/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.registry.lib.util;

import com.google.protobuf.GeneratedMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InvalidStateException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.extension.protobuf.IdentifiableMessage;
import org.openbase.jul.extension.protobuf.container.ProtoBufMessageMap;
import org.openbase.jul.storage.registry.ConsistencyHandler;
import org.openbase.jul.storage.registry.EntryModification;
import rst.domotic.unit.UnitConfigType;
import rst.spatial.PlacementConfigType;

public class LocationUtils {
    public static void validateRootLocation(UnitConfigType.UnitConfig newRootLocation, ProtoBufMessageMap<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder> entryMap, ConsistencyHandler consistencyHandler) throws CouldNotPerformException, EntryModification {
        try {
            boolean modified = false;
            IdentifiableMessage detectedRootLocationConfigEntry = entryMap.get((Comparable)((Object)newRootLocation.getId()));
            UnitConfigType.UnitConfig.Builder detectedRootLocationConfigBuilder = ((UnitConfigType.UnitConfig)detectedRootLocationConfigEntry.getMessage()).toBuilder();
            if (!detectedRootLocationConfigBuilder.getLocationConfig().hasRoot() || !detectedRootLocationConfigBuilder.getLocationConfig().getRoot()) {
                detectedRootLocationConfigBuilder.getLocationConfigBuilder().setRoot(true);
                modified = true;
            }
            if (!detectedRootLocationConfigBuilder.hasPlacementConfig()) {
                detectedRootLocationConfigBuilder.setPlacementConfig(PlacementConfigType.PlacementConfig.newBuilder());
                modified = true;
            }
            if (!detectedRootLocationConfigBuilder.getPlacementConfig().hasLocationId() || !detectedRootLocationConfigBuilder.getPlacementConfig().getLocationId().equals(detectedRootLocationConfigBuilder.getId())) {
                detectedRootLocationConfigBuilder.getPlacementConfigBuilder().setLocationId(detectedRootLocationConfigBuilder.getId());
                modified = true;
            }
            if (modified) {
                throw new EntryModification((Object)detectedRootLocationConfigEntry.setMessage((GeneratedMessage.Builder)detectedRootLocationConfigBuilder), consistencyHandler);
            }
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not validate root location!", (Throwable)ex);
        }
    }

    public static UnitConfigType.UnitConfig getRootLocation(ProtoBufMessageMap<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder> entryMap) throws NotAvailableException, CouldNotPerformException {
        return LocationUtils.getRootLocation(entryMap.getMessages());
    }

    public static UnitConfigType.UnitConfig getRootLocation(List<UnitConfigType.UnitConfig> locationUnitConfigList) throws NotAvailableException, CouldNotPerformException {
        UnitConfigType.UnitConfig rootLocation = null;
        try {
            for (UnitConfigType.UnitConfig locationConfig : locationUnitConfigList) {
                if (!locationConfig.getLocationConfig().hasRoot() || !locationConfig.getLocationConfig().getRoot()) continue;
                if (rootLocation != null) {
                    throw new InvalidStateException("Found more than one [" + rootLocation.getLabel() + "] & [" + locationConfig.getLabel() + "] root locations!");
                }
                rootLocation = locationConfig;
            }
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not lookup root location!", (Throwable)ex);
        }
        if (rootLocation == null) {
            throw new NotAvailableException("root location");
        }
        return rootLocation;
    }

    public static UnitConfigType.UnitConfig detectRootLocation(UnitConfigType.UnitConfig currentLocationConfig, ProtoBufMessageMap<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder> entryMap, ConsistencyHandler consistencyHandler) throws CouldNotPerformException, EntryModification {
        try {
            try {
                return LocationUtils.getRootLocation(entryMap);
            }
            catch (NotAvailableException ex) {
                UnitConfigType.UnitConfig newLocationConfig = LocationUtils.computeNewRootLocation(currentLocationConfig, entryMap);
                LocationUtils.validateRootLocation(newLocationConfig, entryMap, consistencyHandler);
                return newLocationConfig;
            }
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not detect root location!", (Throwable)ex);
        }
    }

    public static UnitConfigType.UnitConfig computeNewRootLocation(UnitConfigType.UnitConfig currentLocationConfig, ProtoBufMessageMap<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder> entryMap) throws CouldNotPerformException {
        try {
            HashMap<String, UnitConfigType.UnitConfig> rootLocationConfigList = new HashMap<String, UnitConfigType.UnitConfig>();
            for (UnitConfigType.UnitConfig locationConfig : entryMap.getMessages()) {
                rootLocationConfigList.put(locationConfig.getId(), locationConfig);
            }
            rootLocationConfigList.put(currentLocationConfig.getId(), currentLocationConfig);
            if (rootLocationConfigList.size() == 1) {
                return (UnitConfigType.UnitConfig)rootLocationConfigList.values().stream().findFirst().get();
            }
            for (UnitConfigType.UnitConfig locationConfig : new ArrayList(rootLocationConfigList.values())) {
                if (!locationConfig.hasPlacementConfig() || !locationConfig.getPlacementConfig().hasLocationId() || locationConfig.getPlacementConfig().getLocationId().isEmpty()) continue;
                if (locationConfig.getPlacementConfig().getLocationId().equals(locationConfig.getId())) {
                    return locationConfig;
                }
                rootLocationConfigList.remove(locationConfig.getId());
            }
            if (rootLocationConfigList.isEmpty()) {
                throw new NotAvailableException("root candidate");
            }
            if (rootLocationConfigList.size() == 1) {
                return (UnitConfigType.UnitConfig)rootLocationConfigList.values().stream().findFirst().get();
            }
            throw new InvalidStateException("To many potential root locations detected!");
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not compute root location!", (Throwable)ex);
        }
    }
}

