/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.authentication.lib.jp;

import java.io.File;
import org.openbase.bco.authentication.lib.jp.JPBCOVarDirectory;
import org.openbase.bco.authentication.lib.jp.JPResetCredentials;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPServiceException;
import org.openbase.jps.exception.JPValidationException;
import org.openbase.jps.preset.AbstractJPDirectory;
import org.openbase.jps.tools.FileHandler;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.slf4j.Logger;

public class JPCredentialsDirectory
extends AbstractJPDirectory {
    public static final String DEFAULT_CREDENTIALS_PATH = "credentials";
    public static final String[] COMMAND_IDENTIFIERS = new String[]{"--cr", "--credentials"};
    public static final FileHandler.ExistenceHandling EXISTENCE_HANDLING = FileHandler.ExistenceHandling.Must;
    public static final FileHandler.AutoMode AUTO_MODE = FileHandler.AutoMode.On;

    public JPCredentialsDirectory() {
        super(COMMAND_IDENTIFIERS, EXISTENCE_HANDLING, AUTO_MODE);
        this.registerDependingProperty(JPBCOVarDirectory.class);
        this.registerDependingProperty(JPResetCredentials.class);
    }

    public File getParentDirectory() throws JPServiceException {
        if (((File)((JPBCOVarDirectory)JPService.getProperty(JPBCOVarDirectory.class)).getValue()).exists() || JPService.testMode()) {
            return (File)((JPBCOVarDirectory)JPService.getProperty(JPBCOVarDirectory.class)).getValue();
        }
        throw new JPServiceException("Could not auto detect bco var path!");
    }

    protected File getPropertyDefaultValue() {
        return new File(DEFAULT_CREDENTIALS_PATH);
    }

    public String getDescription() {
        return "Specifies the credential directory. If not already exist, this credential directory is auto created during startup.";
    }

    public void validate() throws JPValidationException {
        try {
            if (((Boolean)((JPResetCredentials)JPService.getProperty(JPResetCredentials.class)).getValue()).booleanValue()) {
                this.setAutoCreateMode(FileHandler.AutoMode.On);
                this.setExistenceHandling(FileHandler.ExistenceHandling.MustBeNew);
            }
        }
        catch (JPServiceException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not access java property!", (Throwable)ex), (Logger)this.logger);
        }
        super.validate();
    }
}

