/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.authentication.lib.jp;

import java.io.File;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPNotAvailableException;
import org.openbase.jps.exception.JPServiceException;
import org.openbase.jps.preset.AbstractJPDirectory;
import org.openbase.jps.preset.JPLocalUserPrefix;
import org.openbase.jps.preset.JPTmpDirectory;
import org.openbase.jps.tools.FileHandler;
import org.openbase.jul.exception.FatalImplementationErrorException;

public class JPBCOHomeDirectory
extends AbstractJPDirectory {
    public static final String SYSTEM_VARIABLE_BCO_HOME = "BCO_HOME";
    public static final String DEFAULT_PATH = ".config/bco";
    public static final String[] COMMAND_IDENTIFIERS = new String[]{"--bco-home"};
    public static final FileHandler.ExistenceHandling EXISTENCE_HANDLING = FileHandler.ExistenceHandling.Must;
    public static final FileHandler.AutoMode AUTO_MODE = FileHandler.AutoMode.On;

    public JPBCOHomeDirectory() {
        super(COMMAND_IDENTIFIERS, EXISTENCE_HANDLING, AUTO_MODE);
        this.registerDependingProperty(JPTmpDirectory.class);
        this.registerDependingProperty(JPLocalUserPrefix.class);
    }

    public File getParentDirectory() throws JPServiceException {
        return (File)((JPLocalUserPrefix)JPService.getProperty(JPLocalUserPrefix.class)).getValue();
    }

    protected File getPropertyDefaultValue() {
        String systemDefinedHome;
        if (JPService.testMode()) {
            try {
                return (File)((JPTmpDirectory)JPService.getProperty(JPTmpDirectory.class)).getValue();
            }
            catch (JPNotAvailableException ex) {
                new FatalImplementationErrorException("Could not link test tmp directory as bco home path for java tests.", (Object)this, (Throwable)ex);
            }
        }
        if ((systemDefinedHome = System.getenv(SYSTEM_VARIABLE_BCO_HOME)) != null) {
            return new File(systemDefinedHome);
        }
        return new File(DEFAULT_PATH);
    }

    public String getDescription() {
        return "Property can be used to overwrite the bco home path which is mainly used for storing variable runtime data including the registry db.";
    }
}

