/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.authentication.lib.future;

import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Future;
import javax.crypto.BadPaddingException;
import org.openbase.bco.authentication.lib.EncryptionHelper;
import org.openbase.bco.authentication.lib.SessionManager;
import org.openbase.bco.authentication.lib.future.AuthenticatedFuture;
import org.openbase.jul.exception.CouldNotPerformException;
import rst.domotic.authentication.AuthenticatedValueType;
import rst.domotic.authentication.TicketAuthenticatorWrapperType;

public class AuthenticatedValueFuture<RETURN extends GeneratedMessage>
extends AuthenticatedFuture<RETURN, AuthenticatedValueType.AuthenticatedValue> {
    public AuthenticatedValueFuture(Future<AuthenticatedValueType.AuthenticatedValue> internalFuture, Class<RETURN> returnValueClass, TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper ticketAuthenticatorWrapper) {
        super(internalFuture, returnValueClass, ticketAuthenticatorWrapper);
    }

    public AuthenticatedValueFuture(Future<AuthenticatedValueType.AuthenticatedValue> internalFuture, Class<RETURN> returnValueClass, TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper ticketAuthenticatorWrapper, SessionManager sessionManager) {
        super(internalFuture, returnValueClass, ticketAuthenticatorWrapper, sessionManager);
    }

    @Override
    protected TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper getTicketFromInternal(AuthenticatedValueType.AuthenticatedValue internalType) {
        return internalType.getTicketAuthenticatorWrapper();
    }

    @Override
    protected RETURN convertFromInternal(AuthenticatedValueType.AuthenticatedValue authenticatedValue) throws CouldNotPerformException {
        try {
            if (this.getSessionManager().isLoggedIn()) {
                try {
                    return (RETURN)((GeneratedMessage)EncryptionHelper.decryptSymmetric(authenticatedValue.getValue(), this.getSessionManager().getSessionKey(), this.getReturnClass()));
                }
                catch (IOException | BadPaddingException ex) {
                    throw new CouldNotPerformException("Decrypting result of internal future failed!", (Throwable)ex);
                }
            }
            try {
                Method parseFrom = this.getReturnClass().getMethod("parseFrom", ByteString.class);
                return (RETURN)((GeneratedMessage)parseFrom.invoke(null, authenticatedValue.getValue()));
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                throw new CouldNotPerformException("Could not invoke parseFrom method on [" + this.getReturnClass().getSimpleName() + "]", (Throwable)ex);
            }
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("COuld not get return value from internal value", (Throwable)ex);
        }
    }
}

