/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.authentication.lib;

import org.openbase.bco.authentication.lib.AuthenticationRemote;
import org.openbase.jps.core.JPService;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InvalidStateException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedAuthenticationRemote {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachedAuthenticationRemote.class);
    private static AuthenticationRemote authenticationRemote;
    private static boolean shutdown;

    public static synchronized AuthenticationRemote getRemote() throws InterruptedException, NotAvailableException {
        try {
            if (shutdown) {
                throw new InvalidStateException("Remote service is shutting down!");
            }
            if (authenticationRemote == null) {
                try {
                    authenticationRemote = new AuthenticationRemote();
                    authenticationRemote.init();
                    authenticationRemote.activate();
                    authenticationRemote.waitForActivation();
                }
                catch (CouldNotPerformException ex) {
                    if (authenticationRemote != null) {
                        authenticationRemote.shutdown();
                        authenticationRemote = null;
                    }
                    throw (CouldNotPerformException)ExceptionPrinter.printHistoryAndReturnThrowable((Throwable)new CouldNotPerformException("Could not start cached authenticator remote!", (Throwable)ex), (Logger)LOGGER);
                }
            }
            return authenticationRemote;
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("CachedAuthenticatorClientRemote", (Throwable)ex);
        }
    }

    public static void shutdown() {
        if (!shutdown && !JPService.testMode()) {
            LOGGER.warn("This manual authentication remote shutdown is only available during unit tests and not allowed during normal operation!");
            return;
        }
        if (authenticationRemote != null) {
            authenticationRemote.shutdown();
            authenticationRemote = null;
        }
    }

    static {
        shutdown = false;
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            shutdown = true;
            CachedAuthenticationRemote.shutdown();
        }));
    }
}

