/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.authentication.lib;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import javax.crypto.BadPaddingException;
import org.openbase.bco.authentication.lib.EncryptionHelper;
import org.openbase.bco.authentication.lib.exception.SessionExpiredException;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.RejectedException;
import org.openbase.jul.extension.rst.processing.TimestampJavaTimeTransform;
import org.openbase.jul.extension.rst.processing.TimestampProcessor;
import rst.domotic.authentication.AuthenticatorType;
import rst.domotic.authentication.TicketAuthenticatorWrapperType;
import rst.domotic.authentication.TicketSessionKeyWrapperType;
import rst.domotic.authentication.TicketType;
import rst.timing.IntervalType;
import rst.timing.TimestampType;

public class AuthenticationServerHandler {
    public static final long MAX_TIME_DIFF_SERVER_CLIENT = TimeUnit.MINUTES.toNanos(2L);

    public static TicketSessionKeyWrapperType.TicketSessionKeyWrapper handleKDCRequest(String id, byte[] userKey, byte[] clientKey, String clientNetworkAddress, byte[] ticketGrantingServiceSecretKey, long validityTime) throws NotAvailableException, InterruptedException, CouldNotPerformException, IOException {
        byte[] ticketGrantingServiceSessionKey = EncryptionHelper.generateKey();
        TicketType.Ticket.Builder ticketGrantingTicket = TicketType.Ticket.newBuilder();
        ticketGrantingTicket.setClientId(id);
        ticketGrantingTicket.setClientIp(clientNetworkAddress);
        ticketGrantingTicket.setValidityPeriod(AuthenticationServerHandler.getValidityInterval(validityTime));
        ticketGrantingTicket.setSessionKeyBytes(ByteString.copyFrom((byte[])ticketGrantingServiceSessionKey));
        TicketSessionKeyWrapperType.TicketSessionKeyWrapper.Builder ticketSessionKeyWrapper = TicketSessionKeyWrapperType.TicketSessionKeyWrapper.newBuilder();
        ticketSessionKeyWrapper.setTicket(EncryptionHelper.encryptSymmetric((Serializable)ticketGrantingTicket.build(), ticketGrantingServiceSecretKey));
        if (userKey != null) {
            ticketGrantingServiceSessionKey = EncryptionHelper.encrypt((Serializable)ticketGrantingServiceSessionKey, userKey, true);
        }
        if (clientKey != null) {
            ticketGrantingServiceSessionKey = EncryptionHelper.encrypt((Serializable)ticketGrantingServiceSessionKey, clientKey, false);
        }
        ticketSessionKeyWrapper.setSessionKey(ByteString.copyFrom((byte[])ticketGrantingServiceSessionKey));
        return ticketSessionKeyWrapper.build();
    }

    public static TicketSessionKeyWrapperType.TicketSessionKeyWrapper handleTGSRequest(byte[] ticketGrantingServiceSecretKey, byte[] serviceServerSecretKey, TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper wrapper, long validityTime) throws RejectedException, IOException, BadPaddingException {
        TicketType.Ticket ticketGrantingTicket = EncryptionHelper.decryptSymmetric(wrapper.getTicket(), ticketGrantingServiceSecretKey, TicketType.Ticket.class);
        byte[] ticketGrantingServiceSessionKey = ticketGrantingTicket.getSessionKeyBytes().toByteArray();
        AuthenticatorType.Authenticator authenticator = EncryptionHelper.decryptSymmetric(wrapper.getAuthenticator(), ticketGrantingServiceSessionKey, AuthenticatorType.Authenticator.class);
        AuthenticationServerHandler.validateTicket(ticketGrantingTicket, authenticator);
        byte[] serviceServerSessionKey = EncryptionHelper.generateKey();
        TicketType.Ticket.Builder clientServerTicket = ticketGrantingTicket.toBuilder();
        clientServerTicket.setValidityPeriod(AuthenticationServerHandler.getValidityInterval(validityTime));
        clientServerTicket.setSessionKeyBytes(ByteString.copyFrom((byte[])serviceServerSessionKey));
        TicketSessionKeyWrapperType.TicketSessionKeyWrapper.Builder ticketSessionKeyWrapper = TicketSessionKeyWrapperType.TicketSessionKeyWrapper.newBuilder();
        ticketSessionKeyWrapper.setTicket(EncryptionHelper.encryptSymmetric((Serializable)clientServerTicket.build(), serviceServerSecretKey));
        ticketSessionKeyWrapper.setSessionKey(EncryptionHelper.encryptSymmetric((Serializable)serviceServerSessionKey, ticketGrantingServiceSessionKey));
        return ticketSessionKeyWrapper.build();
    }

    public static TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper handleSSRequest(byte[] serviceServerSecretKey, TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper wrapper, long validityTime) throws RejectedException, IOException, BadPaddingException {
        TicketType.Ticket clientServerTicket = EncryptionHelper.decryptSymmetric(wrapper.getTicket(), serviceServerSecretKey, TicketType.Ticket.class);
        AuthenticatorType.Authenticator authenticator = EncryptionHelper.decryptSymmetric(wrapper.getAuthenticator(), clientServerTicket.getSessionKeyBytes().toByteArray(), AuthenticatorType.Authenticator.class);
        AuthenticationServerHandler.validateTicket(clientServerTicket, authenticator);
        TicketType.Ticket.Builder cstb = clientServerTicket.toBuilder();
        cstb.setValidityPeriod(AuthenticationServerHandler.getValidityInterval(validityTime));
        AuthenticatorType.Authenticator.Builder ab = authenticator.toBuilder();
        ab.setTimestamp(ab.getTimestamp().toBuilder().setTime(ab.getTimestamp().getTime() + 1L));
        TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper.Builder ticketAuthenticatorWrapper = wrapper.toBuilder();
        ticketAuthenticatorWrapper.setTicket(EncryptionHelper.encryptSymmetric((Serializable)cstb.build(), serviceServerSecretKey));
        ticketAuthenticatorWrapper.setAuthenticator(EncryptionHelper.encryptSymmetric((Serializable)ab.build(), clientServerTicket.getSessionKeyBytes().toByteArray()));
        return ticketAuthenticatorWrapper.build();
    }

    public static void validateTicket(TicketType.Ticket ticket, AuthenticatorType.Authenticator authenticator) throws RejectedException {
        if (!ticket.hasClientId() || ticket.getClientId().isEmpty()) {
            throw new RejectedException("Ticket does not contain a client id");
        }
        if (!authenticator.hasClientId() || authenticator.getClientId().isEmpty()) {
            throw new RejectedException("Authenticator does not contain a client id");
        }
        if (!authenticator.getClientId().equals(ticket.getClientId())) {
            System.err.println("Received an erroneous request regarding the client id. Expected[" + ticket.getClientId() + "] but was[" + authenticator.getClientId() + "]");
            throw new RejectedException("ClientIds do not match");
        }
        if (!AuthenticationServerHandler.isTimestampInInterval(authenticator.getTimestamp(), ticket.getValidityPeriod())) {
            throw new SessionExpiredException();
        }
        TimestampType.Timestamp currentTime = TimestampProcessor.getCurrentTimestamp();
        if (authenticator.getTimestamp().getTime() < currentTime.getTime() - MAX_TIME_DIFF_SERVER_CLIENT || authenticator.getTimestamp().getTime() > currentTime.getTime() + MAX_TIME_DIFF_SERVER_CLIENT) {
            throw new SessionExpiredException();
        }
    }

    public static boolean isTimestampInInterval(TimestampType.Timestamp timestamp, IntervalType.Interval interval) {
        return timestamp.getTime() >= interval.getBegin().getTime() && timestamp.getTime() <= interval.getEnd().getTime();
    }

    public static IntervalType.Interval getValidityInterval(long validityTime) {
        long currentTime = System.currentTimeMillis();
        IntervalType.Interval.Builder validityInterval = IntervalType.Interval.newBuilder();
        validityInterval.setBegin(TimestampJavaTimeTransform.transform((long)currentTime));
        validityInterval.setEnd(TimestampJavaTimeTransform.transform((long)(currentTime + validityTime)));
        return validityInterval.build();
    }
}

