/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenSecurity;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractPythonCodegen;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonFastAPIServerCodegen
extends AbstractPythonCodegen {
    final ObjectMapper MAPPER = new ObjectMapper();
    final Logger LOGGER = LoggerFactory.getLogger(PythonFastAPIServerCodegen.class);
    protected String sourceFolder;
    private static final String BASE_CLASS_SUFFIX = "base";
    private static final String SERVER_PORT = "serverPort";
    private static final String NAME = "python-fastapi";
    private static final int DEFAULT_SERVER_PORT = 8080;
    private static final String DEFAULT_PACKAGE_NAME = "openapi_server";
    private static final String DEFAULT_SOURCE_FOLDER = "src";
    private static final String DEFAULT_PACKAGE_VERSION = "1.0.0";
    private String implPackage;

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getHelp() {
        return "Generates a Python FastAPI server (beta). Models are defined with the pydantic library";
    }

    public PythonFastAPIServerCodegen() {
        this.modifyFeatureSet(features -> features.includeSecurityFeatures(new SecurityFeature[]{SecurityFeature.OAuth2_AuthorizationCode, SecurityFeature.OAuth2_Password}));
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.BETA).build();
        this.MAPPER.registerModule((Module)new SimpleModule().addKeySerializer(String.class, (JsonSerializer)new SnakeCaseKeySerializer()).addSerializer(Boolean.class, (JsonSerializer)new PythonBooleanSerializer()));
        this.additionalProperties.put(SERVER_PORT, 8080);
        this.additionalProperties.put("baseSuffix", BASE_CLASS_SUFFIX);
        this.additionalProperties.put("sourceFolder", DEFAULT_SOURCE_FOLDER);
        this.additionalProperties.put("packageName", DEFAULT_PACKAGE_NAME);
        this.additionalProperties.put("fastapiImplementationPackage", DEFAULT_PACKAGE_NAME.concat(".impl"));
        this.languageSpecificPrimitives.add("List");
        this.languageSpecificPrimitives.add("Dict");
        this.typeMapping.put("array", "List");
        this.typeMapping.put("map", "Dict");
        this.outputFolder = "generated-code" + File.separator + NAME;
        this.modelTemplateFiles.put("model.mustache", ".py");
        this.apiTemplateFiles.put("api.mustache", ".py");
        this.apiTemplateFiles.put("base_api.mustache", "_".concat(BASE_CLASS_SUFFIX).concat(".py"));
        this.templateDir = NAME;
        this.embeddedTemplateDir = NAME;
        this.apiPackage = "apis";
        this.modelPackage = "models";
        this.testPackage = "tests";
        this.implPackage = "impl";
        this.apiTestTemplateFiles().put("api_test.mustache", ".py");
        this.cliOptions.add(new CliOption("packageName", "python package name (convention: snake_case).").defaultValue(DEFAULT_PACKAGE_NAME));
        this.cliOptions.add(new CliOption("packageVersion", "python package version.").defaultValue(DEFAULT_PACKAGE_VERSION));
        this.cliOptions.add(new CliOption(SERVER_PORT, "TCP port to listen to in app.run").defaultValue(String.valueOf(8080)));
        this.cliOptions.add(new CliOption("sourceFolder", "directory for generated python source code").defaultValue(DEFAULT_SOURCE_FOLDER));
        this.cliOptions.add(new CliOption("fastapiImplementationPackage", "python package name for the implementation code (convention: snake_case).").defaultValue(this.implPackage));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        }
        if (this.additionalProperties.containsKey("sourceFolder")) {
            this.sourceFolder = (String)this.additionalProperties.get("sourceFolder");
        }
        if (this.additionalProperties.containsKey("fastapiImplementationPackage")) {
            this.implPackage = (String)this.additionalProperties.get("fastapiImplementationPackage");
        }
        this.modelPackage = this.packageName + "." + this.modelPackage;
        this.apiPackage = this.packageName + "." + this.apiPackage;
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("openapi.mustache", "", "openapi.yaml"));
        this.supportingFiles.add(new SupportingFile("main.mustache", String.join((CharSequence)File.separator, this.sourceFolder, this.packageName.replace('.', File.separatorChar)), "main.py"));
        this.supportingFiles.add(new SupportingFile("docker-compose.mustache", "", "docker-compose.yaml"));
        this.supportingFiles.add(new SupportingFile("Dockerfile.mustache", "", "Dockerfile"));
        this.supportingFiles.add(new SupportingFile("requirements.mustache", "", "requirements.txt"));
        this.supportingFiles.add(new SupportingFile("security_api.mustache", String.join((CharSequence)File.separator, this.sourceFolder, this.packageName.replace('.', File.separatorChar)), "security_api.py"));
        this.supportingFiles.add(new SupportingFile("extra_models.mustache", org.apache.commons.lang3.StringUtils.substringAfter((String)this.modelFileFolder(), (String)this.outputFolder), "extra_models.py"));
        StringBuilder namespacePackagePath = new StringBuilder(String.join((CharSequence)File.separator, this.sourceFolder, org.apache.commons.lang3.StringUtils.substringBefore((String)this.packageName, (String)".")));
        for (String tmp : org.apache.commons.lang3.StringUtils.split((String)org.apache.commons.lang3.StringUtils.substringAfter((String)this.packageName, (String)"."), (char)'.')) {
            namespacePackagePath.append(File.separator).append(tmp);
            this.supportingFiles.add(new SupportingFile("__init__.mustache", namespacePackagePath.toString(), "__init__.py"));
        }
        this.supportingFiles.add(new SupportingFile("__init__.mustache", org.apache.commons.lang3.StringUtils.substringAfter((String)this.modelFileFolder(), (String)this.outputFolder), "__init__.py"));
        this.supportingFiles.add(new SupportingFile("__init__.mustache", org.apache.commons.lang3.StringUtils.substringAfter((String)this.apiFileFolder(), (String)this.outputFolder), "__init__.py"));
        this.supportingFiles.add(new SupportingFile("__init__.mustache", org.apache.commons.lang3.StringUtils.substringAfter((String)this.apiImplFileFolder(), (String)this.outputFolder), "__init__.py"));
        this.supportingFiles.add(new SupportingFile("conftest.mustache", this.testPackage.replace('.', File.separatorChar), "conftest.py"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("pyproject_toml.mustache", "", "pyproject.toml"));
        this.supportingFiles.add(new SupportingFile("setup_cfg.mustache", "", "setup.cfg"));
        this.supportingFiles.add(new SupportingFile(".flake8.mustache", "", ".flake8"));
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String toModelImport(String name) {
        Object modelImport;
        if (org.apache.commons.lang3.StringUtils.startsWithAny((CharSequence)name, (CharSequence[])new CharSequence[]{"import", "from"})) {
            modelImport = name;
        } else {
            modelImport = "from ";
            if (!"".equals(this.modelPackage())) {
                modelImport = (String)modelImport + this.modelPackage() + ".";
            }
            modelImport = (String)modelImport + this.toModelFilename(name) + " import " + name;
        }
        return modelImport;
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            Schema<?> inner = ModelUtils.getSchemaItems(p);
            return this.getSchemaType(p) + "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            return this.getSchemaType(p) + "[str, " + this.getTypeDeclaration(inner) + "]";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        OperationMap operations = objs.getOperations();
        HashSet<String> securityImports = new HashSet<String>();
        if (operations != null) {
            List<CodegenOperation> ops = operations.getOperation();
            for (CodegenOperation operation : ops) {
                List<CodegenSecurity> securityMethods;
                List<CodegenResponse> responses = operation.responses;
                if (responses != null) {
                    for (CodegenResponse resp : responses) {
                        if (!"0".equals(resp.code)) continue;
                        resp.code = "200";
                    }
                }
                if ((securityMethods = operation.authMethods) != null) {
                    for (CodegenSecurity codegenSecurity : securityMethods) {
                        securityImports.add(codegenSecurity.name);
                    }
                }
                if (operation.requestBodyExamples == null) continue;
                for (Map map : operation.requestBodyExamples) {
                    if (map.get("contentType") == null || !((String)map.get("contentType")).equals("application/json")) continue;
                    try {
                        Map result = (Map)this.MAPPER.readValue((String)map.get("example"), (TypeReference)new TypeReference<Map<String, Object>>(){});
                        operation.bodyParam.example = this.MAPPER.writeValueAsString((Object)result);
                    }
                    catch (IOException e) {
                        operation.bodyParam.example = (String)map.get("example");
                    }
                }
            }
        }
        objs.put("securityImports", new ArrayList(securityImports));
        return objs;
    }

    @Override
    public Map<String, ModelsMap> postProcessAllModels(Map<String, ModelsMap> objs) {
        Map<String, ModelsMap> result = super.postProcessAllModels(objs);
        for (Map.Entry<String, ModelsMap> entry : result.entrySet()) {
            for (ModelMap mo : entry.getValue().getModels()) {
                CodegenModel cm = mo.getModel();
                mo.put("pyImports", this.toPyImports(cm, cm.imports));
            }
        }
        return result;
    }

    private List<Map<String, String>> toPyImports(CodegenModel cm, Set<String> imports) {
        ArrayList<Map<String, String>> pyImports = new ArrayList<Map<String, String>>();
        for (String im : imports) {
            if (im.equals(cm.classname)) continue;
            HashMap<String, String> pyImport = new HashMap<String, String>();
            pyImport.put("import", this.toModelImport(im));
            pyImports.add(pyImport);
        }
        return pyImports;
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        this.generateYAMLSpecFile(objs);
        return objs;
    }

    @Override
    public String apiFileFolder() {
        return String.join((CharSequence)File.separator, this.outputFolder, this.sourceFolder, this.apiPackage().replace('.', File.separatorChar));
    }

    public String apiImplFileFolder() {
        return String.join((CharSequence)File.separator, this.outputFolder, this.sourceFolder, this.implPackage.replace('.', File.separatorChar));
    }

    @Override
    public String modelFileFolder() {
        return String.join((CharSequence)File.separator, this.outputFolder, this.sourceFolder, this.modelPackage().replace('.', File.separatorChar));
    }

    @Override
    public void postProcess() {
        System.out.println("################################################################################");
        System.out.println("# Thanks for using OpenAPI Generator.                                          #");
        System.out.println("# Please consider donation to help us maintain this project \ud83d\ude4f                 #");
        System.out.println("# https://opencollective.com/openapi_generator/donate                          #");
        System.out.println("#                                                                              #");
        System.out.println("# This generator's contributed by Nikita Vakula (https://github.com/krjakbrjak)#");
        System.out.println("# Please support his work directly via https://paypal.me/krjakbrjak  \ud83d\ude4f        #");
        System.out.println("################################################################################");
    }

    @Override
    public String generatorLanguageVersion() {
        return "3.7";
    }

    private static class PythonBooleanSerializer
    extends JsonSerializer<Boolean> {
        private PythonBooleanSerializer() {
        }

        public void serialize(Boolean value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeNumber(value != false ? 1 : 0);
        }
    }

    private static class SnakeCaseKeySerializer
    extends JsonSerializer<String> {
        private SnakeCaseKeySerializer() {
        }

        public void serialize(String value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeFieldName(StringUtils.underscore(value));
        }
    }
}

