/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.collect.ImmutableMap;
import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.openapitools.codegen.CodegenComposedSchemas;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenConstants;
import org.openapitools.codegen.CodegenDiscriminator;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.GeneratorLanguage;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.templating.mustache.CamelCaseLambda;
import org.openapitools.codegen.templating.mustache.CopyLambda;
import org.openapitools.codegen.templating.mustache.FirstLambda;
import org.openapitools.codegen.templating.mustache.IndentedLambda;
import org.openapitools.codegen.templating.mustache.JoinWithCommaLambda;
import org.openapitools.codegen.templating.mustache.OptionalParameterLambda;
import org.openapitools.codegen.templating.mustache.PasteLambda;
import org.openapitools.codegen.templating.mustache.RequiredParameterLambda;
import org.openapitools.codegen.templating.mustache.TrimLineBreaksLambda;
import org.openapitools.codegen.templating.mustache.TrimTrailingWhiteSpaceLambda;
import org.openapitools.codegen.utils.CamelizeOption;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCSharpCodegen
extends DefaultCodegen
implements CodegenConfig {
    protected boolean optionalAssemblyInfoFlag = true;
    protected boolean optionalEmitDefaultValuesFlag = false;
    protected boolean conditionalSerialization = false;
    protected boolean optionalProjectFileFlag = true;
    protected boolean optionalMethodArgumentFlag = true;
    protected boolean useDateTimeOffsetFlag = false;
    protected boolean useCollection = false;
    protected boolean returnICollection = false;
    protected boolean netCoreProjectFileFlag = false;
    protected boolean nullReferenceTypesFlag = false;
    protected boolean useSourceGeneration = false;
    protected String modelPropertyNaming = CodegenConstants.MODEL_PROPERTY_NAMING_TYPE.PascalCase.name();
    protected String licenseUrl = "http://localhost";
    protected String licenseName = "NoLicense";
    protected String packageVersion = "1.0.0";
    protected String packageName = "Org.OpenAPITools";
    protected String packageTitle = "OpenAPI Library";
    protected String packageProductName = "OpenAPILibrary";
    protected String packageDescription = "A library generated from a OpenAPI doc";
    protected String packageCompany = "OpenAPI";
    protected String packageCopyright = "No Copyright";
    protected String packageAuthors = "OpenAPI";
    public static final String DATE_FORMAT = "dateFormat";
    protected String dateFormat = "yyyy'-'MM'-'dd";
    public static final String DATETIME_FORMAT = "dateTimeFormat";
    protected String dateTimeFormat = "yyyy'-'MM'-'dd'T'HH':'mm':'ss'.'fffffffK";
    protected String interfacePrefix = "I";
    protected String enumNameSuffix = "Enum";
    protected String enumValueSuffix = "Enum";
    protected String sourceFolder = "src";
    protected String invalidNamePrefix = "var";
    protected CodegenConstants.ENUM_PROPERTY_NAMING_TYPE enumPropertyNaming = CodegenConstants.ENUM_PROPERTY_NAMING_TYPE.PascalCase;
    protected String testFolder = this.sourceFolder;
    protected Set<String> collectionTypes;
    protected Set<String> mapTypes;
    protected boolean supportNullable = Boolean.FALSE;
    protected Boolean zeroBasedEnums = null;
    protected static final String zeroBasedEnumVendorExtension = "x-zero-based-enum";
    private final Logger LOGGER = LoggerFactory.getLogger(AbstractCSharpCodegen.class);
    protected Set<String> propertySpecialKeywords = new HashSet<String>(Arrays.asList("ToString", "ToJson", "GetHashCode", "Equals", "ShouldSerializeToString"));
    private Map<String, String> schemaKeyToModelNameCache = new HashMap<String, String>();

    public AbstractCSharpCodegen() {
        this.supportsInheritance = true;
        this.importMapping.clear();
        this.outputFolder = "generated-code" + File.separator + this.getName();
        this.embeddedTemplateDir = this.templateDir = this.getName();
        this.collectionTypes = new HashSet<String>(Arrays.asList("IList", "List", "ICollection", "Collection", "IEnumerable"));
        this.mapTypes = new HashSet<String>(Arrays.asList("IDictionary", "Dictionary"));
        this.reservedWords.addAll(Arrays.asList("Client", "client", "parameter", "Configuration", "Version", "Environment", "TimeZone", "OperatingSystem", "localVarPath", "localVarPathParams", "localVarQueryParams", "localVarHeaderParams", "localVarFormParams", "localVarFileParams", "localVarStatusCode", "localVarResponse", "localVarPostBody", "localVarHttpHeaderAccepts", "localVarHttpHeaderAccept", "localVarHttpContentTypes", "localVarHttpContentType", "localVarStatusCode", "abstract", "as", "base", "bool", "break", "byte", "case", "catch", "char", "checked", "class", "const", "continue", "decimal", "default", "delegate", "do", "double", "else", "enum", "event", "explicit", "extern", "false", "finally", "fixed", "float", "for", "foreach", "goto", "if", "implicit", "in", "int", "interface", "internal", "is", "lock", "long", "namespace", "new", "null", "object", "operator", "out", "override", "params", "private", "protected", "public", "readonly", "ref", "return", "sbyte", "sealed", "short", "sizeof", "stackalloc", "static", "string", "struct", "switch", "system", "this", "throw", "true", "try", "typeof", "uint", "ulong", "unchecked", "unsafe", "ushort", "using", "virtual", "void", "volatile", "while"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("String", "string", "bool?", "bool", "double?", "double", "decimal?", "decimal", "int?", "int", "uint", "uint?", "long?", "long", "ulong", "ulong?", "float?", "float", "byte[]", "ICollection", "Collection", "List", "Dictionary", "DateTime?", "DateTime", "DateTimeOffset?", "DateTimeOffset", "Boolean", "Double", "Decimal", "Int32", "Int64", "Float", "Guid?", "Guid", "System.IO.Stream", "Object"));
        this.instantiationTypes.put("array", "List");
        this.instantiationTypes.put("list", "List");
        this.instantiationTypes.put("map", "Dictionary");
        this.setSortParamsByRequiredFlag(true);
    }

    public void setReturnICollection(boolean returnICollection) {
        this.returnICollection = returnICollection;
    }

    public void setUseCollection(boolean useCollection) {
        this.useCollection = useCollection;
        if (useCollection) {
            this.instantiationTypes.put("array", "Collection");
            this.instantiationTypes.put("list", "Collection");
        }
        this.setTypeMapping();
    }

    public void setOptionalMethodArgumentFlag(boolean flag) {
        this.optionalMethodArgumentFlag = flag;
    }

    public void setNetCoreProjectFileFlag(boolean flag) {
        this.netCoreProjectFileFlag = flag;
    }

    public void useDateTimeOffset(boolean flag) {
        this.useDateTimeOffsetFlag = flag;
        this.setTypeMapping();
    }

    @Override
    public void processOpts() {
        String zeroBasedEnums;
        super.processOpts();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)System.getenv("CSHARP_POST_PROCESS_FILE"))) {
            this.LOGGER.info("Environment variable CSHARP_POST_PROCESS_FILE not defined so the C# code may not be properly formatted by uncrustify (0.66 or later) or other code formatter. To define it, try `export CSHARP_POST_PROCESS_FILE=\"/usr/local/bin/uncrustify --no-backup\" && export UNCRUSTIFY_CONFIG=/path/to/uncrustify-rules.cfg` (Linux/Mac). Note: replace /path/to with the location of uncrustify-rules.cfg");
            this.LOGGER.info("NOTE: To enable file post-processing, 'enablePostProcessFile' must be set to `true` (--enable-post-process-file for CLI).");
        }
        if (this.additionalProperties.containsKey("licenseUrl")) {
            this.setLicenseUrl((String)this.additionalProperties.get("licenseUrl"));
        } else {
            this.additionalProperties.put("licenseUrl", this.licenseUrl);
        }
        if (this.additionalProperties.containsKey("licenseName")) {
            this.setLicenseName((String)this.additionalProperties.get("licenseName"));
        } else {
            this.additionalProperties.put("licenseName", this.licenseName);
        }
        if (this.additionalProperties.containsKey("packageVersion")) {
            this.setPackageVersion((String)this.additionalProperties.get("packageVersion"));
        } else {
            this.additionalProperties.put("packageVersion", this.packageVersion);
        }
        if (this.additionalProperties.containsKey("sourceFolder")) {
            this.setSourceFolder((String)this.additionalProperties.get("sourceFolder"));
            this.setTestFolder((String)this.additionalProperties.get("sourceFolder"));
        } else {
            this.additionalProperties.put("sourceFolder", this.sourceFolder);
        }
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        } else {
            this.additionalProperties.put("packageName", this.packageName);
        }
        if (this.additionalProperties.containsKey("invokerPackage")) {
            this.LOGGER.warn(String.format(Locale.ROOT, "%s is not used by C# generators. Please use %s", "invokerPackage", "packageName"));
        }
        if (this.additionalProperties.containsKey("packageTitle")) {
            this.setPackageTitle((String)this.additionalProperties.get("packageTitle"));
        } else {
            this.additionalProperties.put("packageTitle", this.packageTitle);
        }
        if (this.additionalProperties.containsKey("packageProductName")) {
            this.setPackageProductName((String)this.additionalProperties.get("packageProductName"));
        } else {
            this.additionalProperties.put("packageProductName", this.packageProductName);
        }
        if (this.additionalProperties.containsKey(DATE_FORMAT)) {
            this.setDateFormat((String)this.additionalProperties.get(DATE_FORMAT));
        } else {
            this.additionalProperties.put(DATE_FORMAT, this.dateFormat);
        }
        if (this.additionalProperties.containsKey(DATETIME_FORMAT)) {
            this.setDateTimeFormat((String)this.additionalProperties.get(DATETIME_FORMAT));
        } else {
            this.additionalProperties.put(DATETIME_FORMAT, this.dateTimeFormat);
        }
        if (this.additionalProperties.containsKey("packageDescription")) {
            this.setPackageDescription((String)this.additionalProperties.get("packageDescription"));
        } else {
            this.additionalProperties.put("packageDescription", this.packageDescription);
        }
        if (this.additionalProperties.containsKey("packageCompany")) {
            this.setPackageCompany((String)this.additionalProperties.get("packageCompany"));
        } else {
            this.additionalProperties.put("packageCompany", this.packageCompany);
        }
        if (this.additionalProperties.containsKey("packageCopyright")) {
            this.setPackageCopyright((String)this.additionalProperties.get("packageCopyright"));
        } else {
            this.additionalProperties.put("packageCopyright", this.packageCopyright);
        }
        if (this.additionalProperties.containsKey("packageAuthors")) {
            this.setPackageAuthors((String)this.additionalProperties.get("packageAuthors"));
        } else {
            this.additionalProperties.put("packageAuthors", this.packageAuthors);
        }
        if (this.additionalProperties.containsKey("useDateTimeOffset")) {
            this.useDateTimeOffset(this.convertPropertyToBooleanAndWriteBack("useDateTimeOffset"));
        } else {
            this.additionalProperties.put("useDateTimeOffset", this.useDateTimeOffsetFlag);
        }
        if (this.additionalProperties.containsKey("useCollection")) {
            this.setUseCollection(this.convertPropertyToBooleanAndWriteBack("useCollection"));
        } else {
            this.additionalProperties.put("useCollection", this.useCollection);
        }
        if (this.additionalProperties.containsKey("returnICollection")) {
            this.setReturnICollection(this.convertPropertyToBooleanAndWriteBack("returnICollection"));
        } else {
            this.additionalProperties.put("returnICollection", this.returnICollection);
        }
        if (this.additionalProperties.containsKey("netCoreProjectFile")) {
            this.setNetCoreProjectFileFlag(this.convertPropertyToBooleanAndWriteBack("netCoreProjectFile"));
        } else {
            this.additionalProperties.put("netCoreProjectFile", this.netCoreProjectFileFlag);
        }
        if (this.additionalProperties.containsKey("nullableReferenceTypes")) {
            this.setNullableReferenceTypes(this.convertPropertyToBooleanAndWriteBack("nullableReferenceTypes"));
        }
        if (this.additionalProperties.containsKey(zeroBasedEnums = "zeroBasedEnums")) {
            this.setZeroBasedEnums(this.convertPropertyToBooleanAndWriteBack(zeroBasedEnums));
        }
        if (this.additionalProperties.containsKey("interfacePrefix")) {
            String useInterfacePrefix = this.additionalProperties.get("interfacePrefix").toString();
            if ("false".equals(useInterfacePrefix.toLowerCase(Locale.ROOT))) {
                this.setInterfacePrefix("");
            } else if (!"true".equals(useInterfacePrefix.toLowerCase(Locale.ROOT))) {
                this.setInterfacePrefix(this.sanitizeName(useInterfacePrefix));
            }
        }
        if (this.additionalProperties().containsKey("enumNameSuffix")) {
            this.setEnumNameSuffix(this.additionalProperties.get("enumNameSuffix").toString());
        }
        if (this.additionalProperties().containsKey("enumValueSuffix")) {
            this.setEnumValueSuffix(this.additionalProperties.get("enumValueSuffix").toString());
        }
        if (this.additionalProperties.containsKey("enumPropertyNaming")) {
            this.setEnumPropertyNaming((String)this.additionalProperties.get("enumPropertyNaming"));
        }
        this.additionalProperties.put("interfacePrefix", this.interfacePrefix);
        this.additionalProperties.put("lambdaCref", new Mustache.Lambda(){

            public void execute(Template.Fragment fragment, Writer writer) throws IOException {
                String content = fragment.execute();
                content = content.trim().replace("<", "{");
                content = content.replace(">", "}");
                content = content.replace("{string}", "{String}");
                writer.write(content);
            }
        });
        this.setTypeMapping();
    }

    @Override
    protected ImmutableMap.Builder<String, Mustache.Lambda> addMustacheLambdas() {
        CopyLambda copyLambda = new CopyLambda();
        return super.addMustacheLambdas().put((Object)"camelcase_param", (Object)new CamelCaseLambda().generator(this).escapeAsParamName(true)).put((Object)"required", (Object)new RequiredParameterLambda()).put((Object)"optional", (Object)new OptionalParameterLambda().generator(this)).put((Object)"joinWithComma", (Object)new JoinWithCommaLambda()).put((Object)"joinWithAmpersand", (Object)new JoinWithCommaLambda(true, "  ", " && ")).put((Object)"joinLinesWithComma", (Object)new JoinWithCommaLambda(false, "\n", ",\n")).put((Object)"joinConditions", (Object)new JoinWithCommaLambda(true, "  ", " && ")).put((Object)"trimLineBreaks", (Object)new TrimLineBreaksLambda()).put((Object)"trimTrailingWithNewLine", (Object)new TrimTrailingWhiteSpaceLambda(true)).put((Object)"trimTrailing", (Object)new TrimTrailingWhiteSpaceLambda(false)).put((Object)"first", (Object)new FirstLambda("  ")).put((Object)"firstDot", (Object)new FirstLambda("\\.")).put((Object)"indent1", (Object)new IndentedLambda(4, " ", false, true)).put((Object)"indent3", (Object)new IndentedLambda(12, " ", false, true)).put((Object)"indent4", (Object)new IndentedLambda(16, " ", false, true)).put((Object)"copy", (Object)copyLambda).put((Object)"paste", (Object)new PasteLambda(copyLambda, true, true, true, false)).put((Object)"pasteOnce", (Object)new PasteLambda(copyLambda, true, true, true, true)).put((Object)"pasteLine", (Object)new PasteLambda(copyLambda, true, true, false, false));
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        if (property.isInnerEnum && property.items != null) {
            property.dataType = property.datatypeWithEnum = property.datatypeWithEnum.replace(property.items.datatypeWithEnum, model.classname + "." + property.items.datatypeWithEnum);
        }
        if (property.isEnum) {
            if (!property.vendorExtensions.containsKey(zeroBasedEnumVendorExtension)) {
                if (Boolean.TRUE.equals(this.zeroBasedEnums)) {
                    property.vendorExtensions.put(zeroBasedEnumVendorExtension, true);
                } else if (!Boolean.FALSE.equals(this.zeroBasedEnums) && property.allowableValues.containsKey("values")) {
                    List allowableValues = (List)property.allowableValues.get("values");
                    boolean isZeroBased = String.valueOf(allowableValues.get(0)).toLowerCase(Locale.ROOT).equals("unknown");
                    property.vendorExtensions.put(zeroBasedEnumVendorExtension, isZeroBased);
                }
            }
        }
        if (property.isMap || property.isContainer) {
            property.isEnum = false;
            property.isInnerEnum = false;
            property.isString = false;
        }
    }

    @Override
    public ModelsMap postProcessModels(ModelsMap objs) {
        for (ModelMap mo : objs.getModels()) {
            CodegenModel cm = mo.getModel();
            if (cm.getComposedSchemas() != null) {
                List<CodegenProperty> anyOf;
                List<CodegenProperty> oneOf = cm.getComposedSchemas().getOneOf();
                if (oneOf != null) {
                    HashSet<String> dataTypeSet = new HashSet<String>();
                    for (CodegenProperty oneOfProperty : oneOf) {
                        if (dataTypeSet.contains(oneOfProperty.dataType)) {
                            oneOfProperty.vendorExtensions.putIfAbsent("x-composed-data-type", true);
                            continue;
                        }
                        dataTypeSet.add(oneOfProperty.dataType);
                    }
                }
                if ((anyOf = cm.getComposedSchemas().getAnyOf()) != null) {
                    HashSet<String> dataTypeSet = new HashSet<String>();
                    for (CodegenProperty anyOfProperty : anyOf) {
                        if (dataTypeSet.contains(anyOfProperty.dataType)) {
                            anyOfProperty.vendorExtensions.putIfAbsent("x-composed-data-type", true);
                            continue;
                        }
                        dataTypeSet.add(anyOfProperty.dataType);
                    }
                }
            }
            if (!cm.isEnum) continue;
            if (cm.vendorExtensions.containsKey(zeroBasedEnumVendorExtension)) continue;
            if (Boolean.TRUE.equals(this.zeroBasedEnums)) {
                cm.vendorExtensions.put(zeroBasedEnumVendorExtension, true);
                continue;
            }
            if (Boolean.FALSE.equals(this.zeroBasedEnums) || !cm.allowableValues.containsKey("values")) continue;
            List allowableValues = (List)cm.allowableValues.get("values");
            boolean isZeroBased = String.valueOf(allowableValues.get(0)).toLowerCase(Locale.ROOT).equals("unknown");
            cm.vendorExtensions.put(zeroBasedEnumVendorExtension, isZeroBased);
        }
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public Map<String, ModelsMap> postProcessAllModels(Map<String, ModelsMap> objs) {
        CodegenModel model;
        Map<String, ModelsMap> processed = super.postProcessAllModels(objs);
        HashMap<String, CodegenModel> enumRefs = new HashMap<String, CodegenModel>();
        for (Map.Entry<String, ModelsMap> entry : processed.entrySet()) {
            model = ModelUtils.getModelByName(entry.getKey(), processed);
            model.setHasDiscriminatorWithNonEmptyMapping((model.anyOf != null && model.anyOf.size() > 0 || model.oneOf != null && model.oneOf.size() > 0) && model.discriminator != null && model.discriminator.getMappedModels() != null && model.discriminator.getMappedModels().size() > 0);
            if (!model.isEnum) continue;
            enumRefs.put(model.getClassname(), model);
        }
        for (Map.Entry<String, ModelsMap> entry : objs.entrySet()) {
            model = ModelUtils.getModelByName(entry.getKey(), objs);
            model.vendorExtensions.put("x-model-is-mutatable", this.modelIsMutatable(model, null));
            CodegenComposedSchemas composedSchemas = model.getComposedSchemas();
            if (composedSchemas != null) {
                List<CodegenProperty> list;
                List<CodegenProperty> anyOf;
                List<CodegenProperty> allOf = composedSchemas.getAllOf();
                if (allOf != null) {
                    for (CodegenProperty codegenProperty : allOf) {
                        codegenProperty.name = this.patchPropertyName(model, codegenProperty.baseType);
                        this.patchPropertyVendorExtensions(codegenProperty);
                    }
                }
                if ((anyOf = composedSchemas.getAnyOf()) != null) {
                    this.removePropertiesDeclaredInComposedTypes(objs, model, anyOf);
                    for (CodegenProperty property2 : anyOf) {
                        property2.name = this.patchPropertyName(model, property2.baseType);
                        property2.isNullable = true;
                        this.patchPropertyVendorExtensions(property2);
                    }
                }
                if ((list = composedSchemas.getOneOf()) != null) {
                    this.removePropertiesDeclaredInComposedTypes(objs, model, list);
                    for (CodegenProperty property : list) {
                        property.name = this.patchPropertyName(model, property.baseType);
                        property.isNullable = true;
                        this.patchPropertyVendorExtensions(property);
                    }
                }
            }
            for (CodegenProperty property : model.allVars) {
                this.patchProperty(enumRefs, model, property);
            }
            for (CodegenProperty property : model.vars) {
                this.patchProperty(enumRefs, model, property);
            }
            for (CodegenProperty property : model.readWriteVars) {
                this.patchProperty(enumRefs, model, property);
            }
            for (CodegenProperty property : model.optionalVars) {
                this.patchProperty(enumRefs, model, property);
            }
            for (CodegenProperty property : model.parentVars) {
                this.patchProperty(enumRefs, model, property);
            }
            for (CodegenProperty property : model.requiredVars) {
                this.patchProperty(enumRefs, model, property);
            }
            for (CodegenProperty property : model.readOnlyVars) {
                this.patchProperty(enumRefs, model, property);
            }
            for (CodegenProperty property : model.nonNullableVars) {
                this.patchProperty(enumRefs, model, property);
            }
        }
        return processed;
    }

    private boolean modelIsMutatable(CodegenModel model, Set<String> processed) {
        Boolean isMutatable;
        if (processed == null) {
            processed = new HashSet<String>();
        }
        if (!(isMutatable = Boolean.valueOf(model.allVars.stream().anyMatch(v -> !v.isReadOnly))).booleanValue() && !processed.contains(model.classname) && model.getDiscriminator() != null && model.getDiscriminator().getMappedModels() != null) {
            processed.add(model.classname);
            for (CodegenDiscriminator.MappedModel mappedModel : model.getDiscriminator().getMappedModels()) {
                isMutatable = this.modelIsMutatable(model, processed);
            }
        }
        return isMutatable;
    }

    protected void removePropertiesDeclaredInComposedTypes(Map<String, ModelsMap> objs, CodegenModel model, List<CodegenProperty> composedProperties) {
    }

    private String patchPropertyName(CodegenModel model, String value) {
        String tmpPropertyName = this.escapeReservedWord(model, (String)value);
        if (!((String)value).equals(tmpPropertyName) || ((String)value).startsWith(this.invalidNamePrefix)) {
            value = tmpPropertyName;
            String firstCharacter = ((String)value).substring(0, 1);
            value = ((String)value).substring(1);
            value = firstCharacter.toUpperCase(Locale.ROOT) + (String)value;
        }
        return value;
    }

    private void patchPropertyVendorExtensions(CodegenProperty property) {
        Boolean isValueType = this.isValueType(property);
        property.vendorExtensions.put("x-is-value-type", isValueType);
        property.vendorExtensions.put("x-is-reference-type", isValueType == false);
        property.vendorExtensions.put("x-is-nullable-type", this.getNullableReferencesTypes() || isValueType != false);
    }

    protected void patchProperty(Map<String, CodegenModel> enumRefs, CodegenModel model, CodegenProperty property) {
        if (enumRefs.containsKey(property.dataType)) {
            CodegenModel refModel = enumRefs.get(property.dataType);
            property.allowableValues = refModel.allowableValues;
            property.isEnum = true;
            property.isPrimitiveType = true;
        }
        this.patchPropertyVendorExtensions(property);
        String tmpPropertyName = this.escapeReservedWord(model, property.name);
        property.name = this.patchPropertyName(model, property.name);
        String[] nestedTypes = new String[]{"List", "Collection", "ICollection", "Dictionary"};
        Arrays.stream(nestedTypes).forEach(nestedType -> {
            if (property.datatypeWithEnum.contains(", " + nestedType + ">") && property.items != null) {
                property.dataType = property.datatypeWithEnum = property.datatypeWithEnum.replace(", " + nestedType + ">", ", " + property.items.datatypeWithEnum + ">");
            }
            if (property.datatypeWithEnum.contains("<" + nestedType + ">") && property.items != null) {
                property.dataType = property.datatypeWithEnum = property.datatypeWithEnum.replace("<" + nestedType + ">", "<" + property.items.datatypeWithEnum + ">");
            }
        });
        if (property.datatypeWithEnum.equals("decimal")) {
            property.isDecimal = true;
        }
    }

    @Override
    protected List<Map<String, Object>> buildEnumVars(List<Object> values, String dataType) {
        List<Map<String, Object>> enumVars = super.buildEnumVars(values, dataType);
        if ("string?".equals(dataType)) {
            enumVars.forEach(enumVar -> enumVar.put("isString", true));
        }
        return enumVars;
    }

    @Override
    public void updateCodegenPropertyEnum(CodegenProperty var) {
        if (var.vendorExtensions == null) {
            var.vendorExtensions = new HashMap<String, Object>();
        }
        super.updateCodegenPropertyEnum(var);
        if (var.isEnum) {
            if ("byte".equals(var.dataFormat)) {
                var.vendorExtensions.put("x-enum-byte", true);
                var.isString = false;
                var.isLong = false;
                var.isInteger = false;
            } else if ("int".equals(var.dataType) || "int32".equals(var.dataFormat)) {
                var.isInteger = true;
                var.isString = false;
                var.isLong = false;
            } else if ("int64".equals(var.dataFormat)) {
                var.isLong = true;
                var.isString = false;
                var.isInteger = false;
            } else {
                var.isString = true;
                var.isInteger = false;
                var.isLong = false;
            }
        }
    }

    private void postProcessResponseCode(CodegenResponse response, String status, Set<String> httpStatusesWithReturn) {
        response.vendorExtensions.put("x-http-status", status);
        if (response.dataType != null) {
            httpStatusesWithReturn.add(status);
        }
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        OperationMap operations;
        super.postProcessOperationsWithModels(objs, allModels);
        HashSet<String> httpStatusesWithReturn = this.additionalProperties.get("x-http-statuses-with-return") instanceof Set ? (Set)this.additionalProperties.get("x-http-statuses-with-return") : new HashSet<String>();
        this.additionalProperties.put("x-http-statuses-with-return", httpStatusesWithReturn);
        if (objs != null && (operations = objs.getOperations()) != null) {
            List<CodegenOperation> ops = operations.getOperation();
            for (CodegenOperation operation : ops) {
                if (operation.responses != null) {
                    block126: for (CodegenResponse codegenResponse : operation.responses) {
                        String code;
                        if (codegenResponse.returnProperty != null) {
                            Boolean isValueType = this.isValueType(codegenResponse.returnProperty);
                            codegenResponse.vendorExtensions.put("x-is-value-type", isValueType);
                            codegenResponse.vendorExtensions.put("x-is-reference-type", isValueType == false);
                        }
                        switch (code = codegenResponse.code.toLowerCase(Locale.ROOT)) {
                            case "default": 
                            case "0": {
                                this.postProcessResponseCode(codegenResponse, "Default", httpStatusesWithReturn);
                                codegenResponse.vendorExtensions.put("x-http-status-is-default", true);
                                if (operation.responses.stream().count() != 1L) continue block126;
                                codegenResponse.vendorExtensions.put("x-only-default", true);
                                continue block126;
                            }
                            case "100": {
                                this.postProcessResponseCode(codegenResponse, "Continue", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "101": {
                                this.postProcessResponseCode(codegenResponse, "SwitchingProtocols", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "102": {
                                this.postProcessResponseCode(codegenResponse, "Processing", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "103": {
                                this.postProcessResponseCode(codegenResponse, "EarlyHints", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "200": {
                                this.postProcessResponseCode(codegenResponse, "Ok", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "201": {
                                this.postProcessResponseCode(codegenResponse, "Created", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "202": {
                                this.postProcessResponseCode(codegenResponse, "Accepted", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "203": {
                                this.postProcessResponseCode(codegenResponse, "NonAuthoritativeInformation", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "204": {
                                this.postProcessResponseCode(codegenResponse, "NoContent", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "205": {
                                this.postProcessResponseCode(codegenResponse, "ResetContent", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "206": {
                                this.postProcessResponseCode(codegenResponse, "PartialContent", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "207": {
                                this.postProcessResponseCode(codegenResponse, "MultiStatus", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "208": {
                                this.postProcessResponseCode(codegenResponse, "AlreadyImported", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "226": {
                                this.postProcessResponseCode(codegenResponse, "IMUsed", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "300": {
                                this.postProcessResponseCode(codegenResponse, "MultipleChoices", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "301": {
                                this.postProcessResponseCode(codegenResponse, "MovedPermanently", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "302": {
                                this.postProcessResponseCode(codegenResponse, "Found", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "303": {
                                this.postProcessResponseCode(codegenResponse, "SeeOther", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "304": {
                                this.postProcessResponseCode(codegenResponse, "NotModified", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "307": {
                                this.postProcessResponseCode(codegenResponse, "TemporaryRedirect", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "308": {
                                this.postProcessResponseCode(codegenResponse, "PermanentRedirect", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "400": {
                                this.postProcessResponseCode(codegenResponse, "BadRequest", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "401": {
                                this.postProcessResponseCode(codegenResponse, "Unauthorized", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "402": {
                                this.postProcessResponseCode(codegenResponse, "PaymentRequired", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "403": {
                                this.postProcessResponseCode(codegenResponse, "Forbidden", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "404": {
                                this.postProcessResponseCode(codegenResponse, "NotFound", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "405": {
                                this.postProcessResponseCode(codegenResponse, "MethodNotAllowed", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "406": {
                                this.postProcessResponseCode(codegenResponse, "NotAcceptable", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "407": {
                                this.postProcessResponseCode(codegenResponse, "ProxyAuthenticationRequired", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "408": {
                                this.postProcessResponseCode(codegenResponse, "RequestTimeout", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "409": {
                                this.postProcessResponseCode(codegenResponse, "Conflict", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "410": {
                                this.postProcessResponseCode(codegenResponse, "Gone", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "411": {
                                this.postProcessResponseCode(codegenResponse, "LengthRequired", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "412": {
                                this.postProcessResponseCode(codegenResponse, "PreconditionFailed", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "413": {
                                this.postProcessResponseCode(codegenResponse, "ContentTooLarge", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "414": {
                                this.postProcessResponseCode(codegenResponse, "URITooLong", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "415": {
                                this.postProcessResponseCode(codegenResponse, "UnsupportedMediaType", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "416": {
                                this.postProcessResponseCode(codegenResponse, "RangeNotSatisfiable", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "417": {
                                this.postProcessResponseCode(codegenResponse, "ExpectationFailed", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "421": {
                                this.postProcessResponseCode(codegenResponse, "MisdirectedRequest", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "422": {
                                this.postProcessResponseCode(codegenResponse, "UnprocessableContent", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "423": {
                                this.postProcessResponseCode(codegenResponse, "Locked", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "424": {
                                this.postProcessResponseCode(codegenResponse, "FailedDependency", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "425": {
                                this.postProcessResponseCode(codegenResponse, "TooEarly", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "426": {
                                this.postProcessResponseCode(codegenResponse, "UpgradeRequired", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "428": {
                                this.postProcessResponseCode(codegenResponse, "PreconditionRequired", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "429": {
                                this.postProcessResponseCode(codegenResponse, "TooManyRequests", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "431": {
                                this.postProcessResponseCode(codegenResponse, "RequestHeaderFieldsTooLong", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "451": {
                                this.postProcessResponseCode(codegenResponse, "UnavailableForLegalReasons", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "500": {
                                this.postProcessResponseCode(codegenResponse, "InternalServerError", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "501": {
                                this.postProcessResponseCode(codegenResponse, "NotImplemented", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "502": {
                                this.postProcessResponseCode(codegenResponse, "BadGateway", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "503": {
                                this.postProcessResponseCode(codegenResponse, "ServiceUnavailable", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "504": {
                                this.postProcessResponseCode(codegenResponse, "GatewayTimeout", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "505": {
                                this.postProcessResponseCode(codegenResponse, "HttpVersionNotSupported", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "506": {
                                this.postProcessResponseCode(codegenResponse, "VariantAlsoNegotiates", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "507": {
                                this.postProcessResponseCode(codegenResponse, "InsufficientStorage", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "508": {
                                this.postProcessResponseCode(codegenResponse, "LoopDetected", httpStatusesWithReturn);
                                continue block126;
                            }
                            case "511": {
                                this.postProcessResponseCode(codegenResponse, "NetworkAuthenticationRequired", httpStatusesWithReturn);
                                continue block126;
                            }
                        }
                        throw new RuntimeException("Unhandled case: " + code);
                    }
                }
                if (operation.returnType != null) {
                    String string;
                    int namespaceEnd = operation.returnType.lastIndexOf(".");
                    String string2 = string = namespaceEnd > 0 ? operation.returnType.substring(namespaceEnd) : operation.returnType;
                    if (this.collectionTypes.contains(string)) {
                        int genericStart;
                        operation.isArray = true;
                        operation.returnContainer = operation.returnType;
                        if (this.returnICollection && (string.startsWith("List") || string.startsWith("Collection")) && (genericStart = string.indexOf("<")) > 0) {
                            operation.returnType = "ICollection" + string.substring(genericStart);
                        }
                    } else {
                        operation.returnContainer = operation.returnType;
                        operation.isMap = this.mapTypes.stream().anyMatch(t -> typeMapping.startsWith((String)t));
                    }
                }
                if (operation.examples != null) {
                    for (Map map : operation.examples) {
                        for (Map.Entry entry : map.entrySet()) {
                            String val = ((String)entry.getValue()).replace("\"", "\\\"").replace("\r", "\\r").replace("\n", "\\n");
                            entry.setValue(val);
                        }
                    }
                }
                for (CodegenParameter codegenParameter : operation.allParams) {
                    CodegenModel model = this.getModelFromParameter(allModels, codegenParameter);
                    this.patchParameter(model, codegenParameter);
                }
                for (CodegenParameter codegenParameter : operation.bodyParams) {
                    CodegenModel model = this.getModelFromParameter(allModels, codegenParameter);
                    this.patchParameter(model, codegenParameter);
                }
                for (CodegenParameter codegenParameter : operation.cookieParams) {
                    CodegenModel model = this.getModelFromParameter(allModels, codegenParameter);
                    this.patchParameter(model, codegenParameter);
                }
                for (CodegenParameter codegenParameter : operation.formParams) {
                    CodegenModel model = this.getModelFromParameter(allModels, codegenParameter);
                    this.patchParameter(model, codegenParameter);
                }
                for (CodegenParameter codegenParameter : operation.headerParams) {
                    CodegenModel model = this.getModelFromParameter(allModels, codegenParameter);
                    this.patchParameter(model, codegenParameter);
                }
                for (CodegenParameter codegenParameter : operation.implicitHeadersParams) {
                    CodegenModel model = this.getModelFromParameter(allModels, codegenParameter);
                    this.patchParameter(model, codegenParameter);
                }
                for (CodegenParameter codegenParameter : operation.optionalParams) {
                    CodegenModel model = this.getModelFromParameter(allModels, codegenParameter);
                    this.patchParameter(model, codegenParameter);
                }
                for (CodegenParameter codegenParameter : operation.pathParams) {
                    CodegenModel model = this.getModelFromParameter(allModels, codegenParameter);
                    this.patchParameter(model, codegenParameter);
                }
                for (CodegenParameter codegenParameter : operation.queryParams) {
                    CodegenModel model = this.getModelFromParameter(allModels, codegenParameter);
                    this.patchParameter(model, codegenParameter);
                }
                for (CodegenParameter codegenParameter : operation.notNullableParams) {
                    CodegenModel model = this.getModelFromParameter(allModels, codegenParameter);
                    this.patchParameter(model, codegenParameter);
                }
                for (CodegenParameter codegenParameter : operation.requiredParams) {
                    CodegenModel model = this.getModelFromParameter(allModels, codegenParameter);
                    this.patchParameter(model, codegenParameter);
                }
                List referenceTypes = operation.allParams.stream().filter(p -> p.vendorExtensions.get("x-is-value-type") == null && !p.isNullable).collect(Collectors.toList());
                operation.vendorExtensions.put("x-not-nullable-reference-types", referenceTypes);
                operation.vendorExtensions.put("x-has-not-nullable-reference-types", referenceTypes.size() > 0);
                this.processOperation(operation);
            }
        }
        return objs;
    }

    protected void patchVendorExtensionNullableValueType(CodegenParameter parameter) {
        if (parameter.isNullable && !parameter.isContainer && (this.getValueTypes().contains(parameter.dataType) || parameter.isEnum)) {
            parameter.vendorExtensions.put("x-nullable-value-type", true);
        }
    }

    private CodegenModel getModelFromParameter(List<ModelMap> allModels, CodegenParameter parameter) {
        return parameter.isModel ? (CodegenModel)allModels.stream().map(m -> m.getModel()).filter(m -> m.getClassname().equals(parameter.dataType)).findFirst().orElse(null) : null;
    }

    protected void patchVendorExtensionNullableValueTypeLegacy(CodegenParameter parameter) {
        if (parameter.isNullable && !parameter.isContainer && (this.getNullableTypes().contains(parameter.dataType) || parameter.isEnum)) {
            parameter.vendorExtensions.put("x-nullable-value-type", true);
        }
    }

    private void patchParameter(CodegenModel model, CodegenParameter parameter) {
        this.patchVendorExtensionNullableValueType(parameter);
        if (this.getNullableReferencesTypes() || parameter.vendorExtensions.get("x-nullable-value-type") != null) {
            parameter.vendorExtensions.put("x-nullable-type", true);
        }
        if (!this.isSupportNullable()) {
            if (model == null) {
                parameter.isNullable = true;
            } else if (model.isEnum) {
                parameter.isEnum = true;
                parameter.allowableValues = model.allowableValues;
                parameter.isPrimitiveType = true;
                parameter.isNullable = false;
            } else {
                parameter.isNullable = true;
            }
        } else {
            this.updateCodegenParameterEnum(parameter, model);
        }
    }

    protected void processOperation(CodegenOperation operation) {
        String[] nestedTypes = new String[]{"List", "Collection", "ICollection", "Dictionary"};
        Arrays.stream(nestedTypes).forEach(nestedType -> {
            String nestedReturnType;
            if (operation.returnProperty != null && operation.returnType.contains("<" + nestedType + ">") && operation.returnProperty.items != null) {
                nestedReturnType = operation.returnProperty.items.dataType;
                operation.returnProperty.dataType = operation.returnType = operation.returnType.replace("<" + nestedType + ">", "<" + nestedReturnType + ">");
                operation.returnProperty.datatypeWithEnum = operation.returnType;
            }
            if (operation.returnProperty != null && operation.returnType.contains(", " + nestedType + ">") && operation.returnProperty.items != null) {
                nestedReturnType = operation.returnProperty.items.dataType;
                operation.returnProperty.dataType = operation.returnType = operation.returnType.replace(", " + nestedType + ">", ", " + nestedReturnType + ">");
                operation.returnProperty.datatypeWithEnum = operation.returnType;
            }
        });
    }

    protected void updateCodegenParameterEnumLegacy(CodegenParameter parameter, CodegenModel model) {
        if (model != null && model.isEnum) {
            parameter.isEnum = true;
            parameter.allowableValues = model.allowableValues;
            parameter.isPrimitiveType = true;
            parameter.vendorExtensions.put("x-csharp-value-type", true);
        }
        if (!parameter.isContainer && this.getNullableTypes().contains(parameter.dataType)) {
            parameter.vendorExtensions.put("x-csharp-value-type", true);
        }
    }

    protected void updateCodegenParameterEnum(CodegenParameter parameter, CodegenModel model) {
        if (model != null && model.isEnum) {
            parameter.isEnum = true;
            parameter.allowableValues = model.allowableValues;
            parameter.isPrimitiveType = true;
            parameter.vendorExtensions.put("x-is-value-type", true);
        }
        if (!parameter.isContainer && this.getValueTypes().contains(parameter.dataType)) {
            parameter.vendorExtensions.put("x-is-value-type", true);
        }
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.packageName + File.separator + this.apiPackage();
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.packageName + File.separator + this.modelPackage();
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.isReservedWord((String)operationId)) {
            this.LOGGER.warn("{} (reserved word) cannot be used as method name. Renamed to {}", operationId, (Object)StringUtils.camelize(this.sanitizeName("call_" + (String)operationId)));
            operationId = "call_" + (String)operationId;
        }
        if (((String)operationId).matches("^\\d.*")) {
            this.LOGGER.warn("{} (starting with a number) cannot be used as method name. Renamed to {}", operationId, (Object)StringUtils.camelize(this.sanitizeName("call_" + (String)operationId)));
            operationId = "call_" + (String)operationId;
        }
        return StringUtils.camelize(this.sanitizeName((String)operationId));
    }

    @Override
    public String toVarName(String name) {
        if (this.nameMapping.containsKey(name)) {
            return (String)this.nameMapping.get(name);
        }
        if ((name = this.sanitizeName(name)).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = StringUtils.camelize(name)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        if (this.propertySpecialKeywords.contains(name)) {
            return StringUtils.camelize("property_" + name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        if (this.parameterNameMapping.containsKey(name)) {
            return (String)this.parameterNameMapping.get(name);
        }
        name = this.sanitizeName(name);
        if ((name = name.replaceAll("-", "_")).matches("^[A-Z_]*$")) {
            return name;
        }
        name = StringUtils.camelize(name, CamelizeOption.LOWERCASE_FIRST_LETTER);
        return this.escapeReservedWord(name);
    }

    public String escapeReservedWord(CodegenModel model, String name) {
        return (name = this.escapeReservedWord(name)).equalsIgnoreCase(model.getClassname()) ? this.invalidNamePrefix + StringUtils.camelize(name) : name;
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWords().contains(name) || this.reservedWords().contains(((String)name).toLowerCase(Locale.ROOT)) || this.reservedWords().contains(StringUtils.camelize(this.sanitizeName((String)name))) || this.isReservedWord((String)name) || ((String)name).matches("^\\d.*")) {
            name = this.invalidNamePrefix + StringUtils.camelize((String)name);
        }
        return name;
    }

    @Override
    public String toExampleValue(Schema p) {
        return p.getExample() == null ? null : p.getExample().toString();
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isBooleanSchema(p)) {
            if (p.getDefault() != null) {
                return p.getDefault().toString();
            }
        } else if (ModelUtils.isDateSchema(p)) {
            if (p.getDefault() != null) {
                return "\"" + p.getDefault().toString() + "\"";
            }
        } else if (ModelUtils.isDateTimeSchema(p)) {
            if (p.getDefault() != null) {
                return "\"" + p.getDefault().toString() + "\"";
            }
        } else if (ModelUtils.isNumberSchema(p)) {
            if (p.getDefault() != null) {
                if (ModelUtils.isFloatSchema(p)) {
                    return p.getDefault().toString() + "F";
                }
                if (ModelUtils.isDoubleSchema(p)) {
                    return p.getDefault().toString() + "D";
                }
                return p.getDefault().toString() + "M";
            }
        } else if (ModelUtils.isIntegerSchema(p)) {
            if (p.getDefault() != null) {
                return p.getDefault().toString();
            }
        } else if (ModelUtils.isStringSchema(p) && p.getDefault() != null) {
            String _default = String.valueOf(p.getDefault());
            if (p.getEnum() == null) {
                return "\"" + _default + "\"";
            }
            return _default;
        }
        return null;
    }

    @Override
    protected boolean isReservedWord(String word) {
        return this.reservedWords.contains(word);
    }

    public String getNullableType(Schema p, String type) {
        if (this.languageSpecificPrimitives.contains(type)) {
            return type;
        }
        return null;
    }

    @Override
    public String getSchemaType(Schema p) {
        String type;
        String openAPIType = super.getSchemaType(p);
        if (openAPIType == null) {
            this.LOGGER.error("OpenAPI Type for {} is null. Default to UNKNOWN_OPENAPI_TYPE instead.", (Object)p.getName());
            openAPIType = "UNKNOWN_OPENAPI_TYPE";
        }
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            String languageType = this.getNullableType(p, type);
            if (languageType != null) {
                return languageType;
            }
        } else {
            type = openAPIType;
        }
        return this.toModelName(type);
    }

    private String getArrayTypeDeclaration(ArraySchema arr) {
        String arrayType = (String)this.typeMapping.get("array");
        StringBuilder instantiationType = new StringBuilder(arrayType);
        Schema items = arr.getItems();
        String nestedType = this.getTypeDeclaration(items);
        instantiationType.append("<").append(nestedType).append(">");
        return instantiationType.toString();
    }

    @Override
    public String toInstantiationType(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            return this.getArrayTypeDeclaration((ArraySchema)p);
        }
        return super.toInstantiationType(p);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            return this.getArrayTypeDeclaration((ArraySchema)p);
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            return this.getSchemaType(p) + "<string, " + this.getTypeDeclaration(inner) + ">";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String toModelName(String name) {
        if (this.modelNameMapping.containsKey(name)) {
            return (String)this.modelNameMapping.get(name);
        }
        if (this.schemaMapping.containsKey(name)) {
            return (String)this.schemaMapping.get(name);
        }
        Object origName = name;
        if (this.schemaKeyToModelNameCache.containsKey(origName)) {
            return this.schemaKeyToModelNameCache.get(origName);
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + (String)name;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = (String)name + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord((String)(name = StringUtils.camelize(this.sanitizeName((String)name))))) {
            this.LOGGER.warn("{} (reserved word) cannot be used as model name. Renamed to {}", name, (Object)StringUtils.camelize("model_" + (String)name));
            name = StringUtils.camelize("model_" + (String)name);
        }
        if (((String)name).matches("^\\d.*")) {
            this.LOGGER.warn("{} (model name starts with number) cannot be used as model name. Renamed to {}", name, (Object)StringUtils.camelize("model_" + (String)name));
            name = StringUtils.camelize("model_" + (String)name);
        }
        this.schemaKeyToModelNameCache.put((String)origName, (String)name);
        return name;
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + ".Test";
    }

    @Override
    public String modelTestFileFolder() {
        return this.outputFolder + ".Test";
    }

    @Override
    public String toApiTestFilename(String name) {
        return this.toApiName(name) + "Tests";
    }

    @Override
    public String toModelTestFilename(String name) {
        return this.toModelName(name) + "Tests";
    }

    public void setLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

    public void setLicenseName(String licenseName) {
        this.licenseName = licenseName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    public void setPackageTitle(String packageTitle) {
        this.packageTitle = packageTitle;
    }

    public void setPackageProductName(String packageProductName) {
        this.packageProductName = packageProductName;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    public void setPackageDescription(String packageDescription) {
        this.packageDescription = packageDescription;
    }

    public void setPackageCompany(String packageCompany) {
        this.packageCompany = packageCompany;
    }

    public void setPackageCopyright(String packageCopyright) {
        this.packageCopyright = packageCopyright;
    }

    public void setPackageAuthors(String packageAuthors) {
        this.packageAuthors = packageAuthors;
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    public void setTestFolder(String testFolder) {
        this.testFolder = testFolder;
    }

    public String getInterfacePrefix() {
        return this.interfacePrefix;
    }

    public void setZeroBasedEnums(Boolean zeroBasedEnums) {
        this.zeroBasedEnums = zeroBasedEnums;
    }

    public void setNullableReferenceTypes(Boolean nullReferenceTypesFlag) {
        this.nullReferenceTypesFlag = nullReferenceTypesFlag;
        this.additionalProperties.put("nullableReferenceTypes", nullReferenceTypesFlag);
        this.additionalProperties.put("nrt", nullReferenceTypesFlag);
        if (nullReferenceTypesFlag.booleanValue()) {
            this.additionalProperties.put("nrt?", "?");
            this.additionalProperties.put("nrt!", "!");
        } else {
            this.additionalProperties.remove("nrt?");
            this.additionalProperties.remove("nrt!");
        }
    }

    public boolean getNullableReferencesTypes() {
        return this.nullReferenceTypesFlag;
    }

    public void setUseSourceGeneration(Boolean useSourceGeneration) {
        this.useSourceGeneration = useSourceGeneration;
    }

    public boolean getUseSourceGeneration() {
        return this.useSourceGeneration;
    }

    public void setInterfacePrefix(String interfacePrefix) {
        this.interfacePrefix = interfacePrefix;
    }

    public void setEnumNameSuffix(String enumNameSuffix) {
        this.enumNameSuffix = enumNameSuffix;
    }

    public void setEnumValueSuffix(String enumValueSuffix) {
        this.enumValueSuffix = enumValueSuffix;
    }

    public boolean isSupportNullable() {
        return this.supportNullable;
    }

    public void setSupportNullable(boolean supportNullable) {
        this.supportNullable = supportNullable;
    }

    public CodegenConstants.ENUM_PROPERTY_NAMING_TYPE getEnumPropertyNaming() {
        return this.enumPropertyNaming;
    }

    public void setEnumPropertyNaming(String enumPropertyNamingType) {
        try {
            this.enumPropertyNaming = CodegenConstants.ENUM_PROPERTY_NAMING_TYPE.valueOf(enumPropertyNamingType);
        }
        catch (IllegalArgumentException ex) {
            StringBuilder sb = new StringBuilder(enumPropertyNamingType + " is an invalid enum property naming option. Please choose from:");
            for (CodegenConstants.ENUM_PROPERTY_NAMING_TYPE t : CodegenConstants.ENUM_PROPERTY_NAMING_TYPE.values()) {
                sb.append("\n  ").append(t.name());
            }
            throw new RuntimeException(sb.toString());
        }
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if (datatype.startsWith("int") || datatype.startsWith("uint") || datatype.startsWith("long") || datatype.startsWith("ulong") || datatype.startsWith("byte")) {
            return value;
        }
        String partiallyEscaped = value.replace("\n", "\\n").replace("\t", "\\t").replace("\r", "\\r").replaceAll("(?<!\\\\)\"", "\\\\\"");
        return this.escapeUnsafeCharacters(partiallyEscaped);
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        if (name.length() == 0) {
            return this.adjustNamingStyle("Empty");
        }
        if (this.getSymbolName(name) != null) {
            return this.adjustNamingStyle(this.getSymbolName(name));
        }
        Object enumName = this.sanitizeName(name);
        enumName = ((String)enumName).replaceFirst("^_", "");
        enumName = ((String)enumName).replaceFirst("_$", "");
        if (((String)(enumName = this.adjustNamingStyle((String)enumName) + this.enumValueSuffix)).matches("\\d.*")) {
            return "_" + (String)enumName;
        }
        return enumName;
    }

    private String adjustNamingStyle(String name) {
        switch (this.getEnumPropertyNaming()) {
            case original: {
                return name;
            }
            case camelCase: {
                return StringUtils.camelize(name, CamelizeOption.LOWERCASE_FIRST_LETTER);
            }
            case PascalCase: {
                return StringUtils.camelize(name);
            }
            case snake_case: {
                return StringUtils.underscore(name);
            }
            case UPPERCASE: {
                return StringUtils.underscore(name).toUpperCase(Locale.ROOT);
            }
        }
        return name;
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        return this.sanitizeName(StringUtils.camelize(property.name)) + this.enumNameSuffix;
    }

    public String testPackageName() {
        return this.packageName + ".Test";
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*").replace("--", "- -");
    }

    @Override
    public boolean isDataTypeString(String dataType) {
        return "String".equalsIgnoreCase(dataType) || "double?".equals(dataType) || "decimal?".equals(dataType) || "float?".equals(dataType) || "double".equals(dataType) || "decimal".equals(dataType) || "float".equals(dataType);
    }

    protected boolean isValueType(CodegenProperty var) {
        return this.getValueTypes().contains(var.dataType) || var.isEnum;
    }

    @Override
    public void setParameterExampleValue(CodegenParameter p) {
        Object example;
        boolean hasAllowableValues;
        boolean bl = hasAllowableValues = p.allowableValues != null && !p.allowableValues.isEmpty();
        if (hasAllowableValues) {
            List values = (List)p.allowableValues.get("values");
            example = String.valueOf(values.get(0));
        } else {
            example = p.defaultValue == null ? p.example : p.defaultValue;
        }
        String type = p.baseType;
        if (type == null) {
            type = p.dataType;
        }
        if (p.isString) {
            if (example == null) {
                example = p.paramName + "_example";
            }
            example = "\"" + this.escapeText((String)example) + "\"";
        } else if (p.isInteger || p.isShort) {
            if (example == null) {
                example = "56";
            }
        } else if (p.isLong) {
            if (example == null) {
                example = "789";
            }
            example = org.apache.commons.lang3.StringUtils.appendIfMissingIgnoreCase((String)example, (CharSequence)"L", (CharSequence[])new CharSequence[0]);
        } else if (p.isFloat) {
            if (example == null) {
                example = "3.4F";
            }
            example = org.apache.commons.lang3.StringUtils.appendIfMissingIgnoreCase((String)example, (CharSequence)"F", (CharSequence[])new CharSequence[0]);
        } else if (p.isDouble) {
            if (example == null) {
                example = "1.2D";
            }
            example = org.apache.commons.lang3.StringUtils.appendIfMissingIgnoreCase((String)example, (CharSequence)"D", (CharSequence[])new CharSequence[0]);
        } else if (p.isNumber) {
            if (example == null) {
                example = "8.14";
            }
            example = org.apache.commons.lang3.StringUtils.appendIfMissingIgnoreCase((String)example, (CharSequence)"D", (CharSequence[])new CharSequence[0]);
        } else if (p.isBoolean) {
            if (example == null) {
                example = "true";
            }
        } else if (p.isBinary || p.isFile) {
            if (example == null) {
                example = "/path/to/file.txt";
            }
            example = "new System.IO.MemoryStream(System.IO.File.ReadAllBytes(\"" + this.escapeText((String)example) + "\"))";
        } else if (p.isByteArray) {
            if (example == null) {
                example = "BYTE_ARRAY_DATA_HERE";
            }
            example = "System.Text.Encoding.ASCII.GetBytes(\"" + this.escapeText((String)example) + "\")";
        } else if (p.isDate) {
            example = example == null ? "DateTime.Parse(\"2013-10-20\")" : "DateTime.Parse(\"" + (String)example + "\")";
        } else if (p.isDateTime) {
            example = example == null ? "DateTime.Parse(\"2013-10-20T19:20:30+01:00\")" : "DateTime.Parse(\"" + (String)example + "\")";
        } else if (p.isDecimal) {
            if (example == null) {
                example = "8.9M";
            }
            example = org.apache.commons.lang3.StringUtils.appendIfMissingIgnoreCase((String)example, (CharSequence)"M", (CharSequence[])new CharSequence[0]);
        } else if (p.isUuid) {
            example = example == null ? "\"38400000-8cf0-11bd-b23e-10b96e4ef00d\"" : "\"" + (String)example + "\"";
        } else if (p.isUri) {
            example = example == null ? "new Uri(\"https://openapi-generator.tech\")" : "new Uri(\"" + (String)example + "\")";
        } else if (hasAllowableValues) {
            example = "(" + type + ") \"" + (String)example + "\"";
        } else if (!this.languageSpecificPrimitives.contains(type)) {
            example = "new " + type + "()";
        }
        if (example == null) {
            example = "null";
        } else if (Boolean.TRUE.equals(p.isArray)) {
            if (p.items.defaultValue != null) {
                Object innerExample = "String".equals(p.items.dataType) ? "\"" + p.items.defaultValue + "\"" : p.items.defaultValue;
                example = "new List<" + p.items.dataType + ">({" + (String)innerExample + "})";
            } else {
                example = "new List<" + p.items.dataType + ">()";
            }
        } else if (Boolean.TRUE.equals(p.isModel)) {
            example = "new " + p.dataType + "()";
        } else if (Boolean.TRUE.equals(p.isMap)) {
            example = p.items != null ? "new Dictionary<String, " + p.items.dataType + ">" : "new Dictionary<String, String>";
        }
        p.example = example;
    }

    @Override
    public void postProcessFile(File file, String fileType) {
        if (file == null) {
            return;
        }
        String csharpPostProcessFile = System.getenv("CSHARP_POST_PROCESS_FILE");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)csharpPostProcessFile)) {
            return;
        }
        if ("cs".equals(FilenameUtils.getExtension((String)file.toString()))) {
            String command = csharpPostProcessFile + " " + file;
            try {
                Process p = Runtime.getRuntime().exec(command);
                int exitValue = p.waitFor();
                if (exitValue != 0) {
                    this.LOGGER.error("Error running the command ({}). Exit code: {}", (Object)command, (Object)exitValue);
                } else {
                    this.LOGGER.info("Successfully executed: {}", (Object)command);
                }
            }
            catch (IOException | InterruptedException e) {
                this.LOGGER.error("Error running the command ({}). Exception: {}", (Object)command, (Object)e.getMessage());
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        this.postProcessPattern(parameter.pattern, parameter.vendorExtensions);
    }

    public void postProcessPattern(String pattern, Map<String, Object> vendorExtensions) {
        if (pattern != null) {
            Pattern hasModifiers = Pattern.compile(".*/[gmiyuvsdlnx]+$");
            int end = hasModifiers.matcher(pattern).find() ? pattern.lastIndexOf(47) : pattern.length() - 1;
            int start = pattern.startsWith("/") ? 1 : 0;
            HashMap<Character, String> optionsMap = new HashMap<Character, String>();
            optionsMap.put(Character.valueOf('i'), "IgnoreCase");
            optionsMap.put(Character.valueOf('m'), "Multiline");
            optionsMap.put(Character.valueOf('s'), "SingleLine");
            optionsMap.put(Character.valueOf('n'), "ExplicitCapture");
            optionsMap.put(Character.valueOf('x'), "IgnorePatternWhitespace");
            ArrayList<String> modifiers = new ArrayList<String>();
            modifiers.add("CultureInvariant");
            for (char c : pattern.substring(end).toCharArray()) {
                if (optionsMap.containsKey(Character.valueOf(c))) {
                    modifiers.add((String)optionsMap.get(Character.valueOf(c)));
                    continue;
                }
                if (c == 'l') {
                    modifiers.remove("CultureInvariant");
                    continue;
                }
                vendorExtensions.put("x-modifier-" + c, Character.valueOf(c));
            }
            String regex = pattern.substring(start, end).replace("'", "'").replace("\"", "\"\"");
            vendorExtensions.put("x-regex", regex);
            vendorExtensions.put("x-modifiers", modifiers);
        }
    }

    @Override
    public GeneratorLanguage generatorLanguage() {
        return GeneratorLanguage.C_SHARP;
    }

    @Override
    public String toRegularExpression(String pattern) {
        return this.addRegularExpressionDelimiter(pattern);
    }

    @Override
    public String addRegularExpressionDelimiter(String pattern) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)pattern)) {
            return pattern;
        }
        if (!pattern.matches("^/.*")) {
            return "/" + pattern + "/";
        }
        return pattern;
    }

    @Deprecated
    protected Set<String> getNullableTypes() {
        throw new RuntimeException("This method should no longer be used.");
    }

    protected Set<String> getValueTypes() {
        return new HashSet<String>(Arrays.asList("decimal", "bool", "int", "uint", "long", "ulong", "float", "double", "DateTime", "DateTimeOffset", "Guid"));
    }

    protected void setTypeMapping() {
        this.typeMapping = new HashMap();
        this.typeMapping.put("string", "string");
        this.typeMapping.put("binary", "byte[]");
        this.typeMapping.put("ByteArray", "byte[]");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("UnsignedInteger", "uint");
        this.typeMapping.put("UnsignedLong", "ulong");
        this.typeMapping.put("long", "long");
        this.typeMapping.put("float", "float");
        this.typeMapping.put("double", "double");
        this.typeMapping.put("number", "decimal");
        this.typeMapping.put("decimal", "decimal");
        this.typeMapping.put("BigDecimal", "decimal");
        this.typeMapping.put("DateTime", this.useDateTimeOffsetFlag ? "DateTimeOffset" : "DateTime");
        this.typeMapping.put("date", "DateTime");
        this.typeMapping.put("file", "System.IO.Stream");
        this.typeMapping.put("array", "List");
        this.typeMapping.put("list", "List");
        this.typeMapping.put("map", "Dictionary");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("UUID", "Guid");
        this.typeMapping.put("URI", "string");
        this.typeMapping.put("AnyType", "Object");
        if (this.useCollection) {
            this.typeMapping.put("array", "Collection");
            this.typeMapping.put("list", "Collection");
        }
    }
}

