/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.servers.ServerVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenServerVariable;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.GeneratorLanguage;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostmanCollectionCodegen
extends DefaultCodegen
implements CodegenConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(PostmanCollectionCodegen.class);
    protected String apiVersion = "1.0.0";
    public static final String FOLDER_STRATEGY = "folderStrategy";
    public static final String FOLDER_STRATEGY_DEFAULT_VALUE = "Tags";
    public static final String PATH_PARAMS_AS_VARIABLES = "pathParamsAsVariables";
    public static final Boolean PATH_PARAMS_AS_VARIABLES_DEFAULT_VALUE = true;
    public static final String POSTMAN_FILE_DEFAULT_VALUE = "postman.json";
    public static final String POSTMAN_VARIABLES = "postmanVariables";
    protected Boolean postmanVariables = true;
    public static final String POSTMAN_GUID = "postmanGuid";
    protected Boolean postmanGuid = true;
    public static final String POSTMAN_GUID_PLACEHOLDER_NAME = "postmanGuidPlaceholderName";
    protected static final String POSTMAN_GUID_PLACEHOLDER_NAME_DEFAULT_VALUE = "UNIQUE_REFERENCE";
    protected static String postmanGuidPlaceholderName = "UNIQUE_REFERENCE";
    protected Boolean postmanIsoTimestamp = true;
    public static final String POSTMAN_ISO_TIMESTAMP = "postmanIsoTimestamp";
    public static final String POSTMAN_ISO_TIMESTAMP_PLACEHOLDER_NAME = "postmanIsoTimestampPlaceholderName";
    public static final String POSTMAN_ISO_TIMESTAMP_PLACEHOLDER_NAME_DEFAULT_VALUE = "ISO_TIMESTAMP";
    protected static String postmanIsoTimestampPlaceholderName = "ISO_TIMESTAMP";
    public static final String REQUEST_PARAMETER_GENERATION = "requestParameterGeneration";
    public static final String REQUEST_PARAMETER_GENERATION_DEFAULT_VALUE = "Example";
    public String folderStrategy = "Tags";
    protected Boolean pathParamsAsVariables = PATH_PARAMS_AS_VARIABLES_DEFAULT_VALUE;
    public String postmanFile = "postman.json";
    protected String requestParameterGeneration = "Example";
    public Set<PostmanVariable> variables = new HashSet<PostmanVariable>();
    public static final String JSON_ESCAPE_DOUBLE_QUOTE = "\\\"";
    public static final String JSON_ESCAPE_NEW_LINE = "\\n";
    protected Map<String, List<CodegenOperation>> codegenOperationsByTag = new HashMap<String, List<CodegenOperation>>();
    protected List<CodegenOperation> codegenOperationsList = new ArrayList<CodegenOperation>();

    @Override
    public CodegenType getTag() {
        return CodegenType.SCHEMA;
    }

    @Override
    public GeneratorLanguage generatorLanguage() {
        return null;
    }

    @Override
    public String getName() {
        return "postman-collection";
    }

    public PostmanCollectionCodegen() {
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.BETA).build();
        this.templateDir = "postman-collection";
        this.embeddedTemplateDir = "postman-collection";
        this.supportingFiles.add(new SupportingFile("postman.mustache", "", this.postmanFile));
        this.cliOptions.clear();
        this.cliOptions.add(CliOption.newString(FOLDER_STRATEGY, "whether to create folders according to the spec\u2019s paths or tags"));
        this.cliOptions.add(CliOption.newBoolean(PATH_PARAMS_AS_VARIABLES, "whether to create Postman variables for path parameters"));
        this.cliOptions.add(CliOption.newString(POSTMAN_VARIABLES, "whether to convert placeholders (i.e. {{VAR_1}}) into Postman variables"));
        this.cliOptions.add(CliOption.newString(POSTMAN_GUID, "whether to convert placeholders (i.e. {{UNIQUE_REFERENCE}}) into Postman formula {{$guid}}"));
        this.cliOptions.add(CliOption.newString(POSTMAN_GUID_PLACEHOLDER_NAME, "name of the placeholder (i.e. {{UNIQUE_REFERENCE}}) to replace with Postman formula {{$guid}}"));
        this.cliOptions.add(CliOption.newString(POSTMAN_ISO_TIMESTAMP, "whether to convert placeholders (i.e. {{ISO_TIMESTAMP}}) into Postman formula {{$isoTimestamp}}"));
        this.cliOptions.add(CliOption.newString(POSTMAN_ISO_TIMESTAMP_PLACEHOLDER_NAME, "name of the placeholder (i.e. {{ISO_TIMESTAMP}}) to replace with Postman formula {{$isoTimestamp}}"));
        this.cliOptions.add(CliOption.newString(REQUEST_PARAMETER_GENERATION, "whether to generate the request parameters based on the schema or the examples"));
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        if (this.pathParamsAsVariables.booleanValue() && parameter.isPathParam) {
            this.variables.add(new PostmanVariable().addName(parameter.paramName).addType(this.mapToPostmanType(parameter.dataType)).addeDefaultValue(parameter.defaultValue));
        }
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        super.preprocessOpenAPI(openAPI);
        this.additionalProperties().put("formattedDescription", this.formatDescription(openAPI.getInfo().getDescription()));
    }

    @Override
    public List<CodegenServerVariable> fromServerVariables(Map<String, ServerVariable> variables) {
        if (variables != null) {
            variables.entrySet().stream().forEach(serverVariableEntry -> this.variables.add(new PostmanVariable().addName((String)serverVariableEntry.getKey()).addType("string").addeDefaultValue(((ServerVariable)serverVariableEntry.getValue()).getDefault())));
        }
        return super.fromServerVariables(variables);
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties().containsKey(FOLDER_STRATEGY)) {
            this.folderStrategy = this.additionalProperties().get(FOLDER_STRATEGY).toString();
        }
        if (this.additionalProperties.containsKey(PATH_PARAMS_AS_VARIABLES)) {
            this.pathParamsAsVariables = Boolean.parseBoolean(this.additionalProperties.get(PATH_PARAMS_AS_VARIABLES).toString());
        }
        if (this.additionalProperties().containsKey(REQUEST_PARAMETER_GENERATION)) {
            this.requestParameterGeneration = this.additionalProperties().get(REQUEST_PARAMETER_GENERATION).toString();
        }
        if (this.additionalProperties().containsKey(POSTMAN_VARIABLES)) {
            this.postmanVariables = Boolean.parseBoolean(this.additionalProperties.get(POSTMAN_VARIABLES).toString());
        }
        if (this.additionalProperties().containsKey(POSTMAN_GUID)) {
            this.postmanGuid = Boolean.parseBoolean(this.additionalProperties.get(POSTMAN_GUID).toString());
        }
        if (this.additionalProperties().containsKey(POSTMAN_GUID_PLACEHOLDER_NAME)) {
            postmanGuidPlaceholderName = this.additionalProperties.get(POSTMAN_GUID_PLACEHOLDER_NAME).toString();
        }
        if (this.additionalProperties().containsKey(POSTMAN_ISO_TIMESTAMP)) {
            this.postmanIsoTimestamp = Boolean.parseBoolean(this.additionalProperties.get(POSTMAN_ISO_TIMESTAMP).toString());
        }
        if (this.additionalProperties().containsKey(POSTMAN_ISO_TIMESTAMP_PLACEHOLDER_NAME)) {
            postmanIsoTimestampPlaceholderName = this.additionalProperties.get(POSTMAN_ISO_TIMESTAMP_PLACEHOLDER_NAME).toString();
        }
        super.vendorExtensions().put("variables", this.variables);
        if (this.folderStrategy.equalsIgnoreCase("tags")) {
            this.additionalProperties().put("codegenOperationsByTag", this.codegenOperationsByTag);
        } else {
            this.additionalProperties().put("codegenOperationsList", this.codegenOperationsList);
        }
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        OperationsMap results = super.postProcessOperationsWithModels(objs, allModels);
        OperationMap ops = results.getOperations();
        List<CodegenOperation> opList = ops.getOperation();
        for (CodegenOperation codegenOperation : opList) {
            CodegenProperty schema;
            String mediaType;
            if (this.pathParamsAsVariables.booleanValue()) {
                codegenOperation.path = this.doubleCurlyBraces(codegenOperation.path);
            }
            codegenOperation.summary = this.getSummary(codegenOperation);
            if (codegenOperation.produces != null && codegenOperation.produces.get(0) != null) {
                mediaType = codegenOperation.produces.get(0).get("mediaType");
                CodegenParameter acceptHeader = new CodegenParameter();
                acceptHeader.baseName = "Accept";
                acceptHeader.paramName = "Accept";
                schema = new CodegenProperty();
                schema.defaultValue = mediaType;
                acceptHeader.setSchema(schema);
                codegenOperation.headerParams.add(0, acceptHeader);
            }
            if (codegenOperation.consumes != null && codegenOperation.consumes.get(0) != null) {
                mediaType = codegenOperation.consumes.get(0).get("mediaType");
                CodegenParameter contentTypeHeader = new CodegenParameter();
                contentTypeHeader.baseName = "Content-Type";
                contentTypeHeader.paramName = "Content-Type";
                schema = new CodegenProperty();
                schema.defaultValue = mediaType;
                contentTypeHeader.setSchema(schema);
                codegenOperation.headerParams.add(0, contentTypeHeader);
            }
            String[] pathSegments = codegenOperation.path.substring(1).split("/");
            codegenOperation.vendorExtensions.put("pathSegments", pathSegments);
            codegenOperation.responses.stream().forEach(r -> r.vendorExtensions.put("pathSegments", pathSegments));
            List<PostmanRequestItem> postmanRequests = this.getPostmanRequests(codegenOperation);
            if (postmanRequests != null) {
                if (this.postmanVariables.booleanValue()) {
                    postmanRequests = this.createPostmanVariables(postmanRequests);
                }
                if (this.postmanGuid.booleanValue()) {
                    postmanRequests = this.setPostmanGuid(postmanRequests);
                }
                if (this.postmanIsoTimestamp.booleanValue()) {
                    postmanRequests = this.setPostmanIsoTimestamp(postmanRequests);
                }
                codegenOperation.vendorExtensions.put("postmanRequests", postmanRequests);
            }
            for (CodegenResponse codegenResponse : codegenOperation.responses) {
                codegenResponse.vendorExtensions.put("status", this.getStatus(codegenResponse));
            }
            if (this.folderStrategy.equalsIgnoreCase("tags")) {
                this.addToMap(codegenOperation);
                continue;
            }
            this.addToList(codegenOperation);
        }
        return results;
    }

    void addToMap(CodegenOperation codegenOperation) {
        String key = null;
        key = codegenOperation.tags == null || codegenOperation.tags.isEmpty() ? "default" : codegenOperation.tags.get(0).getName();
        List<CodegenOperation> list = this.codegenOperationsByTag.get(key);
        if (list == null) {
            list = new ArrayList<CodegenOperation>();
        }
        list.add(codegenOperation);
        this.codegenOperationsByTag.put(key, list);
    }

    void addToList(CodegenOperation codegenOperation) {
        this.codegenOperationsList.add(codegenOperation);
    }

    String getResponseBody(CodegenResponse codegenResponse) {
        Map<String, Example> maxExamples;
        String responseBody = "";
        if (codegenResponse.getContent() != null && codegenResponse.getContent().get("application/json") != null && codegenResponse.getContent().get("application/json").getExamples() != null) {
            String exampleRef = codegenResponse.getContent().get("application/json").getExamples().values().iterator().next().get$ref();
            if (exampleRef != null) {
                Example example = (Example)this.openAPI.getComponents().getExamples().get(this.extractExampleByName(exampleRef));
                responseBody = this.getJsonFromExample(example);
            }
        } else if (codegenResponse.getContent() != null && (maxExamples = codegenResponse.getContent().get("application/json").getExamples()) != null && maxExamples.values().iterator().hasNext()) {
            responseBody = this.getJsonFromExample(maxExamples.values().iterator().next());
        }
        return responseBody;
    }

    List<PostmanRequestItem> getPostmanRequests(CodegenOperation codegenOperation) {
        ArrayList<PostmanRequestItem> items = new ArrayList<PostmanRequestItem>();
        if (codegenOperation.getHasBodyParam()) {
            if (this.requestParameterGeneration.equalsIgnoreCase("Schema")) {
                items.add(new PostmanRequestItem(codegenOperation.summary, this.getJsonFromSchema(codegenOperation.bodyParam)));
            } else if (codegenOperation.bodyParam.example != null) {
                items.add(new PostmanRequestItem(codegenOperation.summary, this.formatJson(codegenOperation.bodyParam.example)));
            } else if (codegenOperation.bodyParam.getContent().get("application/json") != null && codegenOperation.bodyParam.getContent().get("application/json").getExamples() != null) {
                for (Map.Entry<String, Example> entry : codegenOperation.bodyParam.getContent().get("application/json").getExamples().entrySet()) {
                    String exampleRef = entry.getValue().get$ref();
                    Example example = (Example)this.openAPI.getComponents().getExamples().get(this.extractExampleByName(exampleRef));
                    String exampleAsString = this.getJsonFromExample(example);
                    items.add(new PostmanRequestItem(example.getSummary(), exampleAsString));
                }
            } else if (codegenOperation.bodyParam.getSchema() != null) {
                String exampleAsString = this.formatJson(codegenOperation.bodyParam.getSchema().getExample());
                items.add(new PostmanRequestItem(codegenOperation.summary, exampleAsString));
            } else {
                items.add(new PostmanRequestItem(codegenOperation.summary, this.getJsonFromSchema(codegenOperation.bodyParam)));
            }
        } else {
            items.add(new PostmanRequestItem(codegenOperation.summary, ""));
        }
        return items;
    }

    public List<PostmanRequestItem> createPostmanVariables(List<PostmanRequestItem> postmanRequests) {
        for (PostmanRequestItem requestItem : postmanRequests) {
            for (String var : this.extractPlaceholders(requestItem.getBody())) {
                this.variables.add(new PostmanVariable().addName(var).addType("string").addeDefaultValue(""));
            }
        }
        return postmanRequests;
    }

    List<PostmanRequestItem> setPostmanGuid(List<PostmanRequestItem> postmanRequests) {
        for (PostmanRequestItem requestItem : postmanRequests) {
            requestItem.setBody(requestItem.getBody().replace("{{" + postmanGuidPlaceholderName + "}}", "{{$guid}}"));
        }
        return postmanRequests;
    }

    List<PostmanRequestItem> setPostmanIsoTimestamp(List<PostmanRequestItem> postmanRequests) {
        for (PostmanRequestItem requestItem : postmanRequests) {
            requestItem.setBody(requestItem.getBody().replace("{{" + postmanIsoTimestampPlaceholderName + "}}", "{{$isoTimestamp}}"));
        }
        return postmanRequests;
    }

    @Override
    public String getHelp() {
        return "Generates a Postman collection (format v2.1.0) JSON file";
    }

    @Override
    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input;
    }

    @Override
    public String toDefaultValue(Schema schema) {
        if (schema.getDefault() != null) {
            return schema.getDefault().toString();
        }
        return null;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", JSON_ESCAPE_DOUBLE_QUOTE);
    }

    public String doubleCurlyBraces(String str) {
        String s = str.replace("{{", "{").replace("}}", "}");
        s = s.replace("{", "{{").replace("}", "}}");
        return s;
    }

    public String extractExampleByName(String ref) {
        return ref.substring(ref.lastIndexOf("/") + 1);
    }

    public String mapToPostmanType(String openApiDataType) {
        String ret = "any";
        if (openApiDataType.equalsIgnoreCase("string")) {
            ret = "string";
        } else if (openApiDataType.equalsIgnoreCase("number") || openApiDataType.equalsIgnoreCase("integer")) {
            ret = "number";
        } else if (openApiDataType.equalsIgnoreCase("boolean")) {
            ret = "boolean";
        }
        return ret;
    }

    String getStatus(CodegenResponse codegenResponse) {
        String ret = "";
        if (codegenResponse.is2xx) {
            ret = codegenResponse.code.equalsIgnoreCase("200") ? "OK" : (codegenResponse.code.equalsIgnoreCase("201") ? "Created" : "Success");
        } else if (codegenResponse.is3xx) {
            ret = "Redirection";
        }
        if (codegenResponse.is4xx) {
            ret = codegenResponse.code.equalsIgnoreCase("400") ? "Bad Request" : (codegenResponse.code.equalsIgnoreCase("401") ? "Unauthorized" : (codegenResponse.code.equalsIgnoreCase("403") ? "Forbidden" : (codegenResponse.code.equalsIgnoreCase("404") ? "Not Found" : (codegenResponse.code.equalsIgnoreCase("409") ? "Conflict" : "Client Error"))));
        }
        if (codegenResponse.is5xx) {
            ret = codegenResponse.code.equalsIgnoreCase("500") ? "Internal Server Error" : (codegenResponse.code.equalsIgnoreCase("501") ? "Not Implemented" : "Server Error");
        }
        return ret;
    }

    String getSummary(CodegenOperation codegenOperation) {
        String ret = null;
        ret = codegenOperation.summary != null ? codegenOperation.summary : (codegenOperation.operationId != null ? codegenOperation.operationId : codegenOperation.httpMethod);
        return ret;
    }

    public String formatDescription(String description) {
        if (description != null) {
            description = description.replace("\n", JSON_ESCAPE_NEW_LINE);
            description = description.replace("\"", JSON_ESCAPE_DOUBLE_QUOTE);
        }
        return description;
    }

    public Set<String> extractPlaceholders(String input) {
        HashSet<String> variables = new HashSet<String>();
        Pattern pattern = Pattern.compile("\\{\\{([^}]*)\\}\\}");
        Matcher matcher = pattern.matcher(input);
        while (matcher.find() && !postmanGuidPlaceholderName.equalsIgnoreCase(matcher.group(1)) && !postmanIsoTimestampPlaceholderName.equalsIgnoreCase(matcher.group(1)) && !this.isPostmanDynamicVariable(matcher.group(1))) {
            variables.add(matcher.group(1));
        }
        return variables;
    }

    public boolean isPostmanDynamicVariable(String value) {
        boolean ret = false;
        if (value.equals("$guid") || value.equals("$timestamp")) {
            ret = true;
        }
        return ret;
    }

    public String getJsonFromSchema(CodegenParameter codegenParameter) {
        Object ret = "{\\n ";
        int numVars = codegenParameter.vars.size();
        int counter = 1;
        for (CodegenProperty codegenProperty : codegenParameter.vars) {
            ret = (String)ret + JSON_ESCAPE_DOUBLE_QUOTE + codegenProperty.baseName + "\\\": \\\"<" + this.getPostmanType(codegenProperty) + ">\\\"";
            if (counter < numVars) {
                ret = (String)ret + ",\\n ";
            }
            ++counter;
        }
        ret = (String)ret + "\\n}";
        return ret;
    }

    public String getJsonFromExample(Example example) {
        String ret = "";
        if (example == null) {
            return ret;
        }
        if (example.getValue() instanceof ObjectNode) {
            ret = this.convertToJson((ObjectNode)example.getValue());
        } else if (example.getValue() instanceof LinkedHashMap) {
            ret = this.convertToJson((LinkedHashMap)example.getValue());
        }
        return ret;
    }

    public String[] getAttributes(String json) {
        return json.split(",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)", -1);
    }

    public String convertToJson(ObjectNode objectNode) {
        return this.formatJson(objectNode.toString());
    }

    public String convertToJson(LinkedHashMap<String, Object> linkedHashMap) {
        String ret = "";
        return this.traverseMap(linkedHashMap, ret);
    }

    public String formatJson(String json) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            JsonNode actualObj = objectMapper.readTree(json);
            json = Json.pretty((Object)actualObj);
            json = json.replace("\"", JSON_ESCAPE_DOUBLE_QUOTE);
            json = json.replace("\n", JSON_ESCAPE_NEW_LINE);
        }
        catch (JsonProcessingException e) {
            this.LOGGER.warn("Error formatting JSON", (Throwable)e);
            json = "";
        }
        return json;
    }

    private String traverseMap(LinkedHashMap<String, Object> linkedHashMap, String ret) {
        ret = (String)ret + "{\\n ";
        int numVars = linkedHashMap.entrySet().size();
        int counter = 1;
        for (Map.Entry<String, Object> mapElement : linkedHashMap.entrySet()) {
            String key = mapElement.getKey();
            Object value = mapElement.getValue();
            if (value instanceof String) {
                value = ((String)value).replace(JSON_ESCAPE_DOUBLE_QUOTE, "\"");
                ret = (String)ret + JSON_ESCAPE_DOUBLE_QUOTE + key + "\\\": \\\"" + value + JSON_ESCAPE_DOUBLE_QUOTE;
            } else if (value instanceof Integer) {
                ret = (String)ret + JSON_ESCAPE_DOUBLE_QUOTE + key + "\\\": " + value;
            } else if (value instanceof LinkedHashMap) {
                String in = (String)ret + JSON_ESCAPE_DOUBLE_QUOTE + key + "\\\": ";
                ret = this.traverseMap((LinkedHashMap)value, in);
            } else {
                this.LOGGER.warn("Value type unrecognised: " + value.getClass());
            }
            if (counter < numVars) {
                ret = (String)ret + ",\\n ";
            }
            ++counter;
        }
        ret = (String)ret + "\\n}";
        return ret;
    }

    public String getPostmanType(CodegenProperty codegenProperty) {
        if (codegenProperty.isNumeric) {
            return "number";
        }
        if (codegenProperty.isDate) {
            return "date";
        }
        return "string";
    }

    class PostmanVariable {
        private String name;
        private String type;
        private String defaultValue;

        PostmanVariable() {
        }

        public PostmanVariable addName(String name) {
            this.name = name;
            return this;
        }

        public PostmanVariable addType(String type) {
            this.type = type;
            return this;
        }

        public PostmanVariable addeDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PostmanVariable that = (PostmanVariable)o;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public String toString() {
            return "PostmanVariable{name='" + this.name + "', type='" + this.type + "', defaultValue='" + this.defaultValue + "'}";
        }
    }

    public class PostmanRequestItem {
        private String name;
        private String body;

        public PostmanRequestItem() {
        }

        public PostmanRequestItem(String name, String body) {
            this.name = name;
            this.body = body;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getBody() {
            return this.body;
        }

        public void setBody(String body) {
            this.body = body;
        }
    }
}

