/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenMediaType;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenSecurity;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractPythonCodegen;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.ProcessUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonClientCodegen
extends AbstractPythonCodegen
implements CodegenConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(PythonClientCodegen.class);
    public static final String PACKAGE_URL = "packageUrl";
    public static final String DEFAULT_LIBRARY = "urllib3";
    public static final String RECURSION_LIMIT = "recursionLimit";
    public static final String DATETIME_FORMAT = "datetimeFormat";
    public static final String DATE_FORMAT = "dateFormat";
    public static final String MAP_NUMBER_TO = "mapNumberTo";
    protected String packageUrl;
    protected String apiDocPath = "docs" + File.separator;
    protected String modelDocPath = "docs" + File.separator;
    protected boolean hasModelsToImport = Boolean.FALSE;
    protected boolean useOneOfDiscriminatorLookup = false;
    protected String datetimeFormat = "%Y-%m-%dT%H:%M:%S.%f%z";
    protected String dateFormat = "%Y-%m-%d";
    protected String mapNumberTo = "Union[StrictFloat, StrictInt]";
    protected Map<Character, String> regexModifiers;
    private String testFolder;
    private HashMap<String, HashSet<String>> circularImports = new HashMap();
    private HashMap<String, CodegenModel> codegenModelMap = new HashMap();

    public PythonClientCodegen() {
        this.sortParamsByRequiredFlag = true;
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML, WireFormatFeature.Custom)).includeSecurityFeatures(new SecurityFeature[]{SecurityFeature.SignatureAuth}).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).includeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism, SchemaSupportFeature.allOf, SchemaSupportFeature.oneOf, SchemaSupportFeature.anyOf}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}));
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.STABLE).build();
        this.importMapping.clear();
        this.typeMapping.put("array", "List");
        this.typeMapping.put("set", "List");
        this.typeMapping.put("map", "Dict");
        this.typeMapping.put("decimal", "decimal.Decimal");
        this.typeMapping.put("file", "bytearray");
        this.typeMapping.put("binary", "bytearray");
        this.typeMapping.put("ByteArray", "bytearray");
        this.languageSpecificPrimitives.remove("file");
        this.languageSpecificPrimitives.add("decimal.Decimal");
        this.languageSpecificPrimitives.add("bytearray");
        this.languageSpecificPrimitives.add("none_type");
        this.supportsInheritance = true;
        this.modelPackage = "models";
        this.apiPackage = "api";
        this.outputFolder = "generated-code" + File.separatorChar + "python";
        this.modelTemplateFiles.put("model.mustache", ".py");
        this.apiTemplateFiles.put("api.mustache", ".py");
        this.modelTestTemplateFiles.put("model_test.mustache", ".py");
        this.apiTestTemplateFiles.put("api_test.mustache", ".py");
        this.templateDir = "python";
        this.embeddedTemplateDir = "python";
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.testFolder = "test";
        this.hideGenerationTimestamp = Boolean.TRUE;
        this.setReservedWordsLowerCase(Arrays.asList("schema", "base64", "json", "date", "property", "and", "del", "from", "not", "while", "as", "elif", "global", "or", "with", "assert", "else", "if", "pass", "yield", "break", "except", "import", "print", "class", "exec", "in", "raise", "continue", "finally", "is", "return", "def", "for", "lambda", "try", "self", "nonlocal", "None", "True", "False", "async", "await"));
        this.regexModifiers = new HashMap<Character, String>();
        this.regexModifiers.put(Character.valueOf('i'), "IGNORECASE");
        this.regexModifiers.put(Character.valueOf('l'), "LOCALE");
        this.regexModifiers.put(Character.valueOf('m'), "MULTILINE");
        this.regexModifiers.put(Character.valueOf('s'), "DOTALL");
        this.regexModifiers.put(Character.valueOf('u'), "UNICODE");
        this.regexModifiers.put(Character.valueOf('x'), "VERBOSE");
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption("packageName", "python package name (convention: snake_case).").defaultValue("openapi_client"));
        this.cliOptions.add(new CliOption("projectName", "python project name in setup.py (e.g. petstore-api)."));
        this.cliOptions.add(new CliOption("packageVersion", "python package version.").defaultValue("1.0.0"));
        this.cliOptions.add(new CliOption(PACKAGE_URL, "python package URL."));
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "Hides the generation timestamp when files are generated.").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(new CliOption("generateSourceCodeOnly", "Specifies that only a library source code is to be generated.").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption(RECURSION_LIMIT, "Set the recursion limit. If not set, use the system default value."));
        this.cliOptions.add(new CliOption(MAP_NUMBER_TO, "Map number to Union[StrictFloat, StrictInt], StrictStr or float.").defaultValue("Union[StrictFloat, StrictInt]"));
        this.cliOptions.add(new CliOption(DATETIME_FORMAT, "datetime format for query parameters").defaultValue("%Y-%m-%dT%H:%M:%S%z"));
        this.cliOptions.add(new CliOption(DATE_FORMAT, "date format for query parameters").defaultValue("%Y-%m-%d"));
        this.supportedLibraries.put(DEFAULT_LIBRARY, "urllib3-based client");
        this.supportedLibraries.put("asyncio", "asyncio-based client");
        this.supportedLibraries.put("tornado", "tornado-based client (deprecated)");
        CliOption libraryOption = new CliOption("library", "library template (sub-template) to use: asyncio, tornado (deprecated), urllib3");
        libraryOption.setDefault(DEFAULT_LIBRARY);
        this.cliOptions.add(libraryOption);
        this.setLibrary(DEFAULT_LIBRARY);
        CliOption disallowAdditionalPropertiesIfNotPresentOpt = CliOption.newBoolean("disallowAdditionalPropertiesIfNotPresent", "If false, the 'additionalProperties' implementation (set to true by default) is compliant with the OAS and JSON schema specifications. If true (default), keep the old (incorrect) behaviour that 'additionalProperties' is set to false by default.").defaultValue(Boolean.TRUE.toString());
        HashMap<String, String> disallowAdditionalPropertiesIfNotPresentOpts = new HashMap<String, String>();
        disallowAdditionalPropertiesIfNotPresentOpts.put("false", "The 'additionalProperties' implementation is compliant with the OAS and JSON schema specifications.");
        disallowAdditionalPropertiesIfNotPresentOpts.put("true", "Keep the old (incorrect) behaviour that 'additionalProperties' is set to false by default.");
        disallowAdditionalPropertiesIfNotPresentOpt.setEnum(disallowAdditionalPropertiesIfNotPresentOpts);
        this.cliOptions.add(disallowAdditionalPropertiesIfNotPresentOpt);
        this.setDisallowAdditionalPropertiesIfNotPresent(true);
    }

    @Override
    public void processOpts() {
        this.setLegacyDiscriminatorBehavior(false);
        super.processOpts();
        this.specialCharReplacements.put(".", "Dot");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)System.getenv("PYTHON_POST_PROCESS_FILE"))) {
            this.LOGGER.info("Environment variable PYTHON_POST_PROCESS_FILE not defined so the Python code may not be properly formatted. To define it, try 'export PYTHON_POST_PROCESS_FILE=\"/usr/local/bin/yapf -i\"' (Linux/Mac)");
            this.LOGGER.info("NOTE: To enable file post-processing, 'enablePostProcessFile' must be set to `true` (--enable-post-process-file for CLI).");
        }
        Boolean excludeTests = false;
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        }
        if (this.additionalProperties.containsKey("projectName")) {
            this.setProjectName((String)this.additionalProperties.get("projectName"));
        } else {
            this.setProjectName(this.packageName.replaceAll("_", "-"));
        }
        if (this.additionalProperties.containsKey("packageVersion")) {
            this.setPackageVersion((String)this.additionalProperties.get("packageVersion"));
        }
        this.additionalProperties.put("projectName", this.projectName);
        this.additionalProperties.put("packageName", this.packageName);
        this.additionalProperties.put("packageVersion", this.packageVersion);
        if (this.additionalProperties.containsKey("excludeTests")) {
            excludeTests = Boolean.valueOf(this.additionalProperties.get("excludeTests").toString());
        }
        Boolean generateSourceCodeOnly = false;
        if (this.additionalProperties.containsKey("generateSourceCodeOnly")) {
            generateSourceCodeOnly = Boolean.valueOf(this.additionalProperties.get("generateSourceCodeOnly").toString());
        }
        if (generateSourceCodeOnly.booleanValue()) {
            this.testFolder = this.packagePath() + File.separatorChar + this.testFolder;
            this.apiDocPath = this.packagePath() + File.separatorChar + this.apiDocPath;
            this.modelDocPath = this.packagePath() + File.separatorChar + this.modelDocPath;
        }
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        if (this.additionalProperties.containsKey(PACKAGE_URL)) {
            this.setPackageUrl((String)this.additionalProperties.get(PACKAGE_URL));
        }
        if (this.additionalProperties.containsKey(RECURSION_LIMIT)) {
            try {
                Integer.parseInt((String)this.additionalProperties.get(RECURSION_LIMIT));
            }
            catch (NullPointerException | NumberFormatException e) {
                throw new IllegalArgumentException("recursionLimit must be an integer, e.g. 2000.");
            }
        }
        if (this.additionalProperties.containsKey("useOneOfDiscriminatorLookup")) {
            this.setUseOneOfDiscriminatorLookup(this.convertPropertyToBooleanAndWriteBack("useOneOfDiscriminatorLookup"));
        } else {
            this.additionalProperties.put("useOneOfDiscriminatorLookup", this.useOneOfDiscriminatorLookup);
        }
        if (this.additionalProperties.containsKey(MAP_NUMBER_TO)) {
            this.setMapNumberTo(String.valueOf(this.additionalProperties.get(MAP_NUMBER_TO)));
        }
        if (this.additionalProperties.containsKey(DATETIME_FORMAT)) {
            this.setDatetimeFormat((String)this.additionalProperties.get(DATETIME_FORMAT));
        } else {
            this.additionalProperties.put(DATETIME_FORMAT, this.datetimeFormat);
        }
        if (this.additionalProperties.containsKey(DATE_FORMAT)) {
            this.setDateFormat((String)this.additionalProperties.get(DATE_FORMAT));
        } else {
            this.additionalProperties.put(DATE_FORMAT, this.dateFormat);
        }
        String modelPath = this.packagePath() + File.separatorChar + this.modelPackage.replace('.', File.separatorChar);
        String apiPath = this.packagePath() + File.separatorChar + this.apiPackage.replace('.', File.separatorChar);
        Object readmePath = "README.md";
        String readmeTemplate = "README.mustache";
        if (generateSourceCodeOnly.booleanValue()) {
            readmePath = this.packagePath() + "_" + (String)readmePath;
            readmeTemplate = "README_onlypackage.mustache";
        }
        this.supportingFiles.add(new SupportingFile(readmeTemplate, "", (String)readmePath));
        if (!generateSourceCodeOnly.booleanValue()) {
            this.supportingFiles.add(new SupportingFile("tox.mustache", "", "tox.ini"));
            this.supportingFiles.add(new SupportingFile("test-requirements.mustache", "", "test-requirements.txt"));
            this.supportingFiles.add(new SupportingFile("requirements.mustache", "", "requirements.txt"));
            this.supportingFiles.add(new SupportingFile("setup_cfg.mustache", "", "setup.cfg"));
            this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
            this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
            this.supportingFiles.add(new SupportingFile("travis.mustache", "", ".travis.yml"));
            this.supportingFiles.add(new SupportingFile("github-workflow.mustache", ".github/workflows", "python.yml"));
            this.supportingFiles.add(new SupportingFile("gitlab-ci.mustache", "", ".gitlab-ci.yml"));
            this.supportingFiles.add(new SupportingFile("setup.mustache", "", "setup.py"));
            this.supportingFiles.add(new SupportingFile("pyproject.mustache", "", "pyproject.toml"));
            this.supportingFiles.add(new SupportingFile("py.typed.mustache", this.packagePath(), "py.typed"));
        }
        this.supportingFiles.add(new SupportingFile("configuration.mustache", this.packagePath(), "configuration.py"));
        this.supportingFiles.add(new SupportingFile("__init__package.mustache", this.packagePath(), "__init__.py"));
        this.supportingFiles.add(new SupportingFile("__init__model.mustache", modelPath, "__init__.py"));
        this.supportingFiles.add(new SupportingFile("__init__api.mustache", apiPath, "__init__.py"));
        Map securitySchemeMap = this.openAPI != null ? (this.openAPI.getComponents() != null ? this.openAPI.getComponents().getSecuritySchemes() : null) : null;
        List<CodegenSecurity> authMethods = this.fromSecurity(securitySchemeMap);
        if (ProcessUtils.hasHttpSignatureMethods(authMethods)) {
            this.supportingFiles.add(new SupportingFile("signing.mustache", this.packagePath(), "signing.py"));
        }
        String[] packageNameSplits = this.packageName.split("\\.");
        Object currentPackagePath = "";
        for (int i = 0; i < packageNameSplits.length - 1; ++i) {
            if (i > 0) {
                currentPackagePath = (String)currentPackagePath + File.separatorChar;
            }
            currentPackagePath = (String)currentPackagePath + packageNameSplits[i];
            this.supportingFiles.add(new SupportingFile("__init__.mustache", (String)currentPackagePath, "__init__.py"));
        }
        this.supportingFiles.add(new SupportingFile("exceptions.mustache", this.packagePath(), "exceptions.py"));
        if (Boolean.FALSE.equals(excludeTests)) {
            this.supportingFiles.add(new SupportingFile("__init__.mustache", this.testFolder, "__init__.py"));
        }
        this.supportingFiles.add(new SupportingFile("api_client.mustache", this.packagePath(), "api_client.py"));
        this.supportingFiles.add(new SupportingFile("api_response.mustache", this.packagePath(), "api_response.py"));
        if ("asyncio".equals(this.getLibrary())) {
            this.supportingFiles.add(new SupportingFile("asyncio/rest.mustache", this.packagePath(), "rest.py"));
            this.additionalProperties.put("asyncio", "true");
        } else if ("tornado".equals(this.getLibrary())) {
            this.supportingFiles.add(new SupportingFile("tornado/rest.mustache", this.packagePath(), "rest.py"));
            this.additionalProperties.put("tornado", "true");
        } else {
            this.supportingFiles.add(new SupportingFile("rest.mustache", this.packagePath(), "rest.py"));
        }
        this.modelPackage = this.packageName + "." + this.modelPackage;
        this.apiPackage = this.packageName + "." + this.apiPackage;
    }

    public void setUseOneOfDiscriminatorLookup(boolean useOneOfDiscriminatorLookup) {
        this.useOneOfDiscriminatorLookup = useOneOfDiscriminatorLookup;
    }

    public boolean getUseOneOfDiscriminatorLookup() {
        return this.useOneOfDiscriminatorLookup;
    }

    @Override
    public String toModelImport(String name) {
        Object modelImport;
        if (org.apache.commons.lang3.StringUtils.startsWithAny((CharSequence)name, (CharSequence[])new CharSequence[]{"import", "from"})) {
            modelImport = name;
        } else {
            modelImport = "from ";
            if (!"".equals(this.modelPackage())) {
                modelImport = (String)modelImport + this.modelPackage() + ".";
            }
            modelImport = (String)modelImport + this.toModelFilename(name) + " import " + name;
        }
        return modelImport;
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return this.getSchemaType(p) + "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = this.getAdditionalProperties(p);
            return this.getSchemaType(p) + "[str, " + this.getTypeDeclaration(inner) + "]";
        }
        return super.getTypeDeclaration(p);
    }

    private String getPydanticType(CodegenParameter cp, Set<String> typingImports, Set<String> pydanticImports, Set<String> datetimeImports, Set<String> modelImports, Set<String> exampleImports, String classname) {
        if (cp == null) {
            this.LOGGER.warn("Codegen property is null (e.g. map/dict of undefined type). Default to typing.Any.");
            typingImports.add("Any");
            return "Any";
        }
        if (cp.isArray) {
            Object constraints = "";
            if (cp.maxItems != null) {
                constraints = (String)constraints + String.format(Locale.ROOT, ", max_items=%d", cp.maxItems);
            }
            if (cp.minItems != null) {
                constraints = (String)constraints + String.format(Locale.ROOT, ", min_items=%d", cp.minItems);
            }
            if (cp.getUniqueItems()) {
                constraints = (String)constraints + ", unique_items=True";
            }
            pydanticImports.add("conlist");
            return String.format(Locale.ROOT, "conlist(%s%s)", this.getPydanticType(cp.items, typingImports, pydanticImports, datetimeImports, modelImports, exampleImports, classname), constraints);
        }
        if (cp.isMap) {
            typingImports.add("Dict");
            return String.format(Locale.ROOT, "Dict[str, %s]", this.getPydanticType(cp.items, typingImports, pydanticImports, datetimeImports, modelImports, exampleImports, classname));
        }
        if (cp.isString) {
            if (cp.hasValidation) {
                ArrayList<Object> fieldCustomization = new ArrayList<Object>();
                fieldCustomization.add("strict=True");
                if (cp.getMaxLength() != null) {
                    fieldCustomization.add("max_length=" + cp.getMaxLength());
                }
                if (cp.getMinLength() != null) {
                    fieldCustomization.add("min_length=" + cp.getMinLength());
                }
                if (cp.getPattern() != null) {
                    pydanticImports.add("validator");
                }
                pydanticImports.add("constr");
                return String.format(Locale.ROOT, "constr(%s)", org.apache.commons.lang3.StringUtils.join(fieldCustomization, (String)", "));
            }
            if ("password".equals(cp.getFormat())) {
                pydanticImports.add("SecretStr");
                return "SecretStr";
            }
            pydanticImports.add("StrictStr");
            return "StrictStr";
        }
        if (cp.isNumber || cp.isFloat || cp.isDouble) {
            if (cp.hasValidation) {
                ArrayList<Object> fieldCustomization = new ArrayList<Object>();
                ArrayList<Object> intFieldCustomization = new ArrayList<Object>();
                if (cp.getMaximum() != null) {
                    if (cp.getExclusiveMaximum()) {
                        fieldCustomization.add("lt=" + cp.getMaximum());
                        intFieldCustomization.add("lt=" + Math.ceil(Double.valueOf(cp.getMaximum())));
                    } else {
                        fieldCustomization.add("le=" + cp.getMaximum());
                        intFieldCustomization.add("le=" + Math.floor(Double.valueOf(cp.getMaximum())));
                    }
                }
                if (cp.getMinimum() != null) {
                    if (cp.getExclusiveMinimum()) {
                        fieldCustomization.add("gt=" + cp.getMinimum());
                        intFieldCustomization.add("gt=" + Math.floor(Double.valueOf(cp.getMinimum())));
                    } else {
                        fieldCustomization.add("ge=" + cp.getMinimum());
                        intFieldCustomization.add("ge=" + Math.ceil(Double.valueOf(cp.getMinimum())));
                    }
                }
                if (cp.getMultipleOf() != null) {
                    fieldCustomization.add("multiple_of=" + cp.getMultipleOf());
                }
                if ("Union[StrictFloat, StrictInt]".equals(this.mapNumberTo)) {
                    fieldCustomization.add("strict=True");
                    intFieldCustomization.add("strict=True");
                    pydanticImports.add("confloat");
                    pydanticImports.add("conint");
                    typingImports.add("Union");
                    return String.format(Locale.ROOT, "Union[%s(%s), %s(%s)]", "confloat", org.apache.commons.lang3.StringUtils.join(fieldCustomization, (String)", "), "conint", org.apache.commons.lang3.StringUtils.join(intFieldCustomization, (String)", "));
                }
                if ("StrictFloat".equals(this.mapNumberTo)) {
                    fieldCustomization.add("strict=True");
                    pydanticImports.add("confloat");
                    return String.format(Locale.ROOT, "%s(%s)", "confloat", org.apache.commons.lang3.StringUtils.join(fieldCustomization, (String)", "));
                }
                pydanticImports.add("confloat");
                return String.format(Locale.ROOT, "%s(%s)", "confloat", org.apache.commons.lang3.StringUtils.join(fieldCustomization, (String)", "));
            }
            if ("Union[StrictFloat, StrictInt]".equals(this.mapNumberTo)) {
                typingImports.add("Union");
                pydanticImports.add("StrictFloat");
                pydanticImports.add("StrictInt");
                return "Union[StrictFloat, StrictInt]";
            }
            if ("StrictFloat".equals(this.mapNumberTo)) {
                pydanticImports.add("StrictFloat");
                return "StrictFloat";
            }
            return "float";
        }
        if (cp.isInteger || cp.isLong || cp.isShort || cp.isUnboundedInteger) {
            if (cp.hasValidation) {
                ArrayList<Object> fieldCustomization = new ArrayList<Object>();
                fieldCustomization.add("strict=True");
                if (cp.getMaximum() != null) {
                    if (cp.getExclusiveMaximum()) {
                        fieldCustomization.add("lt=" + cp.getMaximum());
                    } else {
                        fieldCustomization.add("le=" + cp.getMaximum());
                    }
                }
                if (cp.getMinimum() != null) {
                    if (cp.getExclusiveMinimum()) {
                        fieldCustomization.add("gt=" + cp.getMinimum());
                    } else {
                        fieldCustomization.add("ge=" + cp.getMinimum());
                    }
                }
                if (cp.getMultipleOf() != null) {
                    fieldCustomization.add("multiple_of=" + cp.getMultipleOf());
                }
                pydanticImports.add("conint");
                return String.format(Locale.ROOT, "%s(%s)", "conint", org.apache.commons.lang3.StringUtils.join(fieldCustomization, (String)", "));
            }
            pydanticImports.add("StrictInt");
            return "StrictInt";
        }
        if (cp.isBinary || cp.isByteArray) {
            if (cp.hasValidation) {
                ArrayList<Object> fieldCustomization = new ArrayList<Object>();
                fieldCustomization.add("strict=True");
                if (cp.getMinLength() != null) {
                    fieldCustomization.add("min_length=" + cp.getMinLength());
                }
                if (cp.getMaxLength() != null) {
                    fieldCustomization.add("max_length=" + cp.getMaxLength());
                }
                if (cp.getPattern() != null) {
                    pydanticImports.add("validator");
                }
                pydanticImports.add("conbytes");
                pydanticImports.add("constr");
                typingImports.add("Union");
                return String.format(Locale.ROOT, "Union[conbytes(%s), constr(%<s)]", org.apache.commons.lang3.StringUtils.join(fieldCustomization, (String)", "));
            }
            pydanticImports.add("StrictBytes");
            pydanticImports.add("StrictStr");
            typingImports.add("Union");
            return "Union[StrictBytes, StrictStr]";
        }
        if (cp.isBoolean) {
            pydanticImports.add("StrictBool");
            return "StrictBool";
        }
        if (cp.isDecimal) {
            if (cp.hasValidation) {
                ArrayList<Object> fieldCustomization = new ArrayList<Object>();
                fieldCustomization.add("strict=True");
                if (cp.getMaximum() != null) {
                    if (cp.getExclusiveMaximum()) {
                        fieldCustomization.add("gt=" + cp.getMaximum());
                    } else {
                        fieldCustomization.add("ge=" + cp.getMaximum());
                    }
                }
                if (cp.getMinimum() != null) {
                    if (cp.getExclusiveMinimum()) {
                        fieldCustomization.add("lt=" + cp.getMinimum());
                    } else {
                        fieldCustomization.add("le=" + cp.getMinimum());
                    }
                }
                if (cp.getMultipleOf() != null) {
                    fieldCustomization.add("multiple_of=" + cp.getMultipleOf());
                }
                pydanticImports.add("condecimal");
                return String.format(Locale.ROOT, "%s(%s)", "condecimal", org.apache.commons.lang3.StringUtils.join(fieldCustomization, (String)", "));
            }
            pydanticImports.add("condecimal");
            return "condecimal()";
        }
        if (cp.getIsAnyType()) {
            typingImports.add("Any");
            return "Any";
        }
        if (cp.isDate || cp.isDateTime) {
            if (cp.isDate) {
                datetimeImports.add("date");
            }
            if (cp.isDateTime) {
                datetimeImports.add("datetime");
            }
            return cp.dataType;
        }
        if (cp.isUuid) {
            return cp.dataType;
        }
        if (cp.isFreeFormObject) {
            typingImports.add("Dict");
            typingImports.add("Any");
            return "Dict[str, Any]";
        }
        if (!cp.isPrimitiveType) {
            this.hasModelsToImport = true;
            modelImports.add(cp.dataType);
            exampleImports.add(cp.dataType);
            return cp.dataType;
        }
        if (cp.getContent() != null) {
            LinkedHashMap<String, CodegenMediaType> contents = cp.getContent();
            for (String key : contents.keySet()) {
                CodegenMediaType cmt = contents.get(key);
                if (cmt == null) continue;
                return this.getPydanticType(cmt.getSchema(), typingImports, pydanticImports, datetimeImports, modelImports, exampleImports, classname);
            }
            throw new RuntimeException("Error! Failed to process getPydanticType when getting the content: " + cp);
        }
        throw new RuntimeException("Error! Codegen Parameter not yet supported in getPydanticType: " + cp);
    }

    private String getPydanticType(CodegenProperty cp, Set<String> typingImports, Set<String> pydanticImports, Set<String> datetimeImports, Set<String> modelImports, Set<String> exampleImports, String classname) {
        if (cp == null) {
            this.LOGGER.warn("Codegen property is null (e.g. map/dict of undefined type). Default to typing.Any.");
            typingImports.add("Any");
            return "Any";
        }
        if (cp.isEnum) {
            pydanticImports.add("validator");
        }
        if (cp.isArray) {
            Object constraints = "";
            if (cp.maxItems != null) {
                constraints = (String)constraints + String.format(Locale.ROOT, ", max_items=%d", cp.maxItems);
            }
            if (cp.minItems != null) {
                constraints = (String)constraints + String.format(Locale.ROOT, ", min_items=%d", cp.minItems);
            }
            if (cp.getUniqueItems()) {
                constraints = (String)constraints + ", unique_items=True";
            }
            pydanticImports.add("conlist");
            typingImports.add("List");
            return String.format(Locale.ROOT, "conlist(%s%s)", this.getPydanticType(cp.items, typingImports, pydanticImports, datetimeImports, modelImports, exampleImports, classname), constraints);
        }
        if (cp.isMap) {
            typingImports.add("Dict");
            return String.format(Locale.ROOT, "Dict[str, %s]", this.getPydanticType(cp.items, typingImports, pydanticImports, datetimeImports, modelImports, exampleImports, classname));
        }
        if (cp.isString) {
            if (cp.hasValidation) {
                ArrayList<Object> fieldCustomization = new ArrayList<Object>();
                fieldCustomization.add("strict=True");
                if (cp.getMaxLength() != null) {
                    fieldCustomization.add("max_length=" + cp.getMaxLength());
                }
                if (cp.getMinLength() != null) {
                    fieldCustomization.add("min_length=" + cp.getMinLength());
                }
                if (cp.getPattern() != null) {
                    pydanticImports.add("validator");
                }
                pydanticImports.add("constr");
                return String.format(Locale.ROOT, "constr(%s)", org.apache.commons.lang3.StringUtils.join(fieldCustomization, (String)", "));
            }
            if ("password".equals(cp.getFormat())) {
                pydanticImports.add("SecretStr");
                return "SecretStr";
            }
            pydanticImports.add("StrictStr");
            return "StrictStr";
        }
        if (cp.isNumber || cp.isFloat || cp.isDouble) {
            if (cp.hasValidation) {
                ArrayList<Object> fieldCustomization = new ArrayList<Object>();
                ArrayList<Object> intFieldCustomization = new ArrayList<Object>();
                if (cp.getMaximum() != null) {
                    if (cp.getExclusiveMaximum()) {
                        fieldCustomization.add("lt=" + cp.getMaximum());
                        intFieldCustomization.add("lt=" + (int)Math.ceil(Double.valueOf(cp.getMaximum())));
                    } else {
                        fieldCustomization.add("le=" + cp.getMaximum());
                        intFieldCustomization.add("le=" + (int)Math.floor(Double.valueOf(cp.getMaximum())));
                    }
                }
                if (cp.getMinimum() != null) {
                    if (cp.getExclusiveMinimum()) {
                        fieldCustomization.add("gt=" + cp.getMinimum());
                        intFieldCustomization.add("gt=" + (int)Math.floor(Double.valueOf(cp.getMinimum())));
                    } else {
                        fieldCustomization.add("ge=" + cp.getMinimum());
                        intFieldCustomization.add("ge=" + (int)Math.ceil(Double.valueOf(cp.getMinimum())));
                    }
                }
                if (cp.getMultipleOf() != null) {
                    fieldCustomization.add("multiple_of=" + cp.getMultipleOf());
                }
                if ("Union[StrictFloat, StrictInt]".equals(this.mapNumberTo)) {
                    fieldCustomization.add("strict=True");
                    intFieldCustomization.add("strict=True");
                    pydanticImports.add("confloat");
                    pydanticImports.add("conint");
                    typingImports.add("Union");
                    return String.format(Locale.ROOT, "Union[%s(%s), %s(%s)]", "confloat", org.apache.commons.lang3.StringUtils.join(fieldCustomization, (String)", "), "conint", org.apache.commons.lang3.StringUtils.join(intFieldCustomization, (String)", "));
                }
                if ("StrictFloat".equals(this.mapNumberTo)) {
                    fieldCustomization.add("strict=True");
                    pydanticImports.add("confloat");
                    return String.format(Locale.ROOT, "%s(%s)", "confloat", org.apache.commons.lang3.StringUtils.join(fieldCustomization, (String)", "));
                }
                pydanticImports.add("confloat");
                return String.format(Locale.ROOT, "%s(%s)", "confloat", org.apache.commons.lang3.StringUtils.join(fieldCustomization, (String)", "));
            }
            if ("Union[StrictFloat, StrictInt]".equals(this.mapNumberTo)) {
                typingImports.add("Union");
                pydanticImports.add("StrictFloat");
                pydanticImports.add("StrictInt");
                return "Union[StrictFloat, StrictInt]";
            }
            if ("StrictFloat".equals(this.mapNumberTo)) {
                pydanticImports.add("StrictFloat");
                return "StrictFloat";
            }
            return "float";
        }
        if (cp.isInteger || cp.isLong || cp.isShort || cp.isUnboundedInteger) {
            if (cp.hasValidation) {
                ArrayList<Object> fieldCustomization = new ArrayList<Object>();
                fieldCustomization.add("strict=True");
                if (cp.getMaximum() != null) {
                    if (cp.getExclusiveMaximum()) {
                        fieldCustomization.add("lt=" + cp.getMaximum());
                    } else {
                        fieldCustomization.add("le=" + cp.getMaximum());
                    }
                }
                if (cp.getMinimum() != null) {
                    if (cp.getExclusiveMinimum()) {
                        fieldCustomization.add("gt=" + cp.getMinimum());
                    } else {
                        fieldCustomization.add("ge=" + cp.getMinimum());
                    }
                }
                if (cp.getMultipleOf() != null) {
                    fieldCustomization.add("multiple_of=" + cp.getMultipleOf());
                }
                pydanticImports.add("conint");
                return String.format(Locale.ROOT, "%s(%s)", "conint", org.apache.commons.lang3.StringUtils.join(fieldCustomization, (String)", "));
            }
            pydanticImports.add("StrictInt");
            return "StrictInt";
        }
        if (cp.isBinary || cp.isByteArray) {
            if (cp.hasValidation) {
                ArrayList<Object> fieldCustomization = new ArrayList<Object>();
                fieldCustomization.add("strict=True");
                if (cp.getMinLength() != null) {
                    fieldCustomization.add("min_length=" + cp.getMinLength());
                }
                if (cp.getMaxLength() != null) {
                    fieldCustomization.add("max_length=" + cp.getMaxLength());
                }
                if (cp.getPattern() != null) {
                    pydanticImports.add("validator");
                }
                pydanticImports.add("conbytes");
                pydanticImports.add("constr");
                typingImports.add("Union");
                return String.format(Locale.ROOT, "Union[conbytes(%s), constr(%<s)]", org.apache.commons.lang3.StringUtils.join(fieldCustomization, (String)", "));
            }
            pydanticImports.add("StrictBytes");
            pydanticImports.add("StrictStr");
            typingImports.add("Union");
            return "Union[StrictBytes, StrictStr]";
        }
        if (cp.isBoolean) {
            pydanticImports.add("StrictBool");
            return "StrictBool";
        }
        if (cp.isDecimal) {
            if (cp.hasValidation) {
                ArrayList<Object> fieldCustomization = new ArrayList<Object>();
                fieldCustomization.add("strict=True");
                if (cp.getMaximum() != null) {
                    if (cp.getExclusiveMaximum()) {
                        fieldCustomization.add("gt=" + cp.getMaximum());
                    } else {
                        fieldCustomization.add("ge=" + cp.getMaximum());
                    }
                }
                if (cp.getMinimum() != null) {
                    if (cp.getExclusiveMinimum()) {
                        fieldCustomization.add("lt=" + cp.getMinimum());
                    } else {
                        fieldCustomization.add("le=" + cp.getMinimum());
                    }
                }
                if (cp.getMultipleOf() != null) {
                    fieldCustomization.add("multiple_of=" + cp.getMultipleOf());
                }
                pydanticImports.add("condecimal");
                return String.format(Locale.ROOT, "%s(%s)", "condecimal", org.apache.commons.lang3.StringUtils.join(fieldCustomization, (String)", "));
            }
            pydanticImports.add("condecimal");
            return "condecimal()";
        }
        if (cp.getIsAnyType()) {
            typingImports.add("Any");
            return "Any";
        }
        if (cp.isDate || cp.isDateTime) {
            if (cp.isDate) {
                datetimeImports.add("date");
            }
            if (cp.isDateTime) {
                datetimeImports.add("datetime");
            }
            return cp.dataType;
        }
        if (cp.isUuid) {
            return cp.dataType;
        }
        if (cp.isFreeFormObject) {
            typingImports.add("Dict");
            typingImports.add("Any");
            return "Dict[str, Any]";
        }
        if (!cp.isPrimitiveType || cp.isModel) {
            if (classname == null) {
                this.hasModelsToImport = true;
                modelImports.add(cp.dataType);
                exampleImports.add(cp.dataType);
            } else if (this.circularImports.containsKey(cp.dataType)) {
                if (this.circularImports.get(cp.dataType).contains(classname)) {
                    this.LOGGER.debug("Skipped importing {} in {} due to circular import.", (Object)cp.dataType, (Object)classname);
                } else {
                    this.hasModelsToImport = true;
                    modelImports.add(cp.dataType);
                    exampleImports.add(cp.dataType);
                }
            } else {
                this.LOGGER.error("Failed to look up {} from the imports (map of set) of models.", (Object)cp.dataType);
            }
            return cp.dataType;
        }
        throw new RuntimeException("Error! Codegen Property not yet supported in getPydanticType: " + cp);
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        HashMap<String, String> item;
        this.hasModelsToImport = false;
        TreeSet<String> typingImports = new TreeSet<String>();
        TreeSet<String> pydanticImports = new TreeSet<String>();
        TreeSet<String> datetimeImports = new TreeSet<String>();
        TreeSet<String> modelImports = new TreeSet<String>();
        OperationMap objectMap = objs.getOperations();
        List<CodegenOperation> operations = objectMap.getOperation();
        for (CodegenOperation operation : operations) {
            TreeSet<String> exampleImports = new TreeSet<String>();
            List<CodegenParameter> params = operation.allParams;
            for (CodegenParameter param : params) {
                Object typing = this.getPydanticType(param, typingImports, pydanticImports, datetimeImports, modelImports, exampleImports, null);
                ArrayList<String> fields = new ArrayList<String>();
                String firstField = "";
                if (!param.required) {
                    firstField = "None";
                    typing = "Optional[" + (String)typing + "]";
                    typingImports.add("Optional");
                } else {
                    firstField = "...";
                    if (param.isNullable) {
                        typing = "Optional[" + (String)typing + "]";
                        typingImports.add("Optional");
                    }
                }
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)param.description)) {
                    fields.add(String.format(Locale.ROOT, "description=\"%s\"", param.description));
                }
                String fieldCustomization = "None".equals(firstField) ? null : firstField;
                if (!fields.isEmpty()) {
                    if (fieldCustomization != null) {
                        fields.add(0, fieldCustomization);
                    }
                    pydanticImports.add("Field");
                    fieldCustomization = String.format(Locale.ROOT, "Field(%s)", org.apache.commons.lang3.StringUtils.join(fields, (String)", "));
                } else {
                    fieldCustomization = "Field()";
                }
                if ("Field()".equals(fieldCustomization)) {
                    param.vendorExtensions.put("x-py-typing", typing);
                    continue;
                }
                param.vendorExtensions.put("x-py-typing", String.format(Locale.ROOT, "Annotated[%s, %s]", typing, fieldCustomization));
            }
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operation.returnType)) {
                String string = this.getPydanticType(operation.returnProperty, typingImports, new TreeSet<String>(), datetimeImports, modelImports, exampleImports, null);
            }
            if (exampleImports.isEmpty()) continue;
            ArrayList<CallSite> imports = new ArrayList<CallSite>();
            for (String exampleImport : exampleImports) {
                imports.add((CallSite)((Object)("from " + this.packageName + ".models." + StringUtils.underscore(exampleImport) + " import " + exampleImport)));
            }
            operation.vendorExtensions.put("x-py-example-import", imports);
        }
        ArrayList<Map<String, String>> newImports = new ArrayList<Map<String, String>>();
        if (!datetimeImports.isEmpty()) {
            item = new HashMap<String, String>();
            item.put("import", String.format(Locale.ROOT, "from datetime import %s\n", org.apache.commons.lang3.StringUtils.join(datetimeImports, (String)", ")));
            newImports.add(item);
        }
        if (!pydanticImports.isEmpty()) {
            item = new HashMap();
            item.put("import", String.format(Locale.ROOT, "from pydantic import %s\n", org.apache.commons.lang3.StringUtils.join(pydanticImports, (String)", ")));
            newImports.add(item);
        }
        if (!typingImports.isEmpty()) {
            item = new HashMap();
            item.put("import", String.format(Locale.ROOT, "from typing import %s\n", org.apache.commons.lang3.StringUtils.join(typingImports, (String)", ")));
            newImports.add(item);
        }
        if (!modelImports.isEmpty()) {
            for (String modelImport : modelImports) {
                HashMap<String, CallSite> item2 = new HashMap<String, CallSite>();
                item2.put("import", (CallSite)((Object)("from " + this.packageName + ".models." + StringUtils.underscore(modelImport) + " import " + modelImport)));
                newImports.add(item2);
            }
        }
        objs.setImports(newImports);
        return objs;
    }

    @Override
    public Map<String, ModelsMap> postProcessAllModels(Map<String, ModelsMap> objs) {
        Map<String, ModelsMap> processed = super.postProcessAllModels(objs);
        for (Map.Entry<String, ModelsMap> entry : objs.entrySet()) {
            CodegenModel cm = ModelUtils.getModelByName(entry.getKey(), objs);
            this.codegenModelMap.put(cm.classname, ModelUtils.getModelByName(entry.getKey(), objs));
        }
        for (String string : this.codegenModelMap.keySet()) {
            this.createImportMapOfSet(string, this.codegenModelMap);
        }
        for (Map.Entry entry : processed.entrySet()) {
            entry.setValue(this.postProcessModelsMap((ModelsMap)entry.getValue()));
        }
        return processed;
    }

    void createImportMapOfSet(String modelName, Map<String, CodegenModel> codegenModelMap) {
        HashSet<String> imports = new HashSet<String>();
        this.circularImports.put(modelName, imports);
        CodegenModel cm = codegenModelMap.get(modelName);
        if (cm == null) {
            this.LOGGER.warn("Failed to lookup model in createImportMapOfSet: " + modelName);
            return;
        }
        List<CodegenProperty> codegenProperties = null;
        codegenProperties = cm.oneOf != null && !cm.oneOf.isEmpty() ? cm.getComposedSchemas().getOneOf() : (cm.anyOf != null && !cm.anyOf.isEmpty() ? cm.getComposedSchemas().getAnyOf() : cm.vars);
        for (CodegenProperty cp : codegenProperties) {
            String modelNameFromDataType = this.getModelNameFromDataType(cp);
            if (modelNameFromDataType == null) continue;
            imports.add(modelNameFromDataType);
            this.updateImportsFromCodegenModel(modelNameFromDataType, codegenModelMap.get(modelNameFromDataType), imports);
        }
    }

    public void updateImportsFromCodegenModel(String modelName, CodegenModel cm, Set<String> imports) {
        if (cm == null) {
            this.LOGGER.warn("Failed to lookup model in createImportMapOfSet " + modelName);
            return;
        }
        List<CodegenProperty> codegenProperties = null;
        codegenProperties = cm.oneOf != null && !cm.oneOf.isEmpty() ? cm.getComposedSchemas().getOneOf() : (cm.anyOf != null && !cm.anyOf.isEmpty() ? cm.getComposedSchemas().getAnyOf() : cm.vars);
        for (CodegenProperty cp : codegenProperties) {
            String modelNameFromDataType = this.getModelNameFromDataType(cp);
            if (modelNameFromDataType == null || modelName.equals(modelNameFromDataType) || imports.contains(modelNameFromDataType)) continue;
            imports.add(modelNameFromDataType);
            this.updateImportsFromCodegenModel(modelNameFromDataType, this.codegenModelMap.get(modelNameFromDataType), imports);
        }
    }

    private String getModelNameFromDataType(CodegenProperty cp) {
        if (cp.isArray) {
            return this.getModelNameFromDataType(cp.items);
        }
        if (cp.isMap) {
            return this.getModelNameFromDataType(cp.items);
        }
        if (!cp.isPrimitiveType || cp.isModel) {
            return cp.dataType;
        }
        return null;
    }

    private ModelsMap postProcessModelsMap(ModelsMap objs) {
        objs = this.postProcessModelsEnum(objs);
        TreeSet<String> typingImports = new TreeSet<String>();
        TreeSet<String> pydanticImports = new TreeSet<String>();
        TreeSet<String> datetimeImports = new TreeSet<String>();
        TreeSet<String> modelImports = new TreeSet<String>();
        for (ModelMap m : objs.getModels()) {
            TreeSet<String> exampleImports = new TreeSet<String>();
            ArrayList<String> readOnlyFields = new ArrayList<String>();
            this.hasModelsToImport = false;
            int property_count = 1;
            typingImports.clear();
            pydanticImports.clear();
            datetimeImports.clear();
            CodegenModel model = m.getModel();
            if (model.getComposedSchemas() != null && model.getComposedSchemas().getOneOf() != null && !model.getComposedSchemas().getOneOf().isEmpty()) {
                int index = 0;
                Iterator oneOfs = model.getComposedSchemas().getOneOf();
                Iterator<Object> iterator = oneOfs.iterator();
                while (iterator.hasNext()) {
                    CodegenProperty oneOf = iterator.next();
                    if ("none_type".equals(oneOf.dataType)) {
                        oneOfs.remove(index);
                        break;
                    }
                    ++index;
                }
            }
            List<CodegenProperty> codegenProperties = null;
            if (!model.oneOf.isEmpty()) {
                codegenProperties = model.getComposedSchemas().getOneOf();
                typingImports.add("Any");
                typingImports.add("List");
                pydanticImports.add("Field");
                pydanticImports.add("StrictStr");
                pydanticImports.add("ValidationError");
                pydanticImports.add("validator");
            } else if (!model.anyOf.isEmpty()) {
                codegenProperties = model.getComposedSchemas().getAnyOf();
                pydanticImports.add("Field");
                pydanticImports.add("StrictStr");
                pydanticImports.add("ValidationError");
                pydanticImports.add("validator");
            } else {
                codegenProperties = model.vars;
            }
            for (CodegenProperty cp : codegenProperties) {
                Object typing = this.getPydanticType(cp, typingImports, pydanticImports, datetimeImports, modelImports, exampleImports, model.classname);
                ArrayList<String> fields = new ArrayList<String>();
                String firstField = "";
                if (cp.isReadOnly) {
                    readOnlyFields.add(cp.name);
                }
                if (!cp.required) {
                    firstField = "None";
                    typing = "Optional[" + (String)typing + "]";
                    typingImports.add("Optional");
                } else {
                    firstField = "...";
                    if (cp.isNullable) {
                        typing = "Optional[" + (String)typing + "]";
                        typingImports.add("Optional");
                    }
                }
                if (cp.baseName != null && !cp.baseName.equals(cp.name)) {
                    fields.add(String.format(Locale.ROOT, "alias=\"%s\"", cp.baseName));
                }
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)cp.description)) {
                    fields.add(String.format(Locale.ROOT, "description=\"%s\"", cp.description));
                }
                String fieldCustomization = "None".equals(firstField) ? (cp.defaultValue == null ? "None" : (cp.isArray || cp.isMap ? "None" : cp.defaultValue)) : firstField;
                if (!fields.isEmpty()) {
                    fields.add(0, fieldCustomization);
                    pydanticImports.add("Field");
                    fieldCustomization = String.format(Locale.ROOT, "Field(%s)", org.apache.commons.lang3.StringUtils.join(fields, (String)", "));
                }
                if ("...".equals(fieldCustomization)) {
                    pydanticImports.add("Field");
                    fieldCustomization = "Field(...)";
                }
                cp.vendorExtensions.put("x-py-typing", (String)typing + " = " + fieldCustomization);
                if (!model.oneOf.isEmpty()) {
                    cp.vendorExtensions.put("x-py-name", String.format(Locale.ROOT, "oneof_schema_%d_validator", property_count++));
                    continue;
                }
                if (model.anyOf.isEmpty()) continue;
                cp.vendorExtensions.put("x-py-name", String.format(Locale.ROOT, "anyof_schema_%d_validator", property_count++));
            }
            if (!model.isEnum) {
                pydanticImports.add("BaseModel");
            }
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)model.parent)) {
                modelImports.add(model.parent);
            }
            if (model.isEnum) {
                for (Map enumVars : (List)model.getAllowableValues().get("enumVars")) {
                    if (((Boolean)enumVars.get("isString")).booleanValue()) {
                        model.vendorExtensions.putIfAbsent("x-py-enum-type", "str");
                        enumVars.put("name", this.toEnumVariableName((String)enumVars.get("value"), "str"));
                        continue;
                    }
                    model.vendorExtensions.putIfAbsent("x-py-enum-type", "int");
                    enumVars.put("name", this.toEnumVariableName((String)enumVars.get("value"), "int"));
                }
            }
            model.getVendorExtensions().putIfAbsent("x-py-typing-imports", typingImports);
            model.getVendorExtensions().putIfAbsent("x-py-pydantic-imports", pydanticImports);
            model.getVendorExtensions().putIfAbsent("x-py-datetime-imports", datetimeImports);
            model.getVendorExtensions().putIfAbsent("x-py-readonly", readOnlyFields);
            if (modelImports.isEmpty()) continue;
            TreeSet<CallSite> modelsToImport = new TreeSet<CallSite>();
            for (String modelImport : modelImports) {
                if (modelImport.equals(model.classname)) continue;
                modelsToImport.add((CallSite)((Object)("from " + this.packageName + ".models." + StringUtils.underscore(modelImport) + " import " + modelImport)));
            }
            model.getVendorExtensions().putIfAbsent("x-py-model-imports", modelsToImport);
        }
        return objs;
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        this.postProcessPattern(parameter.pattern, parameter.vendorExtensions);
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        this.postProcessPattern(property.pattern, property.vendorExtensions);
    }

    public void postProcessPattern(String pattern, Map<String, Object> vendorExtensions) {
        if (pattern != null) {
            int i = pattern.lastIndexOf(47);
            if (pattern.charAt(0) != '/' || i < 2) {
                throw new IllegalArgumentException("Pattern must follow the Perl /pattern/modifiers convention. " + pattern + " is not valid.");
            }
            String regex = pattern.substring(1, i).replace("'", "\\'");
            ArrayList<String> modifiers = new ArrayList<String>();
            for (char c : pattern.substring(i).toCharArray()) {
                if (!this.regexModifiers.containsKey(Character.valueOf(c))) continue;
                String modifier = this.regexModifiers.get(Character.valueOf(c));
                modifiers.add(modifier);
            }
            vendorExtensions.put("x-regex", regex.replace("\"", "\\\""));
            vendorExtensions.put("x-pattern", pattern.replace("\"", "\\\""));
            vendorExtensions.put("x-modifiers", modifiers);
        }
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "python";
    }

    @Override
    public String getHelp() {
        return "Generates a Python client library.";
    }

    @Override
    public String apiDocFileFolder() {
        return this.outputFolder + File.separator + this.apiDocPath;
    }

    @Override
    public String modelDocFileFolder() {
        return this.outputFolder + File.separator + this.modelDocPath;
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String addRegularExpressionDelimiter(String pattern) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)pattern)) {
            return pattern;
        }
        if (!pattern.matches("^/.*")) {
            return "/" + pattern.replaceAll("(?<!\\\\)\\/", "\\\\/") + "/";
        }
        return pattern;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separatorChar + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separatorChar + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + File.separatorChar + this.testFolder;
    }

    @Override
    public String modelTestFileFolder() {
        return this.outputFolder + File.separatorChar + this.testFolder;
    }

    public void setPackageUrl(String packageUrl) {
        this.packageUrl = packageUrl;
    }

    public String packagePath() {
        return this.packageName.replace('.', File.separatorChar);
    }

    public String generatePackageName(String packageName) {
        return StringUtils.underscore(packageName.replaceAll("[^\\w]+", ""));
    }

    @Override
    public String generatorLanguageVersion() {
        return "3.7+";
    }

    @Override
    protected void addAdditionPropertiesToCodeGenModel(CodegenModel codegenModel, Schema schema) {
        Schema additionalProperties = this.getAdditionalProperties(schema);
        if (additionalProperties != null) {
            codegenModel.additionalPropertiesType = this.getSchemaType(additionalProperties);
        }
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        if ("int".equals(datatype) || "float".equals(datatype)) {
            return name;
        }
        return "'" + name + "'";
    }

    public String toEnumVariableName(String name, String datatype) {
        if ("int".equals(datatype)) {
            return "NUMBER_" + ((String)name).replace("-", "MINUS_");
        }
        if (((String)(name = ((String)name).substring(1, ((String)name).length() - 1))).length() == 0) {
            return "EMPTY";
        }
        if (" ".equals(name)) {
            return "SPACE";
        }
        if ("_".equals(name)) {
            return "UNDERSCORE";
        }
        name = this.reservedWords.contains(name) ? ((String)name).toUpperCase(Locale.ROOT) : (name.chars().anyMatch(character -> this.specialCharReplacements.keySet().contains(String.valueOf((char)character))) ? StringUtils.underscore(StringUtils.escape((String)name, this.specialCharReplacements, Collections.singletonList("_"), "_")).toUpperCase(Locale.ROOT) : ((String)name).toUpperCase(Locale.ROOT));
        name = ((String)name).replace(" ", "_");
        name = ((String)name).replaceFirst("^_", "");
        if (((String)(name = ((String)name).replaceFirst("_$", ""))).matches("\\d.*")) {
            name = "ENUM_" + ((String)name).toUpperCase(Locale.ROOT);
        }
        return name;
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("int".equals(datatype) || "float".equals(datatype)) {
            return value;
        }
        return "'" + this.escapeText(value) + "'";
    }

    @Override
    public String toEnumDefaultValue(String value, String datatype) {
        return value;
    }

    @Override
    public boolean isDataTypeString(String dataType) {
        return "str".equals(dataType);
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "var_" + name;
    }

    public void setMapNumberTo(String mapNumberTo) {
        if (!("Union[StrictFloat, StrictInt]".equals(mapNumberTo) || "StrictFloat".equals(mapNumberTo) || "float".equals(mapNumberTo))) {
            throw new IllegalArgumentException("mapNumberTo value must be Union[StrictFloat, StrictInt], StrictStr or float");
        }
        this.mapNumberTo = mapNumberTo;
    }

    public void setDatetimeFormat(String datetimeFormat) {
        this.datetimeFormat = datetimeFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    @Override
    public ModelsMap postProcessModels(ModelsMap objs) {
        return this.postProcessModelsEnum(objs);
    }
}

