/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.GeneratorLanguage;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCamlClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(OCamlClientCodegen.class);
    public static final String PACKAGE_NAME = "packageName";
    public static final String PACKAGE_VERSION = "packageVersion";
    static final String X_MODEL_MODULE = "x-model-module";
    public static final String CO_HTTP = "cohttp";
    protected String packageName = "openapi";
    protected String packageVersion = "1.0.0";
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";
    protected String apiFolder = "src/apis";
    protected String modelFolder = "src/models";
    private Map<String, List<String>> enumNames = new HashMap<String, List<String>>();
    private Map<String, Schema> enumHash = new HashMap<String, Schema>();
    private Map<String, String> enumUniqNames;

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "ocaml";
    }

    @Override
    public String getHelp() {
        return "Generates an OCaml client library (beta).";
    }

    public OCamlClientCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON)).securityFeatures(EnumSet.of(SecurityFeature.ApiKey)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).includeClientModificationFeatures(new ClientModificationFeature[]{ClientModificationFeature.BasePath}));
        this.outputFolder = "generated-code/ocaml";
        this.modelTemplateFiles.put("model.mustache", ".ml");
        this.hideGenerationTimestamp = Boolean.TRUE;
        this.templateDir = "ocaml";
        this.embeddedTemplateDir = "ocaml";
        this.setReservedWordsLowerCase(Arrays.asList("and", "as", "assert", "asr", "begin", "class", "constraint", "do", "done", "downto", "else", "end", "exception", "external", "false", "for ", "fun", "function", "functor", "if", "in", "include", "inherit", "initializer", "land", "lazy", "let", "lor", "lsl", "lsr", "lxor", "match", "method", "mod", "module", "mutable", "new", "nonrec", "object", "of", "open", "or", "private", "rec", "sig", "struct", "then", "to", "true", "try", "type", "val", "virtual", "when", "while", "with", "result"));
        this.importMapping.remove("File");
        this.supportingFiles.add(new SupportingFile("dune.mustache", "", "dune"));
        this.supportingFiles.add(new SupportingFile("dune-project.mustache", "", "dune-project"));
        this.supportingFiles.add(new SupportingFile("readme.mustache", "", "README.md"));
        this.defaultIncludes = new HashSet<String>(Arrays.asList("int", "int32", "int64", "float", "bool", "char", "string", "list"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("int", "int32", "int64", "float", "bool", "char", "string", "bytes", "list", "Yojson.Safe.t"));
        this.instantiationTypes.clear();
        this.typeMapping.clear();
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("int", "int32");
        this.typeMapping.put("long", "int64");
        this.typeMapping.put("short", "int");
        this.typeMapping.put("char", "char");
        this.typeMapping.put("float", "float");
        this.typeMapping.put("double", "float");
        this.typeMapping.put("integer", "int32");
        this.typeMapping.put("number", "float");
        this.typeMapping.put("date", "string");
        this.typeMapping.put("object", "Yojson.Safe.t");
        this.typeMapping.put("any", "Yojson.Safe.t");
        this.typeMapping.put("file", "string");
        this.typeMapping.put("ByteArray", "string");
        this.typeMapping.put("string", "string");
        this.typeMapping.put("UUID", "string");
        this.typeMapping.put("URI", "string");
        this.typeMapping.put("set", "`Set");
        this.typeMapping.put("password", "string");
        this.typeMapping.put("DateTime", "string");
    }

    @Override
    public Map<String, ModelsMap> postProcessAllModels(Map<String, ModelsMap> superobjs) {
        ArrayList<String> toRemove = new ArrayList<String>();
        for (Map.Entry<String, ModelsMap> modelEntry : superobjs.entrySet()) {
            List<ModelMap> models = modelEntry.getValue().getModels();
            for (ModelMap mo : models) {
                CodegenModel cm = mo.getModel();
                if (Boolean.TRUE.equals(cm.isEnum) && cm.allowableValues != null) {
                    toRemove.add(modelEntry.getKey());
                    continue;
                }
                this.enrichPropertiesWithEnumDefaultValues(cm.getAllVars());
                this.enrichPropertiesWithEnumDefaultValues(cm.getReadOnlyVars());
                this.enrichPropertiesWithEnumDefaultValues(cm.getReadWriteVars());
                this.enrichPropertiesWithEnumDefaultValues(cm.getRequiredVars());
                this.enrichPropertiesWithEnumDefaultValues(cm.getOptionalVars());
                this.enrichPropertiesWithEnumDefaultValues(cm.getVars());
                this.enrichPropertiesWithEnumDefaultValues(cm.getParentVars());
            }
        }
        for (String keyToRemove : toRemove) {
            superobjs.remove(keyToRemove);
        }
        return superobjs;
    }

    private void enrichPropertiesWithEnumDefaultValues(List<CodegenProperty> properties) {
        for (CodegenProperty property : properties) {
            if (property.get_enum() == null || property.get_enum().size() != 1) continue;
            String value = property.get_enum().get(0);
            property.defaultValue = this.ocamlizeEnumValue(value);
        }
    }

    @Override
    protected void updateDataTypeWithEnumForMap(CodegenProperty property) {
        CodegenProperty baseItem = property.items;
        while (baseItem != null && (Boolean.TRUE.equals(baseItem.isMap) || Boolean.TRUE.equals(baseItem.isArray))) {
            baseItem = baseItem.items;
        }
        if (baseItem != null) {
            if (property.defaultValue != null) {
                property.defaultValue = property.defaultValue.replace(", " + property.items.baseType, ", " + this.toEnumName(property.items));
            }
            this.updateCodegenPropertyEnum(property);
        }
    }

    @Override
    protected void updateDataTypeWithEnumForArray(CodegenProperty property) {
        CodegenProperty baseItem = property.items;
        while (baseItem != null && (Boolean.TRUE.equals(baseItem.isMap) || Boolean.TRUE.equals(baseItem.isArray))) {
            baseItem = baseItem.items;
        }
        if (baseItem != null) {
            if (property.defaultValue != null) {
                property.defaultValue = property.defaultValue.replace(baseItem.baseType, this.toEnumName(baseItem));
            }
            this.updateCodegenPropertyEnum(property);
        }
    }

    private String hashEnum(Schema schema) {
        return schema.getEnum().stream().map(String::valueOf).collect(Collectors.joining(","));
    }

    private boolean isEnumSchema(Schema schema) {
        return schema != null && schema.getEnum() != null && !schema.getEnum().isEmpty();
    }

    private void collectEnumSchemas(String parentName, String sName, Schema schema) {
        String h;
        if (schema instanceof ArraySchema) {
            this.collectEnumSchemas(parentName, sName, ((ArraySchema)schema).getItems());
        } else if (schema instanceof MapSchema && schema.getAdditionalProperties() instanceof Schema) {
            this.collectEnumSchemas(parentName, sName, (Schema)schema.getAdditionalProperties());
        } else if (this.isEnumSchema(schema) && !this.enumHash.containsKey(h = this.hashEnum(schema))) {
            this.enumHash.put(h, schema);
            this.enumNames.computeIfAbsent(h, k -> new ArrayList()).add(sName.toLowerCase(Locale.ROOT));
            if (parentName != null) {
                this.enumNames.get(h).add((parentName + "_" + sName).toLowerCase(Locale.ROOT));
            }
        }
    }

    private void collectEnumSchemas(String sName, Schema schema) {
        this.collectEnumSchemas(null, sName, schema);
    }

    private void collectEnumSchemas(String parentName, Map<String, Schema> schemas) {
        for (Map.Entry<String, Schema> schemasEntry : schemas.entrySet()) {
            ArraySchema s;
            String pName;
            String sName = schemasEntry.getKey();
            Schema schema = schemasEntry.getValue();
            this.collectEnumSchemas(parentName, sName, schema);
            if (schema.getProperties() != null) {
                pName = parentName != null ? parentName + "_" + sName : sName;
                this.collectEnumSchemas(pName, schema.getProperties());
            }
            if (schema.getAdditionalProperties() != null && schema.getAdditionalProperties() instanceof Schema) {
                pName = parentName != null ? parentName + "_" + sName : sName;
                this.collectEnumSchemas(pName, (Schema)schema.getAdditionalProperties());
            }
            if (!(schema instanceof ArraySchema) || (s = (ArraySchema)schema).getItems() == null) continue;
            String pName2 = parentName != null ? parentName + "_" + sName : sName;
            this.collectEnumSchemas(pName2, s.getItems());
        }
    }

    private void collectEnumSchemas(Operation operation) {
        if (operation != null) {
            if (operation.getParameters() != null) {
                for (Object parameter : operation.getParameters()) {
                    this.collectEnumSchemas(parameter.getName(), parameter.getSchema());
                }
            }
            if (operation.getRequestBody() != null && operation.getRequestBody().getContent() != null) {
                Content content = operation.getRequestBody().getContent();
                for (String p : content.keySet()) {
                    this.collectEnumSchemas(p, ((MediaType)content.get((Object)p)).getSchema());
                }
            }
            if (operation.getResponses() != null) {
                for (Map.Entry operationGetResponsesEntry : operation.getResponses().entrySet()) {
                    String s = (String)operationGetResponsesEntry.getKey();
                    ApiResponse apiResponse = (ApiResponse)operationGetResponsesEntry.getValue();
                    if (apiResponse.getContent() != null) {
                        Content content = apiResponse.getContent();
                        for (String string : content.keySet()) {
                            this.collectEnumSchemas(string, ((MediaType)content.get((Object)string)).getSchema());
                        }
                    }
                    if (apiResponse.getHeaders() == null) continue;
                    Map headers = apiResponse.getHeaders();
                    for (Map.Entry entry : headers.entrySet()) {
                        String h = (String)entry.getKey();
                        Header header = (Header)entry.getValue();
                        this.collectEnumSchemas(h, header.getSchema());
                    }
                }
            }
        }
    }

    private String sanitizeOCamlTypeName(String name) {
        char c;
        int i;
        String typeName = name.replace("-", "_").replace(" ", "_").replace('.', '_').trim();
        for (i = 0; i < typeName.length() && (Character.isDigit(c = typeName.charAt(i)) || c == '_'); ++i) {
        }
        return typeName.substring(i);
    }

    private void computeEnumUniqNames() {
        HashMap<String, String> definitiveNames = new HashMap<String, String>();
        for (String h : this.enumNames.keySet()) {
            String candidate;
            boolean hasDefName = false;
            List<String> nameCandidates = this.enumNames.get(h);
            for (String name : nameCandidates) {
                String candidate2 = this.sanitizeOCamlTypeName(name);
                if (definitiveNames.containsKey(candidate2) || this.reservedWords.contains(candidate2)) continue;
                definitiveNames.put(candidate2, h);
                hasDefName = true;
                break;
            }
            if (hasDefName) continue;
            int i = 0;
            while (definitiveNames.containsKey(candidate = this.sanitizeOCamlTypeName(nameCandidates.get(0) + "_" + i))) {
                ++i;
            }
            definitiveNames.put(candidate, h);
        }
        this.enumUniqNames = definitiveNames.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }

    private void collectEnumSchemas(OpenAPI openAPI) {
        Paths paths;
        Components components = openAPI.getComponents();
        if (components != null && components.getSchemas() != null && !components.getSchemas().isEmpty()) {
            this.collectEnumSchemas(null, components.getSchemas());
        }
        if ((paths = openAPI.getPaths()) != null && !paths.isEmpty()) {
            for (Map.Entry pathsEntry : paths.entrySet()) {
                String path = (String)pathsEntry.getKey();
                PathItem item = (PathItem)pathsEntry.getValue();
                this.collectEnumSchemas(item.getGet());
                this.collectEnumSchemas(item.getPost());
                this.collectEnumSchemas(item.getPut());
                this.collectEnumSchemas(item.getDelete());
                this.collectEnumSchemas(item.getPatch());
                this.collectEnumSchemas(item.getOptions());
                this.collectEnumSchemas(item.getHead());
                this.collectEnumSchemas(item.getTrace());
            }
        }
        this.computeEnumUniqNames();
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        this.collectEnumSchemas(openAPI);
        this.supportingFiles.add(new SupportingFile("lib.mustache", "", this.packageName + ".opam"));
        this.supportingFiles.add(new SupportingFile("support.mustache", "src/support", "request.ml"));
        this.supportingFiles.add(new SupportingFile("json.mustache", "src/support", "jsonSupport.ml"));
        this.supportingFiles.add(new SupportingFile("enums.mustache", "src/support", "enums.ml"));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)System.getenv("OCAML_POST_PROCESS_FILE"))) {
            this.LOGGER.info("Hint: Environment variable 'OCAML_POST_PROCESS_FILE' (optional) not defined. E.g. to format the source code, please try 'export OCAML_POST_PROCESS_FILE=\"ocamlformat -i --enable-outside-detected-project\"' (Linux/Mac)");
            this.LOGGER.info("NOTE: To enable file post-processing, 'enablePostProcessFile' must be set to `true` (--enable-post-process-file for CLI).");
        } else if (!this.isEnablePostProcessFile()) {
            this.LOGGER.info("Warning: Environment variable 'OCAML_POST_PROCESS_FILE' is set but file post-processing is not enabled. To enable file post-processing, 'enablePostProcessFile' must be set to `true` (--enable-post-process-file for CLI).");
        }
        if (this.additionalProperties.containsKey(PACKAGE_NAME)) {
            this.setPackageName((String)this.additionalProperties.get(PACKAGE_NAME));
        } else {
            this.setPackageName("openapi");
        }
        if (this.additionalProperties.containsKey(PACKAGE_VERSION)) {
            this.setPackageVersion((String)this.additionalProperties.get(PACKAGE_VERSION));
        } else {
            this.setPackageVersion("1.0.0");
        }
        this.additionalProperties.put(PACKAGE_NAME, this.packageName);
        this.additionalProperties.put(PACKAGE_VERSION, this.packageVersion);
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        this.apiTemplateFiles.put("api-impl.mustache", ".ml");
        this.apiTemplateFiles.put("api-intf.mustache", ".mli");
        this.modelPackage = this.packageName;
        this.apiPackage = this.packageName;
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return (this.outputFolder + File.separator + this.apiFolder).replace("/", File.separator);
    }

    @Override
    public String modelFileFolder() {
        return (this.outputFolder + File.separator + this.modelFolder).replace("/", File.separator);
    }

    @Override
    public String toVarName(String name) {
        name = this.sanitizeName(((String)name).replaceAll("-", "_"));
        if (this.isReservedWord((String)(name = StringUtils.underscore((String)name)))) {
            name = this.escapeReservedWord((String)name);
        }
        if (((String)name).matches("^\\d.*")) {
            name = "var_" + (String)name;
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toModelName(String name) {
        return org.apache.commons.lang3.StringUtils.capitalize((String)this.toModelFilename(name)) + ".t";
    }

    @Override
    public String toModelFilename(String name) {
        if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + (String)name;
        }
        if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.modelNameSuffix)) {
            name = (String)name + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord((String)(name = this.sanitizeName((String)name)))) {
            this.LOGGER.warn("{} (reserved word) cannot be used as model name. Renamed to {}", name, (Object)("model_" + (String)name));
            name = "model_" + (String)name;
        }
        if (((String)name).matches("^\\d.*|^_.*")) {
            this.LOGGER.warn("{} (model name starts with number) cannot be used as model name. Renamed to {}", name, (Object)("model_" + (String)name));
            name = "model_" + (String)name;
        }
        return StringUtils.underscore((String)name);
    }

    @Override
    public String toApiFilename(String name) {
        String _name = name.replaceAll("-", "_");
        return StringUtils.underscore(_name) + "_api";
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + "/" + this.apiDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            if (inner == null) {
                this.LOGGER.warn("{}(array property) does not have a proper inner type defined.Default to string", (Object)ap.getName());
                inner = new StringSchema().description("TODO default missing array inner type to string");
            }
            return this.getTypeDeclaration(inner) + " list";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = this.getAdditionalProperties(p);
            if (inner == null) {
                this.LOGGER.warn("{}(map property) does not have a proper inner type defined. Default to string", (Object)p.getName());
                inner = new StringSchema().description("TODO default missing map inner type to string");
            }
            String prefix = inner.getEnum() != null ? "Enums." : "";
            return "(string * " + prefix + this.getTypeDeclaration(inner) + ") list";
        }
        if (p.getEnum() != null) {
            String h = this.hashEnum(p);
            return this.enumUniqNames.get(h);
        }
        Schema referencedSchema = ModelUtils.getReferencedSchema(this.openAPI, p);
        if (referencedSchema != null && referencedSchema.getEnum() != null) {
            String h = this.hashEnum(referencedSchema);
            return "Enums." + this.enumUniqNames.get(h);
        }
        String schemaType = this.getSchemaType(p);
        if (this.typeMapping.containsKey(schemaType)) {
            return (String)this.typeMapping.get(schemaType);
        }
        if (this.typeMapping.containsValue(schemaType)) {
            return schemaType;
        }
        if (this.languageSpecificPrimitives.contains(schemaType)) {
            return schemaType;
        }
        return this.toModelName(schemaType);
    }

    @Override
    public String getSchemaType(Schema p) {
        String type;
        String schemaType = super.getSchemaType(p);
        if (this.typeMapping.containsKey(schemaType) && this.languageSpecificPrimitives.contains(type = (String)this.typeMapping.get(schemaType))) {
            return type;
        }
        return org.apache.commons.lang3.StringUtils.capitalize((String)this.toModelFilename(schemaType));
    }

    @Override
    public String toOperationId(String operationId) {
        Object sanitizedOperationId = this.sanitizeName(operationId);
        if (this.isReservedWord((String)sanitizedOperationId) || ((String)sanitizedOperationId).matches("^[0-9].*")) {
            this.LOGGER.warn("{} (reserved word) cannot be used as method name. Renamed to {}", (Object)operationId, (Object)StringUtils.underscore("call_" + operationId));
            sanitizedOperationId = "call_" + (String)sanitizedOperationId;
        }
        return StringUtils.underscore((String)sanitizedOperationId);
    }

    private Map<String, Object> allowableValues(String valueString) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("values", this.buildEnumValues(valueString));
        return result;
    }

    private List<Map<String, Object>> buildEnumValues(String valueString) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (String v : valueString.split(",")) {
            HashMap<String, String> m = new HashMap<String, String>();
            String value = v.isEmpty() ? "empty" : v;
            m.put("name", value);
            m.put("camlEnumValueName", this.ocamlizeEnumValue(value));
            result.add(m);
        }
        return result;
    }

    public String toEnumValueName(String name) {
        if (this.reservedWords.contains(name)) {
            return this.escapeReservedWord(name);
        }
        if (name.chars().anyMatch(character -> this.specialCharReplacements.keySet().contains(String.valueOf((char)character)))) {
            return StringUtils.escape(name, this.specialCharReplacements, Collections.singletonList("_"), null);
        }
        return name;
    }

    private String ocamlizeEnumValue(String value) {
        Object sanitizedValue = this.toEnumValueName(value.isEmpty() ? "empty" : value).replace(" ", "_");
        if (!((String)sanitizedValue).matches("^[a-zA-Z_].*")) {
            sanitizedValue = "_" + (String)sanitizedValue;
        }
        return "`" + org.apache.commons.lang3.StringUtils.capitalize((String)sanitizedValue);
    }

    private CodegenModel buildEnumModel(String enumName, String values) {
        CodegenModel m = new CodegenModel();
        m.setAllowableValues(this.allowableValues(values));
        m.setName(enumName);
        m.setClassname(enumName);
        m.setDataType(enumName);
        String[] vals = values.split(",");
        if (vals.length == 1) {
            m.setDefaultValue(this.ocamlizeEnumValue(vals[0]));
        }
        m.isEnum = true;
        return m;
    }

    private ModelMap buildEnumModelWrapper(String enumName, String values) {
        ModelMap m = new ModelMap();
        m.put("importPath", this.packageName + "." + enumName);
        m.setModel(this.buildEnumModel(enumName, values));
        return m;
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        OperationMap objectMap = objs.getOperations();
        List<CodegenOperation> operations = objectMap.getOperation();
        for (CodegenOperation codegenOperation : operations) {
            for (CodegenParameter param : codegenOperation.bodyParams) {
                if (!param.isModel || !param.dataType.endsWith(".t")) continue;
                param.vendorExtensions.put(X_MODEL_MODULE, param.dataType.substring(0, param.dataType.lastIndexOf(46)));
            }
            if ("Yojson.Safe.t".equals(codegenOperation.returnBaseType)) {
                codegenOperation.vendorExtensions.put("x-return-free-form-object", true);
            }
            if (codegenOperation.returnType == null || !codegenOperation.returnType.startsWith("Enums.")) continue;
            String returnTypeEnum = codegenOperation.returnType.replaceAll(" list$", "");
            codegenOperation.vendorExtensions.put("x-returntype-enum", returnTypeEnum);
            codegenOperation.vendorExtensions.put("x-returntype-is-enum", true);
        }
        for (Map.Entry entry : this.enumUniqNames.entrySet()) {
            allModels.add(this.buildEnumModelWrapper((String)entry.getValue(), (String)entry.getKey()));
        }
        this.enumUniqNames.clear();
        return objs;
    }

    @Override
    protected boolean needToImport(String type) {
        return !this.defaultIncludes.contains(type) && !this.languageSpecificPrimitives.contains(type);
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*)", "*_)").replace("(*", "(_*").replace("\"", "''");
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        String hash = String.join((CharSequence)",", property.get_enum());
        if (this.enumUniqNames.containsKey(hash)) {
            return this.enumUniqNames.get(hash);
        }
        throw new IllegalArgumentException("Unreferenced enum " + hash);
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (p.getDefault() != null) {
            if (p.getEnum() != null) {
                return this.ocamlizeEnumValue(p.getDefault().toString());
            }
            return p.getDefault().toString();
        }
        return null;
    }

    @Override
    public void postProcessFile(File file, String fileType) {
        super.postProcessFile(file, fileType);
        if (file == null) {
            return;
        }
        String ocamlPostProcessFile = System.getenv("OCAML_POST_PROCESS_FILE");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)ocamlPostProcessFile)) {
            return;
        }
        if ("ml".equals(FilenameUtils.getExtension((String)file.toString())) || "mli".equals(FilenameUtils.getExtension((String)file.toString()))) {
            String command = ocamlPostProcessFile + " " + file;
            try {
                Process p = Runtime.getRuntime().exec(command);
                int exitValue = p.waitFor();
                if (exitValue != 0) {
                    this.LOGGER.error("Error running the command ({}). Exit value: {}", (Object)command, (Object)exitValue);
                } else {
                    this.LOGGER.info("Successfully executed: {}", (Object)command);
                }
            }
            catch (IOException | InterruptedException e) {
                this.LOGGER.error("Error running the command ({}). Exception: {}", (Object)command, (Object)e.getMessage());
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public GeneratorLanguage generatorLanguage() {
        return GeneratorLanguage.OCAML;
    }
}

