/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.FileSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.XML;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.servers.Server;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenCallback;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenSecurity;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.GeneratorLanguage;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.model.ApiInfoMap;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.openapitools.codegen.utils.URLPathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RustServerCodegen
extends DefaultCodegen
implements CodegenConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(RustServerCodegen.class);
    private Map<String, String> modelXmlNames = new HashMap<String, String>();
    private static final String NO_FORMAT = "%%NO_FORMAT";
    protected String apiVersion = "1.0.0";
    protected String serverHost = "localhost";
    protected int serverPort = 8080;
    protected String projectName = "openapi-server";
    protected String apiPath = "rust-server";
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";
    protected String packageName;
    protected String packageVersion;
    protected String externCrateName;
    protected Map<String, Map<String, String>> pathSetMap = new HashMap<String, Map<String, String>>();
    protected Map<String, Map<String, String>> callbacksPathSetMap = new HashMap<String, Map<String, String>>();
    private static final String uuidType = "uuid::Uuid";
    private static final String bytesType = "swagger::ByteArray";
    private static final String xmlMimeType = "application/xml";
    private static final String textXmlMimeType = "text/xml";
    private static final String octetMimeType = "application/octet-stream";
    private static final String plainTextMimeType = "text/plain";
    private static final String jsonMimeType = "application/json";
    private static final String mergePatchJsonMimeType = "application/merge-patch+json";
    private static final String problemJsonMimeType = "application/problem+json";
    private static final String problemXmlMimeType = "application/problem+xml";

    public RustServerCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML, WireFormatFeature.Custom)).securityFeatures(EnumSet.of(SecurityFeature.ApiKey, SecurityFeature.BasicAuth, SecurityFeature.BearerToken, SecurityFeature.OAuth2_Implicit)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}).includeClientModificationFeatures(new ClientModificationFeature[]{ClientModificationFeature.BasePath}));
        this.hideGenerationTimestamp = Boolean.FALSE;
        this.outputFolder = "generated-code/rust-server";
        this.modelTemplateFiles.clear();
        this.apiTemplateFiles.clear();
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.templateDir = "rust-server";
        this.embeddedTemplateDir = "rust-server";
        this.setReservedWordsLowerCase(Arrays.asList("abstract", "alignof", "as", "become", "box", "break", "const", "continue", "crate", "do", "else", "enum", "extern", "false", "final", "fn", "for", "if", "impl", "in", "let", "loop", "macro", "match", "mod", "move", "mut", "offsetof", "override", "priv", "proc", "pub", "pure", "ref", "return", "Self", "self", "sizeof", "static", "struct", "super", "trait", "true", "type", "typeof", "unsafe", "unsized", "use", "virtual", "where", "while", "yield"));
        this.defaultIncludes = new HashSet<String>(Arrays.asList("map", "array"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("bool", "char", "i8", "i16", "i32", "i64", "u8", "u16", "u32", "u64", "isize", "usize", "f32", "f64", "str", "String"));
        this.instantiationTypes.clear();
        this.instantiationTypes.put("array", "Vec");
        this.instantiationTypes.put("map", "std::collections::HashMap");
        this.typeMapping.clear();
        this.typeMapping.put("number", "f64");
        this.typeMapping.put("integer", "i32");
        this.typeMapping.put("long", "i64");
        this.typeMapping.put("float", "f32");
        this.typeMapping.put("double", "f64");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("UUID", uuidType);
        this.typeMapping.put("URI", "String");
        this.typeMapping.put("byte", "u8");
        this.typeMapping.put("ByteArray", bytesType);
        this.typeMapping.put("binary", bytesType);
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("date", "chrono::DateTime::<chrono::Utc>");
        this.typeMapping.put("DateTime", "chrono::DateTime::<chrono::Utc>");
        this.typeMapping.put("password", "String");
        this.typeMapping.put("File", bytesType);
        this.typeMapping.put("file", bytesType);
        this.typeMapping.put("array", "Vec");
        this.typeMapping.put("map", "std::collections::HashMap");
        this.typeMapping.put("object", "serde_json::Value");
        this.typeMapping.put("AnyType", "serde_json::Value");
        this.importMapping = new HashMap();
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption("packageName", "Rust crate name (convention: snake_case).").defaultValue("openapi_client"));
        this.cliOptions.add(new CliOption("packageVersion", "Rust crate version."));
        this.additionalProperties.put("apiVersion", this.apiVersion);
        this.additionalProperties.put("apiPath", this.apiPath);
        this.supportingFiles.add(new SupportingFile("openapi.mustache", "api", "openapi.yaml"));
        this.supportingFiles.add(new SupportingFile("Cargo.mustache", "", "Cargo.toml"));
        this.supportingFiles.add(new SupportingFile("cargo-config", ".cargo", "config"));
        this.supportingFiles.add(new SupportingFile("gitignore", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("lib.mustache", "src", "lib.rs"));
        this.supportingFiles.add(new SupportingFile("context.mustache", "src", "context.rs"));
        this.supportingFiles.add(new SupportingFile("models.mustache", "src", "models.rs"));
        this.supportingFiles.add(new SupportingFile("header.mustache", "src", "header.rs"));
        this.supportingFiles.add(new SupportingFile("server-mod.mustache", "src/server", "mod.rs"));
        this.supportingFiles.add(new SupportingFile("client-mod.mustache", "src/client", "mod.rs"));
        this.supportingFiles.add(new SupportingFile("example-server-main.mustache", "examples/server", "main.rs"));
        this.supportingFiles.add(new SupportingFile("example-server-server.mustache", "examples/server", "server.rs"));
        this.supportingFiles.add(new SupportingFile("example-client-main.mustache", "examples/client", "main.rs"));
        this.supportingFiles.add(new SupportingFile("example-ca.pem", "examples", "ca.pem"));
        this.supportingFiles.add(new SupportingFile("example-server-chain.pem", "examples", "server-chain.pem"));
        this.supportingFiles.add(new SupportingFile("example-server-key.pem", "examples", "server-key.pem"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md").doNotOverwrite());
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)System.getenv("RUST_POST_PROCESS_FILE"))) {
            this.LOGGER.info("Environment variable RUST_POST_PROCESS_FILE not defined. rustfmt will be used by default. To choose a different tool, try 'export RUST_POST_PROCESS_FILE=\"/usr/local/bin/rustfmt\"' (Linux/Mac)");
            this.LOGGER.info("NOTE: To enable file post-processing, 'enablePostProcessFile' must be set to `true`  (--enable-post-process-file for CLI).");
        }
        if (!Boolean.TRUE.equals(ModelUtils.isGenerateAliasAsModel())) {
            this.LOGGER.warn("generateAliasAsModel is set to false, which means array/map will be generated as model instead and the resulting code may have issues. Please enable `generateAliasAsModel` to address the issue.");
        }
        this.setPackageName(this.additionalProperties.getOrDefault("packageName", "openapi_client"));
        if (this.additionalProperties.containsKey("packageVersion")) {
            this.setPackageVersion((String)this.additionalProperties.get("packageVersion"));
        }
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        this.additionalProperties.put("packageName", this.packageName);
        this.additionalProperties.put("externCrateName", this.externCrateName);
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
        this.externCrateName = packageName.replace('-', '_');
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    @Override
    public String apiPackage() {
        return this.apiPath;
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "rust-server";
    }

    @Override
    public String getHelp() {
        return "Generates a Rust client/server library (beta) using the openapi-generator project.";
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        Info info = openAPI.getInfo();
        URL url = URLPathUtils.getServerURL(openAPI, this.serverVariableOverrides());
        this.additionalProperties.put("serverHost", url.getHost());
        this.additionalProperties.put("serverPort", URLPathUtils.getPort(url, this.serverPort));
        if (this.packageVersion == null || this.packageVersion.isEmpty()) {
            ArrayList<String> versionComponents = new ArrayList<String>(Arrays.asList(info.getVersion().split("[.]")));
            if (versionComponents.size() < 1) {
                versionComponents.add("1");
            }
            while (versionComponents.size() < 3) {
                versionComponents.add("0");
            }
            this.setPackageVersion(org.apache.commons.lang3.StringUtils.join(versionComponents, (String)"."));
        }
        this.additionalProperties.put("packageVersion", this.packageVersion);
    }

    @Override
    public String toApiName(String name) {
        if (name.isEmpty()) {
            return "default";
        }
        return StringUtils.underscore(name);
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return name + "_";
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String toModelName(String name) {
        String camelizedName = StringUtils.camelize(this.toModelFilename(name));
        if (this.isReservedWord(camelizedName)) {
            String modelName = "Model" + camelizedName;
            this.LOGGER.warn("{} (reserved word) cannot be used as model name. Renamed to {}", (Object)camelizedName, (Object)modelName);
            return modelName;
        }
        if (camelizedName.matches("^\\d.*")) {
            camelizedName = "Model" + camelizedName;
            this.LOGGER.warn("{} (model name starts with number) cannot be used as model name. Renamed to {}", (Object)name, (Object)camelizedName);
        }
        return camelizedName;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toVarName(String name) {
        String sanitizedName = super.sanitizeName(name = name.replaceAll("^@", "at_"));
        if (this.isReservedWord(sanitizedName)) {
            sanitizedName = this.escapeReservedWord(sanitizedName);
        } else if (sanitizedName.matches("^\\d.*")) {
            sanitizedName = "param_" + sanitizedName;
        }
        return StringUtils.underscore(sanitizedName);
    }

    @Override
    public String toOperationId(String operationId) {
        if (this.isReservedWord(operationId)) {
            this.LOGGER.warn("{} (reserved word) cannot be used as method name. Renamed to {}", (Object)operationId, (Object)StringUtils.camelize("call_" + operationId));
            operationId = "call_" + operationId;
        } else if (operationId.matches("\\d.*")) {
            this.LOGGER.warn("{} cannot be used as method name because it starts with a digit. Renamed to {}", (Object)operationId, (Object)StringUtils.camelize("call_" + operationId));
            operationId = "call_" + operationId;
        }
        return StringUtils.camelize(operationId);
    }

    @Override
    public String toModelFilename(String name) {
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(name = this.sanitizeName(name))) {
            this.LOGGER.warn("{} (reserved word) cannot be used as model name. Renamed to {}", (Object)name, (Object)StringUtils.camelize("model_" + name));
            name = "model_" + name;
        }
        return StringUtils.underscore(name);
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        return this.sanitizeName(StringUtils.camelize(property.name)) + "Enum";
    }

    @Override
    public String toEnumVarName(String value, String datatype) {
        String var = null;
        if (value.isEmpty()) {
            var = "EMPTY";
        } else if (this.getSymbolName(value) != null) {
            var = this.getSymbolName(value).toUpperCase(Locale.ROOT);
        } else if ("Integer".equals(datatype) || "Long".equals(datatype) || "Float".equals(datatype) || "Double".equals(datatype)) {
            String varName = "NUMBER_" + value;
            varName = varName.replaceAll("-", "MINUS_");
            varName = varName.replaceAll("\\+", "PLUS_");
            var = varName = varName.replaceAll("\\.", "_DOT_");
        } else {
            var = value.replaceAll("\\W+", "_").toUpperCase(Locale.ROOT);
            var = var.matches("\\d.*") ? "_" + var : this.sanitizeName(var);
        }
        return var;
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("Integer".equals(datatype) || "Long".equals(datatype) || "Float".equals(datatype) || "Double".equals(datatype)) {
            return value;
        }
        return "\"" + this.escapeText(value) + "\"";
    }

    @Override
    public String toApiFilename(String name) {
        name = name.replaceAll("-", "_");
        return StringUtils.underscore(name);
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + "/" + this.apiDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name) + "_api";
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    private boolean isMimetypeXml(String mimetype) {
        return mimetype.toLowerCase(Locale.ROOT).startsWith(xmlMimeType) || mimetype.toLowerCase(Locale.ROOT).startsWith(problemXmlMimeType) || mimetype.toLowerCase(Locale.ROOT).startsWith(textXmlMimeType);
    }

    private boolean isMimetypeJson(String mimetype) {
        return mimetype.toLowerCase(Locale.ROOT).startsWith(jsonMimeType) || mimetype.toLowerCase(Locale.ROOT).startsWith(mergePatchJsonMimeType) || mimetype.toLowerCase(Locale.ROOT).startsWith(problemJsonMimeType);
    }

    private boolean isMimetypeWwwFormUrlEncoded(String mimetype) {
        return mimetype.toLowerCase(Locale.ROOT).startsWith("application/x-www-form-urlencoded");
    }

    private boolean isMimetypeMultipartFormData(String mimetype) {
        return mimetype.toLowerCase(Locale.ROOT).startsWith("multipart/form-data");
    }

    private boolean isMimetypeOctetStream(String mimetype) {
        return mimetype.toLowerCase(Locale.ROOT).startsWith(octetMimeType);
    }

    private boolean isMimetypeMultipartRelated(String mimetype) {
        return mimetype.toLowerCase(Locale.ROOT).startsWith("multipart/related");
    }

    private boolean isMimetypeUnknown(String mimetype) {
        return "*/*".equals(mimetype);
    }

    boolean isMimetypePlain(String mimetype) {
        boolean result = !this.isMimetypeUnknown(mimetype) && !this.isMimetypeXml(mimetype) && !this.isMimetypeJson(mimetype) && !this.isMimetypeWwwFormUrlEncoded(mimetype) && !this.isMimetypeMultipartFormData(mimetype) && !this.isMimetypeMultipartRelated(mimetype);
        return result;
    }

    private String tidyUpRuntimeCallbackParam(String param) {
        return StringUtils.underscore(param.replace("-", "_").replace(".", "_").replace("{", "").replace("#", "_").replace("/", "_").replace("}", "").replace("$", "").replaceAll("_+", "_"));
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, List<Server> servers) {
        String basePathId;
        Map<String, Schema> definitions = ModelUtils.getSchemas(this.openAPI);
        CodegenOperation op = super.fromOperation(path, httpMethod, operation, servers);
        String pathFormatString = op.path;
        for (CodegenParameter param : op.pathParams) {
            String paramSearch = "{" + param.baseName + "}";
            String paramReplace = "{" + param.paramName + "}";
            pathFormatString = pathFormatString.replace(paramSearch, paramReplace);
        }
        op.vendorExtensions.put("x-path-format-string", pathFormatString);
        String pathId = basePathId = this.sanitizeName(op.path.replace("/", "_").replace("{", "").replace("}", "").replaceAll("^_", "")).toUpperCase(Locale.ROOT);
        int pathIdTiebreaker = 2;
        boolean found = false;
        Map<String, Map<String, String>> pathSetMap = op.isCallbackRequest ? this.callbacksPathSetMap : this.pathSetMap;
        while (pathSetMap.containsKey(pathId)) {
            Map<String, String> pathSetEntry = pathSetMap.get(pathId);
            if (pathSetEntry.get("path").equals(op.path)) {
                found = true;
                break;
            }
            pathId = basePathId + pathIdTiebreaker;
            ++pathIdTiebreaker;
        }
        boolean hasPathParams = !op.pathParams.isEmpty();
        String regex = op.path;
        String formatPath = op.path;
        for (CodegenParameter param : op.pathParams) {
            String string = "{" + param.baseName + "}";
            String paramReplace = "{" + param.paramName + "}";
            formatPath = formatPath.replace(string, paramReplace);
        }
        if (op.isCallbackRequest) {
            formatPath = formatPath.substring(1);
            ArrayList<String> params = new ArrayList<String>();
            Matcher match = Pattern.compile("\\{\\$[^}{]*\\}").matcher(op.path);
            while (match.find()) {
                String string = match.group();
                String rustParam = this.tidyUpRuntimeCallbackParam(string);
                params.add(rustParam);
                String formatParam = "{" + rustParam + "}";
                formatPath = formatPath.replace(string, formatParam);
                String newParam = "(?P<" + rustParam + ">.*)";
                regex = regex.replace(string, newParam);
                hasPathParams = true;
            }
            op.vendorExtensions.put("x-callback-params", params);
        }
        if (!found) {
            HashMap<String, String> pathSetEntry = new HashMap<String, String>();
            pathSetEntry.put("path", op.path);
            pathSetEntry.put("PATH_ID", pathId);
            if (hasPathParams) {
                pathSetEntry.put("hasPathParams", "true");
            }
            for (CodegenParameter codegenParameter : op.pathParams) {
                String paramSearch = "{" + codegenParameter.baseName + "}";
                String paramReplace = "(?P<" + codegenParameter.baseName + ">[^/?#]*)";
                regex = regex.replace(paramSearch, paramReplace);
            }
            pathSetEntry.put("pathRegEx", regex + "$");
            pathSetMap.put(pathId, pathSetEntry);
        }
        String underscoredOperationId = StringUtils.underscore(op.operationId);
        op.vendorExtensions.put("x-operation-id", underscoredOperationId);
        op.vendorExtensions.put("x-uppercase-operation-id", underscoredOperationId.toUpperCase(Locale.ROOT));
        String vendorExtensionPath = op.path.replace("{", ":").replace("}", "");
        op.vendorExtensions.put("x-path", vendorExtensionPath);
        op.vendorExtensions.put("x-path-id", pathId);
        op.vendorExtensions.put("x-has-path-params", hasPathParams);
        op.vendorExtensions.put("x-path-format-string", formatPath);
        String string = op.httpMethod.toUpperCase(Locale.ROOT);
        op.vendorExtensions.put("x-http-method", string);
        if (!op.vendorExtensions.containsKey("x-must-use-response")) {
            op.vendorExtensions.put("x-must-use-response", op.responses.size() > 1);
        }
        for (CodegenParameter param : op.allParams) {
            this.processParam(param, op);
        }
        boolean defaultsToXml = false;
        ArrayList<String> produces = new ArrayList<String>(RustServerCodegen.getProducesInfo(this.openAPI, operation));
        boolean producesXml = false;
        boolean producesPlainText = false;
        if (produces != null && !produces.isEmpty()) {
            ArrayList c = new ArrayList();
            for (String string2 : produces) {
                HashMap<String, String> mediaType = new HashMap<String, String>();
                if (this.isMimetypeXml(string2)) {
                    this.additionalProperties.put("usesXml", true);
                    defaultsToXml = true;
                    producesXml = true;
                } else if (this.isMimetypePlain(string2)) {
                    producesPlainText = true;
                }
                mediaType.put("mediaType", string2);
                c.add(mediaType);
            }
            op.produces = c;
            op.hasProduces = true;
        }
        for (CodegenParameter param : op.headerParams) {
            this.processParam(param, op);
            param.vendorExtensions.put("x-type-name", this.toModelName(param.baseName));
        }
        HashSet<String> responseIds = new HashSet<String>();
        for (CodegenResponse codegenResponse : op.responses) {
            ApiResponse original = "0".equals(codegenResponse.code) ? (ApiResponse)operation.getResponses().get((Object)"default") : (ApiResponse)operation.getResponses().get((Object)codegenResponse.code);
            String[] words = codegenResponse.message.split("[^A-Za-z ]");
            String responseId = codegenResponse.vendorExtensions.containsKey("x-response-id") ? (String)codegenResponse.vendorExtensions.get("x-response-id") : (words.length != 0 && words[0].trim().length() != 0 ? StringUtils.camelize(words[0].replace(" ", "_")) : "Status" + codegenResponse.code);
            int idTieBreaker = 2;
            while (responseIds.contains(responseId)) {
                String trial = String.format(Locale.ROOT, "%s_%d", responseId, idTieBreaker);
                if (!responseIds.contains(trial)) {
                    responseId = trial;
                    continue;
                }
                ++idTieBreaker;
            }
            responseIds.add(responseId);
            String underscoredResponseId = StringUtils.underscore(responseId).toUpperCase(Locale.ROOT);
            codegenResponse.vendorExtensions.put("x-response-id", responseId);
            codegenResponse.vendorExtensions.put("x-uppercase-response-id", underscoredResponseId.toUpperCase(Locale.ROOT));
            codegenResponse.vendorExtensions.put("x-uppercase-operation-id", underscoredOperationId.toUpperCase(Locale.ROOT));
            if (codegenResponse.dataType != null) {
                XML xml;
                Schema model;
                String outputMime;
                String uppercaseDataType = codegenResponse.dataType.replace("models::", "").toUpperCase(Locale.ROOT);
                codegenResponse.vendorExtensions.put("x-uppercase-data-type", uppercaseDataType);
                String firstProduces = null;
                if (original.getContent() != null) {
                    firstProduces = original.getContent().keySet().stream().findFirst().orElse(null);
                }
                if (firstProduces == null) {
                    outputMime = producesXml ? xmlMimeType : (producesPlainText ? (bytesType.equals(codegenResponse.dataType) ? octetMimeType : plainTextMimeType) : jsonMimeType);
                } else {
                    if (this.isMimetypeXml(firstProduces)) {
                        producesXml = true;
                        producesPlainText = false;
                    } else if (this.isMimetypePlain(firstProduces)) {
                        producesXml = false;
                        producesPlainText = true;
                    } else {
                        producesXml = false;
                        producesPlainText = false;
                    }
                    outputMime = firstProduces;
                }
                codegenResponse.vendorExtensions.put("x-mime-type", outputMime);
                if (producesXml) {
                    codegenResponse.vendorExtensions.put("x-produces-xml", true);
                } else if (producesPlainText) {
                    if (bytesType.equals(codegenResponse.dataType)) {
                        codegenResponse.vendorExtensions.put("x-produces-bytes", true);
                    } else {
                        codegenResponse.vendorExtensions.put("x-produces-plain-text", true);
                    }
                } else {
                    codegenResponse.vendorExtensions.put("x-produces-json", true);
                    if ("object".equals(codegenResponse.dataType)) {
                        codegenResponse.dataType = "serde_json::Value";
                    }
                }
                Schema response = (Schema)codegenResponse.schema;
                if (response != null && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)response.get$ref()) && (model = definitions.get(ModelUtils.getSimpleRef(response.get$ref()))) != null && (xml = model.getXml()) != null && xml.getNamespace() != null) {
                    codegenResponse.vendorExtensions.put("x-has-namespace", "true");
                }
            }
            for (CodegenProperty header : codegenResponse.headers) {
                if (uuidType.equals(header.dataType)) {
                    this.additionalProperties.put("apiUsesUuid", true);
                }
                header.nameInCamelCase = this.toModelName(header.baseName);
                header.nameInLowerCase = header.baseName.toLowerCase(Locale.ROOT);
            }
        }
        for (CodegenParameter codegenParameter : op.headerParams) {
            codegenParameter.nameInLowerCase = codegenParameter.baseName.toLowerCase(Locale.ROOT);
        }
        for (CodegenProperty codegenProperty : op.responseHeaders) {
            if (uuidType.equals(codegenProperty.dataType)) {
                this.additionalProperties.put("apiUsesUuid", true);
            }
            codegenProperty.nameInCamelCase = this.toModelName(codegenProperty.baseName);
            codegenProperty.nameInLowerCase = codegenProperty.baseName.toLowerCase(Locale.ROOT);
        }
        return op;
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        OperationMap operations = objs.getOperations();
        List<CodegenOperation> operationList = operations.getOperation();
        for (CodegenOperation op : operationList) {
            this.postProcessOperationWithModels(op, allModels);
        }
        return objs;
    }

    private void postProcessOperationWithModels(CodegenOperation op, List<ModelMap> allModels) {
        boolean consumesPlainText = false;
        boolean consumesXml = false;
        if (op.consumes != null) {
            for (Map<String, String> map : op.consumes) {
                if (map.get("mediaType") == null) continue;
                String string = map.get("mediaType");
                if (this.isMimetypeXml(string)) {
                    this.additionalProperties.put("usesXml", true);
                    consumesXml = true;
                    continue;
                }
                if (this.isMimetypePlain(string)) {
                    consumesPlainText = true;
                    continue;
                }
                if (this.isMimetypeWwwFormUrlEncoded(string)) {
                    this.additionalProperties.put("usesUrlEncodedForm", true);
                    continue;
                }
                if (this.isMimetypeMultipartFormData(string)) {
                    op.vendorExtensions.put("x-consumes-multipart", true);
                    this.additionalProperties.put("apiUsesMultipartFormData", true);
                    this.additionalProperties.put("apiUsesMultipart", true);
                    continue;
                }
                if (!this.isMimetypeMultipartRelated(string)) continue;
                op.vendorExtensions.put("x-consumes-multipart-related", true);
                this.additionalProperties.put("apiUsesMultipartRelated", true);
                this.additionalProperties.put("apiUsesMultipart", true);
            }
        }
        String underscoredOperationId = StringUtils.underscore(op.operationId).toUpperCase(Locale.ROOT);
        if (op.bodyParam != null) {
            op.bodyParam.vendorExtensions.put("x-uppercase-operation-id", underscoredOperationId);
            if (consumesXml) {
                op.bodyParam.vendorExtensions.put("x-consumes-xml", true);
            } else if (consumesPlainText) {
                op.bodyParam.vendorExtensions.put("x-consumes-plain-text", true);
            } else {
                op.bodyParam.vendorExtensions.put("x-consumes-json", true);
            }
        }
        for (CodegenParameter codegenParameter : op.bodyParams) {
            this.processParam(codegenParameter, op);
            codegenParameter.vendorExtensions.put("x-uppercase-operation-id", underscoredOperationId);
            if (consumesXml) {
                codegenParameter.vendorExtensions.put("x-consumes-xml", true);
                continue;
            }
            if (consumesPlainText) {
                codegenParameter.vendorExtensions.put("x-consumes-plain-text", true);
                continue;
            }
            codegenParameter.vendorExtensions.put("x-consumes-json", true);
        }
        for (CodegenParameter codegenParameter : op.queryParams) {
            if (codegenParameter.contentType == null || !this.isMimetypeJson(codegenParameter.contentType)) continue;
            codegenParameter.vendorExtensions.put("x-consumes-json", true);
        }
        for (CodegenParameter codegenParameter : op.formParams) {
            this.processParam(codegenParameter, op);
        }
        for (CodegenParameter codegenParameter : op.headerParams) {
            codegenParameter.nameInLowerCase = codegenParameter.baseName.toLowerCase(Locale.ROOT);
        }
        for (CodegenProperty codegenProperty : op.responseHeaders) {
            if (uuidType.equals(codegenProperty.dataType)) {
                this.additionalProperties.put("apiUsesUuid", true);
            }
            codegenProperty.nameInCamelCase = this.toModelName(codegenProperty.baseName);
            codegenProperty.nameInLowerCase = codegenProperty.baseName.toLowerCase(Locale.ROOT);
        }
        if (op.authMethods != null) {
            boolean bl;
            boolean bl2 = false;
            for (CodegenSecurity s : op.authMethods) {
                if (s.isApiKey.booleanValue() && s.isKeyInHeader.booleanValue()) {
                    s.vendorExtensions.put("x-api-key-name", this.toModelName(s.keyParamName));
                    bl = true;
                }
                if (!s.isBasicBasic.booleanValue() && !s.isBasicBearer.booleanValue() && !s.isOAuth.booleanValue()) continue;
                bl = true;
            }
            if (bl) {
                op.vendorExtensions.put("x-has-header-auth-methods", "true");
            }
        }
        for (CodegenCallback codegenCallback : op.callbacks) {
            for (CodegenCallback.Url url : codegenCallback.urls) {
                for (CodegenOperation innerOp : url.requests) {
                    this.postProcessOperationWithModels(innerOp, allModels);
                }
            }
        }
    }

    @Override
    public boolean isDataTypeFile(String dataType) {
        return dataType != null && dataType.equals(this.typeMapping.get("File"));
    }

    @Override
    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        if (tag != null && co.tags.size() > 1 && !tag.equals(co.tags.get(0).getName())) {
            this.LOGGER.info("generated skip additional tag `{}` with operationId={}", (Object)tag, (Object)co.operationId);
            return;
        }
        super.addOperationToGroup(tag, resourcePath, operation, co, operations);
    }

    @Override
    public CodegenParameter fromRequestBody(RequestBody body, Set<String> imports, String bodyParameterName) {
        Schema original_schema = ModelUtils.getSchemaFromRequestBody(body);
        CodegenParameter codegenParameter = super.fromRequestBody(body, imports, bodyParameterName);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)original_schema.get$ref())) {
            codegenParameter.dataType = this.getTypeDeclaration(original_schema);
            codegenParameter.isPrimitiveType = false;
            codegenParameter.isArray = false;
            codegenParameter.isString = false;
            codegenParameter.isByteArray = ModelUtils.isByteArraySchema(original_schema);
            if (codegenParameter.vendorExtensions != null && codegenParameter.vendorExtensions.containsKey("x-example")) {
                codegenParameter.example = Json.pretty((Object)codegenParameter.vendorExtensions.get("x-example"));
            } else if (!codegenParameter.required) {
                codegenParameter.example = null;
            }
        }
        return codegenParameter;
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            String innerType = this.getTypeDeclaration(inner);
            return (String)this.typeMapping.get("array") + "<" + innerType + ">";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = this.getAdditionalProperties(p);
            String innerType = this.getTypeDeclaration(inner);
            StringBuilder typeDeclaration = new StringBuilder((String)this.typeMapping.get("map")).append("<").append((String)this.typeMapping.get("string")).append(", ");
            typeDeclaration.append(innerType).append(">");
            return typeDeclaration.toString();
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)p.get$ref())) {
            String datatype;
            try {
                datatype = p.get$ref();
                if (datatype.indexOf("#/components/schemas/") == 0) {
                    datatype = this.toModelName(datatype.substring("#/components/schemas/".length()));
                    datatype = "models::" + datatype;
                }
            }
            catch (Exception e) {
                this.LOGGER.warn("Error obtaining the datatype from schema (model):{}. Datatype default to Object", (Object)p);
                datatype = "Object";
                this.LOGGER.error(e.getMessage(), (Throwable)e);
            }
            return datatype;
        }
        if (p instanceof FileSchema) {
            return (String)this.typeMapping.get("File");
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String toInstantiationType(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return (String)this.instantiationTypes.get("array") + "<" + this.getSchemaType(inner) + ">";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = this.getAdditionalProperties(p);
            return (String)this.instantiationTypes.get("map") + "<" + (String)this.typeMapping.get("string") + ", " + this.getSchemaType(inner) + ">";
        }
        return null;
    }

    @Override
    public CodegenModel fromModel(String name, Schema model) {
        Schema additionalProperties;
        this.LOGGER.trace("Creating model from schema: {}", (Object)model);
        Map<String, Schema> allDefinitions = ModelUtils.getSchemas(this.openAPI);
        CodegenModel mdl = super.fromModel(name, model);
        mdl.vendorExtensions.put("x-upper-case-name", name.toUpperCase(Locale.ROOT));
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)model.get$ref())) {
            Schema schema = allDefinitions.get(ModelUtils.getSimpleRef(model.get$ref()));
            mdl.dataType = (String)this.typeMapping.get(schema.getType());
        }
        if (ModelUtils.isArraySchema(model)) {
            Schema inner_schema;
            ArraySchema am = (ArraySchema)model;
            String xmlName = null;
            if (am.getItems() != null && am.getItems().getXml() != null) {
                xmlName = am.getItems().getXml().getName();
            }
            if (am.getXml() != null && am.getXml().getWrapped().booleanValue() && am.getItems() != null && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)am.getItems().get$ref()) && (inner_schema = allDefinitions.get(ModelUtils.getSimpleRef(am.getItems().get$ref()))).getXml() != null && inner_schema.getXml().getName() != null) {
                xmlName = inner_schema.getXml().getName();
            }
            if (xmlName != null) {
                mdl.vendorExtensions.put("x-item-xml-name", xmlName);
                this.modelXmlNames.put("models::" + mdl.classname, xmlName);
            }
            mdl.arrayModelType = this.typeMapping.containsKey(mdl.arrayModelType) ? (String)this.typeMapping.get(mdl.arrayModelType) : this.toModelName(mdl.arrayModelType);
        } else if (mdl.anyOf.size() > 0 || mdl.oneOf.size() > 0) {
            mdl.dataType = this.getSchemaType(model);
        }
        if (mdl.xmlNamespace != null) {
            this.additionalProperties.put("usesXmlNamespaces", true);
        }
        if ((additionalProperties = this.getAdditionalProperties(model)) != null) {
            mdl.additionalPropertiesType = this.getTypeDeclaration(additionalProperties);
        }
        this.LOGGER.trace("Created model: {}", (Object)mdl);
        return mdl;
    }

    @Override
    public Map<String, ModelsMap> postProcessAllModels(Map<String, ModelsMap> objs) {
        Map<String, ModelsMap> newObjs = super.postProcessAllModels(objs);
        HashMap<String, CodegenModel> allModels = new HashMap<String, CodegenModel>();
        for (Map.Entry<String, ModelsMap> entry : objs.entrySet()) {
            String modelName = this.toModelName(entry.getKey());
            List<ModelMap> models = entry.getValue().getModels();
            for (ModelMap mo : models) {
                allModels.put(modelName, mo.getModel());
            }
        }
        for (Map.Entry<String, ModelsMap> entry : allModels.entrySet()) {
            CodegenModel model = (CodegenModel)((Object)entry.getValue());
            if (uuidType.equals(model.dataType)) {
                this.additionalProperties.put("apiUsesUuid", true);
            }
            for (CodegenProperty prop : model.vars) {
                String xmlName;
                if (uuidType.equals(prop.dataType)) {
                    this.additionalProperties.put("apiUsesUuid", true);
                }
                if ((xmlName = this.modelXmlNames.get(prop.dataType)) != null) {
                    prop.vendorExtensions.put("x-item-xml-name", xmlName);
                }
                if (!uuidType.equals(prop.dataType)) continue;
                this.additionalProperties.put("apiUsesUuid", true);
            }
        }
        return newObjs;
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> bundle) {
        SupportingFile[] callbackFiles;
        this.generateYAMLSpecFile(bundle);
        RustServerCodegen.addPathSetMapToBundle(this.pathSetMap, bundle);
        boolean hasCallbacks = RustServerCodegen.haveCallbacks(bundle);
        bundle.put("hasCallbacks", hasCallbacks);
        for (SupportingFile callbackFile : callbackFiles = new SupportingFile[]{new SupportingFile("client-callbacks.mustache", "src/client", "callbacks.rs"), new SupportingFile("server-callbacks.mustache", "src/server", "callbacks.rs"), new SupportingFile("example-client-server.mustache", "examples/client", "server.rs")}) {
            if (hasCallbacks) {
                this.supportingFiles.add(callbackFile);
                continue;
            }
            this.supportingFiles.remove((Object)callbackFile);
        }
        if (hasCallbacks) {
            HashMap<String, Object> callbackData = new HashMap<String, Object>();
            RustServerCodegen.addPathSetMapToBundle(this.callbacksPathSetMap, callbackData);
            bundle.put("callbacks", callbackData);
        }
        return super.postProcessSupportingFileData(bundle);
    }

    private static void addPathSetMapToBundle(Map<String, Map<String, String>> pathSetMap, Map<String, Object> bundle) {
        ArrayList<Map.Entry<String, Map<String, String>>> pathSetEntryList = new ArrayList<Map.Entry<String, Map<String, String>>>(pathSetMap.entrySet());
        Collections.sort(pathSetEntryList, new Comparator<Map.Entry<String, Map<String, String>>>(){

            @Override
            public int compare(Map.Entry<String, Map<String, String>> a, Map.Entry<String, Map<String, String>> b) {
                return a.getValue().get("path").compareTo(b.getValue().get("path"));
            }
        });
        ArrayList<Map> pathSet = new ArrayList<Map>();
        int index = 0;
        for (Map.Entry entry : pathSetEntryList) {
            Map pathSetEntryValue = (Map)entry.getValue();
            pathSetEntryValue.put("index", Integer.toString(index));
            ++index;
            pathSet.add(pathSetEntryValue);
        }
        bundle.put("pathSet", pathSet);
    }

    private static boolean haveCallbacks(Map<String, Object> bundle) {
        ApiInfoMap apiInfo = (ApiInfoMap)bundle.get("apiInfo");
        for (OperationsMap api : apiInfo.getApis()) {
            List<CodegenOperation> ops = api.getOperations().getOperation();
            for (CodegenOperation op : ops) {
                if (op.callbacks.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String toDefaultValue(Schema p) {
        String defaultValue = null;
        if (ModelUtils.isNullable(p) && p.getDefault() != null && "null".equalsIgnoreCase(p.getDefault().toString())) {
            return "swagger::Nullable::Null";
        }
        if (ModelUtils.isBooleanSchema(p)) {
            if (p.getDefault() != null) {
                defaultValue = "false".equalsIgnoreCase(p.getDefault().toString()) ? "false" : "true";
            }
        } else if (ModelUtils.isNumberSchema(p)) {
            if (p.getDefault() != null) {
                defaultValue = p.getDefault().toString();
            }
        } else if (ModelUtils.isIntegerSchema(p)) {
            if (p.getDefault() != null) {
                defaultValue = p.getDefault().toString();
            }
        } else if (ModelUtils.isStringSchema(p) && p.getDefault() != null) {
            defaultValue = "\"" + (String)p.getDefault() + "\".to_string()";
        }
        if (defaultValue != null && ModelUtils.isNullable(p)) {
            defaultValue = "swagger::Nullable::Present(" + defaultValue + ")";
        }
        return defaultValue;
    }

    @Override
    public String toOneOfName(List<String> names, ComposedSchema composedSchema) {
        List<Schema> schemas = ModelUtils.getInterfaces(composedSchema);
        ArrayList<String> types = new ArrayList<String>();
        for (Schema s : schemas) {
            types.add(this.getTypeDeclaration(s));
        }
        return "swagger::OneOf" + types.size() + "<" + String.join((CharSequence)",", types) + ">";
    }

    @Override
    public String toAnyOfName(List<String> names, ComposedSchema composedSchema) {
        List<Schema> schemas = ModelUtils.getInterfaces(composedSchema);
        ArrayList<String> types = new ArrayList<String>();
        for (Schema s : schemas) {
            types.add(this.getTypeDeclaration(s));
        }
        return "swagger::AnyOf" + types.size() + "<" + String.join((CharSequence)",", types) + ">";
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        if (!this.languageSpecificPrimitives.contains(property.dataType)) {
            if (property.dataType.contains(":")) {
                int position = property.dataType.lastIndexOf(":");
                property.dataType = property.dataType.substring(0, position) + StringUtils.camelize(property.dataType.substring(position));
            } else {
                property.dataType = StringUtils.camelize(property.dataType, false);
            }
            property.isPrimitiveType = property.isContainer && this.languageSpecificPrimitives.contains(this.typeMapping.get(property.complexType));
        } else {
            property.isPrimitiveType = true;
        }
        if ("integer".equals(property.baseType)) {
            if ("uint32".equals(property.dataFormat)) {
                property.dataType = "u32";
            } else if ("uint64".equals(property.dataFormat)) {
                property.dataType = "u64";
            } else {
                Long inclusiveMaximum;
                Long inclusiveMinimum;
                Long l = inclusiveMinimum = property.minimum != null ? Long.valueOf(Long.parseLong(property.minimum)) : null;
                if (inclusiveMinimum != null && property.exclusiveMinimum) {
                    Long l2 = inclusiveMinimum;
                    Long l3 = inclusiveMinimum = Long.valueOf(inclusiveMinimum + 1L);
                }
                boolean unsigned = inclusiveMinimum != null && inclusiveMinimum >= 0L;
                Long l4 = inclusiveMaximum = property.maximum != null ? Long.valueOf(Long.parseLong(property.maximum)) : null;
                if (inclusiveMaximum != null && property.exclusiveMaximum) {
                    Object object = inclusiveMaximum;
                    Long l5 = inclusiveMaximum = Long.valueOf(inclusiveMaximum - 1L);
                }
                switch (property.dataFormat == null ? NO_FORMAT : property.dataFormat) {
                    case "int32": {
                        property.dataType = unsigned ? "u32" : "i32";
                        break;
                    }
                    case "int64": {
                        property.dataType = unsigned ? "u64" : "i64";
                        break;
                    }
                    case "%%NO_FORMAT": {
                        property.dataType = this.matchingIntType(unsigned, inclusiveMinimum, inclusiveMaximum);
                        break;
                    }
                    default: {
                        this.LOGGER.warn("The integer format '{}' is not recognized and will be ignored.", (Object)property.dataFormat);
                        property.dataType = this.matchingIntType(unsigned, inclusiveMinimum, inclusiveMaximum);
                    }
                }
            }
        }
        property.name = StringUtils.underscore(property.name);
        if (!property.required) {
            String string = property.defaultValue = property.defaultValue != null ? "Some(" + property.defaultValue + ")" : "None";
        }
        if ("object".equals(property.baseType)) {
            property.dataType = "serde_json::Value";
            property.isNullable = false;
        }
    }

    private long requiredBits(Long bound, boolean unsigned) {
        if (bound == null) {
            return 0L;
        }
        if (unsigned) {
            if (bound < 0L) {
                throw new RuntimeException("Unsigned bound is negative: " + bound);
            }
            return 65L - (long)Long.numberOfLeadingZeros(bound >> 1);
        }
        return 65L - (long)Long.numberOfLeadingZeros(bound < 0L ? Math.abs(bound) - 1L : bound);
    }

    private String matchingIntType(boolean unsigned, Long inclusiveMin, Long inclusiveMax) {
        long requiredMinBits = this.requiredBits(inclusiveMin, unsigned);
        long requiredMaxBits = this.requiredBits(inclusiveMax, unsigned);
        long requiredBits = Math.max(requiredMinBits, requiredMaxBits);
        if (requiredMaxBits == 0L && requiredMinBits <= 16L) {
            return unsigned ? "usize" : "isize";
        }
        if (requiredBits <= 8L) {
            return unsigned ? "u8" : "i8";
        }
        if (requiredBits <= 16L) {
            return unsigned ? "u16" : "i16";
        }
        if (requiredBits <= 32L) {
            return unsigned ? "u32" : "i32";
        }
        return unsigned ? "u64" : "i64";
    }

    @Override
    public ModelsMap postProcessModels(ModelsMap objs) {
        for (ModelMap mo : objs.getModels()) {
            CodegenModel cm = mo.getModel();
            this.LOGGER.trace("Post processing model: {}", (Object)cm);
            if ("object".equals(cm.dataType)) {
                cm.dataType = null;
            } else if ("map".equals(cm.dataType)) {
                if (!cm.allVars.isEmpty() || cm.additionalPropertiesType == null) {
                    this.LOGGER.warn("Ignoring additionalProperties (see https://github.com/OpenAPITools/openapi-generator/issues/318) alongside defined properties");
                    cm.dataType = null;
                } else {
                    cm.dataType = "std::collections::HashMap<String, " + cm.additionalPropertiesType + ">";
                }
            } else if (cm.dataType != null) {
                cm.isAlias = false;
                cm.dataType = (String)this.typeMapping.get(cm.dataType);
                if (uuidType.equals(cm.dataType)) {
                    this.additionalProperties.put("apiUsesUuid", true);
                }
            }
            cm.vendorExtensions.put("x-is-string", "String".equals(cm.dataType));
        }
        return super.postProcessModelsEnum(objs);
    }

    private void processParam(CodegenParameter param, CodegenOperation op) {
        String example = null;
        if (uuidType.equals(param.dataType)) {
            this.additionalProperties.put("apiUsesUuid", true);
        }
        if (Boolean.TRUE.equals(param.isFreeFormObject)) {
            param.vendorExtensions.put("x-format-string", "{:?}");
            example = null;
        } else if (param.isString) {
            param.vendorExtensions.put("x-format-string", "\\\"{}\\\"");
            example = "\"" + (param.example != null ? param.example : "") + "\".to_string()";
        } else if (param.isPrimitiveType) {
            if (param.isByteArray || param.isBinary) {
                param.vendorExtensions.put("x-format-string", "{:?}");
                example = "swagger::ByteArray(Vec::from(\"" + (param.example != null ? param.example : "") + "\"))";
            } else {
                param.vendorExtensions.put("x-format-string", "{}");
                example = param.example != null ? param.example : "";
            }
        } else if (param.isArray) {
            param.vendorExtensions.put("x-format-string", "{:?}");
            example = param.example != null ? param.example : "&Vec::new()";
        } else {
            param.vendorExtensions.put("x-format-string", "{:?}");
            if (param.example != null) {
                example = "serde_json::from_str::<" + param.dataType + ">(r#\"" + param.example + "\"#).expect(\"Failed to parse JSON example\")";
            }
        }
        if (param.required) {
            if (example != null) {
                param.vendorExtensions.put("x-example", example);
            } else if (param.isArray) {
                param.vendorExtensions.put("x-example", "&Vec::new()");
            } else {
                param.vendorExtensions.put("x-example", "???");
                op.vendorExtensions.put("x-no-client-example", Boolean.TRUE);
            }
        } else if (param.dataFormat != null && ("date-time".equals(param.dataFormat) || "date".equals(param.dataFormat))) {
            param.vendorExtensions.put("x-format-string", "{:?}");
            param.vendorExtensions.put("x-example", "None");
        } else {
            param.vendorExtensions.put("x-format-string", "{:?}");
            String exampleString = example != null ? "Some(" + example + ")" : "None";
            param.vendorExtensions.put("x-example", exampleString);
        }
    }

    @Override
    public void postProcessFile(File file, String fileType) {
        if (file == null) {
            return;
        }
        String commandPrefix = System.getenv("RUST_POST_PROCESS_FILE");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)commandPrefix)) {
            commandPrefix = "rustfmt";
        }
        if ("rs".equals(FilenameUtils.getExtension((String)file.toString()))) {
            try {
                Process p = Runtime.getRuntime().exec(new String[]{commandPrefix, file.toString()});
                int exitValue = p.waitFor();
                if (exitValue != 0) {
                    this.LOGGER.error("Error running the command ({} {}). Exit code: {}", new Object[]{commandPrefix, file, exitValue});
                } else {
                    this.LOGGER.info("Successfully executed: {} {}", (Object)commandPrefix, (Object)file);
                }
            }
            catch (IOException | InterruptedException e) {
                this.LOGGER.error("Error running the command ({} ()). Exception: {}", new Object[]{commandPrefix, file, e.getMessage()});
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    protected void updateParameterForString(CodegenParameter codegenParameter, Schema parameterSchema) {
        if (ModelUtils.isEmailSchema(parameterSchema)) {
            codegenParameter.isEmail = true;
        } else if (ModelUtils.isUUIDSchema(parameterSchema)) {
            codegenParameter.setIsString(false);
            codegenParameter.isUuid = true;
        } else if (ModelUtils.isByteArraySchema(parameterSchema)) {
            codegenParameter.setIsString(false);
            codegenParameter.isByteArray = true;
            codegenParameter.isPrimitiveType = true;
        } else if (ModelUtils.isBinarySchema(parameterSchema)) {
            codegenParameter.isBinary = true;
            codegenParameter.isFile = true;
            codegenParameter.isPrimitiveType = true;
        } else if (ModelUtils.isDateSchema(parameterSchema)) {
            codegenParameter.setIsString(false);
            codegenParameter.isDate = true;
            codegenParameter.isPrimitiveType = true;
        } else if (ModelUtils.isDateTimeSchema(parameterSchema)) {
            codegenParameter.setIsString(false);
            codegenParameter.isDateTime = true;
            codegenParameter.isPrimitiveType = true;
        } else if (ModelUtils.isDecimalSchema(parameterSchema)) {
            codegenParameter.setIsString(false);
            codegenParameter.isDecimal = true;
            codegenParameter.isPrimitiveType = true;
        }
        if (Boolean.TRUE.equals(codegenParameter.isString)) {
            codegenParameter.isPrimitiveType = true;
        }
    }

    @Override
    protected void updatePropertyForAnyType(CodegenProperty property, Schema p) {
        if (Boolean.FALSE.equals(p.getNullable())) {
            this.LOGGER.warn("Schema '{}' is any type, which includes the 'null' value. 'nullable' cannot be set to 'false'", (Object)p.getName());
        }
        if (this.languageSpecificPrimitives.contains(property.dataType)) {
            property.isPrimitiveType = true;
        }
        if (ModelUtils.isMapSchema(p)) {
            this.updatePropertyForMap(property, p);
        }
    }

    @Override
    public GeneratorLanguage generatorLanguage() {
        return GeneratorLanguage.RUST;
    }

    @Override
    protected String getParameterDataType(Parameter parameter, Schema schema) {
        if (parameter.get$ref() != null) {
            String refName = ModelUtils.getSimpleRef(parameter.get$ref());
            return this.toModelName(refName);
        }
        return null;
    }
}

