/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.servers.Server;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractScalaCodegen;
import org.openapitools.codegen.languages.Marshaller;
import org.openapitools.codegen.languages.PathMatcherPattern;
import org.openapitools.codegen.languages.TextOrMatcher;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScalaAkkaHttpServerCodegen
extends AbstractScalaCodegen
implements CodegenConfig {
    protected String groupId;
    protected String artifactId;
    protected String artifactVersion;
    protected String invokerPackage;
    protected String akkaHttpVersion;
    protected boolean generateAsManagedSources;
    public static final String AKKA_HTTP_VERSION = "akkaHttpVersion";
    public static final String AKKA_HTTP_VERSION_DESC = "The version of akka-http";
    public static final String DEFAULT_AKKA_HTTP_VERSION = "10.1.10";
    public static final String GENERATE_AS_MANAGED_SOURCES = "asManagedSources";
    public static final String GENERATE_AS_MANAGED_SOURCES_DESC = "Resulting files cab be used as managed resources. No build files or default controllers will be generated";
    public static final boolean DEFAULT_GENERATE_AS_MANAGED_SOURCES = false;
    final Logger LOGGER = LoggerFactory.getLogger(ScalaAkkaHttpServerCodegen.class);
    private static final String IS_10_1_10_PLUS = "akkaHttp10_1_10_plus";
    private boolean is10_1_10AndAbove = false;
    private static final Pattern akkaVersionPattern = Pattern.compile("([0-9]+)(\\.([0-9]+))?(\\.([0-9]+))?(.\\+)?");
    private static final Set<String> primitiveParamTypes = ImmutableSet.of((Object)"Int", (Object)"Long", (Object)"Float", (Object)"Double", (Object)"Boolean", (Object)"String", (Object[])new String[0]);
    private static final Map<String, String> pathTypeToMatcher = ImmutableMap.builder().put((Object)"Int", (Object)"IntNumber").put((Object)"Long", (Object)"LongNumber").put((Object)"Float", (Object)"FloatNumber").put((Object)"Double", (Object)"DoubleNumber").put((Object)"Boolean", (Object)"Boolean").put((Object)"String", (Object)"Segment").build();
    public static String PATH_MATCHER_PATTERNS_KEY = "pathMatcherPatterns";

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "scala-akka-http-server";
    }

    @Override
    public String getHelp() {
        return "Generates a scala-akka-http server (beta).";
    }

    public ScalaAkkaHttpServerCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML, WireFormatFeature.Custom)).securityFeatures(EnumSet.of(SecurityFeature.BasicAuth, SecurityFeature.ApiKey, SecurityFeature.BearerToken)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}));
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.BETA).build();
        this.outputFolder = "generated-code" + File.separator + "scala-akka-http";
        this.modelTemplateFiles.put("model.mustache", ".scala");
        this.apiTemplateFiles.put("api.mustache", ".scala");
        this.templateDir = "scala-akka-http-server";
        this.embeddedTemplateDir = "scala-akka-http-server";
        this.groupId = "org.openapitools";
        this.artifactId = "openapi-scala-akka-http-server";
        this.artifactVersion = "1.0.0";
        this.apiPackage = "org.openapitools.server.api";
        this.modelPackage = "org.openapitools.server.model";
        this.invokerPackage = "org.openapitools.server";
        this.akkaHttpVersion = DEFAULT_AKKA_HTTP_VERSION;
        this.generateAsManagedSources = false;
        this.setReservedWordsLowerCase(Arrays.asList("abstract", "case", "catch", "class", "def", "do", "else", "extends", "false", "final", "finally", "for", "forSome", "if", "implicit", "import", "lazy", "match", "new", "null", "object", "override", "package", "private", "protected", "return", "sealed", "super", "this", "throw", "trait", "try", "true", "type", "val", "var", "while", "with", "yield"));
        this.cliOptions.add(CliOption.newString("invokerPackage", "root package for generated code").defaultValue(this.invokerPackage));
        this.cliOptions.add(CliOption.newString("groupId", "groupId in generated pom.xml").defaultValue(this.groupId));
        this.cliOptions.add(CliOption.newString("artifactId", "artifactId").defaultValue(this.artifactId));
        this.cliOptions.add(CliOption.newString("artifactVersion", "artifact version in generated pom.xml. This also becomes part of the generated library's filename").defaultValue(this.artifactVersion));
        this.cliOptions.add(CliOption.newString(AKKA_HTTP_VERSION, AKKA_HTTP_VERSION_DESC).defaultValue(this.akkaHttpVersion));
        this.cliOptions.add(CliOption.newBoolean(GENERATE_AS_MANAGED_SOURCES, GENERATE_AS_MANAGED_SOURCES_DESC).defaultValue(Boolean.valueOf(false).toString()));
        this.importMapping.remove("Seq");
        this.importMapping.remove("List");
        this.importMapping.remove("Set");
        this.importMapping.remove("Map");
        this.typeMapping = new HashMap();
        this.typeMapping.put("array", "Seq");
        this.typeMapping.put("set", "Set");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("int", "Int");
        this.typeMapping.put("integer", "Int");
        this.typeMapping.put("long", "Long");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("byte", "Byte");
        this.typeMapping.put("short", "Short");
        this.typeMapping.put("char", "Char");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("object", "Any");
        this.typeMapping.put("file", "File");
        this.typeMapping.put("binary", "File");
        this.typeMapping.put("number", "Double");
        this.typeMapping.put("decimal", "BigDecimal");
        this.instantiationTypes.put("array", "ListBuffer");
        this.instantiationTypes.put("map", "Map");
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("invokerPackage")) {
            this.invokerPackage = (String)this.additionalProperties.get("invokerPackage");
        } else {
            this.additionalProperties.put("invokerPackage", this.invokerPackage);
        }
        if (this.additionalProperties.containsKey("groupId")) {
            this.groupId = (String)this.additionalProperties.get("groupId");
        } else {
            this.additionalProperties.put("groupId", this.groupId);
        }
        if (this.additionalProperties.containsKey("artifactId")) {
            this.artifactId = (String)this.additionalProperties.get("artifactId");
        } else {
            this.additionalProperties.put("artifactId", this.artifactId);
        }
        if (this.additionalProperties.containsKey("artifactVersion")) {
            this.artifactVersion = (String)this.additionalProperties.get("artifactVersion");
        } else {
            this.additionalProperties.put("artifactVersion", this.artifactVersion);
        }
        if (this.additionalProperties.containsKey(AKKA_HTTP_VERSION)) {
            this.akkaHttpVersion = (String)this.additionalProperties.get(AKKA_HTTP_VERSION);
        } else {
            this.additionalProperties.put(AKKA_HTTP_VERSION, this.akkaHttpVersion);
        }
        this.parseAkkaHttpVersion();
        if (this.additionalProperties.containsKey(GENERATE_AS_MANAGED_SOURCES)) {
            this.generateAsManagedSources = Boolean.parseBoolean(this.additionalProperties.get(GENERATE_AS_MANAGED_SOURCES).toString());
        } else {
            this.additionalProperties.put(GENERATE_AS_MANAGED_SOURCES, Boolean.valueOf(this.generateAsManagedSources).toString());
        }
        if (!this.generateAsManagedSources) {
            this.supportingFiles.add(new SupportingFile("build.sbt.mustache", "", "build.sbt"));
            this.supportingFiles.add(new SupportingFile("controller.mustache", (this.sourceFolder + File.separator + this.invokerPackage).replace(".", File.separator), "Controller.scala"));
            this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        }
        this.supportingFiles.add(new SupportingFile("helper.mustache", (this.sourceFolder + File.separator + this.invokerPackage).replace(".", File.separator), "AkkaHttpHelper.scala"));
        this.supportingFiles.add(new SupportingFile("stringDirectives.mustache", (this.sourceFolder + File.separator + this.invokerPackage).replace(".", File.separator), "StringDirectives.scala"));
        this.supportingFiles.add(new SupportingFile("multipartDirectives.mustache", (this.sourceFolder + File.separator + this.invokerPackage).replace(".", File.separator), "MultipartDirectives.scala"));
    }

    private void parseAkkaHttpVersion() {
        Matcher matcher = akkaVersionPattern.matcher(this.akkaHttpVersion);
        if (matcher.matches()) {
            String majorS = matcher.group(1);
            String minorS = matcher.group(3);
            String patchS = matcher.group(5);
            boolean andAbove = matcher.group(6) != null;
            int major = -1;
            int minor = -1;
            int patch = -1;
            try {
                if (majorS != null) {
                    major = Integer.parseInt(majorS);
                    if (minorS != null) {
                        minor = Integer.parseInt(minorS);
                        if (patchS != null) {
                            patch = Integer.parseInt(patchS);
                        }
                    }
                }
                if (major > 10 || major == -1 && andAbove) {
                    this.is10_1_10AndAbove = true;
                } else if (major == 10) {
                    if (minor > 1 || minor == -1 && andAbove) {
                        this.is10_1_10AndAbove = true;
                    } else if (minor == 1 && (patch >= 10 || patch == -1 && andAbove)) {
                        this.is10_1_10AndAbove = true;
                    }
                }
            }
            catch (NumberFormatException e) {
                this.LOGGER.warn("Unable to parse {}: {}, fallback to {}", new Object[]{AKKA_HTTP_VERSION, this.akkaHttpVersion, DEFAULT_AKKA_HTTP_VERSION});
                this.akkaHttpVersion = DEFAULT_AKKA_HTTP_VERSION;
                this.is10_1_10AndAbove = true;
            }
        }
        this.additionalProperties.put(IS_10_1_10_PLUS, this.is10_1_10AndAbove);
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, List<Server> servers) {
        CodegenOperation codegenOperation = super.fromOperation(path, httpMethod, operation, servers);
        this.addPathMatcher(codegenOperation);
        return codegenOperation;
    }

    @Override
    public CodegenParameter fromParameter(Parameter parameter, Set<String> imports) {
        CodegenParameter param = super.fromParameter(parameter, imports);
        if (!primitiveParamTypes.contains(param.dataType)) {
            param.dataType = "String";
        }
        if (!param.required) {
            param.vendorExtensions.put("x-has-default-value", param.defaultValue != null);
            if (param.defaultValue != null && "String".equals(param.dataType)) {
                param.defaultValue = String.format(Locale.ROOT, "\"%s\"", param.defaultValue);
            }
        }
        return param;
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        Map<String, Object> baseObjs = super.postProcessOperationsWithModels(objs, allModels);
        ScalaAkkaHttpServerCodegen.pathMatcherPatternsPostProcessor(baseObjs);
        ScalaAkkaHttpServerCodegen.marshallingPostProcessor(baseObjs);
        return baseObjs;
    }

    protected void addPathMatcher(CodegenOperation codegenOperation) {
        LinkedList<String> allPaths = new LinkedList<String>(Arrays.asList(codegenOperation.path.split("/")));
        allPaths.removeIf(""::equals);
        LinkedList<TextOrMatcher> pathMatchers = new LinkedList<TextOrMatcher>();
        for (String path : allPaths) {
            TextOrMatcher textOrMatcher = new TextOrMatcher("", true);
            if (path.startsWith("{") && path.endsWith("}")) {
                String parameterName = path.substring(1, path.length() - 1);
                for (CodegenParameter pathParam : codegenOperation.pathParams) {
                    if (!pathParam.baseName.equals(parameterName)) continue;
                    String matcher = pathTypeToMatcher.get(pathParam.dataType);
                    if (matcher == null) {
                        this.LOGGER.warn("The path parameter {} with the datatype {} could not be translated to a corresponding path matcher of akka http and therefore has been translated to string.", (Object)pathParam.baseName, (Object)pathParam.dataType);
                        matcher = pathTypeToMatcher.get("String");
                    }
                    if (pathParam.pattern != null && !pathParam.pattern.isEmpty()) {
                        matcher = ScalaAkkaHttpServerCodegen.pathMatcherPatternName(pathParam);
                    }
                    textOrMatcher.value = matcher;
                    textOrMatcher.isText = false;
                    pathMatchers.add(textOrMatcher);
                }
                continue;
            }
            textOrMatcher.value = path;
            textOrMatcher.isText = true;
            pathMatchers.add(textOrMatcher);
        }
        codegenOperation.vendorExtensions.put("x-paths", pathMatchers);
    }

    private static void pathMatcherPatternsPostProcessor(Map<String, Object> objs) {
        if (objs != null) {
            HashMap<String, PathMatcherPattern> patternMap = new HashMap<String, PathMatcherPattern>();
            Map operations = (Map)objs.get("operations");
            if (operations != null) {
                List ops = (List)operations.get("operation");
                for (CodegenOperation operation : ops) {
                    for (CodegenParameter parameter : operation.pathParams) {
                        String name;
                        if (parameter.pattern == null || parameter.pattern.isEmpty() || patternMap.containsKey(name = ScalaAkkaHttpServerCodegen.pathMatcherPatternName(parameter))) continue;
                        patternMap.put(name, new PathMatcherPattern(name, parameter.pattern.substring(1, parameter.pattern.length() - 1)));
                    }
                }
            }
            objs.put(PATH_MATCHER_PATTERNS_KEY, new ArrayList(patternMap.values()));
        }
    }

    private static String pathMatcherPatternName(CodegenParameter parameter) {
        return parameter.paramName + "Pattern";
    }

    public static void marshallingPostProcessor(Map<String, Object> objs) {
        if (objs == null) {
            return;
        }
        HashSet<Marshaller> entityUnmarshallerTypes = new HashSet<Marshaller>();
        HashSet<Marshaller> entityMarshallerTypes = new HashSet<Marshaller>();
        HashSet<Marshaller> stringUnmarshallerTypes = new HashSet<Marshaller>();
        boolean hasCookieParams = false;
        boolean hasMultipart = false;
        Map operations = (Map)objs.get("operations");
        if (operations != null) {
            List operationList = (List)operations.get("operation");
            for (CodegenOperation op : operationList) {
                boolean isMultipart = op.isMultipart;
                hasMultipart |= isMultipart;
                hasCookieParams |= op.getHasCookieParams();
                ArrayList<CodegenParameter> fileParams = new ArrayList<CodegenParameter>();
                ArrayList<CodegenParameter> nonFileParams = new ArrayList<CodegenParameter>();
                for (CodegenParameter parameter : op.allParams) {
                    if (!parameter.isBodyParam && !parameter.isFormParam) continue;
                    if (parameter.isFile) {
                        fileParams.add(parameter.copy());
                    } else {
                        nonFileParams.add(parameter.copy());
                    }
                    if (parameter.isPrimitiveType) continue;
                    if (isMultipart) {
                        stringUnmarshallerTypes.add(new Marshaller(parameter));
                        continue;
                    }
                    entityUnmarshallerTypes.add(new Marshaller(parameter));
                }
                HashSet<Marshaller> operationSpecificMarshallers = new HashSet<Marshaller>();
                for (CodegenResponse response : op.responses) {
                    if (!response.primitiveType) {
                        Marshaller marshaller = new Marshaller(response);
                        entityMarshallerTypes.add(marshaller);
                        operationSpecificMarshallers.add(marshaller);
                    }
                    response.vendorExtensions.put("x-empty-response", response.baseType == null && response.message == null);
                    response.vendorExtensions.put("x-is-default", "0".equals(response.code));
                }
                op.vendorExtensions.put("x-specific-marshallers", operationSpecificMarshallers);
                op.vendorExtensions.put("x-file-params", fileParams);
                op.vendorExtensions.put("x-non-file-params", nonFileParams);
            }
        }
        objs.put("hasCookieParams", hasCookieParams);
        objs.put("entityMarshallers", entityMarshallerTypes);
        objs.put("entityUnmarshallers", entityUnmarshallerTypes);
        objs.put("stringUnmarshallers", stringUnmarshallerTypes);
        objs.put("hasMarshalling", !entityMarshallerTypes.isEmpty() || !entityUnmarshallerTypes.isEmpty() || !stringUnmarshallerTypes.isEmpty());
        objs.put("hasMultipart", hasMultipart);
    }
}

