/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErlangProperCodegen
extends DefaultCodegen
implements CodegenConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(ErlangProperCodegen.class);
    protected String packageName = "openapi";
    protected String packageVersion = "1.0.0";
    protected String sourceFolder = "src";
    protected String modelFolder = "model";

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "erlang-proper";
    }

    @Override
    public String getHelp() {
        return "Generates an Erlang library with PropEr generators (beta).";
    }

    public ErlangProperCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON)).securityFeatures(EnumSet.of(SecurityFeature.ApiKey, SecurityFeature.BasicAuth)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}).includeClientModificationFeatures(new ClientModificationFeature[]{ClientModificationFeature.BasePath}));
        this.outputFolder = "generated-code/erlang";
        this.modelTemplateFiles.put("model.mustache", ".erl");
        this.apiTemplateFiles.put("api.mustache", "_api.erl");
        this.apiTemplateFiles.put("statem.mustache", "_statem.erl");
        this.templateDir = "erlang-proper";
        this.embeddedTemplateDir = "erlang-proper";
        this.setReservedWordsLowerCase(Arrays.asList("after", "and", "andalso", "band", "begin", "bnot", "bor", "bsl", "bsr", "bxor", "case", "catch", "cond", "div", "end", "fun", "if", "let", "not", "of", "or", "orelse", "receive", "rem", "try", "when", "xor"));
        this.instantiationTypes.clear();
        this.typeMapping.clear();
        this.typeMapping.put("enum", "binary()");
        this.typeMapping.put("date", "date()");
        this.typeMapping.put("datetime", "datetime()");
        this.typeMapping.put("DateTime", "datetime()");
        this.typeMapping.put("boolean", "boolean()");
        this.typeMapping.put("string", "binary()");
        this.typeMapping.put("integer", "integer()");
        this.typeMapping.put("int", "integer()");
        this.typeMapping.put("float", "integer()");
        this.typeMapping.put("long", "integer()");
        this.typeMapping.put("double", "float()");
        this.typeMapping.put("array", "list()");
        this.typeMapping.put("map", "map()");
        this.typeMapping.put("number", "integer()");
        this.typeMapping.put("bigdecimal", "float()");
        this.typeMapping.put("List", "list()");
        this.typeMapping.put("object", "map()");
        this.typeMapping.put("file", "binary()");
        this.typeMapping.put("binary", "binary()");
        this.typeMapping.put("bytearray", "binary()");
        this.typeMapping.put("byte", "binary()");
        this.typeMapping.put("uuid", "binary()");
        this.typeMapping.put("uri", "binary()");
        this.typeMapping.put("password", "binary()");
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption("packageName", "Erlang application name (convention: lowercase).").defaultValue(this.packageName));
        this.cliOptions.add(new CliOption("packageVersion", "Erlang application version").defaultValue(this.packageVersion));
    }

    @Override
    public CodegenModel fromModel(String name, Schema model) {
        CodegenModel cm = super.fromModel(name, model);
        if (ModelUtils.isArraySchema(model)) {
            return new CodegenArrayModel(cm, (ArraySchema)model);
        }
        return cm;
    }

    @Override
    public String getTypeDeclaration(String name) {
        return name + ":" + name + "()";
    }

    @Override
    public String getTypeDeclaration(Schema schema) {
        String typeDeclaration = super.getSchemaType(schema);
        if (ModelUtils.isArraySchema(schema)) {
            ArraySchema arraySchema = (ArraySchema)schema;
            String complexType = this.getSchemaType(arraySchema.getItems());
            StringBuilder sb = new StringBuilder("list(");
            sb.append(complexType);
            return sb.append(")").toString();
        }
        if (this.typeMapping.containsKey(typeDeclaration)) {
            return (String)this.typeMapping.get(typeDeclaration);
        }
        return this.getTypeDeclaration(this.toModelName(this.lowerCamelCase(typeDeclaration)));
    }

    @Override
    public String getSchemaType(Schema schema) {
        String schemaType = super.getSchemaType(schema);
        if (ModelUtils.isArraySchema(schema)) {
            ArraySchema arraySchema = (ArraySchema)schema;
            String complexType = this.getSchemaType(arraySchema.getItems());
            StringBuilder sb = new StringBuilder("list(");
            sb.append(complexType);
            Integer minItems = schema.getMinItems();
            Integer maxItems = schema.getMaxItems();
            if (minItems != null) {
                sb.append(", ").append(minItems);
            }
            if (minItems != null && maxItems != null) {
                sb.append(", ").append(maxItems);
            }
            return sb.append(")").toString();
        }
        if (ModelUtils.isIntegerSchema(schema)) {
            StringBuilder sb = new StringBuilder("integer(");
            BigDecimal min = schema.getMinimum();
            BigDecimal max = schema.getMaximum();
            if (min != null) {
                sb.append(min);
            }
            if (min != null && max != null) {
                sb.append(", ").append(max);
            }
            return sb.append(")").toString();
        }
        if (ModelUtils.isDateSchema(schema) || ModelUtils.isDateTimeSchema(schema)) {
            return (String)this.typeMapping.get(schemaType);
        }
        if (ModelUtils.isStringSchema(schema)) {
            StringBuilder sb = new StringBuilder("binary(");
            Integer min = schema.getMinLength();
            Integer max = schema.getMaxLength();
            if (min != null) {
                sb.append(min);
            }
            if (min != null && max != null) {
                sb.append(", ").append(max);
            }
            return sb.append(")").toString();
        }
        if (this.typeMapping.containsKey(schemaType)) {
            return (String)this.typeMapping.get(schemaType);
        }
        return this.getTypeDeclaration(this.toModelName(this.lowerCamelCase(schemaType)));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        } else {
            this.setPackageName("openapi");
        }
        if (this.additionalProperties.containsKey("packageVersion")) {
            this.setPackageVersion((String)this.additionalProperties.get("packageVersion"));
        } else {
            this.setPackageVersion("1.0.0");
        }
        this.additionalProperties.put("packageName", this.packageName);
        this.additionalProperties.put("packageVersion", this.packageVersion);
        this.additionalProperties.put("length", new Mustache.Lambda(){

            public void execute(Template.Fragment fragment, Writer writer) throws IOException {
                writer.write(ErlangProperCodegen.this.length(fragment.context()));
            }
        });
        this.additionalProperties.put("qsEncode", new Mustache.Lambda(){

            public void execute(Template.Fragment fragment, Writer writer) throws IOException {
                writer.write(ErlangProperCodegen.this.qsEncode(fragment.context()));
            }
        });
        this.modelPackage = this.packageName;
        this.apiPackage = this.packageName;
        this.supportingFiles.add(new SupportingFile("rebar.config.mustache", "", "rebar.config"));
        this.supportingFiles.add(new SupportingFile("app.src.mustache", "", "src" + File.separator + this.packageName + ".app.src"));
        this.supportingFiles.add(new SupportingFile("utils.mustache", "", "src" + File.separator + this.packageName + "_utils.erl"));
        this.supportingFiles.add(new SupportingFile("gen.mustache", "", "src" + File.separator + this.packageName + "_gen.erl"));
        this.supportingFiles.add(new SupportingFile("include.mustache", "", "src" + File.separator + this.packageName + ".hrl"));
        this.supportingFiles.add(new SupportingFile("statem.hrl.mustache", "", "src" + File.separator + this.packageName + "_statem.hrl"));
        this.supportingFiles.add(new SupportingFile("test.mustache", "", "test" + File.separator + "prop_" + this.packageName + ".erl"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
    }

    private String qsEncode(Object o) {
        String r = "";
        CodegenParameter q = (CodegenParameter)o;
        if (q.required) {
            r = q.isArray ? r + "[{<<\"" + q.baseName + "\">>, X} || X <- " + q.paramName + "]" : r + "{<<\"" + q.baseName + "\">>, " + q.paramName + "}";
        }
        return r;
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return StringUtils.camelize(name) + '_';
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator;
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.modelFolder + File.separator;
    }

    @Override
    public String toVarName(String name) {
        if (this.isReservedWord(name = this.sanitizeName(name.replaceAll("-", "_")))) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return StringUtils.camelize(this.toVarName(name));
    }

    @Override
    public String toArrayModelParamName(String name) {
        if (name == null) {
            this.LOGGER.warn("parameter name for array model is null. Default to 'array_model'.");
            name = "array_model";
        }
        if (name.indexOf(":") > 0) {
            name = name.substring(0, name.indexOf(":")) + "_array";
        }
        return this.toParamName(name);
    }

    @Override
    public String toModelName(String name) {
        return this.packageName + "_" + StringUtils.underscore(name.replaceAll("-", "_").replaceAll("\\.", "_"));
    }

    @Override
    public String toApiName(String name) {
        return this.packageName;
    }

    @Override
    public String toModelFilename(String name) {
        return this.packageName + "_" + StringUtils.underscore(name.replaceAll("\\.", "_"));
    }

    @Override
    public String toApiFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String toOperationId(String operationId) {
        if (this.isReservedWord(operationId)) {
            this.LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + StringUtils.underscore(this.sanitizeName("call_" + operationId)).replaceAll("\\.", "_"));
            operationId = "call_" + operationId;
        }
        return StringUtils.underscore(operationId.replaceAll("\\.", "_"));
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        Map operations = (Map)objs.get("operations");
        List os = (List)operations.get("operation");
        ArrayList<ExtendedCodegenOperation> newOs = new ArrayList<ExtendedCodegenOperation>();
        Pattern pattern = Pattern.compile("\\{([^\\}]+)\\}");
        for (CodegenOperation o : os) {
            o.httpMethod = o.httpMethod.toLowerCase(Locale.ROOT);
            if (o.isArray) {
                o.returnType = "[" + o.returnBaseType + "]";
            }
            Matcher matcher = pattern.matcher(o.path);
            StringBuffer buffer = new StringBuffer();
            while (matcher.find()) {
                String pathTemplateName = matcher.group(1);
                matcher.appendReplacement(buffer, "\", " + StringUtils.camelize(pathTemplateName) + ", \"");
            }
            matcher.appendTail(buffer);
            ExtendedCodegenOperation eco = new ExtendedCodegenOperation(o);
            if (buffer.length() == 0) {
                eco.setReplacedPathName(o.path);
            } else {
                eco.setReplacedPathName(buffer.toString());
            }
            newOs.add(eco);
        }
        operations.put("operation", newOs);
        return objs;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    String length(Object os) {
        int l = 1;
        for (CodegenParameter o : ((ExtendedCodegenOperation)os).allParams) {
            if (!o.required) continue;
            ++l;
        }
        return Integer.toString(l);
    }

    private int lengthRequired(List<CodegenParameter> allParams) {
        int l = 0;
        for (CodegenParameter o : allParams) {
            if (!o.required && !o.isBodyParam) continue;
            ++l;
        }
        return l;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    class ExtendedCodegenOperation
    extends CodegenOperation {
        private String replacedPathName;
        String arity;

        ExtendedCodegenOperation(CodegenOperation o) {
            this.responseHeaders.addAll(o.responseHeaders);
            this.hasAuthMethods = o.hasAuthMethods;
            this.hasConsumes = o.hasConsumes;
            this.hasProduces = o.hasProduces;
            this.hasParams = o.hasParams;
            this.hasOptionalParams = o.hasOptionalParams;
            this.returnTypeIsPrimitive = o.returnTypeIsPrimitive;
            this.returnSimpleType = o.returnSimpleType;
            this.subresourceOperation = o.subresourceOperation;
            this.isMap = o.isMap;
            this.isArray = o.isArray;
            this.isMultipart = o.isMultipart;
            this.isResponseBinary = o.isResponseBinary;
            this.hasReference = o.hasReference;
            this.isRestfulIndex = o.isRestfulIndex;
            this.isRestfulShow = o.isRestfulShow;
            this.isRestfulCreate = o.isRestfulCreate;
            this.isRestfulUpdate = o.isRestfulUpdate;
            this.isRestfulDestroy = o.isRestfulDestroy;
            this.isRestful = o.isRestful;
            this.path = o.path;
            this.operationId = o.operationId;
            this.returnType = o.returnType;
            this.httpMethod = o.httpMethod;
            this.returnBaseType = o.returnBaseType;
            this.returnContainer = o.returnContainer;
            this.summary = o.summary;
            this.unescapedNotes = o.unescapedNotes;
            this.notes = o.notes;
            this.baseName = o.baseName;
            this.defaultResponse = o.defaultResponse;
            this.discriminator = o.discriminator;
            this.consumes = o.consumes;
            this.produces = o.produces;
            this.bodyParam = o.bodyParam;
            this.allParams = o.allParams;
            this.arity = Integer.toString(ErlangProperCodegen.this.lengthRequired(o.allParams));
            this.bodyParams = o.bodyParams;
            this.pathParams = o.pathParams;
            this.queryParams = o.queryParams;
            this.headerParams = o.headerParams;
            this.formParams = o.formParams;
            this.authMethods = o.authMethods;
            this.tags = o.tags;
            this.responses = o.responses;
            this.imports = o.imports;
            this.examples = o.examples;
            this.externalDocs = o.externalDocs;
            this.vendorExtensions = o.vendorExtensions;
            this.nickname = o.nickname;
            this.operationIdLowerCase = o.operationIdLowerCase;
            this.operationIdCamelCase = o.operationIdCamelCase;
        }

        public String getReplacedPathName() {
            return this.replacedPathName;
        }

        public void setReplacedPathName(String replacedPathName) {
            this.replacedPathName = replacedPathName;
        }
    }

    class CodegenArrayModel
    extends CodegenModel {
        Integer minItems;
        Integer maxItems;

        public CodegenArrayModel(CodegenModel cm, ArraySchema schema) {
            this.parent = cm.parent;
            this.parentSchema = cm.parentSchema;
            this.parentModel = cm.parentModel;
            this.interfaceModels = cm.interfaceModels;
            this.children = cm.children;
            this.name = cm.name;
            this.classname = cm.classname;
            this.title = cm.title;
            this.description = cm.description;
            this.classVarName = cm.classVarName;
            this.modelJson = cm.modelJson;
            this.dataType = cm.dataType;
            this.xmlPrefix = cm.xmlPrefix;
            this.xmlNamespace = cm.xmlNamespace;
            this.xmlName = cm.xmlName;
            this.classFilename = cm.classFilename;
            this.unescapedDescription = cm.unescapedDescription;
            this.discriminator = cm.discriminator;
            this.defaultValue = cm.defaultValue;
            this.arrayModelType = cm.arrayModelType;
            this.isAlias = cm.isAlias;
            this.vars = cm.vars;
            this.requiredVars = cm.requiredVars;
            this.optionalVars = cm.optionalVars;
            this.readOnlyVars = cm.readOnlyVars;
            this.readWriteVars = cm.readWriteVars;
            this.allVars = cm.allVars;
            this.parentVars = cm.parentVars;
            this.allowableValues = cm.allowableValues;
            this.mandatory = cm.mandatory;
            this.allMandatory = cm.allMandatory;
            this.imports = cm.imports;
            this.hasVars = cm.hasVars;
            this.emptyVars = cm.emptyVars;
            this.hasMoreModels = cm.hasMoreModels;
            this.hasEnums = cm.hasEnums;
            this.isEnum = cm.isEnum;
            this.hasRequired = cm.hasRequired;
            this.hasOptional = cm.hasOptional;
            this.isArray = cm.isArray;
            this.hasChildren = cm.hasChildren;
            this.hasOnlyReadOnly = cm.hasOnlyReadOnly;
            this.externalDocumentation = cm.externalDocumentation;
            this.vendorExtensions = cm.vendorExtensions;
            this.additionalPropertiesType = cm.additionalPropertiesType;
            this.minItems = schema.getMinItems();
            this.maxItems = schema.getMaxItems();
        }
    }
}

