/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.ProcessUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PowerShellExperimentalClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(PowerShellExperimentalClientCodegen.class);
    private String packageGuid = "{" + UUID.randomUUID().toString().toUpperCase(Locale.ROOT) + "}";
    protected String sourceFolder = "src";
    protected String packageName = "PSOpenAPITools";
    protected String packageVersion = "0.1.2";
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";
    protected String apiTestPath = "tests/Api";
    protected String modelTestPath = "tests/Model";
    protected HashSet nullablePrimitives;
    protected HashSet powershellVerbs;

    public PowerShellExperimentalClientCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML)).securityFeatures(EnumSet.of(SecurityFeature.BasicAuth, SecurityFeature.ApiKey, SecurityFeature.OAuth2_Implicit)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}));
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.BETA).build();
        this.outputFolder = "generated-code" + File.separator + "powershell-expiermental";
        this.modelTemplateFiles.put("model.mustache", ".ps1");
        this.apiTemplateFiles.put("api.mustache", ".ps1");
        this.modelTestTemplateFiles.put("model_test.mustache", ".ps1");
        this.apiTestTemplateFiles.put("api_test.mustache", ".ps1");
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.templateDir = "powershell-experimental";
        this.embeddedTemplateDir = "powershell-experimental";
        this.apiPackage = this.packageName + File.separator + "Api";
        this.modelPackage = this.packageName + File.separator + "Model";
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("Byte", "SByte", "Byte[]", "Int16", "Int32", "Int64", "UInt16", "UInt32", "UInt64", "Decimal", "Single", "Double", "TimeSpan", "System.DateTime", "ProgressRecord", "Char", "String", "XmlDocument", "SecureString", "Boolean", "Guid", "Uri", "System.IO.FileInfo", "Version"));
        this.powershellVerbs = new HashSet<String>(Arrays.asList("Add", "Clear", "Close", "Copy", "Enter", "Exit", "Find", "Format", "Get", "Hide", "Join", "Lock", "Move", "New", "Open", "Optimize", "Pop", "Push", "Redo", "Remove", "Rename", "Reset", "Search", "Select", "Set", "Show", "Skip", "Split", "Step", "Switch", "Undo", "Unlock", "Watch", "Connect", "Disconnect", "Read", "Receive", "Send", "Write", "Backup", "Checkpoint", "Compare", "Compress", "Convert", "ConvertFrom", "ConvertTo", "Dismount", "Edit", "Expand", "Export", "Group", "Import", "Initialize", "Limit", "Merge", "Mount", "Out", "Publish", "Restore", "Save", "Sync", "Unpublish", "Update", "Debug", "Measure", "Ping", "Repair", "Resolve", "Test", "Trace", "Approve", "Assert", "Build", "Complete", "Confirm", "Deny", "Deploy", "Disable", "Enable", "Install", "Invoke", "Register", "Request", "Restart", "Resume", "Start", "Stop", "Submit", "Suspend", "Uninstall", "Unregister", "Wait", "Block", "Grant", "Protect", "Revoke", "Unblock", "Unprotect", "Use"));
        this.nullablePrimitives = new HashSet<String>(Arrays.asList("System.Nullable[Byte]", "System.Nullable[SByte]", "System.Nullable[Int16]", "System.Nullable[Int32]", "System.Nullable[Int64]", "System.Nullable[UInt16]", "System.Nullable[UInt32]", "System.Nullable[UInt64]", "System.Nullable[Decimal]", "System.Nullable[Single]", "System.Nullable[Double]", "System.Nullable[Boolean]"));
        this.reservedWords = new HashSet<String>(Arrays.asList("Begin", "Break", "Catch", "Continue", "Data", "Do", "Dynamicparam", "Else", "Elseif", "End", "Exit", "Filter", "Finally", "For", "Foreach", "From", "Function", "If", "In", "Param", "Process", "Return", "Switch", "Throw", "Trap", "Try", "Until", "While", "Local", "Private", "Where"));
        this.defaultIncludes = new HashSet<String>(Arrays.asList("Byte", "SByte", "Byte[]", "Int16", "Int32", "Int64", "UInt16", "UInt32", "UInt64", "Decimal", "Single", "Double", "TimeSpan", "System.DateTime", "ProgressRecord", "Char", "String", "XmlDocument", "SecureString", "Boolean", "Guid", "Uri", "System.IO.FileInfo", "Version"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("string", "String");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("integer", "Int32");
        this.typeMapping.put("float", "Double");
        this.typeMapping.put("long", "Int64");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("number", "Decimal");
        this.typeMapping.put("date-time", "System.DateTime");
        this.typeMapping.put("date", "System.DateTime");
        this.typeMapping.put("object", "String");
        this.typeMapping.put("file", "System.IO.FileInfo");
        this.typeMapping.put("binary", "System.IO.FileInfo");
        this.typeMapping.put("Date", "System.DateTime");
        this.typeMapping.put("DateTime", "System.DateTime");
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption("packageName", "Client package name (e.g. org.openapitools.client).").defaultValue(this.packageName));
        this.cliOptions.add(new CliOption("packageVersion", "Package version (e.g. 0.1.2).").defaultValue(this.packageVersion));
        this.cliOptions.add(new CliOption("packageGuid", "GUID for PowerShell module (e.g. a27b908d-2a20-467f-bc32-af6f3a654ac5). A random GUID will be generated by default."));
        this.cliOptions.add(new CliOption("apiNamePrefix", "Prefix that will be appended to all API names ('tags'). Default: empty string. e.g. Pet => Pet."));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "powershell-experimental";
    }

    @Override
    public String getHelp() {
        return "Generates a PowerShell API client (beta)";
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
        this.apiPackage = packageName + File.separator + "Api";
        this.modelPackage = packageName + File.separator + "Model";
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    public void setPackageGuid(String packageGuid) {
        this.packageGuid = packageGuid;
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("packageGuid")) {
            this.setPackageGuid((String)this.additionalProperties.get("packageGuid"));
        }
        this.additionalProperties.put("packageGuid", this.packageGuid);
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        } else {
            this.additionalProperties.put("packageName", this.packageName);
        }
        if (this.additionalProperties.containsKey("packageVersion")) {
            this.setPackageVersion((String)this.additionalProperties.get("packageVersion"));
        } else {
            this.additionalProperties.put("packageVersion", this.packageVersion);
        }
        if (this.additionalProperties.containsKey("modelPackage")) {
            LOGGER.warn("modelPackage with " + this.getName() + " generator is ignored. Setting this value independently of " + "packageName" + " is not currently supported.");
        }
        if (this.additionalProperties.containsKey("apiPackage")) {
            LOGGER.warn("apiPackage with " + this.getName() + " generator is ignored. Setting this value independently of " + "packageName" + " is not currently supported.");
        }
        this.additionalProperties.put("apiPackage", this.apiPackage());
        this.additionalProperties.put("modelPackage", this.modelPackage());
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("Build.ps1.mustache", "", "Build.ps1"));
        String infrastructureFolder = this.sourceFolder + File.separator + this.packageName + File.separator;
        this.supportingFiles.add(new SupportingFile("Org.OpenAPITools.psm1.mustache", infrastructureFolder, this.packageName + ".psm1"));
        this.supportingFiles.add(new SupportingFile("configuration.mustache", infrastructureFolder + "Client", this.apiNamePrefix + "Configuration.ps1"));
        this.supportingFiles.add(new SupportingFile("api_client.mustache", infrastructureFolder + "Private", this.apiNamePrefix + "ApiClient.ps1"));
        this.supportingFiles.add(new SupportingFile("Get-CommonParameters.mustache", infrastructureFolder + File.separator + "Private" + File.separator, "Get-CommonParameters.ps1"));
        this.supportingFiles.add(new SupportingFile("Out-DebugParameter.mustache", infrastructureFolder + File.separator + "Private" + File.separator, "Out-DebugParameter.ps1"));
        this.supportingFiles.add(new SupportingFile("about_Org.OpenAPITools.help.txt.mustache", infrastructureFolder + File.separator + "en-US" + File.separator + "about_" + this.packageName + ".help.txt"));
        this.supportingFiles.add(new SupportingFile("appveyor.mustache", "", "appveyor.yml"));
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("#>", "#_>").replace("<#", "<_#");
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String toApiTestFilename(String name) {
        return this.toApiFilename(name) + ".Tests";
    }

    @Override
    public String toModelTestFilename(String name) {
        return this.toModelFilename(name) + ".Tests";
    }

    @Override
    public String apiTestFileFolder() {
        return (this.outputFolder + "/" + this.apiTestPath).replace('/', File.separatorChar);
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + "/" + this.apiDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.apiPackage();
    }

    @Override
    public String modelTestFileFolder() {
        return (this.outputFolder + "/" + this.modelTestPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.modelPackage();
    }

    @Override
    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    @Override
    public String toModelName(String name) {
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(name = this.sanitizeName(name))) {
            LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + StringUtils.camelize("model_" + name));
            name = "model_" + name;
        }
        if (name.matches("^\\d.*")) {
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + StringUtils.camelize("model_" + name));
            name = "model_" + name;
        }
        return StringUtils.camelize(name);
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String getSchemaType(Schema p) {
        String type;
        String openAPIType = super.getSchemaType(p);
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = openAPIType;
        }
        return this.toModelName(type);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return this.getTypeDeclaration(inner) + "[]";
        }
        if (ModelUtils.isMapSchema(p)) {
            return "Hashtable";
        }
        if (!this.languageSpecificPrimitives.contains(this.getSchemaType(p))) {
            return super.getTypeDeclaration(p);
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        return this.sanitizeName(operationId);
    }

    @Override
    public String toParamName(String name) {
        name = this.sanitizeName(name);
        if ((name = name.replaceAll("-", "_")).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = StringUtils.camelize(name, false)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        Map operations = (Map)objs.get("operations");
        HashMap<String, CodegenModel> modelMaps = new HashMap<String, CodegenModel>();
        HashMap<String, Integer> processedModelMaps = new HashMap<String, Integer>();
        for (Object o : allModels) {
            HashMap h = (HashMap)o;
            CodegenModel m = (CodegenModel)h.get("model");
            modelMaps.put(m.classname, m);
        }
        List operationList = (List)operations.get("operation");
        for (CodegenOperation op : operationList) {
            int index = 0;
            for (CodegenParameter p : op.allParams) {
                p.vendorExtensions.put("x-powershell-data-type", this.getPSDataType(p));
                p.vendorExtensions.put("x-powershell-example", this.constructExampleCode(p, modelMaps, processedModelMaps));
                p.vendorExtensions.put("x-index", index);
                ++index;
            }
            if (!op.vendorExtensions.containsKey("x-powershell-method-name")) {
                String methodName = this.toMethodName(op.operationId);
                op.vendorExtensions.put("x-powershell-method-name", methodName);
                op.vendorExtensions.put("x-powershell-method-name-lowercase", methodName);
                continue;
            }
            op.vendorExtensions.put("x-powershell-method-name-lowercase", ((String)op.vendorExtensions.get("x-powershell-method-name")).toLowerCase(Locale.ROOT));
        }
        processedModelMaps.clear();
        for (CodegenOperation operation : operationList) {
            for (CodegenParameter cp : operation.allParams) {
                cp.vendorExtensions.put("x-powershell-example", this.constructExampleCode(cp, modelMaps, processedModelMaps));
            }
        }
        return objs;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        List models = (List)objs.get("models");
        ProcessUtils.addIndexToProperties(models);
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            for (CodegenProperty cp : cm.vars) {
                cp.vendorExtensions.put("x-powershell-data-type", this.getPSDataType(cp));
            }
        }
        return objs;
    }

    @Override
    public String toVarName(String name) {
        if ((name = this.sanitizeName(name)).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = StringUtils.camelize(name)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    private String constructExampleCode(CodegenParameter codegenParameter, HashMap<String, CodegenModel> modelMaps, HashMap<String, Integer> processedModelMap) {
        if (codegenParameter.isListContainer) {
            return "@(" + this.constructExampleCode(codegenParameter.items, modelMaps, processedModelMap) + ")";
        }
        if (codegenParameter.isMapContainer) {
            return "\"TODO\"";
        }
        if (this.languageSpecificPrimitives.contains(codegenParameter.dataType) || this.nullablePrimitives.contains(codegenParameter.dataType)) {
            if ("String".equals(codegenParameter.dataType) || "Character".equals(codegenParameter.dataType)) {
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenParameter.example)) {
                    return "\"" + codegenParameter.example + "\"";
                }
                return "\"" + codegenParameter.paramName + "_example\"";
            }
            if ("Boolean".equals(codegenParameter.dataType) || "System.Nullable[Boolean]".equals(codegenParameter.dataType)) {
                if (Boolean.parseBoolean(codegenParameter.example)) {
                    return "true";
                }
                return "false";
            }
            if ("URL".equals(codegenParameter.dataType)) {
                return "URL(string: \"https://example.com\")!";
            }
            if ("System.DateTime".equals(codegenParameter.dataType)) {
                return "Get-Date";
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenParameter.example)) {
                return codegenParameter.example;
            }
            return "987";
        }
        if (modelMaps.containsKey(codegenParameter.dataType)) {
            return this.constructExampleCode(modelMaps.get(codegenParameter.dataType), modelMaps, processedModelMap);
        }
        return "TODO";
    }

    private String constructExampleCode(CodegenProperty codegenProperty, HashMap<String, CodegenModel> modelMaps, HashMap<String, Integer> processedModelMap) {
        if (codegenProperty.isListContainer) {
            return "@(" + this.constructExampleCode(codegenProperty.items, modelMaps, processedModelMap) + ")";
        }
        if (codegenProperty.isMapContainer) {
            return "\"TODO\"";
        }
        if (this.languageSpecificPrimitives.contains(codegenProperty.dataType) || this.nullablePrimitives.contains(codegenProperty.dataType)) {
            if ("String".equals(codegenProperty.dataType)) {
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenProperty.example)) {
                    return "\"" + codegenProperty.example + "\"";
                }
                return "\"" + codegenProperty.name + "_example\"";
            }
            if ("Boolean".equals(codegenProperty.dataType) || "System.Nullable[Boolean]".equals(codegenProperty.dataType)) {
                if (Boolean.parseBoolean(codegenProperty.example)) {
                    return "$true";
                }
                return "$false";
            }
            if ("URL".equals(codegenProperty.dataType)) {
                return "URL(string: \"https://example.com\")!";
            }
            if ("System.DateTime".equals(codegenProperty.dataType)) {
                return "Get-Date";
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenProperty.example)) {
                return codegenProperty.example;
            }
            return "123";
        }
        if (modelMaps.containsKey(codegenProperty.dataType)) {
            return this.constructExampleCode(modelMaps.get(codegenProperty.dataType), modelMaps, processedModelMap);
        }
        return "\"TODO\"";
    }

    /*
     * Enabled aggressive block sorting
     */
    private String constructExampleCode(CodegenModel codegenModel, HashMap<String, CodegenModel> modelMaps, HashMap<String, Integer> processedModelMap) {
        block5: {
            String model = codegenModel.name;
            if (processedModelMap.containsKey(model)) {
                int count = processedModelMap.get(model);
                if (count == 1) {
                    processedModelMap.put(model, 2);
                    break block5;
                } else {
                    if (count != 2) throw new RuntimeException("Invalid count when constructing example: " + count);
                    return "";
                }
            }
            processedModelMap.put(model, 1);
        }
        String example = "(New-" + codegenModel.name;
        ArrayList<String> propertyExamples = new ArrayList<String>();
        Iterator<CodegenProperty> iterator = codegenModel.vars.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                example = example + org.apache.commons.lang3.StringUtils.join(propertyExamples, (String)" ");
                return example + ")";
            }
            CodegenProperty codegenProperty = iterator.next();
            propertyExamples.add(" -" + codegenProperty.name + " " + this.constructExampleCode(codegenProperty, modelMaps, processedModelMap));
        }
    }

    private String getPSDataType(CodegenProperty cp) {
        if (cp.isPrimitiveType) {
            String dataType = cp.dataType;
            if (!(cp.isString || cp.isFile || cp.isContainer || !cp.isNullable && cp.required)) {
                dataType = "System.Nullable[" + dataType + "]";
            }
            return dataType;
        }
        if (cp.isListContainer) {
            return this.getPSDataType(cp.items) + "[]";
        }
        if (cp.isMapContainer) {
            return "Hashtable";
        }
        return "PSCustomObject";
    }

    private String getPSDataType(CodegenParameter cp) {
        if (cp.isPrimitiveType) {
            String dataType = cp.dataType;
            if (!(cp.isString || cp.isFile || cp.isContainer || !cp.isNullable && cp.required)) {
                dataType = "System.Nullable[" + dataType + "]";
            }
            return dataType;
        }
        if (cp.isListContainer) {
            return this.getPSDataType(cp.items) + "[]";
        }
        if (cp.isMapContainer) {
            return "Hashtable";
        }
        return "PSCustomObject";
    }

    private String toMethodName(String operationId) {
        String methodName = StringUtils.camelize(operationId);
        for (String verb : this.powershellVerbs) {
            if (!methodName.startsWith(verb)) continue;
            methodName = verb + "-" + this.apiNamePrefix + methodName.substring(verb.length());
            LOGGER.info("Naming the method using the PowerShell verb: {} => {}", (Object)operationId, (Object)methodName);
            return methodName;
        }
        return "Invoke-" + this.apiNamePrefix + methodName;
    }
}

