/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenSecurity;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractPhpCodegen;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhpSlimServerCodegen
extends AbstractPhpCodegen {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhpSlimServerCodegen.class);
    public static final String USER_CLASSNAME_KEY = "userClassname";
    protected String groupId = "org.openapitools";
    protected String artifactId = "openapi-server";
    protected String authDirName = "Auth";
    protected String authPackage = "";

    public PhpSlimServerCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML)).securityFeatures(EnumSet.noneOf(SecurityFeature.class)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}));
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.DEPRECATED).build();
        this.importMapping.clear();
        this.variableNamingConvention = "camelCase";
        this.artifactVersion = "1.0.0";
        this.setInvokerPackage("OpenAPIServer");
        this.apiPackage = this.invokerPackage + "\\" + this.apiDirName;
        this.modelPackage = this.invokerPackage + "\\" + this.modelDirName;
        this.authPackage = this.invokerPackage + "\\" + this.authDirName;
        this.outputFolder = "generated-code" + File.separator + "slim";
        this.modelTestTemplateFiles.put("model_test.mustache", ".php");
        this.modelDocTemplateFiles.clear();
        this.apiDocTemplateFiles.clear();
        this.templateDir = "php-slim-server";
        this.embeddedTemplateDir = "php-slim-server";
        this.additionalProperties.put("groupId", this.groupId);
        this.additionalProperties.put("artifactId", this.artifactId);
        for (CliOption co : this.cliOptions) {
            if (!co.getOpt().equals("variableNamingConvention")) continue;
            co.setDescription("naming convention of variable name, e.g. camelCase.");
            co.setDefault("camelCase");
            break;
        }
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "php-slim-deprecated";
    }

    @Override
    public String getHelp() {
        return "Generates a PHP Slim Framework server library. IMPORTANT NOTE: this generator (Slim 3.x)  is no longer actively maintained so please use 'php-slim4' generator instead.";
    }

    @Override
    public String apiFileFolder() {
        if (this.apiPackage.startsWith(this.invokerPackage + "\\")) {
            return this.outputFolder + File.separator + this.toSrcPath(org.apache.commons.lang3.StringUtils.removeStart((String)this.apiPackage, (String)(this.invokerPackage + "\\")), this.srcBasePath);
        }
        return this.outputFolder + File.separator + this.toSrcPath(this.apiPackage, this.srcBasePath);
    }

    @Override
    public String modelFileFolder() {
        if (this.modelPackage.startsWith(this.invokerPackage + "\\")) {
            return this.outputFolder + File.separator + this.toSrcPath(org.apache.commons.lang3.StringUtils.removeStart((String)this.modelPackage, (String)(this.invokerPackage + "\\")), this.srcBasePath);
        }
        return this.outputFolder + File.separator + this.toSrcPath(this.modelPackage, this.srcBasePath);
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("invokerPackage")) {
            this.authPackage = this.invokerPackage + "\\" + this.authDirName;
        }
        this.additionalProperties.put("authPackage", this.authPackage);
        this.additionalProperties.put("authSrcPath", "./" + this.toSrcPath(this.authPackage, this.srcBasePath));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("composer.mustache", "", "composer.json"));
        this.supportingFiles.add(new SupportingFile("index.mustache", "", "index.php"));
        this.supportingFiles.add(new SupportingFile(".htaccess", "", ".htaccess"));
        this.supportingFiles.add(new SupportingFile("SlimRouter.mustache", this.toSrcPath(this.invokerPackage, this.srcBasePath), "SlimRouter.php"));
        this.supportingFiles.add(new SupportingFile("phpunit.xml.mustache", "", "phpunit.xml.dist"));
        this.supportingFiles.add(new SupportingFile("phpcs.xml.mustache", "", "phpcs.xml.dist"));
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        Map operations = (Map)objs.get("operations");
        List operationList = (List)operations.get("operation");
        this.addUserClassnameToOperations(operations);
        this.escapeMediaType(operationList);
        return objs;
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        Map apiInfo = (Map)objs.get("apiInfo");
        List apiList = (List)apiInfo.get("apis");
        for (HashMap api : apiList) {
            HashMap operations = (HashMap)api.get("operations");
            List operationList = (List)operations.get("operation");
            Collections.sort(operationList, new Comparator<CodegenOperation>(){

                @Override
                public int compare(CodegenOperation one, CodegenOperation another) {
                    if (one.getHasPathParams() && !another.getHasPathParams()) {
                        return 1;
                    }
                    if (!one.getHasPathParams() && another.getHasPathParams()) {
                        return -1;
                    }
                    return 0;
                }
            });
        }
        return objs;
    }

    @Override
    public List<CodegenSecurity> fromSecurity(Map<String, SecurityScheme> securitySchemeMap) {
        List<CodegenSecurity> codegenSecurities = super.fromSecurity(securitySchemeMap);
        if (Boolean.FALSE.equals(codegenSecurities.isEmpty())) {
            this.supportingFiles.add(new SupportingFile("abstract_authenticator.mustache", this.toSrcPath(this.authPackage, this.srcBasePath), this.toAbstractName("Authenticator") + ".php"));
        }
        return codegenSecurities;
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return this.toAbstractName("DefaultApi");
        }
        return this.toAbstractName(StringUtils.camelize(name) + "Api");
    }

    @Override
    public String toApiTestFilename(String name) {
        if (name.length() == 0) {
            return "DefaultApiTest";
        }
        return StringUtils.camelize(name) + "ApiTest";
    }

    private void addUserClassnameToOperations(Map<String, Object> operations) {
        String classname = (String)operations.get("classname");
        classname = classname.replaceAll("^" + this.abstractNamePrefix, "");
        classname = classname.replaceAll(this.abstractNameSuffix + "$", "");
        operations.put(USER_CLASSNAME_KEY, classname);
    }

    @Override
    public String encodePath(String input) {
        if (input == null) {
            return input;
        }
        input = super.escapeUnsafeCharacters(StringEscapeUtils.unescapeJava((String)StringEscapeUtils.escapeJava((String)input).replace("\\/", "/")).replaceAll("[\\t\\n\\r]", " ").replace("\\", "\\\\"));
        input = input.trim();
        try {
            input = URLEncoder.encode(input, "UTF-8").replaceAll("\\+", "%20").replaceAll("\\%2F", "/").replaceAll("\\%7B", "{").replaceAll("\\%7D", "}").replaceAll("\\%5B", "[").replaceAll("\\%5D", "]").replaceAll("\\%3A", ":").replaceAll("\\%2B", "+").replaceAll("\\%5C\\%5Cd", "\\\\d");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return input;
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, List<Server> servers) {
        CodegenOperation op = super.fromOperation(path, httpMethod, operation, servers);
        op.path = this.encodePath(path);
        return op;
    }
}

