/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.samskivert.mustache.Mustache;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.File;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractFSharpCodegen;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.utils.URLPathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FsharpGiraffeServerCodegen
extends AbstractFSharpCodegen {
    public static final String USE_SWASHBUCKLE = "useSwashbuckle";
    public static final String GENERATE_BODY = "generateBody";
    public static final String BUILD_TARGET = "buildTarget";
    public static final String PROJECT_SDK = "projectSdk";
    public static final String SDK_WEB = "Microsoft.NET.Sdk.Web";
    public static final String SDK_LIB = "Microsoft.NET.Sdk";
    private String packageGuid = "{" + UUID.randomUUID().toString().toUpperCase(Locale.ROOT) + "}";
    protected Logger LOGGER = LoggerFactory.getLogger(FsharpGiraffeServerCodegen.class);
    private boolean useSwashbuckle = false;
    protected int serverPort = 8080;
    protected String serverHost = "0.0.0.0";
    private boolean generateBody = true;
    private String buildTarget = "program";
    private String projectSdk = "Microsoft.NET.Sdk.Web";

    public FsharpGiraffeServerCodegen() {
        this.featureSet = this.getFeatureSet().modify().includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).build();
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.BETA).build();
        this.modelPackage = "Model";
        this.apiTemplateFiles.put("Handler.mustache", "Handler.fs");
        this.apiTemplateFiles.put("HandlerParams.mustache", "HandlerParams.fs");
        this.apiTemplateFiles.put("ServiceInterface.mustache", "ServiceInterface.fs");
        this.apiTemplateFiles.put("ServiceImpl.mustache", "Service.fs");
        this.apiTestTemplateFiles.put("HandlerTests.mustache", ".fs");
        this.apiTestTemplateFiles.put("HandlerTestsHelper.mustache", "Helper.fs");
        this.modelTemplateFiles.put("Model.mustache", ".fs");
        this.templateDir = "fsharp-giraffe-server";
        this.embeddedTemplateDir = "fsharp-giraffe-server";
        this.cliOptions.clear();
        this.addOption("licenseUrl", "The URL of the license", this.licenseUrl);
        this.addOption("licenseName", "The name of the license", this.licenseName);
        this.addOption("packageCopyright", "Specifies an AssemblyCopyright for the .NET Framework global assembly attributes stored in the AssemblyInfo file.", this.packageCopyright);
        this.addOption("packageAuthors", "Specifies Authors property in the .NET Core project file.", this.packageAuthors);
        this.addOption("packageTitle", "Specifies an AssemblyTitle for the .NET Framework global assembly attributes stored in the AssemblyInfo file.", this.packageTitle);
        this.addOption("packageName", "F# module name (convention: Title.Case).", this.packageName);
        this.addOption("packageVersion", "F# package version.", this.packageVersion);
        this.addOption("packageGuid", "The GUID that will be associated with the C# project", null);
        this.addOption("sourceFolder", "source folder for generated code", this.sourceFolder);
        this.addSwitch("sortParamsByRequiredFlag", "Sort method arguments to place required parameters before optional parameters.", this.sortParamsByRequiredFlag);
        this.addSwitch("useDateTimeOffset", "Use DateTimeOffset to model date-time properties", this.useDateTimeOffsetFlag);
        this.addSwitch("useCollection", "Deserialize array types to Collection<T> instead of List<T>.", this.useCollection);
        this.addSwitch("returnICollection", "Return ICollection<T> instead of the concrete type.", this.returnICollection);
        this.addSwitch(USE_SWASHBUCKLE, "Uses the Swashbuckle.AspNetCore NuGet package for documentation.", this.useSwashbuckle);
        this.addSwitch(GENERATE_BODY, "Generates method body.", this.generateBody);
        this.addOption(BUILD_TARGET, "Target the build for a program or library.", this.buildTarget);
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "fsharp-giraffe-server";
    }

    @Override
    public String getHelp() {
        return "Generates a F# Giraffe server (beta).";
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        super.preprocessOpenAPI(openAPI);
        URL url = URLPathUtils.getServerURL(openAPI, this.serverVariableOverrides());
        this.additionalProperties.put("serverHost", url.getHost());
        this.additionalProperties.put("serverPort", URLPathUtils.getPort(url, 8080));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        boolean isLibrary = false;
        if (this.additionalProperties.containsKey("packageGuid")) {
            this.setPackageGuid((String)this.additionalProperties.get("packageGuid"));
        }
        this.additionalProperties.put("packageGuid", this.packageGuid);
        if (this.additionalProperties.containsKey(USE_SWASHBUCKLE)) {
            this.useSwashbuckle = this.convertPropertyToBooleanAndWriteBack(USE_SWASHBUCKLE);
        } else {
            this.additionalProperties.put(USE_SWASHBUCKLE, this.useSwashbuckle);
        }
        this.additionalProperties.put(PROJECT_SDK, this.projectSdk);
        if (isLibrary) {
            this.LOGGER.warn("Library flag not currently supported.");
        }
        String authFolder = this.sourceFolder + File.separator + "auth";
        String implFolder = this.sourceFolder + File.separator + "impl";
        String helperFolder = this.sourceFolder + File.separator + "helpers";
        this.supportingFiles.add(new SupportingFile("build.sh.mustache", this.projectFolder, "build.sh"));
        this.supportingFiles.add(new SupportingFile("build.bat.mustache", this.projectFolder, "build.bat"));
        this.supportingFiles.add(new SupportingFile("README.mustache", this.projectFolder, "README.md"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", this.projectFolder, ".gitignore"));
        this.supportingFiles.add(new SupportingFile("Project.fsproj.mustache", this.sourceFolder, this.packageName + ".fsproj"));
        this.supportingFiles.add(new SupportingFile("Program.mustache", this.sourceFolder, "Program.fs"));
        this.supportingFiles.add(new SupportingFile("AuthSchemes.mustache", authFolder, "AuthSchemes.fs"));
        this.supportingFiles.add(new SupportingFile("Helpers.mustache", helperFolder, "Helpers.fs"));
        this.supportingFiles.add(new SupportingFile("CustomHandlers.mustache", implFolder, "CustomHandlers.fs"));
        this.supportingFiles.add(new SupportingFile("Project.Tests.fsproj.mustache", this.testFolder, this.packageName + "Tests.fsproj"));
        this.supportingFiles.add(new SupportingFile("TestHelper.mustache", this.testFolder, "TestHelper.fs"));
        if (this.useSwashbuckle) {
            this.LOGGER.warn("Swashbuckle flag not currently supported, this will be ignored.");
        }
    }

    public void setPackageGuid(String packageGuid) {
        this.packageGuid = packageGuid;
    }

    @Override
    public String modelFileFolder() {
        return super.modelFileFolder().replace("Model", "model");
    }

    @Override
    public String apiFileFolder() {
        return super.apiFileFolder() + File.separator + "api";
    }

    private String implFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + "impl";
    }

    @Override
    public String toModelImport(String name) {
        return this.packageName + "." + this.modelPackage() + "." + name;
    }

    @Override
    public String apiFilename(String templateName, String tag) {
        String result = super.apiFilename(templateName, tag);
        if (templateName.endsWith("Impl.mustache")) {
            int ix = result.lastIndexOf(File.separatorChar);
            result = result.substring(0, ix) + result.substring(ix, result.length() - 2) + "fs";
            result = result.replace(this.apiFileFolder(), this.implFileFolder());
        }
        return result;
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        this.generateJSONSpecFile(objs);
        this.generateYAMLSpecFile(objs);
        return super.postProcessSupportingFileData(objs);
    }

    @Override
    protected void processOperation(CodegenOperation operation) {
        super.processOperation(operation);
        if (operation.path != null) {
            String original = operation.path;
            operation.path = operation.path.replace("?", "/");
            if (!original.equals(operation.path)) {
                this.LOGGER.warn("Normalized " + original + " to " + operation.path + ". Please verify generated source.");
            }
        }
        operation.httpMethod = "Http" + operation.httpMethod.substring(0, 1) + operation.httpMethod.substring(1).toLowerCase(Locale.ROOT);
    }

    @Override
    public Mustache.Compiler processCompiler(Mustache.Compiler compiler) {
        return super.processCompiler(compiler).emptyStringIsFalse(true);
    }

    @Override
    public String toRegularExpression(String pattern) {
        return this.escapeText(pattern);
    }
}

