/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.templating.mustache;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang3.StringUtils;

public class IndentedLambda
implements Mustache.Lambda {
    private final int prefixSpaceCount;
    private final String prefix;
    private int spaceCode;

    public IndentedLambda() {
        this(4, " ", null);
    }

    public IndentedLambda(int prefixSpaceCount, String indentionCharacter) {
        this(prefixSpaceCount, Character.codePointAt(indentionCharacter, 0), null);
    }

    public IndentedLambda(int prefixSpaceCount, String indentionCharacter, String prefix) {
        this(prefixSpaceCount, Character.codePointAt(indentionCharacter, 0), prefix);
    }

    private IndentedLambda(int prefixSpaceCount, int indentionCodePoint) {
        this(prefixSpaceCount, indentionCodePoint, null);
    }

    private IndentedLambda(int prefixSpaceCount, int indentionCodePoint, String prefix) {
        if (prefixSpaceCount <= 0) {
            throw new IllegalArgumentException("prefixSpaceCount must be greater than 0");
        }
        if (!Character.isValidCodePoint(indentionCodePoint)) {
            throw new IllegalArgumentException("indentionCodePoint is an invalid code point ");
        }
        this.prefixSpaceCount = prefixSpaceCount;
        this.spaceCode = indentionCodePoint;
        this.prefix = prefix;
    }

    public void execute(Template.Fragment fragment, Writer writer) throws IOException {
        String text = fragment.execute();
        if (text == null || text.length() == 0) {
            return;
        }
        String prefixedIndention = StringUtils.repeat((String)new String(Character.toChars(this.spaceCode)), (int)this.prefixSpaceCount);
        StringBuilder sb = new StringBuilder();
        String[] lines = text.split(System.lineSeparator());
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (i > 0) {
                sb.append(prefixedIndention);
                if (this.prefix != null) {
                    sb.append(this.prefix);
                }
            }
            sb.append(line);
            if (i >= lines.length - 1) continue;
            sb.append(System.lineSeparator());
        }
        writer.write(sb.toString());
    }
}

