/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.PhpSlimServerCodegen;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhpSlim4ServerCodegen
extends PhpSlimServerCodegen {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhpSlim4ServerCodegen.class);
    public static final String PSR7_IMPLEMENTATION = "psr7Implementation";
    protected String psr7Implementation = "slim-psr7";
    protected List<Map<String, String>> composerPackages = new ArrayList<Map<String, String>>();
    protected List<Map<String, String>> composerDevPackages = new ArrayList<Map<String, String>>();

    public PhpSlim4ServerCodegen() {
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.STABLE).build();
        this.outputFolder = "generated-code" + File.separator + "slim4";
        this.templateDir = "php-slim4-server";
        this.embeddedTemplateDir = "php-slim4-server";
        this.updateOption("variableNamingConvention", "camelCase");
        CliOption psr7Option = new CliOption(PSR7_IMPLEMENTATION, "Slim 4 provides its own PSR-7 implementation so that it works out of the box. However, you are free to replace Slim\u2019s default PSR-7 objects with a third-party implementation. Ref: https://www.slimframework.com/docs/v4/concepts/value-objects.html");
        psr7Option.addEnum("slim-psr7", "Slim PSR-7 Message implementation").addEnum("nyholm-psr7", "Nyholm PSR-7 Message implementation").addEnum("guzzle-psr7", "Guzzle PSR-7 Message implementation").addEnum("zend-diactoros", "Zend Diactoros PSR-7 Message implementation").setDefault("slim-psr7");
        this.cliOptions.add(psr7Option);
    }

    @Override
    public String getName() {
        return "php-slim4";
    }

    @Override
    public String getHelp() {
        return "Generates a PHP Slim 4 Framework server library.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(PSR7_IMPLEMENTATION)) {
            this.setPsr7Implementation((String)this.additionalProperties.get(PSR7_IMPLEMENTATION));
        }
        this.additionalProperties.put("isSlimPsr7", Boolean.FALSE);
        this.additionalProperties.put("isNyholmPsr7", Boolean.FALSE);
        this.additionalProperties.put("isGuzzlePsr7", Boolean.FALSE);
        this.additionalProperties.put("isZendDiactoros", Boolean.FALSE);
        switch (this.getPsr7Implementation()) {
            case "slim-psr7": {
                this.additionalProperties.put("isSlimPsr7", Boolean.TRUE);
                break;
            }
            case "nyholm-psr7": {
                this.additionalProperties.put("isNyholmPsr7", Boolean.TRUE);
                break;
            }
            case "guzzle-psr7": {
                this.additionalProperties.put("isGuzzlePsr7", Boolean.TRUE);
                break;
            }
            case "zend-diactoros": {
                this.additionalProperties.put("isZendDiactoros", Boolean.TRUE);
                break;
            }
            default: {
                LOGGER.warn("\"" + this.getPsr7Implementation() + "\" is invalid \"psr7Implementation\" codegen option. Default \"slim-psr7\" used instead.");
                this.additionalProperties.put("isSlimPsr7", Boolean.TRUE);
            }
        }
        this.supportingFiles.add(new SupportingFile("json_body_parser_middleware.mustache", this.toSrcPath(this.invokerPackage + "\\Middleware", this.srcBasePath), "JsonBodyParserMiddleware.php"));
    }

    public void setPsr7Implementation(String psr7Implementation) {
        switch (psr7Implementation) {
            case "slim-psr7": 
            case "nyholm-psr7": 
            case "guzzle-psr7": 
            case "zend-diactoros": {
                this.psr7Implementation = psr7Implementation;
                break;
            }
            default: {
                this.psr7Implementation = "slim-psr7";
                LOGGER.warn("\"" + psr7Implementation + "\" is invalid \"psr7Implementation\" argument. Default \"slim-psr7\" used instead.");
            }
        }
    }

    public String getPsr7Implementation() {
        return this.psr7Implementation;
    }
}

