/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractKotlinCodegen;

public class KotlinClientCodegen
extends AbstractKotlinCodegen {
    protected static final String JVM = "jvm";
    protected static final String MULTIPLATFORM = "multiplatform";
    public static final String DATE_LIBRARY = "dateLibrary";
    public static final String COLLECTION_TYPE = "collectionType";
    protected String dateLibrary;
    protected String collectionType;

    public KotlinClientCodegen() {
        this.dateLibrary = DateLibrary.JAVA8.value;
        this.collectionType = CollectionType.ARRAY.value;
        this.artifactId = "kotlin-client";
        this.packageName = "org.openapitools.client";
        this.updateOption("artifactId", this.artifactId);
        this.updateOption("packageName", this.packageName);
        this.outputFolder = "generated-code" + File.separator + "kotlin-client";
        this.modelTemplateFiles.put("model.mustache", ".kt");
        this.apiTemplateFiles.put("api.mustache", ".kt");
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.templateDir = "kotlin-client";
        this.embeddedTemplateDir = "kotlin-client";
        this.apiPackage = this.packageName + ".apis";
        this.modelPackage = this.packageName + ".models";
        CliOption dateLibrary = new CliOption(DATE_LIBRARY, "Option. Date library to use");
        HashMap<String, String> dateOptions = new HashMap<String, String>();
        dateOptions.put(DateLibrary.THREETENBP.value, "Threetenbp (jvm only)");
        dateOptions.put(DateLibrary.STRING.value, "String");
        dateOptions.put(DateLibrary.JAVA8.value, "Java 8 native JSR310 (jvm only)");
        dateLibrary.setEnum(dateOptions);
        dateLibrary.setDefault(this.dateLibrary);
        this.cliOptions.add(dateLibrary);
        CliOption collectionType = new CliOption(COLLECTION_TYPE, "Option. Collection type to use");
        HashMap<String, String> collectionOptions = new HashMap<String, String>();
        collectionOptions.put(CollectionType.ARRAY.value, "kotlin.Array");
        collectionOptions.put(CollectionType.LIST.value, "kotlin.collections.List");
        collectionType.setEnum(collectionOptions);
        collectionType.setDefault(this.collectionType);
        this.cliOptions.add(collectionType);
        this.supportedLibraries.put(JVM, "Platform: Java Virtual Machine. HTTP client: OkHttp 2.7.5. JSON processing: Gson 2.8.1.");
        this.supportedLibraries.put(MULTIPLATFORM, "Platform: Kotlin multiplatform. HTTP client: Ktor 1.2.4. JSON processing: Kotlinx Serialization: 0.12.0.");
        CliOption libraryOption = new CliOption("library", "Library template (sub-template) to use");
        libraryOption.setEnum(this.supportedLibraries);
        libraryOption.setDefault(JVM);
        this.cliOptions.add(libraryOption);
        this.setLibrary(JVM);
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "kotlin";
    }

    @Override
    public String getHelp() {
        return "Generates a Kotlin client.";
    }

    public void setDateLibrary(String library) {
        this.dateLibrary = library;
    }

    public void setCollectionType(String collectionType) {
        this.collectionType = collectionType;
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (MULTIPLATFORM.equals(this.getLibrary())) {
            this.sourceFolder = "src/commonMain/kotlin";
        }
        String infrastructureFolder = (this.sourceFolder + File.separator + this.packageName + File.separator + "infrastructure").replace(".", "/");
        if (this.additionalProperties.containsKey(DATE_LIBRARY)) {
            this.setDateLibrary(this.additionalProperties.get(DATE_LIBRARY).toString());
        }
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("build.gradle.mustache", "", "build.gradle"));
        this.supportingFiles.add(new SupportingFile("settings.gradle.mustache", "", "settings.gradle"));
        this.supportingFiles.add(new SupportingFile("infrastructure/ApiClient.kt.mustache", infrastructureFolder, "ApiClient.kt"));
        this.supportingFiles.add(new SupportingFile("infrastructure/ApiAbstractions.kt.mustache", infrastructureFolder, "ApiAbstractions.kt"));
        this.supportingFiles.add(new SupportingFile("infrastructure/RequestConfig.kt.mustache", infrastructureFolder, "RequestConfig.kt"));
        this.supportingFiles.add(new SupportingFile("infrastructure/RequestMethod.kt.mustache", infrastructureFolder, "RequestMethod.kt"));
        if (JVM.equals(this.getLibrary())) {
            this.additionalProperties.put(JVM, true);
            this.supportingFiles.add(new SupportingFile("infrastructure/ApplicationDelegates.kt.mustache", infrastructureFolder, "ApplicationDelegates.kt"));
            this.supportingFiles.add(new SupportingFile("infrastructure/Errors.kt.mustache", infrastructureFolder, "Errors.kt"));
            this.supportingFiles.add(new SupportingFile("infrastructure/ResponseExtensions.kt.mustache", infrastructureFolder, "ResponseExtensions.kt"));
            this.supportingFiles.add(new SupportingFile("infrastructure/Serializer.kt.mustache", infrastructureFolder, "Serializer.kt"));
            this.supportingFiles.add(new SupportingFile("infrastructure/ApiInfrastructureResponse.kt.mustache", infrastructureFolder, "ApiInfrastructureResponse.kt"));
            this.supportingFiles.add(new SupportingFile("infrastructure/ByteArrayAdapter.kt.mustache", infrastructureFolder, "ByteArrayAdapter.kt"));
            this.supportingFiles.add(new SupportingFile("infrastructure/LocalDateAdapter.kt.mustache", infrastructureFolder, "LocalDateAdapter.kt"));
            this.supportingFiles.add(new SupportingFile("infrastructure/LocalDateTimeAdapter.kt.mustache", infrastructureFolder, "LocalDateTimeAdapter.kt"));
            this.supportingFiles.add(new SupportingFile("infrastructure/UUIDAdapter.kt.mustache", infrastructureFolder, "UUIDAdapter.kt"));
        } else if (MULTIPLATFORM.equals(this.getLibrary())) {
            this.additionalProperties.put(MULTIPLATFORM, true);
            this.setDateLibrary(DateLibrary.STRING.value);
            this.defaultIncludes.add("io.ktor.client.request.forms.InputProvider");
            this.typeMapping.put("number", "kotlin.Double");
            this.typeMapping.put("file", "InputProvider");
            this.importMapping.put("BigDecimal", "kotlin.Double");
            this.importMapping.put("UUID", "kotlin.String");
            this.importMapping.put("URI", "kotlin.String");
            this.importMapping.put("InputProvider", "io.ktor.client.request.forms.InputProvider");
            this.importMapping.put("File", "io.ktor.client.request.forms.InputProvider");
            this.importMapping.put("Timestamp", "kotlin.String");
            this.importMapping.put("LocalDateTime", "kotlin.String");
            this.importMapping.put("LocalDate", "kotlin.String");
            this.importMapping.put("LocalTime", "kotlin.String");
            this.supportingFiles.add(new SupportingFile("infrastructure/HttpResponse.kt.mustache", infrastructureFolder, "HttpResponse.kt"));
            this.supportingFiles.add(new SupportingFile("commonTest/coroutine.mustache", "src/commonTest/kotlin/util", "Coroutine.kt"));
            this.supportingFiles.add(new SupportingFile("iosTest/coroutine.mustache", "src/iosTest/kotlin/util", "Coroutine.kt"));
            this.supportingFiles.add(new SupportingFile("jvmTest/coroutine.mustache", "src/jvmTest/kotlin/util", "Coroutine.kt"));
            this.supportingFiles.add(new SupportingFile("gradlew.mustache", "", "gradlew"));
            this.supportingFiles.add(new SupportingFile("gradlew.bat.mustache", "", "gradlew.bat"));
            this.supportingFiles.add(new SupportingFile("gradle-wrapper.properties.mustache", "gradle.wrapper".replace(".", File.separator), "gradle-wrapper.properties"));
            this.supportingFiles.add(new SupportingFile("gradle-wrapper.jar", "gradle.wrapper".replace(".", File.separator), "gradle-wrapper.jar"));
        }
        if (DateLibrary.THREETENBP.value.equals(this.dateLibrary)) {
            this.additionalProperties.put(DateLibrary.THREETENBP.value, true);
            this.typeMapping.put("date", "LocalDate");
            this.typeMapping.put("DateTime", "LocalDateTime");
            this.importMapping.put("LocalDate", "org.threeten.bp.LocalDate");
            this.importMapping.put("LocalDateTime", "org.threeten.bp.LocalDateTime");
            this.defaultIncludes.add("org.threeten.bp.LocalDate");
            this.defaultIncludes.add("org.threeten.bp.LocalDateTime");
        } else if (DateLibrary.STRING.value.equals(this.dateLibrary)) {
            this.typeMapping.put("date-time", "kotlin.String");
            this.typeMapping.put("date", "kotlin.String");
            this.typeMapping.put("Date", "kotlin.String");
            this.typeMapping.put("DateTime", "kotlin.String");
        } else if (DateLibrary.JAVA8.value.equals(this.dateLibrary)) {
            this.additionalProperties.put(DateLibrary.JAVA8.value, true);
        }
        if (this.additionalProperties.containsKey(COLLECTION_TYPE)) {
            this.setCollectionType(this.additionalProperties.get(COLLECTION_TYPE).toString());
        }
        if (CollectionType.LIST.value.equals(this.collectionType)) {
            this.typeMapping.put("array", "kotlin.collections.List");
            this.typeMapping.put("list", "kotlin.collections.List");
            this.additionalProperties.put("isList", true);
        }
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        super.postProcessOperationsWithModels(objs, allModels);
        Map operations = (Map)objs.get("operations");
        if (operations != null) {
            List ops = (List)operations.get("operation");
            for (CodegenOperation operation : ops) {
                if (operation.hasConsumes != Boolean.TRUE || !KotlinClientCodegen.isMultipartType(operation.consumes)) continue;
                operation.isMultipart = Boolean.TRUE;
            }
        }
        return operations;
    }

    private static boolean isMultipartType(List<Map<String, String>> consumes) {
        Map<String, String> firstType = consumes.get(0);
        if (firstType != null) {
            return "multipart/form-data".equals(firstType.get("mediaType"));
        }
        return false;
    }

    public static enum CollectionType {
        ARRAY("array"),
        LIST("list");

        public final String value;

        private CollectionType(String value) {
            this.value = value;
        }
    }

    public static enum DateLibrary {
        STRING("string"),
        THREETENBP("threetenbp"),
        JAVA8("java8");

        public final String value;

        private DateLibrary(String value) {
            this.value = value;
        }
    }
}

