/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.info.Info;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.utils.StringUtils;
import org.openapitools.codegen.utils.URLPathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeJSExpressServerCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeJSExpressServerCodegen.class);
    public static final String EXPORTED_NAME = "exportedName";
    public static final String SERVER_PORT = "serverPort";
    protected String apiVersion = "1.0.0";
    protected String defaultServerPort = "8080";
    protected String implFolder = "services";
    protected String projectName = "openapi-server";
    protected String exportedName;

    public NodeJSExpressServerCodegen() {
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.BETA).build();
        this.outputFolder = "generated-code/nodejs-express-server";
        this.templateDir = "nodejs-express-server";
        this.embeddedTemplateDir = "nodejs-express-server";
        this.setReservedWordsLowerCase(Arrays.asList("break", "case", "class", "catch", "const", "continue", "debugger", "default", "delete", "do", "else", "export", "extends", "finally", "for", "function", "if", "import", "in", "instanceof", "let", "new", "return", "super", "switch", "this", "throw", "try", "typeof", "var", "void", "while", "with", "yield"));
        this.additionalProperties.put("apiVersion", this.apiVersion);
        this.additionalProperties.put("implFolder", this.implFolder);
        this.modelTemplateFiles.clear();
        this.apiTemplateFiles.put("controller.mustache", ".js");
        this.apiTemplateFiles.put("service.mustache", ".js");
        this.supportingFiles.add(new SupportingFile("openapi.mustache", "api", "openapi.yaml"));
        this.supportingFiles.add(new SupportingFile("config.mustache", "", "config.js"));
        this.supportingFiles.add(new SupportingFile("expressServer.mustache", "", "expressServer.js"));
        this.supportingFiles.add(new SupportingFile("index.mustache", "", "index.js"));
        this.supportingFiles.add(new SupportingFile("logger.mustache", "", "logger.js"));
        this.supportingFiles.add(new SupportingFile("eslintrc.mustache", "", ".eslintrc.json"));
        this.supportingFiles.add(new SupportingFile("utils" + File.separator + "openapiRouter.mustache", "utils", "openapiRouter.js"));
        this.supportingFiles.add(new SupportingFile("controllers" + File.separator + "index.mustache", "controllers", "index.js"));
        this.supportingFiles.add(new SupportingFile("controllers" + File.separator + "Controller.mustache", "controllers", "Controller.js"));
        this.supportingFiles.add(new SupportingFile("services" + File.separator + "index.mustache", "services", "index.js"));
        this.supportingFiles.add(new SupportingFile("services" + File.separator + "Service.mustache", "services", "Service.js"));
        this.writeOptional(this.outputFolder, new SupportingFile("package.mustache", "", "package.json"));
        this.writeOptional(this.outputFolder, new SupportingFile("README.mustache", "", "README.md"));
        this.cliOptions.add(new CliOption(SERVER_PORT, "TCP port to listen on."));
    }

    @Override
    public String apiPackage() {
        return "controllers";
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "nodejs-express-server";
    }

    @Override
    public String getHelp() {
        return "Generates a NodeJS Express server (alpha). IMPORTANT: this generator may subject to breaking changes without further notice).";
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "Default";
        }
        return StringUtils.camelize(name);
    }

    @Override
    public String toApiFilename(String name) {
        return this.toApiName(name) + "Controller";
    }

    @Override
    public String apiFilename(String templateName, String tag) {
        String result = super.apiFilename(templateName, tag);
        if (templateName.equals("service.mustache")) {
            String stringToMatch = File.separator + "controllers" + File.separator;
            String replacement = File.separator + this.implFolder + File.separator;
            result = result.replaceAll(Pattern.quote(stringToMatch), replacement);
            stringToMatch = "Controller.js";
            replacement = "Service.js";
            result = result.replaceAll(Pattern.quote(stringToMatch), replacement);
        }
        return result;
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    public String getExportedName() {
        return this.exportedName;
    }

    public void setExportedName(String name) {
        this.exportedName = name;
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        Map objectMap = (Map)objs.get("operations");
        List operations = (List)objectMap.get("operation");
        for (CodegenOperation operation : operations) {
            List<CodegenResponse> responses;
            operation.httpMethod = operation.httpMethod.toLowerCase(Locale.ROOT);
            List<CodegenParameter> params = operation.allParams;
            if (params != null && params.size() == 0) {
                operation.allParams = null;
            }
            if ((responses = operation.responses) != null) {
                for (CodegenResponse resp : responses) {
                    if (!"0".equals(resp.code)) continue;
                    resp.code = "default";
                }
            }
            if (operation.examples == null || operation.examples.isEmpty()) continue;
            Iterator<Map<String, String>> it = operation.examples.iterator();
            while (it.hasNext()) {
                Map<String, String> example = it.next();
                String contentType = example.get("contentType");
                if (contentType != null && contentType.startsWith("application/json")) continue;
                it.remove();
            }
        }
        return objs;
    }

    private static List<Map<String, Object>> getOperations(Map<String, Object> objs) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Map apiInfo = (Map)objs.get("apiInfo");
        List apis = (List)apiInfo.get("apis");
        for (Map api : apis) {
            result.add((Map)api.get("operations"));
        }
        return result;
    }

    private static List<Map<String, Object>> sortOperationsByPath(List<CodegenOperation> ops) {
        ArrayListMultimap opsByPath = ArrayListMultimap.create();
        for (CodegenOperation op : ops) {
            opsByPath.put((Object)op.path, (Object)op);
        }
        ArrayList<Map<String, Object>> opsByPathList = new ArrayList<Map<String, Object>>();
        for (Map.Entry entry : opsByPath.asMap().entrySet()) {
            HashMap<String, Object> opsByPathEntry = new HashMap<String, Object>();
            opsByPathList.add(opsByPathEntry);
            opsByPathEntry.put("path", entry.getKey());
            opsByPathEntry.put("operation", entry.getValue());
            ArrayList operationsForThisPath = Lists.newArrayList((Iterable)((Iterable)entry.getValue()));
            ((CodegenOperation)operationsForThisPath.get((int)(operationsForThisPath.size() - 1))).hasMore = false;
            if (opsByPathList.size() >= opsByPath.asMap().size()) continue;
            opsByPathEntry.put("hasMore", "true");
        }
        return opsByPathList;
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(EXPORTED_NAME)) {
            this.setExportedName((String)this.additionalProperties.get(EXPORTED_NAME));
        }
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        Paths paths;
        Info info;
        URL url = URLPathUtils.getServerURL(openAPI);
        String host = URLPathUtils.getProtocolAndHost(url);
        String port = URLPathUtils.getPort(url, this.defaultServerPort);
        String basePath = url.getPath();
        if (this.additionalProperties.containsKey(SERVER_PORT)) {
            port = this.additionalProperties.get(SERVER_PORT).toString();
        }
        this.additionalProperties.put(SERVER_PORT, port);
        if (openAPI.getInfo() != null && (info = openAPI.getInfo()).getTitle() != null) {
            this.projectName = info.getTitle().replaceAll("[^a-zA-Z0-9]", "-").replaceAll("^[-]*", "").replaceAll("[-]*$", "").replaceAll("[-]{2,}", "-").toLowerCase(Locale.ROOT);
            this.additionalProperties.put("projectName", this.projectName);
        }
        if ((paths = openAPI.getPaths()) != null) {
            for (String pathname : paths.keySet()) {
                PathItem path = (PathItem)paths.get((Object)pathname);
                Map operationMap = path.readOperationsMap();
                if (operationMap == null) continue;
                for (PathItem.HttpMethod method : operationMap.keySet()) {
                    Operation operation = (Operation)operationMap.get(method);
                    String tag = "default";
                    if (operation.getTags() != null && operation.getTags().size() > 0) {
                        tag = this.toApiName((String)operation.getTags().get(0));
                    }
                    if (operation.getOperationId() == null) {
                        operation.setOperationId(this.getOrGenerateOperationId(operation, pathname, method.toString()));
                    }
                    if (operation.getExtensions() == null || operation.getExtensions().get("x-openapi-router-controller") == null) {
                        operation.addExtension("x-openapi-router-controller", (Object)(this.sanitizeTag(tag) + "Controller"));
                    }
                    if (operation.getExtensions() != null && operation.getExtensions().get("x-openapi-router-service") != null) continue;
                    operation.addExtension("x-openapi-router-service", (Object)(this.sanitizeTag(tag) + "Service"));
                }
            }
        }
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        this.generateYAMLSpecFile(objs);
        for (Map<String, Object> operations : NodeJSExpressServerCodegen.getOperations(objs)) {
            List ops = (List)operations.get("operation");
            List<Map<String, Object>> opsByPathList = NodeJSExpressServerCodegen.sortOperationsByPath(ops);
            operations.put("operationsByPath", opsByPathList);
        }
        return super.postProcessSupportingFileData(objs);
    }

    @Override
    public String removeNonNameElementToCamelCase(String name) {
        return this.removeNonNameElementToCamelCase(name, "[-:;#]");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }
}

