/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractJavaJAXRSServerCodegen;

public class JavaJAXRSSpecServerCodegen
extends AbstractJavaJAXRSServerCodegen {
    public static final String INTERFACE_ONLY = "interfaceOnly";
    public static final String RETURN_RESPONSE = "returnResponse";
    public static final String GENERATE_POM = "generatePom";
    public static final String USE_SWAGGER_ANNOTATIONS = "useSwaggerAnnotations";
    public static final String JACKSON = "jackson";
    private boolean interfaceOnly = false;
    private boolean returnResponse = false;
    private boolean generatePom = true;
    private boolean useSwaggerAnnotations = true;
    private boolean useJackson = false;
    private String primaryResourceName;

    public JavaJAXRSSpecServerCodegen() {
        this.invokerPackage = "org.openapitools.api";
        this.artifactId = "openapi-jaxrs-server";
        this.outputFolder = "generated-code/JavaJaxRS-Spec";
        this.apiPackage = "org.openapitools.api";
        this.modelPackage = "org.openapitools.model";
        this.updateOption("invokerPackage", this.getInvokerPackage());
        this.updateOption("artifactId", this.getArtifactId());
        this.updateOption("apiPackage", this.apiPackage);
        this.updateOption("modelPackage", this.modelPackage);
        this.modelTemplateFiles.put("model.mustache", ".java");
        this.apiTemplateFiles.put("api.mustache", ".java");
        this.apiTestTemplateFiles.clear();
        this.modelTestTemplateFiles.clear();
        this.modelDocTemplateFiles.remove("model_doc.mustache");
        this.apiDocTemplateFiles.remove("api_doc.mustache");
        this.additionalProperties.put("title", this.title);
        this.typeMapping.put("date", "LocalDate");
        this.importMapping.put("LocalDate", "org.joda.time.LocalDate");
        this.embeddedTemplateDir = this.templateDir = "JavaJaxRS" + File.separator + "spec";
        this.removeOption("library");
        CliOption library = new CliOption("library", "library template (sub-template)").defaultValue("<default>");
        LinkedHashMap<String, String> supportedLibraries = new LinkedHashMap<String, String>();
        supportedLibraries.put("<default>", "JAXRS");
        library.setEnum(supportedLibraries);
        this.cliOptions.add(library);
        this.cliOptions.add(CliOption.newBoolean(GENERATE_POM, "Whether to generate pom.xml if the file does not already exist.").defaultValue(String.valueOf(this.generatePom)));
        this.cliOptions.add(CliOption.newBoolean(INTERFACE_ONLY, "Whether to generate only API interface stubs without the server files.").defaultValue(String.valueOf(this.interfaceOnly)));
        this.cliOptions.add(CliOption.newBoolean(RETURN_RESPONSE, "Whether generate API interface should return javax.ws.rs.core.Response instead of a deserialized entity. Only useful if interfaceOnly is true.").defaultValue(String.valueOf(this.returnResponse)));
        this.cliOptions.add(CliOption.newBoolean(USE_SWAGGER_ANNOTATIONS, "Whether to generate Swagger annotations.", this.useSwaggerAnnotations));
    }

    @Override
    public void processOpts() {
        if (this.additionalProperties.containsKey(GENERATE_POM)) {
            this.generatePom = Boolean.valueOf(this.additionalProperties.get(GENERATE_POM).toString());
        }
        if (this.additionalProperties.containsKey(INTERFACE_ONLY)) {
            this.interfaceOnly = Boolean.valueOf(this.additionalProperties.get(INTERFACE_ONLY).toString());
            if (!this.interfaceOnly) {
                this.additionalProperties.remove(INTERFACE_ONLY);
            }
        }
        if (this.additionalProperties.containsKey(RETURN_RESPONSE)) {
            this.returnResponse = Boolean.valueOf(this.additionalProperties.get(RETURN_RESPONSE).toString());
            if (!this.returnResponse) {
                this.additionalProperties.remove(RETURN_RESPONSE);
            }
        }
        if (this.additionalProperties.containsKey(USE_SWAGGER_ANNOTATIONS)) {
            this.useSwaggerAnnotations = Boolean.valueOf(this.additionalProperties.get(USE_SWAGGER_ANNOTATIONS).toString());
        }
        this.writePropertyBack(USE_SWAGGER_ANNOTATIONS, this.useSwaggerAnnotations);
        this.useJackson = this.convertPropertyToBoolean(JACKSON);
        if (this.interfaceOnly) {
            this.artifactId = "openapi-jaxrs-client";
        }
        super.processOpts();
        this.supportingFiles.clear();
        this.writeOptional(this.outputFolder, new SupportingFile("README.mustache", "", "README.md"));
        if (this.generatePom) {
            this.writeOptional(this.outputFolder, new SupportingFile("pom.mustache", "", "pom.xml"));
        }
        if (!this.interfaceOnly) {
            this.writeOptional(this.outputFolder, new SupportingFile("RestApplication.mustache", (this.sourceFolder + '/' + this.invokerPackage).replace(".", "/"), "RestApplication.java"));
        }
        this.supportingFiles.add(new SupportingFile("openapi.mustache", "src/main/openapi", "openapi.yaml"));
    }

    @Override
    public String getName() {
        return "jaxrs-spec";
    }

    @Override
    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        int pos;
        String basePath = resourcePath;
        if (basePath.startsWith("/")) {
            basePath = basePath.substring(1);
        }
        if ((pos = basePath.indexOf("/")) > 0) {
            basePath = basePath.substring(0, pos);
        }
        String operationKey = basePath;
        if (StringUtils.isEmpty((CharSequence)basePath)) {
            basePath = tag;
            operationKey = "";
            this.primaryResourceName = tag;
        } else if (basePath.matches("\\{.*\\}")) {
            basePath = tag;
            operationKey = "";
            co.subresourceOperation = true;
        } else {
            if (co.path.startsWith("/" + basePath)) {
                co.path = co.path.substring(("/" + basePath).length());
            }
            co.subresourceOperation = !co.path.isEmpty();
        }
        List<CodegenOperation> opList = operations.get(operationKey);
        if (opList == null || opList.isEmpty()) {
            opList = new ArrayList<CodegenOperation>();
            operations.put(operationKey, opList);
        }
        opList.add(co);
        co.baseName = basePath;
    }

    @Override
    public CodegenModel fromModel(String name, Schema model) {
        CodegenModel codegenModel = super.fromModel(name, model);
        if (!this.useSwaggerAnnotations) {
            codegenModel.imports.remove("ApiModelProperty");
            codegenModel.imports.remove("ApiModel");
        }
        if (!this.useJackson) {
            codegenModel.imports.remove("JsonSerialize");
            codegenModel.imports.remove("ToStringSerializer");
            codegenModel.imports.remove("JsonValue");
            codegenModel.imports.remove("JsonProperty");
        }
        return codegenModel;
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        this.generateYAMLSpecFile(objs);
        return super.postProcessSupportingFileData(objs);
    }

    @Override
    public String getHelp() {
        return "Generates a Java JAXRS Server according to JAXRS 2.0 specification.";
    }

    @Override
    public String toApiName(String name) {
        String computed = name;
        if (computed.length() == 0) {
            return this.primaryResourceName + "Api";
        }
        computed = this.sanitizeName(computed);
        return org.openapitools.codegen.utils.StringUtils.camelize(computed) + "Api";
    }
}

