/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.io.File;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.PythonAbstractConnexionServerCodegen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonBluePlanetServerCodegen
extends PythonAbstractConnexionServerCodegen {
    private static final Logger LOGGER = LoggerFactory.getLogger(PythonBluePlanetServerCodegen.class);
    protected String modelDocPath = "";
    protected String modelTestPath = "";

    public PythonBluePlanetServerCodegen() {
        super("python-blueplanet", true);
        this.testPackage = "tests";
        this.templateDir = "python-blueplanet";
        this.embeddedTemplateDir = "python-blueplanet";
    }

    @Override
    public String getName() {
        return "python-blueplanet";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        } else {
            this.setPackageName("swagger_microservice");
            this.additionalProperties.put("packageName", this.packageName);
        }
        if (this.additionalProperties.containsKey("packageVersion")) {
            this.setPackageVersion((String)this.additionalProperties.get("packageVersion"));
        } else {
            this.setPackageVersion("1.0.0");
            this.additionalProperties.put("packageVersion", this.packageVersion);
        }
        if (this.additionalProperties.containsKey("controllerPackage")) {
            this.controllerPackage = this.additionalProperties.get("controllerPackage").toString();
        } else {
            this.controllerPackage = "controllers";
            this.additionalProperties.put("controllerPackage", this.controllerPackage);
        }
        if (this.additionalProperties.containsKey("defaultController")) {
            this.defaultController = this.additionalProperties.get("defaultController").toString();
        } else {
            this.defaultController = "default_controller";
            this.additionalProperties.put("defaultController", this.defaultController);
        }
        if (Boolean.TRUE.equals(this.additionalProperties.get("supportPython2"))) {
            this.additionalProperties.put("supportPython2", Boolean.TRUE);
            this.typeMapping.put("long", "long");
        }
        String APP_PATH = "app" + File.separatorChar;
        String APP_PACKAGE_PATH = APP_PATH + this.packageName;
        String TEST_PATH = APP_PACKAGE_PATH + File.separatorChar + "test";
        String MODEL_PATH = APP_PACKAGE_PATH + File.separatorChar + "models";
        String CONTROLLER_PATH = APP_PACKAGE_PATH + File.separatorChar + "controllers";
        String SOLUTION_PATH = "solution" + File.separatorChar;
        String SWAGGER_PATH = APP_PACKAGE_PATH + File.separatorChar + "swagger";
        this.additionalProperties.put("appSrcPath", APP_PATH);
        this.additionalProperties.put("solutionSrcPath", SOLUTION_PATH);
        this.additionalProperties.put("modelDefinitionsSrcPath", this.modelDocPath);
        this.supportingFiles.add(new SupportingFile("Makefile.mustache", "", "Makefile"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("requirements.mustache", "", "requirements.txt"));
        this.supportingFiles.add(new SupportingFile("app/Dockerfile.mustache", APP_PATH, "Dockerfile"));
        this.supportingFiles.add(new SupportingFile("app/dockerignore.mustache", APP_PATH, ".dockerignore"));
        this.supportingFiles.add(new SupportingFile("app/gitignore.mustache", APP_PATH, ".gitignore"));
        this.supportingFiles.add(new SupportingFile("app/README.mustache", APP_PATH, "README.md"));
        this.supportingFiles.add(new SupportingFile("app/requirements.mustache", APP_PATH, "requirements.txt"));
        this.supportingFiles.add(new SupportingFile("app/setup.mustache", APP_PATH, "setup.py"));
        this.supportingFiles.add(new SupportingFile("app/tox.mustache", APP_PATH, "tox.ini"));
        this.supportingFiles.add(new SupportingFile("app/test-requirements.mustache", APP_PATH, "test-requirements.txt"));
        this.supportingFiles.add(new SupportingFile("app/{{packageName}}/__init__.mustache", APP_PACKAGE_PATH, "__init__.py"));
        this.supportingFiles.add(new SupportingFile("app/{{packageName}}/__main__.mustache", APP_PACKAGE_PATH, "__main__.py"));
        this.supportingFiles.add(new SupportingFile("app/{{packageName}}/encoder.mustache", APP_PACKAGE_PATH, "encoder.py"));
        this.supportingFiles.add(new SupportingFile("app/{{packageName}}/util.mustache", APP_PACKAGE_PATH, "util.py"));
        this.supportingFiles.add(new SupportingFile("app/{{packageName}}/controllers/__init__.mustache", CONTROLLER_PATH, "__init__.py"));
        this.supportingFiles.add(new SupportingFile("app/{{packageName}}/models/__init__.mustache", MODEL_PATH, "__init__.py"));
        this.supportingFiles.add(new SupportingFile("app/{{packageName}}/models/base_model_.mustache", MODEL_PATH, "base_model_.py"));
        this.supportingFiles.add(new SupportingFile("app/{{packageName}}/test/__init__.mustache", TEST_PATH, "__init__.py"));
        this.supportingFiles.add(new SupportingFile("app/{{packageName}}/swagger/swagger.mustache", SWAGGER_PATH, "swagger.yaml"));
        this.supportingFiles.add(new SupportingFile("solution/fig.mustache", SOLUTION_PATH, "fig.yml"));
        this.modelTemplateFiles.remove("model.mustache", ".py");
        this.modelTemplateFiles.put("app/{{packageName}}/models/model.mustache", ".py");
        this.modelPackage = "app." + this.packageName + ".models";
        this.apiTemplateFiles.remove("controller.mustache", ".py");
        this.apiTemplateFiles.put("app/{{packageName}}/controllers/controller.mustache", ".py");
        this.controllerPackage = "app." + this.packageName + ".controllers";
        this.apiTestTemplateFiles().remove("controller_test.mustache", ".py");
        this.apiTestTemplateFiles.put("app/{{packageName}}/test/controller_test.mustache", ".py");
        this.testPackage = "app." + this.packageName + ".test";
        this.modelDocPath = "model-definitions.types.tosca." + this.packageName;
        this.modelDocTemplateFiles.put("model-definitions/types/tosca/{{packageName}}/{{model}}.mustache", ".tosca");
        this.modelTestTemplateFiles.put("model-definitions/types/ddui-views/{{packageName}}.resourceTypes.{{model}}/create.mustache", "create.json");
        this.modelTestTemplateFiles.put("model-definitions/types/ddui-views/{{packageName}}.resourceTypes.{{model}}/high.mustache", "high.json");
        this.modelTestTemplateFiles.put("model-definitions/types/ddui-views/{{packageName}}.resourceTypes.{{model}}/low.mustache", "low.json");
        this.modelTestPath = "model-definitions" + File.separator + "types";
    }

    @Override
    protected void addSupportingFiles() {
        String APP_PATH = "app" + File.separatorChar;
        String APP_PACKAGE_PATH = APP_PATH + this.packageName;
        String TEST_PATH = APP_PACKAGE_PATH + File.separatorChar + "test";
        String MODEL_PATH = APP_PACKAGE_PATH + File.separatorChar + "models";
        String CONTROLLER_PATH = APP_PACKAGE_PATH + File.separatorChar + "controllers";
        String SOLUTION_PATH = "solution" + File.separatorChar;
        String SWAGGER_PATH = APP_PACKAGE_PATH + File.separatorChar + "swagger";
        this.supportingFiles.clear();
        this.additionalProperties.put("appSrcPath", APP_PATH);
        this.additionalProperties.put("solutionSrcPath", SOLUTION_PATH);
        this.additionalProperties.put("modelDefinitionsSrcPath", this.modelDocPath);
        this.supportingFiles.add(new SupportingFile("Makefile.mustache", "", "Makefile"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("requirements.mustache", "", "requirements.txt"));
        this.supportingFiles.add(new SupportingFile("app/Dockerfile.mustache", APP_PATH, "Dockerfile"));
        this.supportingFiles.add(new SupportingFile("app/dockerignore.mustache", APP_PATH, ".dockerignore"));
        this.supportingFiles.add(new SupportingFile("app/gitignore.mustache", APP_PATH, ".gitignore"));
        this.supportingFiles.add(new SupportingFile("app/README.mustache", APP_PATH, "README.md"));
        this.supportingFiles.add(new SupportingFile("app/requirements.mustache", APP_PATH, "requirements.txt"));
        this.supportingFiles.add(new SupportingFile("app/setup.mustache", APP_PATH, "setup.py"));
        this.supportingFiles.add(new SupportingFile("app/tox.mustache", APP_PATH, "tox.ini"));
        this.supportingFiles.add(new SupportingFile("app/test-requirements.mustache", APP_PATH, "test-requirements.txt"));
        this.supportingFiles.add(new SupportingFile("app/{{packageName}}/__init__.mustache", APP_PACKAGE_PATH, "__init__.py"));
        this.supportingFiles.add(new SupportingFile("app/{{packageName}}/__main__.mustache", APP_PACKAGE_PATH, "__main__.py"));
        this.supportingFiles.add(new SupportingFile("app/{{packageName}}/encoder.mustache", APP_PACKAGE_PATH, "encoder.py"));
        this.supportingFiles.add(new SupportingFile("app/{{packageName}}/util.mustache", APP_PACKAGE_PATH, "util.py"));
        this.supportingFiles.add(new SupportingFile("app/{{packageName}}/controllers/__init__.mustache", CONTROLLER_PATH, "__init__.py"));
        this.supportingFiles.add(new SupportingFile("app/{{packageName}}/models/__init__.mustache", MODEL_PATH, "__init__.py"));
        this.supportingFiles.add(new SupportingFile("app/{{packageName}}/models/base_model_.mustache", MODEL_PATH, "base_model_.py"));
        this.supportingFiles.add(new SupportingFile("app/{{packageName}}/test/__init__.mustache", TEST_PATH, "__init__.py"));
        this.supportingFiles.add(new SupportingFile("app/{{packageName}}/swagger/swagger.mustache", SWAGGER_PATH, "swagger.yaml"));
        this.supportingFiles.add(new SupportingFile("solution/fig.mustache", SOLUTION_PATH, "fig.yml"));
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + File.separator + this.modelDocPath).replace('.', File.separatorChar);
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name) + "_ResourceType";
    }

    @Override
    public String modelTestFileFolder() {
        return this.outputFolder + File.separator + this.modelTestPath + File.separator + "ddui-views";
    }

    @Override
    public String toModelTestFilename(String name) {
        String resourceTypeFolder = this.packageName + ".resourceTypes." + this.toModelName(name) + File.separator;
        return resourceTypeFolder;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }
}

