/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenSecurity;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractPhpCodegen;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhpSymfonyServerCodegen
extends AbstractPhpCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhpSymfonyServerCodegen.class);
    public static final String BUNDLE_NAME = "bundleName";
    public static final String BUNDLE_ALIAS = "bundleAlias";
    public static final String COMPOSER_VENDOR_NAME = "composerVendorName";
    public static final String COMPOSER_PROJECT_NAME = "composerProjectName";
    public static final String PHP_LEGACY_SUPPORT = "phpLegacySupport";
    public static final Map<String, String> SYMFONY_EXCEPTIONS = new HashMap<String, String>();
    protected String testsPackage;
    protected String apiTestsPackage;
    protected String modelTestsPackage;
    protected String composerVendorName = "openapi";
    protected String composerProjectName = "server-bundle";
    protected String testsDirName = "Tests";
    protected String bundleName;
    protected String bundleClassName;
    protected String bundleExtensionName;
    protected String bundleAlias;
    protected String controllerDirName = "Controller";
    protected String serviceDirName = "Service";
    protected String controllerPackage;
    protected String servicePackage;
    protected Boolean phpLegacySupport = Boolean.TRUE;
    protected HashSet<String> typeHintable;

    public PhpSymfonyServerCodegen() {
        this.importMapping.clear();
        this.supportsInheritance = true;
        this.srcBasePath = ".";
        this.setInvokerPackage("OpenAPI\\Server");
        this.setBundleName("OpenAPIServer");
        this.setBundleAlias("open_api_server");
        this.modelDirName = "Model";
        this.docsBasePath = "Resources/docs";
        this.apiDocPath = this.docsBasePath + "/" + this.apiDirName;
        this.modelDocPath = this.docsBasePath + "/" + this.modelDirName;
        this.outputFolder = "generated-code" + File.separator + "php";
        this.apiTemplateFiles.put("api_controller.mustache", ".php");
        this.modelTestTemplateFiles.put("testing/model_test.mustache", ".php");
        this.apiTestTemplateFiles = new HashMap();
        this.apiTestTemplateFiles.put("testing/api_test.mustache", ".php");
        this.templateDir = "php-symfony";
        this.embeddedTemplateDir = "php-symfony";
        this.hideGenerationTimestamp = Boolean.TRUE;
        this.setReservedWordsLowerCase(Arrays.asList("resourcePath", "httpBody", "queryParams", "headerParams", "formParams", "_header_accept", "_tempBody", "__halt_compiler", "abstract", "and", "array", "as", "break", "callable", "case", "catch", "class", "clone", "const", "continue", "declare", "default", "die", "do", "echo", "else", "elseif", "empty", "enddeclare", "endfor", "endforeach", "endif", "endswitch", "endwhile", "eval", "exit", "extends", "final", "for", "foreach", "function", "global", "goto", "if", "implements", "include", "include_once", "instanceof", "insteadof", "interface", "isset", "list", "namespace", "new", "or", "print", "private", "protected", "public", "require", "require_once", "return", "static", "switch", "throw", "trait", "try", "unset", "use", "var", "while", "xor"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("bool", "int", "double", "float", "string", "object", "mixed", "number", "void", "byte", "array"));
        this.defaultIncludes = new HashSet<String>(Arrays.asList("\\DateTime", "UploadedFile"));
        this.variableNamingConvention = "camelCase";
        ArrayList sortedLanguageSpecificPrimitives = new ArrayList(this.languageSpecificPrimitives);
        Collections.sort(sortedLanguageSpecificPrimitives);
        String primitives = "'" + org.apache.commons.lang3.StringUtils.join(sortedLanguageSpecificPrimitives, (String)"', '") + "'";
        this.additionalProperties.put("primitives", primitives);
        this.typeMapping = new HashMap();
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("long", "int");
        this.typeMapping.put("number", "float");
        this.typeMapping.put("float", "float");
        this.typeMapping.put("double", "double");
        this.typeMapping.put("string", "string");
        this.typeMapping.put("byte", "int");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("Date", "\\DateTime");
        this.typeMapping.put("DateTime", "\\DateTime");
        this.typeMapping.put("file", "UploadedFile");
        this.typeMapping.put("map", "array");
        this.typeMapping.put("array", "array");
        this.typeMapping.put("list", "array");
        this.typeMapping.put("object", "array");
        this.typeMapping.put("binary", "string");
        this.typeMapping.put("ByteArray", "string");
        this.typeMapping.put("UUID", "string");
        this.cliOptions.add(new CliOption(COMPOSER_VENDOR_NAME, "The vendor name used in the composer package name. The template uses {{composerVendorName}}/{{composerProjectName}} for the composer package name. e.g. yaypets"));
        this.cliOptions.add(new CliOption(BUNDLE_NAME, "The name of the Symfony bundle. The template uses {{bundleName}}"));
        this.cliOptions.add(new CliOption(BUNDLE_ALIAS, "The alias of the Symfony bundle. The template uses {{aliasName}}"));
        this.cliOptions.add(new CliOption(COMPOSER_PROJECT_NAME, "The project name used in the composer package name. The template uses {{composerVendorName}}/{{composerProjectName}} for the composer package name. e.g. petstore-client"));
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "Hides the generation timestamp when files are generated.").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(new CliOption(PHP_LEGACY_SUPPORT, "Should the generated code be compatible with PHP 5.x?").defaultValue(Boolean.TRUE.toString()));
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public void setBundleName(String bundleName) {
        this.bundleName = bundleName;
        this.bundleClassName = bundleName + "Bundle";
        this.bundleExtensionName = bundleName + "Extension";
    }

    public void setBundleAlias(String alias) {
        this.bundleAlias = alias != null && !alias.isEmpty() ? alias.toLowerCase(Locale.ROOT) : this.snakeCase(this.bundleName).replaceAll("([A-Z]+)", "\\_$1").toLowerCase(Locale.ROOT);
    }

    public void setPhpLegacySupport(Boolean support) {
        this.phpLegacySupport = support;
    }

    public String controllerFileFolder() {
        return this.outputFolder + File.separator + this.toSrcPath(this.controllerPackage, this.srcBasePath);
    }

    @Override
    public String escapeText(String input) {
        if (input != null) {
            return super.escapeText(input).trim();
        }
        return input;
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "php-symfony";
    }

    @Override
    public String getHelp() {
        return "Generates a PHP Symfony server bundle.";
    }

    @Override
    public String apiFilename(String templateName, String tag) {
        String suffix = this.apiTemplateFiles().get(templateName);
        if (templateName.equals("api_controller.mustache")) {
            return this.controllerFileFolder() + File.separator + this.toControllerName(tag) + suffix;
        }
        return this.apiFileFolder() + File.separator + this.toApiFilename(tag) + suffix;
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(BUNDLE_NAME)) {
            this.setBundleName((String)this.additionalProperties.get(BUNDLE_NAME));
        } else {
            this.additionalProperties.put(BUNDLE_NAME, this.bundleName);
        }
        if (this.additionalProperties.containsKey(BUNDLE_ALIAS)) {
            this.setBundleAlias((String)this.additionalProperties.get(BUNDLE_ALIAS));
        } else {
            this.additionalProperties.put(BUNDLE_ALIAS, this.bundleAlias);
        }
        if (this.additionalProperties.containsKey(COMPOSER_PROJECT_NAME)) {
            this.setComposerProjectName((String)this.additionalProperties.get(COMPOSER_PROJECT_NAME));
        } else {
            this.additionalProperties.put(COMPOSER_PROJECT_NAME, this.composerProjectName);
        }
        if (this.additionalProperties.containsKey(COMPOSER_VENDOR_NAME)) {
            this.setComposerVendorName((String)this.additionalProperties.get(COMPOSER_VENDOR_NAME));
        } else {
            this.additionalProperties.put(COMPOSER_VENDOR_NAME, this.composerVendorName);
        }
        if (this.additionalProperties.containsKey(PHP_LEGACY_SUPPORT)) {
            this.setPhpLegacySupport(Boolean.valueOf((String)this.additionalProperties.get(PHP_LEGACY_SUPPORT)));
        } else {
            this.additionalProperties.put(PHP_LEGACY_SUPPORT, this.phpLegacySupport);
        }
        this.additionalProperties.put("escapedInvokerPackage", this.invokerPackage.replace("\\", "\\\\"));
        this.additionalProperties.put("controllerPackage", this.controllerPackage);
        this.additionalProperties.put("servicePackage", this.servicePackage);
        this.additionalProperties.put("apiTestsPackage", this.apiTestsPackage);
        this.additionalProperties.put("modelTestsPackage", this.modelTestsPackage);
        this.additionalProperties.put(BUNDLE_NAME, this.bundleName);
        this.additionalProperties.put("bundleClassName", this.bundleClassName);
        this.additionalProperties.put("bundleExtensionName", this.bundleExtensionName);
        this.additionalProperties.put(BUNDLE_ALIAS, this.bundleAlias);
        this.additionalProperties.put("apiSrcPath", "./" + this.toSrcPath(this.apiPackage, this.srcBasePath));
        this.additionalProperties.put("modelSrcPath", "./" + this.toSrcPath(this.modelPackage, this.srcBasePath));
        this.additionalProperties.put("testsSrcPath", "./" + this.toSrcPath(this.testsPackage, this.srcBasePath));
        this.additionalProperties.put("apiTestsSrcPath", "./" + this.toSrcPath(this.apiTestsPackage, this.srcBasePath));
        this.additionalProperties.put("modelTestsSrcPath", "./" + this.toSrcPath(this.modelTestsPackage, this.srcBasePath));
        this.additionalProperties.put("apiTestPath", "./" + this.testsDirName + "/" + this.apiDirName);
        this.additionalProperties.put("modelTestPath", "./" + this.testsDirName + "/" + this.modelDirName);
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        this.additionalProperties.put("testsDirName", this.testsDirName);
        String configDir = "Resources" + File.separator + "config";
        String dependencyInjectionDir = "DependencyInjection";
        this.supportingFiles.add(new SupportingFile("Controller.mustache", this.toSrcPath(this.controllerPackage, this.srcBasePath), "Controller.php"));
        this.supportingFiles.add(new SupportingFile("Bundle.mustache", "", this.bundleClassName + ".php"));
        this.supportingFiles.add(new SupportingFile("Extension.mustache", "DependencyInjection", this.bundleExtensionName + ".php"));
        this.supportingFiles.add(new SupportingFile("ApiPass.mustache", "DependencyInjection" + File.separator + "Compiler", this.bundleName + "ApiPass.php"));
        this.supportingFiles.add(new SupportingFile("ApiServer.mustache", this.toSrcPath(this.apiPackage, this.srcBasePath), "ApiServer.php"));
        this.supportingFiles.add(new SupportingFile("serialization/SerializerInterface.mustache", this.toSrcPath(this.servicePackage, this.srcBasePath), "SerializerInterface.php"));
        this.supportingFiles.add(new SupportingFile("serialization/JmsSerializer.mustache", this.toSrcPath(this.servicePackage, this.srcBasePath), "JmsSerializer.php"));
        this.supportingFiles.add(new SupportingFile("serialization/StrictJsonDeserializationVisitor.mustache", this.toSrcPath(this.servicePackage, this.srcBasePath), "StrictJsonDeserializationVisitor.php"));
        this.supportingFiles.add(new SupportingFile("serialization/TypeMismatchException.mustache", this.toSrcPath(this.servicePackage, this.srcBasePath), "TypeMismatchException.php"));
        this.supportingFiles.add(new SupportingFile("validation/ValidatorInterface.mustache", this.toSrcPath(this.servicePackage, this.srcBasePath), "ValidatorInterface.php"));
        this.supportingFiles.add(new SupportingFile("validation/SymfonyValidator.mustache", this.toSrcPath(this.servicePackage, this.srcBasePath), "SymfonyValidator.php"));
        this.supportingFiles.add(new SupportingFile("testing/phpunit.xml.mustache", "", "phpunit.xml.dist"));
        this.supportingFiles.add(new SupportingFile("testing/pom.xml", "", "pom.xml"));
        this.supportingFiles.add(new SupportingFile("testing/AppKernel.php", this.toSrcPath(this.testsPackage, this.srcBasePath), "AppKernel.php"));
        this.supportingFiles.add(new SupportingFile("testing/test_config.yml", this.toSrcPath(this.testsPackage, this.srcBasePath), "test_config.yml"));
        this.supportingFiles.add(new SupportingFile("routing.mustache", configDir, "routing.yml"));
        this.supportingFiles.add(new SupportingFile("services.mustache", configDir, "services.yml"));
        this.supportingFiles.add(new SupportingFile("composer.mustache", "", "composer.json"));
        this.supportingFiles.add(new SupportingFile("autoload.mustache", "", "autoload.php"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile(".travis.yml", "", ".travis.yml"));
        this.supportingFiles.add(new SupportingFile(".php_cs", "", ".php_cs"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.typeHintable = this.phpLegacySupport != false ? new HashSet<String>(Arrays.asList("array")) : new HashSet<String>(Arrays.asList("array", "bool", "float", "int", "string"));
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        objs = super.postProcessOperationsWithModels(objs, allModels);
        Map operations = (Map)objs.get("operations");
        operations.put("controllerName", this.toControllerName((String)operations.get("pathPrefix")));
        operations.put("symfonyService", this.toSymfonyService((String)operations.get("pathPrefix")));
        HashSet<CodegenSecurity> authMethods = new HashSet<CodegenSecurity>();
        List operationList = (List)operations.get("operation");
        for (CodegenOperation op : operationList) {
            for (CodegenParameter param : op.allParams) {
                String typeHint = this.getTypeHint(param.dataType);
                if (!typeHint.isEmpty()) {
                    param.vendorExtensions.put("x-parameterType", typeHint);
                }
                if (param.isContainer) {
                    param.vendorExtensions.put("x-parameterType", this.getTypeHint(param.dataType + "[]"));
                }
                param.vendorExtensions.put("x-commentType", param.dataType);
                if (param.isContainer) {
                    param.vendorExtensions.put("x-commentType", param.dataType + "[]");
                }
                if (!param.dataType.equals("string") || param.defaultValue == null || param.defaultValue.isEmpty()) continue;
                param.defaultValue = "'" + param.defaultValue + "'";
            }
            if (op.returnType != null) {
                op.vendorExtensions.put("x-commentType", op.returnType);
                if (!op.returnTypeIsPrimitive) {
                    op.vendorExtensions.put("x-commentType", op.returnType + "[]");
                }
            } else {
                op.vendorExtensions.put("x-commentType", "void");
            }
            if (op.authMethods == null) continue;
            authMethods.addAll(op.authMethods);
        }
        operations.put("authMethods", authMethods);
        return objs;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        objs = super.postProcessModels(objs);
        ArrayList modelsArray = (ArrayList)objs.get("models");
        Map models = (Map)modelsArray.get(0);
        CodegenModel model = (CodegenModel)models.get("model");
        for (CodegenProperty var : model.vars) {
            if (var.dataType == null) continue;
            String typeHint = this.getTypeHint(var.dataType);
            if (!typeHint.isEmpty()) {
                var.vendorExtensions.put("x-parameterType", typeHint);
            }
            if (var.isContainer) {
                var.vendorExtensions.put("x-parameterType", this.getTypeHint(var.dataType + "[]"));
            }
            var.vendorExtensions.put("x-commentType", var.dataType);
            if (!var.isContainer) continue;
            var.vendorExtensions.put("x-commentType", var.dataType + "[]");
        }
        return objs;
    }

    @Override
    public String toBooleanGetter(String name) {
        return "is" + this.getterAndSetterCapitalize(name);
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + File.separator + this.toSrcPath(this.apiTestsPackage, this.srcBasePath);
    }

    @Override
    public String modelTestFileFolder() {
        return this.outputFolder + File.separator + this.toSrcPath(this.modelTestsPackage, this.srcBasePath);
    }

    public void setComposerVendorName(String composerVendorName) {
        this.composerVendorName = composerVendorName;
    }

    public void setComposerProjectName(String composerProjectName) {
        this.composerProjectName = composerProjectName;
    }

    @Override
    public void setInvokerPackage(String invokerPackage) {
        super.setInvokerPackage(invokerPackage);
        this.apiPackage = invokerPackage + "\\" + this.apiDirName;
        this.modelPackage = invokerPackage + "\\" + this.modelDirName;
        this.testsPackage = invokerPackage + "\\" + this.testsDirName;
        this.apiTestsPackage = this.testsPackage + "\\" + this.apiDirName;
        this.modelTestsPackage = this.testsPackage + "\\" + this.modelDirName;
        this.controllerPackage = invokerPackage + "\\" + this.controllerDirName;
        this.servicePackage = invokerPackage + "\\" + this.serviceDirName;
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return this.getTypeDeclaration(inner);
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            return this.getTypeDeclaration(inner);
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)p.get$ref())) {
            return this.getTypeDeclaration(this.getPropertyTypeDeclaration(p));
        }
        return this.getPropertyTypeDeclaration(p);
    }

    public String getPropertyTypeDeclaration(Schema p) {
        String openAPIType = this.getSchemaType(p);
        if (this.typeMapping.containsKey(openAPIType)) {
            return (String)this.typeMapping.get(openAPIType);
        }
        return openAPIType;
    }

    @Override
    public String getTypeDeclaration(String name) {
        if (!this.languageSpecificPrimitives.contains(name)) {
            return this.modelPackage + "\\" + name;
        }
        return super.getTypeDeclaration(name);
    }

    @Override
    public String toModelImport(String name) {
        if ("".equals(this.modelPackage())) {
            return name;
        }
        return this.modelPackage() + "\\" + name;
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("int".equals(datatype) || "double".equals(datatype) || "float".equals(datatype)) {
            return value;
        }
        return "\"" + this.escapeText(value) + "\"";
    }

    @Override
    public String toRegularExpression(String pattern) {
        return this.escapeText(pattern);
    }

    @Override
    public String toApiName(String name) {
        if (name.isEmpty()) {
            return "DefaultApiInterface";
        }
        return StringUtils.camelize(name, false) + "ApiInterface";
    }

    protected String toControllerName(String name) {
        if (name.isEmpty()) {
            return "DefaultController";
        }
        return StringUtils.camelize(name, false) + "Controller";
    }

    protected String toSymfonyService(String name) {
        String prefix = this.composerVendorName + ".api.";
        if (name.isEmpty()) {
            return prefix + "default";
        }
        return prefix + name;
    }

    protected String getTypeHint(String type) {
        if (type.endsWith("[]")) {
            return "array";
        }
        if (this.typeHintable.contains(type)) {
            return type;
        }
        if (this.defaultIncludes.contains(type)) {
            return type;
        }
        if (this.isModelClass(type).booleanValue()) {
            return this.extractSimpleName(type);
        }
        return "";
    }

    protected Boolean isModelClass(String type) {
        return type.contains(this.modelPackage());
    }

    static {
        SYMFONY_EXCEPTIONS.put("400", "Symfony\\Component\\HttpKernel\\Exception\\BadRequestHttpException");
        SYMFONY_EXCEPTIONS.put("401", "Symfony\\Component\\HttpKernel\\Exception\\UnauthorizedHttpException");
        SYMFONY_EXCEPTIONS.put("403", "Symfony\\Component\\HttpKernel\\Exception\\AccessDeniedHttpException");
        SYMFONY_EXCEPTIONS.put("404", "Symfony\\Component\\HttpKernel\\Exception\\NotFoundHttpException");
        SYMFONY_EXCEPTIONS.put("405", "Symfony\\Component\\HttpKernel\\Exception\\MethodNotAllowedHttpException");
        SYMFONY_EXCEPTIONS.put("406", "Symfony\\Component\\HttpKernel\\Exception\\NotAcceptableHttpException");
        SYMFONY_EXCEPTIONS.put("409", "Symfony\\Component\\HttpKernel\\Exception\\ConflictHttpException");
        SYMFONY_EXCEPTIONS.put("410", "Symfony\\Component\\HttpKernel\\Exception\\GoneHttpException");
        SYMFONY_EXCEPTIONS.put("411", "Symfony\\Component\\HttpKernel\\Exception\\LengthRequiredHttpException");
        SYMFONY_EXCEPTIONS.put("412", "Symfony\\Component\\HttpKernel\\Exception\\PreconditionFailedHttpException");
        SYMFONY_EXCEPTIONS.put("415", "Symfony\\Component\\HttpKernel\\Exception\\UnsupportedMediaTypeHttpException");
        SYMFONY_EXCEPTIONS.put("422", "Symfony\\Component\\HttpKernel\\Exception\\UnprocessableEntityHttpException");
        SYMFONY_EXCEPTIONS.put("428", "Symfony\\Component\\HttpKernel\\Exception\\PreconditionRequiredHttpException");
        SYMFONY_EXCEPTIONS.put("429", "Symfony\\Component\\HttpKernel\\Exception\\TooManyRequestsHttpException");
        SYMFONY_EXCEPTIONS.put("503", "Symfony\\Component\\HttpKernel\\Exception\\ServiceUnavailableHttpException");
    }
}

