/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Swift4Codegen
extends DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(Swift4Codegen.class);
    public static final String PROJECT_NAME = "projectName";
    public static final String RESPONSE_AS = "responseAs";
    public static final String UNWRAP_REQUIRED = "unwrapRequired";
    public static final String OBJC_COMPATIBLE = "objcCompatible";
    public static final String POD_SOURCE = "podSource";
    public static final String POD_AUTHORS = "podAuthors";
    public static final String POD_SOCIAL_MEDIA_URL = "podSocialMediaURL";
    public static final String POD_DOCSET_URL = "podDocsetURL";
    public static final String POD_LICENSE = "podLicense";
    public static final String POD_HOMEPAGE = "podHomepage";
    public static final String POD_SUMMARY = "podSummary";
    public static final String POD_DESCRIPTION = "podDescription";
    public static final String POD_SCREENSHOTS = "podScreenshots";
    public static final String POD_DOCUMENTATION_URL = "podDocumentationURL";
    public static final String SWIFT_USE_API_NAMESPACE = "swiftUseApiNamespace";
    public static final String DEFAULT_POD_AUTHORS = "OpenAPI Generator";
    public static final String LENIENT_TYPE_CAST = "lenientTypeCast";
    protected static final String LIBRARY_PROMISE_KIT = "PromiseKit";
    protected static final String LIBRARY_RX_SWIFT = "RxSwift";
    protected static final String[] RESPONSE_LIBRARIES = new String[]{"PromiseKit", "RxSwift"};
    protected String projectName = "OpenAPIClient";
    protected boolean unwrapRequired;
    protected boolean objcCompatible = false;
    protected boolean lenientTypeCast = false;
    protected boolean swiftUseApiNamespace;
    protected String[] responseAs = new String[0];
    protected String sourceFolder = "Classes" + File.separator + "OpenAPIs";

    public Swift4Codegen() {
        this.outputFolder = "generated-code" + File.separator + "swift";
        this.modelTemplateFiles.put("model.mustache", ".swift");
        this.apiTemplateFiles.put("api.mustache", ".swift");
        this.templateDir = "swift4";
        this.embeddedTemplateDir = "swift4";
        this.apiPackage = File.separator + "APIs";
        this.modelPackage = File.separator + "Models";
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("Int", "Int32", "Int64", "Float", "Double", "Bool", "Void", "String", "Character", "AnyObject", "Any"));
        this.defaultIncludes = new HashSet<String>(Arrays.asList("Data", "Date", "URL", "UUID", "Array", "Dictionary", "Set", "Any", "Empty", "AnyObject", "Any"));
        this.reservedWords = new HashSet<String>(Arrays.asList("ErrorResponse", "Response", "id", "description", "NSArray", "NSURL", "CGFloat", "NSSet", "NSString", "NSInteger", "NSUInteger", "NSError", "NSDictionary", "associatedtype", "class", "deinit", "enum", "extension", "fileprivate", "func", "import", "init", "inout", "internal", "let", "open", "operator", "private", "protocol", "public", "static", "struct", "subscript", "typealias", "var", "break", "case", "continue", "default", "defer", "do", "else", "fallthrough", "for", "guard", "if", "in", "repeat", "return", "switch", "where", "while", "as", "Any", "catch", "false", "is", "nil", "rethrows", "super", "self", "Self", "throw", "throws", "true", "try", "_", "#available", "#colorLiteral", "#column", "#else", "#elseif", "#endif", "#file", "#fileLiteral", "#function", "#if", "#imageLiteral", "#line", "#selector", "#sourceLocation", "associativity", "convenience", "dynamic", "didSet", "final", "get", "infix", "indirect", "lazy", "left", "mutating", "none", "nonmutating", "optional", "override", "postfix", "precedence", "prefix", "Protocol", "required", "right", "set", "Type", "unowned", "weak", "willSet", "Bool", "Int", "Double", "Float", "Range", "ClosedRange", "Error", "Optional", "UInt", "UInt8", "UInt16", "UInt32", "UInt64", "Int8", "Int16", "Int32", "Int64", "Float80", "Float32", "Float64", "String", "Character", "Unicode", "StaticString", "Array", "Dictionary", "Set", "OptionSet", "CountableRange", "CountableClosedRange", "URL", "Data", "Codable", "Encodable", "Decodable", "Void", "AnyObject", "Class", "dynamicType", "COLUMN", "FILE", "FUNCTION", "LINE"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("array", "Array");
        this.typeMapping.put("List", "Array");
        this.typeMapping.put("map", "Dictionary");
        this.typeMapping.put("date", "Date");
        this.typeMapping.put("Date", "Date");
        this.typeMapping.put("DateTime", "Date");
        this.typeMapping.put("boolean", "Bool");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("char", "Character");
        this.typeMapping.put("short", "Int");
        this.typeMapping.put("int", "Int");
        this.typeMapping.put("long", "Int64");
        this.typeMapping.put("integer", "Int");
        this.typeMapping.put("Integer", "Int");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("number", "Double");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("object", "Any");
        this.typeMapping.put("file", "URL");
        this.typeMapping.put("binary", "URL");
        this.typeMapping.put("ByteArray", "Data");
        this.typeMapping.put("UUID", "UUID");
        this.importMapping = new HashMap();
        this.cliOptions.add(new CliOption(PROJECT_NAME, "Project name in Xcode"));
        this.cliOptions.add(new CliOption(RESPONSE_AS, "Optionally use libraries to manage response.  Currently " + org.apache.commons.lang3.StringUtils.join((Object[])RESPONSE_LIBRARIES, (String)", ") + " are available."));
        this.cliOptions.add(new CliOption(UNWRAP_REQUIRED, "Treat 'required' properties in response as non-optional (which would crash the app if api returns null as opposed to required option specified in json schema"));
        this.cliOptions.add(new CliOption(OBJC_COMPATIBLE, "Add additional properties and methods for Objective-C compatibility (default: false)"));
        this.cliOptions.add(new CliOption(POD_SOURCE, "Source information used for Podspec"));
        this.cliOptions.add(new CliOption("podVersion", "Version used for Podspec"));
        this.cliOptions.add(new CliOption(POD_AUTHORS, "Authors used for Podspec"));
        this.cliOptions.add(new CliOption(POD_SOCIAL_MEDIA_URL, "Social Media URL used for Podspec"));
        this.cliOptions.add(new CliOption(POD_DOCSET_URL, "Docset URL used for Podspec"));
        this.cliOptions.add(new CliOption(POD_LICENSE, "License used for Podspec"));
        this.cliOptions.add(new CliOption(POD_HOMEPAGE, "Homepage used for Podspec"));
        this.cliOptions.add(new CliOption(POD_SUMMARY, "Summary used for Podspec"));
        this.cliOptions.add(new CliOption(POD_DESCRIPTION, "Description used for Podspec"));
        this.cliOptions.add(new CliOption(POD_SCREENSHOTS, "Screenshots used for Podspec"));
        this.cliOptions.add(new CliOption(POD_DOCUMENTATION_URL, "Documentation URL used for Podspec"));
        this.cliOptions.add(new CliOption(SWIFT_USE_API_NAMESPACE, "Flag to make all the API classes inner-class of {{projectName}}API"));
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "Hides the generation timestamp when files are generated.").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(new CliOption(LENIENT_TYPE_CAST, "Accept and cast values for simple types (string->bool, string->int, int->string)").defaultValue(Boolean.FALSE.toString()));
    }

    private static CodegenModel reconcileProperties(CodegenModel codegenModel, CodegenModel parentCodegenModel) {
        List<CodegenProperty> parentModelCodegenProperties = parentCodegenModel.vars;
        List<CodegenProperty> codegenProperties = codegenModel.vars;
        codegenModel.allVars = new ArrayList<CodegenProperty>(codegenProperties);
        codegenModel.parentVars = parentCodegenModel.allVars;
        boolean removedChildProperty = false;
        for (CodegenProperty parentModelCodegenProperty : parentModelCodegenProperties) {
            Iterator<CodegenProperty> iterator = codegenProperties.iterator();
            while (iterator.hasNext()) {
                CodegenProperty codegenProperty = iterator.next();
                if (!codegenProperty.baseName.equals(parentModelCodegenProperty.baseName)) continue;
                iterator.remove();
                removedChildProperty = true;
            }
        }
        if (removedChildProperty) {
            int count = 0;
            int numVars = codegenProperties.size();
            for (CodegenProperty codegenProperty : codegenProperties) {
                codegenProperty.hasMore = ++count < numVars;
            }
            codegenModel.vars = codegenProperties;
        }
        return codegenModel;
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "swift4";
    }

    @Override
    public String getHelp() {
        return "Generates a Swift 4.x client library.";
    }

    @Override
    protected void addAdditionPropertiesToCodeGenModel(CodegenModel codegenModel, Schema schema) {
        Schema additionalProperties = ModelUtils.getAdditionalProperties(schema);
        if (additionalProperties != null) {
            codegenModel.additionalPropertiesType = this.getSchemaType(additionalProperties);
        }
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)System.getenv("SWIFT_POST_PROCESS_FILE"))) {
            LOGGER.info("Environment variable SWIFT_POST_PROCESS_FILE not defined so the Swift code may not be properly formatted. To define it, try 'export SWIFT_POST_PROCESS_FILE=/usr/local/bin/swiftformat' (Linux/Mac)");
        }
        if (this.additionalProperties.containsKey(PROJECT_NAME)) {
            this.setProjectName((String)this.additionalProperties.get(PROJECT_NAME));
        } else {
            this.additionalProperties.put(PROJECT_NAME, this.projectName);
        }
        this.sourceFolder = this.projectName + File.separator + this.sourceFolder;
        if (this.additionalProperties.containsKey(UNWRAP_REQUIRED)) {
            this.setUnwrapRequired(this.convertPropertyToBooleanAndWriteBack(UNWRAP_REQUIRED));
        }
        this.additionalProperties.put(UNWRAP_REQUIRED, this.unwrapRequired);
        if (this.additionalProperties.containsKey(OBJC_COMPATIBLE)) {
            this.setObjcCompatible(this.convertPropertyToBooleanAndWriteBack(OBJC_COMPATIBLE));
        }
        this.additionalProperties.put(OBJC_COMPATIBLE, this.objcCompatible);
        if (this.additionalProperties.containsKey(RESPONSE_AS)) {
            Object responseAsObject = this.additionalProperties.get(RESPONSE_AS);
            if (responseAsObject instanceof String) {
                this.setResponseAs(((String)responseAsObject).split(","));
            } else {
                this.setResponseAs((String[])responseAsObject);
            }
        }
        this.additionalProperties.put(RESPONSE_AS, this.responseAs);
        if (ArrayUtils.contains((Object[])this.responseAs, (Object)LIBRARY_PROMISE_KIT)) {
            this.additionalProperties.put("usePromiseKit", true);
        }
        if (ArrayUtils.contains((Object[])this.responseAs, (Object)LIBRARY_RX_SWIFT)) {
            this.additionalProperties.put("useRxSwift", true);
        }
        if (this.additionalProperties.containsKey(SWIFT_USE_API_NAMESPACE)) {
            this.setSwiftUseApiNamespace(this.convertPropertyToBooleanAndWriteBack(SWIFT_USE_API_NAMESPACE));
        }
        if (!this.additionalProperties.containsKey(POD_AUTHORS)) {
            this.additionalProperties.put(POD_AUTHORS, DEFAULT_POD_AUTHORS);
        }
        this.setLenientTypeCast(this.convertPropertyToBooleanAndWriteBack(LENIENT_TYPE_CAST));
        this.supportingFiles.add(new SupportingFile("Podspec.mustache", "", this.projectName + ".podspec"));
        this.supportingFiles.add(new SupportingFile("Cartfile.mustache", "", "Cartfile"));
        this.supportingFiles.add(new SupportingFile("APIHelper.mustache", this.sourceFolder, "APIHelper.swift"));
        this.supportingFiles.add(new SupportingFile("AlamofireImplementations.mustache", this.sourceFolder, "AlamofireImplementations.swift"));
        this.supportingFiles.add(new SupportingFile("Configuration.mustache", this.sourceFolder, "Configuration.swift"));
        this.supportingFiles.add(new SupportingFile("Extensions.mustache", this.sourceFolder, "Extensions.swift"));
        this.supportingFiles.add(new SupportingFile("Models.mustache", this.sourceFolder, "Models.swift"));
        this.supportingFiles.add(new SupportingFile("APIs.mustache", this.sourceFolder, "APIs.swift"));
        this.supportingFiles.add(new SupportingFile("CodableHelper.mustache", this.sourceFolder, "CodableHelper.swift"));
        this.supportingFiles.add(new SupportingFile("JSONEncodableEncoding.mustache", this.sourceFolder, "JSONEncodableEncoding.swift"));
        this.supportingFiles.add(new SupportingFile("JSONEncodingHelper.mustache", this.sourceFolder, "JSONEncodingHelper.swift"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
    }

    @Override
    protected boolean isReservedWord(String word) {
        return word != null && this.reservedWords.contains(word);
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            return "[String:" + this.getTypeDeclaration(inner) + "]";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSchemaType(Schema p) {
        String type;
        String openAPIType = super.getSchemaType(p);
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (this.languageSpecificPrimitives.contains(type) || this.defaultIncludes.contains(type)) {
                return type;
            }
        } else {
            type = openAPIType;
        }
        return this.toModelName(type);
    }

    @Override
    public boolean isDataTypeFile(String dataType) {
        return dataType != null && dataType.equals("URL");
    }

    @Override
    public boolean isDataTypeBinary(String dataType) {
        return dataType != null && dataType.equals("Data");
    }

    @Override
    public String toModelName(String name) {
        name = this.sanitizeName(name);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (this.isReservedWord(name = StringUtils.camelize(name))) {
            String modelName = "Model" + name;
            LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + modelName);
            return modelName;
        }
        if (name.matches("^\\d.*")) {
            String modelName = "Model" + name;
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + modelName);
            return modelName;
        }
        return name;
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (p.getEnum() != null && !p.getEnum().isEmpty() && p.getDefault() != null) {
            return "." + this.escapeText((String)p.getDefault());
        }
        if (ModelUtils.isIntegerSchema(p) || ModelUtils.isNumberSchema(p) || ModelUtils.isBooleanSchema(p)) {
            if (p.getDefault() != null) {
                return p.getDefault().toString();
            }
        } else if (ModelUtils.isStringSchema(p) && p.getDefault() != null) {
            return "\"" + this.escapeText((String)p.getDefault()) + "\"";
        }
        return null;
    }

    @Override
    public String toInstantiationType(Schema p) {
        if (ModelUtils.isMapSchema(p)) {
            return this.getSchemaType(ModelUtils.getAdditionalProperties(p));
        }
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            String inner = this.getSchemaType(ap.getItems());
            return "[" + inner + "]";
        }
        return null;
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultAPI";
        }
        return this.initialCaps(name) + "API";
    }

    @Override
    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)(operationId = StringUtils.camelize(this.sanitizeName(operationId), true)))) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId)) {
            String newOperationId = StringUtils.camelize("call_" + operationId, true);
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + newOperationId);
            return newOperationId;
        }
        if (operationId.matches("^\\d.*")) {
            LOGGER.warn(operationId + " (starting with a number) cannot be used as method name. Renamed to " + StringUtils.camelize(this.sanitizeName("call_" + operationId), true));
            operationId = StringUtils.camelize(this.sanitizeName("call_" + operationId), true);
        }
        return operationId;
    }

    @Override
    public String toVarName(String name) {
        if ((name = this.sanitizeName(name)).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = StringUtils.camelize(name, true)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        name = this.sanitizeName(name);
        if ((name = name.replaceAll("-", "_")).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = StringUtils.camelize(name, true)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public CodegenModel fromModel(String name, Schema model, Map<String, Schema> allDefinitions) {
        CodegenModel codegenModel = super.fromModel(name, model, allDefinitions);
        if (codegenModel.description != null) {
            codegenModel.imports.add("ApiModel");
        }
        if (allDefinitions != null) {
            String parentSchema = codegenModel.parentSchema;
            while (parentSchema != null) {
                Schema parentModel = allDefinitions.get(parentSchema);
                CodegenModel parentCodegenModel = super.fromModel(codegenModel.parent, parentModel, allDefinitions);
                codegenModel = Swift4Codegen.reconcileProperties(codegenModel, parentCodegenModel);
                parentSchema = parentCodegenModel.parentSchema;
            }
        }
        return codegenModel;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setUnwrapRequired(boolean unwrapRequired) {
        this.unwrapRequired = unwrapRequired;
    }

    public void setObjcCompatible(boolean objcCompatible) {
        this.objcCompatible = objcCompatible;
    }

    public void setLenientTypeCast(boolean lenientTypeCast) {
        this.lenientTypeCast = lenientTypeCast;
    }

    public void setResponseAs(String[] responseAs) {
        this.responseAs = responseAs;
    }

    public void setSwiftUseApiNamespace(boolean swiftUseApiNamespace) {
        this.swiftUseApiNamespace = swiftUseApiNamespace;
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("String".equals(datatype) || "[String]".equals(datatype) || "[String:String]".equals(datatype)) {
            return "\"" + String.valueOf(value) + "\"";
        }
        return String.valueOf(value);
    }

    @Override
    public String toEnumDefaultValue(String value, String datatype) {
        return datatype + "_" + value;
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        String nameLowercase;
        if (name.length() == 0) {
            return "empty";
        }
        Pattern startWithNumberPattern = Pattern.compile("^\\d+");
        Matcher startWithNumberMatcher = startWithNumberPattern.matcher(name);
        if (startWithNumberMatcher.find()) {
            String startingNumbers = startWithNumberMatcher.group(0);
            String nameWithoutStartingNumbers = name.substring(startingNumbers.length());
            return "_" + startingNumbers + StringUtils.camelize(nameWithoutStartingNumbers, true);
        }
        if (this.getSymbolName(name) != null) {
            return StringUtils.camelize(WordUtils.capitalizeFully((String)this.getSymbolName(name).toUpperCase(Locale.ROOT)), true);
        }
        Boolean camelized = false;
        if (name.matches("[A-Z][a-z0-9]+[a-zA-Z0-9]*")) {
            name = StringUtils.camelize(name, true);
            camelized = true;
        }
        if (this.isReservedWord(nameLowercase = org.apache.commons.lang3.StringUtils.lowerCase((String)name))) {
            return this.escapeReservedWord(nameLowercase);
        }
        if ("Int".equals(datatype) || "Int32".equals(datatype) || "Int64".equals(datatype) || "Float".equals(datatype) || "Double".equals(datatype)) {
            String varName = "number" + StringUtils.camelize(name);
            varName = varName.replaceAll("-", "minus");
            varName = varName.replaceAll("\\+", "plus");
            varName = varName.replaceAll("\\.", "dot");
            return varName;
        }
        if (camelized.booleanValue()) {
            return name;
        }
        char[] separators = new char[]{'-', '_', ' ', ':', '(', ')'};
        return StringUtils.camelize(WordUtils.capitalizeFully((String)org.apache.commons.lang3.StringUtils.lowerCase((String)name), (char[])separators).replaceAll("[-_ :\\(\\)]", ""), true);
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        String enumName = this.toModelName(property.name);
        if (this.isReservedWord(property.datatypeWithEnum) || this.toVarName(property.name).equals(property.datatypeWithEnum)) {
            enumName = property.datatypeWithEnum + "Enum";
        }
        if (enumName.matches("\\d.*")) {
            return "_" + enumName;
        }
        return enumName;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        Map<String, Object> postProcessedModelsEnum = this.postProcessModelsEnum(objs);
        List models = (List)postProcessedModelsEnum.get("models");
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            boolean modelHasPropertyWithEscapedName = false;
            for (CodegenProperty prop : cm.allVars) {
                if (prop.name.equals(prop.baseName)) continue;
                prop.vendorExtensions.put("x-codegen-escaped-property-name", true);
                modelHasPropertyWithEscapedName = true;
            }
            if (!modelHasPropertyWithEscapedName) continue;
            cm.vendorExtensions.put("x-codegen-has-escaped-property-names", true);
        }
        return postProcessedModelsEnum;
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        boolean isSwiftScalarType;
        super.postProcessModelProperty(model, property);
        boolean isSwiftOptional = !this.unwrapRequired || !property.required;
        boolean bl = isSwiftScalarType = property.isInteger || property.isLong || property.isFloat || property.isDouble || property.isBoolean;
        if (isSwiftOptional && isSwiftScalarType) {
            property.vendorExtensions.put("x-swift-optional-scalar", true);
        }
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    @Override
    public void postProcessFile(File file, String fileType) {
        if (file == null) {
            return;
        }
        String swiftPostProcessFile = System.getenv("SWIFT_POST_PROCESS_FILE");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)swiftPostProcessFile)) {
            return;
        }
        if ("swift".equals(FilenameUtils.getExtension((String)file.toString()))) {
            String command = swiftPostProcessFile + " " + file.toString();
            try {
                Process p = Runtime.getRuntime().exec(command);
                int exitValue = p.waitFor();
                if (exitValue != 0) {
                    LOGGER.error("Error running the command ({}). Exit value: {}", (Object)command, (Object)exitValue);
                } else {
                    LOGGER.info("Successfully executed: " + command);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error running the command ({}). Exception: {}", (Object)command, (Object)e.getMessage());
            }
        }
    }
}

