/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.io.File;
import java.math.BigDecimal;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElmClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElmClientCodegen.class);
    private Set<String> customPrimitives = new HashSet<String>();
    private ElmVersion elmVersion = ElmVersion.ELM_019;
    private Boolean elmPrefixCustomTypeVariants = false;
    private static final String ELM_VERSION = "elmVersion";
    private static final String ELM_PREFIX_CUSTOM_TYPE_VARIANTS = "elmPrefixCustomTypeVariants";
    private static final String ENCODER = "elmEncoder";
    private static final String DECODER = "elmDecoder";
    private static final String DISCRIMINATOR_NAME = "discriminatorName";
    private static final String UNION_TYPE = "elmUnionType";
    protected String packageName = "openapi";
    protected String packageVersion = "1.0.0";

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "elm";
    }

    @Override
    public String getHelp() {
        return "Generates a Elm client library (beta).";
    }

    public ElmClientCodegen() {
        this.outputFolder = "generated-code/elm";
        this.modelTemplateFiles.put("model.mustache", ".elm");
        this.apiTemplateFiles.put("api.mustache", ".elm");
        this.templateDir = "elm";
        this.supportsInheritance = true;
        this.reservedWords = new HashSet<String>(Arrays.asList("if", "then", "else", "case", "of", "let", "in", "type", "module", "where", "import", "exposing", "as", "port"));
        this.defaultIncludes = new HashSet<String>(Arrays.asList("Order", "Never", "List", "Maybe", "Result", "Program", "Cmd", "Sub"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("Bool", "Dict", "Float", "Int", "String"));
        this.customPrimitives = new HashSet<String>(Arrays.asList("Byte", "DateOnly", "DateTime"));
        this.instantiationTypes.clear();
        this.instantiationTypes.put("array", "List");
        this.instantiationTypes.put("map", "Dict");
        this.typeMapping.clear();
        this.typeMapping.put("integer", "Int");
        this.typeMapping.put("long", "Int");
        this.typeMapping.put("number", "Float");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("double", "Float");
        this.typeMapping.put("boolean", "Bool");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("array", "List");
        this.typeMapping.put("map", "Dict");
        this.typeMapping.put("date", "DateOnly");
        this.typeMapping.put("DateTime", "DateTime");
        this.typeMapping.put("password", "String");
        this.typeMapping.put("ByteArray", "Byte");
        this.typeMapping.put("file", "String");
        this.typeMapping.put("binary", "String");
        this.importMapping.clear();
        this.cliOptions.clear();
        CliOption elmVersion = new CliOption(ELM_VERSION, "Elm version: 0.18, 0.19").defaultValue("0.19");
        HashMap<String, String> supportedVersions = new HashMap<String, String>();
        supportedVersions.put("0.18", "Elm 0.18");
        supportedVersions.put("0.19", "Elm 0.19");
        elmVersion.setEnum(supportedVersions);
        this.cliOptions.add(elmVersion);
        CliOption elmPrefixCustomTypeVariants = CliOption.newBoolean(ELM_PREFIX_CUSTOM_TYPE_VARIANTS, "Prefix custom type variants");
        this.cliOptions.add(elmPrefixCustomTypeVariants);
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(ELM_VERSION)) {
            String version = (String)this.additionalProperties.get(ELM_VERSION);
            this.elmVersion = "0.18".equals(version) ? ElmVersion.ELM_018 : ElmVersion.ELM_019;
        }
        if (this.additionalProperties.containsKey(ELM_PREFIX_CUSTOM_TYPE_VARIANTS)) {
            this.elmPrefixCustomTypeVariants = Boolean.TRUE.equals(Boolean.valueOf(this.additionalProperties.get(ELM_PREFIX_CUSTOM_TYPE_VARIANTS).toString()));
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)System.getenv("ELM_POST_PROCESS_FILE"))) {
            if (this.elmVersion.equals((Object)ElmVersion.ELM_018)) {
                LOGGER.info("Environment variable ELM_POST_PROCESS_FILE not defined so the Elm code may not be properly formatted. To define it, try `export ELM_POST_PROCESS_FILE=\"/usr/local/bin/elm-format --elm-version={} --yes\"` (Linux/Mac)", (Object)"0.18");
            } else {
                LOGGER.info("Environment variable ELM_POST_PROCESS_FILE not defined so the Elm code may not be properly formatted. To define it, try `export ELM_POST_PROCESS_FILE=\"/usr/local/bin/elm-format --elm-version={} --yes\"` (Linux/Mac)", (Object)"0.19");
            }
        }
        switch (this.elmVersion) {
            case ELM_018: {
                LOGGER.info("Elm version: 0.18");
                this.additionalProperties.put("isElm018", true);
                this.supportingFiles.add(new SupportingFile("DateOnly018.mustache", "src", "DateOnly.elm"));
                this.supportingFiles.add(new SupportingFile("DateTime018.mustache", "src", "DateTime.elm"));
                this.supportingFiles.add(new SupportingFile("elm-package018.mustache", "", "elm-package.json"));
                this.supportingFiles.add(new SupportingFile("Main018.mustache", "src", "Main.elm"));
                break;
            }
            case ELM_019: {
                LOGGER.info("Elm version: 0.19");
                this.additionalProperties.put("isElm019", true);
                this.supportingFiles.add(new SupportingFile("DateOnly.mustache", "src", "DateOnly.elm"));
                this.supportingFiles.add(new SupportingFile("DateTime.mustache", "src", "DateTime.elm"));
                this.supportingFiles.add(new SupportingFile("elm.mustache", "", "elm.json"));
                this.supportingFiles.add(new SupportingFile("Main.mustache", "src", "Main.elm"));
                break;
            }
            default: {
                throw new RuntimeException("Undefined Elm version");
            }
        }
        this.supportingFiles.add(new SupportingFile("Byte.mustache", "src", "Byte.elm"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "Default";
        }
        return this.initialCaps(name);
    }

    @Override
    public String toModelName(String name) {
        String modelName = StringUtils.camelize(name);
        return this.defaultIncludes.contains(modelName) ? modelName + "_" : modelName;
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        return this.toModelName(property.name);
    }

    @Override
    public String toVarName(String name) {
        String varName = StringUtils.camelize(name, true);
        return this.isReservedWord(varName) ? this.escapeReservedWord(name) : varName;
    }

    @Override
    public String toEnumVarName(String value, String datatype) {
        String camelized = StringUtils.camelize(value.replace(" ", "_").replace("(", "_").replace(")", ""));
        if (!Character.isUpperCase(camelized.charAt(0))) {
            return "N" + camelized;
        }
        return camelized;
    }

    @Override
    public String toInstantiationType(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            String inner = this.getSchemaType(ap.getItems());
            return (String)this.instantiationTypes.get("array") + " " + inner;
        }
        return null;
    }

    @Override
    public String escapeReservedWord(String name) {
        return name + "_";
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + "/src/Request/" + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + "/src/Data/" + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public CodegenModel fromModel(String name, Schema schema, Map<String, Schema> allDefinitions) {
        CodegenModel m = super.fromModel(name, schema, allDefinitions);
        if (ModelUtils.isArraySchema(schema)) {
            ArraySchema am = (ArraySchema)schema;
            CodegenProperty codegenProperty = this.fromProperty(name, am.getItems());
            m.vendorExtensions.putAll(codegenProperty.vendorExtensions);
        }
        return m;
    }

    @Override
    public Map<String, Object> postProcessAllModels(Map<String, Object> objs) {
        HashMap<String, CodegenModel> allModels = new HashMap<String, CodegenModel>();
        for (Map.Entry<String, Object> entry : objs.entrySet()) {
            String modelName = this.toModelName(entry.getKey());
            Map inner = (Map)entry.getValue();
            List models = (List)inner.get("models");
            for (Map mo : models) {
                CodegenModel cm = (CodegenModel)mo.get("model");
                allModels.put(modelName, cm);
            }
        }
        for (CodegenModel cm : allModels.values()) {
            CodegenModel parent = (CodegenModel)allModels.get(cm.parent);
            if (parent == null) continue;
            if (parent.children == null) {
                parent.children = new ArrayList<CodegenModel>();
                parent.hasChildren = true;
            }
            parent.children.add(cm);
            Collections.sort(parent.children, new Comparator<CodegenModel>(){

                @Override
                public int compare(CodegenModel cm1, CodegenModel cm2) {
                    return Collator.getInstance(Locale.ROOT).compare(cm1.classname, cm2.classname);
                }
            });
        }
        for (Map.Entry<String, Object> entry : objs.entrySet()) {
            Map inner = (Map)entry.getValue();
            List models = (List)inner.get("models");
            for (Map mo : models) {
                ElmImport elmImport;
                CodegenModel cm = (CodegenModel)mo.get("model");
                if (cm.isEnum) {
                    this.addEncoderAndDecoder(cm.vendorExtensions, cm.classname, DataTypeExposure.EXPOSED);
                    cm.vendorExtensions.put(UNION_TYPE, cm.classname);
                } else if (cm.isAlias) {
                    this.addEncoderAndDecoder(cm.vendorExtensions, cm.dataType, DataTypeExposure.EXPOSED);
                }
                ArrayList<ElmImport> elmImports = new ArrayList<ElmImport>();
                for (CodegenProperty property : cm.allVars) {
                    if (property.complexType == null) continue;
                    elmImport = this.createImport(property.complexType);
                    elmImports.add(elmImport);
                }
                if (cm.isArrayModel && cm.arrayModelType != null) {
                    ElmImport elmImport2 = this.createImport(cm.arrayModelType);
                    elmImports.add(elmImport2);
                }
                if (cm.discriminator != null) {
                    for (CodegenModel child : cm.children) {
                        elmImport = this.createImport(child.classname);
                        elmImports.add(elmImport);
                        String propertyName = cm.discriminator.getPropertyName();
                        List allVars = child.allVars.stream().filter(var -> !var.baseName.equals(propertyName)).collect(Collectors.toList());
                        child.allVars.clear();
                        child.allVars.addAll(allVars);
                        child.vendorExtensions.put(DISCRIMINATOR_NAME, propertyName);
                    }
                }
                inner.put("elmImports", elmImports);
            }
        }
        return objs;
    }

    private ElmImport createImport(String name) {
        ElmImport elmImport = new ElmImport();
        boolean isData = !this.customPrimitives.contains(name);
        String modulePrefix = isData ? "Data." : "";
        elmImport.moduleName = modulePrefix + name;
        if (isData) {
            elmImport.as = name;
        }
        elmImport.exposures = new TreeSet<String>();
        elmImport.exposures.add(name);
        elmImport.hasExposures = true;
        return elmImport;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        return this.postProcessModelsEnum(objs);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> operations, List<Object> allModels) {
        ElmImport elmImport;
        Map objs = (Map)operations.get("operations");
        List ops = (List)objs.get("operation");
        boolean hasDateTime = false;
        boolean hasDate = false;
        HashMap dependencies = new HashMap();
        for (Object op : ops) {
            Object encoder;
            void var10_10;
            String string = ((CodegenOperation)op).path;
            for (CodegenParameter param : ((CodegenOperation)op).pathParams) {
                String var = this.paramToString(param);
                String string2 = var10_10.replace("{" + param.paramName + "}", "\" ++ " + var + " ++ \"");
                hasDateTime = hasDateTime || param.isDateTime;
                hasDate = hasDate || param.isDate;
            }
            ((CodegenOperation)op).path = ("\"" + (String)var10_10 + "\"").replaceAll(" \\+\\+ \"\"", "");
            if (!(((CodegenOperation)op).bodyParam == null || ((CodegenOperation)op).bodyParam.isPrimitiveType || ((CodegenOperation)op).bodyParam.isMapContainer || (encoder = (String)((CodegenOperation)op).bodyParam.vendorExtensions.get(ENCODER)) == null || dependencies.containsKey(((CodegenOperation)op).bodyParam.dataType))) {
                dependencies.put(((CodegenOperation)op).bodyParam.dataType, new TreeSet());
            }
            encoder = ((CodegenOperation)op).responses.iterator();
            while (encoder.hasNext()) {
                String decoder;
                CodegenResponse resp = encoder.next();
                if (resp.primitiveType || resp.isMapContainer || (decoder = (String)resp.vendorExtensions.get(DECODER)) == null || dependencies.containsKey(resp.dataType)) continue;
                dependencies.put(resp.dataType, new TreeSet());
            }
        }
        ArrayList<ElmImport> elmImports = new ArrayList<ElmImport>();
        for (Map.Entry entry : dependencies.entrySet()) {
            ElmImport elmImport2 = new ElmImport();
            String key = (String)entry.getKey();
            elmImport2.moduleName = "Data." + key;
            elmImport2.as = key;
            elmImport2.exposures = (Set)entry.getValue();
            elmImport2.exposures.add(key);
            elmImport2.hasExposures = true;
            elmImports.add(elmImport2);
        }
        if (hasDate) {
            elmImport = new ElmImport();
            elmImport.moduleName = "DateOnly";
            elmImport.exposures = new TreeSet<String>();
            elmImport.exposures.add("DateOnly");
            elmImport.hasExposures = true;
            elmImports.add(elmImport);
        }
        if (hasDateTime) {
            elmImport = new ElmImport();
            elmImport.moduleName = "DateTime";
            elmImport.exposures = new TreeSet<String>();
            elmImport.exposures.add("DateTime");
            elmImport.hasExposures = true;
            elmImports.add(elmImport);
        }
        operations.put("elmImports", elmImports);
        return operations;
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isStringSchema(p)) {
            if (p.getDefault() != null) {
                return this.toOptionalValue("\"" + p.getDefault().toString() + "\"");
            }
            return this.toOptionalValue(null);
        }
        if (ModelUtils.isBooleanSchema(p)) {
            if (p.getDefault() != null) {
                return this.toOptionalValue(Boolean.valueOf(p.getDefault().toString()) != false ? "True" : "False");
            }
            return this.toOptionalValue(null);
        }
        if (ModelUtils.isDateSchema(p)) {
            return this.toOptionalValue(null);
        }
        if (ModelUtils.isDateTimeSchema(p)) {
            return this.toOptionalValue(null);
        }
        if (ModelUtils.isNumberSchema(p)) {
            NumberSchema dp = (NumberSchema)p;
            if (dp.getDefault() != null) {
                return this.toOptionalValue(((BigDecimal)dp.getDefault()).toString());
            }
            return this.toOptionalValue(null);
        }
        if (ModelUtils.isIntegerSchema(p)) {
            if (p.getDefault() != null) {
                return this.toOptionalValue(p.getDefault().toString());
            }
            return this.toOptionalValue(null);
        }
        return this.toOptionalValue(null);
    }

    private String toOptionalValue(String value) {
        if (value == null) {
            return "Nothing";
        }
        return "(Just " + value + ")";
    }

    private String paramToString(CodegenParameter param) {
        String paramName = param.paramName;
        if (param.isString || param.isUuid || param.isBinary || param.isByteArray) {
            return paramName;
        }
        if (param.isBoolean) {
            return "if " + paramName + " then \"true\" else \"false\"";
        }
        if (param.isDateTime) {
            return "DateTime.toString " + paramName;
        }
        if (param.isDate) {
            return "DateOnly.toString " + paramName;
        }
        if (ElmVersion.ELM_018.equals((Object)this.elmVersion)) {
            return "toString " + paramName;
        }
        if (param.isInteger || param.isLong) {
            return "String.fromInt " + paramName;
        }
        if (param.isFloat || param.isDouble) {
            return "String.fromFloat " + paramName;
        }
        throw new RuntimeException("Parameter '" + paramName + "' cannot be converted to a string. Please report the issue.");
    }

    @Override
    public String getSchemaType(Schema p) {
        String type;
        String openAPIType = super.getSchemaType(p);
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = openAPIType;
        }
        return this.toModelName(type);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return this.getTypeDeclaration(inner);
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            return this.getTypeDeclaration(inner);
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public CodegenProperty fromProperty(String name, Schema p) {
        CodegenProperty property = super.fromProperty(name, p);
        if (property.isEnum) {
            this.addEncoderAndDecoder(property.vendorExtensions, property.baseName, DataTypeExposure.INTERNAL);
            property.vendorExtensions.put(UNION_TYPE, property.datatypeWithEnum);
        } else {
            boolean isPrimitiveType = property.isMapContainer ? this.isPrimitiveDataType(property.dataType) : property.isPrimitiveType;
            this.addEncoderAndDecoder(property.vendorExtensions, property.dataType, isPrimitiveType ? DataTypeExposure.PRIMITIVE : DataTypeExposure.EXTERNAL);
        }
        return property;
    }

    @Override
    public CodegenResponse fromResponse(OpenAPI openAPI, String responseCode, ApiResponse resp) {
        CodegenResponse response = super.fromResponse(openAPI, responseCode, resp);
        if (response.dataType != null) {
            boolean isPrimitiveType = response.isMapContainer ? this.isPrimitiveDataType(response.dataType) : response.primitiveType;
            this.addEncoderAndDecoder(response.vendorExtensions, response.dataType, isPrimitiveType ? DataTypeExposure.PRIMITIVE : DataTypeExposure.EXTERNAL);
        }
        return response;
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        boolean isPrimitiveType = parameter.isMapContainer ? this.isPrimitiveDataType(parameter.dataType) : parameter.isPrimitiveType;
        this.addEncoderAndDecoder(parameter.vendorExtensions, parameter.dataType, isPrimitiveType ? DataTypeExposure.PRIMITIVE : DataTypeExposure.EXTERNAL);
    }

    @Override
    public void updateCodegenPropertyEnum(CodegenProperty property) {
        super.updateCodegenPropertyEnum(property);
        if (!this.elmPrefixCustomTypeVariants.booleanValue()) {
            return;
        }
        Map<String, Object> allowableValues = property.allowableValues;
        if (allowableValues == null) {
            return;
        }
        ArrayList enumVars = (ArrayList)allowableValues.get("enumVars");
        if (enumVars == null) {
            return;
        }
        String prefix = this.toEnumName(property);
        for (Map enumVar : enumVars) {
            enumVar.put("name", prefix + enumVar.get("name"));
        }
    }

    private boolean isPrimitiveDataType(String dataType) {
        return this.languageSpecificPrimitives.contains(dataType);
    }

    private void addEncoderAndDecoder(Map<String, Object> vendorExtensions, String dataType, DataTypeExposure dataTypeExposure) {
        String encoderName;
        String decoderName;
        String baseName = StringUtils.camelize(dataType, true);
        switch (dataTypeExposure) {
            case EXPOSED: {
                decoderName = "decoder";
                encoderName = "encoder";
                break;
            }
            case INTERNAL: {
                encoderName = baseName + "Encoder";
                decoderName = baseName + "Decoder";
                break;
            }
            case EXTERNAL: {
                encoderName = dataType + ".encoder";
                decoderName = dataType + ".decoder";
                break;
            }
            case PRIMITIVE: {
                encoderName = "Encode." + baseName;
                decoderName = "Decode." + baseName;
                break;
            }
            default: {
                encoderName = "";
                decoderName = "";
            }
        }
        if (!vendorExtensions.containsKey(ENCODER)) {
            vendorExtensions.put(ENCODER, encoderName);
        }
        if (!vendorExtensions.containsKey(DECODER)) {
            vendorExtensions.put(DECODER, decoderName);
        }
    }

    @Override
    public void postProcessFile(File file, String fileType) {
        if (file == null) {
            return;
        }
        String elmPostProcessFile = System.getenv("ELM_POST_PROCESS_FILE");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)elmPostProcessFile)) {
            return;
        }
        if ("elm".equals(FilenameUtils.getExtension((String)file.toString()))) {
            String command = elmPostProcessFile + " " + file.toString();
            try {
                Process p = Runtime.getRuntime().exec(command);
                int exitValue = p.waitFor();
                if (exitValue != 0) {
                    LOGGER.error("Error running the command ({}). Exit code: {}", (Object)command, (Object)exitValue);
                } else {
                    LOGGER.info("Successfully executed: " + command);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error running the command ({}). Exception: {}", (Object)command, (Object)e.getMessage());
            }
        }
    }

    private static enum ElmVersion {
        ELM_018,
        ELM_019;

    }

    private static class ElmImport {
        public String moduleName;
        public String as;
        public Set<String> exposures;
        public Boolean hasExposures;

        private ElmImport() {
        }
    }

    private static enum DataTypeExposure {
        EXPOSED,
        INTERNAL,
        EXTERNAL,
        PRIMITIVE;

    }
}

