/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.base.Strings;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.utils.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJavaCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractJavaCodegen.class);
    public static final String FULL_JAVA_UTIL = "fullJavaUtil";
    public static final String DEFAULT_LIBRARY = "<default>";
    public static final String DATE_LIBRARY = "dateLibrary";
    public static final String JAVA8_MODE = "java8";
    public static final String SUPPORT_ASYNC = "supportAsync";
    public static final String WITH_XML = "withXml";
    public static final String SUPPORT_JAVA6 = "supportJava6";
    public static final String DISABLE_HTML_ESCAPING = "disableHtmlEscaping";
    public static final String BOOLEAN_GETTER_PREFIX = "booleanGetterPrefix";
    public static final String BOOLEAN_GETTER_PREFIX_DEFAULT = "get";
    public static final String USE_NULL_FOR_UNKNOWN_ENUM_VALUE = "useNullForUnknownEnumValue";
    protected String dateLibrary = "threetenbp";
    protected boolean supportAsync = false;
    protected boolean java8Mode = false;
    protected boolean withXml = false;
    protected String invokerPackage = "org.openapitools";
    protected String groupId = "org.openapitools";
    protected String artifactId = "openapi-java";
    protected String artifactVersion = "1.0.0";
    protected String artifactUrl = "https://github.com/openapitools/openapi-generator";
    protected String artifactDescription = "OpenAPI Java";
    protected String developerName = "OpenAPI";
    protected String developerEmail = "team@openapitools.org";
    protected String developerOrganization = "OpenAPI";
    protected String developerOrganizationUrl = "http://openapitools.org";
    protected String scmConnection = "scm:git:git@github.com:openapitools/openapi-generator.git";
    protected String scmDeveloperConnection = "scm:git:git@github.com:openapitools/openapi-generator.git";
    protected String scmUrl = "https://github.com/openapitools/openapi-generator";
    protected String licenseName = "Unlicense";
    protected String licenseUrl = "http://unlicense.org";
    protected String projectFolder = "src" + File.separator + "main";
    protected String projectTestFolder = "src" + File.separator + "test";
    protected String sourceFolder = this.projectFolder + File.separator + "java";
    protected String testFolder = this.projectTestFolder + File.separator + "java";
    protected String localVariablePrefix = "";
    protected boolean fullJavaUtil;
    protected String javaUtilPrefix = "";
    protected Boolean serializableModel = false;
    protected boolean serializeBigDecimalAsString = false;
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";
    protected boolean supportJava6 = false;
    protected boolean disableHtmlEscaping = false;
    protected String booleanGetterPrefix = "get";
    protected boolean useNullForUnknownEnumValue = false;

    public AbstractJavaCodegen() {
        this.supportsInheritance = true;
        this.modelTemplateFiles.put("model.mustache", ".java");
        this.apiTemplateFiles.put("api.mustache", ".java");
        this.apiTestTemplateFiles.put("api_test.mustache", ".java");
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.hideGenerationTimestamp = false;
        this.setReservedWordsLowerCase(Arrays.asList("localVarPath", "localVarQueryParams", "localVarCollectionQueryParams", "localVarHeaderParams", "localVarFormParams", "localVarPostBody", "localVarAccepts", "localVarAccept", "localVarContentTypes", "localVarContentType", "localVarAuthNames", "localReturnType", "ApiClient", "ApiException", "ApiResponse", "Configuration", "StringUtil", "abstract", "continue", "for", "new", "switch", "assert", "default", "if", "package", "synchronized", "boolean", "do", "goto", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while", "null"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("String", "boolean", "Boolean", "Double", "Integer", "Long", "Float", "Object", "byte[]"));
        this.instantiationTypes.put("array", "ArrayList");
        this.instantiationTypes.put("map", "HashMap");
        this.typeMapping.put("date", "Date");
        this.typeMapping.put("file", "File");
        this.cliOptions.add(new CliOption("modelPackage", "package for generated models"));
        this.cliOptions.add(new CliOption("apiPackage", "package for generated api classes"));
        this.cliOptions.add(new CliOption("invokerPackage", "root package for generated code"));
        this.cliOptions.add(new CliOption("groupId", "groupId in generated pom.xml"));
        this.cliOptions.add(new CliOption("artifactId", "artifactId in generated pom.xml"));
        this.cliOptions.add(new CliOption("artifactVersion", "artifact version in generated pom.xml"));
        this.cliOptions.add(new CliOption("artifactUrl", "artifact URL in generated pom.xml"));
        this.cliOptions.add(new CliOption("artifactDescription", "artifact description in generated pom.xml"));
        this.cliOptions.add(new CliOption("scmConnection", "SCM connection in generated pom.xml"));
        this.cliOptions.add(new CliOption("scmDeveloperConnection", "SCM developer connection in generated pom.xml"));
        this.cliOptions.add(new CliOption("scmUrl", "SCM URL in generated pom.xml"));
        this.cliOptions.add(new CliOption("developerName", "developer name in generated pom.xml"));
        this.cliOptions.add(new CliOption("developerEmail", "developer email in generated pom.xml"));
        this.cliOptions.add(new CliOption("developerOrganization", "developer organization in generated pom.xml"));
        this.cliOptions.add(new CliOption("developerOrganizationUrl", "developer organization URL in generated pom.xml"));
        this.cliOptions.add(new CliOption("licenseName", "The name of the license"));
        this.cliOptions.add(new CliOption("licenseUrl", "The URL of the license"));
        this.cliOptions.add(new CliOption("sourceFolder", "source folder for generated code"));
        this.cliOptions.add(new CliOption("localVariablePrefix", "prefix for generated code members and local variables"));
        this.cliOptions.add(CliOption.newBoolean("serializableModel", "boolean - toggle \"implements Serializable\" for generated models"));
        this.cliOptions.add(CliOption.newBoolean("bigDecimalAsString", "Treat BigDecimal values as Strings to avoid precision loss."));
        this.cliOptions.add(CliOption.newBoolean(FULL_JAVA_UTIL, "whether to use fully qualified name for classes under java.util. This option only works for Java API client"));
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "hides the timestamp when files were generated"));
        this.cliOptions.add(CliOption.newBoolean(WITH_XML, "whether to include support for application/xml content type and include XML annotations in the model (works with libraries that provide support for JSON and XML)"));
        CliOption dateLibrary = new CliOption(DATE_LIBRARY, "Option. Date library to use");
        HashMap<String, String> dateOptions = new HashMap<String, String>();
        dateOptions.put(JAVA8_MODE, "Java 8 native JSR310 (preferred for jdk 1.8+) - note: this also sets \"java8\" to true");
        dateOptions.put("threetenbp", "Backport of JSR310 (preferred for jdk < 1.8)");
        dateOptions.put("java8-localdatetime", "Java 8 using LocalDateTime (for legacy app only)");
        dateOptions.put("joda", "Joda (for legacy app only)");
        dateOptions.put("legacy", "Legacy java.util.Date (if you really have a good reason not to use threetenbp");
        dateLibrary.setEnum(dateOptions);
        this.cliOptions.add(dateLibrary);
        CliOption java8Mode = new CliOption(JAVA8_MODE, "Option. Use Java8 classes instead of third party equivalents");
        HashMap<String, String> java8ModeOptions = new HashMap<String, String>();
        java8ModeOptions.put("true", "Use Java 8 classes such as Base64");
        java8ModeOptions.put("false", "Various third party libraries as needed");
        java8Mode.setEnum(java8ModeOptions);
        this.cliOptions.add(java8Mode);
        this.cliOptions.add(CliOption.newBoolean(DISABLE_HTML_ESCAPING, "Disable HTML escaping of JSON strings when using gson (needed to avoid problems with byte[] fields)"));
        this.cliOptions.add(CliOption.newString(BOOLEAN_GETTER_PREFIX, "Set booleanGetterPrefix (default value 'get')"));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(SUPPORT_JAVA6)) {
            this.setSupportJava6(Boolean.valueOf(this.additionalProperties.get(SUPPORT_JAVA6).toString()));
        }
        this.additionalProperties.put(SUPPORT_JAVA6, this.supportJava6);
        if (this.additionalProperties.containsKey(DISABLE_HTML_ESCAPING)) {
            this.setDisableHtmlEscaping(Boolean.valueOf(this.additionalProperties.get(DISABLE_HTML_ESCAPING).toString()));
        }
        this.additionalProperties.put(DISABLE_HTML_ESCAPING, this.disableHtmlEscaping);
        if (this.additionalProperties.containsKey(BOOLEAN_GETTER_PREFIX)) {
            this.setBooleanGetterPrefix(this.additionalProperties.get(BOOLEAN_GETTER_PREFIX).toString());
        }
        this.additionalProperties.put(BOOLEAN_GETTER_PREFIX, this.booleanGetterPrefix);
        if (this.additionalProperties.containsKey(USE_NULL_FOR_UNKNOWN_ENUM_VALUE)) {
            this.setUseNullForUnknownEnumValue(Boolean.valueOf(this.additionalProperties.get(USE_NULL_FOR_UNKNOWN_ENUM_VALUE).toString()));
        }
        this.additionalProperties.put(USE_NULL_FOR_UNKNOWN_ENUM_VALUE, this.useNullForUnknownEnumValue);
        if (this.additionalProperties.containsKey("invokerPackage")) {
            this.setInvokerPackage((String)this.additionalProperties.get("invokerPackage"));
        } else if (this.additionalProperties.containsKey("apiPackage")) {
            String derviedInvokerPackage = this.deriveInvokerPackageName((String)this.additionalProperties.get("apiPackage"));
            this.additionalProperties.put("invokerPackage", derviedInvokerPackage);
            this.setInvokerPackage((String)this.additionalProperties.get("invokerPackage"));
            LOGGER.info("Invoker Package Name, originally not set, is now dervied from api package name: " + derviedInvokerPackage);
        } else if (this.additionalProperties.containsKey("modelPackage")) {
            String derviedInvokerPackage = this.deriveInvokerPackageName((String)this.additionalProperties.get("modelPackage"));
            this.additionalProperties.put("invokerPackage", derviedInvokerPackage);
            this.setInvokerPackage((String)this.additionalProperties.get("invokerPackage"));
            LOGGER.info("Invoker Package Name, originally not set, is now dervied from model package name: " + derviedInvokerPackage);
        } else {
            this.additionalProperties.put("invokerPackage", this.invokerPackage);
        }
        if (!this.additionalProperties.containsKey("modelPackage")) {
            this.additionalProperties.put("modelPackage", this.modelPackage);
        }
        if (!this.additionalProperties.containsKey("apiPackage")) {
            this.additionalProperties.put("apiPackage", this.apiPackage);
        }
        if (this.additionalProperties.containsKey("groupId")) {
            this.setGroupId((String)this.additionalProperties.get("groupId"));
        } else {
            this.additionalProperties.put("groupId", this.groupId);
        }
        if (this.additionalProperties.containsKey("artifactId")) {
            this.setArtifactId((String)this.additionalProperties.get("artifactId"));
        } else {
            this.additionalProperties.put("artifactId", this.artifactId);
        }
        if (this.additionalProperties.containsKey("artifactVersion")) {
            this.setArtifactVersion((String)this.additionalProperties.get("artifactVersion"));
        } else {
            this.additionalProperties.put("artifactVersion", this.artifactVersion);
        }
        if (this.additionalProperties.containsKey("artifactUrl")) {
            this.setArtifactUrl((String)this.additionalProperties.get("artifactUrl"));
        } else {
            this.additionalProperties.put("artifactUrl", this.artifactUrl);
        }
        if (this.additionalProperties.containsKey("artifactDescription")) {
            this.setArtifactDescription((String)this.additionalProperties.get("artifactDescription"));
        } else {
            this.additionalProperties.put("artifactDescription", this.artifactDescription);
        }
        if (this.additionalProperties.containsKey("scmConnection")) {
            this.setScmConnection((String)this.additionalProperties.get("scmConnection"));
        } else {
            this.additionalProperties.put("scmConnection", this.scmConnection);
        }
        if (this.additionalProperties.containsKey("scmDeveloperConnection")) {
            this.setScmDeveloperConnection((String)this.additionalProperties.get("scmDeveloperConnection"));
        } else {
            this.additionalProperties.put("scmDeveloperConnection", this.scmDeveloperConnection);
        }
        if (this.additionalProperties.containsKey("scmUrl")) {
            this.setScmUrl((String)this.additionalProperties.get("scmUrl"));
        } else {
            this.additionalProperties.put("scmUrl", this.scmUrl);
        }
        if (this.additionalProperties.containsKey("developerName")) {
            this.setDeveloperName((String)this.additionalProperties.get("developerName"));
        } else {
            this.additionalProperties.put("developerName", this.developerName);
        }
        if (this.additionalProperties.containsKey("developerEmail")) {
            this.setDeveloperEmail((String)this.additionalProperties.get("developerEmail"));
        } else {
            this.additionalProperties.put("developerEmail", this.developerEmail);
        }
        if (this.additionalProperties.containsKey("developerOrganization")) {
            this.setDeveloperOrganization((String)this.additionalProperties.get("developerOrganization"));
        } else {
            this.additionalProperties.put("developerOrganization", this.developerOrganization);
        }
        if (this.additionalProperties.containsKey("developerOrganizationUrl")) {
            this.setDeveloperOrganizationUrl((String)this.additionalProperties.get("developerOrganizationUrl"));
        } else {
            this.additionalProperties.put("developerOrganizationUrl", this.developerOrganizationUrl);
        }
        if (this.additionalProperties.containsKey("licenseName")) {
            this.setLicenseName((String)this.additionalProperties.get("licenseName"));
        } else {
            this.additionalProperties.put("licenseName", this.licenseName);
        }
        if (this.additionalProperties.containsKey("licenseUrl")) {
            this.setLicenseUrl((String)this.additionalProperties.get("licenseUrl"));
        } else {
            this.additionalProperties.put("licenseUrl", this.licenseUrl);
        }
        if (this.additionalProperties.containsKey("sourceFolder")) {
            this.setSourceFolder((String)this.additionalProperties.get("sourceFolder"));
        }
        if (this.additionalProperties.containsKey("localVariablePrefix")) {
            this.setLocalVariablePrefix((String)this.additionalProperties.get("localVariablePrefix"));
        }
        if (this.additionalProperties.containsKey("serializableModel")) {
            this.setSerializableModel(Boolean.valueOf(this.additionalProperties.get("serializableModel").toString()));
        }
        if (this.additionalProperties.containsKey("library")) {
            this.setLibrary((String)this.additionalProperties.get("library"));
        }
        if (this.additionalProperties.containsKey("bigDecimalAsString")) {
            this.setSerializeBigDecimalAsString(Boolean.valueOf(this.additionalProperties.get("bigDecimalAsString").toString()));
        }
        this.additionalProperties.put("serializableModel", this.serializableModel);
        if (this.additionalProperties.containsKey(FULL_JAVA_UTIL)) {
            this.setFullJavaUtil(Boolean.valueOf(this.additionalProperties.get(FULL_JAVA_UTIL).toString()));
        }
        if (this.fullJavaUtil) {
            this.javaUtilPrefix = "java.util.";
        }
        this.additionalProperties.put(FULL_JAVA_UTIL, this.fullJavaUtil);
        this.additionalProperties.put("javaUtilPrefix", this.javaUtilPrefix);
        if (this.additionalProperties.containsKey(WITH_XML)) {
            this.setWithXml(Boolean.valueOf(this.additionalProperties.get(WITH_XML).toString()));
        }
        this.additionalProperties.put(WITH_XML, this.withXml);
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        this.importMapping.put("List", "java.util.List");
        if (this.fullJavaUtil) {
            this.typeMapping.put("array", "java.util.List");
            this.typeMapping.put("map", "java.util.Map");
            this.typeMapping.put("DateTime", "java.util.Date");
            this.typeMapping.put("UUID", "java.util.UUID");
            this.typeMapping.remove("List");
            this.importMapping.remove("Date");
            this.importMapping.remove("Map");
            this.importMapping.remove("HashMap");
            this.importMapping.remove("Array");
            this.importMapping.remove("ArrayList");
            this.importMapping.remove("List");
            this.importMapping.remove("Set");
            this.importMapping.remove("DateTime");
            this.importMapping.remove("UUID");
            this.instantiationTypes.put("array", "java.util.ArrayList");
            this.instantiationTypes.put("map", "java.util.HashMap");
        }
        this.sanitizeConfig();
        this.importMapping.put("ToStringSerializer", "com.fasterxml.jackson.databind.ser.std.ToStringSerializer");
        this.importMapping.put("JsonSerialize", "com.fasterxml.jackson.databind.annotation.JsonSerialize");
        this.importMapping.put("ApiModelProperty", "io.swagger.annotations.ApiModelProperty");
        this.importMapping.put("ApiModel", "io.swagger.annotations.ApiModel");
        this.importMapping.put("JsonProperty", "com.fasterxml.jackson.annotation.JsonProperty");
        this.importMapping.put("JsonSubTypes", "com.fasterxml.jackson.annotation.JsonSubTypes");
        this.importMapping.put("JsonTypeInfo", "com.fasterxml.jackson.annotation.JsonTypeInfo");
        this.importMapping.put("JsonCreator", "com.fasterxml.jackson.annotation.JsonCreator");
        this.importMapping.put("JsonValue", "com.fasterxml.jackson.annotation.JsonValue");
        this.importMapping.put("SerializedName", "com.google.gson.annotations.SerializedName");
        this.importMapping.put("TypeAdapter", "com.google.gson.TypeAdapter");
        this.importMapping.put("JsonAdapter", "com.google.gson.annotations.JsonAdapter");
        this.importMapping.put("JsonReader", "com.google.gson.stream.JsonReader");
        this.importMapping.put("JsonWriter", "com.google.gson.stream.JsonWriter");
        this.importMapping.put("IOException", "java.io.IOException");
        this.importMapping.put("Objects", "java.util.Objects");
        this.importMapping.put("StringUtil", this.invokerPackage + ".StringUtil");
        this.importMapping.put("com.fasterxml.jackson.annotation.JsonProperty", "com.fasterxml.jackson.annotation.JsonCreator");
        if (this.additionalProperties.containsKey(JAVA8_MODE)) {
            this.setJava8Mode(Boolean.parseBoolean(this.additionalProperties.get(JAVA8_MODE).toString()));
            if (this.java8Mode) {
                this.additionalProperties.put(JAVA8_MODE, "true");
            }
        }
        if (this.additionalProperties.containsKey(SUPPORT_ASYNC)) {
            this.setSupportAsync(Boolean.parseBoolean(this.additionalProperties.get(SUPPORT_ASYNC).toString()));
            if (this.supportAsync) {
                this.additionalProperties.put(SUPPORT_ASYNC, "true");
            }
        }
        if (this.additionalProperties.containsKey(WITH_XML)) {
            this.setWithXml(Boolean.parseBoolean(this.additionalProperties.get(WITH_XML).toString()));
            if (this.withXml) {
                this.additionalProperties.put(WITH_XML, "true");
            }
        }
        if (this.additionalProperties.containsKey(DATE_LIBRARY)) {
            this.setDateLibrary(this.additionalProperties.get(DATE_LIBRARY).toString());
        }
        if ("threetenbp".equals(this.dateLibrary)) {
            this.additionalProperties.put("threetenbp", "true");
            this.additionalProperties.put("jsr310", "true");
            this.typeMapping.put("date", "LocalDate");
            this.typeMapping.put("DateTime", "OffsetDateTime");
            this.importMapping.put("LocalDate", "org.threeten.bp.LocalDate");
            this.importMapping.put("OffsetDateTime", "org.threeten.bp.OffsetDateTime");
        } else if ("joda".equals(this.dateLibrary)) {
            this.additionalProperties.put("joda", "true");
            this.typeMapping.put("date", "LocalDate");
            this.typeMapping.put("DateTime", "DateTime");
            this.importMapping.put("LocalDate", "org.joda.time.LocalDate");
            this.importMapping.put("DateTime", "org.joda.time.DateTime");
        } else if (this.dateLibrary.startsWith(JAVA8_MODE)) {
            this.additionalProperties.put(JAVA8_MODE, "true");
            this.additionalProperties.put("jsr310", "true");
            this.typeMapping.put("date", "LocalDate");
            this.importMapping.put("LocalDate", "java.time.LocalDate");
            if ("java8-localdatetime".equals(this.dateLibrary)) {
                this.typeMapping.put("DateTime", "LocalDateTime");
                this.importMapping.put("LocalDateTime", "java.time.LocalDateTime");
            } else {
                this.typeMapping.put("DateTime", "OffsetDateTime");
                this.importMapping.put("OffsetDateTime", "java.time.OffsetDateTime");
            }
        } else if (this.dateLibrary.equals("legacy")) {
            this.additionalProperties.put("legacyDates", "true");
        }
    }

    private void sanitizeConfig() {
        this.setApiPackage(AbstractJavaCodegen.sanitizePackageName(this.apiPackage));
        if (this.additionalProperties.containsKey("apiPackage")) {
            this.additionalProperties.put("apiPackage", this.apiPackage);
        }
        this.setModelPackage(AbstractJavaCodegen.sanitizePackageName(this.modelPackage));
        if (this.additionalProperties.containsKey("modelPackage")) {
            this.additionalProperties.put("modelPackage", this.modelPackage);
        }
        this.setInvokerPackage(AbstractJavaCodegen.sanitizePackageName(this.invokerPackage));
        if (this.additionalProperties.containsKey("invokerPackage")) {
            this.additionalProperties.put("invokerPackage", this.invokerPackage);
        }
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.apiPackage().replace('.', '/');
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + "/" + this.testFolder + "/" + this.apiPackage().replace('.', '/');
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.modelPackage().replace('.', '/');
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + "/" + this.apiDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toApiTestFilename(String name) {
        return this.toApiName(name) + "Test";
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        return AbstractJavaCodegen.camelize(name) + "Api";
    }

    @Override
    public String toApiFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String toVarName(String name) {
        if ((name = this.sanitizeName(name, "\\W-[\\$]")).toLowerCase(Locale.ROOT).matches("^_*class$")) {
            return "propertyClass";
        }
        if ("_".equals(name)) {
            name = "_u";
        }
        if (name.matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.startsWithTwoUppercaseLetters(name)) {
            name = name.substring(0, 2).toLowerCase(Locale.ROOT) + name.substring(2);
        }
        if (name.chars().anyMatch(character -> this.specialCharReplacements.keySet().contains("" + (char)character))) {
            ArrayList<String> allowedCharacters = new ArrayList<String>();
            allowedCharacters.add("_");
            allowedCharacters.add("$");
            name = this.escapeSpecialCharacters(name, allowedCharacters, "_");
        }
        if (this.isReservedWord(name = AbstractJavaCodegen.camelize(name, true)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    private boolean startsWithTwoUppercaseLetters(String name) {
        boolean startsWithTwoUppercaseLetters = false;
        if (name.length() > 1) {
            startsWithTwoUppercaseLetters = name.substring(0, 2).equals(name.substring(0, 2).toUpperCase(Locale.ROOT));
        }
        return startsWithTwoUppercaseLetters;
    }

    @Override
    public String toParamName(String name) {
        if ("callback".equals(name)) {
            return "paramCallback";
        }
        return this.toVarName(name);
    }

    @Override
    public String toModelName(String name) {
        String camelizedName;
        String sanitizedName;
        if (this.importMapping.containsKey(name)) {
            return (String)this.importMapping.get(name);
        }
        String nameWithPrefixSuffix = sanitizedName = this.sanitizeName(name);
        if (!StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            nameWithPrefixSuffix = this.modelNamePrefix + "_" + nameWithPrefixSuffix;
        }
        if (!StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            nameWithPrefixSuffix = nameWithPrefixSuffix + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(camelizedName = AbstractJavaCodegen.camelize(nameWithPrefixSuffix))) {
            String modelName = "Model" + camelizedName;
            LOGGER.warn(camelizedName + " (reserved word) cannot be used as model name. Renamed to " + modelName);
            return modelName;
        }
        if (camelizedName.matches("^\\d.*")) {
            String modelName = "Model" + camelizedName;
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + modelName);
            return modelName;
        }
        return camelizedName;
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            if (inner == null) {
                LOGGER.warn(ap.getName() + "(array property) does not have a proper inner type defined.Default to string");
                inner = new StringSchema().description("TODO default missing array inner type to string");
            }
            return this.getSchemaType(p) + "<" + this.getTypeDeclaration(inner) + ">";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            if (inner == null) {
                LOGGER.warn(p.getName() + "(map property) does not have a proper inner type defined. Default to string");
                inner = new StringSchema().description("TODO default missing array inner type to string");
            }
            return this.getSchemaType(p) + "<String, " + this.getTypeDeclaration(inner) + ">";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getAlias(String name) {
        if (this.typeAliases != null && this.typeAliases.containsKey(name)) {
            return (String)this.typeAliases.get(name);
        }
        return name;
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            Boolean java8;
            ArraySchema ap = (ArraySchema)p;
            String pattern = this.fullJavaUtil ? "new java.util.ArrayList<%s>()" : "new ArrayList<%s>()";
            if (ap.getItems() == null) {
                return null;
            }
            String typeDeclaration = this.getTypeDeclaration(ap.getItems());
            Object java8obj = this.additionalProperties.get(JAVA8_MODE);
            if (java8obj != null && (java8 = Boolean.valueOf(java8obj.toString())) != null && java8.booleanValue()) {
                typeDeclaration = "";
            }
            return String.format(Locale.ROOT, pattern, typeDeclaration);
        }
        if (ModelUtils.isMapSchema(p)) {
            Boolean java8;
            String pattern = this.fullJavaUtil ? "new java.util.HashMap<%s>()" : "new HashMap<%s>()";
            if (ModelUtils.getAdditionalProperties(p) == null) {
                return null;
            }
            String typeDeclaration = String.format(Locale.ROOT, "String, %s", this.getTypeDeclaration(ModelUtils.getAdditionalProperties(p)));
            Object java8obj = this.additionalProperties.get(JAVA8_MODE);
            if (java8obj != null && (java8 = Boolean.valueOf(java8obj.toString())) != null && java8.booleanValue()) {
                typeDeclaration = "";
            }
            return String.format(Locale.ROOT, pattern, typeDeclaration);
        }
        if (ModelUtils.isIntegerSchema(p)) {
            if (p.getDefault() != null) {
                if ("int64".equals(p.getFormat())) {
                    return p.getDefault().toString() + "l";
                }
                return p.getDefault().toString();
            }
            return "null";
        }
        if (ModelUtils.isNumberSchema(p)) {
            if (p.getDefault() != null) {
                if ("float".equals(p.getFormat())) {
                    return p.getDefault().toString() + "f";
                }
                return p.getDefault().toString() + "d";
            }
            return "null";
        }
        if (ModelUtils.isBooleanSchema(p)) {
            if (p.getDefault() != null) {
                return p.getDefault().toString();
            }
            return "null";
        }
        if (ModelUtils.isStringSchema(p)) {
            if (p.getDefault() != null) {
                String _default = (String)p.getDefault();
                if (p.getEnum() == null) {
                    return "\"" + this.escapeText(_default) + "\"";
                }
                return _default;
            }
            return "null";
        }
        return super.toDefaultValue(p);
    }

    @Override
    public void setParameterExampleValue(CodegenParameter p) {
        String example = p.defaultValue == null ? p.example : p.defaultValue;
        String type = p.baseType;
        if (type == null) {
            type = p.dataType;
        }
        if ("String".equals(type)) {
            if (example == null) {
                example = p.paramName + "_example";
            }
            example = "\"" + this.escapeText(example) + "\"";
        } else if ("Integer".equals(type) || "Short".equals(type)) {
            if (example == null) {
                example = "56";
            }
        } else if ("Long".equals(type)) {
            if (example == null) {
                example = "56";
            }
            example = example + "L";
        } else if ("Float".equals(type)) {
            if (example == null) {
                example = "3.4";
            }
            example = example + "F";
        } else if ("Double".equals(type)) {
            example = "3.4";
            example = example + "D";
        } else if ("Boolean".equals(type)) {
            if (example == null) {
                example = "true";
            }
        } else if ("File".equals(type)) {
            if (example == null) {
                example = "/path/to/file";
            }
            example = "new File(\"" + this.escapeText(example) + "\")";
        } else if ("Date".equals(type)) {
            example = "new Date()";
        } else if (!this.languageSpecificPrimitives.contains(type)) {
            example = "new " + type + "()";
        }
        if (example == null) {
            example = "null";
        } else if (Boolean.TRUE.equals(p.isListContainer)) {
            example = "Arrays.asList(" + example + ")";
        } else if (Boolean.TRUE.equals(p.isMapContainer)) {
            example = "new HashMap()";
        }
        p.example = example;
    }

    @Override
    public String toExampleValue(Schema p) {
        if (p.getExample() != null) {
            return this.escapeText(p.getExample().toString());
        }
        return super.toExampleValue(p);
    }

    @Override
    public String getSchemaType(Schema p) {
        String openAPIType = super.getSchemaType(p);
        if (this.typeMapping.containsKey(openAPIType)) {
            return (String)this.typeMapping.get(openAPIType);
        }
        if (null == openAPIType) {
            LOGGER.error("No Type defined for Schema " + p);
        }
        return this.toModelName(openAPIType);
    }

    @Override
    public String toOperationId(String operationId) {
        if (StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method/operation name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId = AbstractJavaCodegen.camelize(this.sanitizeName(operationId), true))) {
            String newOperationId = AbstractJavaCodegen.camelize("call_" + operationId, true);
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + newOperationId);
            return newOperationId;
        }
        if (operationId.matches("^\\d.*")) {
            LOGGER.warn(operationId + " (starting with a number) cannot be used as method sname. Renamed to " + AbstractJavaCodegen.camelize("call_" + operationId), (Object)true);
            operationId = AbstractJavaCodegen.camelize("call_" + operationId, true);
        }
        return operationId;
    }

    @Override
    public CodegenModel fromModel(String name, Schema model, Map<String, Schema> allDefinitions) {
        CodegenModel codegenModel = super.fromModel(name, model, allDefinitions);
        if (codegenModel.description != null) {
            codegenModel.imports.add("ApiModel");
        }
        if (codegenModel.discriminator != null && this.additionalProperties.containsKey("jackson")) {
            codegenModel.imports.add("JsonSubTypes");
            codegenModel.imports.add("JsonTypeInfo");
        }
        if (allDefinitions != null && codegenModel.parentSchema != null && codegenModel.hasEnums) {
            Schema parentModel = allDefinitions.get(codegenModel.parentSchema);
            CodegenModel parentCodegenModel = super.fromModel(codegenModel.parent, parentModel, allDefinitions);
            codegenModel = AbstractJavaCodegen.reconcileInlineEnums(codegenModel, parentCodegenModel);
        }
        return codegenModel;
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        if (this.serializeBigDecimalAsString && property.baseType.equals("BigDecimal")) {
            property.vendorExtensions.put("extraAnnotation", "@JsonSerialize(using = ToStringSerializer.class)");
            model.imports.add("ToStringSerializer");
            model.imports.add("JsonSerialize");
        }
        if (!this.fullJavaUtil) {
            if ("array".equals(property.containerType)) {
                model.imports.add("ArrayList");
            } else if ("map".equals(property.containerType)) {
                model.imports.add("HashMap");
            }
        }
        if (!BooleanUtils.toBoolean((Boolean)model.isEnum)) {
            model.imports.add("ApiModelProperty");
            model.imports.add("ApiModel");
        }
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        List recursiveImports = (List)objs.get("imports");
        if (recursiveImports == null) {
            return objs;
        }
        ListIterator listIterator = recursiveImports.listIterator();
        while (listIterator.hasNext()) {
            String _import = (String)((Map)listIterator.next()).get("import");
            if (!this.importMapping.containsKey(_import)) continue;
            HashMap newImportMap = new HashMap();
            newImportMap.put("import", this.importMapping.get(_import));
            listIterator.add(newImportMap);
        }
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        List imports = (List)objs.get("imports");
        Pattern pattern = Pattern.compile("java\\.util\\.(List|ArrayList|Map|HashMap)");
        Iterator itr = imports.iterator();
        while (itr.hasNext()) {
            String _import = (String)((Map)itr.next()).get("import");
            if (!pattern.matcher(_import).matches()) continue;
            itr.remove();
        }
        return objs;
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        if (openAPI == null || openAPI.getPaths() == null) {
            return;
        }
        for (String pathname : openAPI.getPaths().keySet()) {
            PathItem path = (PathItem)openAPI.getPaths().get((Object)pathname);
            if (path.readOperations() == null) continue;
            for (Operation operation : path.readOperations()) {
                if (this.hasBodyParameter(openAPI, operation) || this.hasFormParameter(openAPI, operation)) {
                    String defaultContentType = this.hasFormParameter(openAPI, operation) ? "application/x-www-form-urlencoded" : "application/json";
                    ArrayList<String> consumes = new ArrayList<String>(AbstractJavaCodegen.getConsumesInfo(openAPI, operation));
                    String contentType = consumes == null || consumes.isEmpty() ? defaultContentType : (String)consumes.get(0);
                    operation.addExtension("x-contentType", (Object)contentType);
                }
                String accepts = AbstractJavaCodegen.getAccept(openAPI, operation);
                operation.addExtension("x-accepts", (Object)accepts);
            }
        }
    }

    protected static String getAccept(OpenAPI openAPI, Operation operation) {
        String accepts = null;
        String defaultContentType = "application/json";
        ArrayList<String> produces = new ArrayList<String>(AbstractJavaCodegen.getProducesInfo(openAPI, operation));
        if (produces != null && !produces.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String produce : produces) {
                if (defaultContentType.equalsIgnoreCase(produce)) {
                    accepts = defaultContentType;
                    break;
                }
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(produce);
            }
            if (accepts == null) {
                accepts = sb.toString();
            }
        } else {
            accepts = defaultContentType;
        }
        return accepts;
    }

    @Override
    protected boolean needToImport(String type) {
        return super.needToImport(type) && type.indexOf(".") < 0;
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        return this.sanitizeName(AbstractJavaCodegen.camelize(property.name)) + "Enum";
    }

    @Override
    public String toEnumVarName(String value, String datatype) {
        if (value.length() == 0) {
            return "EMPTY";
        }
        if (this.getSymbolName(value) != null) {
            return this.getSymbolName(value).toUpperCase(Locale.ROOT);
        }
        if ("Integer".equals(datatype) || "Long".equals(datatype) || "Float".equals(datatype) || "Double".equals(datatype)) {
            String varName = "NUMBER_" + value;
            varName = varName.replaceAll("-", "MINUS_");
            varName = varName.replaceAll("\\+", "PLUS_");
            varName = varName.replaceAll("\\.", "_DOT_");
            return varName;
        }
        String var = value.replaceAll("\\W+", "_").toUpperCase(Locale.ROOT);
        if (var.matches("\\d.*")) {
            return "_" + var;
        }
        return var;
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("Integer".equals(datatype) || "Double".equals(datatype)) {
            return value;
        }
        if ("Long".equals(datatype)) {
            return value + "l";
        }
        if ("Float".equals(datatype)) {
            return value + "f";
        }
        return "\"" + this.escapeText(value) + "\"";
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, Map<String, Schema> definitions, OpenAPI openAPI) {
        CodegenOperation op = super.fromOperation(path, httpMethod, operation, definitions, openAPI);
        op.path = this.sanitizePath(op.path);
        return op;
    }

    private static CodegenModel reconcileInlineEnums(CodegenModel codegenModel, CodegenModel parentCodegenModel) {
        if (!parentCodegenModel.hasEnums) {
            return codegenModel;
        }
        List<CodegenProperty> parentModelCodegenProperties = parentCodegenModel.vars;
        List<CodegenProperty> codegenProperties = codegenModel.vars;
        boolean removedChildEnum = false;
        for (CodegenProperty parentModelCodegenPropery : parentModelCodegenProperties) {
            if (!parentModelCodegenPropery.isEnum) continue;
            Iterator<CodegenProperty> iterator = codegenProperties.iterator();
            while (iterator.hasNext()) {
                CodegenProperty codegenProperty = iterator.next();
                if (!codegenProperty.isEnum || !codegenProperty.equals(parentModelCodegenPropery)) continue;
                iterator.remove();
                removedChildEnum = true;
            }
        }
        if (removedChildEnum) {
            int count = 0;
            int numVars = codegenProperties.size();
            for (CodegenProperty codegenProperty : codegenProperties) {
                codegenProperty.hasMore = ++count < numVars;
            }
            codegenModel.vars = codegenProperties;
        }
        return codegenModel;
    }

    private static String sanitizePackageName(String packageName) {
        packageName = packageName.trim();
        if (Strings.isNullOrEmpty((String)(packageName = packageName.replaceAll("[^a-zA-Z0-9_\\.]", "_")))) {
            return "invalidPackageName";
        }
        return packageName;
    }

    public String getInvokerPackage() {
        return this.invokerPackage;
    }

    public void setInvokerPackage(String invokerPackage) {
        this.invokerPackage = invokerPackage;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setArtifactVersion(String artifactVersion) {
        this.artifactVersion = artifactVersion;
    }

    public void setArtifactUrl(String artifactUrl) {
        this.artifactUrl = artifactUrl;
    }

    public void setArtifactDescription(String artifactDescription) {
        this.artifactDescription = artifactDescription;
    }

    public void setScmConnection(String scmConnection) {
        this.scmConnection = scmConnection;
    }

    public void setScmDeveloperConnection(String scmDeveloperConnection) {
        this.scmDeveloperConnection = scmDeveloperConnection;
    }

    public void setScmUrl(String scmUrl) {
        this.scmUrl = scmUrl;
    }

    public void setDeveloperName(String developerName) {
        this.developerName = developerName;
    }

    public void setDeveloperEmail(String developerEmail) {
        this.developerEmail = developerEmail;
    }

    public void setDeveloperOrganization(String developerOrganization) {
        this.developerOrganization = developerOrganization;
    }

    public void setDeveloperOrganizationUrl(String developerOrganizationUrl) {
        this.developerOrganizationUrl = developerOrganizationUrl;
    }

    public void setLicenseName(String licenseName) {
        this.licenseName = licenseName;
    }

    public void setLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    public void setTestFolder(String testFolder) {
        this.testFolder = testFolder;
    }

    public void setLocalVariablePrefix(String localVariablePrefix) {
        this.localVariablePrefix = localVariablePrefix;
    }

    public void setSerializeBigDecimalAsString(boolean s) {
        this.serializeBigDecimalAsString = s;
    }

    public void setSerializableModel(Boolean serializableModel) {
        this.serializableModel = serializableModel;
    }

    private String sanitizePath(String p) {
        return p.replaceAll("\"", "%22");
    }

    public void setFullJavaUtil(boolean fullJavaUtil) {
        this.fullJavaUtil = fullJavaUtil;
    }

    public void setWithXml(boolean withXml) {
        this.withXml = withXml;
    }

    public void setDateLibrary(String library) {
        this.dateLibrary = library;
    }

    public void setJava8Mode(boolean enabled) {
        this.java8Mode = enabled;
    }

    public void setSupportAsync(boolean enabled) {
        this.supportAsync = enabled;
    }

    public void setDisableHtmlEscaping(boolean disabled) {
        this.disableHtmlEscaping = disabled;
    }

    public void setBooleanGetterPrefix(String booleanGetterPrefix) {
        this.booleanGetterPrefix = booleanGetterPrefix;
    }

    public void setUseNullForUnknownEnumValue(boolean useNullForUnknownEnumValue) {
        this.useNullForUnknownEnumValue = useNullForUnknownEnumValue;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    private String deriveInvokerPackageName(String input) {
        String[] parts = input.split(Pattern.quote("."));
        StringBuilder sb = new StringBuilder();
        String delim = "";
        for (String p : Arrays.copyOf(parts, parts.length - 1)) {
            sb.append(delim).append(p);
            delim = ".";
        }
        return sb.toString();
    }

    public void setSupportJava6(boolean value) {
        this.supportJava6 = value;
    }

    @Override
    public String toRegularExpression(String pattern) {
        return this.escapeText(pattern);
    }

    @Override
    public boolean convertPropertyToBoolean(String propertyKey) {
        boolean booleanValue = false;
        if (this.additionalProperties.containsKey(propertyKey)) {
            booleanValue = Boolean.valueOf(this.additionalProperties.get(propertyKey).toString());
        }
        return booleanValue;
    }

    @Override
    public void writePropertyBack(String propertyKey, boolean value) {
        this.additionalProperties.put(propertyKey, value);
    }

    @Override
    public String toBooleanGetter(String name) {
        return this.booleanGetterPrefix + this.getterAndSetterCapitalize(name);
    }

    @Override
    public String sanitizeTag(String tag) {
        if ((tag = AbstractJavaCodegen.camelize(AbstractJavaCodegen.underscore(this.sanitizeName(tag)))).matches("^\\d.*")) {
            tag = "Class" + tag;
        }
        return tag;
    }
}

