/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.examples;

import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.examples.XmlExampleGenerator;
import org.openapitools.codegen.utils.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExampleGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExampleGenerator.class);
    private static final String MIME_TYPE_JSON = "application/json";
    private static final String MIME_TYPE_XML = "application/xml";
    private static final String EXAMPLE = "example";
    private static final String CONTENT_TYPE = "contentType";
    private static final String OUTPUT = "output";
    private static final String NONE = "none";
    private static final String URL = "url";
    private static final String URI = "uri";
    protected Map<String, Schema> examples;
    private OpenAPI openAPI;
    private Random random;

    public ExampleGenerator(Map<String, Schema> examples, OpenAPI openAPI) {
        this.examples = examples;
        this.openAPI = openAPI;
        this.random = new Random("ExampleGenerator".hashCode());
    }

    public List<Map<String, String>> generateFromResponseSchema(Schema responseSchema, Set<String> producesInfo) {
        if (responseSchema.getExample() == null && StringUtils.isEmpty((CharSequence)responseSchema.get$ref()) && !ModelUtils.isArraySchema(responseSchema)) {
            return null;
        }
        if (responseSchema.getExample() != null && !(responseSchema.getExample() instanceof Map)) {
            LOGGER.warn("example value (array/primitive) not handled at the moment: " + responseSchema.getExample());
            return null;
        }
        if (ModelUtils.isArraySchema(responseSchema)) {
            ArraySchema as = (ArraySchema)responseSchema;
            if (as.getItems() != null && StringUtils.isEmpty((CharSequence)as.getItems().get$ref())) {
                return this.generate((Map<String, Object>)((Map)responseSchema.getExample()), new ArrayList<String>(producesInfo), as.getItems());
            }
            if (as.getItems() != null && !StringUtils.isEmpty((CharSequence)as.getItems().get$ref())) {
                return this.generate((Map<String, Object>)((Map)responseSchema.getExample()), new ArrayList<String>(producesInfo), ModelUtils.getSimpleRef(as.getItems().get$ref()));
            }
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)responseSchema.get$ref())) {
            return this.generate((Map<String, Object>)((Map)responseSchema.getExample()), new ArrayList<String>(producesInfo), responseSchema);
        }
        return this.generate((Map<String, Object>)((Map)responseSchema.getExample()), new ArrayList<String>(producesInfo), ModelUtils.getSimpleRef(responseSchema.get$ref()));
    }

    public List<Map<String, String>> generate(Map<String, Object> examples, List<String> mediaTypes, Schema property) {
        LOGGER.debug("debugging generate in ExampleGenerator");
        ArrayList<Map<String, String>> output = new ArrayList<Map<String, String>>();
        HashSet<String> processedModels = new HashSet<String>();
        if (examples == null) {
            if (mediaTypes == null) {
                mediaTypes = Collections.singletonList(MIME_TYPE_JSON);
            }
            for (String string : mediaTypes) {
                String example;
                HashMap<String, String> kv = new HashMap<String, String>();
                kv.put(CONTENT_TYPE, string);
                if (property != null && (string.startsWith(MIME_TYPE_JSON) || string.contains("*/*"))) {
                    example = Json.pretty((Object)this.resolvePropertyToExample("", string, property, processedModels));
                    if (example == null) continue;
                    kv.put(EXAMPLE, example);
                    output.add(kv);
                    continue;
                }
                if (property == null || !string.startsWith(MIME_TYPE_XML) || (example = new XmlExampleGenerator(this.examples).toXml(property)) == null) continue;
                kv.put(EXAMPLE, example);
                output.add(kv);
            }
        } else {
            for (Map.Entry entry : examples.entrySet()) {
                HashMap kv = new HashMap();
                kv.put(CONTENT_TYPE, entry.getKey());
                kv.put(EXAMPLE, Json.pretty(entry.getValue()));
                output.add(kv);
            }
        }
        if (output.size() == 0) {
            HashMap<String, String> kv = new HashMap<String, String>();
            kv.put(OUTPUT, NONE);
            output.add(kv);
        }
        return output;
    }

    public List<Map<String, String>> generate(Map<String, Object> examples, List<String> mediaTypes, String modelName) {
        ArrayList<Map<String, String>> output = new ArrayList<Map<String, String>>();
        HashSet<String> processedModels = new HashSet<String>();
        if (examples == null) {
            if (mediaTypes == null) {
                mediaTypes = Collections.singletonList(MIME_TYPE_JSON);
            }
            for (String string : mediaTypes) {
                String example;
                Schema schema;
                HashMap<String, String> kv = new HashMap<String, String>();
                kv.put(CONTENT_TYPE, string);
                if (modelName != null && (string.startsWith(MIME_TYPE_JSON) || string.contains("*/*"))) {
                    schema = this.examples.get(modelName);
                    if (schema == null || (example = Json.pretty((Object)this.resolveModelToExample(modelName, string, schema, processedModels))) == null) continue;
                    kv.put(EXAMPLE, example);
                    output.add(kv);
                    continue;
                }
                if (modelName == null || !string.startsWith(MIME_TYPE_XML) || (example = new XmlExampleGenerator(this.examples).toXml(schema = this.examples.get(modelName), 0, Collections.emptySet())) == null) continue;
                kv.put(EXAMPLE, example);
                output.add(kv);
            }
        } else {
            for (Map.Entry entry : examples.entrySet()) {
                HashMap kv = new HashMap();
                kv.put(CONTENT_TYPE, entry.getKey());
                kv.put(EXAMPLE, Json.pretty(entry.getValue()));
                output.add(kv);
            }
        }
        if (output.size() == 0) {
            HashMap<String, String> kv = new HashMap<String, String>();
            kv.put(OUTPUT, NONE);
            output.add(kv);
        }
        return output;
    }

    private Object resolvePropertyToExample(String propertyName, String mediaType, Schema property, Set<String> processedModels) {
        LOGGER.debug("Resolving example for property {}...", (Object)property);
        if (property.getExample() != null) {
            LOGGER.debug("Example set in openapi spec, returning example: '{}'", (Object)property.getExample().toString());
            return property.getExample();
        }
        if (ModelUtils.isBooleanSchema(property)) {
            Object defaultValue = property.getDefault();
            if (defaultValue != null) {
                return defaultValue;
            }
            return Boolean.TRUE;
        }
        if (ModelUtils.isArraySchema(property)) {
            Schema innerType = ((ArraySchema)property).getItems();
            if (innerType != null) {
                int arrayLength;
                int n = arrayLength = null == ((ArraySchema)property).getMaxItems() ? 2 : ((ArraySchema)property).getMaxItems();
                if (arrayLength == Integer.MAX_VALUE) {
                    LOGGER.warn("The max items allowed in property {} of {} equals Integer.MAX_VALUE. Treating this as if no max items has been specified.", (Object)property, (Object)arrayLength);
                    arrayLength = 2;
                } else if (arrayLength > 1024) {
                    LOGGER.warn("The max items allowed in property {} is too large ({} items), restricting it to 1024 items", (Object)property, (Object)arrayLength);
                    arrayLength = 1024;
                }
                Object[] objectProperties = new Object[arrayLength];
                Object objProperty = this.resolvePropertyToExample(propertyName, mediaType, innerType, processedModels);
                for (int i = 0; i < arrayLength; ++i) {
                    objectProperties[i] = objProperty;
                }
                return objectProperties;
            }
        } else {
            if (ModelUtils.isDateSchema(property)) {
                return "2000-01-23";
            }
            if (ModelUtils.isDateTimeSchema(property)) {
                return "2000-01-23T04:56:07.000+00:00";
            }
            if (ModelUtils.isNumberSchema(property)) {
                Double max;
                Double min = property.getMinimum() == null ? null : Double.valueOf(property.getMinimum().doubleValue());
                Double d = max = property.getMaximum() == null ? null : Double.valueOf(property.getMaximum().doubleValue());
                if (ModelUtils.isFloatSchema(property)) {
                    return Float.valueOf((float)this.randomNumber(min, max));
                }
                if (ModelUtils.isDoubleSchema(property)) {
                    return new BigDecimal(this.randomNumber(min, max));
                }
                return this.randomNumber(min, max);
            }
            if (ModelUtils.isFileSchema(property)) {
                return "";
            }
            if (ModelUtils.isIntegerSchema(property)) {
                Double max;
                Double min = property.getMinimum() == null ? null : Double.valueOf(property.getMinimum().doubleValue());
                Double d = max = property.getMaximum() == null ? null : Double.valueOf(property.getMaximum().doubleValue());
                if (ModelUtils.isLongSchema(property)) {
                    return (long)this.randomNumber(min, max);
                }
                return (int)this.randomNumber(min, max);
            }
            if (ModelUtils.isMapSchema(property)) {
                HashMap<String, Object> mp = new HashMap<String, Object>();
                if (property.getName() != null) {
                    mp.put(property.getName(), this.resolvePropertyToExample(propertyName, mediaType, (Schema)property.getAdditionalProperties(), processedModels));
                } else {
                    mp.put("key", this.resolvePropertyToExample(propertyName, mediaType, (Schema)property.getAdditionalProperties(), processedModels));
                }
                return mp;
            }
            if (ModelUtils.isUUIDSchema(property)) {
                return "046b6c7f-0b8a-43b9-b35d-6489e6daee91";
            }
            if (ModelUtils.isStringSchema(property)) {
                LOGGER.debug("String property");
                String defaultValue = (String)property.getDefault();
                if (defaultValue != null && !defaultValue.isEmpty()) {
                    LOGGER.debug("Default value found: '{}'", (Object)defaultValue);
                    return defaultValue;
                }
                List enumValues = property.getEnum();
                if (enumValues != null && !enumValues.isEmpty()) {
                    LOGGER.debug("Enum value found: '{}'", enumValues.get(0));
                    return enumValues.get(0);
                }
                String format = property.getFormat();
                if (format != null && (URI.equals(format) || URL.equals(format))) {
                    LOGGER.debug("URI or URL format, without default or enum, generating random one.");
                    return "http://example.com/aeiou";
                }
                LOGGER.debug("No values found, using property name " + propertyName + " as example");
                return propertyName;
            }
            if (!StringUtils.isEmpty((CharSequence)property.get$ref())) {
                String simpleName = ModelUtils.getSimpleRef(property.get$ref());
                Schema schema = ModelUtils.getSchema(this.openAPI, simpleName);
                if (schema == null) {
                    return "{}";
                }
                return this.resolveModelToExample(simpleName, mediaType, schema, processedModels);
            }
            if (ModelUtils.isObjectSchema(property)) {
                return "{}";
            }
        }
        return "";
    }

    private double randomNumber(Double min, Double max) {
        if (min != null && max != null) {
            double range = max - min;
            return this.random.nextDouble() * range + min;
        }
        if (min != null) {
            return this.random.nextDouble() + min;
        }
        if (max != null) {
            return this.random.nextDouble() * max;
        }
        return this.random.nextDouble() * 10.0;
    }

    private Object resolveModelToExample(String name, String mediaType, Schema schema, Set<String> processedModels) {
        if (processedModels.contains(name)) {
            return schema.getExample();
        }
        processedModels.add(name);
        HashMap<String, Object> values = new HashMap<String, Object>();
        LOGGER.debug("Resolving model '{}' to example", (Object)name);
        if (schema.getExample() != null) {
            LOGGER.debug("Using example from spec: {}", schema.getExample());
            return schema.getExample();
        }
        if (schema.getProperties() != null) {
            LOGGER.debug("Creating example from model values");
            for (Object propertyName : schema.getProperties().keySet()) {
                Schema property = (Schema)schema.getProperties().get(propertyName.toString());
                values.put(propertyName.toString(), this.resolvePropertyToExample(propertyName.toString(), mediaType, property, processedModels));
            }
            schema.setExample(values);
            return schema.getExample();
        }
        return null;
    }
}

