/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.CaseFormat;
import com.samskivert.mustache.Mustache;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.CookieParameter;
import io.swagger.v3.oas.models.parameters.HeaderParameter;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.PathParameter;
import io.swagger.v3.oas.models.parameters.QueryParameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.OAuthFlow;
import io.swagger.v3.oas.models.security.OAuthFlows;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenModelFactory;
import org.openapitools.codegen.CodegenModelType;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenSecurity;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.examples.ExampleGenerator;
import org.openapitools.codegen.serializer.SerializerUtils;
import org.openapitools.codegen.utils.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCodegen.class);
    protected String inputSpec;
    protected String outputFolder = "";
    protected Set<String> defaultIncludes = new HashSet<String>();
    protected Map<String, String> typeMapping = new HashMap<String, String>();
    protected Map<String, String> instantiationTypes = new HashMap<String, String>();
    protected Set<String> reservedWords = new HashSet<String>();
    protected Set<String> languageSpecificPrimitives = new HashSet<String>();
    protected Map<String, String> importMapping = new HashMap<String, String>();
    protected String modelPackage = "";
    protected String apiPackage = "";
    protected String fileSuffix;
    protected String modelNamePrefix = "";
    protected String modelNameSuffix = "";
    protected String testPackage = "";
    protected Map<String, String> apiTemplateFiles = new HashMap<String, String>();
    protected Map<String, String> modelTemplateFiles = new HashMap<String, String>();
    protected Map<String, String> apiTestTemplateFiles = new HashMap<String, String>();
    protected Map<String, String> modelTestTemplateFiles = new HashMap<String, String>();
    protected Map<String, String> apiDocTemplateFiles = new HashMap<String, String>();
    protected Map<String, String> modelDocTemplateFiles = new HashMap<String, String>();
    protected Map<String, String> reservedWordsMappings = new HashMap<String, String>();
    protected String templateDir;
    protected String embeddedTemplateDir;
    protected String commonTemplateDir = "_common";
    protected Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected Map<String, Object> vendorExtensions = new HashMap<String, Object>();
    protected List<SupportingFile> supportingFiles = new ArrayList<SupportingFile>();
    protected List<CliOption> cliOptions = new ArrayList<CliOption>();
    protected boolean skipOverwrite;
    protected boolean removeOperationIdPrefix;
    protected boolean supportsInheritance;
    protected boolean supportsMixins;
    protected Map<String, String> supportedLibraries = new LinkedHashMap<String, String>();
    protected String library;
    protected Boolean sortParamsByRequiredFlag = true;
    protected Boolean ensureUniqueParams = true;
    protected Boolean allowUnicodeIdentifiers = false;
    protected String gitUserId;
    protected String gitRepoId;
    protected String releaseNote;
    protected String httpUserAgent;
    protected Boolean hideGenerationTimestamp = true;
    protected Map<String, String> specialCharReplacements = new HashMap<String, String>();
    protected Map<String, String> typeAliases = null;
    protected Boolean prependFormOrBodyParameters = false;
    protected String docExtension;
    protected String ignoreFilePathOverride;

    @Override
    public List<CliOption> cliOptions() {
        return this.cliOptions;
    }

    @Override
    public void processOpts() {
        if (this.additionalProperties.containsKey("templateDir")) {
            this.setTemplateDir((String)this.additionalProperties.get("templateDir"));
        }
        if (this.additionalProperties.containsKey("modelPackage")) {
            this.setModelPackage((String)this.additionalProperties.get("modelPackage"));
        }
        if (this.additionalProperties.containsKey("apiPackage")) {
            this.setApiPackage((String)this.additionalProperties.get("apiPackage"));
        }
        if (this.additionalProperties.containsKey("hideGenerationTimestamp")) {
            this.setHideGenerationTimestamp(this.convertPropertyToBooleanAndWriteBack("hideGenerationTimestamp"));
        } else {
            this.additionalProperties.put("hideGenerationTimestamp", this.hideGenerationTimestamp);
        }
        if (this.additionalProperties.containsKey("sortParamsByRequiredFlag")) {
            this.setSortParamsByRequiredFlag(Boolean.valueOf(this.additionalProperties.get("sortParamsByRequiredFlag").toString()));
        }
        if (this.additionalProperties.containsKey("prependFormOrBodyParameters")) {
            this.setPrependFormOrBodyParameters(Boolean.valueOf(this.additionalProperties.get("prependFormOrBodyParameters").toString()));
        }
        if (this.additionalProperties.containsKey("ensureUniqueParams")) {
            this.setEnsureUniqueParams(Boolean.valueOf(this.additionalProperties.get("ensureUniqueParams").toString()));
        }
        if (this.additionalProperties.containsKey("allowUnicodeIdentifiers")) {
            this.setAllowUnicodeIdentifiers(Boolean.valueOf(this.additionalProperties.get("allowUnicodeIdentifiers").toString()));
        }
        if (this.additionalProperties.containsKey("modelNamePrefix")) {
            this.setModelNamePrefix((String)this.additionalProperties.get("modelNamePrefix"));
        }
        if (this.additionalProperties.containsKey("modelNameSuffix")) {
            this.setModelNameSuffix((String)this.additionalProperties.get("modelNameSuffix"));
        }
        if (this.additionalProperties.containsKey("removeOperationIdPrefix")) {
            this.setRemoveOperationIdPrefix(Boolean.valueOf(this.additionalProperties.get("removeOperationIdPrefix").toString()));
        }
        if (this.additionalProperties.containsKey("docExtension")) {
            this.setDocExtension(String.valueOf(this.additionalProperties.get("docExtension").toString()));
        }
    }

    @Override
    public Map<String, Object> postProcessAllModels(Map<String, Object> objs) {
        if (this.supportsInheritance) {
            HashMap<Object, CodegenModel> allModels = new HashMap<Object, CodegenModel>();
            for (Map.Entry<String, Object> entry : objs.entrySet()) {
                String modelName = this.toModelName(entry.getKey());
                Map inner = (Map)entry.getValue();
                List models = (List)inner.get("models");
                for (Map mo : models) {
                    CodegenModel cm = (CodegenModel)mo.get("model");
                    allModels.put(modelName, cm);
                }
            }
            for (CodegenModel cm : allModels.values()) {
                if (cm.getParent() != null) {
                    cm.setParentModel((CodegenModel)allModels.get(cm.getParent()));
                }
                if (cm.getInterfaces() == null || cm.getInterfaces().isEmpty()) continue;
                cm.setInterfaceModels(new ArrayList<CodegenModel>(cm.getInterfaces().size()));
                for (String intf : cm.getInterfaces()) {
                    CodegenModel intfModel = (CodegenModel)allModels.get(intf);
                    if (intfModel == null) continue;
                    cm.getInterfaceModels().add(intfModel);
                }
            }
            for (String name : allModels.keySet()) {
                CodegenModel cm = (CodegenModel)allModels.get(name);
                CodegenModel parent = (CodegenModel)allModels.get(cm.getParent());
                while (parent != null) {
                    if (parent.getChildren() == null) {
                        parent.setChildren(new ArrayList<CodegenModel>());
                    }
                    parent.getChildren().add(cm);
                    if (parent.getDiscriminator() == null) {
                        parent = (CodegenModel)allModels.get(parent.getParent());
                        continue;
                    }
                    parent = null;
                }
            }
        }
        return objs;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        return objs;
    }

    public Map<String, Object> postProcessModelsEnum(Map<String, Object> objs) {
        List models = (List)objs.get("models");
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            if (Boolean.TRUE.equals(cm.isEnum) && cm.allowableValues != null) {
                Map<String, Object> allowableValues = cm.allowableValues;
                List values = (List)allowableValues.get("values");
                ArrayList enumVars = new ArrayList();
                String commonPrefix = this.findCommonPrefixOfVars(values);
                int truncateIdx = commonPrefix.length();
                for (Object value : values) {
                    String enumName;
                    HashMap<String, Object> enumVar = new HashMap<String, Object>();
                    if (truncateIdx == 0) {
                        enumName = value.toString();
                    } else {
                        enumName = value.toString().substring(truncateIdx);
                        if ("".equals(enumName)) {
                            enumName = value.toString();
                        }
                    }
                    enumVar.put("name", this.toEnumVarName(enumName, cm.dataType));
                    enumVar.put("value", this.toEnumValue(value.toString(), cm.dataType));
                    enumVar.put("isString", this.isDataTypeString(cm.dataType));
                    enumVars.add(enumVar);
                }
                cm.allowableValues.put("enumVars", enumVars);
            }
            for (CodegenProperty var : cm.vars) {
                this.updateCodegenPropertyEnum(var);
            }
        }
        return objs;
    }

    public String findCommonPrefixOfVars(List<Object> vars) {
        if (vars.size() > 1) {
            try {
                String[] listStr = vars.toArray(new String[vars.size()]);
                String prefix = StringUtils.getCommonPrefix((String[])listStr);
                return prefix.replaceAll("[a-zA-Z0-9]+\\z", "");
            }
            catch (ArrayStoreException arrayStoreException) {
                // empty catch block
            }
        }
        return "";
    }

    public String toEnumDefaultValue(String value, String datatype) {
        return datatype + "." + value;
    }

    public String toEnumValue(String value, String datatype) {
        if ("number".equalsIgnoreCase(datatype)) {
            return value;
        }
        return "\"" + this.escapeText(value) + "\"";
    }

    public String toEnumVarName(String value, String datatype) {
        if (value.length() == 0) {
            return "EMPTY";
        }
        String var = value.replaceAll("\\W+", "_").toUpperCase();
        if (var.matches("\\d.*")) {
            return "_" + var;
        }
        return var;
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        return objs;
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        return objs;
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        return objs;
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
    }

    @Override
    public void processOpenAPI(OpenAPI openAPI) {
    }

    @Override
    public Mustache.Compiler processCompiler(Mustache.Compiler compiler) {
        return compiler;
    }

    @Override
    public String escapeText(String input) {
        if (input == null) {
            return input;
        }
        return this.escapeUnsafeCharacters(StringEscapeUtils.unescapeJava((String)StringEscapeUtils.escapeJava((String)input).replace("\\/", "/")).replaceAll("[\\t\\n\\r]", " ").replace("\\", "\\\\").replace("\"", "\\\""));
    }

    @Override
    public String escapeTextWhileAllowingNewLines(String input) {
        if (input == null) {
            return input;
        }
        return this.escapeUnsafeCharacters(StringEscapeUtils.unescapeJava((String)StringEscapeUtils.escapeJava((String)input).replace("\\/", "/")).replaceAll("[\\t]", " ").replace("\\", "\\\\").replace("\"", "\\\""));
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        LOGGER.warn("escapeUnsafeCharacters should be overridden in the code generator with proper logic to escape unsafe characters");
        return input;
    }

    @Override
    public String escapeQuotationMark(String input) {
        LOGGER.warn("escapeQuotationMark should be overridden in the code generator with proper logic to escape single/double quote");
        return input.replace("\"", "\\\"");
    }

    @Override
    public Set<String> defaultIncludes() {
        return this.defaultIncludes;
    }

    @Override
    public Map<String, String> typeMapping() {
        return this.typeMapping;
    }

    @Override
    public Map<String, String> instantiationTypes() {
        return this.instantiationTypes;
    }

    @Override
    public Set<String> reservedWords() {
        return this.reservedWords;
    }

    @Override
    public Set<String> languageSpecificPrimitives() {
        return this.languageSpecificPrimitives;
    }

    @Override
    public Map<String, String> importMapping() {
        return this.importMapping;
    }

    @Override
    public String testPackage() {
        return this.testPackage;
    }

    @Override
    public String modelPackage() {
        return this.modelPackage;
    }

    @Override
    public String apiPackage() {
        return this.apiPackage;
    }

    @Override
    public String fileSuffix() {
        return this.fileSuffix;
    }

    @Override
    public String templateDir() {
        return this.templateDir;
    }

    @Override
    public String embeddedTemplateDir() {
        if (this.embeddedTemplateDir != null) {
            return this.embeddedTemplateDir;
        }
        return this.templateDir;
    }

    @Override
    public String getCommonTemplateDir() {
        return this.commonTemplateDir;
    }

    public void setCommonTemplateDir(String commonTemplateDir) {
        this.commonTemplateDir = commonTemplateDir;
    }

    @Override
    public Map<String, String> apiDocTemplateFiles() {
        return this.apiDocTemplateFiles;
    }

    @Override
    public Map<String, String> modelDocTemplateFiles() {
        return this.modelDocTemplateFiles;
    }

    @Override
    public Map<String, String> reservedWordsMappings() {
        return this.reservedWordsMappings;
    }

    @Override
    public Map<String, String> apiTestTemplateFiles() {
        return this.apiTestTemplateFiles;
    }

    @Override
    public Map<String, String> modelTestTemplateFiles() {
        return this.modelTestTemplateFiles;
    }

    @Override
    public Map<String, String> apiTemplateFiles() {
        return this.apiTemplateFiles;
    }

    @Override
    public Map<String, String> modelTemplateFiles() {
        return this.modelTemplateFiles;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + "/" + this.apiPackage().replace('.', '/');
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + "/" + this.modelPackage().replace('.', '/');
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + "/" + this.testPackage().replace('.', '/');
    }

    @Override
    public String modelTestFileFolder() {
        return this.outputFolder + "/" + this.testPackage().replace('.', '/');
    }

    @Override
    public String apiDocFileFolder() {
        return this.outputFolder;
    }

    @Override
    public String modelDocFileFolder() {
        return this.outputFolder;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public Map<String, Object> vendorExtensions() {
        return this.vendorExtensions;
    }

    @Override
    public List<SupportingFile> supportingFiles() {
        return this.supportingFiles;
    }

    @Override
    public String outputFolder() {
        return this.outputFolder;
    }

    @Override
    public void setOutputDir(String dir) {
        this.outputFolder = dir;
    }

    @Override
    public String getOutputDir() {
        return this.outputFolder();
    }

    @Override
    public String getInputSpec() {
        return this.inputSpec;
    }

    @Override
    public void setInputSpec(String inputSpec) {
        this.inputSpec = inputSpec;
    }

    public void setTemplateDir(String templateDir) {
        this.templateDir = templateDir;
    }

    public void setModelPackage(String modelPackage) {
        this.modelPackage = modelPackage;
    }

    public void setModelNamePrefix(String modelNamePrefix) {
        this.modelNamePrefix = modelNamePrefix;
    }

    public void setModelNameSuffix(String modelNameSuffix) {
        this.modelNameSuffix = modelNameSuffix;
    }

    public void setApiPackage(String apiPackage) {
        this.apiPackage = apiPackage;
    }

    public void setSortParamsByRequiredFlag(Boolean sortParamsByRequiredFlag) {
        this.sortParamsByRequiredFlag = sortParamsByRequiredFlag;
    }

    public void setPrependFormOrBodyParameters(Boolean prependFormOrBodyParameters) {
        this.prependFormOrBodyParameters = prependFormOrBodyParameters;
    }

    public void setEnsureUniqueParams(Boolean ensureUniqueParams) {
        this.ensureUniqueParams = ensureUniqueParams;
    }

    public void setAllowUnicodeIdentifiers(Boolean allowUnicodeIdentifiers) {
        this.allowUnicodeIdentifiers = allowUnicodeIdentifiers;
    }

    public String toRegularExpression(String pattern) {
        return this.addRegularExpressionDelimiter(this.escapeText(pattern));
    }

    @Override
    public String toApiFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String toApiTestFilename(String name) {
        return this.toApiName(name) + "Test";
    }

    @Override
    public String toApiVarName(String name) {
        return this.snakeCase(name);
    }

    @Override
    public String toModelFilename(String name) {
        return this.initialCaps(name);
    }

    @Override
    public String toModelTestFilename(String name) {
        return this.initialCaps(name) + "Test";
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.initialCaps(name);
    }

    public String toOperationId(String operationId) {
        if (StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        return operationId;
    }

    public String toVarName(String name) {
        if (this.reservedWords.contains(name)) {
            return this.escapeReservedWord(name);
        }
        if (name.chars().anyMatch(character -> this.specialCharReplacements.keySet().contains("" + (char)character))) {
            return this.escapeSpecialCharacters(name, null, null);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        if (this.reservedWords.contains(name = this.removeNonNameElementToCamelCase(name))) {
            return this.escapeReservedWord(name);
        }
        if (name.chars().anyMatch(character -> this.specialCharReplacements.keySet().contains("" + (char)character))) {
            return this.escapeSpecialCharacters(name, null, null);
        }
        return name;
    }

    public String toArrayModelParamName(String name) {
        return this.toParamName(name);
    }

    public String toEnumName(CodegenProperty property) {
        return StringUtils.capitalize((String)property.name) + "Enum";
    }

    @Override
    public String escapeReservedWord(String name) {
        throw new RuntimeException("reserved word " + name + " not allowed");
    }

    public String escapeSpecialCharacters(String name, List<String> charactersToAllow, String appdendixToReplacement) {
        String result = name.chars().mapToObj(c -> {
            String character = "" + (char)c;
            if (charactersToAllow != null && charactersToAllow.contains(character)) {
                return character;
            }
            if (this.specialCharReplacements.containsKey(character)) {
                return this.specialCharReplacements.get(character) + (appdendixToReplacement != null ? appdendixToReplacement : "");
            }
            return character;
        }).reduce((c1, c2) -> "" + c1 + c2).orElse(null);
        if (result != null) {
            return result;
        }
        throw new RuntimeException("Word '" + name + "' could not be escaped.");
    }

    @Override
    public String toModelImport(String name) {
        if ("".equals(this.modelPackage())) {
            return name;
        }
        return this.modelPackage() + "." + name;
    }

    @Override
    public String toApiImport(String name) {
        return this.apiPackage() + "." + name;
    }

    public DefaultCodegen() {
        this.defaultIncludes = new HashSet<String>(Arrays.asList("double", "int", "long", "short", "char", "float", "String", "boolean", "Boolean", "Double", "Void", "Integer", "Long", "Float"));
        this.typeMapping = new HashMap<String, String>();
        this.typeMapping.put("array", "List");
        this.typeMapping.put("map", "Map");
        this.typeMapping.put("List", "List");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("int", "Integer");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("number", "BigDecimal");
        this.typeMapping.put("DateTime", "Date");
        this.typeMapping.put("long", "Long");
        this.typeMapping.put("short", "Short");
        this.typeMapping.put("char", "String");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("integer", "Integer");
        this.typeMapping.put("ByteArray", "byte[]");
        this.typeMapping.put("binary", "File");
        this.typeMapping.put("file", "File");
        this.typeMapping.put("UUID", "UUID");
        this.instantiationTypes = new HashMap<String, String>();
        this.reservedWords = new HashSet<String>();
        this.importMapping = new HashMap<String, String>();
        this.importMapping.put("BigDecimal", "java.math.BigDecimal");
        this.importMapping.put("UUID", "java.util.UUID");
        this.importMapping.put("File", "java.io.File");
        this.importMapping.put("Date", "java.util.Date");
        this.importMapping.put("Timestamp", "java.sql.Timestamp");
        this.importMapping.put("Map", "java.util.Map");
        this.importMapping.put("HashMap", "java.util.HashMap");
        this.importMapping.put("Array", "java.util.List");
        this.importMapping.put("ArrayList", "java.util.ArrayList");
        this.importMapping.put("List", "java.util.*");
        this.importMapping.put("Set", "java.util.*");
        this.importMapping.put("DateTime", "org.joda.time.*");
        this.importMapping.put("LocalDateTime", "org.joda.time.*");
        this.importMapping.put("LocalDate", "org.joda.time.*");
        this.importMapping.put("LocalTime", "org.joda.time.*");
        this.cliOptions.add(CliOption.newBoolean("sortParamsByRequiredFlag", "Sort method arguments to place required parameters before optional parameters.").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(CliOption.newBoolean("ensureUniqueParams", "Whether to ensure parameter names are unique in an operation (rename parameters that are not).").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(CliOption.newBoolean("allowUnicodeIdentifiers", "boolean, toggles whether unicode identifiers are allowed in names or not, default is false").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(CliOption.newBoolean("prependFormOrBodyParameters", "Add form or body parameters to the beginning of the parameter list.").defaultValue(Boolean.FALSE.toString()));
        this.initalizeSpecialCharacterMapping();
    }

    protected void initalizeSpecialCharacterMapping() {
        this.specialCharReplacements.put("$", "Dollar");
        this.specialCharReplacements.put("^", "Caret");
        this.specialCharReplacements.put("|", "Pipe");
        this.specialCharReplacements.put("=", "Equal");
        this.specialCharReplacements.put("*", "Star");
        this.specialCharReplacements.put("-", "Minus");
        this.specialCharReplacements.put("&", "Ampersand");
        this.specialCharReplacements.put("%", "Percent");
        this.specialCharReplacements.put("#", "Hash");
        this.specialCharReplacements.put("@", "At");
        this.specialCharReplacements.put("!", "Exclamation");
        this.specialCharReplacements.put("+", "Plus");
        this.specialCharReplacements.put(":", "Colon");
        this.specialCharReplacements.put(">", "Greater_Than");
        this.specialCharReplacements.put("<", "Less_Than");
        this.specialCharReplacements.put(".", "Period");
        this.specialCharReplacements.put("_", "Underscore");
        this.specialCharReplacements.put("?", "Question_Mark");
        this.specialCharReplacements.put(",", "Comma");
        this.specialCharReplacements.put("'", "Quote");
        this.specialCharReplacements.put("\"", "Double_Quote");
        this.specialCharReplacements.put("/", "Slash");
        this.specialCharReplacements.put("\\", "Back_Slash");
        this.specialCharReplacements.put("(", "Left_Parenthesis");
        this.specialCharReplacements.put(")", "Right_Parenthesis");
        this.specialCharReplacements.put("{", "Left_Curly_Bracket");
        this.specialCharReplacements.put("}", "Right_Curly_Bracket");
        this.specialCharReplacements.put("[", "Left_Square_Bracket");
        this.specialCharReplacements.put("]", "Right_Square_Bracket");
        this.specialCharReplacements.put("~", "Tilde");
        this.specialCharReplacements.put("`", "Backtick");
        this.specialCharReplacements.put("<=", "Less_Than_Or_Equal_To");
        this.specialCharReplacements.put(">=", "Greater_Than_Or_Equal_To");
        this.specialCharReplacements.put("!=", "Not_Equal");
    }

    protected String getSymbolName(String input) {
        return this.specialCharReplacements.get(input);
    }

    @Override
    public String generateExamplePath(String path, Operation operation) {
        StringBuilder sb = new StringBuilder();
        sb.append(path);
        if (operation.getParameters() != null) {
            int count = 0;
            for (Parameter param : operation.getParameters()) {
                if (!(param instanceof QueryParameter)) continue;
                StringBuilder paramPart = new StringBuilder();
                QueryParameter qp = (QueryParameter)param;
                if (count == 0) {
                    paramPart.append("?");
                } else {
                    paramPart.append(",");
                }
                ++count;
                if (!param.getRequired().booleanValue()) {
                    paramPart.append("[");
                }
                paramPart.append(param.getName()).append("=");
                paramPart.append("{");
                if (qp.getStyle() != null) {
                    paramPart.append(param.getName()).append("1");
                    if (Parameter.StyleEnum.FORM.equals((Object)qp.getStyle())) {
                        if (qp.getExplode() != null && qp.getExplode().booleanValue()) {
                            paramPart.append(",");
                        } else {
                            paramPart.append("&").append(param.getName()).append("=");
                            paramPart.append(param.getName()).append("2");
                        }
                    } else if (Parameter.StyleEnum.PIPEDELIMITED.equals((Object)qp.getStyle())) {
                        paramPart.append("|");
                    } else if (Parameter.StyleEnum.SPACEDELIMITED.equals((Object)qp.getStyle())) {
                        paramPart.append("%20");
                    } else {
                        LOGGER.warn("query parameter '" + param.getName() + "style not support: " + qp.getStyle());
                    }
                } else {
                    paramPart.append(param.getName());
                }
                paramPart.append("}");
                if (!param.getRequired().booleanValue()) {
                    paramPart.append("]");
                }
                sb.append(paramPart.toString());
            }
        }
        return sb.toString();
    }

    public String toInstantiationType(Schema schema) {
        if (ModelUtils.isMapSchema(schema)) {
            Schema additionalProperties = (Schema)schema.getAdditionalProperties();
            String type = additionalProperties.getType();
            if (null == type) {
                LOGGER.error("No Type defined for Additional Property " + additionalProperties + "\n\tIn Property: " + schema);
            }
            String inner = this.getSchemaType(additionalProperties);
            return this.instantiationTypes.get("map") + "<String, " + inner + ">";
        }
        if (ModelUtils.isArraySchema(schema)) {
            ArraySchema arraySchema = (ArraySchema)schema;
            String inner = this.getSchemaType(arraySchema.getItems());
            return this.instantiationTypes.get("array") + "<" + inner + ">";
        }
        return null;
    }

    public void setParameterExampleValue(CodegenParameter codegenParameter) {
        if (codegenParameter.vendorExtensions != null && codegenParameter.vendorExtensions.containsKey("x-example")) {
            codegenParameter.example = Json.pretty((Object)codegenParameter.vendorExtensions.get("x-example"));
        } else if (Boolean.TRUE.equals(codegenParameter.isBoolean)) {
            codegenParameter.example = "true";
        } else if (Boolean.TRUE.equals(codegenParameter.isLong)) {
            codegenParameter.example = "789";
        } else if (Boolean.TRUE.equals(codegenParameter.isInteger)) {
            codegenParameter.example = "56";
        } else if (Boolean.TRUE.equals(codegenParameter.isFloat)) {
            codegenParameter.example = "3.4";
        } else if (Boolean.TRUE.equals(codegenParameter.isDouble)) {
            codegenParameter.example = "1.2";
        } else if (Boolean.TRUE.equals(codegenParameter.isNumber)) {
            codegenParameter.example = "8.14";
        } else if (Boolean.TRUE.equals(codegenParameter.isBinary)) {
            codegenParameter.example = "BINARY_DATA_HERE";
        } else if (Boolean.TRUE.equals(codegenParameter.isByteArray)) {
            codegenParameter.example = "BYTE_ARRAY_DATA_HERE";
        } else if (Boolean.TRUE.equals(codegenParameter.isFile)) {
            codegenParameter.example = "/path/to/file.txt";
        } else if (Boolean.TRUE.equals(codegenParameter.isDate)) {
            codegenParameter.example = "2013-10-20";
        } else if (Boolean.TRUE.equals(codegenParameter.isDateTime)) {
            codegenParameter.example = "2013-10-20T19:20:30+01:00";
        } else if (Boolean.TRUE.equals(codegenParameter.isUuid)) {
            codegenParameter.example = "38400000-8cf0-11bd-b23e-10b96e4ef00d";
        } else if (Boolean.TRUE.equals(codegenParameter.isString)) {
            codegenParameter.example = codegenParameter.paramName + "_example";
        }
    }

    public void setParameterExampleValue(CodegenParameter codegenParameter, Parameter parameter) {
        Example example;
        if (parameter.getExample() != null) {
            codegenParameter.example = parameter.getExample().toString();
            return;
        }
        if (parameter.getExamples() != null && !parameter.getExamples().isEmpty() && (example = (Example)parameter.getExamples().values().iterator().next()).getValue() != null) {
            codegenParameter.example = example.getValue().toString();
            return;
        }
        Schema schema = parameter.getSchema();
        if (schema != null && schema.getExample() != null) {
            codegenParameter.example = schema.getExample().toString();
            return;
        }
        this.setParameterExampleValue(codegenParameter);
    }

    public void setParameterExampleValue(CodegenParameter codegenParameter, RequestBody requestBody) {
        Example example;
        MediaType mediaType;
        Content content = requestBody.getContent();
        if (content.size() > 1) {
            LOGGER.warn("Multiple MediaTypes found, using only the first one");
        }
        if ((mediaType = (MediaType)content.values().iterator().next()).getExample() != null) {
            codegenParameter.example = mediaType.getExample().toString();
            return;
        }
        if (mediaType.getExamples() != null && !mediaType.getExamples().isEmpty() && (example = (Example)mediaType.getExamples().values().iterator().next()).getValue() != null) {
            codegenParameter.example = example.getValue().toString();
            return;
        }
        this.setParameterExampleValue(codegenParameter);
    }

    public String toExampleValue(Schema schema) {
        if (schema.getExample() != null) {
            return schema.getExample().toString();
        }
        if (ModelUtils.isBooleanSchema(schema)) {
            return "null";
        }
        if (ModelUtils.isDateSchema(schema)) {
            return "null";
        }
        if (ModelUtils.isDateTimeSchema(schema)) {
            return "null";
        }
        if (ModelUtils.isNumberSchema(schema)) {
            return "null";
        }
        if (ModelUtils.isIntegerSchema(schema)) {
            return "null";
        }
        if (ModelUtils.isStringSchema(schema)) {
            return "null";
        }
        if (ModelUtils.isObjectSchema(schema)) {
            return "null";
        }
        return "null";
    }

    public String toDefaultValue(Schema schema) {
        if (schema.getDefault() != null) {
            return schema.getDefault().toString();
        }
        if (ModelUtils.isBooleanSchema(schema)) {
            return "null";
        }
        if (ModelUtils.isDateSchema(schema)) {
            return "null";
        }
        if (ModelUtils.isDateTimeSchema(schema)) {
            return "null";
        }
        if (ModelUtils.isNumberSchema(schema)) {
            return "null";
        }
        if (ModelUtils.isIntegerSchema(schema)) {
            return "null";
        }
        if (ModelUtils.isStringSchema(schema)) {
            return "null";
        }
        if (ModelUtils.isObjectSchema(schema)) {
            return "null";
        }
        return "null";
    }

    public String toDefaultValueWithParam(String name, Schema schema) {
        return " = data." + name + ";";
    }

    public String getSchemaType(Schema schema) {
        ComposedSchema cs;
        if (schema instanceof ComposedSchema && (cs = (ComposedSchema)schema).getAllOf() != null) {
            for (Schema s : cs.getAllOf()) {
                if (s == null) continue;
                schema = s;
                break;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)schema.get$ref())) {
            String schemaName = ModelUtils.getSimpleRef(schema.get$ref());
            if (StringUtils.isNotEmpty((CharSequence)schemaName)) {
                return this.getAlias(schemaName);
            }
            LOGGER.warn("Error obtaining the datatype from ref:" + schema.get$ref() + ". Default to 'object'");
            return "object";
        }
        return this.getAlias(DefaultCodegen.getPrimitiveType(schema));
    }

    private static String getPrimitiveType(Schema schema) {
        if (schema == null) {
            throw new RuntimeException("schema cannot be null in getPrimitiveType");
        }
        if (ModelUtils.isStringSchema(schema) && "number".equals(schema.getFormat())) {
            return "BigDecimal";
        }
        if (ModelUtils.isByteArraySchema(schema)) {
            return "ByteArray";
        }
        if (ModelUtils.isFileSchema(schema)) {
            return "file";
        }
        if (ModelUtils.isBinarySchema(schema)) {
            return "binary";
        }
        if (ModelUtils.isBooleanSchema(schema)) {
            return "boolean";
        }
        if (ModelUtils.isDateSchema(schema)) {
            return "date";
        }
        if (ModelUtils.isDateTimeSchema(schema)) {
            return "DateTime";
        }
        if (ModelUtils.isNumberSchema(schema)) {
            if (schema.getFormat() == null) {
                return "number";
            }
            if (ModelUtils.isFloatSchema(schema)) {
                return "float";
            }
            if (ModelUtils.isDoubleSchema(schema)) {
                return "double";
            }
            LOGGER.warn("Unknown `format` detected for " + schema.getName() + ": " + schema.getFormat());
        } else {
            if (ModelUtils.isIntegerSchema(schema)) {
                if (ModelUtils.isLongSchema(schema)) {
                    return "long";
                }
                return schema.getType();
            }
            if (ModelUtils.isMapSchema(schema)) {
                return "map";
            }
            if (ModelUtils.isArraySchema(schema)) {
                return "array";
            }
            if (ModelUtils.isUUIDSchema(schema)) {
                return "UUID";
            }
            if (ModelUtils.isStringSchema(schema)) {
                return "string";
            }
            if (schema.getProperties() != null && !schema.getProperties().isEmpty()) {
                return "object";
            }
            if (StringUtils.isNotEmpty((CharSequence)schema.getType())) {
                LOGGER.warn("Unknown type found in the schema: " + schema.getType());
                return schema.getType();
            }
        }
        return "object";
    }

    public String snakeCase(String name) {
        return name.length() > 0 ? Character.toLowerCase(name.charAt(0)) + name.substring(1) : "";
    }

    public String initialCaps(String name) {
        return StringUtils.capitalize((String)name);
    }

    @Override
    public String getTypeDeclaration(String name) {
        return name;
    }

    @Override
    public String getTypeDeclaration(Schema schema) {
        String oasType = this.getSchemaType(schema);
        if (this.typeMapping.containsKey(oasType)) {
            return this.typeMapping.get(oasType);
        }
        return oasType;
    }

    public String getAlias(String name) {
        if (this.typeAliases != null && this.typeAliases.containsKey(name)) {
            return this.typeAliases.get(name);
        }
        return name;
    }

    @Override
    public String toBooleanGetter(String name) {
        return "get" + this.getterAndSetterCapitalize(name);
    }

    @Override
    public String toGetter(String name) {
        return "get" + this.getterAndSetterCapitalize(name);
    }

    @Override
    public String toSetter(String name) {
        return "set" + this.getterAndSetterCapitalize(name);
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        return this.initialCaps(name) + "Api";
    }

    @Override
    public String toModelName(String name) {
        return this.initialCaps(this.modelNamePrefix + name + this.modelNameSuffix);
    }

    @Override
    public CodegenModel fromModel(String name, Schema schema, Map<String, Schema> allDefinitions) {
        if (this.typeAliases == null) {
            this.typeAliases = DefaultCodegen.getAllAliases(allDefinitions);
        }
        schema = ModelUtils.unaliasSchema(allDefinitions, schema);
        CodegenModel m = (CodegenModel)CodegenModelFactory.newInstance(CodegenModelType.MODEL);
        m.name = this.reservedWords.contains(name) ? this.escapeReservedWord(name) : name;
        m.title = this.escapeText(schema.getTitle());
        m.description = this.escapeText(schema.getDescription());
        m.unescapedDescription = schema.getDescription();
        m.classname = this.toModelName(name);
        m.classVarName = this.toVarName(name);
        m.classFilename = this.toModelFilename(name);
        m.modelJson = Json.pretty((Object)schema);
        m.externalDocumentation = schema.getExternalDocs();
        if (schema.getExtensions() != null && !schema.getExtensions().isEmpty()) {
            m.getVendorExtensions().putAll(schema.getExtensions());
        }
        m.isAlias = this.typeAliases.containsKey(name);
        m.discriminator = schema.getDiscriminator();
        if (schema.getXml() != null) {
            m.xmlPrefix = schema.getXml().getPrefix();
            m.xmlNamespace = schema.getXml().getNamespace();
            m.xmlName = schema.getXml().getName();
        }
        if (ModelUtils.isArraySchema(schema)) {
            m.isArrayModel = true;
            m.arrayModelType = this.fromProperty((String)name, (Schema)schema).complexType;
            this.addParentContainer(m, name, schema);
        } else if (schema instanceof ComposedSchema) {
            String parentName;
            ArrayList<String> allRequired;
            LinkedHashMap<String, Schema> allProperties;
            ComposedSchema composed = (ComposedSchema)schema;
            LinkedHashMap<String, Schema> properties = new LinkedHashMap<String, Schema>();
            ArrayList<String> required = new ArrayList<String>();
            if (this.supportsInheritance || this.supportsMixins) {
                allProperties = new LinkedHashMap<String, Schema>();
                allRequired = new ArrayList<String>();
                m.allVars = new ArrayList<CodegenProperty>();
                if (composed.getAllOf() != null) {
                    int modelImplCnt = 0;
                    for (Schema innerModel : composed.getAllOf()) {
                        if (m.discriminator == null) {
                            m.discriminator = schema.getDiscriminator();
                        }
                        if (innerModel.getXml() != null) {
                            m.xmlPrefix = innerModel.getXml().getPrefix();
                            m.xmlNamespace = innerModel.getXml().getNamespace();
                            m.xmlName = innerModel.getXml().getName();
                        }
                        if (modelImplCnt++ <= 1) continue;
                        LOGGER.warn("More than one inline schema specified in allOf:. Only the first one is recognized. All others are ignored.");
                        break;
                    }
                }
            } else {
                allProperties = null;
                allRequired = null;
            }
            Schema parent = StringUtils.isBlank((CharSequence)(parentName = this.getParentName(composed, allDefinitions))) || allDefinitions == null ? null : allDefinitions.get(parentName);
            List<Schema> interfaces = this.getInterfaces(composed);
            if (interfaces != null) {
                if (m.interfaces == null) {
                    m.interfaces = new ArrayList<String>();
                }
                for (Schema interfaceSchema : interfaces) {
                    if (StringUtils.isBlank((CharSequence)interfaceSchema.get$ref())) continue;
                    Schema refSchema = null;
                    String ref = ModelUtils.getSimpleRef(interfaceSchema.get$ref());
                    if (allDefinitions != null) {
                        refSchema = allDefinitions.get(ref);
                    }
                    String modelName = this.toModelName(ref);
                    m.interfaces.add(modelName);
                    this.addImport(m, modelName);
                    if (allDefinitions == null || refSchema == null) continue;
                    if (!this.supportsMixins && !this.supportsInheritance) {
                        this.addProperties(properties, required, refSchema, allDefinitions);
                    }
                    if (!this.supportsInheritance) continue;
                    this.addProperties(allProperties, allRequired, refSchema, allDefinitions);
                }
            }
            if (parent != null) {
                m.parentSchema = parentName;
                m.parent = this.toModelName(parentName);
                this.addImport(m, m.parent);
                if (allDefinitions != null && !allDefinitions.isEmpty()) {
                    if (this.supportsInheritance) {
                        this.addProperties(allProperties, allRequired, parent, allDefinitions);
                    } else {
                        this.addProperties(properties, required, parent, allDefinitions);
                    }
                }
            }
            Schema child = null;
            if (composed.getAllOf() != null && !composed.getAllOf().isEmpty()) {
                for (Schema component : composed.getAllOf()) {
                    if (component.get$ref() != null) continue;
                    child = component;
                }
            }
            if (child != null) {
                this.addProperties(properties, required, child, allDefinitions);
                if (this.supportsInheritance) {
                    this.addProperties(allProperties, allRequired, child, allDefinitions);
                }
            }
            this.addVars(m, this.unaliasPropertySchema(allDefinitions, properties), required, allProperties, allRequired);
        } else {
            m.dataType = this.getSchemaType(schema);
            if (schema.getEnum() != null && !schema.getEnum().isEmpty()) {
                m.isEnum = true;
                m.allowableValues = new HashMap<String, Object>();
                m.allowableValues.put("values", schema.getEnum());
            }
            if (ModelUtils.isMapSchema(schema)) {
                this.addAdditionPropertiesToCodeGenModel(m, schema);
                m.isMapModel = true;
            }
            if (ModelUtils.isIntegerSchema(schema) && !ModelUtils.isLongSchema(schema)) {
                m.isInteger = Boolean.TRUE;
            }
            if (ModelUtils.isStringSchema(schema)) {
                m.isString = Boolean.TRUE;
            }
            this.addVars(m, this.unaliasPropertySchema(allDefinitions, schema.getProperties()), schema.getRequired());
        }
        if (m.vars != null) {
            for (CodegenProperty prop : m.vars) {
                this.postProcessModelProperty(m, prop);
            }
        }
        LOGGER.debug("debugging fromModel return: " + m);
        return m;
    }

    protected void addAdditionPropertiesToCodeGenModel(CodegenModel codegenModel, Schema schema) {
        this.addParentContainer(codegenModel, codegenModel.name, schema);
    }

    protected void addProperties(Map<String, Schema> properties, List<String> required, Schema schema, Map<String, Schema> allSchemas) {
        if (schema instanceof ComposedSchema) {
            ComposedSchema composedSchema = (ComposedSchema)schema;
            if (composedSchema.getAllOf() == null) {
                return;
            }
            for (Schema component : composedSchema.getAllOf()) {
                this.addProperties(properties, required, component, allSchemas);
            }
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)schema.get$ref())) {
            Schema interfaceSchema = allSchemas.get(ModelUtils.getSimpleRef(schema.get$ref()));
            this.addProperties(properties, required, interfaceSchema, allSchemas);
            return;
        }
        if (schema.getProperties() != null) {
            properties.putAll(schema.getProperties());
        }
        if (schema.getRequired() != null) {
            required.addAll(schema.getRequired());
        }
    }

    public String getterAndSetterCapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        return DefaultCodegen.camelize(this.toVarName(name));
    }

    public CodegenProperty fromProperty(String name, Schema p) {
        HashMap<String, Object> allowableValues;
        List _enum;
        if (p == null) {
            LOGGER.error("Unexpected missing property for name " + name);
            return null;
        }
        LOGGER.debug("debugging fromProperty for " + name + " : " + p);
        CodegenProperty property = (CodegenProperty)CodegenModelFactory.newInstance(CodegenModelType.PROPERTY);
        property.name = this.toVarName(name);
        property.baseName = name;
        property.nameInCamelCase = DefaultCodegen.camelize(property.name, false);
        property.nameInSnakeCase = CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, property.nameInCamelCase);
        property.description = this.escapeText(p.getDescription());
        property.unescapedDescription = p.getDescription();
        property.title = p.getTitle();
        property.getter = this.toGetter(name);
        property.setter = this.toSetter(name);
        String example = this.toExampleValue(p);
        if (!"null".equals(example)) {
            property.example = example;
        }
        property.defaultValue = this.toDefaultValue(p);
        property.defaultValueWithParam = this.toDefaultValueWithParam(name, p);
        property.jsonSchema = Json.pretty((Object)p);
        if (p.getReadOnly() != null) {
            property.isReadOnly = p.getReadOnly();
        }
        if (p.getXml() != null) {
            if (p.getXml().getAttribute() != null) {
                property.isXmlAttribute = p.getXml().getAttribute();
            }
            property.xmlPrefix = p.getXml().getPrefix();
            property.xmlName = p.getXml().getName();
            property.xmlNamespace = p.getXml().getNamespace();
        }
        if (p.getExtensions() != null && !p.getExtensions().isEmpty()) {
            property.getVendorExtensions().putAll(p.getExtensions());
        }
        String type = this.getSchemaType(p);
        if (ModelUtils.isIntegerSchema(p)) {
            property.isNumeric = Boolean.TRUE;
            if ("int64".equals(p.getFormat())) {
                property.isLong = Boolean.TRUE;
            } else {
                property.isInteger = Boolean.TRUE;
            }
            if (p.getMinimum() != null) {
                property.minimum = String.valueOf(p.getMinimum().longValue());
            }
            if (p.getMaximum() != null) {
                property.maximum = String.valueOf(p.getMaximum().longValue());
            }
            if (p.getExclusiveMinimum() != null) {
                property.exclusiveMinimum = p.getExclusiveMinimum();
            }
            if (p.getExclusiveMaximum() != null) {
                property.exclusiveMaximum = p.getExclusiveMaximum();
            }
            if (property.minimum != null || property.maximum != null) {
                property.hasValidation = true;
            }
            HashMap<String, Object> allowableValues2 = new HashMap<String, Object>();
            if (p.getEnum() != null) {
                List _enum2 = p.getEnum();
                property._enum = new ArrayList<String>();
                Iterator iterator = _enum2.iterator();
                while (iterator.hasNext()) {
                    Object i = iterator.next();
                    property._enum.add(String.valueOf(i));
                }
                property.isEnum = true;
                allowableValues2.put("values", _enum2);
            }
            if (allowableValues2.size() > 0) {
                property.allowableValues = allowableValues2;
            }
        } else if (ModelUtils.isBooleanSchema(p)) {
            property.isBoolean = true;
            property.getter = this.toBooleanGetter(name);
        } else if (ModelUtils.isDateSchema(p)) {
            property.isString = false;
            property.isDate = true;
            if (p.getEnum() != null) {
                _enum = p.getEnum();
                property._enum = new ArrayList<String>();
                for (String i : _enum) {
                    property._enum.add(i);
                }
                property.isEnum = true;
                allowableValues = new HashMap();
                allowableValues.put("values", _enum);
                property.allowableValues = allowableValues;
            }
        } else if (ModelUtils.isDateTimeSchema(p)) {
            property.isString = false;
            property.isDateTime = true;
            if (p.getEnum() != null) {
                _enum = p.getEnum();
                property._enum = new ArrayList<String>();
                for (String i : _enum) {
                    property._enum.add(i);
                }
                property.isEnum = true;
                allowableValues = new HashMap<String, Object>();
                allowableValues.put("values", _enum);
                property.allowableValues = allowableValues;
            }
        } else if (ModelUtils.isStringSchema(p)) {
            if (ModelUtils.isByteArraySchema(p)) {
                property.isByteArray = true;
            } else if (ModelUtils.isBinarySchema(p)) {
                property.isBinary = true;
                property.isFile = true;
            } else if (ModelUtils.isFileSchema(p)) {
                property.isFile = true;
            } else if (ModelUtils.isUUIDSchema(p)) {
                property.isString = true;
                property.isUuid = true;
            } else {
                property.isString = true;
            }
            property.maxLength = p.getMaxLength();
            property.minLength = p.getMinLength();
            property.pattern = this.toRegularExpression(p.getPattern());
            if (property.pattern != null || property.minLength != null || property.maxLength != null) {
                property.hasValidation = true;
            }
            if (p.getEnum() != null) {
                property._enum = _enum = p.getEnum();
                property.isEnum = true;
                allowableValues = new HashMap();
                allowableValues.put("values", _enum);
                property.allowableValues = allowableValues;
            }
        } else if (ModelUtils.isNumberSchema(p)) {
            property.isNumeric = Boolean.TRUE;
            if (ModelUtils.isFloatSchema(p)) {
                property.isFloat = Boolean.TRUE;
            } else if (ModelUtils.isDoubleSchema(p)) {
                property.isDouble = Boolean.TRUE;
            } else {
                property.isNumber = Boolean.TRUE;
            }
            if (p.getMinimum() != null) {
                property.minimum = String.valueOf(p.getMinimum());
            }
            if (p.getMaximum() != null) {
                property.maximum = String.valueOf(p.getMaximum());
            }
            if (p.getExclusiveMinimum() != null) {
                property.exclusiveMinimum = p.getExclusiveMinimum();
            }
            if (p.getExclusiveMaximum() != null) {
                property.exclusiveMaximum = p.getExclusiveMaximum();
            }
            if (property.minimum != null || property.maximum != null) {
                property.hasValidation = true;
            }
            if (p.getEnum() != null && !p.getEnum().isEmpty()) {
                _enum = p.getEnum();
                property._enum = new ArrayList<String>();
                for (Object i : _enum) {
                    property._enum.add(String.valueOf(i));
                }
                property.isEnum = true;
                allowableValues = new HashMap<String, Object>();
                allowableValues.put("values", _enum);
                property.allowableValues = allowableValues;
            }
        }
        property.dataType = this.getTypeDeclaration(p);
        property.dataFormat = p.getFormat();
        property.baseType = this.getSchemaType(p);
        if (property.isEnum) {
            property.datatypeWithEnum = this.toEnumName(property);
            property.enumName = this.toEnumName(property);
        } else {
            property.datatypeWithEnum = property.dataType;
        }
        if (ModelUtils.isArraySchema(p)) {
            property.isContainer = true;
            property.isListContainer = true;
            property.containerType = "array";
            property.baseType = this.getSchemaType(p);
            if (p.getXml() != null) {
                property.isXmlWrapped = p.getXml().getWrapped() == null ? false : p.getXml().getWrapped();
                property.xmlPrefix = p.getXml().getPrefix();
                property.xmlNamespace = p.getXml().getNamespace();
                property.xmlName = p.getXml().getName();
            }
            property.maxItems = p.getMaxItems();
            property.minItems = p.getMinItems();
            String itemName = null;
            if (p.getExtensions() != null && p.getExtensions().get("x-item-name") != null) {
                itemName = p.getExtensions().get("x-item-name").toString();
            }
            if (itemName == null) {
                itemName = property.name;
            }
            CodegenProperty cp = this.fromProperty(itemName, ((ArraySchema)p).getItems());
            this.updatePropertyForArray(property, cp);
        } else if (ModelUtils.isMapSchema(p)) {
            property.isContainer = true;
            property.isMapContainer = true;
            property.containerType = "map";
            property.baseType = this.getSchemaType(p);
            property.minItems = p.getMinProperties();
            property.maxItems = p.getMaxProperties();
            CodegenProperty cp = this.fromProperty("inner", (Schema)p.getAdditionalProperties());
            this.updatePropertyForMap(property, cp);
        } else {
            this.setNonArrayMapProperty(property, type);
        }
        LOGGER.debug("debugging from property return: " + property);
        return property;
    }

    protected void updatePropertyForArray(CodegenProperty property, CodegenProperty innerProperty) {
        if (innerProperty == null) {
            LOGGER.warn("skipping invalid array property " + Json.pretty((Object)property));
            return;
        }
        property.dataFormat = innerProperty.dataFormat;
        if (!this.languageSpecificPrimitives.contains(innerProperty.baseType)) {
            property.complexType = innerProperty.baseType;
        } else {
            property.isPrimitiveType = true;
        }
        property.items = innerProperty;
        property.mostInnerItems = this.getMostInnerItems(innerProperty);
        if (this.isPropertyInnerMostEnum(property).booleanValue()) {
            property.isEnum = true;
            this.updateDataTypeWithEnumForArray(property);
            property.allowableValues = this.getInnerEnumAllowableValues(property);
        }
    }

    protected void updatePropertyForMap(CodegenProperty property, CodegenProperty innerProperty) {
        if (innerProperty == null) {
            LOGGER.warn("skipping invalid map property " + Json.pretty((Object)property));
            return;
        }
        if (!this.languageSpecificPrimitives.contains(innerProperty.baseType)) {
            property.complexType = innerProperty.baseType;
        } else {
            property.isPrimitiveType = true;
        }
        property.items = innerProperty;
        property.mostInnerItems = this.getMostInnerItems(innerProperty);
        property.dataFormat = innerProperty.dataFormat;
        if (this.isPropertyInnerMostEnum(property).booleanValue()) {
            property.isEnum = true;
            this.updateDataTypeWithEnumForMap(property);
            property.allowableValues = this.getInnerEnumAllowableValues(property);
        }
    }

    protected Boolean isPropertyInnerMostEnum(CodegenProperty property) {
        CodegenProperty currentProperty = this.getMostInnerItems(property);
        return currentProperty == null ? false : currentProperty.isEnum;
    }

    protected CodegenProperty getMostInnerItems(CodegenProperty property) {
        CodegenProperty currentProperty = property;
        while (currentProperty != null && (Boolean.TRUE.equals(currentProperty.isMapContainer) || Boolean.TRUE.equals(currentProperty.isListContainer))) {
            currentProperty = currentProperty.items;
        }
        return currentProperty;
    }

    protected Map<String, Object> getInnerEnumAllowableValues(CodegenProperty property) {
        CodegenProperty currentProperty = this.getMostInnerItems(property);
        return currentProperty == null ? new HashMap() : currentProperty.allowableValues;
    }

    protected void updateDataTypeWithEnumForArray(CodegenProperty property) {
        CodegenProperty baseItem = property.items;
        while (baseItem != null && (Boolean.TRUE.equals(baseItem.isMapContainer) || Boolean.TRUE.equals(baseItem.isListContainer))) {
            baseItem = baseItem.items;
        }
        if (baseItem != null) {
            property.datatypeWithEnum = property.datatypeWithEnum.replace(baseItem.baseType, this.toEnumName(baseItem));
            property.enumName = this.toEnumName(property);
            if (property.defaultValue != null) {
                property.defaultValue = property.defaultValue.replace(baseItem.baseType, this.toEnumName(baseItem));
            }
            this.updateCodegenPropertyEnum(property);
        }
    }

    protected void updateDataTypeWithEnumForMap(CodegenProperty property) {
        CodegenProperty baseItem = property.items;
        while (baseItem != null && (Boolean.TRUE.equals(baseItem.isMapContainer) || Boolean.TRUE.equals(baseItem.isListContainer))) {
            baseItem = baseItem.items;
        }
        if (baseItem != null) {
            property.datatypeWithEnum = property.datatypeWithEnum.replace(", " + baseItem.baseType, ", " + this.toEnumName(baseItem));
            property.enumName = this.toEnumName(property);
            if (property.defaultValue != null) {
                property.defaultValue = property.defaultValue.replace(", " + property.items.baseType, ", " + this.toEnumName(property.items));
            }
        }
    }

    protected void setNonArrayMapProperty(CodegenProperty property, String type) {
        property.isNotContainer = true;
        if (this.languageSpecificPrimitives().contains(type)) {
            property.isPrimitiveType = true;
        } else {
            property.complexType = property.baseType;
        }
    }

    protected ApiResponse findMethodResponse(ApiResponses responses) {
        String code = null;
        for (String responseCode : responses.keySet()) {
            if (!responseCode.startsWith("2") && !responseCode.equals("default") || code != null && code.compareTo(responseCode) <= 0) continue;
            code = responseCode;
        }
        if (code == null) {
            return null;
        }
        return (ApiResponse)responses.get(code);
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, Map<String, Schema> schemas) {
        return this.fromOperation(path, httpMethod, operation, schemas, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, Map<String, Schema> schemas, OpenAPI openAPI) {
        int offset;
        LOGGER.debug("fromOperation => operation: " + operation);
        CodegenOperation op = (CodegenOperation)CodegenModelFactory.newInstance(CodegenModelType.OPERATION);
        HashSet<String> imports = new HashSet<String>();
        if (operation.getExtensions() != null && !operation.getExtensions().isEmpty()) {
            op.vendorExtensions.putAll(operation.getExtensions());
        }
        if (operation == null) {
            throw new RuntimeException("operation cannot be null in fromOperation");
        }
        op.operationIdOriginal = operation.getOperationId();
        String operationId = this.getOrGenerateOperationId(operation, path, httpMethod);
        if (this.removeOperationIdPrefix && (offset = operationId.indexOf(95)) > -1) {
            operationId = operationId.substring(offset + 1);
        }
        operationId = this.removeNonNameElementToCamelCase(operationId);
        op.path = path;
        op.operationId = this.toOperationId(operationId);
        op.summary = this.escapeText(operation.getSummary());
        op.unescapedNotes = operation.getDescription();
        op.notes = this.escapeText(operation.getDescription());
        op.hasConsumes = false;
        op.hasProduces = false;
        if (operation.getDeprecated() != null) {
            op.isDeprecated = operation.getDeprecated();
        }
        this.addConsumesInfo(openAPI, operation, op);
        if (operation.getResponses() != null && !operation.getResponses().isEmpty()) {
            ApiResponse methodResponse = this.findMethodResponse(operation.getResponses());
            for (String key : operation.getResponses().keySet()) {
                ApiResponse response = (ApiResponse)operation.getResponses().get((Object)key);
                this.addProducesInfo(openAPI, response, op);
                CodegenResponse r = this.fromResponse(key, response);
                r.hasMore = true;
                if (r.baseType != null && !this.defaultIncludes.contains(r.baseType) && !this.languageSpecificPrimitives.contains(r.baseType)) {
                    imports.add(r.baseType);
                }
                r.isDefault = response == methodResponse;
                op.responses.add(r);
                if (Boolean.TRUE.equals(r.isBinary) && Boolean.TRUE.equals(r.isDefault)) {
                    op.isResponseBinary = Boolean.TRUE;
                }
                if (!Boolean.TRUE.equals(r.isFile) || !Boolean.TRUE.equals(r.isDefault)) continue;
                op.isResponseFile = Boolean.TRUE;
            }
            op.responses.get((int)(op.responses.size() - 1)).hasMore = false;
            if (methodResponse != null) {
                Schema responseSchema = ModelUtils.getSchemaFromResponse(methodResponse);
                if (responseSchema != null) {
                    Schema schema;
                    CodegenProperty cm = this.fromProperty("response", responseSchema);
                    if (ModelUtils.isArraySchema(responseSchema)) {
                        ArraySchema as = (ArraySchema)responseSchema;
                        CodegenProperty innerProperty = this.fromProperty("response", as.getItems());
                        op.returnBaseType = innerProperty.baseType;
                    } else if (ModelUtils.isMapSchema(responseSchema)) {
                        CodegenProperty innerProperty = this.fromProperty("response", (Schema)responseSchema.getAdditionalProperties());
                        op.returnBaseType = innerProperty.baseType;
                    } else {
                        op.returnBaseType = cm.complexType != null ? cm.complexType : cm.baseType;
                    }
                    op.examples = new ExampleGenerator(schemas, openAPI).generateFromResponseSchema(responseSchema, DefaultCodegen.getProducesInfo(openAPI, operation));
                    op.defaultResponse = this.toDefaultValue(responseSchema);
                    op.returnType = cm.dataType;
                    boolean bl = op.hasReference = schemas != null && schemas.containsKey(op.returnBaseType);
                    if (schemas != null && (schema = schemas.get(op.returnBaseType)) != null) {
                        CodegenModel cmod = this.fromModel(op.returnBaseType, schema, schemas);
                        op.discriminator = cmod.discriminator;
                    }
                    if (cm.isContainer) {
                        op.returnContainer = cm.containerType;
                        if ("map".equals(cm.containerType)) {
                            op.isMapContainer = true;
                        } else if ("list".equalsIgnoreCase(cm.containerType)) {
                            op.isListContainer = true;
                        } else if ("array".equalsIgnoreCase(cm.containerType)) {
                            op.isListContainer = true;
                        }
                    } else {
                        op.returnSimpleType = true;
                    }
                    if (this.languageSpecificPrimitives().contains(op.returnBaseType) || op.returnBaseType == null) {
                        op.returnTypeIsPrimitive = true;
                    }
                }
                this.addHeaders(methodResponse, op.responseHeaders);
            }
        }
        List parameters = operation.getParameters();
        ArrayList<CodegenParameter> allParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> bodyParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> pathParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> queryParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> headerParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> cookieParams = new ArrayList<CodegenParameter>();
        List<Object> formParams = new ArrayList();
        ArrayList<CodegenParameter> requiredParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> optionalParams = new ArrayList<CodegenParameter>();
        CodegenParameter bodyParam = null;
        RequestBody requestBody = operation.getRequestBody();
        if (requestBody != null) {
            if ("application/x-www-form-urlencoded".equalsIgnoreCase(this.getContentType(requestBody)) || "multipart/form-data".equalsIgnoreCase(this.getContentType(requestBody))) {
                formParams = this.fromRequestBodyToFormParameters(requestBody, schemas, imports);
                for (CodegenParameter codegenParameter : formParams) {
                    this.postProcessParameter(codegenParameter);
                }
                if (this.prependFormOrBodyParameters.booleanValue()) {
                    for (CodegenParameter codegenParameter : formParams) {
                        allParams.add(codegenParameter.copy());
                    }
                }
            } else {
                requestBody = ModelUtils.getReferencedRequestBody(openAPI, requestBody);
                String bodyParameterName = "";
                if (op.vendorExtensions != null && op.vendorExtensions.containsKey("x-codegen-request-body-name")) {
                    bodyParameterName = (String)op.vendorExtensions.get("x-codegen-request-body-name");
                }
                bodyParam = this.fromRequestBody(requestBody, schemas, imports, bodyParameterName);
                bodyParam.description = requestBody.getDescription();
                this.postProcessParameter(bodyParam);
                bodyParams.add(bodyParam);
                if (this.prependFormOrBodyParameters.booleanValue()) {
                    allParams.add(bodyParam);
                }
                if (schemas != null) {
                    op.requestBodyExamples = new ExampleGenerator(schemas, openAPI).generate(null, new ArrayList<String>(DefaultCodegen.getConsumesInfo(openAPI, operation)), bodyParam.baseType);
                }
            }
        }
        if (parameters != null) {
            for (Parameter parameter : parameters) {
                void var22_30;
                if (StringUtils.isNotBlank((CharSequence)parameter.get$ref())) {
                    Parameter parameter2 = this.getParameterFromRef(parameter.get$ref(), openAPI);
                }
                CodegenParameter p = this.fromParameter((Parameter)var22_30, imports);
                allParams.add(p);
                if (var22_30 instanceof QueryParameter || "query".equalsIgnoreCase(var22_30.getIn())) {
                    queryParams.add(p.copy());
                    continue;
                }
                if (var22_30 instanceof PathParameter || "path".equalsIgnoreCase(var22_30.getIn())) {
                    pathParams.add(p.copy());
                    continue;
                }
                if (var22_30 instanceof HeaderParameter || "header".equalsIgnoreCase(var22_30.getIn())) {
                    headerParams.add(p.copy());
                    continue;
                }
                if (var22_30 instanceof CookieParameter || "cookie".equalsIgnoreCase(var22_30.getIn())) {
                    cookieParams.add(p.copy());
                    continue;
                }
                LOGGER.warn("Unknown parameter type " + p.baseType + " for " + p.baseName);
            }
        }
        if (!this.prependFormOrBodyParameters.booleanValue()) {
            for (CodegenParameter codegenParameter : formParams) {
                allParams.add(codegenParameter.copy());
            }
            for (CodegenParameter codegenParameter : bodyParams) {
                allParams.add(codegenParameter.copy());
            }
        }
        for (CodegenParameter codegenParameter : allParams) {
            if (!this.ensureUniqueParams.booleanValue() || this.isParameterNameUnique(codegenParameter, allParams)) continue;
            codegenParameter.paramName = DefaultCodegen.generateNextName(codegenParameter.paramName);
        }
        for (CodegenParameter codegenParameter : allParams) {
            if (codegenParameter.required) {
                requiredParams.add(codegenParameter.copy());
                continue;
            }
            optionalParams.add(codegenParameter.copy());
            op.hasOptionalParams = true;
        }
        for (String string : imports) {
            if (!this.needToImport(string)) continue;
            op.imports.add(string);
        }
        op.bodyParam = bodyParam;
        op.httpMethod = httpMethod.toUpperCase();
        if (this.sortParamsByRequiredFlag.booleanValue()) {
            Collections.sort(allParams, new Comparator<CodegenParameter>(){

                @Override
                public int compare(CodegenParameter one, CodegenParameter another) {
                    if (one.required == another.required) {
                        return 0;
                    }
                    if (one.required) {
                        return -1;
                    }
                    return 1;
                }
            });
        }
        op.allParams = DefaultCodegen.addHasMore(allParams);
        op.bodyParams = DefaultCodegen.addHasMore(bodyParams);
        op.pathParams = DefaultCodegen.addHasMore(pathParams);
        op.queryParams = DefaultCodegen.addHasMore(queryParams);
        op.headerParams = DefaultCodegen.addHasMore(headerParams);
        op.cookieParams = DefaultCodegen.addHasMore(cookieParams);
        op.formParams = DefaultCodegen.addHasMore(formParams);
        op.requiredParams = DefaultCodegen.addHasMore(requiredParams);
        op.optionalParams = DefaultCodegen.addHasMore(optionalParams);
        op.externalDocs = operation.getExternalDocs();
        op.nickname = op.operationId;
        if (op.allParams.size() > 0) {
            op.hasParams = true;
        }
        op.hasRequiredParams = op.requiredParams.size() > 0;
        op.isRestfulShow = op.isRestfulShow();
        op.isRestfulIndex = op.isRestfulIndex();
        op.isRestfulCreate = op.isRestfulCreate();
        op.isRestfulUpdate = op.isRestfulUpdate();
        op.isRestfulDestroy = op.isRestfulDestroy();
        op.isRestful = op.isRestful();
        return op;
    }

    public boolean isParameterNameUnique(CodegenParameter p, List<CodegenParameter> parameters) {
        for (CodegenParameter parameter : parameters) {
            if (System.identityHashCode(p) == System.identityHashCode(parameter) || !p.paramName.equals(parameter.paramName)) continue;
            return false;
        }
        return true;
    }

    public CodegenResponse fromResponse(String responseCode, ApiResponse response) {
        CodegenResponse r = (CodegenResponse)CodegenModelFactory.newInstance(CodegenModelType.RESPONSE);
        r.code = "default".equals(responseCode) ? "0" : responseCode;
        Schema responseSchema = ModelUtils.getSchemaFromResponse(response);
        r.schema = responseSchema;
        r.message = this.escapeText(response.getDescription());
        r.jsonSchema = Json.pretty((Object)response);
        if (response.getExtensions() != null && !response.getExtensions().isEmpty()) {
            r.vendorExtensions.putAll(response.getExtensions());
        }
        this.addHeaders(response, r.headers);
        boolean bl = r.hasHeaders = !r.headers.isEmpty();
        if (r.schema != null) {
            CodegenProperty cp = this.fromProperty("response", responseSchema);
            if (ModelUtils.isArraySchema(responseSchema)) {
                CodegenProperty innerProperty;
                ArraySchema as = (ArraySchema)responseSchema;
                CodegenProperty innerCp = innerProperty = this.fromProperty("response", as.getItems());
                while (innerCp != null) {
                    r.baseType = innerCp.baseType;
                    innerCp = innerCp.items;
                }
            } else {
                r.baseType = cp.complexType != null ? cp.complexType : cp.baseType;
            }
            r.dataType = cp.dataType;
            if (Boolean.TRUE.equals(cp.isString) && Boolean.TRUE.equals(cp.isUuid)) {
                r.isUuid = true;
            } else if (Boolean.TRUE.equals(cp.isByteArray)) {
                r.isByteArray = true;
            } else if (Boolean.TRUE.equals(cp.isString)) {
                r.isString = true;
            } else if (Boolean.TRUE.equals(cp.isBoolean)) {
                r.isBoolean = true;
            } else if (Boolean.TRUE.equals(cp.isLong)) {
                r.isLong = true;
                r.isNumeric = true;
            } else if (Boolean.TRUE.equals(cp.isInteger)) {
                r.isInteger = true;
                r.isNumeric = true;
            } else if (Boolean.TRUE.equals(cp.isNumber)) {
                r.isNumber = true;
                r.isNumeric = true;
            } else if (Boolean.TRUE.equals(cp.isDouble)) {
                r.isDouble = true;
                r.isNumeric = true;
            } else if (Boolean.TRUE.equals(cp.isFloat)) {
                r.isFloat = true;
                r.isNumeric = true;
            } else if (Boolean.TRUE.equals(cp.isBinary)) {
                r.isFile = true;
                r.isBinary = true;
            } else if (Boolean.TRUE.equals(cp.isFile)) {
                r.isFile = true;
            } else if (Boolean.TRUE.equals(cp.isDate)) {
                r.isDate = true;
            } else if (Boolean.TRUE.equals(cp.isDateTime)) {
                r.isDateTime = true;
            } else {
                LOGGER.debug("Property type is not primitive: " + cp.dataType);
            }
            if (cp.isContainer) {
                r.simpleType = false;
                r.containerType = cp.containerType;
                r.isMapContainer = "map".equals(cp.containerType);
                r.isListContainer = "list".equalsIgnoreCase(cp.containerType) || "array".equalsIgnoreCase(cp.containerType);
            } else {
                r.simpleType = true;
            }
            boolean bl2 = r.primitiveType = r.baseType == null || this.languageSpecificPrimitives().contains(r.baseType);
        }
        if (r.baseType == null) {
            r.isMapContainer = false;
            r.isListContainer = false;
            r.primitiveType = true;
            r.simpleType = true;
        }
        return r;
    }

    public CodegenParameter fromParameter(Parameter parameter, Set<String> imports) {
        CodegenParameter codegenParameter = (CodegenParameter)CodegenModelFactory.newInstance(CodegenModelType.PARAMETER);
        codegenParameter.baseName = parameter.getName();
        codegenParameter.description = this.escapeText(parameter.getDescription());
        codegenParameter.unescapedDescription = parameter.getDescription();
        if (parameter.getRequired() != null) {
            codegenParameter.required = parameter.getRequired();
        }
        codegenParameter.jsonSchema = Json.pretty((Object)parameter);
        if (System.getProperty("debugParser") != null) {
            LOGGER.info("working on Parameter " + parameter.getName());
            LOGGER.info("JSON schema: " + codegenParameter.jsonSchema);
        }
        if (parameter.getExtensions() != null && !parameter.getExtensions().isEmpty()) {
            codegenParameter.vendorExtensions.putAll(parameter.getExtensions());
        }
        if (parameter.getSchema() != null) {
            CodegenProperty codegenProperty;
            Schema parameterSchema = parameter.getSchema();
            if (parameterSchema == null) {
                LOGGER.warn("warning!  Schema not found for parameter \"" + parameter.getName() + "\", using String");
                parameterSchema = new StringSchema().description("//TODO automatically added by openapi-generator due to missing type definition.");
            }
            if (parameterSchema.getDefault() != null) {
                codegenParameter.defaultValue = this.toDefaultValue(parameterSchema);
            }
            String collectionFormat = null;
            if (ModelUtils.isArraySchema(parameterSchema)) {
                CodegenProperty codegenProperty2;
                ArraySchema arraySchema = (ArraySchema)parameterSchema;
                Schema inner = arraySchema.getItems();
                if (inner == null) {
                    LOGGER.warn("warning! No inner type supplied for array parameter \"" + parameter.getName() + "\", using String");
                    inner = new StringSchema().description("//TODO automatically added by openapi-generator due to missing iner type definition in the spec");
                    arraySchema.setItems(inner);
                }
                collectionFormat = StringUtils.isEmpty((CharSequence)(collectionFormat = this.getCollectionFormat(parameter))) ? "csv" : collectionFormat;
                codegenParameter.items = codegenProperty2 = this.fromProperty("inner", inner);
                codegenParameter.mostInnerItems = codegenProperty2.mostInnerItems;
                codegenParameter.baseType = codegenProperty2.dataType;
                codegenParameter.isContainer = true;
                codegenParameter.isListContainer = true;
                while (codegenProperty2 != null) {
                    imports.add(codegenProperty2.baseType);
                    codegenProperty2 = codegenProperty2.items;
                }
            } else if (ModelUtils.isMapSchema(parameterSchema)) {
                codegenParameter.items = codegenProperty = this.fromProperty("inner", (Schema)parameterSchema.getAdditionalProperties());
                codegenParameter.mostInnerItems = codegenProperty.mostInnerItems;
                codegenParameter.baseType = codegenProperty.dataType;
                codegenParameter.isContainer = true;
                codegenParameter.isMapContainer = true;
                while (codegenProperty != null) {
                    imports.add(codegenProperty.baseType);
                    codegenProperty = codegenProperty.items;
                }
            }
            codegenProperty = this.fromProperty(parameter.getName(), parameterSchema);
            codegenProperty.required = Boolean.TRUE.equals(parameter.getRequired());
            this.setParameterBooleanFlagWithCodegenProperty(codegenParameter, codegenProperty);
            String parameterDataType = this.getParameterDataType(parameter, parameterSchema);
            codegenParameter.dataType = parameterDataType != null ? parameterDataType : codegenProperty.dataType;
            codegenParameter.dataFormat = codegenProperty.dataFormat;
            codegenParameter.required = codegenProperty.required;
            if (codegenProperty.isEnum) {
                codegenParameter.datatypeWithEnum = codegenProperty.datatypeWithEnum;
                codegenParameter.enumName = codegenProperty.enumName;
            }
            this.updateCodegenPropertyEnum(codegenProperty);
            codegenParameter.isEnum = codegenProperty.isEnum;
            codegenParameter._enum = codegenProperty._enum;
            codegenParameter.allowableValues = codegenProperty.allowableValues;
            if (codegenProperty.items != null && codegenProperty.items.isEnum) {
                codegenParameter.datatypeWithEnum = codegenProperty.datatypeWithEnum;
                codegenParameter.enumName = codegenProperty.enumName;
                codegenParameter.items = codegenProperty.items;
                codegenParameter.mostInnerItems = codegenProperty.mostInnerItems;
            }
            codegenParameter.collectionFormat = collectionFormat;
            if ("multi".equals(collectionFormat)) {
                codegenParameter.isCollectionFormatMulti = true;
            }
            codegenParameter.paramName = this.toParamName(parameter.getName());
            if (codegenProperty.complexType != null) {
                imports.add(codegenProperty.complexType);
            }
            if (ModelUtils.isIntegerSchema(parameterSchema)) {
                codegenParameter.maximum = parameterSchema.getMaximum() == null ? null : String.valueOf(parameterSchema.getMaximum().longValue());
                codegenParameter.minimum = parameterSchema.getMinimum() == null ? null : String.valueOf(parameterSchema.getMinimum().longValue());
            } else {
                codegenParameter.maximum = parameterSchema.getMaximum() == null ? null : String.valueOf(parameterSchema.getMaximum());
                codegenParameter.minimum = parameterSchema.getMinimum() == null ? null : String.valueOf(parameterSchema.getMinimum());
            }
            codegenParameter.exclusiveMaximum = parameterSchema.getExclusiveMaximum() == null ? false : parameterSchema.getExclusiveMaximum();
            codegenParameter.exclusiveMinimum = parameterSchema.getExclusiveMinimum() == null ? false : parameterSchema.getExclusiveMinimum();
            codegenParameter.maxLength = parameterSchema.getMaxLength();
            codegenParameter.minLength = parameterSchema.getMinLength();
            codegenParameter.pattern = this.toRegularExpression(parameterSchema.getPattern());
            codegenParameter.maxItems = parameterSchema.getMaxItems();
            codegenParameter.minItems = parameterSchema.getMinItems();
            codegenParameter.uniqueItems = parameterSchema.getUniqueItems() == null ? false : parameterSchema.getUniqueItems();
            codegenParameter.multipleOf = parameterSchema.getMultipleOf();
            if (codegenParameter.maximum != null || codegenParameter.minimum != null || codegenParameter.maxLength != null || codegenParameter.minLength != null || codegenParameter.maxItems != null || codegenParameter.minItems != null || codegenParameter.pattern != null) {
                codegenParameter.hasValidation = true;
            }
        } else {
            LOGGER.error("ERROR! Not handling  " + parameter + " as Body Parameter at the moment");
        }
        if (parameter instanceof QueryParameter || "query".equalsIgnoreCase(parameter.getIn())) {
            codegenParameter.isQueryParam = true;
        } else if (parameter instanceof PathParameter || "path".equalsIgnoreCase(parameter.getIn())) {
            codegenParameter.required = true;
            codegenParameter.isPathParam = true;
        } else if (parameter instanceof HeaderParameter || "header".equalsIgnoreCase(parameter.getIn())) {
            codegenParameter.isHeaderParam = true;
        } else if (parameter instanceof CookieParameter || "cookie".equalsIgnoreCase(parameter.getIn())) {
            codegenParameter.isCookieParam = true;
        } else {
            LOGGER.warn("Unknown parameter type: " + parameter.getName());
        }
        this.setParameterExampleValue(codegenParameter, parameter);
        this.postProcessParameter(codegenParameter);
        LOGGER.debug("debugging codegenParameter return: " + codegenParameter);
        return codegenParameter;
    }

    protected String getParameterDataType(Parameter parameter, Schema schema) {
        return null;
    }

    public boolean isDataTypeBinary(String dataType) {
        if (dataType != null) {
            return dataType.toLowerCase().startsWith("byte");
        }
        return false;
    }

    public boolean isDataTypeFile(String dataType) {
        if (dataType != null) {
            return dataType.toLowerCase().equals("file");
        }
        return false;
    }

    @Override
    public List<CodegenSecurity> fromSecurity(Map<String, SecurityScheme> securitySchemeMap) {
        if (securitySchemeMap == null) {
            return Collections.emptyList();
        }
        ArrayList<CodegenSecurity> codegenSecurities = new ArrayList<CodegenSecurity>(securitySchemeMap.size());
        for (String key : securitySchemeMap.keySet()) {
            SecurityScheme securityScheme = securitySchemeMap.get(key);
            CodegenSecurity cs = (CodegenSecurity)CodegenModelFactory.newInstance(CodegenModelType.SECURITY);
            cs.name = key;
            cs.type = securityScheme.getType().toString();
            cs.isApplication = cs.isImplicit = Boolean.valueOf(false);
            cs.isPassword = cs.isImplicit;
            cs.isCode = cs.isImplicit;
            if (SecurityScheme.Type.APIKEY.equals((Object)securityScheme.getType())) {
                cs.isBasic = cs.isOAuth = Boolean.valueOf(false);
                cs.isApiKey = true;
                cs.keyParamName = securityScheme.getName();
                cs.isKeyInHeader = securityScheme.getIn() == SecurityScheme.In.HEADER;
                cs.isKeyInQuery = securityScheme.getIn() == SecurityScheme.In.QUERY;
                cs.isKeyInCookie = securityScheme.getIn() == SecurityScheme.In.COOKIE;
            } else if (SecurityScheme.Type.HTTP.equals((Object)securityScheme.getType())) {
                cs.isApiKey = cs.isOAuth = Boolean.valueOf(false);
                cs.isKeyInCookie = cs.isOAuth;
                cs.isKeyInQuery = cs.isOAuth;
                cs.isKeyInHeader = cs.isOAuth;
                cs.isBasic = true;
            } else if (SecurityScheme.Type.OAUTH2.equals((Object)securityScheme.getType())) {
                cs.isApiKey = cs.isBasic = Boolean.valueOf(false);
                cs.isKeyInCookie = cs.isBasic;
                cs.isKeyInQuery = cs.isBasic;
                cs.isKeyInHeader = cs.isBasic;
                cs.isOAuth = true;
                OAuthFlows flows = securityScheme.getFlows();
                if (securityScheme.getFlows() == null) {
                    throw new RuntimeException("missing oauth flow in " + cs.name);
                }
                if (flows.getPassword() != null) {
                    this.setOauth2Info(cs, flows.getPassword());
                    cs.isPassword = true;
                    cs.flow = "password";
                } else if (flows.getImplicit() != null) {
                    this.setOauth2Info(cs, flows.getImplicit());
                    cs.isImplicit = true;
                    cs.flow = "implicit";
                } else if (flows.getClientCredentials() != null) {
                    this.setOauth2Info(cs, flows.getClientCredentials());
                    cs.isApplication = true;
                    cs.flow = "application";
                } else if (flows.getAuthorizationCode() != null) {
                    this.setOauth2Info(cs, flows.getAuthorizationCode());
                    cs.isCode = true;
                    cs.flow = "accessCode";
                } else {
                    throw new RuntimeException("Could not identify any oauth2 flow in " + cs.name);
                }
            }
            codegenSecurities.add(cs);
        }
        Collections.sort(codegenSecurities, new Comparator<CodegenSecurity>(){

            @Override
            public int compare(CodegenSecurity one, CodegenSecurity another) {
                return ObjectUtils.compare((Comparable)((Object)one.name), (Comparable)((Object)another.name));
            }
        });
        Iterator it = codegenSecurities.iterator();
        while (it.hasNext()) {
            CodegenSecurity security = (CodegenSecurity)it.next();
            security.hasMore = it.hasNext();
        }
        return codegenSecurities;
    }

    protected void setReservedWordsLowerCase(List<String> words) {
        this.reservedWords = new HashSet<String>();
        for (String word : words) {
            this.reservedWords.add(word.toLowerCase());
        }
    }

    protected boolean isReservedWord(String word) {
        return word != null && this.reservedWords.contains(word.toLowerCase());
    }

    protected String getOrGenerateOperationId(Operation operation, String path, String httpMethod) {
        String operationId = operation.getOperationId();
        if (StringUtils.isBlank((CharSequence)operationId)) {
            String tmpPath = path;
            tmpPath = tmpPath.replaceAll("\\{", "");
            tmpPath = tmpPath.replaceAll("\\}", "");
            String[] parts = (tmpPath + "/" + httpMethod).split("/");
            StringBuilder builder = new StringBuilder();
            if ("/".equals(tmpPath)) {
                builder.append("root");
            }
            for (String part : parts) {
                if (part.length() <= 0) continue;
                part = builder.toString().length() == 0 ? Character.toLowerCase(part.charAt(0)) + part.substring(1) : this.initialCaps(part);
                builder.append(part);
            }
            operationId = this.sanitizeName(builder.toString());
            LOGGER.warn("Empty operationId found for path: " + httpMethod + " " + path + ". Renamed to auto-generated operationId: " + operationId);
        }
        return operationId;
    }

    protected boolean needToImport(String type) {
        return StringUtils.isNotBlank((CharSequence)type) && !this.defaultIncludes.contains(type) && !this.languageSpecificPrimitives.contains(type);
    }

    protected List<Map<String, Object>> toExamples(Map<String, Object> examples) {
        if (examples == null) {
            return null;
        }
        ArrayList<Map<String, Object>> output = new ArrayList<Map<String, Object>>(examples.size());
        for (Map.Entry<String, Object> entry : examples.entrySet()) {
            HashMap<String, Object> kv = new HashMap<String, Object>();
            kv.put("contentType", entry.getKey());
            kv.put("example", entry.getValue());
            output.add(kv);
        }
        return output;
    }

    private void addHeaders(ApiResponse response, List<CodegenProperty> properties) {
        if (response.getHeaders() != null) {
            for (Map.Entry headers : response.getHeaders().entrySet()) {
                CodegenProperty cp = this.fromProperty((String)headers.getKey(), ((Header)headers.getValue()).getSchema());
                cp.setDescription(this.escapeText(((Header)headers.getValue()).getDescription()));
                cp.setUnescapedDescription(((Header)headers.getValue()).getDescription());
                properties.add(cp);
            }
        }
    }

    private static List<CodegenParameter> addHasMore(List<CodegenParameter> objs) {
        if (objs != null) {
            for (int i = 0; i < objs.size(); ++i) {
                if (i > 0) {
                    objs.get((int)i).secondaryParam = true;
                }
                if (i >= objs.size() - 1) continue;
                objs.get((int)i).hasMore = true;
            }
        }
        return objs;
    }

    @Override
    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        List<CodegenOperation> opList = operations.get(tag);
        if (opList == null) {
            opList = new ArrayList<CodegenOperation>();
            operations.put(tag, opList);
        }
        String uniqueName = co.operationId;
        int counter = 0;
        for (CodegenOperation op : opList) {
            if (!uniqueName.equals(op.operationId)) continue;
            uniqueName = co.operationId + "_" + counter;
            ++counter;
        }
        if (!co.operationId.equals(uniqueName)) {
            LOGGER.warn("generated unique operationId `" + uniqueName + "`");
        }
        co.operationId = uniqueName;
        co.operationIdLowerCase = uniqueName.toLowerCase();
        co.operationIdCamelCase = DefaultCodegen.camelize(uniqueName);
        co.operationIdSnakeCase = DefaultCodegen.underscore(uniqueName);
        opList.add(co);
        co.baseName = tag;
    }

    private void addParentContainer(CodegenModel model, String name, Schema schema) {
        String mappedType;
        CodegenProperty property = this.fromProperty(name, schema);
        this.addImport(model, property.complexType);
        model.parent = this.toInstantiationType(schema);
        String containerType = property.containerType;
        String instantiationType = this.instantiationTypes.get(containerType);
        if (instantiationType != null) {
            this.addImport(model, instantiationType);
        }
        if ((mappedType = this.typeMapping.get(containerType)) != null) {
            this.addImport(model, mappedType);
        }
    }

    public static String underscore(String word) {
        String firstPattern = "([A-Z]+)([A-Z][a-z])";
        String secondPattern = "([a-z\\d])([A-Z])";
        String replacementPattern = "$1_$2";
        word = word.replaceAll("\\.", "/");
        word = word.replaceAll("\\$", "__");
        word = word.replaceAll(firstPattern, replacementPattern);
        word = word.replaceAll(secondPattern, replacementPattern);
        word = word.replace('-', '_');
        word = word.replace(' ', '_');
        word = word.toLowerCase();
        return word;
    }

    protected String dashize(String word) {
        return DefaultCodegen.underscore(word).replaceAll("[_ ]", "-");
    }

    private static String generateNextName(String name) {
        Pattern pattern = Pattern.compile("\\d+\\z");
        Matcher matcher = pattern.matcher(name);
        if (matcher.find()) {
            String numStr = matcher.group();
            int num = Integer.parseInt(numStr) + 1;
            return name.substring(0, name.length() - numStr.length()) + num;
        }
        return name + "2";
    }

    protected void addImport(CodegenModel m, String type) {
        if (type != null && this.needToImport(type)) {
            m.imports.add(type);
        }
    }

    private Map<String, Schema> unaliasPropertySchema(Map<String, Schema> allSchemas, Map<String, Schema> properties) {
        if (properties != null) {
            for (String key : properties.keySet()) {
                properties.put(key, ModelUtils.unaliasSchema(allSchemas, properties.get(key)));
            }
        }
        return properties;
    }

    private void addVars(CodegenModel model, Map<String, Schema> properties, List<String> required) {
        this.addVars(model, properties, required, null, null);
    }

    private void addVars(CodegenModel m, Map<String, Schema> properties, List<String> required, Map<String, Schema> allProperties, List<String> allRequired) {
        m.hasRequired = false;
        if (properties != null && !properties.isEmpty()) {
            m.hasVars = true;
            m.hasEnums = false;
            TreeSet<String> mandatory = required == null ? Collections.emptySet() : new TreeSet<String>(required);
            this.addVars(m, m.vars, properties, mandatory);
            m.mandatory = mandatory;
            m.allMandatory = m.mandatory;
        } else {
            m.emptyVars = true;
            m.hasVars = false;
            m.hasEnums = false;
        }
        if (allProperties != null) {
            TreeSet<String> allMandatory = allRequired == null ? Collections.emptySet() : new TreeSet<String>(allRequired);
            this.addVars(m, m.allVars, allProperties, allMandatory);
            m.allMandatory = allMandatory;
        }
    }

    private void addVars(CodegenModel m, List<CodegenProperty> vars, Map<String, Schema> properties, Set<String> mandatory) {
        ArrayList<Map.Entry<String, Schema>> propertyList = new ArrayList<Map.Entry<String, Schema>>(properties.entrySet());
        int totalCount = propertyList.size();
        for (int i = 0; i < totalCount; ++i) {
            Map.Entry entry = (Map.Entry)propertyList.get(i);
            String key = (String)entry.getKey();
            Schema prop = (Schema)entry.getValue();
            if (prop == null) {
                LOGGER.warn("null property for " + key);
                continue;
            }
            CodegenProperty cp = this.fromProperty(key, prop);
            cp.required = mandatory.contains(key);
            m.hasRequired = m.hasRequired || cp.required;
            boolean bl = m.hasOptional = m.hasOptional || !cp.required;
            if (cp.isEnum) {
                m.hasEnums = true;
            }
            if (!Boolean.TRUE.equals(cp.isReadOnly)) {
                m.hasOnlyReadOnly = false;
            }
            if (i + 1 != totalCount) {
                cp.hasMore = true;
                if (!Boolean.TRUE.equals(((Schema)((Map.Entry)propertyList.get(i + 1)).getValue()).getReadOnly())) {
                    cp.hasMoreNonReadOnly = true;
                }
            }
            if (cp.isContainer) {
                this.addImport(m, this.typeMapping.get("array"));
            }
            this.addImport(m, cp.baseType);
            CodegenProperty innerCp = cp;
            while (innerCp != null) {
                this.addImport(m, innerCp.complexType);
                innerCp = innerCp.items;
            }
            vars.add(cp);
            if (Boolean.TRUE.equals(cp.required)) {
                m.requiredVars.add(cp);
            } else {
                m.optionalVars.add(cp);
            }
            if (Boolean.TRUE.equals(cp.isReadOnly)) {
                m.readOnlyVars.add(cp);
                continue;
            }
            m.readWriteVars.add(cp);
        }
    }

    private static Map<String, String> getAllAliases(Map<String, Schema> schemas) {
        if (schemas == null || schemas.isEmpty()) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> aliases = new HashMap<String, String>();
        for (Map.Entry<String, Schema> entry : schemas.entrySet()) {
            String oasName = entry.getKey();
            Schema schema = entry.getValue();
            String schemaType = DefaultCodegen.getPrimitiveType(schema);
            if (schemaType == null || schemaType.equals("object") || schemaType.equals("array") || schema.getEnum() != null || ModelUtils.isMapSchema(schema)) continue;
            aliases.put(oasName, schemaType);
        }
        return aliases;
    }

    public String removeNonNameElementToCamelCase(String name) {
        return this.removeNonNameElementToCamelCase(name, "[-_:;#]");
    }

    protected String removeNonNameElementToCamelCase(String name, String nonNameElementPattern) {
        String result = Arrays.stream(name.split(nonNameElementPattern)).map(StringUtils::capitalize).collect(Collectors.joining(""));
        if (result.length() > 0) {
            result = result.substring(0, 1).toLowerCase() + result.substring(1);
        }
        return result;
    }

    public static String camelize(String word) {
        return DefaultCodegen.camelize(word, false);
    }

    public static String camelize(String word, boolean lowercaseFirstLetter) {
        Pattern p = Pattern.compile("\\/(.?)");
        Matcher m = p.matcher(word);
        while (m.find()) {
            word = m.replaceFirst("." + m.group(1));
            m = p.matcher(word);
        }
        String[] parts = word.split("\\.");
        StringBuilder f = new StringBuilder();
        for (String z : parts) {
            if (z.length() <= 0) continue;
            f.append(Character.toUpperCase(z.charAt(0))).append(z.substring(1));
        }
        word = f.toString();
        m = p.matcher(word);
        while (m.find()) {
            word = m.replaceFirst("" + Character.toUpperCase(m.group(1).charAt(0)) + m.group(1).substring(1));
            m = p.matcher(word);
        }
        p = Pattern.compile("(\\.?)(\\w)([^\\.]*)$");
        m = p.matcher(word);
        if (m.find()) {
            String rep = m.group(1) + m.group(2).toUpperCase() + m.group(3);
            rep = rep.replaceAll("\\$", "\\\\\\$");
            word = m.replaceAll(rep);
        }
        p = Pattern.compile("(_)(.)");
        m = p.matcher(word);
        while (m.find()) {
            String upperCase;
            String original = m.group(2);
            word = original.equals(upperCase = original.toUpperCase()) ? word.replaceFirst("_", "") : m.replaceFirst(upperCase);
            m = p.matcher(word);
        }
        p = Pattern.compile("(-)(.)");
        m = p.matcher(word);
        while (m.find()) {
            word = m.replaceFirst(m.group(2).toUpperCase());
            m = p.matcher(word);
        }
        if (lowercaseFirstLetter && word.length() > 0) {
            int i = 0;
            char charAt = word.charAt(i);
            while (!(i + 1 >= word.length() || charAt >= 'a' && charAt <= 'z' || charAt >= 'A' && charAt <= 'Z')) {
                charAt = word.charAt(++i);
            }
            word = word.substring(0, ++i).toLowerCase() + word.substring(i);
        }
        word = word.replaceAll("_", "");
        return word;
    }

    @Override
    public String apiFilename(String templateName, String tag) {
        String suffix = this.apiTemplateFiles().get(templateName);
        return this.apiFileFolder() + File.separator + this.toApiFilename(tag) + suffix;
    }

    @Override
    public String apiDocFilename(String templateName, String tag) {
        String docExtension = this.getDocExtension();
        String suffix = docExtension != null ? docExtension : this.apiDocTemplateFiles().get(templateName);
        return this.apiDocFileFolder() + File.separator + this.toApiDocFilename(tag) + suffix;
    }

    @Override
    public String apiTestFilename(String templateName, String tag) {
        String suffix = this.apiTestTemplateFiles().get(templateName);
        return this.apiTestFileFolder() + File.separator + this.toApiTestFilename(tag) + suffix;
    }

    @Override
    public boolean shouldOverwrite(String filename) {
        return !this.skipOverwrite || !new File(filename).exists();
    }

    @Override
    public boolean isSkipOverwrite() {
        return this.skipOverwrite;
    }

    @Override
    public void setSkipOverwrite(boolean skipOverwrite) {
        this.skipOverwrite = skipOverwrite;
    }

    @Override
    public boolean isRemoveOperationIdPrefix() {
        return this.removeOperationIdPrefix;
    }

    @Override
    public void setRemoveOperationIdPrefix(boolean removeOperationIdPrefix) {
        this.removeOperationIdPrefix = removeOperationIdPrefix;
    }

    @Override
    public boolean isHideGenerationTimestamp() {
        return this.hideGenerationTimestamp;
    }

    @Override
    public void setHideGenerationTimestamp(boolean hideGenerationTimestamp) {
        this.hideGenerationTimestamp = hideGenerationTimestamp;
    }

    @Override
    public Map<String, String> supportedLibraries() {
        return this.supportedLibraries;
    }

    @Override
    public void setLibrary(String library) {
        if (library != null && !this.supportedLibraries.containsKey(library)) {
            StringBuilder sb = new StringBuilder("Unknown library: " + library + "\nAvailable libraries:");
            if (this.supportedLibraries.size() == 0) {
                sb.append("\n  ").append("NONE");
            } else {
                for (String lib : this.supportedLibraries.keySet()) {
                    sb.append("\n  ").append(lib);
                }
            }
            throw new RuntimeException(sb.toString());
        }
        this.library = library;
    }

    @Override
    public String getLibrary() {
        return this.library;
    }

    @Override
    public void setGitUserId(String gitUserId) {
        this.gitUserId = gitUserId;
    }

    @Override
    public String getGitUserId() {
        return this.gitUserId;
    }

    @Override
    public void setGitRepoId(String gitRepoId) {
        this.gitRepoId = gitRepoId;
    }

    @Override
    public String getGitRepoId() {
        return this.gitRepoId;
    }

    @Override
    public void setReleaseNote(String releaseNote) {
        this.releaseNote = releaseNote;
    }

    @Override
    public String getReleaseNote() {
        return this.releaseNote;
    }

    @Override
    public String getDocExtension() {
        return this.docExtension;
    }

    @Override
    public void setDocExtension(String userDocExtension) {
        this.docExtension = userDocExtension;
    }

    @Override
    public void setHttpUserAgent(String httpUserAgent) {
        this.httpUserAgent = httpUserAgent;
    }

    @Override
    public String getHttpUserAgent() {
        return this.httpUserAgent;
    }

    protected CliOption buildLibraryCliOption(Map<String, String> supportedLibraries) {
        StringBuilder sb = new StringBuilder("library template (sub-template) to use:");
        for (String lib : supportedLibraries.keySet()) {
            sb.append("\n").append(lib).append(" - ").append(supportedLibraries.get(lib));
        }
        return new CliOption("library", sb.toString());
    }

    @Override
    public String sanitizeName(String name) {
        return this.sanitizeName(name, "\\W");
    }

    public String sanitizeName(String name, String removeCharRegEx) {
        if (name == null) {
            LOGGER.error("String to be sanitized is null. Default to ERROR_UNKNOWN");
            return "ERROR_UNKNOWN";
        }
        if ("$".equals(name)) {
            return "value";
        }
        name = name.replaceAll("\\[\\]", "");
        name = name.replaceAll("\\[", "_");
        name = name.replaceAll("\\]", "");
        name = name.replaceAll("\\(", "_");
        name = name.replaceAll("\\)", "");
        name = name.replaceAll("\\.", "_");
        name = name.replaceAll("-", "_");
        name = name.replace("|", "_");
        name = name.replaceAll(" ", "_");
        name = this.allowUnicodeIdentifiers != false ? Pattern.compile(removeCharRegEx, 256).matcher(name).replaceAll("") : name.replaceAll(removeCharRegEx, "");
        return name;
    }

    @Override
    public String sanitizeTag(String tag) {
        if ((tag = DefaultCodegen.camelize(this.sanitizeName(tag))).matches("^\\d.*")) {
            tag = "Class" + tag;
        }
        return tag;
    }

    public void writeOptional(String outputFolder, SupportingFile supportingFile) {
        String folder = "";
        if (outputFolder != null && !"".equals(outputFolder)) {
            folder = folder + outputFolder + File.separator;
        }
        if (!new File(folder = !"".equals(folder = folder + supportingFile.folder) ? folder + File.separator + supportingFile.destinationFilename : supportingFile.destinationFilename).exists()) {
            this.supportingFiles.add(supportingFile);
        } else {
            LOGGER.info("Skipped overwriting " + supportingFile.destinationFilename + " as the file already exists in " + folder);
        }
    }

    public void setParameterBooleanFlagWithCodegenProperty(CodegenParameter parameter, CodegenProperty property) {
        if (parameter == null) {
            LOGGER.error("Codegen Parameter cannot be null.");
            return;
        }
        if (property == null) {
            LOGGER.error("Codegen Property cannot be null.");
            return;
        }
        if (Boolean.TRUE.equals(property.isUuid) && Boolean.TRUE.equals(property.isString)) {
            parameter.isUuid = true;
        } else if (Boolean.TRUE.equals(property.isByteArray)) {
            parameter.isByteArray = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isBinary)) {
            parameter.isBinary = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isString)) {
            parameter.isString = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isBoolean)) {
            parameter.isBoolean = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isLong)) {
            parameter.isLong = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isInteger)) {
            parameter.isInteger = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isDouble)) {
            parameter.isDouble = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isFloat)) {
            parameter.isFloat = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isNumber)) {
            parameter.isNumber = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isDate)) {
            parameter.isDate = true;
            parameter.isPrimitiveType = true;
        } else if (Boolean.TRUE.equals(property.isDateTime)) {
            parameter.isDateTime = true;
            parameter.isPrimitiveType = true;
        } else {
            LOGGER.debug("Property type is not primitive: " + property.dataType);
        }
        if (Boolean.TRUE.equals(property.isFile)) {
            parameter.isFile = true;
        }
    }

    public void updateCodegenPropertyEnum(CodegenProperty var) {
        Map<String, Object> allowableValues = var.allowableValues;
        if (var.items != null) {
            allowableValues = var.items.allowableValues;
        }
        if (allowableValues == null) {
            return;
        }
        List values = (List)allowableValues.get("values");
        if (values == null) {
            return;
        }
        ArrayList<Map<String, Boolean>> enumVars = new ArrayList<Map<String, Boolean>>();
        String commonPrefix = this.findCommonPrefixOfVars(values);
        int truncateIdx = commonPrefix.length();
        for (Object value : values) {
            String enumName;
            Map<String, Boolean> enumVar = new HashMap<String, String>();
            if (truncateIdx == 0) {
                enumName = value.toString();
            } else {
                enumName = value.toString().substring(truncateIdx);
                if ("".equals(enumName)) {
                    enumName = value.toString();
                }
            }
            String dataType = var.mostInnerItems != null ? var.mostInnerItems.dataType : var.dataType;
            enumVar.put("name", (Boolean)((Object)this.toEnumVarName(enumName, dataType)));
            enumVar.put("value", (Boolean)((Object)this.toEnumValue(value.toString(), dataType)));
            enumVar.put("isString", this.isDataTypeString(dataType));
            enumVars.add(enumVar);
        }
        allowableValues.put("enumVars", enumVars);
        if (var.defaultValue != null) {
            String enumName = null;
            for (Map<String, Boolean> enumVar : enumVars) {
                if (!this.toEnumValue(var.defaultValue, var.dataType).equals(enumVar.get("value"))) continue;
                enumName = (String)enumVar.get("name");
                break;
            }
            if (enumName != null) {
                var.defaultValue = this.toEnumDefaultValue(enumName, var.datatypeWithEnum);
            }
        }
    }

    public String addRegularExpressionDelimiter(String pattern) {
        if (StringUtils.isEmpty((CharSequence)pattern)) {
            return pattern;
        }
        if (!pattern.matches("^/.*")) {
            return "/" + pattern.replaceAll("/", "\\\\/") + "/";
        }
        return pattern;
    }

    public boolean convertPropertyToBooleanAndWriteBack(String propertyKey) {
        boolean booleanValue = false;
        if (this.additionalProperties.containsKey(propertyKey)) {
            booleanValue = this.convertPropertyToBoolean(propertyKey);
            this.writePropertyBack(propertyKey, booleanValue);
        }
        return booleanValue;
    }

    @Override
    public String getIgnoreFilePathOverride() {
        return this.ignoreFilePathOverride;
    }

    @Override
    public void setIgnoreFilePathOverride(String ignoreFileOverride) {
        this.ignoreFilePathOverride = ignoreFileOverride;
    }

    public boolean convertPropertyToBoolean(String propertyKey) {
        boolean booleanValue = false;
        if (this.additionalProperties.containsKey(propertyKey)) {
            booleanValue = Boolean.valueOf(this.additionalProperties.get(propertyKey).toString());
        }
        return booleanValue;
    }

    public void writePropertyBack(String propertyKey, boolean value) {
        this.additionalProperties.put(propertyKey, value);
    }

    protected String getContentType(RequestBody requestBody) {
        if (requestBody == null || requestBody.getContent() == null || requestBody.getContent().isEmpty()) {
            return null;
        }
        return (String)new ArrayList(requestBody.getContent().keySet()).get(0);
    }

    protected Parameter getParameterFromRef(String ref, OpenAPI openAPI) {
        String parameterName = ref.substring(ref.lastIndexOf(47) + 1);
        Map parameterMap = openAPI.getComponents().getParameters();
        return (Parameter)parameterMap.get(parameterName);
    }

    private void setOauth2Info(CodegenSecurity codegenSecurity, OAuthFlow flow) {
        codegenSecurity.authorizationUrl = flow.getAuthorizationUrl();
        codegenSecurity.tokenUrl = flow.getTokenUrl();
        if (flow.getScopes() != null && !flow.getScopes().isEmpty()) {
            ArrayList<Map<String, Object>> scopes = new ArrayList<Map<String, Object>>();
            int count = 0;
            int numScopes = flow.getScopes().size();
            for (Map.Entry scopeEntry : flow.getScopes().entrySet()) {
                HashMap scope = new HashMap();
                scope.put("scope", scopeEntry.getKey());
                scope.put("description", this.escapeText((String)scopeEntry.getValue()));
                if (++count < numScopes) {
                    scope.put("hasMore", "true");
                } else {
                    scope.put("hasMore", null);
                }
                scopes.add(scope);
            }
            codegenSecurity.scopes = scopes;
        }
    }

    private List<Schema> getInterfaces(ComposedSchema composed) {
        if (composed.getAllOf() != null && !composed.getAllOf().isEmpty()) {
            return composed.getAllOf();
        }
        if (composed.getAnyOf() != null && !composed.getAnyOf().isEmpty()) {
            return composed.getAnyOf();
        }
        if (composed.getOneOf() != null && !composed.getOneOf().isEmpty()) {
            return composed.getOneOf();
        }
        return null;
    }

    private void addConsumesInfo(OpenAPI openAPI, Operation operation, CodegenOperation codegenOperation) {
        RequestBody requestBody = ModelUtils.getReferencedRequestBody(openAPI, operation.getRequestBody());
        if (requestBody == null || requestBody.getContent() == null || requestBody.getContent().isEmpty()) {
            return;
        }
        Set consumes = requestBody.getContent().keySet();
        ArrayList<Map<String, String>> mediaTypeList = new ArrayList<Map<String, String>>();
        int count = 0;
        for (String key : consumes) {
            HashMap<String, String> mediaType = new HashMap<String, String>();
            if ("*/*".equals(key)) continue;
            mediaType.put("mediaType", this.escapeText(this.escapeQuotationMark(key)));
            if (++count < consumes.size()) {
                mediaType.put("hasMore", "true");
            } else {
                mediaType.put("hasMore", null);
            }
            mediaTypeList.add(mediaType);
        }
        if (!mediaTypeList.isEmpty()) {
            codegenOperation.consumes = mediaTypeList;
            codegenOperation.hasConsumes = true;
        }
    }

    public static Set<String> getConsumesInfo(OpenAPI openAPI, Operation operation) {
        RequestBody requestBody = ModelUtils.getReferencedRequestBody(openAPI, operation.getRequestBody());
        if (requestBody == null || requestBody.getContent() == null || requestBody.getContent().isEmpty()) {
            return Collections.emptySet();
        }
        return requestBody.getContent().keySet();
    }

    public boolean hasFormParameter(OpenAPI openAPI, Operation operation) {
        Set<String> consumesInfo = DefaultCodegen.getConsumesInfo(openAPI, operation);
        if (consumesInfo == null || consumesInfo.isEmpty()) {
            return false;
        }
        for (String consume : consumesInfo) {
            if (!"application/x-www-form-urlencoded".equalsIgnoreCase(consume) && !"multipart/form-data".equalsIgnoreCase(consume)) continue;
            return true;
        }
        return false;
    }

    public boolean hasBodyParameter(OpenAPI openAPI, Operation operation) {
        RequestBody requestBody = ModelUtils.getReferencedRequestBody(openAPI, operation.getRequestBody());
        if (requestBody == null) {
            return false;
        }
        Schema schema = ModelUtils.getSchemaFromRequestBody(requestBody);
        return ModelUtils.getReferencedSchema(openAPI, schema) != null;
    }

    private void addProducesInfo(OpenAPI openAPI, ApiResponse inputResponse, CodegenOperation codegenOperation) {
        ApiResponse response = ModelUtils.getReferencedApiResponse(openAPI, inputResponse);
        if (response == null || response.getContent() == null || response.getContent().isEmpty()) {
            return;
        }
        Set produces = response.getContent().keySet();
        if (codegenOperation.produces == null) {
            codegenOperation.produces = new ArrayList<Map<String, String>>();
        }
        HashSet<String> existingMediaTypes = new HashSet<String>();
        for (Map<String, String> mediaType : codegenOperation.produces) {
            existingMediaTypes.add(mediaType.get("mediaType"));
        }
        int count = 0;
        for (String key : produces) {
            String encodedKey = "*/*".equals(key) ? key : this.escapeText(this.escapeQuotationMark(key));
            if (existingMediaTypes.contains(encodedKey)) continue;
            HashMap<String, String> mediaType = new HashMap<String, String>();
            mediaType.put("mediaType", encodedKey);
            if (++count < produces.size()) {
                mediaType.put("hasMore", "true");
            } else {
                mediaType.put("hasMore", null);
            }
            if (!codegenOperation.produces.isEmpty()) {
                Map<String, String> lastMediaType = codegenOperation.produces.get(codegenOperation.produces.size() - 1);
                lastMediaType.put("hasMore", "true");
            }
            codegenOperation.produces.add(mediaType);
            codegenOperation.hasProduces = Boolean.TRUE;
        }
    }

    public static Set<String> getProducesInfo(OpenAPI openAPI, Operation operation) {
        if (operation.getResponses() == null || operation.getResponses().isEmpty()) {
            return null;
        }
        TreeSet<String> produces = new TreeSet<String>();
        for (ApiResponse r : operation.getResponses().values()) {
            ApiResponse response = ModelUtils.getReferencedApiResponse(openAPI, r);
            if (response.getContent() == null) continue;
            produces.addAll(response.getContent().keySet());
        }
        return produces;
    }

    protected String getParentName(ComposedSchema composedSchema, Map<String, Schema> allSchemas) {
        if (composedSchema.getAllOf() != null && !composedSchema.getAllOf().isEmpty()) {
            Schema schema = (Schema)composedSchema.getAllOf().get(0);
            String ref = schema.get$ref();
            if (StringUtils.isBlank((CharSequence)ref)) {
                return null;
            }
            return ModelUtils.getSimpleRef(ref);
        }
        return null;
    }

    protected String getCollectionFormat(Parameter parameter) {
        if (Parameter.StyleEnum.FORM.equals((Object)parameter.getStyle())) {
            if (Boolean.TRUE.equals(parameter.getExplode())) {
                return "multi";
            }
            return "csv";
        }
        if (Parameter.StyleEnum.SIMPLE.equals((Object)parameter.getStyle())) {
            return "csv";
        }
        if (Parameter.StyleEnum.PIPEDELIMITED.equals((Object)parameter.getStyle())) {
            return "pipe";
        }
        if (Parameter.StyleEnum.SPACEDELIMITED.equals((Object)parameter.getStyle())) {
            return "space";
        }
        return null;
    }

    @Override
    public CodegenType getTag() {
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String getHelp() {
        return null;
    }

    public List<CodegenParameter> fromRequestBodyToFormParameters(RequestBody body, Map<String, Schema> schemas, Set<String> imports) {
        ArrayList<CodegenParameter> parameters = new ArrayList<CodegenParameter>();
        LOGGER.debug("debugging fromRequestBodyToFormParameters= " + body);
        Schema schema = ModelUtils.getSchemaFromRequestBody(body);
        if (StringUtils.isNotBlank((CharSequence)schema.get$ref())) {
            schema = schemas.get(ModelUtils.getSimpleRef(schema.get$ref()));
        }
        if (schema.getProperties() != null && !schema.getProperties().isEmpty()) {
            Map properties = schema.getProperties();
            for (Map.Entry entry : properties.entrySet()) {
                CodegenParameter codegenParameter = (CodegenParameter)CodegenModelFactory.newInstance(CodegenModelType.PARAMETER);
                CharSequence collectionFormat = null;
                Schema s = (Schema)entry.getValue();
                if (ModelUtils.isArraySchema(s)) {
                    CodegenProperty codegenProperty;
                    ArraySchema arraySchema = (ArraySchema)s;
                    Schema inner = arraySchema.getItems();
                    if (inner == null) {
                        LOGGER.warn("warning! No inner type supplied for array parameter \"" + s.getName() + "\", using String");
                        inner = new StringSchema().description("//TODO automatically added by openapi-generator due to missing iner type definition in the spec");
                        arraySchema.setItems(inner);
                    }
                    codegenParameter = this.fromFormProperty((String)entry.getKey(), inner, imports);
                    codegenParameter.items = codegenProperty = this.fromProperty("inner", inner);
                    codegenParameter.mostInnerItems = codegenProperty.mostInnerItems;
                    codegenParameter.baseType = codegenProperty.dataType;
                    codegenParameter.isPrimitiveType = false;
                    codegenParameter.isContainer = true;
                    codegenParameter.isListContainer = true;
                    codegenParameter.description = s.getDescription();
                    codegenParameter.dataType = this.getTypeDeclaration(s);
                    if (codegenParameter.baseType != null && codegenParameter.enumName != null) {
                        codegenParameter.datatypeWithEnum = codegenParameter.dataType.replace(codegenParameter.baseType, codegenParameter.enumName);
                    } else {
                        LOGGER.warn("Could not compute datatypeWithEnum from " + codegenParameter.baseType + ", " + codegenParameter.enumName);
                    }
                    CharSequence charSequence = codegenParameter.collectionFormat = StringUtils.isEmpty(collectionFormat) ? "csv" : collectionFormat;
                    while (codegenProperty != null) {
                        imports.add(codegenProperty.baseType);
                        codegenProperty = codegenProperty.items;
                    }
                } else {
                    if (ModelUtils.isMapSchema(s)) {
                        LOGGER.error("Map of form parameters not supported. Please report the issue to https://github.com/openapitools/openapi-generator if you need help.");
                        continue;
                    }
                    codegenParameter = this.fromFormProperty((String)entry.getKey(), (Schema)entry.getValue(), imports);
                }
                if (!codegenParameter.required && schema.getRequired() != null) {
                    codegenParameter.required = schema.getRequired().contains(entry.getKey());
                }
                parameters.add(codegenParameter);
            }
        }
        return parameters;
    }

    public CodegenParameter fromFormProperty(String name, Schema propertySchema, Set<String> imports) {
        CodegenParameter codegenParameter = (CodegenParameter)CodegenModelFactory.newInstance(CodegenModelType.PARAMETER);
        LOGGER.debug("Debugging fromFormProperty: " + name);
        CodegenProperty codegenProperty = this.fromProperty(name, propertySchema);
        codegenParameter.isFormParam = Boolean.TRUE;
        codegenParameter.baseName = codegenProperty.baseName;
        codegenParameter.paramName = this.toParamName(codegenParameter.baseName);
        codegenParameter.baseType = codegenProperty.baseType;
        codegenParameter.dataType = codegenProperty.dataType;
        codegenParameter.dataFormat = codegenProperty.dataFormat;
        codegenParameter.description = this.escapeText(codegenProperty.description);
        codegenParameter.unescapedDescription = codegenProperty.getDescription();
        codegenParameter.jsonSchema = Json.pretty((Object)propertySchema);
        codegenParameter.defaultValue = codegenProperty.getDefaultValue();
        if (codegenProperty.getVendorExtensions() != null && !codegenProperty.getVendorExtensions().isEmpty()) {
            codegenParameter.vendorExtensions = codegenProperty.getVendorExtensions();
        }
        if (propertySchema.getRequired() != null && !propertySchema.getRequired().isEmpty() && propertySchema.getRequired().contains(codegenProperty.baseName)) {
            codegenParameter.required = Boolean.TRUE;
        }
        this.updateCodegenPropertyEnum(codegenProperty);
        codegenParameter.isEnum = codegenProperty.isEnum;
        codegenParameter._enum = codegenProperty._enum;
        codegenParameter.allowableValues = codegenProperty.allowableValues;
        if (codegenProperty.isEnum) {
            codegenParameter.datatypeWithEnum = codegenProperty.datatypeWithEnum;
            codegenParameter.enumName = codegenProperty.enumName;
        }
        if (codegenProperty.items != null && codegenProperty.items.isEnum) {
            codegenParameter.items = codegenProperty.items;
            codegenParameter.mostInnerItems = codegenProperty.mostInnerItems;
        }
        if (codegenProperty.complexType != null) {
            imports.add(codegenProperty.complexType);
        }
        if (ModelUtils.isIntegerSchema(propertySchema)) {
            codegenParameter.maximum = propertySchema.getMaximum() == null ? null : String.valueOf(propertySchema.getMaximum().longValue());
            codegenParameter.minimum = propertySchema.getMinimum() == null ? null : String.valueOf(propertySchema.getMinimum().longValue());
        } else {
            codegenParameter.maximum = propertySchema.getMaximum() == null ? null : String.valueOf(propertySchema.getMaximum());
            codegenParameter.minimum = propertySchema.getMinimum() == null ? null : String.valueOf(propertySchema.getMinimum());
        }
        codegenParameter.exclusiveMaximum = propertySchema.getExclusiveMaximum() == null ? false : propertySchema.getExclusiveMaximum();
        codegenParameter.exclusiveMinimum = propertySchema.getExclusiveMinimum() == null ? false : propertySchema.getExclusiveMinimum();
        codegenParameter.maxLength = propertySchema.getMaxLength();
        codegenParameter.minLength = propertySchema.getMinLength();
        codegenParameter.pattern = this.toRegularExpression(propertySchema.getPattern());
        codegenParameter.maxItems = propertySchema.getMaxItems();
        codegenParameter.minItems = propertySchema.getMinItems();
        codegenParameter.uniqueItems = propertySchema.getUniqueItems() == null ? false : propertySchema.getUniqueItems();
        codegenParameter.multipleOf = propertySchema.getMultipleOf();
        if (codegenParameter.maximum != null || codegenParameter.minimum != null || codegenParameter.maxLength != null || codegenParameter.minLength != null || codegenParameter.maxItems != null || codegenParameter.minItems != null || codegenParameter.pattern != null) {
            codegenParameter.hasValidation = true;
        }
        this.setParameterBooleanFlagWithCodegenProperty(codegenParameter, codegenProperty);
        this.setParameterExampleValue(codegenParameter);
        return codegenParameter;
    }

    public CodegenParameter fromRequestBody(RequestBody body, Map<String, Schema> schemas, Set<String> imports, String bodyParameterName) {
        if (body == null) {
            LOGGER.error("body in fromRequestBody cannot be null!");
        }
        CodegenParameter codegenParameter = (CodegenParameter)CodegenModelFactory.newInstance(CodegenModelType.PARAMETER);
        codegenParameter.baseName = "UNKNOWN_BASE_NAME";
        codegenParameter.paramName = "UNKNOWN_PARAM_NAME";
        codegenParameter.description = body.getDescription();
        codegenParameter.required = body.getRequired() != null ? body.getRequired() : Boolean.FALSE;
        codegenParameter.isBodyParam = Boolean.TRUE;
        String name = null;
        LOGGER.debug("Request body = " + body);
        Schema schema = ModelUtils.getSchemaFromRequestBody(body);
        if (StringUtils.isNotBlank((CharSequence)schema.get$ref())) {
            name = ModelUtils.getSimpleRef(schema.get$ref());
            schema = schemas.get(name);
        }
        if (ModelUtils.isMapSchema(schema)) {
            Schema inner = (Schema)schema.getAdditionalProperties();
            if (inner == null) {
                inner = new StringSchema().description("//TODO automatically added by openapi-generator");
                schema.setAdditionalProperties((Object)inner);
            }
            CodegenProperty codegenProperty = this.fromProperty("property", schema);
            imports.add(codegenProperty.baseType);
            codegenParameter.baseName = StringUtils.isEmpty((CharSequence)bodyParameterName) ? "request_body" : bodyParameterName;
            codegenParameter.paramName = this.toParamName(codegenParameter.baseName);
            codegenParameter.items = codegenProperty.items;
            codegenParameter.mostInnerItems = codegenProperty.mostInnerItems;
            codegenParameter.dataType = this.getTypeDeclaration(schema);
            codegenParameter.baseType = this.getSchemaType(inner);
            codegenParameter.isContainer = Boolean.TRUE;
            codegenParameter.isMapContainer = Boolean.TRUE;
            this.setParameterBooleanFlagWithCodegenProperty(codegenParameter, codegenProperty);
        } else if (ModelUtils.isArraySchema(schema)) {
            CodegenProperty innerCp;
            ArraySchema arraySchema = (ArraySchema)schema;
            Schema inner = arraySchema.getItems();
            if (inner == null) {
                inner = new StringSchema().description("//TODO automatically added by openapi-generator");
                arraySchema.setItems(inner);
            }
            CodegenProperty codegenProperty = this.fromProperty("property", schema);
            imports.add(codegenProperty.baseType);
            CodegenProperty mostInnerItem = innerCp = codegenProperty;
            while (innerCp != null) {
                if (innerCp.complexType != null) {
                    imports.add(innerCp.complexType);
                }
                mostInnerItem = innerCp;
                innerCp = innerCp.items;
            }
            codegenParameter.baseName = StringUtils.isEmpty((CharSequence)bodyParameterName) ? mostInnerItem.complexType : bodyParameterName;
            codegenParameter.paramName = this.toArrayModelParamName(codegenParameter.baseName);
            codegenParameter.items = codegenProperty.items;
            codegenParameter.mostInnerItems = codegenProperty.mostInnerItems;
            codegenParameter.dataType = this.getTypeDeclaration((Schema)arraySchema);
            codegenParameter.baseType = this.getSchemaType((Schema)arraySchema);
            codegenParameter.isContainer = Boolean.TRUE;
            codegenParameter.isListContainer = Boolean.TRUE;
            this.setParameterBooleanFlagWithCodegenProperty(codegenParameter, codegenProperty);
            while (codegenProperty != null) {
                imports.add(codegenProperty.baseType);
                codegenProperty = codegenProperty.items;
            }
        } else if (ModelUtils.isObjectSchema(schema) || ModelUtils.isComposedSchema(schema)) {
            CodegenModel codegenModel = null;
            if (StringUtils.isNotBlank((CharSequence)name)) {
                schema.setName(name);
                codegenModel = this.fromModel(name, schema, schemas);
            }
            if (codegenModel != null && !codegenModel.emptyVars) {
                codegenParameter.baseName = StringUtils.isEmpty((CharSequence)bodyParameterName) ? codegenModel.classname : bodyParameterName;
                codegenParameter.paramName = this.toParamName(codegenParameter.baseName);
                codegenParameter.baseType = codegenModel.classname;
                codegenParameter.dataType = this.getTypeDeclaration(codegenModel.classname);
                codegenParameter.description = codegenModel.description;
                imports.add(codegenParameter.baseType);
            } else {
                CodegenProperty codegenProperty = this.fromProperty("property", schema);
                if (schema.getAdditionalProperties() != null) {
                    LOGGER.error("Map should be supported. Please report to openapi-generator github repo about the issue.");
                } else if (codegenProperty != null) {
                    String codegenModelDescription;
                    String codegenModelName;
                    if (codegenModel != null) {
                        codegenModelName = codegenModel.classname;
                        codegenModelDescription = codegenModel.description;
                    } else {
                        LOGGER.warn("The following schema has undefined (null) baseType. It could be due to form parameter defined in OpenAPI v2 spec with incorrect consumes. A correct 'consumes' for form parameters should be 'application/x-www-form-urlencoded' or 'multipart/form-data'");
                        LOGGER.warn("schema: " + schema);
                        LOGGER.warn("codegenModel is null. Default to UNKNOWN_BASE_TYPE");
                        codegenModelName = "UNKNOWN_BASE_TYPE";
                        codegenModelDescription = "UNKNOWN_DESCRIPTION";
                    }
                    codegenParameter.baseName = StringUtils.isEmpty((CharSequence)bodyParameterName) ? codegenModelName : bodyParameterName;
                    codegenParameter.paramName = this.toParamName(codegenParameter.baseName);
                    codegenParameter.baseType = codegenModelName;
                    codegenParameter.dataType = this.getTypeDeclaration(codegenModelName);
                    codegenParameter.description = codegenModelDescription;
                    imports.add(codegenParameter.baseType);
                    if (codegenProperty.complexType != null) {
                        imports.add(codegenProperty.complexType);
                    }
                }
                this.setParameterBooleanFlagWithCodegenProperty(codegenParameter, codegenProperty);
            }
        } else {
            CodegenProperty codegenProperty = this.fromProperty("PRIMITIVE_REQUEST_BODY", schema);
            if (codegenProperty != null) {
                codegenParameter.baseName = StringUtils.isEmpty((CharSequence)bodyParameterName) ? "body" : bodyParameterName;
                codegenParameter.isPrimitiveType = true;
                codegenParameter.baseType = codegenProperty.baseType;
                codegenParameter.dataType = codegenProperty.dataType;
                codegenParameter.description = codegenProperty.description;
                codegenParameter.paramName = this.toParamName(codegenParameter.baseName);
                if (codegenProperty.complexType != null) {
                    imports.add(codegenProperty.complexType);
                }
            }
            this.setParameterBooleanFlagWithCodegenProperty(codegenParameter, codegenProperty);
        }
        this.setParameterExampleValue(codegenParameter, body);
        return codegenParameter;
    }

    protected void addOption(String key, String description, String defaultValue) {
        CliOption option = new CliOption(key, description);
        if (defaultValue != null) {
            option.defaultValue(defaultValue);
        }
        this.cliOptions.add(option);
    }

    protected void addSwitch(String key, String description, Boolean defaultValue) {
        CliOption option = CliOption.newBoolean(key, description);
        if (defaultValue != null) {
            option.defaultValue(defaultValue.toString());
        }
        this.cliOptions.add(option);
    }

    public void generateJSONSpecFile(Map<String, Object> objs) {
        OpenAPI openAPI = (OpenAPI)objs.get("openAPI");
        if (openAPI != null) {
            try {
                objs.put("openapi-json", Json.pretty().writeValueAsString((Object)openAPI).replace("\r\n", "\n"));
            }
            catch (JsonProcessingException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void generateYAMLSpecFile(Map<String, Object> objs) {
        OpenAPI openAPI = (OpenAPI)objs.get("openAPI");
        String yaml = SerializerUtils.toYamlString(openAPI);
        if (yaml != null) {
            objs.put("openapi-yaml", yaml);
        }
    }

    public boolean isDataTypeString(String dataType) {
        return "String".equals(dataType);
    }
}

