/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractTypeScriptClientCodegen;

public class TypeScriptAureliaClientCodegen
extends AbstractTypeScriptClientCodegen {
    public static final String NPM_NAME = "npmName";
    public static final String NPM_VERSION = "npmVersion";
    protected String npmName = null;
    protected String npmVersion = "1.0.0";

    public TypeScriptAureliaClientCodegen() {
        this.apiTemplateFiles.put("api.mustache", ".ts");
        this.importMapping.clear();
        this.outputFolder = "generated-code/typescript-aurelia";
        this.templateDir = "typescript-aurelia";
        this.embeddedTemplateDir = "typescript-aurelia";
        this.cliOptions.add(new CliOption(NPM_NAME, "The name under which you want to publish generated npm package"));
        this.cliOptions.add(new CliOption(NPM_VERSION, "The version of your npm package"));
    }

    @Override
    public String getName() {
        return "typescript-aurelia";
    }

    @Override
    public String getHelp() {
        return "Generates a TypeScript client library for the Aurelia framework (beta).";
    }

    public String getNpmName() {
        return this.npmName;
    }

    public void setNpmName(String npmName) {
        this.npmName = npmName;
    }

    public String getNpmVersion() {
        return this.npmVersion;
    }

    public void setNpmVersion(String npmVersion) {
        this.npmVersion = npmVersion;
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(NPM_NAME)) {
            this.setNpmName(this.additionalProperties.get(NPM_NAME).toString());
        }
        if (this.additionalProperties.containsKey(NPM_VERSION)) {
            this.setNpmVersion(this.additionalProperties.get(NPM_VERSION).toString());
        }
        this.supportingFiles.add(new SupportingFile("models.mustache", "", "models.ts"));
        this.supportingFiles.add(new SupportingFile("index.ts.mustache", "", "index.ts"));
        this.supportingFiles.add(new SupportingFile("Api.ts.mustache", "", "Api.ts"));
        this.supportingFiles.add(new SupportingFile("AuthStorage.ts.mustache", "", "AuthStorage.ts"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("README.md", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("package.json.mustache", "", "package.json"));
        this.supportingFiles.add(new SupportingFile("tsconfig.json.mustache", "", "tsconfig.json"));
        this.supportingFiles.add(new SupportingFile("tslint.json.mustache", "", "tslint.json"));
        this.supportingFiles.add(new SupportingFile("gitignore", "", ".gitignore"));
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        objs = super.postProcessOperationsWithModels(objs, allModels);
        HashSet<String> modelImports = new HashSet<String>();
        Map operations = (Map)objs.get("operations");
        List operationList = (List)operations.get("operation");
        for (CodegenOperation op : operationList) {
            op.httpMethod = this.initialCaps(op.httpMethod.toLowerCase());
            for (CodegenParameter param : op.allParams) {
                if (param.isPrimitiveType || param.isListContainer || param.dataType.equals("any")) continue;
                modelImports.add(param.dataType);
            }
            if (op.returnBaseType == null || op.returnTypeIsPrimitive) continue;
            modelImports.add(op.returnBaseType);
        }
        objs.put("modelImports", modelImports);
        return objs;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        List models = (List)this.postProcessModelsEnum(objs).get("models");
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            cm.imports = new TreeSet<String>(cm.imports);
            for (CodegenProperty var : cm.vars) {
                if (!Boolean.TRUE.equals(var.isEnum)) continue;
                var.datatypeWithEnum = var.datatypeWithEnum.replace(var.enumName, cm.classname + var.enumName);
                var.enumName = cm.classname + var.enumName;
            }
        }
        return objs;
    }
}

