/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.info.Info;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.utils.URLPathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeJSServerCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeJSServerCodegen.class);
    protected String implFolder = "service";
    public static final String GOOGLE_CLOUD_FUNCTIONS = "googleCloudFunctions";
    public static final String EXPORTED_NAME = "exportedName";
    public static final String SERVER_PORT = "serverPort";
    protected String apiVersion = "1.0.0";
    protected String projectName = "openapi-server";
    protected String defaultServerPort = "8080";
    protected boolean googleCloudFunctions;
    protected String exportedName;

    public NodeJSServerCodegen() {
        this.outputFolder = "generated-code/nodejs";
        this.modelTemplateFiles.clear();
        this.apiTemplateFiles.put("controller.mustache", ".js");
        this.templateDir = "nodejs";
        this.embeddedTemplateDir = "nodejs";
        this.setReservedWordsLowerCase(Arrays.asList("break", "case", "class", "catch", "const", "continue", "debugger", "default", "delete", "do", "else", "export", "extends", "finally", "for", "function", "if", "import", "in", "instanceof", "let", "new", "return", "super", "switch", "this", "throw", "try", "typeof", "var", "void", "while", "with", "yield"));
        this.additionalProperties.put("apiVersion", this.apiVersion);
        this.additionalProperties.put("implFolder", this.implFolder);
        this.supportingFiles.add(new SupportingFile("writer.mustache", "utils".replace(".", File.separator), "writer.js"));
        this.cliOptions.add(CliOption.newBoolean(GOOGLE_CLOUD_FUNCTIONS, "When specified, it will generate the code which runs within Google Cloud Functions instead of standalone Node.JS server. See https://cloud.google.com/functions/docs/quickstart for the details of how to deploy the generated code."));
        this.cliOptions.add(new CliOption(EXPORTED_NAME, "When the generated code will be deployed to Google Cloud Functions, this option can be used to update the name of the exported function. By default, it refers to the basePath. This does not affect normal standalone nodejs server code."));
        this.cliOptions.add(new CliOption(SERVER_PORT, "TCP port to listen on."));
    }

    @Override
    public String apiPackage() {
        return "controllers";
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "nodejs-server";
    }

    @Override
    public String getHelp() {
        return "Generates a nodejs server library using the swagger-tools project.  By default, it will also generate service classes--which you can disable with the `-Dnoservice` environment variable.";
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultController";
        }
        return this.initialCaps(name);
    }

    @Override
    public String toApiFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String apiFilename(String templateName, String tag) {
        String result = super.apiFilename(templateName, tag);
        if (templateName.equals("service.mustache")) {
            String stringToMatch = File.separator + "controllers" + File.separator;
            String replacement = File.separator + this.implFolder + File.separator;
            result = result.replaceAll(Pattern.quote(stringToMatch), replacement);
        }
        return result;
    }

    private String implFileFolder(String output) {
        return this.outputFolder + File.separator + output + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    public boolean getGoogleCloudFunctions() {
        return this.googleCloudFunctions;
    }

    public void setGoogleCloudFunctions(boolean value) {
        this.googleCloudFunctions = value;
    }

    public String getExportedName() {
        return this.exportedName;
    }

    public void setExportedName(String name) {
        this.exportedName = name;
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        Map objectMap = (Map)objs.get("operations");
        List operations = (List)objectMap.get("operation");
        for (CodegenOperation operation : operations) {
            List<CodegenResponse> responses;
            operation.httpMethod = operation.httpMethod.toLowerCase();
            List<CodegenParameter> params = operation.allParams;
            if (params != null && params.size() == 0) {
                operation.allParams = null;
            }
            if ((responses = operation.responses) != null) {
                for (CodegenResponse resp : responses) {
                    if (!"0".equals(resp.code)) continue;
                    resp.code = "default";
                }
            }
            if (operation.examples == null || operation.examples.isEmpty()) continue;
            Iterator<Map<String, String>> it = operation.examples.iterator();
            while (it.hasNext()) {
                Map<String, String> example = it.next();
                String contentType = example.get("contentType");
                if (contentType != null && contentType.startsWith("application/json")) continue;
                it.remove();
            }
        }
        return objs;
    }

    private static List<Map<String, Object>> getOperations(Map<String, Object> objs) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Map apiInfo = (Map)objs.get("apiInfo");
        List apis = (List)apiInfo.get("apis");
        for (Map api : apis) {
            result.add((Map)api.get("operations"));
        }
        return result;
    }

    private static List<Map<String, Object>> sortOperationsByPath(List<CodegenOperation> ops) {
        ArrayListMultimap opsByPath = ArrayListMultimap.create();
        for (CodegenOperation op : ops) {
            opsByPath.put((Object)op.path, (Object)op);
        }
        ArrayList<Map<String, Object>> opsByPathList = new ArrayList<Map<String, Object>>();
        for (Map.Entry entry : opsByPath.asMap().entrySet()) {
            HashMap<String, Object> opsByPathEntry = new HashMap<String, Object>();
            opsByPathList.add(opsByPathEntry);
            opsByPathEntry.put("path", entry.getKey());
            opsByPathEntry.put("operation", entry.getValue());
            ArrayList operationsForThisPath = Lists.newArrayList((Iterable)((Iterable)entry.getValue()));
            ((CodegenOperation)operationsForThisPath.get((int)(operationsForThisPath.size() - 1))).hasMore = false;
            if (opsByPathList.size() >= opsByPath.asMap().size()) continue;
            opsByPathEntry.put("hasMore", "true");
        }
        return opsByPathList;
    }

    @Override
    public void processOpts() {
        super.processOpts();
        StringBuilder message = new StringBuilder();
        message.append(System.lineSeparator()).append(System.lineSeparator()).append("=======================================================================================").append(System.lineSeparator()).append("Currently, Node.js server doesn't work as its dependency doesn't support OpenAPI Spec3.").append(System.lineSeparator()).append("For further details, see https://github.com/OpenAPITools/openapi-generator/issues/34").append(System.lineSeparator()).append("=======================================================================================").append(System.lineSeparator()).append(System.lineSeparator());
        LOGGER.warn(message.toString());
        if (this.additionalProperties.containsKey(GOOGLE_CLOUD_FUNCTIONS)) {
            this.setGoogleCloudFunctions(Boolean.valueOf(this.additionalProperties.get(GOOGLE_CLOUD_FUNCTIONS).toString()));
        }
        if (this.additionalProperties.containsKey(EXPORTED_NAME)) {
            this.setExportedName((String)this.additionalProperties.get(EXPORTED_NAME));
        }
        this.supportingFiles.add(new SupportingFile("openapi.mustache", "api", "openapi.yaml"));
        if (this.getGoogleCloudFunctions()) {
            this.writeOptional(this.outputFolder, new SupportingFile("index-gcf.mustache", "", "index.js"));
        } else {
            this.writeOptional(this.outputFolder, new SupportingFile("index.mustache", "", "index.js"));
        }
        this.writeOptional(this.outputFolder, new SupportingFile("package.mustache", "", "package.json"));
        this.writeOptional(this.outputFolder, new SupportingFile("README.mustache", "", "README.md"));
        if (System.getProperty("noservice") == null) {
            this.apiTemplateFiles.put("service.mustache", "Service.js");
        }
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        Paths paths;
        Info info;
        URL url = URLPathUtils.getServerURL(openAPI);
        String host = URLPathUtils.getProtocolAndHost(url);
        String port = URLPathUtils.getPort(url, this.defaultServerPort);
        String basePath = url.getPath();
        if (this.additionalProperties.containsKey(SERVER_PORT)) {
            port = this.additionalProperties.get(SERVER_PORT).toString();
        }
        this.additionalProperties.put(SERVER_PORT, port);
        if (openAPI.getInfo() != null && (info = openAPI.getInfo()).getTitle() != null) {
            this.projectName = info.getTitle().replaceAll("[^a-zA-Z0-9]", "-").replaceAll("^[-]*", "").replaceAll("[-]*$", "").replaceAll("[-]{2,}", "-").toLowerCase();
            this.additionalProperties.put("projectName", this.projectName);
        }
        if (this.getGoogleCloudFunctions()) {
            if (!host.endsWith(".cloudfunctions.net")) {
                LOGGER.warn("Host " + host + " seems not matching with cloudfunctions.net URL.");
            }
            if (!this.additionalProperties.containsKey(EXPORTED_NAME)) {
                if (basePath == null || basePath.equals("/")) {
                    LOGGER.warn("Cannot find the exported name properly. Using 'openapi' as the exported name");
                    basePath = "/openapi";
                }
                this.additionalProperties.put(EXPORTED_NAME, basePath.substring(1));
            }
        }
        if ((paths = openAPI.getPaths()) != null) {
            for (String pathname : paths.keySet()) {
                PathItem path = (PathItem)paths.get((Object)pathname);
                Map operationMap = path.readOperationsMap();
                if (operationMap == null) continue;
                for (PathItem.HttpMethod method : operationMap.keySet()) {
                    Operation operation = (Operation)operationMap.get(method);
                    String tag = "default";
                    if (operation.getTags() != null && operation.getTags().size() > 0) {
                        tag = this.toApiName((String)operation.getTags().get(0));
                    }
                    if (operation.getOperationId() == null) {
                        operation.setOperationId(this.getOrGenerateOperationId(operation, pathname, method.toString()));
                    }
                    if (operation.getExtensions() != null && operation.getExtensions().get("x-swagger-router-controller") != null) continue;
                    operation.addExtension("x-swagger-router-controller", (Object)this.sanitizeTag(tag));
                }
            }
        }
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        this.generateYAMLSpecFile(objs);
        for (Map<String, Object> operations : NodeJSServerCodegen.getOperations(objs)) {
            List ops = (List)operations.get("operation");
            List<Map<String, Object>> opsByPathList = NodeJSServerCodegen.sortOperationsByPath(ops);
            operations.put("operationsByPath", opsByPathList);
        }
        return super.postProcessSupportingFileData(objs);
    }

    @Override
    public String removeNonNameElementToCamelCase(String name) {
        return this.removeNonNameElementToCamelCase(name, "[-:;#]");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }
}

