/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractCppCodegen;
import org.openapitools.codegen.utils.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CppQt5ClientCodegen
extends AbstractCppCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(CppQt5ClientCodegen.class);
    public static final String CPP_NAMESPACE = "cppNamespace";
    public static final String CPP_NAMESPACE_DESC = "C++ namespace (convention: name::space::for::api).";
    public static final String OPTIONAL_PROJECT_FILE_DESC = "Generate client.pri.";
    protected final String PREFIX = "OAI";
    protected Set<String> foundationClasses = new HashSet<String>();
    protected String sourceFolder = "client";
    protected String apiVersion = "1.0.0";
    protected Map<String, String> namespaces = new HashMap<String, String>();
    protected Set<String> systemIncludes = new HashSet<String>();
    protected String cppNamespace = "OpenAPI";
    protected boolean optionalProjectFileFlag = true;

    public CppQt5ClientCodegen() {
        this.outputFolder = "generated-code/qt5cpp";
        if (StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            this.modelNamePrefix = "OAI";
        }
        this.modelTemplateFiles.put("model-header.mustache", ".h");
        this.modelTemplateFiles.put("model-body.mustache", ".cpp");
        this.apiTemplateFiles.put("api-header.mustache", ".h");
        this.apiTemplateFiles.put("api-body.mustache", ".cpp");
        this.templateDir = "cpp-qt5-client";
        this.embeddedTemplateDir = "cpp-qt5-client";
        this.addOption(CPP_NAMESPACE, CPP_NAMESPACE_DESC, this.cppNamespace);
        this.addSwitch("optionalProjectFile", OPTIONAL_PROJECT_FILE_DESC, this.optionalProjectFileFlag);
        this.additionalProperties.put("apiVersion", this.apiVersion);
        this.additionalProperties().put("prefix", "OAI");
        this.additionalProperties.put(CPP_NAMESPACE, this.cppNamespace);
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("bool", "qint32", "qint64", "float", "double"));
        this.supportingFiles.add(new SupportingFile("helpers-header.mustache", this.sourceFolder, "OAIHelpers.h"));
        this.supportingFiles.add(new SupportingFile("helpers-body.mustache", this.sourceFolder, "OAIHelpers.cpp"));
        this.supportingFiles.add(new SupportingFile("HttpRequest.h.mustache", this.sourceFolder, "OAIHttpRequest.h"));
        this.supportingFiles.add(new SupportingFile("HttpRequest.cpp.mustache", this.sourceFolder, "OAIHttpRequest.cpp"));
        this.supportingFiles.add(new SupportingFile("modelFactory.mustache", this.sourceFolder, "OAIModelFactory.h"));
        this.supportingFiles.add(new SupportingFile("object.mustache", this.sourceFolder, "OAIObject.h"));
        this.supportingFiles.add(new SupportingFile("QObjectWrapper.h.mustache", this.sourceFolder, "OAIQObjectWrapper.h"));
        if (this.optionalProjectFileFlag) {
            this.supportingFiles.add(new SupportingFile("Project.mustache", this.sourceFolder, "client.pri"));
        }
        this.typeMapping = new HashMap();
        this.typeMapping.put("date", "QDate");
        this.typeMapping.put("DateTime", "QDateTime");
        this.typeMapping.put("string", "QString");
        this.typeMapping.put("integer", "qint32");
        this.typeMapping.put("long", "qint64");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("array", "QList");
        this.typeMapping.put("map", "QMap");
        this.typeMapping.put("file", "OAIHttpRequestInputFileElement");
        this.typeMapping.put("object", "OAIObject");
        this.typeMapping.put("binary", "OAIHttpRequestInputFileElement");
        this.typeMapping.put("ByteArray", "QByteArray");
        this.typeMapping.put("UUID", "QString");
        this.importMapping = new HashMap();
        this.importMapping.put("OAIHttpRequestInputFileElement", "#include \"OAIHttpRequest.h\"");
        this.namespaces = new HashMap<String, String>();
        this.foundationClasses.add("QString");
        this.systemIncludes.add("QString");
        this.systemIncludes.add("QList");
        this.systemIncludes.add("QMap");
        this.systemIncludes.add("QDate");
        this.systemIncludes.add("QDateTime");
        this.systemIncludes.add("QByteArray");
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(CPP_NAMESPACE)) {
            this.cppNamespace = (String)this.additionalProperties.get(CPP_NAMESPACE);
        }
        this.additionalProperties.put("cppNamespaceDeclarations", this.cppNamespace.split("\\::"));
        if (this.additionalProperties.containsKey("modelNamePrefix")) {
            this.supportingFiles.clear();
            this.supportingFiles.add(new SupportingFile("helpers-header.mustache", this.sourceFolder, this.modelNamePrefix + "Helpers.h"));
            this.supportingFiles.add(new SupportingFile("helpers-body.mustache", this.sourceFolder, this.modelNamePrefix + "Helpers.cpp"));
            this.supportingFiles.add(new SupportingFile("HttpRequest.h.mustache", this.sourceFolder, this.modelNamePrefix + "HttpRequest.h"));
            this.supportingFiles.add(new SupportingFile("HttpRequest.cpp.mustache", this.sourceFolder, this.modelNamePrefix + "HttpRequest.cpp"));
            this.supportingFiles.add(new SupportingFile("modelFactory.mustache", this.sourceFolder, this.modelNamePrefix + "ModelFactory.h"));
            this.supportingFiles.add(new SupportingFile("object.mustache", this.sourceFolder, this.modelNamePrefix + "Object.h"));
            this.supportingFiles.add(new SupportingFile("QObjectWrapper.h.mustache", this.sourceFolder, this.modelNamePrefix + "QObjectWrapper.h"));
            this.typeMapping.put("object", this.modelNamePrefix + "Object");
            this.typeMapping.put("file", this.modelNamePrefix + "HttpRequestInputFileElement");
            this.importMapping.put("SWGHttpRequestInputFileElement", "#include \"" + this.modelNamePrefix + "HttpRequest.h\"");
            this.additionalProperties().put("prefix", this.modelNamePrefix);
        }
        if (this.additionalProperties.containsKey("optionalProjectFile")) {
            this.setOptionalProjectFileFlag(this.convertPropertyToBooleanAndWriteBack("optionalProjectFile"));
        } else {
            this.additionalProperties.put("optionalProjectFile", this.optionalProjectFileFlag);
        }
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "cpp-qt5";
    }

    @Override
    public String getHelp() {
        return "Generates a Qt5 C++ client library.";
    }

    @Override
    public String toModelImport(String name) {
        if (this.namespaces.containsKey(name)) {
            return "using " + this.namespaces.get(name) + ";";
        }
        if (this.systemIncludes.contains(name)) {
            return "#include <" + name + ">";
        }
        String folder = this.modelPackage().replace("::", File.separator);
        if (!folder.isEmpty()) {
            folder = folder + File.separator;
        }
        return "#include \"" + folder + this.toModelName(name) + ".h\"";
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.modelPackage().replace("::", File.separator);
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.apiPackage().replace("::", File.separator);
    }

    @Override
    public String toModelFilename(String name) {
        return this.initialCaps(this.toModelName(name));
    }

    @Override
    public String toApiFilename(String name) {
        return this.modelNamePrefix + this.initialCaps(name) + "Api";
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        String openAPIType = this.getSchemaType(p);
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return this.getSchemaType(p) + "<" + this.getTypeDeclaration(inner) + ">*";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = (Schema)p.getAdditionalProperties();
            return this.getSchemaType(p) + "<QString, " + this.getTypeDeclaration(inner) + ">*";
        }
        if (this.foundationClasses.contains(openAPIType)) {
            return openAPIType + "*";
        }
        if (this.languageSpecificPrimitives.contains(openAPIType)) {
            return this.toModelName(openAPIType);
        }
        return openAPIType + "*";
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isBooleanSchema(p)) {
            return "false";
        }
        if (ModelUtils.isDateSchema(p)) {
            return "NULL";
        }
        if (ModelUtils.isDateTimeSchema(p)) {
            return "NULL";
        }
        if (ModelUtils.isNumberSchema(p)) {
            if ("float".equals(p.getFormat())) {
                return "0.0f";
            }
            return "0.0";
        }
        if (ModelUtils.isIntegerSchema(p)) {
            if ("int64".equals(p.getFormat())) {
                return "0L";
            }
            return "0";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = (Schema)p.getAdditionalProperties();
            return "new QMap<QString, " + this.getTypeDeclaration(inner) + ">()";
        }
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return "new QList<" + this.getTypeDeclaration(inner) + ">()";
        }
        if (ModelUtils.isStringSchema(p)) {
            return "new QString(\"\")";
        }
        if (!StringUtils.isEmpty((CharSequence)p.get$ref())) {
            return "new " + this.toModelName(ModelUtils.getSimpleRef(p.get$ref())) + "()";
        }
        return "NULL";
    }

    @Override
    public String getSchemaType(Schema p) {
        String openAPIType = super.getSchemaType(p);
        String type = null;
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return this.toModelName(type);
            }
            if (this.foundationClasses.contains(type)) {
                return type;
            }
        } else {
            type = openAPIType;
        }
        return this.toModelName(type);
    }

    @Override
    public String toModelName(String type) {
        if (type == null) {
            LOGGER.warn("Model name can't be null. Default to 'UnknownModel'.");
            type = "UnknownModel";
        }
        if (this.typeMapping.keySet().contains(type) || this.typeMapping.values().contains(type) || this.importMapping.values().contains(type) || this.defaultIncludes.contains(type) || this.languageSpecificPrimitives.contains(type)) {
            return type;
        }
        String typeName = this.sanitizeName(type);
        return this.modelNamePrefix + Character.toUpperCase(typeName.charAt(0)) + typeName.substring(1);
    }

    @Override
    public String toVarName(String name) {
        String varName = this.sanitizeName(name);
        if (varName.matches("^[A-Z_]*$")) {
            varName = varName.toLowerCase();
        }
        if (this.isReservedWord(varName = CppQt5ClientCodegen.underscore(varName)) || varName.matches("^\\d.*")) {
            varName = this.escapeReservedWord(varName);
        }
        return varName;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toApiName(String type) {
        return this.modelNamePrefix + Character.toUpperCase(type.charAt(0)) + type.substring(1) + "Api";
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    public void setOptionalProjectFileFlag(boolean flag) {
        this.optionalProjectFileFlag = flag;
    }

    @Override
    public String getTypeDeclaration(String str) {
        return str;
    }
}

