/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.mustache;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang3.StringUtils;

public class IndentedLambda
implements Mustache.Lambda {
    private final int prefixSpaceCount;
    private int spaceCode;

    public IndentedLambda() {
        this(4, " ");
    }

    public IndentedLambda(int prefixSpaceCount, String indentionCharacter) {
        this(prefixSpaceCount, Character.codePointAt(indentionCharacter, 0));
    }

    private IndentedLambda(int prefixSpaceCount, int indentionCodePoint) {
        if (prefixSpaceCount <= 0) {
            throw new IllegalArgumentException("prefixSpaceCount must be greater than 0");
        }
        if (!Character.isValidCodePoint(indentionCodePoint)) {
            throw new IllegalArgumentException("indentionCodePoint is an invalid code point ");
        }
        this.prefixSpaceCount = prefixSpaceCount;
        this.spaceCode = indentionCodePoint;
    }

    public void execute(Template.Fragment fragment, Writer writer) throws IOException {
        String text = fragment.execute();
        if (text == null || text.length() == 0) {
            return;
        }
        String prefixedIndention = StringUtils.repeat((String)new String(Character.toChars(this.spaceCode)), (int)this.prefixSpaceCount);
        StringBuilder sb = new StringBuilder();
        String[] lines = text.split(System.lineSeparator());
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (i > 0) {
                sb.append(prefixedIndention);
            }
            sb.append(line);
            if (i >= lines.length - 1) continue;
            sb.append(System.lineSeparator());
        }
        writer.write(sb.toString());
    }
}

