/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.online.service;

import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.core.models.AuthorizationValue;
import io.swagger.v3.parser.core.models.ParseOptions;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.ClientOptInput;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenConfigLoader;
import org.openapitools.codegen.DefaultGenerator;
import org.openapitools.codegen.online.model.GeneratorInput;
import org.openapitools.codegen.online.service.Generator;
import org.openapitools.codegen.online.service.ZipUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ResponseStatusException;

/*
 * Exception performing whole class analysis ignored.
 */
public class Generator {
    private static Logger LOGGER = LoggerFactory.getLogger(Generator.class);

    public static Map<String, CliOption> getOptions(String language) {
        CodegenConfig config;
        try {
            config = CodegenConfigLoader.forName((String)language);
        }
        catch (Exception e) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, String.format(Locale.ROOT, "Unsupported target %s supplied. %s", language, e));
        }
        LinkedHashMap<String, CliOption> map = new LinkedHashMap<String, CliOption>();
        for (CliOption option : config.cliOptions()) {
            map.put(option.getOpt(), option);
        }
        return map;
    }

    public static String generateClient(String language, GeneratorInput opts) {
        return Generator.generate((String)language, (GeneratorInput)opts, (Type)Type.CLIENT);
    }

    public static String generateServer(String language, GeneratorInput opts) {
        return Generator.generate((String)language, (GeneratorInput)opts, (Type)Type.SERVER);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String generate(String language, GeneratorInput opts, Type type) {
        CodegenConfig codegenConfig;
        OpenAPI openapi;
        ArrayList<AuthorizationValue> authorizationValues;
        LOGGER.debug(String.format(Locale.ROOT, "generate %s for %s", type.getTypeName(), language));
        if (opts == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "No options were supplied");
        }
        JsonNode node = opts.getSpec();
        if (node != null && "{}".equals(node.toString())) {
            LOGGER.debug("ignoring empty spec");
            node = null;
        }
        ParseOptions parseOptions = new ParseOptions();
        parseOptions.setResolve(true);
        if (node == null) {
            if (opts.getOpenAPIUrl() == null) throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "No OpenAPI specification was supplied");
            if (opts.getAuthorizationValue() != null) {
                authorizationValues = new ArrayList();
                authorizationValues.add(opts.getAuthorizationValue());
                openapi = new OpenAPIParser().readLocation(opts.getOpenAPIUrl(), authorizationValues, parseOptions).getOpenAPI();
            } else {
                openapi = new OpenAPIParser().readLocation(opts.getOpenAPIUrl(), null, parseOptions).getOpenAPI();
            }
        } else if (opts.getAuthorizationValue() != null) {
            authorizationValues = new ArrayList<AuthorizationValue>();
            authorizationValues.add(opts.getAuthorizationValue());
            openapi = new OpenAPIParser().readContents(node.toString(), authorizationValues, parseOptions).getOpenAPI();
        } else {
            openapi = new OpenAPIParser().readContents(node.toString(), null, parseOptions).getOpenAPI();
        }
        if (openapi == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "The OpenAPI specification supplied was not valid");
        }
        Object destPath = null;
        if (opts.getOptions() != null) {
            destPath = (String)opts.getOptions().get("outputFolder");
        }
        if (destPath == null) {
            destPath = language + "-" + type.getTypeName();
        }
        ClientOptInput clientOptInput = new ClientOptInput();
        String outputFolder = Generator.getTmpFolder().getAbsolutePath() + File.separator + (String)destPath;
        String outputFilename = outputFolder + "-bundle.zip";
        clientOptInput.openAPI(openapi);
        try {
            codegenConfig = CodegenConfigLoader.forName((String)language);
        }
        catch (RuntimeException e) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Unsupported target " + language + " supplied");
        }
        if (opts.getOptions() != null) {
            codegenConfig.additionalProperties().putAll(opts.getOptions());
            codegenConfig.additionalProperties().put("openAPI", openapi);
        }
        codegenConfig.setOutputDir(outputFolder);
        clientOptInput.config(codegenConfig);
        try {
            List files = new DefaultGenerator().opts(clientOptInput).generate();
            if (files.size() <= 0) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "A target generation was attempted, but no files were created!");
            }
            ArrayList<File> filesToAdd = new ArrayList<File>();
            LOGGER.debug("adding to {}", (Object)outputFolder);
            filesToAdd.add(new File(outputFolder));
            ZipUtil zip = new ZipUtil();
            zip.compressFiles(filesToAdd, outputFilename);
            for (File file : files) {
                try {
                    file.delete();
                }
                catch (Exception e) {
                    LOGGER.error("unable to delete file " + file.getAbsolutePath(), (Throwable)e);
                }
            }
            try {
                new File(outputFolder).delete();
                return outputFilename;
            }
            catch (Exception e) {
                LOGGER.error("unable to delete output folder " + outputFolder, (Throwable)e);
            }
            return outputFilename;
        }
        catch (Exception e) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Unable to build target: " + e.getMessage(), (Throwable)e);
        }
    }

    private static File getTmpFolder() {
        try {
            File outputFolder = Files.createTempDirectory("codegen-tmp", new FileAttribute[0]).toFile();
            outputFolder.deleteOnExit();
            return outputFolder;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Cannot access tmp folder");
        }
    }
}

