/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.generator.gradle.plugin.tasks;

import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openapitools.codegen.validation.Invalid;
import org.openapitools.codegen.validation.ValidationResult;
import org.openapitools.codegen.validations.oas.OpenApiEvaluator;
import org.openapitools.codegen.validations.oas.RuleConfiguration;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0007R*\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u00048G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b8GX\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR$\u0010\u000e\u001a\u0010\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f0\u000b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR$\u0010\u0012\u001a\u0010\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f0\u000b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\r\u00a8\u0006\u0016"}, d2={"Lorg/openapitools/generator/gradle/plugin/tasks/ValidateTask;", "Lorg/gradle/api/DefaultTask;", "()V", "value", "", "input", "getInput", "()Ljava/lang/String;", "setInput", "(Ljava/lang/String;)V", "inputSpec", "Lorg/gradle/api/provider/Property;", "getInputSpec", "()Lorg/gradle/api/provider/Property;", "recommend", "", "kotlin.jvm.PlatformType", "getRecommend", "treatWarningsAsErrors", "getTreatWarningsAsErrors", "doWork", "", "openapi-generator-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nValidateTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ValidateTask.kt\norg/openapitools/generator/gradle/plugin/tasks/ValidateTask\n+ 2 ObjectFactoryExtensions.kt\norg/gradle/kotlin/dsl/ObjectFactoryExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,138:1\n59#2:139\n59#2:140\n59#2:141\n1855#3,2:142\n1855#3,2:144\n1855#3,2:146\n*S KotlinDebug\n*F\n+ 1 ValidateTask.kt\norg/openapitools/generator/gradle/plugin/tasks/ValidateTask\n*L\n57#1:139\n61#1:140\n65#1:141\n101#1:142,2\n112#1:144,2\n118#1:146,2\n*E\n"})
public class ValidateTask
extends DefaultTask {
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    private final Property<String> inputSpec;
    @Optional
    @Input
    @NotNull
    private final Property<Boolean> recommend;
    @Optional
    @Input
    @NotNull
    private final Property<Boolean> treatWarningsAsErrors;
    @Nullable
    private String input;

    public ValidateTask() {
        ObjectFactory objectFactory = this.getProject().getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"project.objects");
        ObjectFactory $this$property$iv = objectFactory;
        boolean $i$f$property = false;
        Property property = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.java)");
        this.inputSpec = property;
        ObjectFactory objectFactory2 = this.getProject().getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory2, (String)"project.objects");
        ObjectFactory $this$property$iv2 = objectFactory2;
        boolean $i$f$property2 = false;
        Property property2 = $this$property$iv2.property(Boolean.class);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"property(T::class.java)");
        Property property3 = property2.convention((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"project.objects.property\u2026olean>().convention(true)");
        this.recommend = property3;
        ObjectFactory objectFactory3 = this.getProject().getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory3, (String)"project.objects");
        $this$property$iv2 = objectFactory3;
        $i$f$property2 = false;
        Property property4 = $this$property$iv2.property(Boolean.class);
        Intrinsics.checkNotNullExpressionValue((Object)property4, (String)"property(T::class.java)");
        Property property5 = property4.convention((Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)property5, (String)"project.objects.property\u2026lean>().convention(false)");
        this.treatWarningsAsErrors = property5;
    }

    @InputFile
    @NotNull
    public final Property<String> getInputSpec() {
        return this.inputSpec;
    }

    @NotNull
    public final Property<Boolean> getRecommend() {
        return this.recommend;
    }

    @NotNull
    public final Property<Boolean> getTreatWarningsAsErrors() {
        return this.treatWarningsAsErrors;
    }

    @Internal
    @Nullable
    public final String getInput() {
        return this.input;
    }

    @Option(option="input", description="The input specification.")
    public final void setInput(@Nullable String value) {
        this.inputSpec.set((Object)value);
    }

    @TaskAction
    public final void doWork() {
        ValidationResult validationResult;
        StyledTextOutput out;
        boolean failOnWarnings;
        Logger logger;
        block10: {
            Object it;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            Set messages;
            block9: {
                logger = Logging.getLogger(((Object)((Object)this)).getClass());
                Object object = this.inputSpec.get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inputSpec.get()");
                String spec = (String)object;
                Object object2 = this.recommend.get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"recommend.get()");
                boolean recommendations = (Boolean)object2;
                Object object3 = this.treatWarningsAsErrors.get();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"treatWarningsAsErrors.get()");
                failOnWarnings = (Boolean)object3;
                logger.quiet("Validating spec " + spec);
                ParseOptions options = new ParseOptions();
                options.setResolve(true);
                SwaggerParseResult result = new OpenAPIParser().readLocation(spec, null, options);
                List list = result.getMessages();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"result.messages");
                messages = CollectionsKt.toSet((Iterable)list);
                out = ((StyledTextOutputFactory)this.getServices().get(StyledTextOutputFactory.class)).create("openapi");
                RuleConfiguration ruleConfiguration = new RuleConfiguration();
                ruleConfiguration.setEnableRecommendations(recommendations);
                OpenApiEvaluator evaluator = new OpenApiEvaluator(ruleConfiguration);
                validationResult = evaluator.validate(result.getOpenAPI());
                List list2 = validationResult.getWarnings();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"validationResult.warnings");
                if (!((Collection)list2).isEmpty()) {
                    out.withStyle(StyledTextOutput.Style.Info);
                    out.println((Object)"\nSpec has issues or recommendations.\nIssues:\n");
                    List list3 = validationResult.getWarnings();
                    Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"validationResult.warnings");
                    $this$forEach$iv = list3;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (Invalid)element$iv;
                        boolean bl = false;
                        out.withStyle(StyledTextOutput.Style.Info);
                        out.println((Object)("\t" + it.getMessage() + "\n"));
                        logger.debug("WARNING: " + it.getMessage() + "|" + it.getDetails());
                    }
                }
                if (!((Collection)messages).isEmpty()) break block9;
                List list4 = validationResult.getErrors();
                Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"validationResult.errors");
                if (!(!((Collection)list4).isEmpty())) break block10;
            }
            out.withStyle(StyledTextOutput.Style.Error);
            out.println((Object)"\nSpec is invalid.\nIssues:\n");
            $this$forEach$iv = messages;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (String)element$iv;
                boolean bl = false;
                out.withStyle(StyledTextOutput.Style.Error);
                out.println((Object)("\t" + (String)it + "\n"));
                logger.debug("ERROR: " + (String)it);
            }
            List list = validationResult.getErrors();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"validationResult.errors");
            $this$forEach$iv = list;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Invalid)element$iv;
                boolean bl = false;
                out.withStyle(StyledTextOutput.Style.Error);
                out.println((Object)("\t" + it.getMessage() + "\n"));
                logger.debug("ERROR: " + it.getMessage() + "|" + it.getDetails());
            }
            throw new GradleException("Validation failed.");
        }
        if (failOnWarnings) {
            List list = validationResult.getWarnings();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"validationResult.warnings");
            if (!((Collection)list).isEmpty()) {
                out.withStyle(StyledTextOutput.Style.Error);
                out.println((Object)"\nWarnings found in the spec and 'treatWarningsAsErrors' is enabled.\nFailing validation.\n");
                throw new GradleException("Validation failed due to warnings (treatWarningsAsErrors = true).");
            }
        }
        out.withStyle(StyledTextOutput.Style.Success);
        logger.debug("No error validations from swagger-parser or internal validations.");
        out.println((Object)"Spec is valid.");
    }
}

