/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.operation.validator.util.convert.style;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openapi4j.core.model.OAIContext;
import org.openapi4j.core.util.MultiStringMap;
import org.openapi4j.core.util.StringUtil;
import org.openapi4j.operation.validator.util.convert.TypeConverter;
import org.openapi4j.parser.model.v3.AbsParameter;
import org.openapi4j.parser.model.v3.Schema;

public class FormStyleConverter {
    private static final FormStyleConverter INSTANCE = new FormStyleConverter();

    private FormStyleConverter() {
    }

    public static FormStyleConverter instance() {
        return INSTANCE;
    }

    public JsonNode convert(OAIContext context, AbsParameter<?> param, String paramName, MultiStringMap<String> paramPairs, List<String> visitedParams) {
        JsonNode result;
        if (paramPairs == null) {
            return null;
        }
        param.setSchema(param.getSchema().getFlatSchema(context));
        String type = param.getSchema().getSupposedType(context);
        if ("array".equals(type)) {
            result = this.getArrayValues(context, param, paramPairs.get(paramName));
            visitedParams.add(paramName);
        } else if ("object".equals(type)) {
            result = this.getObjectValues(context, param, paramName, paramPairs, visitedParams);
        } else {
            result = this.getPrimitiveValue(context, param, paramPairs.get(paramName));
            visitedParams.add(paramName);
        }
        return result;
    }

    private JsonNode getArrayValues(OAIContext context, AbsParameter<?> param, Collection<String> paramValues) {
        if (paramValues == null) {
            return null;
        }
        ArrayList<Object> values = new ArrayList<Object>();
        if (param.isExplode()) {
            values.addAll(paramValues);
        } else {
            for (String paramValue : paramValues) {
                values.addAll(StringUtil.tokenize((String)paramValue, (String)",", (boolean)false, (boolean)false));
            }
        }
        return TypeConverter.instance().convertArray(context, param.getSchema().getItemsSchema(), values);
    }

    private JsonNode getObjectValues(OAIContext context, AbsParameter<?> param, String paramName, MultiStringMap<String> values, List<String> visitedParams) {
        if (param.isExplode()) {
            return this.getExplodedObjectValues(context, param, values, visitedParams);
        }
        return this.getNotExplodedObjectValues(context, param, paramName, values, visitedParams);
    }

    private JsonNode getExplodedObjectValues(OAIContext context, AbsParameter<?> param, MultiStringMap<String> values, List<String> visitedParams) {
        ObjectNode result = JsonNodeFactory.instance.objectNode();
        for (Map.Entry propEntry : param.getSchema().getProperties().entrySet()) {
            String propName = (String)propEntry.getKey();
            Collection paramValues = values.get(propName);
            if (paramValues == null) continue;
            JsonNode value = TypeConverter.instance().convertPrimitive(context, (Schema)propEntry.getValue(), this.getParamValue(paramValues));
            result.set(propName, value);
            visitedParams.add(propName);
        }
        return result.size() != 0 ? result : null;
    }

    private JsonNode getNotExplodedObjectValues(OAIContext context, AbsParameter<?> param, String paramName, MultiStringMap<String> values, List<String> visitedParams) {
        Collection paramValues = values.get(paramName);
        visitedParams.add(paramName);
        if (paramValues == null) {
            return null;
        }
        String value = this.getParamValue(paramValues);
        if (value == null) {
            return null;
        }
        ObjectNode result = JsonNodeFactory.instance.objectNode();
        List arrayValues = StringUtil.tokenize((String)value, (String)",", (boolean)false, (boolean)false);
        int idx = 0;
        while (idx < arrayValues.size()) {
            String propName = (String)arrayValues.get(idx++);
            String propValue = (String)arrayValues.get(idx++);
            Schema propSchema = param.getSchema().getProperty(propName);
            result.set(propName, TypeConverter.instance().convertPrimitive(context, propSchema, propValue));
        }
        return result;
    }

    private JsonNode getPrimitiveValue(OAIContext context, AbsParameter<?> param, Collection<String> paramValues) {
        if (paramValues == null) {
            return null;
        }
        return TypeConverter.instance().convertPrimitive(context, param.getSchema(), this.getParamValue(paramValues));
    }

    private String getParamValue(Collection<String> paramValues) {
        if (paramValues == null) {
            return null;
        }
        return paramValues.stream().filter(Objects::nonNull).findFirst().orElse(null);
    }
}

