/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.operation.validator.util.convert.style;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.openapi4j.core.model.OAIContext;
import org.openapi4j.core.util.MultiStringMap;
import org.openapi4j.core.util.StringUtil;
import org.openapi4j.operation.validator.util.convert.style.FlatStyleConverter;
import org.openapi4j.parser.model.v3.AbsParameter;

class DelimitedStyleConverter
extends FlatStyleConverter {
    protected final String delimiter;

    DelimitedStyleConverter(String delimiter) {
        this.delimiter = delimiter;
    }

    public JsonNode convert(OAIContext context, AbsParameter<?> param, String paramName, MultiStringMap<String> paramPairs, List<String> visitedParams) {
        Collection paramValues = paramPairs.get(paramName);
        if (paramValues == null) {
            return null;
        }
        visitedParams.add(paramName);
        String paramValue = paramValues.size() == 1 ? (String)paramValues.iterator().next() : String.join((CharSequence)this.delimiter, paramValues);
        return this.convert(context, param, paramName, paramValue);
    }

    @Override
    public JsonNode convert(OAIContext context, AbsParameter<?> param, String paramName, String paramValue) {
        if (!"array".equals(param.getSchema().getSupposedType(context))) {
            return null;
        }
        List values = StringUtil.tokenize((String)paramValue, (String)Pattern.quote(this.delimiter), (boolean)false, (boolean)false);
        ArrayList<String> arrayValues = new ArrayList<String>();
        for (String value : values) {
            if (param.isExplode()) {
                arrayValues.add(value);
                continue;
            }
            arrayValues.addAll(StringUtil.tokenize((String)value, (String)Pattern.quote(this.delimiter), (boolean)false, (boolean)false));
        }
        HashMap<String, Object> paramValues = new HashMap<String, Object>();
        paramValues.put(paramName, arrayValues);
        return this.convert(context, param, paramName, paramValues);
    }
}

