/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.operation.validator.util.convert.style;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.openapi4j.core.model.OAIContext;
import org.openapi4j.core.util.MultiStringMap;
import org.openapi4j.core.util.StringUtil;
import org.openapi4j.operation.validator.util.convert.TypeConverter;
import org.openapi4j.parser.model.v3.AbsParameter;
import org.openapi4j.parser.model.v3.Schema;

public class DeepObjectStyleConverter {
    private static final DeepObjectStyleConverter INSTANCE = new DeepObjectStyleConverter();

    private DeepObjectStyleConverter() {
    }

    public static DeepObjectStyleConverter instance() {
        return INSTANCE;
    }

    public JsonNode convert(OAIContext context, AbsParameter<?> param, String paramName, MultiStringMap<String> paramPairs, List<String> visitedParams) {
        ObjectNode result = JsonNodeFactory.instance.objectNode();
        Schema propSchema = param.getSchema().getFlatSchema(context);
        String type = propSchema.getSupposedType(context);
        for (Map.Entry valueEntry : paramPairs.entrySet()) {
            String propPath = (String)valueEntry.getKey();
            if (propPath.startsWith(paramName + "[")) {
                List properties = StringUtil.tokenize((String)propPath, (String)"\\[|\\]", (boolean)true, (boolean)true);
                if (properties.size() != 2) continue;
                String propName = (String)properties.get(1);
                JsonNode value = TypeConverter.instance().convertPrimitive(context, propSchema.getProperty(propName), ((Collection)valueEntry.getValue()).stream().findFirst().orElse(null));
                result.set(propName, value);
                visitedParams.add(propPath);
                continue;
            }
            if (!propPath.equals(paramName) || !"object".equals(type)) continue;
            visitedParams.add(propPath);
        }
        return result;
    }
}

