/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.operation.validator.util.convert;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import org.openapi4j.core.model.OAIContext;
import org.openapi4j.parser.model.v3.Schema;

public final class TypeConverter {
    private static final TypeConverter INSTANCE = new TypeConverter();

    private TypeConverter() {
    }

    public static TypeConverter instance() {
        return INSTANCE;
    }

    public JsonNode convertObject(OAIContext context, Schema schema, Map<String, Object> content) {
        if (schema == null || content == null) {
            return JsonNodeFactory.instance.nullNode();
        }
        Map properties = schema.getProperties();
        if (properties == null || properties.isEmpty()) {
            return JsonNodeFactory.instance.nullNode();
        }
        ObjectNode convertedContent = JsonNodeFactory.instance.objectNode();
        block8: for (Map.Entry entry : properties.entrySet()) {
            String entryKey = (String)entry.getKey();
            if (!content.containsKey(entryKey)) continue;
            Object value = content.get(entryKey);
            Schema flatSchema = ((Schema)entry.getValue()).getFlatSchema(context);
            switch (flatSchema.getSupposedType(context)) {
                case "object": {
                    convertedContent.set(entryKey, this.convertObject(context, flatSchema, this.castMap(value)));
                    continue block8;
                }
                case "array": {
                    convertedContent.set(entryKey, this.convertArray(context, flatSchema.getItemsSchema(), this.castList(value)));
                    continue block8;
                }
            }
            convertedContent.set(entryKey, this.convertPrimitive(context, flatSchema, value));
        }
        return convertedContent;
    }

    public JsonNode convertArray(OAIContext context, Schema schema, Collection<Object> content) {
        if (schema == null || content == null) {
            return JsonNodeFactory.instance.nullNode();
        }
        ArrayNode convertedContent = JsonNodeFactory.instance.arrayNode();
        Schema flatSchema = schema.getFlatSchema(context);
        switch (flatSchema.getSupposedType(context)) {
            case "object": {
                for (Object value : content) {
                    convertedContent.add(this.convertObject(context, flatSchema, this.castMap(value)));
                }
                break;
            }
            case "array": {
                for (Object value : content) {
                    convertedContent.add(this.convertArray(context, flatSchema.getItemsSchema(), this.castList(value)));
                }
                break;
            }
            default: {
                for (Object value : content) {
                    convertedContent.add(this.convertPrimitive(context, flatSchema, value));
                }
            }
        }
        return convertedContent;
    }

    public JsonNode convertPrimitive(OAIContext context, Schema schema, Object value) {
        if (value == null) {
            return JsonNodeFactory.instance.nullNode();
        }
        if (schema == null) {
            return JsonNodeFactory.instance.textNode(value.toString());
        }
        try {
            Schema flatSchema = schema.getFlatSchema(context);
            switch (flatSchema.getSupposedType(context)) {
                case "boolean": {
                    return JsonNodeFactory.instance.booleanNode(this.parseBoolean(value.toString()));
                }
                case "integer": {
                    if ("int32".equals(flatSchema.getFormat())) {
                        return JsonNodeFactory.instance.numberNode(Integer.parseInt(value.toString()));
                    }
                    if ("int64".equals(flatSchema.getFormat())) {
                        return JsonNodeFactory.instance.numberNode(Long.parseLong(value.toString()));
                    }
                    return JsonNodeFactory.instance.numberNode(new BigInteger(value.toString()));
                }
                case "number": {
                    if ("float".equals(flatSchema.getFormat())) {
                        return JsonNodeFactory.instance.numberNode(Float.parseFloat(value.toString()));
                    }
                    if ("double".equals(flatSchema.getFormat())) {
                        return JsonNodeFactory.instance.numberNode(Double.parseDouble(value.toString()));
                    }
                    return JsonNodeFactory.instance.numberNode(new BigDecimal(value.toString()));
                }
            }
            return JsonNodeFactory.instance.textNode(value.toString());
        }
        catch (IllegalArgumentException ex) {
            return JsonNodeFactory.instance.textNode(value.toString());
        }
    }

    private boolean parseBoolean(String value) {
        if ("true".equals(value = value.trim().toLowerCase())) {
            return true;
        }
        if ("false".equals(value)) {
            return false;
        }
        throw new IllegalArgumentException(value);
    }

    private Map<String, Object> castMap(Object obj) {
        try {
            return (Map)obj;
        }
        catch (ClassCastException ex) {
            return null;
        }
    }

    private Collection<Object> castList(Object obj) {
        try {
            return (Collection)obj;
        }
        catch (ClassCastException ex) {
            return null;
        }
    }
}

