/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.operation.validator.util.convert;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.MapType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.UploadContext;
import org.openapi4j.core.model.OAIContext;
import org.openapi4j.core.util.IOUtil;
import org.openapi4j.core.util.TreeUtil;
import org.openapi4j.operation.validator.util.convert.ContentConverter;
import org.openapi4j.operation.validator.util.convert.TypeConverter;
import org.openapi4j.parser.model.v3.EncodingProperty;
import org.openapi4j.parser.model.v3.MediaType;
import org.openapi4j.parser.model.v3.Schema;

class MultipartConverter {
    private static final MultipartConverter INSTANCE = new MultipartConverter();
    private static final MapType MAP_TYPE = TreeUtil.json.getTypeFactory().constructMapType(HashMap.class, TreeUtil.json.getTypeFactory().constructType(String.class), TreeUtil.json.getTypeFactory().constructType(Object.class));
    private static final UploadContextInstance UPLOAD_CONTEXT_INSTANCE = (body, contentType, encoding) -> new UploadContext(){

        public String getCharacterEncoding() {
            return encoding;
        }

        public String getContentType() {
            return contentType;
        }

        public int getContentLength() {
            return 0;
        }

        public long contentLength() {
            return 0L;
        }

        public InputStream getInputStream() {
            return body;
        }
    };

    private MultipartConverter() {
    }

    public static MultipartConverter instance() {
        return INSTANCE;
    }

    JsonNode convert(OAIContext context, MediaType mediaType, String body, String rawContentType, String encoding) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(body.getBytes(encoding));
        return this.convert(context, mediaType, is, rawContentType, encoding);
    }

    JsonNode convert(OAIContext context, MediaType mediaType, InputStream body, String rawContentType, String encoding) throws IOException {
        UploadContext requestContext = UPLOAD_CONTEXT_INSTANCE.create(body, rawContentType, encoding);
        ObjectNode result = JsonNodeFactory.instance.objectNode();
        try {
            FileItemIterator iterator = new FileUpload().getItemIterator((RequestContext)requestContext);
            while (iterator.hasNext()) {
                FileItemStream item = iterator.next();
                String name = item.getFieldName();
                if (item.isFormField()) {
                    JsonNode convertedValue = this.mapValue(context, result, mediaType, item, name, encoding);
                    if (convertedValue == null) continue;
                    this.addValue(result, name, convertedValue);
                    continue;
                }
                this.addValue(result, name, (JsonNode)JsonNodeFactory.instance.textNode(item.getName()));
            }
        }
        catch (FileUploadException ex) {
            throw new IOException(ex);
        }
        return result;
    }

    private JsonNode mapValue(OAIContext context, ObjectNode result, MediaType mediaType, FileItemStream item, String name, String encoding) throws IOException {
        Schema propSchema = mediaType.getSchema().getProperty(name);
        String itemContentType = item.getContentType();
        if (itemContentType != null) {
            int checkResult = this.checkContentType(context, propSchema, mediaType.getEncoding(name), item);
            if (checkResult == -1) {
                String content = IOUtil.toString((InputStream)item.openStream(), (String)encoding);
                return JsonNodeFactory.instance.textNode(content);
            }
            if (checkResult == 0) {
                String content = IOUtil.toString((InputStream)item.openStream(), (String)encoding);
                try {
                    return ContentConverter.convert(context, new MediaType().setSchema(propSchema), itemContentType, null, content);
                }
                catch (IOException ex) {
                    return JsonNodeFactory.instance.textNode(content);
                }
            }
        }
        return this.convertToJsonNode(context, result, name, propSchema, item, encoding);
    }

    private int checkContentType(OAIContext context, Schema propSchema, EncodingProperty encProperty, FileItemStream item) {
        String specContentType;
        String itemContentType = item.getContentType();
        String string = specContentType = encProperty != null && encProperty.getContentType() != null ? encProperty.getContentType() : null;
        if (specContentType != null && !itemContentType.equals(specContentType)) {
            return -1;
        }
        Schema flatSchema = propSchema.getFlatSchema(context);
        switch (flatSchema.getSupposedType(context)) {
            case "object": {
                return itemContentType.equals("application/json") ? 1 : 0;
            }
            case "array": {
                return this.checkContentType(context, flatSchema.getItemsSchema(), encProperty, item);
            }
            case "string": {
                if (!"binary".equals(flatSchema.getFormat())) break;
                return itemContentType.equals("application/octet-stream") ? 1 : 0;
            }
        }
        return itemContentType.equals("text/plain") ? 1 : 0;
    }

    private JsonNode convertToJsonNode(OAIContext context, ObjectNode result, String name, Schema schema, FileItemStream item, String encoding) throws IOException {
        if (schema == null) {
            return TypeConverter.instance().convertPrimitive(context, null, IOUtil.toString((InputStream)item.openStream(), (String)encoding));
        }
        switch (schema.getSupposedType(context)) {
            case "object": {
                Map jsonContent = (Map)TreeUtil.json.readValue(item.openStream(), (JavaType)MAP_TYPE);
                return TypeConverter.instance().convertObject(context, schema, jsonContent);
            }
            case "array": {
                JsonNode convertedValue = this.convertToJsonNode(context, result, name, schema.getItemsSchema(), item, encoding);
                JsonNode previousValue = result.get(name);
                if (previousValue instanceof ArrayNode) {
                    ((ArrayNode)previousValue).add(convertedValue);
                } else {
                    result.set(name, (JsonNode)JsonNodeFactory.instance.arrayNode().add(convertedValue));
                }
                return null;
            }
        }
        return TypeConverter.instance().convertPrimitive(context, schema, IOUtil.toString((InputStream)item.openStream(), (String)encoding));
    }

    private void addValue(ObjectNode result, String name, JsonNode value) {
        JsonNode previousValue = result.get(name);
        if (previousValue != null) {
            if (previousValue instanceof ArrayNode) {
                ((ArrayNode)previousValue).add(value);
            } else {
                ArrayNode values = JsonNodeFactory.instance.arrayNode();
                values.add(previousValue);
                values.add(value);
                result.set(name, (JsonNode)values);
            }
        } else {
            result.set(name, value);
        }
    }

    @FunctionalInterface
    private static interface UploadContextInstance {
        public UploadContext create(InputStream var1, String var2, String var3);
    }
}

