/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.operation.validator.util.convert;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.openapi4j.core.model.OAIContext;
import org.openapi4j.core.util.IOUtil;
import org.openapi4j.core.util.MultiStringMap;
import org.openapi4j.core.util.StringUtil;
import org.openapi4j.core.util.TreeUtil;
import org.openapi4j.operation.validator.util.convert.ContentConverter;
import org.openapi4j.operation.validator.util.convert.TypeConverter;
import org.openapi4j.operation.validator.util.convert.style.DeepObjectStyleConverter;
import org.openapi4j.operation.validator.util.convert.style.FormStyleConverter;
import org.openapi4j.operation.validator.util.convert.style.PipeDelimitedStyleConverter;
import org.openapi4j.operation.validator.util.convert.style.SpaceDelimitedStyleConverter;
import org.openapi4j.parser.model.v3.AbsParameter;
import org.openapi4j.parser.model.v3.EncodingProperty;
import org.openapi4j.parser.model.v3.MediaType;
import org.openapi4j.parser.model.v3.Parameter;
import org.openapi4j.parser.model.v3.Schema;

class FormUrlConverter {
    private static final String SPACE_DELIMITED = "spaceDelimited";
    private static final String PIPE_DELIMITED = "pipeDelimited";
    private static final String DEEP_OBJECT = "deepObject";
    private static final FormUrlConverter INSTANCE = new FormUrlConverter();
    private final Map<MediaType, Map<String, AbsParameter<Parameter>>> mediaTypesCache = new HashMap<MediaType, Map<String, AbsParameter<Parameter>>>();

    public static FormUrlConverter instance() {
        return INSTANCE;
    }

    private FormUrlConverter() {
    }

    JsonNode convert(OAIContext context, MediaType mediaType, InputStream body, String encoding) throws IOException {
        return this.convert(context, mediaType, IOUtil.toString((InputStream)body, (String)encoding), encoding);
    }

    JsonNode convert(OAIContext context, MediaType mediaType, String body, String encoding) {
        Map<String, JsonNode> params = this.convert(context, this.getParameters(mediaType), body, true, encoding);
        return TreeUtil.json.valueToTree(params);
    }

    Map<String, JsonNode> convert(OAIContext context, Map<String, AbsParameter<Parameter>> specParameters, String body, boolean caseSensitive, String encoding) {
        HashMap<String, JsonNode> mappedValues = new HashMap<String, JsonNode>();
        if (body == null) {
            return mappedValues;
        }
        MultiStringMap<String> paramPairs = this.getParameterPairs(body, caseSensitive, encoding);
        ArrayList<String> visitedParams = new ArrayList<String>();
        for (Map.Entry<String, AbsParameter<Parameter>> paramEntry : specParameters.entrySet()) {
            JsonNode convertedValue;
            String specParamName = paramEntry.getKey();
            AbsParameter<Parameter> specParam = paramEntry.getValue();
            if (specParam.getSchema() != null) {
                String style = specParam.getStyle();
                if (SPACE_DELIMITED.equals(style)) {
                    convertedValue = SpaceDelimitedStyleConverter.instance().convert(context, (AbsParameter)specParam, specParamName, (MultiStringMap)paramPairs, visitedParams);
                } else if (PIPE_DELIMITED.equals(style)) {
                    convertedValue = PipeDelimitedStyleConverter.instance().convert(context, (AbsParameter)specParam, specParamName, (MultiStringMap)paramPairs, visitedParams);
                } else if (DEEP_OBJECT.equals(style)) {
                    convertedValue = DeepObjectStyleConverter.instance().convert(context, specParam, specParamName, paramPairs, visitedParams);
                } else {
                    if (specParam.getExplode() == null) {
                        specParam.setExplode(Boolean.valueOf(true));
                    }
                    convertedValue = FormStyleConverter.instance().convert(context, specParam, specParamName, paramPairs, visitedParams);
                }
            } else {
                convertedValue = this.getValueFromContentType(context, specParam.getContentMediaTypes(), specParamName, paramPairs, visitedParams);
            }
            if (convertedValue == null) continue;
            mappedValues.put(specParamName, convertedValue);
        }
        for (String key : visitedParams) {
            paramPairs.remove(key);
        }
        Schema defaultSchema = new Schema().setType("string");
        for (Map.Entry valueEntry : paramPairs.entrySet()) {
            Collection values = (Collection)valueEntry.getValue();
            JsonNode value = TypeConverter.instance().convertPrimitive(context, defaultSchema, values.iterator().next());
            mappedValues.put((String)valueEntry.getKey(), value);
        }
        return mappedValues;
    }

    private MultiStringMap<String> getParameterPairs(String value, boolean caseSensitive, String encoding) {
        List pairs = StringUtil.tokenize((String)value, (String)"&", (boolean)true, (boolean)true);
        MultiStringMap result = new MultiStringMap(caseSensitive);
        for (String pair : pairs) {
            int idx = pair.indexOf(61);
            if (idx == -1) {
                result.put(this.decode(pair, encoding), null);
                continue;
            }
            result.put(this.decode(pair.substring(0, idx), encoding), (Object)this.decode(pair.substring(idx + 1), encoding));
        }
        return result;
    }

    private String decode(String value, String encoding) {
        try {
            return URLDecoder.decode(value, encoding);
        }
        catch (UnsupportedEncodingException e) {
            try {
                return URLDecoder.decode(value, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException ignored) {
                return value;
            }
        }
    }

    private JsonNode getValueFromContentType(OAIContext context, Map<String, MediaType> mediaTypes, String paramName, MultiStringMap<String> paramPairs, List<String> visitedParams) {
        Optional entry;
        Collection propValues = paramPairs.get(paramName);
        if (propValues == null) {
            return null;
        }
        visitedParams.add(paramName);
        if (mediaTypes != null && (entry = mediaTypes.entrySet().stream().findFirst()).isPresent()) {
            Map.Entry mediaType = (Map.Entry)entry.get();
            try {
                return ContentConverter.convert(context, (MediaType)mediaType.getValue(), (String)mediaType.getKey(), null, propValues.stream().findFirst().orElse(null));
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    private Map<String, AbsParameter<Parameter>> getParameters(MediaType mediaType) {
        Map<String, AbsParameter<Parameter>> specParameters = this.mediaTypesCache.get(mediaType);
        if (specParameters != null) {
            return specParameters;
        }
        Map encodings = mediaType.getEncodings() != null ? mediaType.getEncodings() : new HashMap();
        specParameters = new HashMap<String, AbsParameter<Parameter>>();
        for (Map.Entry propEntry : mediaType.getSchema().getProperties().entrySet()) {
            String propName = (String)propEntry.getKey();
            specParameters.put(propName, this.createParameter(encodings, propName, (Schema)propEntry.getValue()));
        }
        this.mediaTypesCache.put(mediaType, specParameters);
        return specParameters;
    }

    private AbsParameter<Parameter> createParameter(Map<String, EncodingProperty> encodings, String propName, Schema schema) {
        EncodingProperty encodingProperty = encodings.get(propName);
        Parameter param = new Parameter().setName(propName);
        param.setSchema(schema);
        if (encodingProperty != null) {
            param.setStyle(encodingProperty.getStyle()).setExplode(encodingProperty.getExplode());
            if (encodingProperty.getContentType() != null) {
                param.setContentMediaType(encodingProperty.getContentType(), new MediaType().setSchema(schema));
                param.setSchema(null);
            }
        }
        return param;
    }
}

