/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.operation.validator.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ContentType {
    private static final Pattern JSON_PATTERN = Pattern.compile("(?:application|text)/(?:.+\\+)?json");
    private static final Pattern XML_PATTERN = Pattern.compile("(?:application|text)/(?:.+\\+)?xml");
    private static final Pattern CHARSET_PATTERN = Pattern.compile("(?:charset=)(.*)");

    private ContentType() {
    }

    public static boolean isJson(String contentType) {
        if (contentType == null) {
            return false;
        }
        return JSON_PATTERN.matcher(contentType.toLowerCase()).matches();
    }

    public static boolean isFormUrlEncoded(String contentType) {
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().startsWith("application/x-www-form-urlencoded");
    }

    public static boolean isMultipartFormData(String contentType) {
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().startsWith("multipart/form-data") || contentType.toLowerCase().startsWith("multipart/mixed");
    }

    public static boolean isXml(String contentType) {
        if (contentType == null) {
            return false;
        }
        return XML_PATTERN.matcher(contentType.toLowerCase()).matches();
    }

    public static String getCharSet(String contentType) {
        String charset;
        if (contentType == null) {
            return StandardCharsets.UTF_8.name();
        }
        Matcher matcher = CHARSET_PATTERN.matcher(contentType);
        if (matcher.find() && Charset.isSupported(charset = matcher.group(1).trim())) {
            return charset;
        }
        return StandardCharsets.UTF_8.name();
    }

    public static String getCharSetOrNull(String contentType) {
        String charset;
        if (contentType == null) {
            return null;
        }
        Matcher matcher = CHARSET_PATTERN.matcher(contentType);
        if (matcher.find() && Charset.isSupported(charset = matcher.group(1).trim())) {
            return charset;
        }
        return null;
    }

    public static String getTypeOnly(String contentType) {
        if (contentType == null) {
            return null;
        }
        int endIndex = contentType.indexOf(59);
        if (endIndex == -1) {
            return contentType;
        }
        return contentType.substring(0, endIndex).toLowerCase();
    }
}

