/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.operation.validator.model.impl;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.openapi4j.core.util.MultiStringMap;
import org.openapi4j.operation.validator.model.Response;
import org.openapi4j.operation.validator.model.impl.Body;

public class DefaultResponse
implements Response {
    private final int status;
    private final Map<String, Collection<String>> headers;
    private final Body body;

    private DefaultResponse(int status, Map<String, Collection<String>> headers, Body body) {
        this.status = status;
        this.headers = Objects.requireNonNull(headers);
        this.body = body;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public Body getBody() {
        return this.body;
    }

    @Override
    public Map<String, Collection<String>> getHeaders() {
        return this.headers;
    }

    @Override
    public Collection<String> getHeaderValues(String name) {
        return this.headers.get(name);
    }

    public static final class Builder {
        private final int status;
        private final MultiStringMap<String> headers;
        private Body body;

        public Builder(int status) {
            this.status = status;
            this.headers = new MultiStringMap(false);
        }

        public Builder headers(Map<String, Collection<String>> headers) {
            headers.forEach((arg_0, arg_1) -> this.headers.putAll(arg_0, arg_1));
            return this;
        }

        public Builder header(String name, Collection<String> values) {
            this.headers.putAll(name, values);
            return this;
        }

        public Builder header(String name, String value) {
            this.headers.put(name, (Object)value);
            return this;
        }

        public Builder body(Body body) {
            this.body = body;
            return this;
        }

        public DefaultResponse build() {
            return new DefaultResponse(this.status, this.headers.asUnmodifiableMap(), this.body);
        }
    }
}

