/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.operation.validator.model.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.openapi4j.core.model.OAIContext;
import org.openapi4j.core.util.TreeUtil;
import org.openapi4j.operation.validator.util.convert.ContentConverter;
import org.openapi4j.parser.model.v3.MediaType;

public class Body {
    private static final String BODY_REQUIRED_ERR_MSG = "Body content is required.";
    private final Object bodyObject;
    private final JsonNode bodyNode;
    private final String bodyStr;
    private final InputStream bodyIs;

    private Body(Object body) {
        this.bodyObject = body;
        this.bodyNode = null;
        this.bodyStr = null;
        this.bodyIs = null;
    }

    private Body(JsonNode bodyNode) {
        this.bodyObject = null;
        this.bodyNode = bodyNode;
        this.bodyStr = null;
        this.bodyIs = null;
    }

    private Body(String body) {
        this.bodyObject = null;
        this.bodyNode = null;
        this.bodyStr = body;
        this.bodyIs = null;
    }

    private Body(InputStream bodyIs) {
        this.bodyObject = null;
        this.bodyNode = null;
        this.bodyStr = null;
        this.bodyIs = bodyIs;
    }

    public static Body from(JsonNode body) {
        Objects.requireNonNull(body, BODY_REQUIRED_ERR_MSG);
        return new Body(body);
    }

    public static Body from(Object body) {
        Objects.requireNonNull(body, BODY_REQUIRED_ERR_MSG);
        return new Body(body);
    }

    public static Body from(String body) {
        Objects.requireNonNull(body, BODY_REQUIRED_ERR_MSG);
        return new Body(body);
    }

    public static Body from(InputStream body) {
        Objects.requireNonNull(body, BODY_REQUIRED_ERR_MSG);
        return new Body(body);
    }

    public JsonNode getContentAsNode(OAIContext context, MediaType mediaType, String rawContentType) throws IOException {
        if (this.bodyNode != null) {
            return this.bodyNode;
        }
        if (this.bodyObject != null) {
            return (JsonNode)TreeUtil.json.convertValue(this.bodyObject, JsonNode.class);
        }
        return ContentConverter.convert(context, mediaType, rawContentType, this.bodyIs, this.bodyStr);
    }
}

