/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import io.github.maksymdolgykh.dropwizard.micrometer.MicrometerBundle;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.prometheus.client.Histogram;
import org.openmetadata.service.OpenMetadataApplicationConfig;

public class MicrometerBundleSingleton {
    private static final MicrometerBundle instance = new MicrometerBundle();
    public static final PrometheusMeterRegistry prometheusMeterRegistry = MicrometerBundle.prometheusRegistry;
    private static Timer requestsLatencyTimer;
    private static Timer jdbiLatencyTimer;
    private static final double[] latencyBuckets;
    public static final Histogram httpRequests;
    public static final Histogram jdbiRequests;

    private MicrometerBundleSingleton() {
    }

    public static void initLatencyEvents(OpenMetadataApplicationConfig config) {
        requestsLatencyTimer = Timer.builder((String)"http_latency_requests").description("HTTP request latency in seconds.").publishPercentiles(config.getEventMonitorConfiguration().getLatency()).register((MeterRegistry)prometheusMeterRegistry);
        jdbiLatencyTimer = Timer.builder((String)"jdbi_latency_requests").description("JDBI queries latency in seconds.").publishPercentiles(config.getEventMonitorConfiguration().getLatency()).register((MeterRegistry)prometheusMeterRegistry);
    }

    public static MicrometerBundle getInstance() {
        return instance;
    }

    public static Timer getRequestsLatencyTimer() {
        return requestsLatencyTimer;
    }

    public static Timer getJdbiLatencyTimer() {
        return jdbiLatencyTimer;
    }

    static {
        latencyBuckets = new double[]{0.01, 0.1, 1.0, 2.0, 5.0, 10.0, 20.0, 60.0};
        httpRequests = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().name("http_server_requests_sec")).help("HTTP methods duration")).labelNames(new String[]{"method"})).buckets(latencyBuckets).register(prometheusMeterRegistry.getPrometheusRegistry());
        jdbiRequests = (Histogram)((Histogram.Builder)((Histogram.Builder)Histogram.build().name("jdbi_requests_seconds")).help("jdbi requests duration distribution")).buckets(latencyBuckets).register(MicrometerBundle.prometheusRegistry.getPrometheusRegistry());
    }
}

