/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Pipeline;
import org.openmetadata.schema.type.Task;
import org.openmetadata.service.Entity;
import org.openmetadata.service.search.ParseTags;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;

public class PipelineIndex
implements SearchIndex {
    final Pipeline pipeline;

    public PipelineIndex(Pipeline pipeline) {
        this.pipeline = pipeline;
    }

    @Override
    public List<SearchSuggest> getSuggest() {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.pipeline.getFullyQualifiedName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.pipeline.getDisplayName()).weight(10).build());
        return suggest;
    }

    @Override
    public Object getEntity() {
        return this.pipeline;
    }

    @Override
    public Map<String, Object> buildSearchIndexDocInternal(Map<String, Object> doc) {
        ArrayList<SearchSuggest> serviceSuggest = new ArrayList<SearchSuggest>();
        ArrayList<SearchSuggest> taskSuggest = new ArrayList<SearchSuggest>();
        serviceSuggest.add(SearchSuggest.builder().input(this.pipeline.getService() != null ? this.pipeline.getService().getName() : null).weight(5).build());
        if (this.pipeline.getTasks() != null) {
            for (Task task : this.pipeline.getTasks()) {
                taskSuggest.add(SearchSuggest.builder().input(task.getName()).weight(5).build());
            }
        }
        ParseTags parseTags = new ParseTags(Entity.getEntityTags("pipeline", (EntityInterface)this.pipeline));
        Map<String, Object> commonAttributes = this.getCommonAttributesMap((EntityInterface)this.pipeline, "pipeline");
        doc.putAll(commonAttributes);
        doc.put("name", this.pipeline.getName() != null ? this.pipeline.getName() : this.pipeline.getDisplayName());
        doc.put("displayName", this.pipeline.getDisplayName() != null ? this.pipeline.getDisplayName() : this.pipeline.getName());
        doc.put("tags", parseTags.getTags());
        doc.put("tier", parseTags.getTierTag());
        doc.put("task_suggest", taskSuggest);
        doc.put("service_suggest", serviceSuggest);
        doc.put("serviceType", this.pipeline.getServiceType());
        doc.put("lineage", SearchIndex.getLineageData(this.pipeline.getEntityReference()));
        doc.put("service", this.getEntityWithDisplayName(this.pipeline.getService()));
        return doc;
    }

    public static Map<String, Float> getFields() {
        Map<String, Float> fields = SearchIndex.getDefaultFields();
        fields.put("tasks.name", Float.valueOf(8.0f));
        fields.put("tasks.description", Float.valueOf(1.0f));
        return fields;
    }
}

