/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.UUID;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.EntityTimeSeriesInterface;
import org.openmetadata.schema.analytics.ReportData;
import org.openmetadata.schema.dataInsight.DataInsightChartResult;
import org.openmetadata.schema.service.configuration.elasticsearch.ElasticSearchConfiguration;
import org.openmetadata.schema.tests.TestSuite;
import org.openmetadata.schema.type.ChangeDescription;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.FieldChange;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.schema.type.UsageDetails;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.UnhandledServerException;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.search.SearchClient;
import org.openmetadata.service.search.SearchIndexFactory;
import org.openmetadata.service.search.SearchListFilter;
import org.openmetadata.service.search.SearchRequest;
import org.openmetadata.service.search.SearchSortFilter;
import org.openmetadata.service.search.elasticsearch.ElasticSearchClient;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.IndexMapping;
import org.openmetadata.service.search.opensearch.OpenSearchClient;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchRepository {
    private static final Logger LOG = LoggerFactory.getLogger(SearchRepository.class);
    private final SearchClient searchClient;
    private Map<String, IndexMapping> entityIndexMap;
    private final String language;
    public SearchIndexFactory searchIndexFactory = new SearchIndexFactory();
    private final List<String> inheritableFields = List.of("owner", "domain", "disabled");
    private final List<String> propagateFields = List.of("tags");
    private final ElasticSearchConfiguration elasticSearchConfiguration;
    private final String clusterAlias;
    public final List<String> dataInsightReports = List.of("entityReportData", "webAnalyticEntityViewReportData", "webAnalyticUserActivityReportData", "rawCostAnalysisReportData", "aggregatedCostAnalysisReportData");
    public static final String ELASTIC_SEARCH_EXTENSION = "service.eventPublisher";

    public SearchRepository(ElasticSearchConfiguration config) {
        this.elasticSearchConfiguration = config;
        this.searchClient = config != null && config.getSearchType() == ElasticSearchConfiguration.SearchType.OPENSEARCH ? new OpenSearchClient(config) : new ElasticSearchClient(config);
        try {
            if (config != null && !CommonUtil.nullOrEmpty((String)config.getSearchIndexFactoryClassName())) {
                this.searchIndexFactory = Class.forName(config.getSearchIndexFactoryClassName()).asSubclass(SearchIndexFactory.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to initialize search index factory using default one", (Throwable)e);
        }
        this.language = config != null && config.getSearchIndexMappingLanguage() != null ? config.getSearchIndexMappingLanguage().value() : "en";
        this.clusterAlias = config != null ? config.getClusterAlias() : "";
        this.loadIndexMappings();
        Entity.setSearchRepository(this);
    }

    private void loadIndexMappings() {
        Set entities;
        JsonObject jsonPayload;
        this.entityIndexMap = new HashMap<String, IndexMapping>();
        try (InputStream in = this.getClass().getResourceAsStream("/elasticsearch/indexMapping.json");){
            assert (in != null);
            jsonPayload = JsonUtils.readJson(new String(in.readAllBytes())).asJsonObject();
            entities = jsonPayload.keySet();
            for (String s : entities) {
                this.entityIndexMap.put(s, JsonUtils.readValue(((JsonValue)jsonPayload.get((Object)s)).toString(), IndexMapping.class));
            }
        }
        catch (Exception e) {
            throw new UnhandledServerException("Failed to load indexMapping.json", e);
        }
        try (InputStream in2 = this.getClass().getResourceAsStream("/elasticsearch/collate/indexMapping.json");){
            if (in2 != null) {
                jsonPayload = JsonUtils.readJson(new String(in2.readAllBytes())).asJsonObject();
                entities = jsonPayload.keySet();
                for (String s : entities) {
                    this.entityIndexMap.put(s, JsonUtils.readValue(((JsonValue)jsonPayload.get((Object)s)).toString(), IndexMapping.class));
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to load indexMapping.json");
        }
    }

    public ElasticSearchConfiguration.SearchType getSearchType() {
        return this.searchClient.getSearchType();
    }

    public void createIndexes() {
        for (IndexMapping indexMapping : this.entityIndexMap.values()) {
            this.createIndex(indexMapping);
        }
    }

    public void updateIndexes() {
        for (IndexMapping indexMapping : this.entityIndexMap.values()) {
            this.updateIndex(indexMapping);
        }
    }

    public void dropIndexes() {
        for (IndexMapping indexMapping : this.entityIndexMap.values()) {
            this.deleteIndex(indexMapping);
        }
    }

    public IndexMapping getIndexMapping(String entityType) {
        return this.entityIndexMap.get(entityType);
    }

    public String getIndexOrAliasName(String name) {
        return this.clusterAlias != null && !this.clusterAlias.isEmpty() ? this.clusterAlias + "_" + name : name;
    }

    public boolean indexExists(IndexMapping indexMapping) {
        return this.searchClient.indexExists(indexMapping.getIndexName(this.clusterAlias));
    }

    public void createIndex(IndexMapping indexMapping) {
        try {
            if (!this.indexExists(indexMapping)) {
                String indexMappingContent = this.getIndexMapping(indexMapping);
                this.searchClient.createIndex(indexMapping, indexMappingContent);
                this.searchClient.createAliases(indexMapping);
            }
        }
        catch (Exception e) {
            LOG.error(String.format("Failed to Create Index for entity %s due to ", indexMapping.getIndexName(this.clusterAlias)), (Throwable)e);
        }
    }

    public void updateIndex(IndexMapping indexMapping) {
        try {
            String indexMappingContent = this.getIndexMapping(indexMapping);
            if (this.indexExists(indexMapping)) {
                this.searchClient.updateIndex(indexMapping, indexMappingContent);
            } else {
                this.searchClient.createIndex(indexMapping, indexMappingContent);
            }
            this.searchClient.createAliases(indexMapping);
        }
        catch (Exception e) {
            LOG.warn(String.format("Failed to Update Index for entity %s", indexMapping.getIndexName(this.clusterAlias)));
        }
    }

    public void deleteIndex(IndexMapping indexMapping) {
        try {
            if (this.indexExists(indexMapping)) {
                this.searchClient.deleteIndex(indexMapping);
            }
        }
        catch (Exception e) {
            LOG.error(String.format("Failed to Delete Index for entity %s due to ", indexMapping.getIndexName(this.clusterAlias)), (Throwable)e);
        }
    }

    private String getIndexMapping(IndexMapping indexMapping) {
        String string;
        block9: {
            InputStream in = this.getClass().getResourceAsStream(String.format(indexMapping.getIndexMappingFile(), this.language.toLowerCase()));
            try {
                assert (in != null);
                string = new String(in.readAllBytes());
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.error("Failed to read index Mapping file due to ", (Throwable)e);
                    return null;
                }
            }
            in.close();
        }
        return string;
    }

    public void createEntity(EntityInterface entity) {
        if (entity != null) {
            String entityId = entity.getId().toString();
            String entityType = entity.getEntityReference().getType();
            try {
                IndexMapping indexMapping = this.entityIndexMap.get(entityType);
                SearchIndex index = this.searchIndexFactory.buildIndex(entityType, entity);
                String doc = JsonUtils.pojoToJson(index.buildSearchIndexDoc());
                this.searchClient.createEntity(indexMapping.getIndexName(this.clusterAlias), entityId, doc);
            }
            catch (Exception ie) {
                LOG.error(String.format("Issue in Creating new search document for entity [%s] and entityType [%s]. Reason[%s], Cause[%s], Stack [%s]", entityId, entityType, ie.getMessage(), ie.getCause(), ExceptionUtils.getStackTrace((Throwable)ie)));
            }
        }
    }

    public void createTimeSeriesEntity(EntityTimeSeriesInterface entity) {
        if (entity != null) {
            String entityType;
            if (entity instanceof ReportData) {
                ReportData reportData = (ReportData)entity;
                entityType = reportData.getReportDataType().toString();
            } else {
                entityType = entity.getEntityReference().getType();
            }
            String entityId = entity.getId().toString();
            try {
                IndexMapping indexMapping = this.entityIndexMap.get(entityType);
                SearchIndex index = this.searchIndexFactory.buildIndex(entityType, entity);
                String doc = JsonUtils.pojoToJson(index.buildSearchIndexDoc());
                this.searchClient.createTimeSeriesEntity(indexMapping.getIndexName(this.clusterAlias), entityId, doc);
            }
            catch (Exception ie) {
                LOG.error(String.format("Issue in Creating new search document for entity [%s] and entityType [%s]. Reason[%s], Cause[%s], Stack [%s]", entityId, entityType, ie.getMessage(), ie.getCause(), ExceptionUtils.getStackTrace((Throwable)ie)));
            }
        }
    }

    public void updateEntity(EntityInterface entity) {
        if (entity != null) {
            String entityType = entity.getEntityReference().getType();
            String entityId = entity.getId().toString();
            try {
                IndexMapping indexMapping = this.entityIndexMap.get(entityType);
                String scriptTxt = "for (k in params.keySet()) { ctx._source.put(k, params.get(k)) }";
                HashMap<String, Object> doc = new HashMap();
                if (entity.getChangeDescription() != null && Objects.equals(entity.getVersion(), entity.getChangeDescription().getPreviousVersion())) {
                    scriptTxt = this.getScriptWithParams(entity, doc);
                } else {
                    SearchIndex elasticSearchIndex = this.searchIndexFactory.buildIndex(entityType, entity);
                    doc = elasticSearchIndex.buildSearchIndexDoc();
                }
                this.searchClient.updateEntity(indexMapping.getIndexName(this.clusterAlias), entityId, doc, scriptTxt);
                this.propagateInheritedFieldsToChildren(entityType, entityId, entity.getChangeDescription(), indexMapping);
                this.propagateGlossaryTags(entityType, entity.getFullyQualifiedName(), entity.getChangeDescription());
            }
            catch (Exception ie) {
                LOG.error(String.format("Issue in Updating the search document for entity [%s] and entityType [%s]. Reason[%s], Cause[%s], Stack [%s]", entityId, entityType, ie.getMessage(), ie.getCause(), ExceptionUtils.getStackTrace((Throwable)ie)));
            }
        }
    }

    public void updateEntity(EntityReference entityReference) {
        EntityRepository<? extends EntityInterface> entityRepository = Entity.getEntityRepository(entityReference.getType());
        EntityInterface entity = entityRepository.get(null, entityReference.getId(), entityRepository.getFields("*"));
        this.updateEntity(entity);
    }

    public void propagateInheritedFieldsToChildren(String entityType, String entityId, ChangeDescription changeDescription, IndexMapping indexMapping) {
        if (changeDescription != null) {
            Pair<String, Map<String, Object>> updates = this.getInheritedFieldChanges(changeDescription);
            ImmutablePair parentMatch = !((Map)updates.getValue()).isEmpty() && ((Map)updates.getValue()).get("type").toString().equalsIgnoreCase("domain") ? (entityType.equalsIgnoreCase("databaseService") || entityType.equalsIgnoreCase("dashboardService") || entityType.equalsIgnoreCase("messagingService") || entityType.equalsIgnoreCase("pipelineService") || entityType.equalsIgnoreCase("mlmodelService") || entityType.equalsIgnoreCase("storageService") || entityType.equalsIgnoreCase("searchService") ? new ImmutablePair((Object)"service.id", (Object)entityId) : new ImmutablePair((Object)(entityType + ".id"), (Object)entityId)) : new ImmutablePair((Object)(entityType + ".id"), (Object)entityId);
            if (updates.getKey() != null && !((String)updates.getKey()).isEmpty()) {
                this.searchClient.updateChildren(indexMapping.getChildAliases(this.clusterAlias), (Pair<String, String>)parentMatch, updates);
            }
        }
    }

    public void propagateGlossaryTags(String entityType, String glossaryFQN, ChangeDescription changeDescription) {
        HashMap<String, List<TagLabel>> fieldData = new HashMap<String, List<TagLabel>>();
        if (changeDescription != null && entityType.equalsIgnoreCase("glossaryTerm")) {
            List<TagLabel> tagLabels;
            for (FieldChange field : changeDescription.getFieldsAdded()) {
                if (!this.propagateFields.contains(field.getName())) continue;
                tagLabels = JsonUtils.readObjects((String)((FieldChange)changeDescription.getFieldsAdded().get(0)).getNewValue(), TagLabel.class);
                tagLabels.forEach(tagLabel -> tagLabel.setLabelType(TagLabel.LabelType.DERIVED));
                fieldData.put("tagAdded", tagLabels);
            }
            for (FieldChange field : changeDescription.getFieldsDeleted()) {
                if (!this.propagateFields.contains(field.getName())) continue;
                tagLabels = JsonUtils.readObjects((String)((FieldChange)changeDescription.getFieldsDeleted().get(0)).getOldValue(), TagLabel.class);
                tagLabels.forEach(tagLabel -> tagLabel.setLabelType(TagLabel.LabelType.DERIVED));
                fieldData.put("tagDeleted", tagLabels);
            }
            this.searchClient.updateChildren("all", (Pair<String, String>)new ImmutablePair((Object)"tags.tagFQN", (Object)glossaryFQN), (Pair<String, Map<String, Object>>)new ImmutablePair((Object)"if (ctx._source.tags != null) { for (int i = ctx._source.tags.size() - 1; i >= 0; i--) { if (params.tagDeleted != null) { for (int j = 0; j < params.tagDeleted.size(); j++) { if (ctx._source.tags[i].tagFQN.equalsIgnoreCase(params.tagDeleted[j].tagFQN)) { ctx._source.tags.remove(i); } } } } } if (ctx._source.tags == null) { ctx._source.tags = []; } if (params.tagAdded != null) { ctx._source.tags.addAll(params.tagAdded); } ctx._source.tags = ctx._source.tags .stream() .distinct() .sorted((o1, o2) -> o1.tagFQN.compareTo(o2.tagFQN)) .collect(Collectors.toList());", fieldData));
        }
    }

    private Pair<String, Map<String, Object>> getInheritedFieldChanges(ChangeDescription changeDescription) {
        StringBuilder scriptTxt = new StringBuilder();
        Map<Object, Object> fieldData = new HashMap();
        if (changeDescription != null) {
            EntityReference entityReference;
            for (FieldChange field : changeDescription.getFieldsAdded()) {
                if (!this.inheritableFields.contains(field.getName())) continue;
                try {
                    entityReference = JsonUtils.readValue(field.getNewValue().toString(), EntityReference.class);
                    scriptTxt.append(String.format("if(ctx._source.%s == null){ ctx._source.put('%s', params)}", field.getName(), field.getName()));
                    fieldData = JsonUtils.getMap(entityReference);
                }
                catch (UnhandledServerException e) {
                    scriptTxt.append(String.format("ctx._source.put('%s', '%s')", field.getName(), field.getNewValue()));
                }
            }
            for (FieldChange field : changeDescription.getFieldsUpdated()) {
                if (!this.inheritableFields.contains(field.getName())) continue;
                try {
                    EntityReference oldEntityReference = JsonUtils.readValue(field.getOldValue().toString(), EntityReference.class);
                    EntityReference newEntityReference = JsonUtils.readValue(field.getNewValue().toString(), EntityReference.class);
                    scriptTxt.append(String.format("if((ctx._source.%s == null) || (ctx._source.%s.id == '%s')) { ctx._source.put('%s', params)}", field.getName(), field.getName(), oldEntityReference.getId().toString(), field.getName()));
                    fieldData = JsonUtils.getMap(newEntityReference);
                }
                catch (UnhandledServerException e) {
                    scriptTxt.append(String.format("ctx._source.put('%s', '%s')", field.getName(), field.getNewValue()));
                }
            }
            for (FieldChange field : changeDescription.getFieldsDeleted()) {
                if (!this.inheritableFields.contains(field.getName())) continue;
                try {
                    entityReference = JsonUtils.readValue(field.getOldValue().toString(), EntityReference.class);
                    scriptTxt.append(String.format("if((ctx._source.%s != null) && (ctx._source.%s.id == '%s')){ ctx._source.remove('%s')}", field.getName(), field.getName(), entityReference.getId().toString(), field.getName()));
                    fieldData = JsonUtils.getMap(entityReference);
                }
                catch (UnhandledServerException e) {
                    scriptTxt.append(String.format("ctx._source.remove('%s')", field.getName()));
                }
            }
        }
        return new ImmutablePair((Object)scriptTxt.toString(), fieldData);
    }

    public void deleteByScript(String entityType, String scriptTxt, Map<String, Object> params) {
        try {
            IndexMapping indexMapping = this.getIndexMapping(entityType);
            this.searchClient.deleteByScript(indexMapping.getIndexName(this.clusterAlias), scriptTxt, params);
        }
        catch (Exception ie) {
            LOG.error(String.format("Issue in Creating new search document for entityType [%s]. Reason[%s], Cause[%s], Stack [%s]", entityType, ie.getMessage(), ie.getCause(), ExceptionUtils.getStackTrace((Throwable)ie)));
        }
    }

    public void deleteEntity(EntityInterface entity) {
        if (entity != null) {
            String entityId = entity.getId().toString();
            String entityType = entity.getEntityReference().getType();
            IndexMapping indexMapping = this.entityIndexMap.get(entityType);
            try {
                this.searchClient.deleteEntity(indexMapping.getIndexName(this.clusterAlias), entityId);
                this.deleteOrUpdateChildren(entity, indexMapping);
            }
            catch (Exception ie) {
                LOG.error(String.format("Issue in Deleting the search document for entityID [%s] and entityType [%s]. Reason[%s], Cause[%s], Stack [%s]", entityId, entityType, ie.getMessage(), ie.getCause(), ExceptionUtils.getStackTrace((Throwable)ie)));
            }
        }
    }

    public void deleteTimeSeriesEntityById(EntityTimeSeriesInterface entity) {
        if (entity != null) {
            String entityId = entity.getId().toString();
            String entityType = entity.getEntityReference().getType();
            IndexMapping indexMapping = this.entityIndexMap.get(entityType);
            try {
                this.searchClient.deleteEntity(indexMapping.getIndexName(this.clusterAlias), entityId);
            }
            catch (Exception ie) {
                LOG.error(String.format("Issue in Deleting the search document for entityID [%s] and entityType [%s]. Reason[%s], Cause[%s], Stack [%s]", entityId, entityType, ie.getMessage(), ie.getCause(), ExceptionUtils.getStackTrace((Throwable)ie)));
            }
        }
    }

    public void softDeleteOrRestoreEntity(EntityInterface entity, boolean delete) {
        if (entity != null) {
            String entityId = entity.getId().toString();
            String entityType = entity.getEntityReference().getType();
            IndexMapping indexMapping = this.entityIndexMap.get(entityType);
            String scriptTxt = String.format("ctx._source.put('deleted', '%s')", delete);
            try {
                this.searchClient.softDeleteOrRestoreEntity(indexMapping.getIndexName(this.clusterAlias), entityId, scriptTxt);
                this.softDeleteOrRestoredChildren(entity.getEntityReference(), indexMapping, delete);
            }
            catch (Exception ie) {
                LOG.error(String.format("Issue in Soft Deleting the search document for entityID [%s] and entityType [%s]. Reason[%s], Cause[%s], Stack [%s]", entityId, entityType, ie.getMessage(), ie.getCause(), ExceptionUtils.getStackTrace((Throwable)ie)));
            }
        }
    }

    public void deleteOrUpdateChildren(EntityInterface entity, IndexMapping indexMapping) {
        String entityType;
        String docId = entity.getId().toString();
        switch (entityType = entity.getEntityReference().getType()) {
            case "domain": {
                this.searchClient.updateChildren("all", (Pair<String, String>)new ImmutablePair((Object)(entityType + ".id"), (Object)docId), (Pair<String, Map<String, Object>>)new ImmutablePair((Object)"ctx._source.remove('domain')", null));
                this.searchClient.deleteEntityByFields(indexMapping.getChildAliases(this.clusterAlias), List.of(new ImmutablePair((Object)(entityType + ".id"), (Object)docId)));
                break;
            }
            case "tag": 
            case "glossaryTerm": {
                this.searchClient.updateChildren("all", (Pair<String, String>)new ImmutablePair((Object)"tags.tagFQN", (Object)entity.getFullyQualifiedName()), (Pair<String, Map<String, Object>>)new ImmutablePair((Object)"for (int i = 0; i < ctx._source.tags.length; i++) { if (ctx._source.tags[i].tagFQN == params.fqn) { ctx._source.tags.remove(i) }}", Collections.singletonMap("fqn", entity.getFullyQualifiedName())));
                break;
            }
            case "testSuite": {
                TestSuite testSuite = (TestSuite)entity;
                if (Boolean.TRUE.equals(testSuite.getExecutable())) {
                    this.searchClient.deleteEntityByFields(indexMapping.getChildAliases(this.clusterAlias), List.of(new ImmutablePair((Object)"testSuite.id", (Object)docId)));
                    break;
                }
                this.searchClient.updateChildren(indexMapping.getChildAliases(this.clusterAlias), (Pair<String, String>)new ImmutablePair((Object)"testSuites.id", (Object)testSuite.getId().toString()), (Pair<String, Map<String, Object>>)new ImmutablePair((Object)"for (int i = 0; i < ctx._source.testSuites.length; i++) { if (ctx._source.testSuites[i].id == '%s') { ctx._source.testSuites.remove(i) }}", null));
                break;
            }
            case "dashboardService": 
            case "databaseService": 
            case "messagingService": 
            case "pipelineService": 
            case "mlmodelService": 
            case "storageService": 
            case "searchService": {
                this.searchClient.deleteEntityByFields(indexMapping.getChildAliases(this.clusterAlias), List.of(new ImmutablePair((Object)"service.id", (Object)docId)));
                break;
            }
            default: {
                this.searchClient.deleteEntityByFields(indexMapping.getChildAliases(this.clusterAlias), List.of(new ImmutablePair((Object)(entityType + ".id"), (Object)docId)));
            }
        }
    }

    public void softDeleteOrRestoredChildren(EntityReference entityReference, IndexMapping indexMapping, boolean delete) {
        String docId = entityReference.getId().toString();
        String entityType = entityReference.getType();
        String scriptTxt = String.format("ctx._source.put('deleted', '%s')", delete);
        switch (entityType) {
            case "dashboardService": 
            case "databaseService": 
            case "messagingService": 
            case "pipelineService": 
            case "mlmodelService": 
            case "storageService": 
            case "searchService": {
                this.searchClient.softDeleteOrRestoreChildren(indexMapping.getChildAliases(this.clusterAlias), scriptTxt, List.of(new ImmutablePair((Object)"service.id", (Object)docId)));
                break;
            }
            default: {
                this.searchClient.softDeleteOrRestoreChildren(indexMapping.getChildAliases(this.clusterAlias), scriptTxt, List.of(new ImmutablePair((Object)(entityType + ".id"), (Object)docId)));
            }
        }
    }

    public String getScriptWithParams(EntityInterface entity, Map<String, Object> fieldAddParams) {
        List entityReferences;
        ChangeDescription changeDescription = entity.getChangeDescription();
        List fieldsAdded = changeDescription.getFieldsAdded();
        StringBuilder scriptTxt = new StringBuilder();
        fieldAddParams.put("updatedAt", entity.getUpdatedAt());
        scriptTxt.append("ctx._source.updatedAt=params.updatedAt;");
        for (FieldChange fieldChange : fieldsAdded) {
            if (!fieldChange.getName().equalsIgnoreCase("followers")) continue;
            entityReferences = (List)fieldChange.getNewValue();
            ArrayList<String> newFollowers = new ArrayList<String>();
            for (EntityReference follower : entityReferences) {
                newFollowers.add(follower.getId().toString());
            }
            fieldAddParams.put(fieldChange.getName(), newFollowers);
            scriptTxt.append("ctx._source.followers.addAll(params.followers);");
        }
        for (FieldChange fieldChange : changeDescription.getFieldsDeleted()) {
            if (!fieldChange.getName().equalsIgnoreCase("followers")) continue;
            entityReferences = (List)fieldChange.getOldValue();
            for (EntityReference follower : entityReferences) {
                fieldAddParams.put(fieldChange.getName(), follower.getId().toString());
            }
            scriptTxt.append("ctx._source.followers.removeAll(Collections.singleton(params.followers));");
        }
        for (FieldChange fieldChange : changeDescription.getFieldsUpdated()) {
            Map<String, Object> doc;
            if (fieldChange.getName().equalsIgnoreCase("usageSummary")) {
                UsageDetails usageSummary = (UsageDetails)fieldChange.getNewValue();
                fieldAddParams.put(fieldChange.getName(), JsonUtils.getMap(usageSummary));
                scriptTxt.append("ctx._source.usageSummary = params.usageSummary;");
            }
            if (entity.getEntityReference().getType().equals("query") && fieldChange.getName().equalsIgnoreCase("queryUsedIn")) {
                fieldAddParams.put(fieldChange.getName(), JsonUtils.convertValue(fieldChange.getNewValue(), new TypeReference<List<LinkedHashMap<String, String>>>(){}));
                scriptTxt.append("ctx._source.queryUsedIn = params.queryUsedIn;");
            }
            if (fieldChange.getName().equalsIgnoreCase("votes")) {
                doc = JsonUtils.getMap(entity);
                fieldAddParams.put(fieldChange.getName(), doc.get("votes"));
                scriptTxt.append("ctx._source.votes = params.votes;");
            }
            if (!fieldChange.getName().equalsIgnoreCase("pipelineStatus")) continue;
            scriptTxt.append("if (ctx._source.containsKey('pipelineStatus')) { ctx._source.pipelineStatus = params.newPipelineStatus; } else { ctx._source['pipelineStatus'] = params.newPipelineStatus;}");
            doc = JsonUtils.getMap(entity);
            fieldAddParams.put("newPipelineStatus", doc.get("pipelineStatus"));
        }
        return scriptTxt.toString();
    }

    public Response search(SearchRequest request) throws IOException {
        return this.searchClient.search(request);
    }

    public Response getDocument(String indexName, UUID entityId) throws IOException {
        return this.searchClient.getDocByID(indexName, entityId.toString());
    }

    public SearchClient.SearchResultListMapper listWithOffset(SearchListFilter filter, int limit, int offset, String entityType, SearchSortFilter searchSortFilter, String q) throws IOException {
        IndexMapping index = this.entityIndexMap.get(entityType);
        return this.searchClient.listWithOffset(filter.getCondition(entityType), limit, offset, index.getIndexName(this.clusterAlias), searchSortFilter, q);
    }

    public Response searchBySourceUrl(String sourceUrl) throws IOException {
        return this.searchClient.searchBySourceUrl(sourceUrl);
    }

    public Response searchLineage(String fqn, int upstreamDepth, int downstreamDepth, String queryFilter, boolean deleted, String entityType) throws IOException {
        return this.searchClient.searchLineage(fqn, upstreamDepth, downstreamDepth, queryFilter, deleted, entityType);
    }

    public Map<String, Object> searchLineageForExport(String fqn, int upstreamDepth, int downstreamDepth, String queryFilter, boolean deleted, String entityType) throws IOException {
        return this.searchClient.searchLineageInternal(fqn, upstreamDepth, downstreamDepth, queryFilter, deleted, entityType);
    }

    public Response searchByField(String fieldName, String fieldValue, String index) throws IOException {
        return this.searchClient.searchByField(fieldName, fieldValue, index);
    }

    public Response aggregate(String index, String fieldName, String value, String query) throws IOException {
        return this.searchClient.aggregate(index, fieldName, value, query);
    }

    public JsonObject aggregate(String query, String index, JsonObject aggregationJson) throws IOException {
        return this.searchClient.aggregate(query, index, aggregationJson);
    }

    public Response suggest(SearchRequest request) throws IOException {
        return this.searchClient.suggest(request);
    }

    public SortedMap<Long, List<Object>> getSortedDate(String team, Long scheduleTime, Long currentTime, DataInsightChartResult.DataInsightChartType chartType, String indexName) throws IOException, ParseException {
        return this.searchClient.getSortedDate(team, scheduleTime, currentTime, chartType, indexName);
    }

    public Response listDataInsightChartResult(Long startTs, Long endTs, String tier, String team, DataInsightChartResult.DataInsightChartType dataInsightChartName, Integer size, Integer from, String queryFilter, String dataReportIndex) throws IOException, ParseException {
        return this.searchClient.listDataInsightChartResult(startTs, endTs, tier, team, dataInsightChartName, size, from, queryFilter, dataReportIndex);
    }

    public SearchClient getSearchClient() {
        return this.searchClient;
    }

    public SearchIndexFactory getSearchIndexFactory() {
        return this.searchIndexFactory;
    }

    public void setSearchIndexFactory(SearchIndexFactory searchIndexFactory) {
        this.searchIndexFactory = searchIndexFactory;
    }

    public ElasticSearchConfiguration getElasticSearchConfiguration() {
        return this.elasticSearchConfiguration;
    }

    public String getClusterAlias() {
        return this.clusterAlias;
    }

    public List<String> getDataInsightReports() {
        return this.dataInsightReports;
    }
}

