/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.csv.CsvUtil;
import org.openmetadata.csv.EntityCsv;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.api.data.TermReference;
import org.openmetadata.schema.entity.data.Glossary;
import org.openmetadata.schema.entity.data.GlossaryTerm;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.ProviderType;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.schema.type.csv.CsvDocumentation;
import org.openmetadata.schema.type.csv.CsvFile;
import org.openmetadata.schema.type.csv.CsvHeader;
import org.openmetadata.schema.type.csv.CsvImportResult;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.GlossaryTermRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlossaryRepository
extends EntityRepository<Glossary> {
    private static final Logger LOG = LoggerFactory.getLogger(GlossaryRepository.class);
    private static final String UPDATE_FIELDS = "";
    private static final String PATCH_FIELDS = "";

    public GlossaryRepository() {
        super("v1/glossaries/", "glossary", Glossary.class, Entity.getCollectionDAO().glossaryDAO(), "", "");
        this.quoteFqn = true;
        this.supportsSearch = true;
    }

    @Override
    public void setFields(Glossary glossary, EntityUtil.Fields fields) {
        glossary.setTermCount(fields.contains("termCount") ? this.getTermCount(glossary) : glossary.getTermCount());
        glossary.withUsageCount(fields.contains("usageCount") ? this.getUsageCount(glossary) : glossary.getUsageCount());
    }

    @Override
    public void clearFields(Glossary glossary, EntityUtil.Fields fields) {
        glossary.setTermCount(fields.contains("termCount") ? glossary.getTermCount() : null);
        glossary.withUsageCount(fields.contains("usageCount") ? glossary.getUsageCount() : null);
    }

    @Override
    public void prepare(Glossary glossary, boolean update) {
        this.validateUsers(glossary.getReviewers());
    }

    @Override
    public void storeEntity(Glossary glossary, boolean update) {
        List reviewers = glossary.getReviewers();
        glossary.withReviewers(null);
        this.store(glossary, update);
        glossary.withReviewers(reviewers);
    }

    @Override
    public void storeRelationships(Glossary glossary) {
        for (EntityReference reviewer : CommonUtil.listOrEmpty((List)glossary.getReviewers())) {
            this.addRelationship(reviewer.getId(), glossary.getId(), "user", "glossary", Relationship.REVIEWS);
        }
    }

    private Integer getUsageCount(Glossary glossary) {
        return this.daoCollection.tagUsageDAO().getTagCount(TagLabel.TagSource.GLOSSARY.ordinal(), glossary.getName());
    }

    private Integer getTermCount(Glossary glossary) {
        ListFilter filter = (ListFilter)new ListFilter(Include.NON_DELETED).addQueryParam("parent", FullyQualifiedName.build(glossary.getName()));
        return this.daoCollection.glossaryTermDAO().listCount(filter);
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(Glossary original, Glossary updated, EntityRepository.Operation operation) {
        return new GlossaryUpdater(original, updated, operation);
    }

    @Override
    public String exportToCsv(String name, String user) throws IOException {
        Glossary glossary = (Glossary)this.getByName(null, name, EntityUtil.Fields.EMPTY_FIELDS);
        GlossaryTermRepository repository = (GlossaryTermRepository)Entity.getEntityRepository("glossaryTerm");
        ListFilter filter = (ListFilter)new ListFilter(Include.NON_DELETED).addQueryParam("parent", name);
        List terms = repository.listAll(repository.getFields("owner,reviewers,tags,relatedTerms"), filter);
        terms.sort(Comparator.comparing(EntityInterface::getFullyQualifiedName));
        return new GlossaryCsv(glossary, user).exportCsv(terms);
    }

    @Override
    public CsvImportResult importFromCsv(String name, String csv, boolean dryRun, String user) throws IOException {
        Glossary glossary = (Glossary)this.getByName(null, name, EntityUtil.Fields.EMPTY_FIELDS);
        GlossaryCsv glossaryCsv = new GlossaryCsv(glossary, user);
        return glossaryCsv.importCsv(csv, dryRun);
    }

    private void updateAssetIndexesOnGlossaryUpdate(Glossary original, Glossary updated) {
        GlossaryTermRepository repository = (GlossaryTermRepository)Entity.getEntityRepository("glossaryTerm");
        HashSet<String> targetFQNHashesFromDb = new HashSet<String>(this.daoCollection.tagUsageDAO().getTargetFQNHashForTagPrefix(updated.getFullyQualifiedName()));
        List<EntityReference> childTerms = this.findTo(updated.getId(), "glossary", Relationship.CONTAINS, "glossaryTerm");
        for (EntityReference child : childTerms) {
            targetFQNHashesFromDb.addAll(this.daoCollection.tagUsageDAO().getTargetFQNHashForTag(child.getFullyQualifiedName()));
        }
        Map<String, EntityReference> targetFQNFromES = repository.getGlossaryUsageFromES(original.getFullyQualifiedName(), targetFQNHashesFromDb.size());
        Map<String, EntityReference> childrenTerms = repository.getGlossaryTermsContainingFQNFromES(original.getFullyQualifiedName(), this.getTermCount(updated));
        for (EntityReference child : childrenTerms.values()) {
            targetFQNFromES.putAll(repository.getGlossaryUsageFromES(child.getFullyQualifiedName(), targetFQNHashesFromDb.size()));
            this.searchRepository.updateEntity(child);
        }
        if (targetFQNFromES.size() == targetFQNHashesFromDb.size()) {
            for (String fqnHash : targetFQNHashesFromDb) {
                EntityReference refDetails = targetFQNFromES.get(fqnHash);
                if (refDetails == null) continue;
                this.searchRepository.updateEntity(refDetails);
            }
        }
    }

    public class GlossaryUpdater
    extends EntityRepository.EntityUpdater {
        public GlossaryUpdater(Glossary original, Glossary updated, EntityRepository.Operation operation) {
            super((EntityRepository)GlossaryRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
            GlossaryRepository.this.renameAllowed = true;
        }

        @Override
        @Transaction
        public void entitySpecificUpdate() {
            this.updateName((Glossary)this.original, (Glossary)this.updated);
            ((Glossary)this.updated).setMutuallyExclusive(((Glossary)this.original).getMutuallyExclusive());
        }

        public void updateName(Glossary original, Glossary updated) {
            if (!original.getName().equals(updated.getName())) {
                if (ProviderType.SYSTEM.equals((Object)original.getProvider())) {
                    throw new IllegalArgumentException(CatalogExceptionMessage.systemEntityRenameNotAllowed(original.getName(), GlossaryRepository.this.entityType));
                }
                LOG.info("Glossary name changed from {} to {}", (Object)original.getName(), (Object)updated.getName());
                GlossaryRepository.this.setFullyQualifiedName(updated);
                GlossaryRepository.this.daoCollection.glossaryTermDAO().updateFqn(original.getName(), updated.getName());
                GlossaryRepository.this.daoCollection.tagUsageDAO().updateTagPrefix(TagLabel.TagSource.GLOSSARY.ordinal(), original.getName(), updated.getName());
                this.recordChange("name", original.getName(), updated.getName());
                this.invalidateGlossary(original.getId());
                GlossaryRepository.this.daoCollection.tagUsageDAO().renameByTargetFQNHash(TagLabel.TagSource.CLASSIFICATION.ordinal(), original.getFullyQualifiedName(), updated.getFullyQualifiedName());
                GlossaryRepository.this.updateAssetIndexesOnGlossaryUpdate(original, updated);
            }
        }

        public void invalidateGlossary(UUID classificationId) {
            EntityRepository.CACHE_WITH_ID.invalidate((Object)new ImmutablePair((Object)"glossary", (Object)classificationId));
            List<CollectionDAO.EntityRelationshipRecord> tags = GlossaryRepository.this.findToRecords(classificationId, "glossary", Relationship.CONTAINS, "glossaryTerm");
            for (CollectionDAO.EntityRelationshipRecord tagRecord : tags) {
                this.invalidateTerms(tagRecord.getId());
            }
        }

        private void invalidateTerms(UUID termId) {
            List<CollectionDAO.EntityRelationshipRecord> tagRecords = GlossaryRepository.this.findToRecords(termId, "glossaryTerm", Relationship.CONTAINS, "glossaryTerm");
            EntityRepository.CACHE_WITH_ID.invalidate((Object)new ImmutablePair((Object)"glossaryTerm", (Object)termId));
            for (CollectionDAO.EntityRelationshipRecord tagRecord : tagRecords) {
                this.invalidateTerms(tagRecord.getId());
            }
        }
    }

    public static class GlossaryCsv
    extends EntityCsv<GlossaryTerm> {
        public static final CsvDocumentation DOCUMENTATION = GlossaryCsv.getCsvDocumentation("glossary");
        public static final List<CsvHeader> HEADERS = DOCUMENTATION.getHeaders();
        private final Glossary glossary;

        GlossaryCsv(Glossary glossary, String user) {
            super("glossaryTerm", HEADERS, user);
            this.glossary = glossary;
        }

        @Override
        protected void createEntity(CSVPrinter printer, List<CSVRecord> csvRecords) throws IOException {
            CSVRecord csvRecord = this.getNextRecord(printer, csvRecords);
            GlossaryTerm glossaryTerm = new GlossaryTerm().withGlossary(this.glossary.getEntityReference());
            glossaryTerm.withParent(this.getEntityReference(printer, csvRecord, 0, "glossaryTerm")).withName(csvRecord.get(1)).withDisplayName(csvRecord.get(2)).withDescription(csvRecord.get(3)).withSynonyms(CsvUtil.fieldToStrings(csvRecord.get(4))).withRelatedTerms(this.getEntityReferences(printer, csvRecord, 5, "glossaryTerm")).withReferences(this.getTermReferences(printer, csvRecord)).withTags(this.getTagLabels(printer, csvRecord, List.of(Pair.of((Object)7, (Object)TagLabel.TagSource.CLASSIFICATION)))).withReviewers(this.getEntityReferences(printer, csvRecord, 8, "user")).withOwner(this.getOwner(printer, csvRecord, 9)).withStatus(this.getTermStatus(printer, csvRecord));
            if (this.processRecord) {
                this.createEntity(printer, csvRecord, glossaryTerm);
            }
        }

        private List<TermReference> getTermReferences(CSVPrinter printer, CSVRecord csvRecord) throws IOException {
            if (!this.processRecord) {
                return null;
            }
            String termRefs = csvRecord.get(6);
            if (CommonUtil.nullOrEmpty((String)termRefs)) {
                return null;
            }
            List<String> termRefList = CsvUtil.fieldToStrings(termRefs);
            if (termRefList.size() % 2 != 0) {
                this.importFailure(printer, GlossaryCsv.invalidField(6, "Term references should termName;endpoint"), csvRecord);
                this.processRecord = false;
                return null;
            }
            ArrayList<TermReference> list = new ArrayList<TermReference>();
            int i = 0;
            while (i < termRefList.size()) {
                list.add(new TermReference().withName(termRefList.get(i++)).withEndpoint(URI.create(termRefList.get(i++))));
            }
            return list;
        }

        private GlossaryTerm.Status getTermStatus(CSVPrinter printer, CSVRecord csvRecord) throws IOException {
            if (!this.processRecord) {
                return null;
            }
            String termStatus = csvRecord.get(10);
            try {
                return CommonUtil.nullOrEmpty((String)termStatus) ? GlossaryTerm.Status.DRAFT : GlossaryTerm.Status.fromValue((String)termStatus);
            }
            catch (Exception ex) {
                this.importFailure(printer, GlossaryCsv.invalidField(10, String.format("Glossary term status %s is invalid", termStatus)), csvRecord);
                this.processRecord = false;
                return null;
            }
        }

        @Override
        protected void addRecord(CsvFile csvFile, GlossaryTerm entity) {
            ArrayList<String> recordList = new ArrayList<String>();
            CsvUtil.addEntityReference(recordList, entity.getParent());
            CsvUtil.addField(recordList, entity.getName());
            CsvUtil.addField(recordList, entity.getDisplayName());
            CsvUtil.addField(recordList, entity.getDescription());
            CsvUtil.addFieldList(recordList, entity.getSynonyms());
            CsvUtil.addEntityReferences(recordList, entity.getRelatedTerms());
            CsvUtil.addField(recordList, this.termReferencesToRecord(entity.getReferences()));
            CsvUtil.addTagLabels(recordList, entity.getTags());
            CsvUtil.addField(recordList, this.reviewerReferencesToRecord(entity.getReviewers()));
            CsvUtil.addOwner(recordList, entity.getOwner());
            CsvUtil.addField(recordList, entity.getStatus().value());
            this.addRecord(csvFile, (List<String>)recordList);
        }

        private String termReferencesToRecord(List<TermReference> list) {
            return CommonUtil.nullOrEmpty(list) ? null : list.stream().map(termReference -> termReference.getName() + ";" + termReference.getEndpoint()).collect(Collectors.joining(";"));
        }

        private String reviewerReferencesToRecord(List<EntityReference> reviewers) {
            return CommonUtil.nullOrEmpty(reviewers) ? null : reviewers.stream().map(EntityReference::getName).collect(Collectors.joining(";"));
        }
    }
}

