/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.tuple.Pair;
import org.openmetadata.csv.CsvUtil;
import org.openmetadata.csv.EntityCsv;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.api.services.DatabaseConnection;
import org.openmetadata.schema.entity.data.Database;
import org.openmetadata.schema.entity.services.DatabaseService;
import org.openmetadata.schema.entity.services.ServiceType;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.schema.type.csv.CsvDocumentation;
import org.openmetadata.schema.type.csv.CsvFile;
import org.openmetadata.schema.type.csv.CsvHeader;
import org.openmetadata.schema.type.csv.CsvImportResult;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.DatabaseRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.ServiceEntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseServiceRepository
extends ServiceEntityRepository<DatabaseService, DatabaseConnection> {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseServiceRepository.class);

    public DatabaseServiceRepository() {
        super("v1/services/databaseServices/", "databaseService", Entity.getCollectionDAO().dbServiceDAO(), DatabaseConnection.class, "", ServiceType.DATABASE);
        this.supportsSearch = true;
    }

    @Override
    public String exportToCsv(String name, String user) throws IOException {
        DatabaseService databaseService = (DatabaseService)this.getByName(null, name, EntityUtil.Fields.EMPTY_FIELDS);
        DatabaseRepository repository = (DatabaseRepository)Entity.getEntityRepository("database");
        ListFilter filter = (ListFilter)new ListFilter(Include.NON_DELETED).addQueryParam("service", name);
        List databases = repository.listAll(repository.getFields("owner,tags,domain"), filter);
        databases.sort(Comparator.comparing(EntityInterface::getFullyQualifiedName));
        return new DatabaseServiceCsv(databaseService, user).exportCsv(databases);
    }

    @Override
    public CsvImportResult importFromCsv(String name, String csv, boolean dryRun, String user) throws IOException {
        DatabaseService databaseService = (DatabaseService)this.getByName(null, name, EntityUtil.Fields.EMPTY_FIELDS);
        DatabaseServiceCsv databaseServiceCsv = new DatabaseServiceCsv(databaseService, user);
        return databaseServiceCsv.importCsv(csv, dryRun);
    }

    public static class DatabaseServiceCsv
    extends EntityCsv<Database> {
        public static final CsvDocumentation DOCUMENTATION = DatabaseServiceCsv.getCsvDocumentation("databaseService");
        public static final List<CsvHeader> HEADERS = DOCUMENTATION.getHeaders();
        private final DatabaseService service;

        DatabaseServiceCsv(DatabaseService service, String user) {
            super("database", DOCUMENTATION.getHeaders(), user);
            this.service = service;
        }

        @Override
        protected void createEntity(CSVPrinter printer, List<CSVRecord> csvRecords) throws IOException {
            Database database;
            CSVRecord csvRecord = this.getNextRecord(printer, csvRecords);
            String databaseFqn = FullyQualifiedName.add(this.service.getFullyQualifiedName(), csvRecord.get(0));
            try {
                database = (Database)Entity.getEntityByName("database", databaseFqn, "*", Include.NON_DELETED);
            }
            catch (EntityNotFoundException ex) {
                LOG.warn("Database not found: {}, it will be created with Import.", (Object)databaseFqn);
                database = new Database().withService(this.service.getEntityReference());
            }
            List<TagLabel> tagLabels = this.getTagLabels(printer, csvRecord, List.of(Pair.of((Object)4, (Object)TagLabel.TagSource.CLASSIFICATION), Pair.of((Object)5, (Object)TagLabel.TagSource.GLOSSARY), Pair.of((Object)6, (Object)TagLabel.TagSource.CLASSIFICATION)));
            database.withName(csvRecord.get(0)).withDisplayName(csvRecord.get(1)).withDescription(csvRecord.get(2)).withOwner(this.getOwner(printer, csvRecord, 3)).withTags(tagLabels).withDomain(this.getEntityReference(printer, csvRecord, 7, "domain"));
            if (this.processRecord) {
                this.createEntity(printer, csvRecord, database);
            }
        }

        @Override
        protected void addRecord(CsvFile csvFile, Database entity) {
            ArrayList<String> recordList = new ArrayList<String>();
            CsvUtil.addField(recordList, entity.getName());
            CsvUtil.addField(recordList, entity.getDisplayName());
            CsvUtil.addField(recordList, entity.getDescription());
            CsvUtil.addOwner(recordList, entity.getOwner());
            CsvUtil.addTagLabels(recordList, entity.getTags());
            CsvUtil.addGlossaryTerms(recordList, entity.getTags());
            CsvUtil.addTagTiers(recordList, entity.getTags());
            String domain = entity.getDomain() == null || Boolean.TRUE.equals(entity.getDomain().getInherited()) ? "" : entity.getDomain().getFullyQualifiedName();
            CsvUtil.addField(recordList, domain);
            this.addRecord(csvFile, (List<String>)recordList);
        }
    }
}

