/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import com.fasterxml.jackson.core.type.TypeReference;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.StatementException;
import org.jdbi.v3.sqlobject.CreateSqlObject;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBeanList;
import org.jdbi.v3.sqlobject.customizer.BindList;
import org.jdbi.v3.sqlobject.customizer.BindMap;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.openmetadata.api.configuration.UiThemePreference;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.TokenInterface;
import org.openmetadata.schema.analytics.ReportData;
import org.openmetadata.schema.analytics.WebAnalyticEvent;
import org.openmetadata.schema.api.configuration.LoginConfiguration;
import org.openmetadata.schema.api.configuration.profiler.ProfilerConfiguration;
import org.openmetadata.schema.auth.EmailVerificationToken;
import org.openmetadata.schema.auth.PasswordResetToken;
import org.openmetadata.schema.auth.PersonalAccessToken;
import org.openmetadata.schema.auth.RefreshToken;
import org.openmetadata.schema.auth.TokenType;
import org.openmetadata.schema.dataInsight.DataInsightChart;
import org.openmetadata.schema.dataInsight.kpi.Kpi;
import org.openmetadata.schema.email.SmtpSettings;
import org.openmetadata.schema.entities.docStore.Document;
import org.openmetadata.schema.entity.Bot;
import org.openmetadata.schema.entity.Type;
import org.openmetadata.schema.entity.app.App;
import org.openmetadata.schema.entity.app.AppMarketPlaceDefinition;
import org.openmetadata.schema.entity.automations.Workflow;
import org.openmetadata.schema.entity.classification.Classification;
import org.openmetadata.schema.entity.classification.Tag;
import org.openmetadata.schema.entity.data.Chart;
import org.openmetadata.schema.entity.data.Container;
import org.openmetadata.schema.entity.data.Dashboard;
import org.openmetadata.schema.entity.data.DashboardDataModel;
import org.openmetadata.schema.entity.data.Database;
import org.openmetadata.schema.entity.data.DatabaseSchema;
import org.openmetadata.schema.entity.data.Glossary;
import org.openmetadata.schema.entity.data.GlossaryTerm;
import org.openmetadata.schema.entity.data.Metrics;
import org.openmetadata.schema.entity.data.MlModel;
import org.openmetadata.schema.entity.data.Pipeline;
import org.openmetadata.schema.entity.data.Query;
import org.openmetadata.schema.entity.data.Report;
import org.openmetadata.schema.entity.data.SearchIndex;
import org.openmetadata.schema.entity.data.StoredProcedure;
import org.openmetadata.schema.entity.data.Table;
import org.openmetadata.schema.entity.data.Topic;
import org.openmetadata.schema.entity.domains.DataProduct;
import org.openmetadata.schema.entity.domains.Domain;
import org.openmetadata.schema.entity.events.EventSubscription;
import org.openmetadata.schema.entity.policies.Policy;
import org.openmetadata.schema.entity.services.DashboardService;
import org.openmetadata.schema.entity.services.DatabaseService;
import org.openmetadata.schema.entity.services.MessagingService;
import org.openmetadata.schema.entity.services.MetadataService;
import org.openmetadata.schema.entity.services.MlModelService;
import org.openmetadata.schema.entity.services.PipelineService;
import org.openmetadata.schema.entity.services.SearchService;
import org.openmetadata.schema.entity.services.StorageService;
import org.openmetadata.schema.entity.services.connections.TestConnectionDefinition;
import org.openmetadata.schema.entity.services.ingestionPipelines.IngestionPipeline;
import org.openmetadata.schema.entity.teams.Persona;
import org.openmetadata.schema.entity.teams.Role;
import org.openmetadata.schema.entity.teams.Team;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.settings.Settings;
import org.openmetadata.schema.settings.SettingsType;
import org.openmetadata.schema.tests.TestCase;
import org.openmetadata.schema.tests.TestDefinition;
import org.openmetadata.schema.tests.TestSuite;
import org.openmetadata.schema.type.EventType;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.schema.type.UsageDetails;
import org.openmetadata.schema.type.UsageStats;
import org.openmetadata.schema.util.EntitiesCount;
import org.openmetadata.schema.util.ServicesCount;
import org.openmetadata.schema.utils.EntityInterfaceUtil;
import org.openmetadata.service.jdbi3.EntityDAO;
import org.openmetadata.service.jdbi3.EntityTimeSeriesDAO;
import org.openmetadata.service.jdbi3.FeedFilter;
import org.openmetadata.service.jdbi3.FeedRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.locator.ConnectionAwareSqlQuery;
import org.openmetadata.service.jdbi3.locator.ConnectionAwareSqlQueryContainer;
import org.openmetadata.service.jdbi3.locator.ConnectionAwareSqlUpdate;
import org.openmetadata.service.jdbi3.locator.ConnectionAwareSqlUpdateContainer;
import org.openmetadata.service.jdbi3.locator.ConnectionType;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.resources.tags.TagLabelUtil;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.jdbi.BindFQN;
import org.openmetadata.service.util.jdbi.BindUUID;

public interface CollectionDAO {
    @CreateSqlObject
    public DatabaseDAO databaseDAO();

    @CreateSqlObject
    public DatabaseSchemaDAO databaseSchemaDAO();

    @CreateSqlObject
    public EntityRelationshipDAO relationshipDAO();

    @CreateSqlObject
    public FieldRelationshipDAO fieldRelationshipDAO();

    @CreateSqlObject
    public EntityExtensionDAO entityExtensionDAO();

    @CreateSqlObject
    public AppExtensionTimeSeries appExtensionTimeSeriesDao();

    @CreateSqlObject
    public EntityExtensionTimeSeriesDAO entityExtensionTimeSeriesDao();

    @CreateSqlObject
    public ReportDataTimeSeriesDAO reportDataTimeSeriesDao();

    @CreateSqlObject
    public ProfilerDataTimeSeriesDAO profilerDataTimeSeriesDao();

    @CreateSqlObject
    public DataQualityDataTimeSeriesDAO dataQualityDataTimeSeriesDao();

    @CreateSqlObject
    public TestCaseResolutionStatusTimeSeriesDAO testCaseResolutionStatusTimeSeriesDao();

    @CreateSqlObject
    public RoleDAO roleDAO();

    @CreateSqlObject
    public UserDAO userDAO();

    @CreateSqlObject
    public TeamDAO teamDAO();

    @CreateSqlObject
    public PersonaDAO personaDAO();

    @CreateSqlObject
    public TagUsageDAO tagUsageDAO();

    @CreateSqlObject
    public TagDAO tagDAO();

    @CreateSqlObject
    public ClassificationDAO classificationDAO();

    @CreateSqlObject
    public TableDAO tableDAO();

    @CreateSqlObject
    public QueryDAO queryDAO();

    @CreateSqlObject
    public UsageDAO usageDAO();

    @CreateSqlObject
    public MetricsDAO metricsDAO();

    @CreateSqlObject
    public ChartDAO chartDAO();

    @CreateSqlObject
    public ApplicationDAO applicationDAO();

    @CreateSqlObject
    public ApplicationMarketPlaceDAO applicationMarketPlaceDAO();

    @CreateSqlObject
    public PipelineDAO pipelineDAO();

    @CreateSqlObject
    public DashboardDAO dashboardDAO();

    @CreateSqlObject
    public ReportDAO reportDAO();

    @CreateSqlObject
    public TopicDAO topicDAO();

    @CreateSqlObject
    public MlModelDAO mlModelDAO();

    @CreateSqlObject
    public SearchIndexDAO searchIndexDAO();

    @CreateSqlObject
    public GlossaryDAO glossaryDAO();

    @CreateSqlObject
    public GlossaryTermDAO glossaryTermDAO();

    @CreateSqlObject
    public BotDAO botDAO();

    @CreateSqlObject
    public DomainDAO domainDAO();

    @CreateSqlObject
    public DataProductDAO dataProductDAO();

    @CreateSqlObject
    public EventSubscriptionDAO eventSubscriptionDAO();

    @CreateSqlObject
    public PolicyDAO policyDAO();

    @CreateSqlObject
    public IngestionPipelineDAO ingestionPipelineDAO();

    @CreateSqlObject
    public DatabaseServiceDAO dbServiceDAO();

    @CreateSqlObject
    public MetadataServiceDAO metadataServiceDAO();

    @CreateSqlObject
    public PipelineServiceDAO pipelineServiceDAO();

    @CreateSqlObject
    public MlModelServiceDAO mlModelServiceDAO();

    @CreateSqlObject
    public DashboardServiceDAO dashboardServiceDAO();

    @CreateSqlObject
    public MessagingServiceDAO messagingServiceDAO();

    @CreateSqlObject
    public StorageServiceDAO storageServiceDAO();

    @CreateSqlObject
    public SearchServiceDAO searchServiceDAO();

    @CreateSqlObject
    public ContainerDAO containerDAO();

    @CreateSqlObject
    public FeedDAO feedDAO();

    @CreateSqlObject
    public StoredProcedureDAO storedProcedureDAO();

    @CreateSqlObject
    public ChangeEventDAO changeEventDAO();

    @CreateSqlObject
    public TypeEntityDAO typeEntityDAO();

    @CreateSqlObject
    public TestDefinitionDAO testDefinitionDAO();

    @CreateSqlObject
    public TestConnectionDefinitionDAO testConnectionDefinitionDAO();

    @CreateSqlObject
    public TestSuiteDAO testSuiteDAO();

    @CreateSqlObject
    public TestCaseDAO testCaseDAO();

    @CreateSqlObject
    public WebAnalyticEventDAO webAnalyticEventDAO();

    @CreateSqlObject
    public DataInsightChartDAO dataInsightChartDAO();

    @CreateSqlObject
    public SystemDAO systemDAO();

    @CreateSqlObject
    public TokenDAO getTokenDAO();

    @CreateSqlObject
    public KpiDAO kpiDAO();

    @CreateSqlObject
    public WorkflowDAO workflowDAO();

    @CreateSqlObject
    public DataModelDAO dashboardDataModelDAO();

    @CreateSqlObject
    public DocStoreDAO docStoreDAO();

    @CreateSqlObject
    public SuggestionDAO suggestionDAO();

    public static interface SuggestionDAO {
        default public String getTableName() {
            return "suggestions";
        }

        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT INTO suggestions(fqnHash, json) VALUES (:fqnHash, :json)", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO suggestions(fqnHash, json) VALUES (:fqnHash, :json :: jsonb)", connectionType=ConnectionType.POSTGRES)})
        public void insert(@BindFQN(value="fqnHash") String var1, @Bind(value="json") String var2);

        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="UPDATE suggestions SET json = :json where id = :id", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="UPDATE suggestions SET json = (:json :: jsonb) where id = :id", connectionType=ConnectionType.POSTGRES)})
        public void update(@BindUUID(value="id") UUID var1, @Bind(value="json") String var2);

        @SqlQuery(value="SELECT json FROM suggestions WHERE id = :id")
        public String findById(@BindUUID(value="id") UUID var1);

        @SqlUpdate(value="DELETE FROM suggestions WHERE id = :id")
        public void delete(@BindUUID(value="id") UUID var1);

        @SqlUpdate(value="DELETE FROM suggestions WHERE fqnHash = :fqnHash")
        public void deleteByFQN(@BindUUID(value="fqnHash") String var1);

        @SqlQuery(value="SELECT json FROM suggestions <condition> ORDER BY updatedAt DESC LIMIT :limit")
        public List<String> list(@Bind(value="limit") int var1, @Define(value="condition") String var2);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT count(*) FROM suggestions <mysqlCond>", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT count(*) FROM suggestions <postgresCond>", connectionType=ConnectionType.POSTGRES)})
        public int listCount(@Define(value="mysqlCond") String var1, @Define(value="postgresCond") String var2);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT json FROM (SELECT updatedAt, json FROM suggestions <mysqlCond> ORDER BY updatedAt DESC LIMIT :limit) last_rows_subquery ORDER BY updatedAt", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT json FROM (SELECT updatedAt, json FROM suggestions <psqlCond> ORDER BY updatedAt DESC LIMIT :limit) last_rows_subquery ORDER BY updatedAt", connectionType=ConnectionType.POSTGRES)})
        public List<String> listBefore(@Define(value="mysqlCond") String var1, @Define(value="psqlCond") String var2, @Bind(value="limit") int var3, @Bind(value="before") String var4);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT json FROM suggestions <mysqlCond>  ORDER BY updatedAt DESC LIMIT :limit", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT json FROM suggestions <psqlCond>  ORDER BY updatedAt DESC LIMIT :limit", connectionType=ConnectionType.POSTGRES)})
        public List<String> listAfter(@Define(value="mysqlCond") String var1, @Define(value="psqlCond") String var2, @Bind(value="limit") int var3, @Bind(value="after") String var4);
    }

    public static interface DocStoreDAO
    extends EntityDAO<Document> {
        @Override
        default public String getTableName() {
            return "doc_store";
        }

        @Override
        default public Class<Document> getEntityClass() {
            return Document.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }

        @Override
        default public boolean supportsSoftDelete() {
            return false;
        }

        @Override
        default public List<String> listBefore(ListFilter filter, int limit, String before) {
            String entityType = filter.getQueryParam("entityType");
            String fqnPrefix = filter.getQueryParam("fqnPrefix");
            String cond = filter.getCondition();
            if (entityType == null && fqnPrefix == null) {
                return EntityDAO.super.listBefore(filter, limit, before);
            }
            StringBuilder mysqlCondition = new StringBuilder();
            StringBuilder psqlCondition = new StringBuilder();
            mysqlCondition.append(cond);
            psqlCondition.append(cond);
            if (fqnPrefix != null) {
                String fqnPrefixHash = FullyQualifiedName.buildHash(fqnPrefix);
                String fqnCond = String.format(" AND (fqnHash LIKE CONCAT(:fqnPrefixHash, '.%') OR fqnHash=:fqnPrefixHash)", fqnPrefixHash);
                mysqlCondition.append(fqnCond);
                psqlCondition.append(fqnCond);
            }
            if (entityType != null) {
                mysqlCondition.append(String.format(" AND entityType='%s' ", entityType));
                psqlCondition.append(String.format(" AND entityType='%s' ", entityType));
            }
            return this.listBefore(this.getTableName(), mysqlCondition.toString(), psqlCondition.toString(), limit, before);
        }

        @Override
        default public List<String> listAfter(ListFilter filter, int limit, String after) {
            String entityType = filter.getQueryParam("entityType");
            String fqnPrefix = filter.getQueryParam("fqnPrefix");
            String cond = filter.getCondition();
            if (entityType == null && fqnPrefix == null) {
                return EntityDAO.super.listAfter(filter, limit, after);
            }
            StringBuilder mysqlCondition = new StringBuilder();
            StringBuilder psqlCondition = new StringBuilder();
            mysqlCondition.append(cond);
            psqlCondition.append(cond);
            if (fqnPrefix != null) {
                String fqnPrefixHash = FullyQualifiedName.buildHash(fqnPrefix);
                String fqnCond = String.format(" AND (fqnHash LIKE '%s' OR fqnHash='%s')", fqnPrefixHash + ".%", fqnPrefixHash);
                mysqlCondition.append(fqnCond);
                psqlCondition.append(fqnCond);
            }
            if (entityType != null) {
                mysqlCondition.append(String.format(" AND entityType='%s' ", entityType));
                psqlCondition.append(String.format(" AND entityType='%s' ", entityType));
            }
            return this.listAfter(this.getTableName(), mysqlCondition.toString(), psqlCondition.toString(), limit, after);
        }

        @Override
        default public int listCount(ListFilter filter) {
            String entityType = filter.getQueryParam("entityType");
            String fqnPrefix = filter.getQueryParam("fqnPrefix");
            String cond = filter.getCondition();
            if (entityType == null && fqnPrefix == null) {
                return EntityDAO.super.listCount(filter);
            }
            StringBuilder mysqlCondition = new StringBuilder();
            StringBuilder psqlCondition = new StringBuilder();
            mysqlCondition.append(cond);
            psqlCondition.append(cond);
            if (fqnPrefix != null) {
                String fqnPrefixHash = FullyQualifiedName.buildHash(fqnPrefix);
                String fqnCond = String.format(" AND (fqnHash LIKE '%s' OR fqnHash='%s')", fqnPrefixHash + ".%", fqnPrefixHash);
                mysqlCondition.append(fqnCond);
                psqlCondition.append(fqnCond);
            }
            if (entityType != null) {
                mysqlCondition.append(String.format(" AND entityType='%s' ", entityType));
                psqlCondition.append(String.format(" AND entityType='%s' ", entityType));
            }
            return this.listCount(this.getTableName(), this.getNameHashColumn(), mysqlCondition.toString(), psqlCondition.toString());
        }

        @Override
        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT json FROM (SELECT name, json FROM <table> <mysqlCond> AND name < :before ORDER BY name DESC LIMIT :limit) last_rows_subquery ORDER BY name", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT json FROM (SELECT name, json FROM <table> <psqlCond> AND name < :before ORDER BY name DESC LIMIT :limit) last_rows_subquery ORDER BY name", connectionType=ConnectionType.POSTGRES)})
        public List<String> listBefore(@Define(value="table") String var1, @Define(value="mysqlCond") String var2, @Define(value="psqlCond") String var3, @Bind(value="limit") int var4, @Bind(value="before") String var5);

        @Override
        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT json FROM <table> <mysqlCond> AND name > :after ORDER BY name LIMIT :limit", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT json FROM <table> <psqlCond> AND name > :after ORDER BY name LIMIT :limit", connectionType=ConnectionType.POSTGRES)})
        public List<String> listAfter(@Define(value="table") String var1, @Define(value="mysqlCond") String var2, @Define(value="psqlCond") String var3, @Bind(value="limit") int var4, @Bind(value="after") String var5);
    }

    public static interface DataModelDAO
    extends EntityDAO<DashboardDataModel> {
        @Override
        default public String getTableName() {
            return "dashboard_data_model_entity";
        }

        @Override
        default public Class<DashboardDataModel> getEntityClass() {
            return DashboardDataModel.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }
    }

    public static interface WorkflowDAO
    extends EntityDAO<Workflow> {
        @Override
        default public String getTableName() {
            return "automations_workflow";
        }

        @Override
        default public Class<Workflow> getEntityClass() {
            return Workflow.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "nameHash";
        }

        @Override
        default public List<String> listBefore(ListFilter filter, int limit, String before) {
            String workflowType = filter.getQueryParam("workflowType");
            String status = filter.getQueryParam("status");
            String condition = filter.getCondition();
            if (workflowType == null && status == null) {
                return EntityDAO.super.listBefore(filter, limit, before);
            }
            StringBuilder sqlCondition = new StringBuilder();
            sqlCondition.append(String.format("%s ", condition));
            if (workflowType != null) {
                sqlCondition.append(String.format("AND workflowType='%s' ", workflowType));
            }
            if (status != null) {
                sqlCondition.append(String.format("AND status='%s' ", status));
            }
            return this.listBefore(this.getTableName(), this.getNameHashColumn(), sqlCondition.toString(), limit, before);
        }

        @Override
        default public List<String> listAfter(ListFilter filter, int limit, String after) {
            String workflowType = filter.getQueryParam("workflowType");
            String status = filter.getQueryParam("status");
            String condition = filter.getCondition();
            if (workflowType == null && status == null) {
                return EntityDAO.super.listAfter(filter, limit, after);
            }
            StringBuilder sqlCondition = new StringBuilder();
            sqlCondition.append(String.format("%s ", condition));
            if (workflowType != null) {
                sqlCondition.append(String.format("AND workflowType='%s' ", workflowType));
            }
            if (status != null) {
                sqlCondition.append(String.format("AND status='%s' ", status));
            }
            return this.listAfter(this.getTableName(), this.getNameHashColumn(), sqlCondition.toString(), limit, after);
        }

        @Override
        default public int listCount(ListFilter filter) {
            String workflowType = filter.getQueryParam("workflowType");
            String status = filter.getQueryParam("status");
            String condition = filter.getCondition();
            if (workflowType == null && status == null) {
                return EntityDAO.super.listCount(filter);
            }
            StringBuilder sqlCondition = new StringBuilder();
            sqlCondition.append(String.format("%s ", condition));
            if (workflowType != null) {
                sqlCondition.append(String.format("AND workflowType='%s' ", workflowType));
            }
            if (status != null) {
                sqlCondition.append(String.format("AND status='%s' ", status));
            }
            return this.listCount(this.getTableName(), sqlCondition.toString());
        }

        @Override
        @SqlQuery(value="SELECT json FROM (SELECT name, json FROM <table> <sqlCondition> AND name < :before ORDER BY name DESC LIMIT :limit) last_rows_subquery ORDER BY name")
        public List<String> listBefore(@Define(value="table") String var1, @Define(value="sqlCondition") String var2, @Bind(value="limit") int var3, @Bind(value="before") String var4);

        @Override
        @SqlQuery(value="SELECT json FROM <table> <sqlCondition> AND name > :after ORDER BY name LIMIT :limit")
        public List<String> listAfter(@Define(value="table") String var1, @Define(value="sqlCondition") String var2, @Bind(value="limit") int var3, @Bind(value="after") String var4);

        @SqlQuery(value="SELECT count(*) FROM <table> <sqlCondition>")
        public int listCount(@Define(value="table") String var1, @Define(value="sqlCondition") String var2);
    }

    public static interface KpiDAO
    extends EntityDAO<Kpi> {
        @Override
        default public String getTableName() {
            return "kpi_entity";
        }

        @Override
        default public Class<Kpi> getEntityClass() {
            return Kpi.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "nameHash";
        }
    }

    public static interface TokenDAO {
        @SqlQuery(value="SELECT tokenType, json FROM user_tokens WHERE token = :token")
        @RegisterRowMapper(value=TokenRowMapper.class)
        public TokenInterface findByToken(@Bind(value="token") String var1) throws StatementException;

        @SqlQuery(value="SELECT tokenType, json FROM user_tokens WHERE userId = :userId AND tokenType = :tokenType ")
        @RegisterRowMapper(value=TokenRowMapper.class)
        public List<TokenInterface> getAllUserTokenWithType(@BindUUID(value="userId") UUID var1, @Bind(value="tokenType") String var2) throws StatementException;

        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT INTO user_tokens (json) VALUES (:json)", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO user_tokens (json) VALUES (:json :: jsonb)", connectionType=ConnectionType.POSTGRES)})
        public void insert(@Bind(value="json") String var1);

        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="UPDATE user_tokens SET json = :json WHERE token = :token", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="UPDATE user_tokens SET json = (:json :: jsonb) WHERE token = :token", connectionType=ConnectionType.POSTGRES)})
        public void update(@Bind(value="token") String var1, @Bind(value="json") String var2);

        @SqlUpdate(value="DELETE from user_tokens WHERE token = :token")
        public void delete(@Bind(value="token") String var1);

        @SqlUpdate(value="DELETE from user_tokens WHERE token IN (<tokenIds>)")
        public void deleteAll(@BindList(value="tokenIds") List<String> var1);

        @SqlUpdate(value="DELETE from user_tokens WHERE userid = :userid AND tokenType = :tokenType")
        public void deleteTokenByUserAndType(@BindUUID(value="userid") UUID var1, @Bind(value="tokenType") String var2);
    }

    public static class TokenRowMapper
    implements RowMapper<TokenInterface> {
        public TokenInterface map(ResultSet rs, StatementContext ctx) throws SQLException {
            return TokenRowMapper.getToken(TokenType.fromValue((String)rs.getString("tokenType")), rs.getString("json"));
        }

        public static TokenInterface getToken(TokenType type, String json) {
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case TokenType.EMAIL_VERIFICATION -> JsonUtils.readValue(json, EmailVerificationToken.class);
                case TokenType.PASSWORD_RESET -> JsonUtils.readValue(json, PasswordResetToken.class);
                case TokenType.REFRESH_TOKEN -> JsonUtils.readValue(json, RefreshToken.class);
                case TokenType.PERSONAL_ACCESS_TOKEN -> JsonUtils.readValue(json, PersonalAccessToken.class);
            };
        }
    }

    public static class SettingsRowMapper
    implements RowMapper<Settings> {
        public Settings map(ResultSet rs, StatementContext ctx) throws SQLException {
            return SettingsRowMapper.getSettings(SettingsType.fromValue((String)rs.getString("configType")), rs.getString("json"));
        }

        public static Settings getSettings(SettingsType configType, String json) {
            Settings settings = new Settings();
            settings.setConfigType(configType);
            Object value = switch (configType) {
                case SettingsType.EMAIL_CONFIGURATION -> JsonUtils.readValue(json, SmtpSettings.class);
                case SettingsType.CUSTOM_UI_THEME_PREFERENCE -> JsonUtils.readValue(json, UiThemePreference.class);
                case SettingsType.LOGIN_CONFIGURATION -> JsonUtils.readValue(json, LoginConfiguration.class);
                case SettingsType.SLACK_APP_CONFIGURATION -> JsonUtils.readValue(json, String.class);
                case SettingsType.SLACK_BOT, SettingsType.SLACK_INSTALLER -> JsonUtils.readValue(json, new TypeReference<HashMap<String, Object>>(){});
                case SettingsType.PROFILER_CONFIGURATION -> JsonUtils.readValue(json, ProfilerConfiguration.class);
                default -> throw new IllegalArgumentException("Invalid Settings Type " + configType);
            };
            settings.setConfigValue(value);
            return settings;
        }
    }

    public static interface SystemDAO {
        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT (SELECT COUNT(fqnHash) FROM table_entity <cond>) as tableCount, (SELECT COUNT(fqnHash) FROM topic_entity <cond>) as topicCount, (SELECT COUNT(fqnHash) FROM dashboard_entity <cond>) as dashboardCount, (SELECT COUNT(fqnHash) FROM pipeline_entity <cond>) as pipelineCount, (SELECT COUNT(fqnHash) FROM ml_model_entity <cond>) as mlmodelCount, (SELECT COUNT(fqnHash) FROM storage_container_entity <cond>) as storageContainerCount, (SELECT COUNT(fqnHash) FROM search_index_entity <cond>) as searchIndexCount, (SELECT COUNT(nameHash) FROM glossary_entity <cond>) as glossaryCount, (SELECT COUNT(fqnHash) FROM glossary_term_entity <cond>) as glossaryTermCount, (SELECT (SELECT COUNT(nameHash) FROM metadata_service_entity <cond>) + (SELECT COUNT(nameHash) FROM dbservice_entity <cond>)+(SELECT COUNT(nameHash) FROM messaging_service_entity <cond>)+ (SELECT COUNT(nameHash) FROM dashboard_service_entity <cond>)+ (SELECT COUNT(nameHash) FROM pipeline_service_entity <cond>)+ (SELECT COUNT(nameHash) FROM mlmodel_service_entity <cond>)+ (SELECT COUNT(nameHash) FROM search_service_entity <cond>)+ (SELECT COUNT(nameHash) FROM storage_service_entity <cond>)) as servicesCount, (SELECT COUNT(nameHash) FROM user_entity <cond> AND (JSON_EXTRACT(json, '$.isBot') IS NULL OR JSON_EXTRACT(json, '$.isBot') = FALSE)) as userCount, (SELECT COUNT(nameHash) FROM team_entity <cond>) as teamCount, (SELECT COUNT(fqnHash) FROM test_suite <cond>) as testSuiteCount", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT (SELECT COUNT(*) FROM table_entity <cond>) as tableCount, (SELECT COUNT(*) FROM topic_entity <cond>) as topicCount, (SELECT COUNT(*) FROM dashboard_entity <cond>) as dashboardCount, (SELECT COUNT(*) FROM pipeline_entity <cond>) as pipelineCount, (SELECT COUNT(*) FROM ml_model_entity <cond>) as mlmodelCount, (SELECT COUNT(*) FROM storage_container_entity <cond>) as storageContainerCount, (SELECT COUNT(*) FROM search_index_entity <cond>) as searchIndexCount, (SELECT COUNT(*) FROM glossary_entity <cond>) as glossaryCount, (SELECT COUNT(*) FROM glossary_term_entity <cond>) as glossaryTermCount, (SELECT (SELECT COUNT(*) FROM metadata_service_entity <cond>) + (SELECT COUNT(*) FROM dbservice_entity <cond>)+(SELECT COUNT(*) FROM messaging_service_entity <cond>)+ (SELECT COUNT(*) FROM dashboard_service_entity <cond>)+ (SELECT COUNT(*) FROM pipeline_service_entity <cond>)+ (SELECT COUNT(*) FROM mlmodel_service_entity <cond>)+ (SELECT COUNT(*) FROM search_service_entity <cond>)+ (SELECT COUNT(*) FROM storage_service_entity <cond>)) as servicesCount, (SELECT COUNT(*) FROM user_entity <cond> AND (json#>'{isBot}' IS NULL OR ((json#>'{isBot}')::boolean) = FALSE)) as userCount, (SELECT COUNT(*) FROM team_entity <cond>) as teamCount, (SELECT COUNT(*) FROM test_suite <cond>) as testSuiteCount", connectionType=ConnectionType.POSTGRES)})
        @RegisterRowMapper(value=EntitiesCountRowMapper.class)
        public EntitiesCount getAggregatedEntitiesCount(@Define(value="cond") String var1) throws StatementException;

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT (SELECT COUNT(nameHash) FROM dbservice_entity <cond>) as databaseServiceCount, (SELECT COUNT(nameHash) FROM messaging_service_entity <cond>) as messagingServiceCount, (SELECT COUNT(nameHash) FROM dashboard_service_entity <cond>) as dashboardServiceCount, (SELECT COUNT(nameHash) FROM pipeline_service_entity <cond>) as pipelineServiceCount, (SELECT COUNT(nameHash) FROM mlmodel_service_entity <cond>) as mlModelServiceCount, (SELECT COUNT(nameHash) FROM storage_service_entity <cond>) as storageServiceCount, (SELECT COUNT(nameHash) FROM search_service_entity <cond>) as searchServiceCount", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT (SELECT COUNT(*) FROM dbservice_entity <cond>) as databaseServiceCount, (SELECT COUNT(*) FROM messaging_service_entity <cond>) as messagingServiceCount, (SELECT COUNT(*) FROM dashboard_service_entity <cond>) as dashboardServiceCount, (SELECT COUNT(*) FROM pipeline_service_entity <cond>) as pipelineServiceCount, (SELECT COUNT(*) FROM mlmodel_service_entity <cond>) as mlModelServiceCount, (SELECT COUNT(*) FROM storage_service_entity <cond>) as storageServiceCount, (SELECT COUNT(*) FROM search_service_entity <cond>) as searchServiceCount", connectionType=ConnectionType.POSTGRES)})
        @RegisterRowMapper(value=ServicesCountRowMapper.class)
        public ServicesCount getAggregatedServicesCount(@Define(value="cond") String var1) throws StatementException;

        @SqlQuery(value="SELECT configType,json FROM openmetadata_settings")
        @RegisterRowMapper(value=SettingsRowMapper.class)
        public List<Settings> getAllConfig() throws StatementException;

        @SqlQuery(value="SELECT configType, json FROM openmetadata_settings WHERE configType = :configType")
        @RegisterRowMapper(value=SettingsRowMapper.class)
        public Settings getConfigWithKey(@Bind(value="configType") String var1) throws StatementException;

        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT into openmetadata_settings (configType, json)VALUES (:configType, :json) ON DUPLICATE KEY UPDATE json = :json", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT into openmetadata_settings (configType, json)VALUES (:configType, :json :: jsonb) ON CONFLICT (configType) DO UPDATE SET json = EXCLUDED.json", connectionType=ConnectionType.POSTGRES)})
        public void insertSettings(@Bind(value="configType") String var1, @Bind(value="json") String var2);

        @SqlUpdate(value="DELETE from openmetadata_settings WHERE configType = :configType")
        public void delete(@Bind(value="configType") String var1);

        @SqlQuery(value="SELECT 42")
        public Integer testConnection() throws StatementException;
    }

    public static class ServicesCountRowMapper
    implements RowMapper<ServicesCount> {
        public ServicesCount map(ResultSet rs, StatementContext ctx) throws SQLException {
            return new ServicesCount().withDatabaseServiceCount(Integer.valueOf(rs.getInt("databaseServiceCount"))).withMessagingServiceCount(Integer.valueOf(rs.getInt("messagingServiceCount"))).withDashboardServiceCount(Integer.valueOf(rs.getInt("dashboardServiceCount"))).withPipelineServiceCount(Integer.valueOf(rs.getInt("pipelineServiceCount"))).withMlModelServiceCount(Integer.valueOf(rs.getInt("mlModelServiceCount"))).withStorageServiceCount(Integer.valueOf(rs.getInt("storageServiceCount")));
        }
    }

    public static class EntitiesCountRowMapper
    implements RowMapper<EntitiesCount> {
        public EntitiesCount map(ResultSet rs, StatementContext ctx) throws SQLException {
            return new EntitiesCount().withTableCount(Integer.valueOf(rs.getInt("tableCount"))).withTopicCount(Integer.valueOf(rs.getInt("topicCount"))).withDashboardCount(Integer.valueOf(rs.getInt("dashboardCount"))).withPipelineCount(Integer.valueOf(rs.getInt("pipelineCount"))).withMlmodelCount(Integer.valueOf(rs.getInt("mlmodelCount"))).withServicesCount(Integer.valueOf(rs.getInt("servicesCount"))).withUserCount(Integer.valueOf(rs.getInt("userCount"))).withTeamCount(Integer.valueOf(rs.getInt("teamCount"))).withTestSuiteCount(Integer.valueOf(rs.getInt("testSuiteCount"))).withStorageContainerCount(Integer.valueOf(rs.getInt("storageContainerCount"))).withGlossaryCount(Integer.valueOf(rs.getInt("glossaryCount"))).withGlossaryTermCount(Integer.valueOf(rs.getInt("glossaryTermCount")));
        }
    }

    public static interface TestCaseResolutionStatusTimeSeriesDAO
    extends EntityTimeSeriesDAO {
        @Override
        default public String getTimeSeriesTableName() {
            return "test_case_resolution_status_time_series";
        }

        @SqlQuery(value="SELECT json FROM test_case_resolution_status_time_series WHERE stateId = :stateId ORDER BY timestamp DESC")
        public List<String> listTestCaseResolutionStatusesForStateId(@Bind(value="stateId") String var1);

        @SqlUpdate(value="DELETE FROM test_case_resolution_status_time_series WHERE entityFQNHash = :entityFQNHash")
        public void delete(@BindFQN(value="entityFQNHash") String var1);

        @SqlQuery(value="SELECT json FROM (SELECT id, json, testCaseResolutionStatusType, assignee, ROW_NUMBER() OVER(PARTITION BY <partition> ORDER BY timestamp DESC) AS row_num FROM <table> <cond> AND timestamp BETWEEN :startTs AND :endTs ORDER BY timestamp DESC) ranked <outerCond> AND ranked.row_num = 1 LIMIT :limit OFFSET :offset")
        public List<String> listWithOffset(@Define(value="table") String var1, @Define(value="cond") String var2, @Define(value="partition") String var3, @Bind(value="limit") int var4, @Bind(value="offset") int var5, @Bind(value="startTs") Long var6, @Bind(value="endTs") Long var7, @Define(value="outerCond") String var8);

        @Override
        default public List<String> listWithOffset(ListFilter filter, int limit, int offset, Long startTs, Long endTs, boolean latest) {
            if (latest) {
                String testCaseResolutionStatusType = filter.getQueryParam("testCaseResolutionStatusType");
                filter.removeQueryParam("testCaseResolutionStatusType");
                String assignee = filter.getQueryParam("assignee");
                filter.removeQueryParam("assignee");
                ListFilter outerFilter = new ListFilter(null);
                outerFilter.addQueryParam("testCaseResolutionStatusType", testCaseResolutionStatusType);
                outerFilter.addQueryParam("assignee", assignee);
                return this.listWithOffset(this.getTimeSeriesTableName(), filter.getCondition(), this.getPartitionFieldName(), limit, offset, startTs, endTs, outerFilter.getCondition());
            }
            return this.listWithOffset(this.getTimeSeriesTableName(), filter.getCondition(), limit, offset, startTs, endTs);
        }
    }

    public static interface DataQualityDataTimeSeriesDAO
    extends EntityTimeSeriesDAO {
        @Override
        default public String getTimeSeriesTableName() {
            return "data_quality_data_time_series";
        }

        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT INTO data_quality_data_time_series(entityFQNHash, extension, jsonSchema, json, incidentId) VALUES (:testCaseFQNHash, :extension, :jsonSchema, :json, :incidentStateId)", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO data_quality_data_time_series(entityFQNHash, extension, jsonSchema, json, incidentId) VALUES (:testCaseFQNHash, :extension, :jsonSchema, (:json :: jsonb), :incidentStateId)", connectionType=ConnectionType.POSTGRES)})
        public void insert(@Define(value="table") String var1, @BindFQN(value="testCaseFQNHash") String var2, @Bind(value="extension") String var3, @Bind(value="jsonSchema") String var4, @Bind(value="json") String var5, @Bind(value="incidentStateId") String var6);

        @Override
        default public void insert(String entityFQNHash, String extension, String jsonSchema, String json, String incidentStateId) {
            this.insert(this.getTimeSeriesTableName(), entityFQNHash, extension, jsonSchema, json, incidentStateId);
        }
    }

    public static interface ProfilerDataTimeSeriesDAO
    extends EntityTimeSeriesDAO {
        @Override
        default public String getTimeSeriesTableName() {
            return "profiler_data_time_series";
        }
    }

    public static interface ReportDataTimeSeriesDAO
    extends EntityTimeSeriesDAO {
        @Override
        default public String getTimeSeriesTableName() {
            return "report_data_time_series";
        }

        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="DELETE FROM report_data_time_series WHERE entityFQNHash = :reportDataType and date = :date", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="DELETE FROM report_data_time_series WHERE entityFQNHash = :reportDataType and DATE(TO_TIMESTAMP((json ->> 'timestamp')::bigint/1000)) = DATE(:date)", connectionType=ConnectionType.POSTGRES)})
        public void deleteReportDataTypeAtDate(@BindFQN(value="reportDataType") String var1, @Bind(value="date") String var2);

        @SqlUpdate(value="DELETE FROM report_data_time_series WHERE entityFQNHash = :reportDataType")
        public void deletePreviousReportData(@BindFQN(value="reportDataType") String var1);
    }

    public static interface AppExtensionTimeSeries {
        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT INTO apps_extension_time_series(json) VALUES (:json)", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO apps_extension_time_series(json) VALUES ((:json :: jsonb))", connectionType=ConnectionType.POSTGRES)})
        public void insert(@Bind(value="json") String var1);

        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="UPDATE apps_extension_time_series set json = :json where appId=:appId and timestamp=:timestamp", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="UPDATE apps_extension_time_series set json = (:json :: jsonb) where appId=:appId and timestamp=:timestamp", connectionType=ConnectionType.POSTGRES)})
        public void update(@Bind(value="appId") String var1, @Bind(value="json") String var2, @Bind(value="timestamp") Long var3);

        @SqlQuery(value="SELECT count(*) FROM apps_extension_time_series where appId = :appId")
        public int listAppRunRecordCount(@Bind(value="appId") String var1);

        @SqlQuery(value="SELECT json FROM apps_extension_time_series where appId = :appId ORDER BY timestamp DESC LIMIT :limit OFFSET :offset")
        public List<String> listAppRunRecord(@Bind(value="appId") String var1, @Bind(value="limit") int var2, @Bind(value="offset") int var3);

        @SqlQuery(value="SELECT json FROM apps_extension_time_series where appId = :appId AND timestamp > :startTime ORDER BY timestamp DESC LIMIT :limit OFFSET :offset")
        public List<String> listAppRunRecordAfterTime(@Bind(value="appId") String var1, @Bind(value="limit") int var2, @Bind(value="offset") int var3, @Bind(value="startTime") long var4);

        default public String getLatestAppRun(UUID appId) {
            List<String> result = this.listAppRunRecord(appId.toString(), 1, 0);
            if (!CommonUtil.nullOrEmpty(result)) {
                return result.get(0);
            }
            return null;
        }

        default public String getLatestAppRun(UUID appId, long startTime) {
            List<String> result = this.listAppRunRecordAfterTime(appId.toString(), 1, 0, startTime);
            if (!CommonUtil.nullOrEmpty(result)) {
                return result.get(0);
            }
            return null;
        }
    }

    public static interface EntityExtensionTimeSeriesDAO
    extends EntityTimeSeriesDAO {
        @Override
        default public String getTimeSeriesTableName() {
            return "entity_extension_time_series";
        }
    }

    public static interface DataInsightChartDAO
    extends EntityDAO<DataInsightChart> {
        @Override
        default public String getTableName() {
            return "data_insight_chart";
        }

        @Override
        default public Class<DataInsightChart> getEntityClass() {
            return DataInsightChart.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }
    }

    public static interface WebAnalyticEventDAO
    extends EntityDAO<WebAnalyticEvent> {
        @Override
        default public String getTableName() {
            return "web_analytic_event";
        }

        @Override
        default public Class<WebAnalyticEvent> getEntityClass() {
            return WebAnalyticEvent.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }
    }

    public static interface TestCaseDAO
    extends EntityDAO<TestCase> {
        @Override
        default public String getTableName() {
            return "test_case";
        }

        @Override
        default public Class<TestCase> getEntityClass() {
            return TestCase.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }

        default public int countOfTestCases(List<UUID> testCaseIds) {
            return this.countOfTestCases(this.getTableName(), testCaseIds.stream().map(Object::toString).toList());
        }

        @SqlQuery(value="SELECT count(*) FROM <table> WHERE id IN (<testCaseIds>)")
        public int countOfTestCases(@Define(value="table") String var1, @BindList(value="testCaseIds") List<String> var2);

        public static class TestCaseRecordMapper
        implements RowMapper<TestCaseRecord> {
            public TestCaseRecord map(ResultSet rs, StatementContext ctx) throws SQLException {
                return new TestCaseRecord(rs.getString("json"), rs.getInt("ranked"));
            }
        }

        public static class TestCaseRecord {
            String json;
            Integer rank;

            public TestCaseRecord(String json, Integer rank) {
                this.json = json;
                this.rank = rank;
            }

            public String getJson() {
                return this.json;
            }

            public Integer getRank() {
                return this.rank;
            }
        }
    }

    public static interface TestSuiteDAO
    extends EntityDAO<TestSuite> {
        @Override
        default public String getTableName() {
            return "test_suite";
        }

        @Override
        default public Class<TestSuite> getEntityClass() {
            return TestSuite.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }

        @Override
        default public int listCount(ListFilter filter) {
            String mySqlCondition = filter.getCondition(this.getTableName());
            String postgresCondition = filter.getCondition(this.getTableName());
            boolean includeEmptyTestSuite = Boolean.parseBoolean(filter.getQueryParam("includeEmptyTestSuites"));
            if (!includeEmptyTestSuite) {
                String condition;
                mySqlCondition = condition = String.format("INNER JOIN entity_relationship er ON %s.id=er.fromId AND er.relation=%s AND er.toEntity='%s'", this.getTableName(), Relationship.CONTAINS.ordinal(), "testCase");
                postgresCondition = condition;
                mySqlCondition = String.format("%s %s", mySqlCondition, filter.getCondition(this.getTableName()));
                postgresCondition = String.format("%s %s", postgresCondition, filter.getCondition(this.getTableName()));
            }
            return this.listCountDistinct(this.getTableName(), mySqlCondition, postgresCondition, String.format("%s.%s", this.getTableName(), this.getNameHashColumn()));
        }

        @Override
        default public List<String> listBefore(ListFilter filter, int limit, String before) {
            String mySqlCondition = filter.getCondition(this.getTableName());
            String postgresCondition = filter.getCondition(this.getTableName());
            String groupBy = "";
            boolean includeEmptyTestSuite = Boolean.parseBoolean(filter.getQueryParam("includeEmptyTestSuites"));
            if (!includeEmptyTestSuite) {
                String condition;
                groupBy = String.format("group by %s.json, %s.name", this.getTableName(), this.getTableName());
                mySqlCondition = condition = String.format("INNER JOIN entity_relationship er ON %s.id=er.fromId AND er.relation=%s AND er.toEntity='%s'", this.getTableName(), Relationship.CONTAINS.ordinal(), "testCase");
                postgresCondition = condition;
                mySqlCondition = String.format("%s %s", mySqlCondition, filter.getCondition(this.getTableName()));
                postgresCondition = String.format("%s %s", postgresCondition, filter.getCondition(this.getTableName()));
            }
            return this.listBefore(this.getTableName(), mySqlCondition, postgresCondition, limit, before, groupBy);
        }

        @Override
        default public List<String> listAfter(ListFilter filter, int limit, String after) {
            String mySqlCondition = filter.getCondition(this.getTableName());
            String postgresCondition = filter.getCondition(this.getTableName());
            String groupBy = "";
            boolean includeEmptyTestSuite = Boolean.parseBoolean(filter.getQueryParam("includeEmptyTestSuites"));
            if (!includeEmptyTestSuite) {
                String condition;
                groupBy = String.format("group by %s.json, %s.name", this.getTableName(), this.getTableName());
                mySqlCondition = condition = String.format("INNER JOIN entity_relationship er ON %s.id=er.fromId AND er.relation=%s AND er.toEntity='%s'", this.getTableName(), Relationship.CONTAINS.ordinal(), "testCase");
                postgresCondition = condition;
                mySqlCondition = String.format("%s %s", mySqlCondition, filter.getCondition(this.getTableName()));
                postgresCondition = String.format("%s %s", postgresCondition, filter.getCondition(this.getTableName()));
            }
            return this.listAfter(this.getTableName(), mySqlCondition, postgresCondition, limit, after, groupBy);
        }
    }

    public static interface TestDefinitionDAO
    extends EntityDAO<TestDefinition> {
        @Override
        default public String getTableName() {
            return "test_definition";
        }

        @Override
        default public Class<TestDefinition> getEntityClass() {
            return TestDefinition.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "nameHash";
        }

        @Override
        default public List<String> listBefore(ListFilter filter, int limit, String before) {
            String entityType = filter.getQueryParam("entityType");
            String testPlatform = filter.getQueryParam("testPlatform");
            String supportedDataType = filter.getQueryParam("supportedDataType");
            String condition = filter.getCondition();
            if (entityType == null && testPlatform == null && supportedDataType == null) {
                return EntityDAO.super.listBefore(filter, limit, before);
            }
            StringBuilder mysqlCondition = new StringBuilder();
            StringBuilder psqlCondition = new StringBuilder();
            mysqlCondition.append(String.format("%s ", condition));
            psqlCondition.append(String.format("%s ", condition));
            if (testPlatform != null) {
                mysqlCondition.append(String.format("AND json_extract(json, '$.testPlatforms') LIKE '%%%s%%' ", testPlatform));
                psqlCondition.append(String.format("AND json->>'testPlatforms' LIKE '%%%s%%' ", testPlatform));
            }
            if (entityType != null) {
                mysqlCondition.append(String.format("AND entityType='%s' ", entityType));
                psqlCondition.append(String.format("AND entityType='%s' ", entityType));
            }
            if (supportedDataType != null) {
                mysqlCondition.append(String.format("AND supported_data_types LIKE '%%%s%%' ", supportedDataType));
                String psqlStr = String.format("AND supported_data_types @> '`%s`' ", supportedDataType);
                psqlCondition.append(psqlStr.replace('`', '\"'));
            }
            return this.listBefore(this.getTableName(), mysqlCondition.toString(), psqlCondition.toString(), limit, before);
        }

        @Override
        default public List<String> listAfter(ListFilter filter, int limit, String after) {
            String entityType = filter.getQueryParam("entityType");
            String testPlatform = filter.getQueryParam("testPlatform");
            String supportedDataType = filter.getQueryParam("supportedDataType");
            String condition = filter.getCondition();
            if (entityType == null && testPlatform == null && supportedDataType == null) {
                return EntityDAO.super.listAfter(filter, limit, after);
            }
            StringBuilder mysqlCondition = new StringBuilder();
            StringBuilder psqlCondition = new StringBuilder();
            mysqlCondition.append(String.format("%s ", condition));
            psqlCondition.append(String.format("%s ", condition));
            if (testPlatform != null) {
                mysqlCondition.append(String.format("AND json_extract(json, '$.testPlatforms') LIKE '%%%s%%' ", testPlatform));
                psqlCondition.append(String.format("AND json->>'testPlatforms' LIKE '%%%s%%' ", testPlatform));
            }
            if (entityType != null) {
                mysqlCondition.append(String.format("AND entityType='%s' ", entityType));
                psqlCondition.append(String.format("AND entityType='%s' ", entityType));
            }
            if (supportedDataType != null) {
                mysqlCondition.append(String.format("AND supported_data_types LIKE '%%%s%%' ", supportedDataType));
                String psqlStr = String.format("AND supported_data_types @> '`%s`' ", supportedDataType);
                psqlCondition.append(psqlStr.replace('`', '\"'));
            }
            return this.listAfter(this.getTableName(), mysqlCondition.toString(), psqlCondition.toString(), limit, after);
        }

        @Override
        default public int listCount(ListFilter filter) {
            String entityType = filter.getQueryParam("entityType");
            String testPlatform = filter.getQueryParam("testPlatform");
            String supportedDataType = filter.getQueryParam("supportedDataType");
            String condition = filter.getCondition();
            if (entityType == null && testPlatform == null && supportedDataType == null) {
                return EntityDAO.super.listCount(filter);
            }
            StringBuilder mysqlCondition = new StringBuilder();
            StringBuilder psqlCondition = new StringBuilder();
            mysqlCondition.append(String.format("%s ", condition));
            psqlCondition.append(String.format("%s ", condition));
            if (testPlatform != null) {
                mysqlCondition.append(String.format("AND json_extract(json, '$.testPlatforms') LIKE '%%%s%%' ", testPlatform));
                psqlCondition.append(String.format("AND json->>'testPlatforms' LIKE '%%%s%%' ", testPlatform));
            }
            if (entityType != null) {
                mysqlCondition.append(String.format("AND entityType='%s' ", entityType));
                psqlCondition.append(String.format("AND entityType='%s' ", entityType));
            }
            if (supportedDataType != null) {
                mysqlCondition.append(String.format("AND supported_data_types LIKE '%%%s%%' ", supportedDataType));
                String psqlStr = String.format("AND supported_data_types @> '`%s`' ", supportedDataType);
                psqlCondition.append(psqlStr.replace('`', '\"'));
            }
            return this.listCount(this.getTableName(), this.getNameHashColumn(), mysqlCondition.toString(), psqlCondition.toString());
        }

        @Override
        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT json FROM (SELECT name, json FROM <table> <mysqlCond> AND name < :before ORDER BY name DESC LIMIT :limit) last_rows_subquery ORDER BY name", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT json FROM (SELECT name, json FROM <table> <psqlCond> AND name < :before ORDER BY name DESC LIMIT :limit) last_rows_subquery ORDER BY name", connectionType=ConnectionType.POSTGRES)})
        public List<String> listBefore(@Define(value="table") String var1, @Define(value="mysqlCond") String var2, @Define(value="psqlCond") String var3, @Bind(value="limit") int var4, @Bind(value="before") String var5);

        @Override
        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT json FROM <table> <mysqlCond> AND name > :after ORDER BY name LIMIT :limit", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT json FROM <table> <psqlCond> AND name > :after ORDER BY name LIMIT :limit", connectionType=ConnectionType.POSTGRES)})
        public List<String> listAfter(@Define(value="table") String var1, @Define(value="mysqlCond") String var2, @Define(value="psqlCond") String var3, @Bind(value="limit") int var4, @Bind(value="after") String var5);

        @Override
        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT count(<nameHashColumn>) FROM <table> <mysqlCond>", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT count(*) FROM <table> <psqlCond>", connectionType=ConnectionType.POSTGRES)})
        public int listCount(@Define(value="table") String var1, @Define(value="nameHashColumn") String var2, @Define(value="mysqlCond") String var3, @Define(value="psqlCond") String var4);
    }

    public static interface TypeEntityDAO
    extends EntityDAO<Type> {
        @Override
        default public String getTableName() {
            return "type_entity";
        }

        @Override
        default public Class<Type> getEntityClass() {
            return Type.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "nameHash";
        }

        @Override
        default public boolean supportsSoftDelete() {
            return false;
        }
    }

    public static interface ChangeEventDAO {
        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT INTO change_event (json) VALUES (:json)", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO change_event (json) VALUES (:json :: jsonb)", connectionType=ConnectionType.POSTGRES)})
        public void insert(@Bind(value="json") String var1);

        @SqlUpdate(value="DELETE FROM change_event WHERE entityType = :entityType")
        public void deleteAll(@Bind(value="entityType") String var1);

        default public List<String> list(EventType eventType, List<String> entityTypes, long timestamp) {
            if (CommonUtil.nullOrEmpty(entityTypes)) {
                return Collections.emptyList();
            }
            if (entityTypes.get(0).equals("*")) {
                return this.listWithoutEntityFilter(eventType.value(), timestamp);
            }
            return this.listWithEntityFilter(eventType.value(), entityTypes, timestamp);
        }

        @SqlQuery(value="SELECT json FROM change_event WHERE eventType = :eventType AND (entityType IN (<entityTypes>)) AND eventTime >= :timestamp ORDER BY eventTime ASC")
        public List<String> listWithEntityFilter(@Bind(value="eventType") String var1, @BindList(value="entityTypes") List<String> var2, @Bind(value="timestamp") long var3);

        @SqlQuery(value="SELECT json FROM change_event WHERE eventType = :eventType AND eventTime >= :timestamp ORDER BY eventTime ASC")
        public List<String> listWithoutEntityFilter(@Bind(value="eventType") String var1, @Bind(value="timestamp") long var2);

        @SqlQuery(value="SELECT json FROM change_event ce where ce.offset > :offset ORDER BY ce.eventTime ASC LIMIT :limit")
        public List<String> list(@Bind(value="limit") long var1, @Bind(value="offset") long var3);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT MAX(offset) FROM change_event", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT MAX(\"offset\") FROM change_event", connectionType=ConnectionType.POSTGRES)})
        public long getLatestOffset();
    }

    public static interface UserDAO
    extends EntityDAO<User> {
        @Override
        default public String getTableName() {
            return "user_entity";
        }

        @Override
        default public Class<User> getEntityClass() {
            return User.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "nameHash";
        }

        @Override
        default public int listCount(ListFilter filter) {
            String team = EntityInterfaceUtil.quoteName((String)filter.getQueryParam("team"));
            String isBotStr = filter.getQueryParam("isBot");
            String isAdminStr = filter.getQueryParam("isAdmin");
            String mySqlCondition = filter.getCondition("ue");
            String postgresCondition = filter.getCondition("ue");
            if (isAdminStr != null) {
                boolean isAdmin = Boolean.parseBoolean(isAdminStr);
                if (isAdmin) {
                    mySqlCondition = String.format("%s AND JSON_EXTRACT(ue.json, '$.isAdmin') = TRUE ", mySqlCondition);
                    postgresCondition = String.format("%s AND ((ue.json#>'{isAdmin}')::boolean)  = TRUE ", postgresCondition);
                } else {
                    mySqlCondition = String.format("%s AND (JSON_EXTRACT(ue.json, '$.isAdmin') IS NULL OR JSON_EXTRACT(ue.json, '$.isAdmin') = FALSE ) ", mySqlCondition);
                    postgresCondition = String.format("%s AND (ue.json#>'{isAdmin}' IS NULL OR ((ue.json#>'{isAdmin}')::boolean) = FALSE ) ", postgresCondition);
                }
            }
            if (isBotStr != null) {
                boolean isBot = Boolean.parseBoolean(isBotStr);
                if (isBot) {
                    mySqlCondition = String.format("%s AND JSON_EXTRACT(ue.json, '$.isBot') = TRUE ", mySqlCondition);
                    postgresCondition = String.format("%s AND ((ue.json#>'{isBot}')::boolean) = TRUE ", postgresCondition);
                } else {
                    mySqlCondition = String.format("%s AND (JSON_EXTRACT(ue.json, '$.isBot') IS NULL OR JSON_EXTRACT(ue.json, '$.isBot') = FALSE ) ", mySqlCondition);
                    postgresCondition = String.format("%s AND (ue.json#>'{isBot}' IS NULL OR ((ue.json#>'{isBot}')::boolean) = FALSE) ", postgresCondition);
                }
            }
            if (team == null && isAdminStr == null && isBotStr == null) {
                return EntityDAO.super.listCount(filter);
            }
            return this.listCount(this.getTableName(), mySqlCondition, postgresCondition, team, Relationship.HAS.ordinal());
        }

        @Override
        default public List<String> listBefore(ListFilter filter, int limit, String before) {
            String team = EntityInterfaceUtil.quoteName((String)filter.getQueryParam("team"));
            String isBotStr = filter.getQueryParam("isBot");
            String isAdminStr = filter.getQueryParam("isAdmin");
            String mySqlCondition = filter.getCondition("ue");
            String postgresCondition = filter.getCondition("ue");
            if (isAdminStr != null) {
                boolean isAdmin = Boolean.parseBoolean(isAdminStr);
                if (isAdmin) {
                    mySqlCondition = String.format("%s AND JSON_EXTRACT(ue.json, '$.isAdmin') = TRUE ", mySqlCondition);
                    postgresCondition = String.format("%s AND ((ue.json#>'{isAdmin}')::boolean) = TRUE ", postgresCondition);
                } else {
                    mySqlCondition = String.format("%s AND (JSON_EXTRACT(ue.json, '$.isAdmin') IS NULL OR JSON_EXTRACT(ue.json, '$.isAdmin') = FALSE ) ", mySqlCondition);
                    postgresCondition = String.format("%s AND (ue.json#>'{isAdmin}' IS NULL OR ((ue.json#>'{isAdmin}')::boolean) = FALSE ) ", postgresCondition);
                }
            }
            if (isBotStr != null) {
                boolean isBot = Boolean.parseBoolean(isBotStr);
                if (isBot) {
                    mySqlCondition = String.format("%s AND JSON_EXTRACT(ue.json, '$.isBot') = TRUE ", mySqlCondition);
                    postgresCondition = String.format("%s AND ((ue.json#>'{isBot}')::boolean) = TRUE ", postgresCondition);
                } else {
                    mySqlCondition = String.format("%s AND (JSON_EXTRACT(ue.json, '$.isBot') IS NULL OR JSON_EXTRACT(ue.json, '$.isBot') = FALSE ) ", mySqlCondition);
                    postgresCondition = String.format("%s AND (ue.json#>'{isBot}' IS NULL OR ((ue.json#>'{isBot}')::boolean) = FALSE) ", postgresCondition);
                }
            }
            if (team == null && isAdminStr == null && isBotStr == null) {
                return EntityDAO.super.listBefore(filter, limit, before);
            }
            return this.listBefore(this.getTableName(), mySqlCondition, postgresCondition, team, limit, before, Relationship.HAS.ordinal());
        }

        @Override
        default public List<String> listAfter(ListFilter filter, int limit, String after) {
            String team = EntityInterfaceUtil.quoteName((String)filter.getQueryParam("team"));
            String isBotStr = filter.getQueryParam("isBot");
            String isAdminStr = filter.getQueryParam("isAdmin");
            String mySqlCondition = filter.getCondition("ue");
            String postgresCondition = filter.getCondition("ue");
            if (isAdminStr != null) {
                boolean isAdmin = Boolean.parseBoolean(isAdminStr);
                if (isAdmin) {
                    mySqlCondition = String.format("%s AND JSON_EXTRACT(ue.json, '$.isAdmin') = TRUE ", mySqlCondition);
                    postgresCondition = String.format("%s AND ((ue.json#>'{isAdmin}')::boolean) = TRUE ", postgresCondition);
                } else {
                    mySqlCondition = String.format("%s AND (JSON_EXTRACT(ue.json, '$.isAdmin') IS NULL OR JSON_EXTRACT(ue.json, '$.isAdmin') = FALSE ) ", mySqlCondition);
                    postgresCondition = String.format("%s AND (ue.json#>'{isAdmin}' IS NULL OR ((ue.json#>'{isAdmin}')::boolean) = FALSE ) ", postgresCondition);
                }
            }
            if (isBotStr != null) {
                boolean isBot = Boolean.parseBoolean(isBotStr);
                if (isBot) {
                    mySqlCondition = String.format("%s AND JSON_EXTRACT(ue.json, '$.isBot') = TRUE ", mySqlCondition);
                    postgresCondition = String.format("%s AND ((ue.json#>'{isBot}')::boolean) = TRUE ", postgresCondition);
                } else {
                    mySqlCondition = String.format("%s AND (JSON_EXTRACT(ue.json, '$.isBot') IS NULL OR JSON_EXTRACT(ue.json, '$.isBot') = FALSE ) ", mySqlCondition);
                    postgresCondition = String.format("%s AND (ue.json#>'{isBot}' IS NULL OR ((ue.json#>'{isBot}')::boolean) = FALSE) ", postgresCondition);
                }
            }
            if (team == null && isAdminStr == null && isBotStr == null) {
                return EntityDAO.super.listAfter(filter, limit, after);
            }
            return this.listAfter(this.getTableName(), mySqlCondition, postgresCondition, team, limit, after, Relationship.HAS.ordinal());
        }

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT count(id) FROM (SELECT ue.id FROM user_entity ue LEFT JOIN entity_relationship er on ue.id = er.toId LEFT JOIN team_entity te on te.id = er.fromId and er.relation = :relation  <mysqlCond>  AND (:team IS NULL OR te.nameHash = :team) GROUP BY ue.id) subquery", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT count(id) FROM (SELECT ue.id FROM user_entity ue LEFT JOIN entity_relationship er on ue.id = er.toId LEFT JOIN team_entity te on te.id = er.fromId and er.relation = :relation  <postgresCond>  AND (:team IS NULL OR te.nameHash = :team) GROUP BY ue.id) subquery", connectionType=ConnectionType.POSTGRES)})
        public int listCount(@Define(value="table") String var1, @Define(value="mysqlCond") String var2, @Define(value="postgresCond") String var3, @BindFQN(value="team") String var4, @Bind(value="relation") int var5);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT json FROM (SELECT ue.name, ue.json FROM user_entity ue LEFT JOIN entity_relationship er on ue.id = er.toId LEFT JOIN team_entity te on te.id = er.fromId and er.relation = :relation  <mysqlCond> AND (:team IS NULL OR te.nameHash = :team) AND ue.name < :before GROUP BY ue.name, ue.json ORDER BY ue.name DESC LIMIT :limit) last_rows_subquery ORDER BY name", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT json FROM (SELECT ue.name, ue.json FROM user_entity ue LEFT JOIN entity_relationship er on ue.id = er.toId LEFT JOIN team_entity te on te.id = er.fromId and er.relation = :relation  <postgresCond> AND (:team IS NULL OR te.nameHash = :team) AND ue.name < :before GROUP BY ue.name, ue.json ORDER BY ue.name DESC LIMIT :limit) last_rows_subquery ORDER BY name", connectionType=ConnectionType.POSTGRES)})
        public List<String> listBefore(@Define(value="table") String var1, @Define(value="mysqlCond") String var2, @Define(value="postgresCond") String var3, @BindFQN(value="team") String var4, @Bind(value="limit") int var5, @Bind(value="before") String var6, @Bind(value="relation") int var7);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT ue.json FROM user_entity ue LEFT JOIN entity_relationship er on ue.id = er.toId LEFT JOIN team_entity te on te.id = er.fromId and er.relation = :relation  <mysqlCond> AND (:team IS NULL OR te.nameHash = :team) AND ue.name > :after GROUP BY ue.name, ue.json ORDER BY ue.name LIMIT :limit", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT ue.json FROM user_entity ue LEFT JOIN entity_relationship er on ue.id = er.toId LEFT JOIN team_entity te on te.id = er.fromId and er.relation = :relation  <postgresCond> AND (:team IS NULL OR te.nameHash = :team) AND ue.name > :after GROUP BY ue.name, ue.json ORDER BY ue.name LIMIT :limit", connectionType=ConnectionType.POSTGRES)})
        public List<String> listAfter(@Define(value="table") String var1, @Define(value="mysqlCond") String var2, @Define(value="postgresCond") String var3, @BindFQN(value="team") String var4, @Bind(value="limit") int var5, @Bind(value="after") String var6, @Bind(value="relation") int var7);

        @SqlQuery(value="SELECT COUNT(*) FROM user_entity WHERE LOWER(email) = LOWER(:email)")
        public int checkEmailExists(@Bind(value="email") String var1);

        @SqlQuery(value="SELECT json FROM user_entity WHERE LOWER(email) = LOWER(:email)")
        public String findUserByEmail(@Bind(value="email") String var1);

        @Override
        default public User findEntityByName(String fqn, Include include) {
            return (User)EntityDAO.super.findEntityByName(fqn.toLowerCase(), include);
        }
    }

    @RegisterRowMapper(value=UsageDetailsMapper.class)
    public static interface UsageDAO {
        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT INTO entity_usage (usageDate, id, entityType, count1, count7, count30) SELECT :date, :id, :entityType, :count1, (:count1 + (SELECT COALESCE(SUM(count1), 0) FROM entity_usage WHERE id = :id AND usageDate >= :date - INTERVAL 6 DAY)), (:count1 + (SELECT COALESCE(SUM(count1), 0) FROM entity_usage WHERE id = :id AND usageDate >= :date - INTERVAL 29 DAY))ON DUPLICATE KEY UPDATE count7 = count7 - count1 + :count1, count30 = count30 - count1 + :count1, count1 = :count1", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO entity_usage (usageDate, id, entityType, count1, count7, count30) SELECT (:date :: date), :id, :entityType, :count1, (:count1 + (SELECT COALESCE(SUM(count1), 0) FROM entity_usage WHERE id = :id AND usageDate >= (:date :: date) - INTERVAL '6 days')), (:count1 + (SELECT COALESCE(SUM(count1), 0) FROM entity_usage WHERE id = :id AND usageDate >= (:date :: date) - INTERVAL '29 days'))ON CONFLICT (usageDate, id) DO UPDATE SET count7 = entity_usage.count7 - entity_usage.count1 + :count1,count30 = entity_usage.count30 - entity_usage.count1 + :count1, count1 = :count1", connectionType=ConnectionType.POSTGRES)})
        public void insertOrReplaceCount(@Bind(value="date") String var1, @BindUUID(value="id") UUID var2, @Bind(value="entityType") String var3, @Bind(value="count1") int var4);

        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT INTO entity_usage (usageDate, id, entityType, count1, count7, count30) SELECT :date, :id, :entityType, :count1, (:count1 + (SELECT COALESCE(SUM(count1), 0) FROM entity_usage WHERE id = :id AND usageDate >= :date - INTERVAL 6 DAY)), (:count1 + (SELECT COALESCE(SUM(count1), 0) FROM entity_usage WHERE id = :id AND usageDate >= :date - INTERVAL 29 DAY)) ON DUPLICATE KEY UPDATE count1 = count1 + :count1, count7 = count7 + :count1, count30 = count30 + :count1", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO entity_usage (usageDate, id, entityType, count1, count7, count30) SELECT (:date :: date), :id, :entityType, :count1, (:count1 + (SELECT COALESCE(SUM(count1), 0) FROM entity_usage WHERE id = :id AND usageDate >= (:date :: date) - INTERVAL '6 days')), (:count1 + (SELECT COALESCE(SUM(count1), 0) FROM entity_usage WHERE id = :id AND usageDate >= (:date :: date) - INTERVAL '29 days')) ON CONFLICT (usageDate, id) DO UPDATE SET count1 = entity_usage.count1 + :count1, count7 = entity_usage.count7 + :count1, count30 = entity_usage.count30 + :count1", connectionType=ConnectionType.POSTGRES)})
        public void insertOrUpdateCount(@Bind(value="date") String var1, @BindUUID(value="id") UUID var2, @Bind(value="entityType") String var3, @Bind(value="count1") int var4);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT id, usageDate, entityType, count1, count7, count30, percentile1, percentile7, percentile30 FROM entity_usage WHERE id = :id AND usageDate >= :date - INTERVAL :days DAY AND usageDate <= :date ORDER BY usageDate DESC", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT id, usageDate, entityType, count1, count7, count30, percentile1, percentile7, percentile30 FROM entity_usage WHERE id = :id AND usageDate >= (:date :: date) - make_interval(days => :days) AND usageDate <= (:date :: date) ORDER BY usageDate DESC", connectionType=ConnectionType.POSTGRES)})
        public List<UsageDetails> getUsageById(@BindUUID(value="id") UUID var1, @Bind(value="date") String var2, @Bind(value="days") int var3);

        @SqlQuery(value="SELECT id, usageDate, entityType, count1, count7, count30, percentile1, percentile7, percentile30 FROM entity_usage WHERE usageDate IN (SELECT MAX(usageDate) FROM entity_usage WHERE id = :id) AND id = :id")
        public UsageDetails getLatestUsage(@Bind(value="id") String var1);

        @SqlUpdate(value="DELETE FROM entity_usage WHERE id = :id")
        public void delete(@BindUUID(value="id") UUID var1);

        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="UPDATE entity_usage u JOIN ( SELECT u1.id, (SELECT COUNT(*) FROM entity_usage as u2 WHERE u2.count1 <  u1.count1 AND u2.entityType = :entityType AND u2.usageDate = :date) as p1, (SELECT COUNT(*) FROM entity_usage as u3 WHERE u3.count7 <  u1.count7 AND u3.entityType = :entityType AND u3.usageDate = :date) as p7, (SELECT COUNT(*) FROM entity_usage as u4 WHERE u4.count30 <  u1.count30 AND u4.entityType = :entityType AND u4.usageDate = :date) as p30, (SELECT COUNT(*) FROM entity_usage WHERE entityType = :entityType AND usageDate = :date) as total FROM entity_usage u1 WHERE u1.entityType = :entityType AND u1.usageDate = :date) vals ON u.id = vals.id AND usageDate = :date SET u.percentile1 = ROUND(100 * p1/total, 2), u.percentile7 = ROUND(p7 * 100/total, 2), u.percentile30 = ROUND(p30*100/total, 2)", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="UPDATE entity_usage u SET percentile1 = ROUND(100 * p1 / total, 2), percentile7 = ROUND(p7 * 100 / total, 2), percentile30 = ROUND(p30 * 100 / total, 2) FROM (   SELECT u1.id,        (SELECT COUNT(*) FROM entity_usage as u2 WHERE u2.count1 < u1.count1 AND u2.entityType = :entityType AND u2.usageDate = (:date :: date)) as p1,        (SELECT COUNT(*) FROM entity_usage as u3 WHERE u3.count7 < u1.count7 AND u3.entityType = :entityType AND u3.usageDate = (:date :: date)) as p7,        (SELECT COUNT(*) FROM entity_usage as u4 WHERE u4.count30 < u1.count30 AND u4.entityType = :entityType AND u4.usageDate = (:date :: date)) as p30,        (SELECT COUNT(*) FROM entity_usage WHERE entityType = :entityType AND usageDate = (:date :: date)   ) as total FROM entity_usage u1    WHERE u1.entityType = :entityType AND u1.usageDate = (:date :: date)) vals WHERE u.id = vals.id AND usageDate = (:date :: date);", connectionType=ConnectionType.POSTGRES)})
        public void computePercentile(@Bind(value="entityType") String var1, @Bind(value="date") String var2);

        public static class UsageDetailsMapper
        implements RowMapper<UsageDetails> {
            public UsageDetails map(ResultSet r, StatementContext ctx) throws SQLException {
                UsageStats dailyStats = new UsageStats().withCount(Integer.valueOf(r.getInt("count1"))).withPercentileRank(Double.valueOf(r.getDouble("percentile1")));
                UsageStats weeklyStats = new UsageStats().withCount(Integer.valueOf(r.getInt("count7"))).withPercentileRank(Double.valueOf(r.getDouble("percentile7")));
                UsageStats monthlyStats = new UsageStats().withCount(Integer.valueOf(r.getInt("count30"))).withPercentileRank(Double.valueOf(r.getDouble("percentile30")));
                return new UsageDetails().withDate(r.getString("usageDate")).withDailyStats(dailyStats).withWeeklyStats(weeklyStats).withMonthlyStats(monthlyStats);
            }
        }
    }

    public static interface TopicDAO
    extends EntityDAO<Topic> {
        @Override
        default public String getTableName() {
            return "topic_entity";
        }

        @Override
        default public Class<Topic> getEntityClass() {
            return Topic.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }
    }

    public static interface TeamDAO
    extends EntityDAO<Team> {
        @Override
        default public String getTableName() {
            return "team_entity";
        }

        @Override
        default public Class<Team> getEntityClass() {
            return Team.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "nameHash";
        }

        @Override
        default public int listCount(ListFilter filter) {
            String parentTeam = filter.getQueryParam("parentTeam");
            String isJoinable = filter.getQueryParam("isJoinable");
            String condition = filter.getCondition();
            if (parentTeam != null) {
                Team team = (Team)this.findEntityByName(parentTeam, filter.getInclude());
                condition = "Organization".equals(team.getName()) ? String.format("%s AND id NOT IN ( (SELECT '%s') UNION (SELECT toId FROM entity_relationship WHERE fromId!='%s' AND fromEntity='team' AND toEntity='team' AND relation=%d) )", condition, team.getId(), team.getId(), Relationship.PARENT_OF.ordinal()) : String.format("%s AND id IN (SELECT toId FROM entity_relationship WHERE fromId='%s' AND fromEntity='team' AND toEntity='team' AND relation=%d)", condition, team.getId(), Relationship.PARENT_OF.ordinal());
            }
            String mySqlCondition = condition;
            String postgresCondition = condition;
            if (isJoinable != null) {
                mySqlCondition = String.format("%s AND JSON_EXTRACT(json, '$.isJoinable') = %s ", mySqlCondition, isJoinable);
                postgresCondition = String.format("%s AND ((json#>'{isJoinable}')::boolean)  = %s ", postgresCondition, isJoinable);
            }
            return this.listCount(this.getTableName(), this.getNameHashColumn(), mySqlCondition, postgresCondition);
        }

        @Override
        default public List<String> listBefore(ListFilter filter, int limit, String before) {
            String parentTeam = filter.getQueryParam("parentTeam");
            String isJoinable = filter.getQueryParam("isJoinable");
            String condition = filter.getCondition();
            if (parentTeam != null) {
                Team team = (Team)this.findEntityByName(parentTeam);
                condition = "Organization".equals(team.getName()) ? String.format("%s AND id NOT IN ( (SELECT '%s') UNION (SELECT toId FROM entity_relationship WHERE fromId!='%s' AND fromEntity='team' AND toEntity='team' AND relation=%d) )", condition, team.getId(), team.getId(), Relationship.PARENT_OF.ordinal()) : String.format("%s AND id IN (SELECT toId FROM entity_relationship WHERE fromId='%s' AND fromEntity='team' AND toEntity='team' AND relation=%d)", condition, team.getId(), Relationship.PARENT_OF.ordinal());
            }
            String mySqlCondition = condition;
            String postgresCondition = condition;
            if (isJoinable != null) {
                mySqlCondition = String.format("%s AND JSON_EXTRACT(json, '$.isJoinable') = %s ", mySqlCondition, isJoinable);
                postgresCondition = String.format("%s AND ((json#>'{isJoinable}')::boolean)  = %s ", postgresCondition, isJoinable);
            }
            before = FullyQualifiedName.unquoteName(before);
            return this.listBefore(this.getTableName(), mySqlCondition, postgresCondition, limit, before);
        }

        @Override
        default public List<String> listAfter(ListFilter filter, int limit, String after) {
            String parentTeam = filter.getQueryParam("parentTeam");
            String isJoinable = filter.getQueryParam("isJoinable");
            String condition = filter.getCondition();
            if (parentTeam != null) {
                Team team = (Team)this.findEntityByName(parentTeam, filter.getInclude());
                condition = "Organization".equals(team.getName()) ? String.format("%s AND id NOT IN ( (SELECT '%s') UNION (SELECT toId FROM entity_relationship WHERE fromId!='%s' AND fromEntity='team' AND toEntity='team' AND relation=%d) )", condition, team.getId(), team.getId(), Relationship.PARENT_OF.ordinal()) : String.format("%s AND id IN (SELECT toId FROM entity_relationship WHERE fromId='%s' AND fromEntity='team' AND toEntity='team' AND relation=%d)", condition, team.getId(), Relationship.PARENT_OF.ordinal());
            }
            String mySqlCondition = condition;
            String postgresCondition = condition;
            if (isJoinable != null) {
                mySqlCondition = String.format("%s AND JSON_EXTRACT(json, '$.isJoinable') = %s ", mySqlCondition, isJoinable);
                postgresCondition = String.format("%s AND ((json#>'{isJoinable}')::boolean)  = %s ", postgresCondition, isJoinable);
            }
            after = FullyQualifiedName.unquoteName(after);
            return this.listAfter(this.getTableName(), mySqlCondition, postgresCondition, limit, after);
        }

        default public List<String> listTeamsUnderOrganization(UUID teamId) {
            return this.listTeamsUnderOrganization(teamId, Relationship.PARENT_OF.ordinal());
        }

        @SqlQuery(value="SELECT te.id FROM team_entity te WHERE te.id NOT IN (SELECT :teamId) UNION (SELECT toId FROM entity_relationship WHERE fromId != :teamId AND fromEntity = 'team' AND relation = :relation AND toEntity = 'team')")
        public List<String> listTeamsUnderOrganization(@BindUUID(value="teamId") UUID var1, @Bind(value="relation") int var2);
    }

    public static interface PersonaDAO
    extends EntityDAO<Persona> {
        @Override
        default public String getTableName() {
            return "persona_entity";
        }

        @Override
        default public Class<Persona> getEntityClass() {
            return Persona.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "nameHash";
        }

        @Override
        default public boolean supportsSoftDelete() {
            return false;
        }
    }

    public static interface RoleDAO
    extends EntityDAO<Role> {
        @Override
        default public String getTableName() {
            return "role_entity";
        }

        @Override
        default public Class<Role> getEntityClass() {
            return Role.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "nameHash";
        }
    }

    @RegisterRowMapper(value=TagLabelMapper.class)
    public static interface TagUsageDAO {
        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT IGNORE INTO tag_usage (source, tagFQN, tagFQNHash, targetFQNHash, labelType, state) VALUES (:source, :tagFQN, :tagFQNHash, :targetFQNHash, :labelType, :state)", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO tag_usage (source, tagFQN, tagFQNHash, targetFQNHash, labelType, state) VALUES (:source, :tagFQN, :tagFQNHash, :targetFQNHash, :labelType, :state) ON CONFLICT (source, tagFQNHash, targetFQNHash) DO NOTHING", connectionType=ConnectionType.POSTGRES)})
        public void applyTag(@Bind(value="source") int var1, @Bind(value="tagFQN") String var2, @BindFQN(value="tagFQNHash") String var3, @BindFQN(value="targetFQNHash") String var4, @Bind(value="labelType") int var5, @Bind(value="state") int var6);

        default public List<TagLabel> getTags(String targetFQN) {
            List<TagLabel> tags = this.getTagsInternal(targetFQN);
            tags.forEach(TagLabelUtil::applyTagCommonFields);
            return tags;
        }

        default public Map<String, List<TagLabel>> getTagsByPrefix(String targetFQNPrefix, String postfix, boolean requiresFqnHash) {
            String fqnHash = requiresFqnHash ? FullyQualifiedName.buildHash(targetFQNPrefix) : targetFQNPrefix;
            LinkedHashMap<String, List<TagLabel>> resultSet = new LinkedHashMap<String, List<TagLabel>>();
            List<Pair<String, TagLabel>> tags = this.getTagsInternalByPrefix(fqnHash, postfix);
            tags.forEach(pair -> {
                String targetHash = (String)pair.getLeft();
                TagLabel tagLabel = (TagLabel)pair.getRight();
                List<TagLabel> listOfTarget = new ArrayList<TagLabel>();
                if (resultSet.containsKey(targetHash)) {
                    listOfTarget = (List)resultSet.get(targetHash);
                    listOfTarget.add(tagLabel);
                } else {
                    listOfTarget.add(tagLabel);
                }
                resultSet.put(targetHash, listOfTarget);
            });
            return resultSet;
        }

        @SqlQuery(value="SELECT source, tagFQN,  labelType, state FROM tag_usage WHERE targetFQNHash = :targetFQNHash ORDER BY tagFQN")
        public List<TagLabel> getTagsInternal(@BindFQN(value="targetFQNHash") String var1);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT source, tagFQN, labelType, targetFQNHash, state, json FROM (  SELECT gterm.* , tu.*   FROM glossary_term_entity AS gterm   JOIN tag_usage AS tu   ON gterm.fqnHash = tu.tagFQNHash   WHERE tu.source = 1   UNION ALL   SELECT ta.*, tu.*   FROM tag AS ta   JOIN tag_usage AS tu   ON ta.fqnHash = tu.tagFQNHash   WHERE tu.source = 0 ) AS combined_data WHERE combined_data.targetFQNHash  LIKE CONCAT(:targetFQNHashPrefix, :postfix)", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT source, tagFQN, labelType, targetFQNHash, state, json FROM (  SELECT gterm.*, tu.*   FROM glossary_term_entity AS gterm   JOIN tag_usage AS tu ON gterm.fqnHash = tu.tagFQNHash   WHERE tu.source = 1   UNION ALL   SELECT ta.*, tu.*   FROM tag AS ta   JOIN tag_usage AS tu ON ta.fqnHash = tu.tagFQNHash   WHERE tu.source = 0 ) AS combined_data WHERE combined_data.targetFQNHash LIKE CONCAT(:targetFQNHashPrefix, :postfix)", connectionType=ConnectionType.POSTGRES)})
        @RegisterRowMapper(value=TagLabelRowMapperWithTargetFqnHash.class)
        public List<Pair<String, TagLabel>> getTagsInternalByPrefix(@Bind(value="targetFQNHashPrefix") String var1, @Bind(value="postfix") String var2);

        @SqlQuery(value="SELECT * FROM tag_usage")
        @Deprecated(since="Release 1.1")
        @RegisterRowMapper(value=TagLabelMapperMigration.class)
        public List<TagLabelMigration> listAll();

        @SqlQuery(value="SELECT COUNT(*) FROM tag_usage WHERE (tagFQNHash LIKE CONCAT(:tagFqnHash, '.%') OR tagFQNHash = :tagFqnHash) AND source = :source")
        public int getTagCount(@Bind(value="source") int var1, @BindFQN(value="tagFqnHash") String var2);

        @SqlUpdate(value="DELETE FROM tag_usage where targetFQNHash = :targetFQNHash")
        public void deleteTagsByTarget(@BindFQN(value="targetFQNHash") String var1);

        @SqlUpdate(value="DELETE FROM tag_usage where tagFQNHash = :tagFqnHash AND targetFQNHash LIKE CONCAT(:targetFQNHash, '%')")
        public void deleteTagsByTagAndTargetEntity(@BindFQN(value="tagFqnHash") String var1, @BindFQN(value="targetFQNHash") String var2);

        @SqlUpdate(value="DELETE FROM tag_usage where tagFQNHash = :tagFQNHash AND source = :source")
        public void deleteTagLabels(@Bind(value="source") int var1, @BindFQN(value="tagFQNHash") String var2);

        @SqlUpdate(value="DELETE FROM tag_usage where tagFQNHash = :tagFQNHash")
        public void deleteTagLabelsByFqn(@BindFQN(value="tagFQNHash") String var1);

        @SqlUpdate(value="DELETE FROM tag_usage where targetFQNHash = :targetFQNHash OR targetFQNHash LIKE CONCAT(:targetFQNHash, '.%')")
        public void deleteTagLabelsByTargetPrefix(@BindFQN(value="targetFQNHash") String var1);

        @Deprecated(since="Release 1.1")
        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT INTO tag_usage (source, tagFQN, tagFQNHash, targetFQNHash, labelType, state, targetFQN)VALUES (:source, :tagFQN, :tagFQNHash, :targetFQNHash, :labelType, :state, :targetFQN) ON DUPLICATE KEY UPDATE tagFQNHash = :tagFQNHash, targetFQNHash = :targetFQNHash", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO tag_usage (source, tagFQN, tagFQNHash, targetFQNHash, labelType, state, targetFQN) VALUES (:source, :tagFQN, :tagFQNHash, :targetFQNHash, :labelType, :state, :targetFQN) ON CONFLICT (source, tagFQN, targetFQN) DO UPDATE SET tagFQNHash = EXCLUDED.tagFQNHash, targetFQNHash = EXCLUDED.targetFQNHash", connectionType=ConnectionType.POSTGRES)})
        public void upsertFQNHash(@Bind(value="source") int var1, @Bind(value="tagFQN") String var2, @Bind(value="tagFQNHash") String var3, @Bind(value="targetFQNHash") String var4, @Bind(value="labelType") int var5, @Bind(value="state") int var6, @Bind(value="targetFQN") String var7);

        default public void updateTagPrefix(int source, String oldPrefix, String newPrefix) {
            String update = String.format("UPDATE tag_usage SET tagFQN = REPLACE(tagFQN, '%s.', '%s.'), tagFQNHash = REPLACE(tagFQNHash, '%s.', '%s.') WHERE source = %s AND tagFQNHash LIKE '%s.%%'", ListFilter.escapeApostrophe(oldPrefix), ListFilter.escapeApostrophe(newPrefix), FullyQualifiedName.buildHash(oldPrefix), FullyQualifiedName.buildHash(newPrefix), source, FullyQualifiedName.buildHash(oldPrefix));
            this.updateTagPrefixInternal(update);
        }

        default public void updateTargetFQNHashPrefix(int source, String oldTargetFQNHashPrefix, String newTargetFQNHashPrefix) {
            String update = String.format("UPDATE tag_usage SET targetFQNHash = REPLACE(targetFQNHash, '%s.', '%s.') WHERE source = %s AND targetFQNHash LIKE '%s.%%'", FullyQualifiedName.buildHash(oldTargetFQNHashPrefix), FullyQualifiedName.buildHash(newTargetFQNHashPrefix), source, FullyQualifiedName.buildHash(oldTargetFQNHashPrefix));
            this.updateTagPrefixInternal(update);
        }

        default public void rename(int source, String oldFQN, String newFQN) {
            this.renameInternal(source, oldFQN, newFQN, newFQN);
            this.updateTagPrefix(source, oldFQN, newFQN);
        }

        default public void renameByTargetFQNHash(int source, String oldTargetFQNHash, String newTargetFQNHash) {
            this.renameByTargetFQNHashInternal(source, oldTargetFQNHash, newTargetFQNHash);
            this.updateTargetFQNHashPrefix(source, oldTargetFQNHash, newTargetFQNHash);
        }

        @SqlUpdate(value="Update tag_usage set tagFQN = :newFQN, tagFQNHash = :newFQNHash WHERE source = :source AND tagFQNHash = :oldFQNHash")
        public void renameInternal(@Bind(value="source") int var1, @BindFQN(value="oldFQNHash") String var2, @Bind(value="newFQN") String var3, @BindFQN(value="newFQNHash") String var4);

        @SqlUpdate(value="Update tag_usage set targetFQNHash = :newTargetFQNHash WHERE source = :source AND targetFQNHash = :oldTargetFQNHash")
        public void renameByTargetFQNHashInternal(@Bind(value="source") int var1, @BindFQN(value="oldTargetFQNHash") String var2, @BindFQN(value="newTargetFQNHash") String var3);

        @SqlUpdate(value="<update>")
        public void updateTagPrefixInternal(@Define(value="update") String var1);

        @SqlQuery(value="select targetFQNHash FROM tag_usage where tagFQNHash = :tagFQNHash")
        @RegisterRowMapper(value=TagLabelMapper.class)
        public List<String> getTargetFQNHashForTag(@BindFQN(value="tagFQNHash") String var1);

        @SqlQuery(value="select targetFQNHash FROM tag_usage where tagFQNHash LIKE CONCAT(:tagFQNHash, '.%')")
        @RegisterRowMapper(value=TagLabelMapper.class)
        public List<String> getTargetFQNHashForTagPrefix(@BindFQN(value="tagFQNHash") String var1);

        @Deprecated(since="Release 1.1")
        public static class TagLabelMapperMigration
        implements RowMapper<TagLabelMigration> {
            public TagLabelMigration map(ResultSet r, StatementContext ctx) throws SQLException {
                TagLabelMigration tagLabel = new TagLabelMigration();
                tagLabel.setSource(r.getInt("source"));
                tagLabel.setLabelType(r.getInt("labelType"));
                tagLabel.setState(r.getInt("state"));
                tagLabel.setTagFQN(r.getString("tagFQN"));
                try {
                    tagLabel.setTargetFQN(r.getString("targetFQN"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    tagLabel.setTagFQNHash(r.getString("tagFQNHash"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    tagLabel.setTargetFQNHash(r.getString("targetFQNHash"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return tagLabel;
            }
        }

        @Deprecated(since="Release 1.1")
        public static class TagLabelMigration {
            private int source;
            private String tagFQN;
            private String targetFQN;
            private int labelType;
            private int state;
            private String tagFQNHash;
            private String targetFQNHash;

            public int getSource() {
                return this.source;
            }

            public String getTagFQN() {
                return this.tagFQN;
            }

            public String getTargetFQN() {
                return this.targetFQN;
            }

            public int getLabelType() {
                return this.labelType;
            }

            public int getState() {
                return this.state;
            }

            public String getTagFQNHash() {
                return this.tagFQNHash;
            }

            public String getTargetFQNHash() {
                return this.targetFQNHash;
            }

            public void setSource(int source) {
                this.source = source;
            }

            public void setTagFQN(String tagFQN) {
                this.tagFQN = tagFQN;
            }

            public void setTargetFQN(String targetFQN) {
                this.targetFQN = targetFQN;
            }

            public void setLabelType(int labelType) {
                this.labelType = labelType;
            }

            public void setState(int state) {
                this.state = state;
            }

            public void setTagFQNHash(String tagFQNHash) {
                this.tagFQNHash = tagFQNHash;
            }

            public void setTargetFQNHash(String targetFQNHash) {
                this.targetFQNHash = targetFQNHash;
            }
        }

        public static class TagLabelRowMapperWithTargetFqnHash
        implements RowMapper<Pair<String, TagLabel>> {
            public Pair<String, TagLabel> map(ResultSet r, StatementContext ctx) throws SQLException {
                TagLabel label = new TagLabel().withSource(TagLabel.TagSource.values()[r.getInt("source")]).withLabelType(TagLabel.LabelType.values()[r.getInt("labelType")]).withState(TagLabel.State.values()[r.getInt("state")]).withTagFQN(r.getString("tagFQN"));
                TagLabel.TagSource source = TagLabel.TagSource.values()[r.getInt("source")];
                if (source == TagLabel.TagSource.CLASSIFICATION) {
                    Tag tag = JsonUtils.readValue(r.getString("json"), Tag.class);
                    label.setName(tag.getName());
                    label.setDisplayName(tag.getDisplayName());
                    label.setDescription(tag.getDescription());
                    label.setStyle(tag.getStyle());
                } else if (source == TagLabel.TagSource.GLOSSARY) {
                    GlossaryTerm glossaryTerm = JsonUtils.readValue(r.getString("json"), GlossaryTerm.class);
                    label.setName(glossaryTerm.getName());
                    label.setDisplayName(glossaryTerm.getDisplayName());
                    label.setDescription(glossaryTerm.getDescription());
                    label.setStyle(glossaryTerm.getStyle());
                } else {
                    throw new IllegalArgumentException("Invalid source type " + source);
                }
                return Pair.of((Object)r.getString("targetFQNHash"), (Object)label);
            }
        }

        public static class TagLabelMapper
        implements RowMapper<TagLabel> {
            public TagLabel map(ResultSet r, StatementContext ctx) throws SQLException {
                return new TagLabel().withSource(TagLabel.TagSource.values()[r.getInt("source")]).withLabelType(TagLabel.LabelType.values()[r.getInt("labelType")]).withState(TagLabel.State.values()[r.getInt("state")]).withTagFQN(r.getString("tagFQN"));
            }
        }
    }

    public static interface TagDAO
    extends EntityDAO<Tag> {
        @Override
        default public String getTableName() {
            return "tag";
        }

        @Override
        default public Class<Tag> getEntityClass() {
            return Tag.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }

        @Override
        default public int listCount(ListFilter filter) {
            String condition;
            boolean disabled = Boolean.parseBoolean(filter.getQueryParam("classification.disabled"));
            String mySqlCondition = condition = String.format("INNER JOIN entity_relationship er ON tag.id=er.toId AND er.relation=%s AND er.fromEntity='%s'  INNER JOIN classification c on er.fromId=c.id", Relationship.CONTAINS.ordinal(), "classification");
            String postgresCondition = condition;
            if (disabled) {
                mySqlCondition = String.format("%s AND (JSON_EXTRACT(c.json, '$.disabled') IS NULL OR JSON_EXTRACT(c.json, '$.disabled') = TRUE)", mySqlCondition);
                postgresCondition = String.format("%s AND ((c.json#>'{disabled}') IS NULL OR ((c.json#>'{disabled}')::boolean)  = TRUE)", postgresCondition);
            } else {
                mySqlCondition = String.format("%s AND (JSON_EXTRACT(c.json, '$.disabled') IS NULL OR JSON_EXTRACT(c.json, '$.disabled') = FALSE)", mySqlCondition);
                postgresCondition = String.format("%s AND ((c.json#>'{disabled}') IS NULL OR ((c.json#>'{disabled}')::boolean)  = FALSE)", postgresCondition);
            }
            mySqlCondition = String.format("%s %s", mySqlCondition, filter.getCondition("tag"));
            postgresCondition = String.format("%s %s", postgresCondition, filter.getCondition("tag"));
            return this.listCount(this.getTableName(), this.getNameHashColumn(), mySqlCondition, postgresCondition);
        }

        @Override
        default public List<String> listBefore(ListFilter filter, int limit, String before) {
            String condition;
            boolean disabled = Boolean.parseBoolean(filter.getQueryParam("classification.disabled"));
            String mySqlCondition = condition = String.format("INNER JOIN entity_relationship er ON tag.id=er.toId AND er.relation=%s AND er.fromEntity='%s'  INNER JOIN classification c on er.fromId=c.id", Relationship.CONTAINS.ordinal(), "classification");
            String postgresCondition = condition;
            if (disabled) {
                mySqlCondition = String.format("%s AND (JSON_EXTRACT(c.json, '$.disabled') IS NULL OR JSON_EXTRACT(c.json, '$.disabled') = TRUE)", mySqlCondition);
                postgresCondition = String.format("%s AND ((c.json#>'{disabled}') IS NULL OR ((c.json#>'{disabled}')::boolean) = TRUE)", postgresCondition);
            } else {
                mySqlCondition = String.format("%s AND (JSON_EXTRACT(c.json, '$.disabled') IS NULL OR JSON_EXTRACT(c.json, '$.disabled') = FALSE)", mySqlCondition);
                postgresCondition = String.format("%s AND ((c.json#>'{disabled}') IS NULL OR ((c.json#>'{disabled}')::boolean)  = FALSE)", postgresCondition);
            }
            mySqlCondition = String.format("%s %s", mySqlCondition, filter.getCondition("tag"));
            postgresCondition = String.format("%s %s", postgresCondition, filter.getCondition("tag"));
            return this.listBefore(this.getTableName(), mySqlCondition, postgresCondition, limit, before);
        }

        @Override
        default public List<String> listAfter(ListFilter filter, int limit, String after) {
            String condition;
            boolean disabled = Boolean.parseBoolean(filter.getQueryParam("classification.disabled"));
            String mySqlCondition = condition = String.format("INNER JOIN entity_relationship er ON tag.id=er.toId AND er.relation=%s AND er.fromEntity='%s'  INNER JOIN classification c on er.fromId=c.id", Relationship.CONTAINS.ordinal(), "classification");
            String postgresCondition = condition;
            if (disabled) {
                mySqlCondition = String.format("%s AND (JSON_EXTRACT(c.json, '$.disabled') IS NULL OR JSON_EXTRACT(c.json, '$.disabled') = TRUE)", mySqlCondition);
                postgresCondition = String.format("%s AND ((c.json#>'{disabled}') IS NULL OR ((c.json#>'{disabled}')::boolean) = TRUE)", postgresCondition);
            } else {
                mySqlCondition = String.format("%s AND (JSON_EXTRACT(c.json, '$.disabled') IS NULL OR JSON_EXTRACT(c.json, '$.disabled') = FALSE)", mySqlCondition);
                postgresCondition = String.format("%s AND ((c.json#>'{disabled}') IS NULL OR ((c.json#>'{disabled}')::boolean)  = FALSE)", postgresCondition);
            }
            mySqlCondition = String.format("%s %s", mySqlCondition, filter.getCondition("tag"));
            postgresCondition = String.format("%s %s", postgresCondition, filter.getCondition("tag"));
            return this.listAfter(this.getTableName(), mySqlCondition, postgresCondition, limit, after);
        }
    }

    public static interface ClassificationDAO
    extends EntityDAO<Classification> {
        @Override
        default public String getTableName() {
            return "classification";
        }

        @Override
        default public Class<Classification> getEntityClass() {
            return Classification.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "nameHash";
        }
    }

    public static interface PipelineDAO
    extends EntityDAO<Pipeline> {
        @Override
        default public String getTableName() {
            return "pipeline_entity";
        }

        @Override
        default public Class<Pipeline> getEntityClass() {
            return Pipeline.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }
    }

    public static interface QueryDAO
    extends EntityDAO<Query> {
        @Override
        default public String getTableName() {
            return "query_entity";
        }

        @Override
        default public Class<Query> getEntityClass() {
            return Query.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }

        @Override
        default public boolean supportsSoftDelete() {
            return false;
        }

        @Override
        default public int listCount(ListFilter filter) {
            String entityId = filter.getQueryParam("entityId");
            String condition = "INNER JOIN entity_relationship ON query_entity.id = entity_relationship.toId";
            HashMap<String, Object> bindMap = new HashMap<String, Object>();
            if (!CommonUtil.nullOrEmpty((String)entityId)) {
                condition = String.format("%s WHERE entity_relationship.fromId = :id and entity_relationship.relation = :relation and entity_relationship.toEntity = :toEntityType", condition);
                bindMap.put("id", entityId);
                bindMap.put("relation", Relationship.MENTIONED_IN.ordinal());
                bindMap.put("toEntityType", "query");
                return this.listQueryCount(condition, bindMap);
            }
            return EntityDAO.super.listCount(filter);
        }

        @Override
        default public List<String> listBefore(ListFilter filter, int limit, String before) {
            String entityId = filter.getQueryParam("entityId");
            String condition = "INNER JOIN entity_relationship ON query_entity.id = entity_relationship.toId";
            HashMap<String, Object> bindMap = new HashMap<String, Object>();
            if (!CommonUtil.nullOrEmpty((String)entityId)) {
                condition = String.format("%s WHERE entity_relationship.fromId = :entityId and entity_relationship.relation = :relation and entity_relationship.toEntity = :toEntity and query_entity.name < :before order by query_entity.name DESC LIMIT :limit", condition);
                bindMap.put("entityId", entityId);
                bindMap.put("relation", Relationship.MENTIONED_IN.ordinal());
                bindMap.put("toEntity", "query");
                bindMap.put("before", before);
                bindMap.put("limit", limit);
                return this.listBeforeQueriesByEntityId(condition, bindMap);
            }
            return EntityDAO.super.listBefore(filter, limit, before);
        }

        @Override
        default public List<String> listAfter(ListFilter filter, int limit, String after) {
            String entityId = filter.getQueryParam("entityId");
            String condition = "INNER JOIN entity_relationship ON query_entity.id = entity_relationship.toId";
            HashMap<String, Object> bindMap = new HashMap<String, Object>();
            if (!CommonUtil.nullOrEmpty((String)entityId)) {
                condition = String.format("%s WHERE entity_relationship.fromId = :entityId and entity_relationship.relation = :relation and entity_relationship.toEntity = :toEntity and query_entity.name > :after order by query_entity.name ASC LIMIT :limit", condition);
                bindMap.put("entityId", entityId);
                bindMap.put("relation", Relationship.MENTIONED_IN.ordinal());
                bindMap.put("toEntity", "query");
                bindMap.put("after", after);
                bindMap.put("limit", limit);
                return this.listAfterQueriesByEntityId(condition, bindMap);
            }
            return EntityDAO.super.listAfter(filter, limit, after);
        }

        @SqlQuery(value="SELECT query_entity.json FROM query_entity <cond>")
        public List<String> listAfterQueriesByEntityId(@Define(value="cond") String var1, @BindMap Map<String, Object> var2);

        @SqlQuery(value="SELECT json FROM (SELECT query_entity.name, query_entity.json FROM query_entity <cond>) last_rows_subquery ORDER BY name")
        public List<String> listBeforeQueriesByEntityId(@Define(value="cond") String var1, @BindMap Map<String, Object> var2);

        @SqlQuery(value="SELECT count(*) FROM query_entity <cond> ")
        public int listQueryCount(@Define(value="cond") String var1, @BindMap Map<String, Object> var2);
    }

    public static interface StoredProcedureDAO
    extends EntityDAO<StoredProcedure> {
        @Override
        default public String getTableName() {
            return "stored_procedure_entity";
        }

        @Override
        default public Class<StoredProcedure> getEntityClass() {
            return StoredProcedure.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }
    }

    public static interface TableDAO
    extends EntityDAO<Table> {
        @Override
        default public String getTableName() {
            return "table_entity";
        }

        @Override
        default public Class<Table> getEntityClass() {
            return Table.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }

        @Override
        default public int listCount(ListFilter filter) {
            String includeEmptyTestSuite = filter.getQueryParam("includeEmptyTestSuite");
            if (includeEmptyTestSuite != null && !Boolean.parseBoolean(includeEmptyTestSuite)) {
                String condition;
                String mySqlCondition = condition = String.format("INNER JOIN entity_relationship er ON %s.id=er.fromId AND er.relation=%s AND er.toEntity='%s'", this.getTableName(), Relationship.CONTAINS.ordinal(), "testSuite");
                String postgresCondition = condition;
                mySqlCondition = String.format("%s %s", mySqlCondition, filter.getCondition(this.getTableName()));
                postgresCondition = String.format("%s %s", postgresCondition, filter.getCondition(this.getTableName()));
                return this.listCount(this.getTableName(), this.getNameHashColumn(), mySqlCondition, postgresCondition);
            }
            String condition = filter.getCondition(this.getTableName());
            return this.listCount(this.getTableName(), this.getNameHashColumn(), condition, condition);
        }

        @Override
        default public List<String> listBefore(ListFilter filter, int limit, String before) {
            String includeEmptyTestSuite = filter.getQueryParam("includeEmptyTestSuite");
            if (includeEmptyTestSuite != null && !Boolean.parseBoolean(includeEmptyTestSuite)) {
                String condition;
                String mySqlCondition = condition = String.format("INNER JOIN entity_relationship er ON %s.id=er.fromId AND er.relation=%s AND er.toEntity='%s'", this.getTableName(), Relationship.CONTAINS.ordinal(), "testSuite");
                String postgresCondition = condition;
                mySqlCondition = String.format("%s %s", mySqlCondition, filter.getCondition(this.getTableName()));
                postgresCondition = String.format("%s %s", postgresCondition, filter.getCondition(this.getTableName()));
                return this.listBefore(this.getTableName(), mySqlCondition, postgresCondition, limit, before);
            }
            String condition = filter.getCondition(this.getTableName());
            return this.listBefore(this.getTableName(), condition, condition, limit, before);
        }

        @Override
        default public List<String> listAfter(ListFilter filter, int limit, String after) {
            String includeEmptyTestSuite = filter.getQueryParam("includeEmptyTestSuite");
            if (includeEmptyTestSuite != null && !Boolean.parseBoolean(includeEmptyTestSuite)) {
                String condition;
                String mySqlCondition = condition = String.format("INNER JOIN entity_relationship er ON %s.id=er.fromId AND er.relation=%s AND er.toEntity='%s'", this.getTableName(), Relationship.CONTAINS.ordinal(), "testSuite");
                String postgresCondition = condition;
                mySqlCondition = String.format("%s %s", mySqlCondition, filter.getCondition(this.getTableName()));
                postgresCondition = String.format("%s %s", postgresCondition, filter.getCondition(this.getTableName()));
                return this.listAfter(this.getTableName(), mySqlCondition, postgresCondition, limit, after);
            }
            String condition = filter.getCondition(this.getTableName());
            return this.listAfter(this.getTableName(), condition, condition, limit, after);
        }
    }

    public static interface ReportDAO
    extends EntityDAO<Report> {
        @Override
        default public String getTableName() {
            return "report_entity";
        }

        @Override
        default public Class<Report> getEntityClass() {
            return Report.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }
    }

    public static interface PolicyDAO
    extends EntityDAO<Policy> {
        @Override
        default public String getTableName() {
            return "policy_entity";
        }

        @Override
        default public Class<Policy> getEntityClass() {
            return Policy.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }
    }

    public static interface MlModelServiceDAO
    extends EntityDAO<MlModelService> {
        @Override
        default public String getTableName() {
            return "mlmodel_service_entity";
        }

        @Override
        default public Class<MlModelService> getEntityClass() {
            return MlModelService.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "nameHash";
        }
    }

    public static interface PipelineServiceDAO
    extends EntityDAO<PipelineService> {
        @Override
        default public String getTableName() {
            return "pipeline_service_entity";
        }

        @Override
        default public Class<PipelineService> getEntityClass() {
            return PipelineService.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "nameHash";
        }
    }

    public static interface IngestionPipelineDAO
    extends EntityDAO<IngestionPipeline> {
        @Override
        default public String getTableName() {
            return "ingestion_pipeline_entity";
        }

        @Override
        default public Class<IngestionPipeline> getEntityClass() {
            return IngestionPipeline.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }

        @Override
        default public int listCount(ListFilter filter) {
            Object condition = "INNER JOIN entity_relationship ON ingestion_pipeline_entity.id = entity_relationship.toId";
            if (filter.getQueryParam("pipelineType") != null) {
                String pipelineTypeCondition = String.format(" and %s", filter.getPipelineTypeCondition(null));
                condition = (String)condition + pipelineTypeCondition;
            }
            if (filter.getQueryParam("applicationType") != null) {
                String applicationTypeCondition = String.format(" and %s", filter.getApplicationTypeCondition());
                condition = (String)condition + applicationTypeCondition;
            }
            if (filter.getQueryParam("service") != null) {
                String serviceCondition = String.format(" and %s", filter.getServiceCondition(null));
                condition = (String)condition + serviceCondition;
            }
            HashMap<String, Object> bindMap = new HashMap<String, Object>();
            String serviceType = filter.getQueryParam("serviceType");
            if (!CommonUtil.nullOrEmpty((String)serviceType)) {
                condition = String.format("%s WHERE entity_relationship.fromEntity = :serviceType and entity_relationship.relation = :relation", condition);
                bindMap.put("relation", Relationship.CONTAINS.ordinal());
                bindMap.put("serviceType", serviceType);
                return this.listIngestionPipelineCount((String)condition, bindMap);
            }
            return EntityDAO.super.listCount(filter);
        }

        @Override
        default public List<String> listAfter(ListFilter filter, int limit, String after) {
            Object condition = "INNER JOIN entity_relationship ON ingestion_pipeline_entity.id = entity_relationship.toId";
            if (filter.getQueryParam("pipelineType") != null) {
                String pipelineTypeCondition = String.format(" and %s", filter.getPipelineTypeCondition(null));
                condition = (String)condition + pipelineTypeCondition;
            }
            if (filter.getQueryParam("applicationType") != null) {
                String applicationTypeCondition = String.format(" and %s", filter.getApplicationTypeCondition());
                condition = (String)condition + applicationTypeCondition;
            }
            if (filter.getQueryParam("service") != null) {
                String serviceCondition = String.format(" and %s", filter.getServiceCondition(null));
                condition = (String)condition + serviceCondition;
            }
            HashMap<String, Object> bindMap = new HashMap<String, Object>();
            String serviceType = filter.getQueryParam("serviceType");
            if (!CommonUtil.nullOrEmpty((String)serviceType)) {
                condition = String.format("%s WHERE entity_relationship.fromEntity = :serviceType and entity_relationship.relation = :relation and ingestion_pipeline_entity.name > :after order by ingestion_pipeline_entity.name ASC LIMIT :limit", condition);
                bindMap.put("serviceType", serviceType);
                bindMap.put("relation", Relationship.CONTAINS.ordinal());
                bindMap.put("after", after);
                bindMap.put("limit", limit);
                return this.listAfterIngestionPipelineByserviceType((String)condition, bindMap);
            }
            return EntityDAO.super.listAfter(filter, limit, after);
        }

        @Override
        default public List<String> listBefore(ListFilter filter, int limit, String before) {
            Object condition = "INNER JOIN entity_relationship ON ingestion_pipeline_entity.id = entity_relationship.toId";
            if (filter.getQueryParam("pipelineType") != null) {
                String pipelineTypeCondition = String.format(" and %s", filter.getPipelineTypeCondition(null));
                condition = (String)condition + pipelineTypeCondition;
            }
            if (filter.getQueryParam("applicationType") != null) {
                String applicationTypeCondition = String.format(" and %s", filter.getApplicationTypeCondition());
                condition = (String)condition + applicationTypeCondition;
            }
            if (filter.getQueryParam("service") != null) {
                String serviceCondition = String.format(" and %s", filter.getServiceCondition(null));
                condition = (String)condition + serviceCondition;
            }
            HashMap<String, Object> bindMap = new HashMap<String, Object>();
            String serviceType = filter.getQueryParam("serviceType");
            if (!CommonUtil.nullOrEmpty((String)serviceType)) {
                condition = String.format("%s WHERE entity_relationship.fromEntity = :serviceType and entity_relationship.relation = :relation and ingestion_pipeline_entity.name < :before order by ingestion_pipeline_entity.name DESC LIMIT :limit", condition);
                bindMap.put("serviceType", serviceType);
                bindMap.put("relation", Relationship.CONTAINS.ordinal());
                bindMap.put("before", before);
                bindMap.put("limit", limit);
                return this.listBeforeIngestionPipelineByserviceType((String)condition, bindMap);
            }
            return EntityDAO.super.listBefore(filter, limit, before);
        }

        @SqlQuery(value="SELECT ingestion_pipeline_entity.json FROM ingestion_pipeline_entity <cond>")
        public List<String> listAfterIngestionPipelineByserviceType(@Define(value="cond") String var1, @BindMap Map<String, Object> var2);

        @SqlQuery(value="SELECT json FROM (SELECT ingestion_pipeline_entity.name, ingestion_pipeline_entity.json FROM ingestion_pipeline_entity <cond>) last_rows_subquery ORDER BY last_rows_subquery.name")
        public List<String> listBeforeIngestionPipelineByserviceType(@Define(value="cond") String var1, @BindMap Map<String, Object> var2);

        @SqlQuery(value="SELECT count(*) FROM ingestion_pipeline_entity <cond> ")
        public int listIngestionPipelineCount(@Define(value="cond") String var1, @BindMap Map<String, Object> var2);
    }

    public static interface GlossaryTermDAO
    extends EntityDAO<GlossaryTerm> {
        @Override
        default public String getTableName() {
            return "glossary_term_entity";
        }

        @Override
        default public Class<GlossaryTerm> getEntityClass() {
            return GlossaryTerm.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }

        @Override
        default public int listCount(ListFilter filter) {
            String condition = filter.getCondition();
            String directChildrenOf = filter.getQueryParam("directChildrenOf");
            if (!CommonUtil.nullOrEmpty((String)directChildrenOf)) {
                condition = String.format(" %s AND fqnHash = CONCAT('%s', '.', MD5(CASE WHEN name LIKE '%%.%%' THEN CONCAT('\"', name, '\"') ELSE name END))  ", condition, FullyQualifiedName.buildHash(directChildrenOf));
            }
            return this.listCount(this.getTableName(), this.getNameHashColumn(), condition);
        }

        @Override
        default public List<String> listBefore(ListFilter filter, int limit, String before) {
            String condition = filter.getCondition();
            String directChildrenOf = filter.getQueryParam("directChildrenOf");
            if (!CommonUtil.nullOrEmpty((String)directChildrenOf)) {
                condition = String.format(" %s AND fqnHash = CONCAT('%s', '.', MD5(CASE WHEN name LIKE '%%.%%' THEN CONCAT('\"', name, '\"') ELSE name END))  ", condition, FullyQualifiedName.buildHash(directChildrenOf));
            }
            return this.listBefore(this.getTableName(), condition, limit, before);
        }

        @Override
        default public List<String> listAfter(ListFilter filter, int limit, String after) {
            String condition = filter.getCondition();
            String directChildrenOf = filter.getQueryParam("directChildrenOf");
            if (!CommonUtil.nullOrEmpty((String)directChildrenOf)) {
                condition = String.format(" %s AND fqnHash = CONCAT('%s', '.', MD5(CASE WHEN name LIKE '%%.%%' THEN CONCAT('\"', name, '\"') ELSE name END))  ", condition, FullyQualifiedName.buildHash(directChildrenOf));
            }
            return this.listAfter(this.getTableName(), condition, limit, after);
        }

        @SqlQuery(value="select fqnhash FROM glossary_term_entity where fqnhash LIKE CONCAT(:fqnhash, '.%')")
        public List<String> getNestedChildrenByFQN(@BindFQN(value="fqnhash") String var1);
    }

    public static interface GlossaryDAO
    extends EntityDAO<Glossary> {
        @Override
        default public String getTableName() {
            return "glossary_entity";
        }

        @Override
        default public Class<Glossary> getEntityClass() {
            return Glossary.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "nameHash";
        }
    }

    public static interface MlModelDAO
    extends EntityDAO<MlModel> {
        @Override
        default public String getTableName() {
            return "ml_model_entity";
        }

        @Override
        default public Class<MlModel> getEntityClass() {
            return MlModel.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }
    }

    public static interface MetricsDAO
    extends EntityDAO<Metrics> {
        @Override
        default public String getTableName() {
            return "metric_entity";
        }

        @Override
        default public Class<Metrics> getEntityClass() {
            return Metrics.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }
    }

    public static interface MessagingServiceDAO
    extends EntityDAO<MessagingService> {
        @Override
        default public String getTableName() {
            return "messaging_service_entity";
        }

        @Override
        default public Class<MessagingService> getEntityClass() {
            return MessagingService.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "nameHash";
        }
    }

    public static interface ApplicationMarketPlaceDAO
    extends EntityDAO<AppMarketPlaceDefinition> {
        @Override
        default public String getTableName() {
            return "apps_marketplace";
        }

        @Override
        default public Class<AppMarketPlaceDefinition> getEntityClass() {
            return AppMarketPlaceDefinition.class;
        }
    }

    public static interface ApplicationDAO
    extends EntityDAO<App> {
        @Override
        default public String getTableName() {
            return "installed_apps";
        }

        @Override
        default public Class<App> getEntityClass() {
            return App.class;
        }
    }

    public static interface ChartDAO
    extends EntityDAO<Chart> {
        @Override
        default public String getTableName() {
            return "chart_entity";
        }

        @Override
        default public Class<Chart> getEntityClass() {
            return Chart.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }
    }

    public static interface EventSubscriptionDAO
    extends EntityDAO<EventSubscription> {
        @Override
        default public String getTableName() {
            return "event_subscription_entity";
        }

        @Override
        default public Class<EventSubscription> getEntityClass() {
            return EventSubscription.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "nameHash";
        }

        @SqlQuery(value="SELECT json FROM event_subscription_entity")
        public List<String> listAllEventsSubscriptions();

        @Override
        default public boolean supportsSoftDelete() {
            return false;
        }

        @SqlQuery(value="SELECT json FROM change_event_consumers where id = :id AND extension = :extension")
        public String getSubscriberExtension(@Bind(value="id") String var1, @Bind(value="extension") String var2);

        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT INTO change_event_consumers(id, extension, jsonSchema, json) VALUES (:id, :extension, :jsonSchema, :json)ON DUPLICATE KEY UPDATE json = :json, jsonSchema = :jsonSchema", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO change_event_consumers(id, extension, jsonSchema, json) VALUES (:id, :extension, :jsonSchema, (:json :: jsonb)) ON CONFLICT (id, extension) DO UPDATE SET json = EXCLUDED.json, jsonSchema = EXCLUDED.jsonSchema", connectionType=ConnectionType.POSTGRES)})
        public void upsertSubscriberExtension(@Bind(value="id") String var1, @Bind(value="extension") String var2, @Bind(value="jsonSchema") String var3, @Bind(value="json") String var4);

        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT INTO consumers_dlq(id, extension, json) VALUES (:id, :extension, :json)ON DUPLICATE KEY UPDATE json = :json", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO consumers_dlq(id, extension, json) VALUES (:id, :extension, (:json :: jsonb)) ON CONFLICT (id, extension) DO UPDATE SET json = EXCLUDED.json", connectionType=ConnectionType.POSTGRES)})
        public void upsertFailedEvent(@Bind(value="id") String var1, @Bind(value="extension") String var2, @Bind(value="json") String var3);
    }

    public static interface DataProductDAO
    extends EntityDAO<DataProduct> {
        @Override
        default public String getTableName() {
            return "data_product_entity";
        }

        @Override
        default public Class<DataProduct> getEntityClass() {
            return DataProduct.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }

        @Override
        default public boolean supportsSoftDelete() {
            return false;
        }
    }

    public static interface DomainDAO
    extends EntityDAO<Domain> {
        @Override
        default public String getTableName() {
            return "domain_entity";
        }

        @Override
        default public Class<Domain> getEntityClass() {
            return Domain.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }

        @Override
        default public boolean supportsSoftDelete() {
            return false;
        }
    }

    public static interface BotDAO
    extends EntityDAO<Bot> {
        @Override
        default public String getTableName() {
            return "bot_entity";
        }

        @Override
        default public Class<Bot> getEntityClass() {
            return Bot.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "nameHash";
        }
    }

    public static interface FieldRelationshipDAO {
        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT IGNORE INTO field_relationship(fromFQNHash, toFQNHash, fromFQN, toFQN, fromType, toType, relation, json) VALUES (:fromFQNHash, :toFQNHash, :fromFQN, :toFQN, :fromType, :toType, :relation, :json)", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO field_relationship(fromFQNHash, toFQNHash, fromFQN, toFQN, fromType, toType, relation, json) VALUES (:fromFQNHash, :toFQNHash, :fromFQN, :toFQN, :fromType, :toType, :relation, (:json :: jsonb)) ON CONFLICT (fromFQNHash, toFQNHash, relation) DO NOTHING", connectionType=ConnectionType.POSTGRES)})
        public void insert(@BindFQN(value="fromFQNHash") String var1, @BindFQN(value="toFQNHash") String var2, @Bind(value="fromFQN") String var3, @Bind(value="toFQN") String var4, @Bind(value="fromType") String var5, @Bind(value="toType") String var6, @Bind(value="relation") int var7, @Bind(value="json") String var8);

        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT INTO field_relationship(fromFQNHash, toFQNHash, fromFQN, toFQN, fromType, toType, relation, jsonSchema, json) VALUES (:fromFQNHash, :toFQNHash, :fromFQN, :toFQN, :fromType, :toType, :relation, :jsonSchema, :json) ON DUPLICATE KEY UPDATE json = :json", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO field_relationship(fromFQNHash, toFQNHash, fromFQN, toFQN, fromType, toType, relation, jsonSchema, json) VALUES (:fromFQNHash, :toFQNHash, :fromFQN, :toFQN, :fromType, :toType, :relation, :jsonSchema, (:json :: jsonb)) ON CONFLICT (fromFQNHash, toFQNHash, relation) DO UPDATE SET json = EXCLUDED.json", connectionType=ConnectionType.POSTGRES)})
        public void upsert(@BindFQN(value="fromFQNHash") String var1, @BindFQN(value="toFQNHash") String var2, @Bind(value="fromFQN") String var3, @Bind(value="toFQN") String var4, @Bind(value="fromType") String var5, @Bind(value="toType") String var6, @Bind(value="relation") int var7, @Bind(value="jsonSchema") String var8, @Bind(value="json") String var9);

        @SqlQuery(value="SELECT json FROM field_relationship WHERE fromFQNHash = :fromFQNHash AND toFQNHash = :toFQNHash AND fromType = :fromType AND toType = :toType AND relation = :relation")
        public String find(@BindFQN(value="fromFQNHash") String var1, @BindFQN(value="toFQNHash") String var2, @Bind(value="fromType") String var3, @Bind(value="toType") String var4, @Bind(value="relation") int var5);

        @SqlQuery(value="SELECT fromFQN, fromType, json FROM field_relationship WHERE toFQNHash = :toFQNHash AND toType = :toType AND relation = :relation")
        @RegisterRowMapper(value=FromFieldMapper.class)
        public List<Triple<String, String, String>> findFrom(@BindFQN(value="toFQNHash") String var1, @Bind(value="toType") String var2, @Bind(value="relation") int var3);

        @SqlQuery(value="SELECT fromFQN, toFQN, json FROM field_relationship WHERE fromFQNHash LIKE CONCAT(:fqnPrefixHash, '%') AND fromType = :fromType AND toType = :toType AND relation = :relation")
        @RegisterRowMapper(value=ToFieldMapper.class)
        public List<Triple<String, String, String>> listToByPrefix(@BindFQN(value="fqnPrefixHash") String var1, @Bind(value="fromType") String var2, @Bind(value="toType") String var3, @Bind(value="relation") int var4);

        @Deprecated(since="Release 1.1")
        @SqlQuery(value="SELECT DISTINCT fromFQN, toFQN FROM field_relationship WHERE fromFQNHash = '' or fromFQNHash is null or toFQNHash = '' or toFQNHash is null LIMIT :limit")
        @RegisterRowMapper(value=FieldRelationShipMapper.class)
        public List<Pair<String, String>> migrationListDistinctWithOffset(@Bind(value="limit") int var1);

        @SqlQuery(value="SELECT fromFQN, toFQN, json FROM field_relationship WHERE fromFQNHash = :fqnHash AND fromType = :type AND toType = :otherType AND relation = :relation UNION SELECT toFQN, fromFQN, json FROM field_relationship WHERE toFQNHash = :fqnHash AND toType = :type AND fromType = :otherType AND relation = :relation")
        @RegisterRowMapper(value=ToFieldMapper.class)
        public List<Triple<String, String, String>> listBidirectional(@BindFQN(value="fqnHash") String var1, @Bind(value="type") String var2, @Bind(value="otherType") String var3, @Bind(value="relation") int var4);

        @SqlQuery(value="SELECT fromFQN, toFQN, json FROM field_relationship WHERE fromFQNHash LIKE CONCAT(:fqnPrefixHash, '%') AND fromType = :type AND toType = :otherType AND relation = :relation UNION SELECT toFQN, fromFQN, json FROM field_relationship WHERE toFQNHash LIKE CONCAT(:fqnPrefixHash, '%') AND toType = :type AND fromType = :otherType AND relation = :relation")
        @RegisterRowMapper(value=ToFieldMapper.class)
        public List<Triple<String, String, String>> listBidirectionalByPrefix(@BindFQN(value="fqnPrefixHash") String var1, @Bind(value="type") String var2, @Bind(value="otherType") String var3, @Bind(value="relation") int var4);

        default public void deleteAllByPrefix(String fqn) {
            String prefix = String.format("%s%s%%", FullyQualifiedName.buildHash(fqn), ".");
            String condition = "WHERE (toFQNHash LIKE :prefix OR fromFQNHash LIKE :prefix)";
            HashMap<String, String> bindMap = new HashMap<String, String>();
            bindMap.put("prefix", prefix);
            this.deleteAllByPrefixInternal(condition, bindMap);
        }

        @SqlUpdate(value="DELETE from field_relationship <cond>")
        public void deleteAllByPrefixInternal(@Define(value="cond") String var1, @BindMap Map<String, String> var2);

        @SqlUpdate(value="DELETE from field_relationship WHERE fromFQNHash = :fromFQNHash AND toFQNHash = :toFQNHash AND fromType = :fromType AND toType = :toType AND relation = :relation")
        public void delete(@BindFQN(value="fromFQNHash") String var1, @BindFQN(value="toFQNHash") String var2, @Bind(value="fromType") String var3, @Bind(value="toType") String var4, @Bind(value="relation") int var5);

        public static class FieldRelationship {
            private String fromFQNHash;
            private String toFQNHash;
            private String fromFQN;
            private String toFQN;
            private String fromType;
            private String toType;
            private int relation;
            private String jsonSchema;
            private String json;

            public String getFromFQNHash() {
                return this.fromFQNHash;
            }

            public String getToFQNHash() {
                return this.toFQNHash;
            }

            public String getFromFQN() {
                return this.fromFQN;
            }

            public String getToFQN() {
                return this.toFQN;
            }

            public String getFromType() {
                return this.fromType;
            }

            public String getToType() {
                return this.toType;
            }

            public int getRelation() {
                return this.relation;
            }

            public String getJsonSchema() {
                return this.jsonSchema;
            }

            public String getJson() {
                return this.json;
            }

            public void setFromFQNHash(String fromFQNHash) {
                this.fromFQNHash = fromFQNHash;
            }

            public void setToFQNHash(String toFQNHash) {
                this.toFQNHash = toFQNHash;
            }

            public void setFromFQN(String fromFQN) {
                this.fromFQN = fromFQN;
            }

            public void setToFQN(String toFQN) {
                this.toFQN = toFQN;
            }

            public void setFromType(String fromType) {
                this.fromType = fromType;
            }

            public void setToType(String toType) {
                this.toType = toType;
            }

            public void setRelation(int relation) {
                this.relation = relation;
            }

            public void setJsonSchema(String jsonSchema) {
                this.jsonSchema = jsonSchema;
            }

            public void setJson(String json) {
                this.json = json;
            }
        }

        public static class FieldRelationShipMapper
        implements RowMapper<Pair<String, String>> {
            public Pair<String, String> map(ResultSet rs, StatementContext ctx) throws SQLException {
                return Pair.of((Object)rs.getString("fromFQN"), (Object)rs.getString("toFQN"));
            }
        }

        public static class ToFieldMapper
        implements RowMapper<Triple<String, String, String>> {
            public Triple<String, String, String> map(ResultSet rs, StatementContext ctx) throws SQLException {
                return Triple.of((Object)rs.getString("fromFQN"), (Object)rs.getString("toFQN"), (Object)rs.getString("json"));
            }
        }

        public static class FromFieldMapper
        implements RowMapper<Triple<String, String, String>> {
            public Triple<String, String, String> map(ResultSet rs, StatementContext ctx) throws SQLException {
                return Triple.of((Object)rs.getString("fromFQN"), (Object)rs.getString("fromType"), (Object)rs.getString("json"));
            }
        }
    }

    public static interface FeedDAO {
        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT INTO thread_entity(json) VALUES (:json)", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO thread_entity(json) VALUES (:json :: jsonb)", connectionType=ConnectionType.POSTGRES)})
        public void insert(@Bind(value="json") String var1);

        @SqlQuery(value="SELECT json FROM thread_entity WHERE id = :id")
        public String findById(@BindUUID(value="id") UUID var1);

        @SqlQuery(value="SELECT json FROM thread_entity ORDER BY createdAt DESC")
        public List<String> list();

        @SqlQuery(value="SELECT count(id) FROM thread_entity <condition>")
        public int listCount(@Define(value="condition") String var1);

        @SqlUpdate(value="DELETE FROM thread_entity WHERE id = :id")
        public void delete(@BindUUID(value="id") UUID var1);

        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="UPDATE task_sequence SET id=LAST_INSERT_ID(id+1)", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="UPDATE task_sequence SET id=(id+1) RETURNING id", connectionType=ConnectionType.POSTGRES)})
        public void updateTaskId();

        @SqlQuery(value="SELECT id FROM task_sequence LIMIT 1")
        public int getTaskId();

        @SqlQuery(value="SELECT json FROM thread_entity WHERE taskId = :id")
        public String findByTaskId(@Bind(value="id") int var1);

        @SqlQuery(value="SELECT json FROM thread_entity <condition> ORDER BY createdAt DESC LIMIT :limit")
        public List<String> list(@Bind(value="limit") int var1, @Define(value="condition") String var2);

        @SqlQuery(value="SELECT json FROM thread_entity WHERE type='Announcement' AND (:threadId IS NULL OR id != :threadId) AND entityId = :entityId AND (( :startTs >= announcementStart AND :startTs < announcementEnd) OR (:endTs > announcementStart AND :endTs < announcementEnd) OR (:startTs <= announcementStart AND :endTs >= announcementEnd))")
        public List<String> listAnnouncementBetween(@BindUUID(value="threadId") UUID var1, @BindUUID(value="entityId") UUID var2, @Bind(value="startTs") long var3, @Bind(value="endTs") long var5);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT json FROM thread_entity <condition> AND taskAssignees @> ANY (ARRAY[<userTeamJsonPostgres>]::jsonb[]) ORDER BY createdAt DESC LIMIT :limit", connectionType=ConnectionType.POSTGRES), @ConnectionAwareSqlQuery(value="SELECT json FROM thread_entity <condition> AND JSON_OVERLAPS(json_extract(taskAssignees, '$[*].id'), :userTeamJsonMysql) ORDER BY createdAt DESC LIMIT :limit", connectionType=ConnectionType.MYSQL)})
        public List<String> listTasksAssigned(@BindList(value="userTeamJsonPostgres") List<String> var1, @Bind(value="userTeamJsonMysql") String var2, @Bind(value="limit") int var3, @Define(value="condition") String var4);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT count(id) FROM thread_entity <condition> AND taskAssignees @> ANY (ARRAY[<userTeamJsonPostgres>]::jsonb[])", connectionType=ConnectionType.POSTGRES), @ConnectionAwareSqlQuery(value="SELECT count(id) FROM thread_entity <condition> AND JSON_OVERLAPS(json_extract(taskAssignees, '$[*].id'), :userTeamJsonMysql) ", connectionType=ConnectionType.MYSQL)})
        public int listCountTasksAssignedTo(@BindList(value="userTeamJsonPostgres") List<String> var1, @Bind(value="userTeamJsonMysql") String var2, @Define(value="condition") String var3);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT json FROM thread_entity <condition> AND (taskAssignees @> ANY (ARRAY[<userTeamJsonPostgres>]::jsonb[]) OR createdBy = :username) ORDER BY createdAt DESC LIMIT :limit", connectionType=ConnectionType.POSTGRES), @ConnectionAwareSqlQuery(value="SELECT json FROM thread_entity <condition> AND (JSON_OVERLAPS(JSON_EXTRACT(taskAssignees, '$[*].id'), :userTeamJsonMysql) OR createdBy = :username) ORDER BY createdAt DESC LIMIT :limit", connectionType=ConnectionType.MYSQL)})
        public List<String> listTasksOfUser(@BindList(value="userTeamJsonPostgres") List<String> var1, @Bind(value="userTeamJsonMysql") String var2, @Bind(value="username") String var3, @Bind(value="limit") int var4, @Define(value="condition") String var5);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT count(id) FROM thread_entity <condition> AND (taskAssignees @> ANY (ARRAY[<userTeamJsonPostgres>]::jsonb[]) OR createdBy = :username) ", connectionType=ConnectionType.POSTGRES), @ConnectionAwareSqlQuery(value="SELECT count(id) FROM thread_entity <condition> AND (JSON_OVERLAPS(JSON_EXTRACT(taskAssignees, '$[*].id'), :userTeamJsonMysql) OR createdBy = :username) ", connectionType=ConnectionType.MYSQL)})
        public int listCountTasksOfUser(@BindList(value="userTeamJsonPostgres") List<String> var1, @Bind(value="userTeamJsonMysql") String var2, @Bind(value="username") String var3, @Define(value="condition") String var4);

        @SqlQuery(value="SELECT json FROM thread_entity <condition> AND createdBy = :username ORDER BY createdAt DESC LIMIT :limit")
        public List<String> listTasksAssigned(@Bind(value="username") String var1, @Bind(value="limit") int var2, @Define(value="condition") String var3);

        @SqlQuery(value="SELECT count(id) FROM thread_entity <condition> AND createdBy = :username")
        public int listCountTasksAssignedBy(@Bind(value="username") String var1, @Define(value="condition") String var2);

        @SqlQuery(value="SELECT json FROM thread_entity <condition> AND (entityId in (SELECT toId FROM entity_relationship WHERE ((fromEntity='user' AND fromId= :userId) OR (fromEntity='team' AND fromId IN (<teamIds>))) AND relation=8) OR id in (SELECT toId FROM entity_relationship WHERE (fromEntity='user' AND fromId= :userId AND toEntity='THREAD' AND relation IN (1,2)))) ORDER BY createdAt DESC LIMIT :limit")
        public List<String> listThreadsByOwner(@BindUUID(value="userId") UUID var1, @BindList(value="teamIds") List<String> var2, @Bind(value="limit") int var3, @Define(value="condition") String var4);

        @SqlQuery(value="SELECT count(id) FROM thread_entity <condition> AND (entityId in (SELECT toId FROM entity_relationship WHERE ((fromEntity='user' AND fromId= :userId) OR (fromEntity='team' AND fromId IN (<teamIds>))) AND relation=8) OR id in (SELECT toId FROM entity_relationship WHERE (fromEntity='user' AND fromId= :userId AND toEntity='THREAD' AND relation IN (1,2)))) ")
        public int listCountThreadsByOwner(@BindUUID(value="userId") UUID var1, @BindList(value="teamIds") List<String> var2, @Define(value="condition") String var3);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT json FROM thread_entity WHERE (json -> '$.task.testCaseResolutionStatusId') = :testCaseResolutionStatusId; ", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT json FROM thread_entity WHERE (json#>'{task}'->>'testCaseResolutionStatusId') = :testCaseResolutionStatusId; ", connectionType=ConnectionType.POSTGRES)})
        public String fetchThreadByTestCaseResolutionStatusId(@BindUUID(value="testCaseResolutionStatusId") UUID var1);

        default public List<String> listThreadsByEntityLink(FeedFilter filter, MessageParser.EntityLink entityLink, int limit, int relation, String userName, List<String> teamNames) {
            int filterRelation = -1;
            if (userName != null && filter.getFilterType() == FeedRepository.FilterType.MENTIONS) {
                filterRelation = Relationship.MENTIONED_IN.ordinal();
            }
            return this.listThreadsByEntityLink(entityLink.getFullyQualifiedFieldValue(), entityLink.getFullyQualifiedFieldType(), limit, relation, userName, teamNames, filterRelation, filter.getCondition());
        }

        @SqlQuery(value="SELECT json FROM thread_entity <condition> AND MD5(id) in (SELECT fromFQNHash FROM field_relationship WHERE (:fqnPrefixHash IS NULL OR toFQNHash LIKE CONCAT(:fqnPrefixHash, '.%') OR toFQNHash=:fqnPrefixHash) AND fromType='THREAD' AND (:toType IS NULL OR toType LIKE CONCAT(:toType, '.%') OR toType=:toType) AND relation= :relation) AND (:userName IS NULL OR MD5(id) in (SELECT toFQNHash FROM field_relationship WHERE  ((fromType='user' AND fromFQNHash= :userName) OR (fromType='team' AND fromFQNHash IN (<teamNames>))) AND toType='THREAD' AND relation= :filterRelation) )ORDER BY createdAt DESC LIMIT :limit")
        public List<String> listThreadsByEntityLink(@BindFQN(value="fqnPrefixHash") String var1, @Bind(value="toType") String var2, @Bind(value="limit") int var3, @Bind(value="relation") int var4, @BindFQN(value="userName") String var5, @BindList(value="teamNames") List<String> var6, @Bind(value="filterRelation") int var7, @Define(value="condition") String var8);

        default public int listCountThreadsByEntityLink(FeedFilter filter, MessageParser.EntityLink entityLink, int relation, String userName, List<String> teamNames) {
            int filterRelation = -1;
            if (userName != null && filter.getFilterType() == FeedRepository.FilterType.MENTIONS) {
                filterRelation = Relationship.MENTIONED_IN.ordinal();
            }
            return this.listCountThreadsByEntityLink(entityLink.getFullyQualifiedFieldValue(), entityLink.getFullyQualifiedFieldType(), relation, userName, teamNames, filterRelation, filter.getCondition(false));
        }

        @SqlQuery(value="SELECT count(id) FROM thread_entity <condition> AND MD5(id) in (SELECT fromFQNHash FROM field_relationship WHERE (:fqnPrefixHash IS NULL OR toFQNHash LIKE CONCAT(:fqnPrefixHash, '.%') OR toFQNHash=:fqnPrefixHash) AND fromType='THREAD' AND (:toType IS NULL OR toType LIKE CONCAT(:toType, '.%') OR toType=:toType) AND relation= :relation) AND (:userName IS NULL OR id in (SELECT toFQNHash FROM field_relationship WHERE  ((fromType='user' AND fromFQNHash= :userName) OR (fromType='team' AND fromFQNHash IN (<teamNames>))) AND toType='THREAD' AND relation= :filterRelation) )")
        public int listCountThreadsByEntityLink(@BindFQN(value="fqnPrefixHash") String var1, @Bind(value="toType") String var2, @Bind(value="relation") int var3, @Bind(value="userName") String var4, @BindList(value="teamNames") List<String> var5, @Bind(value="filterRelation") int var6, @Define(value="condition") String var7);

        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="UPDATE thread_entity SET json = :json where id = :id", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="UPDATE thread_entity SET json = (:json :: jsonb) where id = :id", connectionType=ConnectionType.POSTGRES)})
        public void update(@BindUUID(value="id") UUID var1, @Bind(value="json") String var2);

        @SqlQuery(value="SELECT te.entityLink, te.type, te.taskStatus, COUNT(id) count FROM thread_entity te  where entityId = :entityId  OR  MD5(id) in (SELECT fromFQNHash FROM field_relationship WHERE (:fqnPrefixHash IS NULL OR toFQNHash LIKE CONCAT(:fqnPrefixHash, '.%') OR toFQNHash=:fqnPrefixHash) AND fromType='THREAD' AND (:toType IS NULL OR toType LIKE CONCAT(:toType, '.%') OR toType=:toType) AND relation= 3) GROUP BY te.type, te.taskStatus, entityLink")
        @RegisterRowMapper(value=ThreadCountFieldMapper.class)
        public List<List<String>> listCountByEntityLink(@BindUUID(value="entityId") UUID var1, @BindFQN(value="fqnPrefixHash") String var2, @Bind(value="toType") String var3);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT te.type, te.taskStatus, COUNT(id) count FROM thread_entity te where (entityId in (SELECT toId FROM entity_relationship WHERE ((fromEntity='user' AND fromId= :userId) OR (fromEntity='team' AND fromId IN (<teamIds>))) AND relation=8) OR id in (SELECT toId FROM entity_relationship WHERE (fromEntity='user' AND fromId= :userId AND toEntity='THREAD' AND relation IN (1,2)))  OR id in (SELECT toId FROM entity_relationship WHERE ((fromEntity='user' AND fromId= :userId) OR (fromEntity='team' AND fromId IN (<teamIds>))) AND relation=11))  OR (taskAssignees @> ANY (ARRAY[<userTeamJsonPostgres>]::jsonb[]) OR createdBy = :username)GROUP BY te.type, te.taskStatus", connectionType=ConnectionType.POSTGRES), @ConnectionAwareSqlQuery(value="SELECT te.type, te.taskStatus, COUNT(id) count FROM thread_entity te where (entityId in (SELECT toId FROM entity_relationship WHERE ((fromEntity='user' AND fromId= :userId) OR (fromEntity='team' AND fromId IN (<teamIds>))) AND relation=8) OR id in (SELECT toId FROM entity_relationship WHERE (fromEntity='user' AND fromId= :userId AND toEntity='THREAD' AND relation IN (1,2)))  OR id in (SELECT toId FROM entity_relationship WHERE ((fromEntity='user' AND fromId= :userId) OR (fromEntity='team' AND fromId IN (<teamIds>))) AND relation=11)) OR (JSON_OVERLAPS(JSON_EXTRACT(taskAssignees, '$[*].id'), :userTeamJsonMysql) OR createdBy = :username) GROUP BY te.type, te.taskStatus", connectionType=ConnectionType.MYSQL)})
        @RegisterRowMapper(value=OwnerCountFieldMapper.class)
        public List<List<String>> listCountByOwner(@BindUUID(value="userId") UUID var1, @BindList(value="teamIds") List<String> var2, @Bind(value="username") String var3, @Bind(value="userTeamJsonMysql") String var4, @BindList(value="userTeamJsonPostgres") List<String> var5);

        @SqlQuery(value="SELECT json FROM thread_entity <condition> AND entityId in (SELECT toId FROM entity_relationship WHERE ((fromEntity='user' AND fromId= :userId) OR (fromEntity='team' AND fromId IN (<teamIds>))) AND relation= :relation) ORDER BY createdAt DESC LIMIT :limit")
        public List<String> listThreadsByFollows(@BindUUID(value="userId") UUID var1, @BindList(value="teamIds") List<String> var2, @Bind(value="limit") int var3, @Bind(value="relation") int var4, @Define(value="condition") String var5);

        @SqlQuery(value="SELECT count(id) FROM thread_entity <condition> AND entityId in (SELECT toId FROM entity_relationship WHERE ((fromEntity='user' AND fromId= :userId) OR (fromEntity='team' AND fromId IN (<teamIds>))) AND relation= :relation)")
        public int listCountThreadsByFollows(@BindUUID(value="userId") UUID var1, @BindList(value="teamIds") List<String> var2, @Bind(value="relation") int var3, @Define(value="condition") String var4);

        @SqlQuery(value="SELECT json FROM thread_entity <condition> AND (entityId in (SELECT toId FROM entity_relationship WHERE ((fromEntity='user' AND fromId= :userId) OR (fromEntity='team' AND fromId IN (<teamIds>))) AND relation=8) OR id in (SELECT toId FROM entity_relationship WHERE (fromEntity='user' AND fromId= :userId AND toEntity='THREAD' AND relation IN (1,2)))  OR id in (SELECT toId FROM entity_relationship WHERE ((fromEntity='user' AND fromId= :userId) OR (fromEntity='team' AND fromId IN (<teamIds>))) AND relation=11)) ORDER BY createdAt DESC LIMIT :limit")
        public List<String> listThreadsByOwnerOrFollows(@BindUUID(value="userId") UUID var1, @BindList(value="teamIds") List<String> var2, @Bind(value="limit") int var3, @Define(value="condition") String var4);

        @SqlQuery(value="SELECT count(id) FROM thread_entity <condition> AND (entityId in (SELECT toId FROM entity_relationship WHERE ((fromEntity='user' AND fromId= :userId) OR (fromEntity='team' AND fromId IN (<teamIds>))) AND relation=8) OR id in (SELECT toId FROM entity_relationship WHERE (fromEntity='user' AND fromId= :userId AND toEntity='THREAD' AND relation IN (1,2)))  OR id in (SELECT toId FROM entity_relationship WHERE ((fromEntity='user' AND fromId= :userId) OR (fromEntity='team' AND fromId IN (<teamIds>))) AND relation=11))")
        public int listCountThreadsByOwnerOrFollows(@BindUUID(value="userId") UUID var1, @BindList(value="teamIds") List<String> var2, @Define(value="condition") String var3);

        @SqlQuery(value="SELECT json FROM thread_entity <condition> AND MD5(id) in (SELECT toFQNHash FROM field_relationship WHERE ((fromType='user' AND fromFQNHash= :userName) OR (fromType='team' AND fromFQNHash IN (<teamNames>)))  AND toType='THREAD' AND relation= :relation) ORDER BY createdAt DESC LIMIT :limit")
        public List<String> listThreadsByMentions(@Bind(value="userName") String var1, @BindList(value="teamNames") List<String> var2, @Bind(value="limit") int var3, @Bind(value="relation") int var4, @Define(value="condition") String var5);

        @SqlQuery(value="SELECT count(id) FROM thread_entity <condition> AND MD5(id) in (SELECT toFQNHash FROM field_relationship WHERE ((fromType='user' AND fromFQNHash= :userName) OR (fromType='team' AND fromFQNHash IN (<teamNames>)))  AND toType='THREAD' AND relation= :relation) ")
        public int listCountThreadsByMentions(@Bind(value="userName") String var1, @BindList(value="teamNames") List<String> var2, @Bind(value="relation") int var3, @Define(value="condition") String var4);

        @SqlQuery(value="select id from thread_entity where entityId = :entityId")
        public List<String> findByEntityId(@Bind(value="entityId") String var1);

        public static class ThreadCountFieldMapper
        implements RowMapper<List<String>> {
            public List<String> map(ResultSet rs, StatementContext ctx) throws SQLException {
                return Arrays.asList(rs.getString("entityLink"), rs.getString("type"), rs.getString("taskStatus"), rs.getString("count"));
            }
        }

        public static class OwnerCountFieldMapper
        implements RowMapper<List<String>> {
            public List<String> map(ResultSet rs, StatementContext ctx) throws SQLException {
                return Arrays.asList(rs.getString("type"), rs.getString("taskStatus"), rs.getString("count"));
            }
        }
    }

    public static interface EntityRelationshipDAO {
        default public void insert(UUID fromId, UUID toId, String fromEntity, String toEntity, int relation) {
            this.insert(fromId, toId, fromEntity, toEntity, relation, null);
        }

        default public void bulkInsertToRelationship(UUID fromId, List<UUID> toIds, String fromEntity, String toEntity, int relation) {
            List<EntityRelationshipObject> insertToRelationship = toIds.stream().map(testCase -> EntityRelationshipObject.builder().fromId(fromId.toString()).toId(testCase.toString()).fromEntity(fromEntity).toEntity(toEntity).relation(relation).build()).collect(Collectors.toList());
            this.bulkInsertTo(insertToRelationship);
        }

        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT INTO entity_relationship(fromId, toId, fromEntity, toEntity, relation, json) VALUES (:fromId, :toId, :fromEntity, :toEntity, :relation, :json) ON DUPLICATE KEY UPDATE json = :json", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO entity_relationship(fromId, toId, fromEntity, toEntity, relation, json) VALUES (:fromId, :toId, :fromEntity, :toEntity, :relation, (:json :: jsonb)) ON CONFLICT (fromId, toId, relation) DO UPDATE SET json = EXCLUDED.json", connectionType=ConnectionType.POSTGRES)})
        public void insert(@BindUUID(value="fromId") UUID var1, @BindUUID(value="toId") UUID var2, @Bind(value="fromEntity") String var3, @Bind(value="toEntity") String var4, @Bind(value="relation") int var5, @Bind(value="json") String var6);

        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT IGNORE INTO entity_relationship(fromId, toId, fromEntity, toEntity, relation) VALUES <values>", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO entity_relationship(fromId, toId, fromEntity, toEntity, relation) VALUES <values>ON CONFLICT DO NOTHING", connectionType=ConnectionType.POSTGRES)})
        public void bulkInsertTo(@BindBeanList(value="values", propertyNames={"fromId", "toId", "fromEntity", "toEntity", "relation"}) List<EntityRelationshipObject> var1);

        @SqlQuery(value="SELECT toId, toEntity, json FROM entity_relationship WHERE fromId = :fromId AND fromEntity = :fromEntity AND relation IN (<relation>)")
        @RegisterRowMapper(value=ToRelationshipMapper.class)
        public List<EntityRelationshipRecord> findTo(@BindUUID(value="fromId") UUID var1, @Bind(value="fromEntity") String var2, @BindList(value="relation") List<Integer> var3);

        default public List<EntityRelationshipRecord> findTo(UUID fromId, String fromEntity, int relation) {
            return this.findTo(fromId, fromEntity, List.of(Integer.valueOf(relation)));
        }

        @SqlQuery(value="SELECT toId, toEntity, json FROM entity_relationship WHERE fromId = :fromId AND fromEntity = :fromEntity AND relation = :relation AND toEntity = :toEntity")
        @RegisterRowMapper(value=ToRelationshipMapper.class)
        public List<EntityRelationshipRecord> findTo(@BindUUID(value="fromId") UUID var1, @Bind(value="fromEntity") String var2, @Bind(value="relation") int var3, @Bind(value="toEntity") String var4);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT toId, toEntity, json FROM entity_relationship WHERE JSON_UNQUOTE(JSON_EXTRACT(json, '$.pipeline.id')) =:fromId OR fromId = :fromId AND relation = :relation ORDER BY toId", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT toId, toEntity, json FROM entity_relationship WHERE  json->'pipeline'->>'id' =:fromId OR fromId = :fromId AND relation = :relation ORDER BY toId", connectionType=ConnectionType.POSTGRES)})
        @RegisterRowMapper(value=ToRelationshipMapper.class)
        public List<EntityRelationshipRecord> findToPipeline(@BindUUID(value="fromId") UUID var1, @Bind(value="relation") int var2);

        @SqlQuery(value="SELECT fromId, fromEntity, json FROM entity_relationship WHERE toId = :toId AND toEntity = :toEntity AND relation = :relation AND fromEntity = :fromEntity ")
        @RegisterRowMapper(value=FromRelationshipMapper.class)
        public List<EntityRelationshipRecord> findFrom(@BindUUID(value="toId") UUID var1, @Bind(value="toEntity") String var2, @Bind(value="relation") int var3, @Bind(value="fromEntity") String var4);

        @SqlQuery(value="SELECT fromId, fromEntity, json FROM entity_relationship WHERE toId = :toId AND toEntity = :toEntity AND relation = :relation")
        @RegisterRowMapper(value=FromRelationshipMapper.class)
        public List<EntityRelationshipRecord> findFrom(@BindUUID(value="toId") UUID var1, @Bind(value="toEntity") String var2, @Bind(value="relation") int var3);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT fromId, fromEntity, json FROM entity_relationship WHERE JSON_UNQUOTE(JSON_EXTRACT(json, '$.pipeline.id')) = :toId OR toId = :toId AND relation = :relation ORDER BY fromId", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT fromId, fromEntity, json FROM entity_relationship WHERE  json->'pipeline'->>'id' = :toId OR toId = :toId AND relation = :relation ORDER BY fromId", connectionType=ConnectionType.POSTGRES)})
        @RegisterRowMapper(value=FromRelationshipMapper.class)
        public List<EntityRelationshipRecord> findFromPipeline(@BindUUID(value="toId") UUID var1, @Bind(value="relation") int var2);

        @SqlQuery(value="SELECT count(*) FROM entity_relationship WHERE fromEntity = :fromEntity AND toEntity = :toEntity")
        public int findIfAnyRelationExist(@Bind(value="fromEntity") String var1, @Bind(value="toEntity") String var2);

        @SqlQuery(value="SELECT json FROM entity_relationship WHERE fromId = :fromId  AND toId = :toId  AND relation = :relation ")
        public String getRelation(@BindUUID(value="fromId") UUID var1, @BindUUID(value="toId") UUID var2, @Bind(value="relation") int var3);

        @SqlUpdate(value="DELETE from entity_relationship WHERE fromId = :fromId AND fromEntity = :fromEntity AND toId = :toId AND toEntity = :toEntity AND relation = :relation")
        public int delete(@BindUUID(value="fromId") UUID var1, @Bind(value="fromEntity") String var2, @BindUUID(value="toId") UUID var3, @Bind(value="toEntity") String var4, @Bind(value="relation") int var5);

        @SqlUpdate(value="DELETE from entity_relationship WHERE fromId = :fromId AND fromEntity = :fromEntity AND relation = :relation AND toEntity = :toEntity")
        public void deleteFrom(@BindUUID(value="fromId") UUID var1, @Bind(value="fromEntity") String var2, @Bind(value="relation") int var3, @Bind(value="toEntity") String var4);

        @SqlUpdate(value="DELETE from entity_relationship WHERE toId = :toId AND toEntity = :toEntity AND relation = :relation AND fromEntity = :fromEntity")
        public void deleteTo(@BindUUID(value="toId") UUID var1, @Bind(value="toEntity") String var2, @Bind(value="relation") int var3, @Bind(value="fromEntity") String var4);

        @SqlUpdate(value="DELETE from entity_relationship WHERE (toId = :id AND toEntity = :entity) OR (fromId = :id AND fromEntity = :entity)")
        public void deleteAll(@BindUUID(value="id") UUID var1, @Bind(value="entity") String var2);

        @SqlUpdate(value="DELETE from entity_relationship WHERE fromId = :id or toId = :id")
        public void deleteAllWithId(@BindUUID(value="id") UUID var1);

        public static class ToRelationshipMapper
        implements RowMapper<EntityRelationshipRecord> {
            public EntityRelationshipRecord map(ResultSet rs, StatementContext ctx) throws SQLException {
                return EntityRelationshipRecord.builder().id(UUID.fromString(rs.getString("toId"))).type(rs.getString("toEntity")).json(rs.getString("json")).build();
            }
        }

        public static class FromRelationshipMapper
        implements RowMapper<EntityRelationshipRecord> {
            public EntityRelationshipRecord map(ResultSet rs, StatementContext ctx) throws SQLException {
                return EntityRelationshipRecord.builder().id(UUID.fromString(rs.getString("fromId"))).type(rs.getString("fromEntity")).json(rs.getString("json")).build();
            }
        }
    }

    public static class QueryList {
        private String fqn;
        private Query query;

        QueryList(String fqn, Query query) {
            this.fqn = fqn;
            this.query = query;
        }

        public static QueryListBuilder builder() {
            return new QueryListBuilder();
        }

        public String getFqn() {
            return this.fqn;
        }

        public Query getQuery() {
            return this.query;
        }

        public static class QueryListBuilder {
            private String fqn;
            private Query query;

            QueryListBuilder() {
            }

            public QueryListBuilder fqn(String fqn) {
                this.fqn = fqn;
                return this;
            }

            public QueryListBuilder query(Query query) {
                this.query = query;
                return this;
            }

            public QueryList build() {
                return new QueryList(this.fqn, this.query);
            }

            public String toString() {
                return "CollectionDAO.QueryList.QueryListBuilder(fqn=" + this.fqn + ", query=" + this.query + ")";
            }
        }
    }

    public static class ReportDataRow {
        private String rowNum;
        private ReportData reportData;

        ReportDataRow(String rowNum, ReportData reportData) {
            this.rowNum = rowNum;
            this.reportData = reportData;
        }

        public static ReportDataRowBuilder builder() {
            return new ReportDataRowBuilder();
        }

        public String getRowNum() {
            return this.rowNum;
        }

        public ReportData getReportData() {
            return this.reportData;
        }

        public static class ReportDataRowBuilder {
            private String rowNum;
            private ReportData reportData;

            ReportDataRowBuilder() {
            }

            public ReportDataRowBuilder rowNum(String rowNum) {
                this.rowNum = rowNum;
                return this;
            }

            public ReportDataRowBuilder reportData(ReportData reportData) {
                this.reportData = reportData;
                return this;
            }

            public ReportDataRow build() {
                return new ReportDataRow(this.rowNum, this.reportData);
            }

            public String toString() {
                return "CollectionDAO.ReportDataRow.ReportDataRowBuilder(rowNum=" + this.rowNum + ", reportData=" + this.reportData + ")";
            }
        }
    }

    public static class EntityRelationshipObject {
        private String fromId;
        private String toId;
        private String fromEntity;
        private String toEntity;
        private int relation;

        EntityRelationshipObject(String fromId, String toId, String fromEntity, String toEntity, int relation) {
            this.fromId = fromId;
            this.toId = toId;
            this.fromEntity = fromEntity;
            this.toEntity = toEntity;
            this.relation = relation;
        }

        public static EntityRelationshipObjectBuilder builder() {
            return new EntityRelationshipObjectBuilder();
        }

        public String getFromId() {
            return this.fromId;
        }

        public String getToId() {
            return this.toId;
        }

        public String getFromEntity() {
            return this.fromEntity;
        }

        public String getToEntity() {
            return this.toEntity;
        }

        public int getRelation() {
            return this.relation;
        }

        public static class EntityRelationshipObjectBuilder {
            private String fromId;
            private String toId;
            private String fromEntity;
            private String toEntity;
            private int relation;

            EntityRelationshipObjectBuilder() {
            }

            public EntityRelationshipObjectBuilder fromId(String fromId) {
                this.fromId = fromId;
                return this;
            }

            public EntityRelationshipObjectBuilder toId(String toId) {
                this.toId = toId;
                return this;
            }

            public EntityRelationshipObjectBuilder fromEntity(String fromEntity) {
                this.fromEntity = fromEntity;
                return this;
            }

            public EntityRelationshipObjectBuilder toEntity(String toEntity) {
                this.toEntity = toEntity;
                return this;
            }

            public EntityRelationshipObjectBuilder relation(int relation) {
                this.relation = relation;
                return this;
            }

            public EntityRelationshipObject build() {
                return new EntityRelationshipObject(this.fromId, this.toId, this.fromEntity, this.toEntity, this.relation);
            }

            public String toString() {
                return "CollectionDAO.EntityRelationshipObject.EntityRelationshipObjectBuilder(fromId=" + this.fromId + ", toId=" + this.toId + ", fromEntity=" + this.fromEntity + ", toEntity=" + this.toEntity + ", relation=" + this.relation + ")";
            }
        }
    }

    public static class EntityRelationshipRecord {
        private UUID id;
        private String type;
        private String json;

        EntityRelationshipRecord(UUID id, String type, String json) {
            this.id = id;
            this.type = type;
            this.json = json;
        }

        public static EntityRelationshipRecordBuilder builder() {
            return new EntityRelationshipRecordBuilder();
        }

        public UUID getId() {
            return this.id;
        }

        public String getType() {
            return this.type;
        }

        public String getJson() {
            return this.json;
        }

        public static class EntityRelationshipRecordBuilder {
            private UUID id;
            private String type;
            private String json;

            EntityRelationshipRecordBuilder() {
            }

            public EntityRelationshipRecordBuilder id(UUID id) {
                this.id = id;
                return this;
            }

            public EntityRelationshipRecordBuilder type(String type) {
                this.type = type;
                return this;
            }

            public EntityRelationshipRecordBuilder json(String json) {
                this.json = json;
                return this;
            }

            public EntityRelationshipRecord build() {
                return new EntityRelationshipRecord(this.id, this.type, this.json);
            }

            public String toString() {
                return "CollectionDAO.EntityRelationshipRecord.EntityRelationshipRecordBuilder(id=" + this.id + ", type=" + this.type + ", json=" + this.json + ")";
            }
        }
    }

    public static class ExtensionMapper
    implements RowMapper<ExtensionRecord> {
        public ExtensionRecord map(ResultSet rs, StatementContext ctx) throws SQLException {
            return new ExtensionRecord(rs.getString("extension"), rs.getString("json"));
        }
    }

    public record ExtensionRecord(String extensionName, String extensionJson) {
    }

    public static class EntityVersionPair {
        private final Double version;
        private final String entityJson;

        public EntityVersionPair(ExtensionRecord extensionRecord) {
            this.version = EntityUtil.getVersion(extensionRecord.extensionName());
            this.entityJson = extensionRecord.extensionJson();
        }

        public Double getVersion() {
            return this.version;
        }

        public String getEntityJson() {
            return this.entityJson;
        }
    }

    public static interface EntityExtensionDAO {
        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="REPLACE INTO entity_extension(id, extension, jsonSchema, json) VALUES (:id, :extension, :jsonSchema, :json)", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO entity_extension(id, extension, jsonSchema, json) VALUES (:id, :extension, :jsonSchema, (:json :: jsonb)) ON CONFLICT (id, extension) DO UPDATE SET jsonSchema = EXCLUDED.jsonSchema, json = EXCLUDED.json", connectionType=ConnectionType.POSTGRES)})
        public void insert(@BindUUID(value="id") UUID var1, @Bind(value="extension") String var2, @Bind(value="jsonSchema") String var3, @Bind(value="json") String var4);

        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="UPDATE entity_extension SET json = :json where (json -> '$.id') = :id", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="UPDATE entity_extension SET json = (:json :: jsonb) where (json ->> 'id) = :id", connectionType=ConnectionType.POSTGRES)})
        public void update(@BindUUID(value="id") UUID var1, @Bind(value="json") String var2);

        @SqlQuery(value="SELECT json FROM entity_extension WHERE id = :id AND extension = :extension")
        public String getExtension(@BindUUID(value="id") UUID var1, @Bind(value="extension") String var2);

        @RegisterRowMapper(value=ExtensionMapper.class)
        @SqlQuery(value="SELECT extension, json FROM entity_extension WHERE id = :id AND extension LIKE CONCAT (:extensionPrefix, '.%') ORDER BY extension")
        public List<ExtensionRecord> getExtensions(@BindUUID(value="id") UUID var1, @Bind(value="extensionPrefix") String var2);

        @SqlUpdate(value="DELETE FROM entity_extension WHERE id = :id AND extension = :extension")
        public void delete(@BindUUID(value="id") UUID var1, @Bind(value="extension") String var2);

        @SqlUpdate(value="DELETE FROM entity_extension WHERE extension = :extension")
        public void deleteExtension(@Bind(value="extension") String var1);

        @SqlUpdate(value="DELETE FROM entity_extension WHERE id = :id")
        public void deleteAll(@BindUUID(value="id") UUID var1);
    }

    public static interface SearchIndexDAO
    extends EntityDAO<SearchIndex> {
        @Override
        default public String getTableName() {
            return "search_index_entity";
        }

        @Override
        default public Class<SearchIndex> getEntityClass() {
            return SearchIndex.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }
    }

    public static interface SearchServiceDAO
    extends EntityDAO<SearchService> {
        @Override
        default public String getTableName() {
            return "search_service_entity";
        }

        @Override
        default public Class<SearchService> getEntityClass() {
            return SearchService.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "nameHash";
        }
    }

    public static interface ContainerDAO
    extends EntityDAO<Container> {
        @Override
        default public String getTableName() {
            return "storage_container_entity";
        }

        @Override
        default public Class<Container> getEntityClass() {
            return Container.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }

        @Override
        default public List<String> listBefore(ListFilter filter, int limit, String before) {
            boolean root = Boolean.parseBoolean(filter.getQueryParam("root"));
            String condition = filter.getCondition();
            if (!root) {
                return EntityDAO.super.listBefore(filter, limit, before);
            }
            String sqlCondition = String.format("%s AND er.toId is NULL", condition);
            return this.listBefore(this.getTableName(), sqlCondition, limit, before);
        }

        @Override
        default public List<String> listAfter(ListFilter filter, int limit, String after) {
            boolean root = Boolean.parseBoolean(filter.getQueryParam("root"));
            String condition = filter.getCondition();
            if (!root) {
                return EntityDAO.super.listAfter(filter, limit, after);
            }
            String sqlCondition = String.format("%s AND er.toId is NULL", condition);
            return this.listAfter(this.getTableName(), sqlCondition, limit, after);
        }

        @Override
        default public int listCount(ListFilter filter) {
            boolean root = Boolean.parseBoolean(filter.getQueryParam("root"));
            String condition = filter.getCondition();
            if (!root) {
                return EntityDAO.super.listCount(filter);
            }
            String sqlCondition = String.format("%s AND er.toId is NULL", condition);
            return this.listCount(this.getTableName(), this.getNameHashColumn(), sqlCondition);
        }

        @Override
        @SqlQuery(value="SELECT json FROM (SELECT name, ce.json FROM <table> ce LEFT JOIN (  SELECT toId FROM entity_relationship   WHERE fromEntity = 'container' AND toEntity = 'container' AND relation = 0 ) er on ce.id = er.toId <sqlCondition> AND name < :before ORDER BY name DESC LIMIT :limit) last_rows_subquery ORDER BY name")
        public List<String> listBefore(@Define(value="table") String var1, @Define(value="sqlCondition") String var2, @Bind(value="limit") int var3, @Bind(value="before") String var4);

        @Override
        @SqlQuery(value="SELECT ce.json FROM <table> ce LEFT JOIN (  SELECT toId FROM entity_relationship   WHERE fromEntity = 'container' AND toEntity = 'container' AND relation = 0 ) er on ce.id = er.toId <sqlCondition> AND name > :after ORDER BY name LIMIT :limit")
        public List<String> listAfter(@Define(value="table") String var1, @Define(value="sqlCondition") String var2, @Bind(value="limit") int var3, @Bind(value="after") String var4);

        @Override
        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT count(<nameHashColumn>) FROM <table> ce LEFT JOIN (  SELECT toId FROM entity_relationship   WHERE fromEntity = 'container' AND toEntity = 'container' AND relation = 0 ) er on ce.id = er.toId <sqlCondition>", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT count(*) FROM <table> ce LEFT JOIN (  SELECT toId FROM entity_relationship   WHERE fromEntity = 'container' AND toEntity = 'container' AND relation = 0 ) er on ce.id = er.toId <sqlCondition>", connectionType=ConnectionType.POSTGRES)})
        public int listCount(@Define(value="table") String var1, @Define(value="nameHashColumn") String var2, @Define(value="sqlCondition") String var3);
    }

    public static interface StorageServiceDAO
    extends EntityDAO<StorageService> {
        @Override
        default public String getTableName() {
            return "storage_service_entity";
        }

        @Override
        default public Class<StorageService> getEntityClass() {
            return StorageService.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "nameHash";
        }
    }

    public static interface TestConnectionDefinitionDAO
    extends EntityDAO<TestConnectionDefinition> {
        @Override
        default public String getTableName() {
            return "test_connection_definition";
        }

        @Override
        default public Class<TestConnectionDefinition> getEntityClass() {
            return TestConnectionDefinition.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "nameHash";
        }
    }

    public static interface MetadataServiceDAO
    extends EntityDAO<MetadataService> {
        @Override
        default public String getTableName() {
            return "metadata_service_entity";
        }

        @Override
        default public Class<MetadataService> getEntityClass() {
            return MetadataService.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "nameHash";
        }
    }

    public static interface DatabaseServiceDAO
    extends EntityDAO<DatabaseService> {
        @Override
        default public String getTableName() {
            return "dbservice_entity";
        }

        @Override
        default public Class<DatabaseService> getEntityClass() {
            return DatabaseService.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "nameHash";
        }
    }

    public static interface DatabaseSchemaDAO
    extends EntityDAO<DatabaseSchema> {
        @Override
        default public String getTableName() {
            return "database_schema_entity";
        }

        @Override
        default public Class<DatabaseSchema> getEntityClass() {
            return DatabaseSchema.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }
    }

    public static interface DatabaseDAO
    extends EntityDAO<Database> {
        @Override
        default public String getTableName() {
            return "database_entity";
        }

        @Override
        default public Class<Database> getEntityClass() {
            return Database.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }
    }

    public static interface DashboardServiceDAO
    extends EntityDAO<DashboardService> {
        @Override
        default public String getTableName() {
            return "dashboard_service_entity";
        }

        @Override
        default public String getNameHashColumn() {
            return "nameHash";
        }

        @Override
        default public Class<DashboardService> getEntityClass() {
            return DashboardService.class;
        }
    }

    public static interface DashboardDAO
    extends EntityDAO<Dashboard> {
        @Override
        default public String getTableName() {
            return "dashboard_entity";
        }

        @Override
        default public Class<Dashboard> getEntityClass() {
            return Dashboard.class;
        }

        @Override
        default public String getNameHashColumn() {
            return "fqnHash";
        }
    }
}

